/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf;

import com.alee.extended.button.WebSplitButtonUI;
import com.alee.extended.checkbox.WebTristateCheckBoxUI;
import com.alee.extended.label.WebMultiLineLabelUI;
import com.alee.extended.label.WebVerticalLabelUI;
import com.alee.laf.AltProcessor;
import com.alee.laf.StyleConstants;
import com.alee.laf.WebFonts;
import com.alee.laf.WebLayoutStyle;
import com.alee.laf.button.WebButtonUI;
import com.alee.laf.button.WebToggleButtonUI;
import com.alee.laf.checkbox.WebCheckBoxUI;
import com.alee.laf.colorchooser.WebColorChooserUI;
import com.alee.laf.combobox.WebComboBoxUI;
import com.alee.laf.desktoppane.WebDesktopIconUI;
import com.alee.laf.desktoppane.WebDesktopPaneUI;
import com.alee.laf.desktoppane.WebInternalFrameUI;
import com.alee.laf.filechooser.WebFileChooserUI;
import com.alee.laf.label.WebLabelUI;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.list.WebListStyle;
import com.alee.laf.list.WebListUI;
import com.alee.laf.menu.WebCheckBoxMenuItemUI;
import com.alee.laf.menu.WebMenuBarUI;
import com.alee.laf.menu.WebMenuItemUI;
import com.alee.laf.menu.WebMenuUI;
import com.alee.laf.menu.WebPopupMenuSeparatorUI;
import com.alee.laf.menu.WebPopupMenuUI;
import com.alee.laf.menu.WebRadioButtonMenuItemUI;
import com.alee.laf.optionpane.WebOptionPaneUI;
import com.alee.laf.panel.WebPanelUI;
import com.alee.laf.progressbar.WebProgressBarUI;
import com.alee.laf.radiobutton.WebRadioButtonUI;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.laf.scroll.WebScrollBarStyle;
import com.alee.laf.scroll.WebScrollBarUI;
import com.alee.laf.scroll.WebScrollPaneUI;
import com.alee.laf.separator.WebSeparatorUI;
import com.alee.laf.slider.WebSliderUI;
import com.alee.laf.spinner.WebSpinnerUI;
import com.alee.laf.splitpane.WebSplitPaneUI;
import com.alee.laf.tabbedpane.WebTabbedPaneUI;
import com.alee.laf.table.WebTableHeaderUI;
import com.alee.laf.table.WebTableStyle;
import com.alee.laf.table.WebTableUI;
import com.alee.laf.text.WebEditorPaneUI;
import com.alee.laf.text.WebFormattedTextFieldUI;
import com.alee.laf.text.WebPasswordFieldUI;
import com.alee.laf.text.WebTextAreaUI;
import com.alee.laf.text.WebTextFieldUI;
import com.alee.laf.text.WebTextPaneUI;
import com.alee.laf.toolbar.WebToolBarSeparatorUI;
import com.alee.laf.toolbar.WebToolBarUI;
import com.alee.laf.tooltip.WebToolTipUI;
import com.alee.laf.tree.WebTreeUI;
import com.alee.laf.viewport.WebViewportStyle;
import com.alee.laf.viewport.WebViewportUI;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.proxy.ProxyManager;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.style.StyleManager;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.version.VersionManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ColorUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.SwingLazyValue;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class WebLookAndFeel
extends BasicLookAndFeel {
    public static final String PROPERTY_HONOR_USER_BORDER = "WebLookAndFeel.honorUserBorder";
    public static final String PROPERTY_HONOR_USER_BORDERS = "WebLookAndFeel.honorUserBorders";
    public static final String LOOK_AND_FEEL_PROPERTY = "lookAndFeel";
    public static final String ORIENTATION_PROPERTY = "componentOrientation";
    public static final String MARGIN_PROPERTY = "margin";
    public static final String ENABLED_PROPERTY = "enabled";
    public static final String MODEL_PROPERTY = "model";
    public static final String TOOLBAR_FLOATABLE_PROPERTY = "floatable";
    public static final String WINDOW_DECORATION_STYLE_PROPERTY = "windowDecorationStyle";
    public static final String WINDOW_RESIZABLE_PROPERTY = "resizable";
    public static final String WINDOW_ICON_PROPERTY = "iconImage";
    public static final String WINDOW_TITLE_PROPERTY = "title";
    public static final String VISIBLE_PROPERTY = "visible";
    public static final String DOCUMENT_PROPERTY = "document";
    public static final String OPAQUE_PROPERTY = "opaque";
    public static final String PAINTER_PROPERTY = "painter";
    public static final String RENDERER_PROPERTY = "renderer";
    public static final String DROP_LOCATION = "dropLocation";
    private static List<ImageIcon> icons = null;
    private static final Map<Icon, ImageIcon> disabledIcons = new WeakHashMap<Icon, ImageIcon>(50);
    public static final AltProcessor altProcessor = new AltProcessor();
    private static boolean isMnemonicHidden = true;
    private static boolean decorateFrames = false;
    private static boolean decorateDialogs = false;
    public static String labelUI = WebLabelUI.class.getCanonicalName();
    public static String verticalLabelUI = WebVerticalLabelUI.class.getCanonicalName();
    public static String multiLineLabelUI = WebMultiLineLabelUI.class.getCanonicalName();
    public static String toolTipUI = WebToolTipUI.class.getCanonicalName();
    public static String buttonUI = WebButtonUI.class.getCanonicalName();
    public static String splitButtonUI = WebSplitButtonUI.class.getCanonicalName();
    public static String toggleButtonUI = WebToggleButtonUI.class.getCanonicalName();
    public static String checkBoxUI = WebCheckBoxUI.class.getCanonicalName();
    public static String tristateCheckBoxUI = WebTristateCheckBoxUI.class.getCanonicalName();
    public static String radioButtonUI = WebRadioButtonUI.class.getCanonicalName();
    public static String menuBarUI = WebMenuBarUI.class.getCanonicalName();
    public static String menuUI = WebMenuUI.class.getCanonicalName();
    public static String popupMenuUI = WebPopupMenuUI.class.getCanonicalName();
    public static String menuItemUI = WebMenuItemUI.class.getCanonicalName();
    public static String checkBoxMenuItemUI = WebCheckBoxMenuItemUI.class.getCanonicalName();
    public static String radioButtonMenuItemUI = WebRadioButtonMenuItemUI.class.getCanonicalName();
    public static String popupMenuSeparatorUI = WebPopupMenuSeparatorUI.class.getCanonicalName();
    public static String separatorUI = WebSeparatorUI.class.getCanonicalName();
    public static String scrollBarUI = WebScrollBarUI.class.getCanonicalName();
    public static String scrollPaneUI = WebScrollPaneUI.class.getCanonicalName();
    public static String viewportUI = WebViewportUI.class.getCanonicalName();
    public static String textFieldUI = WebTextFieldUI.class.getCanonicalName();
    public static String passwordFieldUI = WebPasswordFieldUI.class.getCanonicalName();
    public static String formattedTextFieldUI = WebFormattedTextFieldUI.class.getCanonicalName();
    public static String textAreaUI = WebTextAreaUI.class.getCanonicalName();
    public static String editorPaneUI = WebEditorPaneUI.class.getCanonicalName();
    public static String textPaneUI = WebTextPaneUI.class.getCanonicalName();
    public static String toolBarUI = WebToolBarUI.class.getCanonicalName();
    public static String toolBarSeparatorUI = WebToolBarSeparatorUI.class.getCanonicalName();
    public static String tableUI = WebTableUI.class.getCanonicalName();
    public static String tableHeaderUI = WebTableHeaderUI.class.getCanonicalName();
    public static String colorChooserUI = WebColorChooserUI.class.getCanonicalName();
    public static String fileChooserUI = WebFileChooserUI.class.getCanonicalName();
    public static String panelUI = WebPanelUI.class.getCanonicalName();
    public static String rootPaneUI = WebRootPaneUI.class.getCanonicalName();
    public static String tabbedPaneUI = WebTabbedPaneUI.class.getCanonicalName();
    public static String splitPaneUI = WebSplitPaneUI.class.getCanonicalName();
    public static String progressBarUI = WebProgressBarUI.class.getCanonicalName();
    public static String sliderUI = WebSliderUI.class.getCanonicalName();
    public static String spinnerUI = WebSpinnerUI.class.getCanonicalName();
    public static String treeUI = WebTreeUI.class.getCanonicalName();
    public static String listUI = WebListUI.class.getCanonicalName();
    public static String comboBoxUI = WebComboBoxUI.class.getCanonicalName();
    public static String desktopPaneUI = WebDesktopPaneUI.class.getCanonicalName();
    public static String desktopIconUI = WebDesktopIconUI.class.getCanonicalName();
    public static String internalFrameUI = WebInternalFrameUI.class.getCanonicalName();
    public static String optionPaneUI = WebOptionPaneUI.class.getCanonicalName();
    public static Font globalControlFont = WebFonts.getSystemControlFont();
    public static Font buttonFont;
    public static Font toggleButtonFont;
    public static Font radioButtonFont;
    public static Font checkBoxFont;
    public static Font colorChooserFont;
    public static Font labelFont;
    public static Font listFont;
    public static Font panelFont;
    public static Font progressBarFont;
    public static Font scrollPaneFont;
    public static Font viewportFont;
    public static Font sliderFont;
    public static Font tabbedPaneFont;
    public static Font tableFont;
    public static Font tableHeaderFont;
    public static Font titledBorderFont;
    public static Font toolBarFont;
    public static Font treeFont;
    public static Font globalTooltipFont;
    public static Font toolTipFont;
    public static Font globalAlertFont;
    public static Font optionPaneFont;
    public static Font globalMenuFont;
    public static Font menuBarFont;
    public static Font menuFont;
    public static Font menuItemFont;
    public static Font radioButtonMenuItemFont;
    public static Font checkBoxMenuItemFont;
    public static Font popupMenuFont;
    public static Font globalAcceleratorFont;
    public static Font menuItemAcceleratorFont;
    public static Font radioButtonMenuItemAcceleratorFont;
    public static Font checkBoxMenuItemAcceleratorFont;
    public static Font menuAcceleratorFont;
    public static Font globalTitleFont;
    public static Font internalFrameFont;
    public static Font globalTextFont;
    public static Font comboBoxFont;
    public static Font spinnerFont;
    public static Font textFieldFont;
    public static Font formattedTextFieldFont;
    public static Font passwordFieldFont;
    public static Font textAreaFont;
    public static Font textPaneFont;
    public static Font editorPaneFont;

    @Override
    public String getName() {
        return "WebLookAndFeel";
    }

    @Override
    public String getID() {
        return "WebLookAndFeel";
    }

    @Override
    public String getDescription() {
        return "Cross-platform stylish Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        table.put("LabelUI", labelUI);
        table.put("VerticalLabelUI", verticalLabelUI);
        table.put("MultiLineLabelUI", multiLineLabelUI);
        table.put("ToolTipUI", toolTipUI);
        table.put("ButtonUI", buttonUI);
        table.put("SplitButtonUI", splitButtonUI);
        table.put("ToggleButtonUI", toggleButtonUI);
        table.put("CheckBoxUI", checkBoxUI);
        table.put("TristateCheckBoxUI", tristateCheckBoxUI);
        table.put("RadioButtonUI", radioButtonUI);
        table.put("MenuBarUI", menuBarUI);
        table.put("MenuUI", menuUI);
        table.put("PopupMenuUI", popupMenuUI);
        table.put("MenuItemUI", menuItemUI);
        table.put("CheckBoxMenuItemUI", checkBoxMenuItemUI);
        table.put("RadioButtonMenuItemUI", radioButtonMenuItemUI);
        table.put("PopupMenuSeparatorUI", popupMenuSeparatorUI);
        table.put("SeparatorUI", separatorUI);
        table.put("ScrollBarUI", scrollBarUI);
        table.put("ScrollPaneUI", scrollPaneUI);
        table.put("ViewportUI", viewportUI);
        table.put("TextFieldUI", textFieldUI);
        table.put("PasswordFieldUI", passwordFieldUI);
        table.put("FormattedTextFieldUI", formattedTextFieldUI);
        table.put("TextAreaUI", textAreaUI);
        table.put("EditorPaneUI", editorPaneUI);
        table.put("TextPaneUI", textPaneUI);
        table.put("ToolBarUI", toolBarUI);
        table.put("ToolBarSeparatorUI", toolBarSeparatorUI);
        table.put("TableUI", tableUI);
        table.put("TableHeaderUI", tableHeaderUI);
        table.put("ColorChooserUI", colorChooserUI);
        table.put("FileChooserUI", fileChooserUI);
        table.put("PanelUI", panelUI);
        table.put("RootPaneUI", rootPaneUI);
        table.put("TabbedPaneUI", tabbedPaneUI);
        table.put("SplitPaneUI", splitPaneUI);
        table.put("ProgressBarUI", progressBarUI);
        table.put("SliderUI", sliderUI);
        table.put("SpinnerUI", spinnerUI);
        table.put("TreeUI", treeUI);
        table.put("ListUI", listUI);
        table.put("ComboBoxUI", comboBoxUI);
        table.put("DesktopPaneUI", desktopPaneUI);
        table.put("DesktopIconUI", desktopIconUI);
        table.put("InternalFrameUI", internalFrameUI);
        table.put("OptionPaneUI", optionPaneUI);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        String textColor = "#" + ColorUtils.getHexColor(StyleConstants.textColor);
        String[] defaultSystemColors = new String[]{"menu", "#ffffff", "menuText", textColor, "textHighlight", "#" + ColorUtils.getHexColor(StyleConstants.textSelectionColor), "textHighlightText", textColor, "textInactiveText", "#" + ColorUtils.getHexColor(StyleConstants.disabledTextColor), "controlText", textColor};
        this.loadSystemColors(table, defaultSystemColors, this.isNativeLookAndFeel());
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        ProprietaryUtils.setupUIDefaults(table);
        WebLookAndFeel.initializeFonts(table);
        Color controlText = table.getColor("controlText");
        table.put("Label.foreground", controlText);
        table.put("Label.disabledForeground", StyleConstants.disabledTextColor);
        SwingLazyValue textComponentBorder = new SwingLazyValue("javax.swing.plaf.BorderUIResource.LineBorderUIResource", new Object[]{StyleConstants.shadeColor});
        table.put("TextField.border", textComponentBorder);
        table.put("TextArea.border", textComponentBorder);
        table.put("EditorPane.border", textComponentBorder);
        table.put("TextPane.border", textComponentBorder);
        table.put("OptionPane.messageAreaBorder", new SwingLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{0, 0, 5, 0}));
        table.put("OptionPane.isYesLast", SystemUtils.isMac() ? Boolean.TRUE : Boolean.FALSE);
        table.put("html.pendingImage", StyleConstants.htmlPendingIcon);
        table.put("html.missingImage", StyleConstants.htmlMissingIcon);
        table.put("ScrollBar.minimumThumbSize", new Dimension(WebScrollBarStyle.minThumbWidth, WebScrollBarStyle.minThumbHeight));
        table.put("ScrollBar.width", new Integer(10));
        table.put("Tree.openIcon", WebTreeUI.OPEN_ICON);
        table.put("Tree.closedIcon", WebTreeUI.CLOSED_ICON);
        table.put("Tree.leafIcon", WebTreeUI.LEAF_ICON);
        table.put("Tree.collapsedIcon", WebTreeUI.EXPAND_ICON);
        table.put("Tree.expandedIcon", WebTreeUI.COLLAPSE_ICON);
        table.put("Tree.textForeground", Color.BLACK);
        table.put("Tree.textBackground", StyleConstants.transparent);
        table.put("Tree.selectionForeground", Color.BLACK);
        table.put("Tree.selectionBackground", StyleConstants.transparent);
        table.put("Tree.selectionBorderColor", StyleConstants.transparent);
        table.put("Tree.dropCellBackground", StyleConstants.transparent);
        table.put("Tree.rendererMargins", new InsetsUIResource(4, 4, 4, 6));
        table.put("Tree.rendererFillBackground", Boolean.FALSE);
        table.put("Tree.drawsFocusBorderAroundIcon", Boolean.FALSE);
        table.put("Tree.drawDashedFocusIndicator", Boolean.FALSE);
        table.put("Tree.leftChildIndent", new Integer(12));
        table.put("Tree.rightChildIndent", new Integer(12));
        table.put("Tree.lineTypeDashed", Boolean.TRUE);
        table.put("Menu.menuPopupOffsetX", new Integer(0));
        table.put("Menu.menuPopupOffsetY", new Integer(0));
        table.put("Menu.submenuPopupOffsetX", new Integer(0));
        table.put("Menu.submenuPopupOffsetY", new Integer(0));
        table.put("Viewport.background", WebViewportStyle.background);
        table.put("Table.cellNoFocusBorder", LafUtils.createWebBorder(1, 1, 1, 1));
        table.put("Table.focusSelectedCellHighlightBorder", LafUtils.createWebBorder(1, 1, 1, 1));
        table.put("Table.focusCellHighlightBorder", LafUtils.createWebBorder(1, 1, 1, 1));
        table.put("Table.foreground", WebTableStyle.foreground);
        table.put("Table.background", WebTableStyle.background);
        table.put("Table.selectionForeground", WebTableStyle.selectionForeground);
        table.put("Table.selectionBackground", WebTableStyle.selectionBackground);
        table.put("Table.scrollPaneBorder", (Object)null);
        table.put("TableHeader.cellBorder", LafUtils.createWebBorder(WebTableStyle.headerMargin));
        table.put("TableHeader.focusCellBorder", LafUtils.createWebBorder(WebTableStyle.headerMargin));
        table.put("List.cellRenderer", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new WebListCellRenderer.UIResource();
            }
        });
        table.put("List.selectionForeground", WebListStyle.foreground);
        table.put("ComboBox.selectionForeground", Color.BLACK);
        table.put("ComboBox.squareButton", (Object)false);
        table.put("ComboBox.padding", new InsetsUIResource(0, 0, 0, 0));
        table.put("ProgressBar.border", new SwingLazyValue("com.alee.laf.WebBorders", "getProgressBarBorder"));
        table.put("Button.border", new SwingLazyValue("com.alee.laf.WebBorders", "getButtonBorder"));
        table.put("TextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"}));
        table.put("PasswordField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-begin-line", "control RIGHT", "caret-end-line", "control shift LEFT", "selection-begin-line", "control shift RIGHT", "selection-end-line", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"}));
        table.put("FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}));
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control A", "select-all", "control BACK_SLASH", "unselect", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control HOME", "caret-begin", "control END", "caret-end", "control shift HOME", "selection-begin", "control shift END", "selection-end", "UP", "caret-up", "DOWN", "caret-down", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift DOWN", "selection-down", "ENTER", "insert-break", "TAB", "insert-tab", "control T", "next-link-action", "control shift T", "previous-link-action", "control SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        table.put("TextArea.focusInputMap", multilineInputMap);
        table.put("TextPane.focusInputMap", multilineInputMap);
        table.put("EditorPane.focusInputMap", multilineInputMap);
        table.put("ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}));
        table.put("FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up", "ENTER", "approveSelection", "ctrl ENTER", "approveSelection"}));
    }

    private static void initializeFonts(UIDefaults table) {
        WebLookAndFeel.initializeFont(table, "Button.font", buttonFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "ToggleButton.font", toggleButtonFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "RadioButton.font", radioButtonFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "CheckBox.font", checkBoxFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "ColorChooser.font", colorChooserFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "ComboBox.font", comboBoxFont, globalTextFont);
        WebLookAndFeel.initializeFont(table, "InternalFrame.titleFont", internalFrameFont, globalTitleFont);
        WebLookAndFeel.initializeFont(table, "Label.font", labelFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "List.font", listFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "MenuBar.font", menuBarFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table, "MenuItem.font", menuItemFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table, "MenuItem.acceleratorFont", menuItemAcceleratorFont, globalAcceleratorFont);
        WebLookAndFeel.initializeFont(table, "RadioButtonMenuItem.font", radioButtonMenuItemFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table, "RadioButtonMenuItem.acceleratorFont", radioButtonMenuItemAcceleratorFont, globalAcceleratorFont);
        WebLookAndFeel.initializeFont(table, "CheckBoxMenuItem.font", checkBoxMenuItemFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table, "CheckBoxMenuItem.acceleratorFont", checkBoxMenuItemAcceleratorFont, globalAcceleratorFont);
        WebLookAndFeel.initializeFont(table, "Menu.font", menuFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table, "Menu.acceleratorFont", menuAcceleratorFont, globalAcceleratorFont);
        WebLookAndFeel.initializeFont(table, "PopupMenu.font", popupMenuFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table, "OptionPane.font", optionPaneFont, globalAlertFont);
        WebLookAndFeel.initializeFont(table, "Panel.font", panelFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "ProgressBar.font", progressBarFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "ScrollPane.font", scrollPaneFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "Viewport.font", viewportFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "Slider.font", sliderFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "Spinner.font", spinnerFont, globalTextFont);
        WebLookAndFeel.initializeFont(table, "TabbedPane.font", tabbedPaneFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "Table.font", tableFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "TableHeader.font", tableHeaderFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "TextField.font", textFieldFont, globalTextFont);
        WebLookAndFeel.initializeFont(table, "FormattedTextField.font", formattedTextFieldFont, globalTextFont);
        WebLookAndFeel.initializeFont(table, "PasswordField.font", passwordFieldFont, globalTextFont);
        WebLookAndFeel.initializeFont(table, "TextArea.font", textAreaFont, globalTextFont);
        WebLookAndFeel.initializeFont(table, "TextPane.font", textPaneFont, globalTextFont);
        WebLookAndFeel.initializeFont(table, "EditorPane.font", editorPaneFont, globalTextFont);
        WebLookAndFeel.initializeFont(table, "TitledBorder.font", titledBorderFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "ToolBar.font", toolBarFont, globalControlFont);
        WebLookAndFeel.initializeFont(table, "ToolTip.font", toolTipFont, globalTooltipFont);
        WebLookAndFeel.initializeFont(table, "Tree.font", treeFont, globalControlFont);
    }

    protected static void initializeFont(UIDefaults table, String key, Font font, Font globalFont) {
        table.put(key, WebLookAndFeel.createLazyFont(font != null ? font : globalFont));
    }

    protected static SwingLazyValue createLazyFont(Font font) {
        return new SwingLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{font.getName(), font.getStyle(), font.getSize()});
    }

    @Override
    public void initialize() {
        super.initialize();
        System.setProperty("sun.awt.exception.handler", ExceptionHandler.class.getName());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(altProcessor);
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(WebLookAndFeel.LOOK_AND_FEEL_PROPERTY)) {
                    if (evt.getNewValue() instanceof WebLookAndFeel) {
                        JFrame.setDefaultLookAndFeelDecorated(decorateFrames);
                        JDialog.setDefaultLookAndFeelDecorated(decorateDialogs);
                        WebLookAndFeel.initializeManagers();
                    }
                    UIManager.removePropertyChangeListener(this);
                }
            }
        });
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(altProcessor);
    }

    public static void setMnemonicHidden(boolean hide) {
        isMnemonicHidden = !UIManager.getBoolean("Button.showMnemonics") && hide;
    }

    public static boolean isMnemonicHidden() {
        if (UIManager.getBoolean("Button.showMnemonics")) {
            isMnemonicHidden = false;
        }
        return isMnemonicHidden;
    }

    public static boolean install() {
        return WebLookAndFeel.install(false);
    }

    public static boolean install(boolean updateExistingComponents) {
        try {
            UIManager.setLookAndFeel(new WebLookAndFeel());
            if (updateExistingComponents) {
                WebLookAndFeel.updateAllComponentUIs();
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isInstalled() {
        return UIManager.getLookAndFeel().getClass().getCanonicalName().equals(WebLookAndFeel.class.getCanonicalName());
    }

    public static void initializeManagers() {
        VersionManager.initialize();
        LanguageManager.initialize();
        SettingsManager.initialize();
        HotkeyManager.initialize();
        FocusManager.initialize();
        TooltipManager.initialize();
        ProxyManager.initialize();
        StyleManager.initialize();
    }

    public static List<Image> getImages() {
        WebLookAndFeel.loadIcons();
        return ImageUtils.toImagesList(icons);
    }

    public static List<ImageIcon> getIcons() {
        WebLookAndFeel.loadIcons();
        return CollectionUtils.copy(icons);
    }

    public static Image getImage(int size) {
        return WebLookAndFeel.getIcon(size).getImage();
    }

    public static ImageIcon getIcon(int size) {
        WebLookAndFeel.loadIcons();
        for (ImageIcon icon : icons) {
            if (icon.getIconWidth() != size) continue;
            return icon;
        }
        return null;
    }

    protected static void loadIcons() {
        if (icons == null) {
            icons = XmlUtils.loadImagesList(WebLookAndFeel.class.getResource("resources/icons.xml"));
        }
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        if (disabledIcons.containsKey(icon)) {
            return disabledIcons.get(icon);
        }
        ImageIcon disabledIcon = icon instanceof ImageIcon ? ImageUtils.createDisabledCopy((ImageIcon)icon) : null;
        disabledIcons.put(icon, disabledIcon);
        return disabledIcon;
    }

    public static void updateAllComponentUIs() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    @Override
    public LayoutStyle getLayoutStyle() {
        return WebLayoutStyle.getInstance();
    }

    public static boolean isDecorateFrames() {
        return decorateFrames;
    }

    public static void setDecorateFrames(boolean decorateFrames) {
        WebLookAndFeel.decorateFrames = decorateFrames;
        JFrame.setDefaultLookAndFeelDecorated(decorateFrames);
    }

    public static boolean isDecorateDialogs() {
        return decorateDialogs;
    }

    public static void setDecorateDialogs(boolean decorateDialogs) {
        WebLookAndFeel.decorateDialogs = decorateDialogs;
        JDialog.setDefaultLookAndFeelDecorated(decorateDialogs);
    }

    public static void setDecorateAllWindows(boolean decorateAllWindows) {
        WebLookAndFeel.setDecorateFrames(decorateAllWindows);
        WebLookAndFeel.setDecorateDialogs(decorateAllWindows);
    }

    public static boolean isLeftToRight() {
        return LanguageManager.isLeftToRight();
    }

    public static ComponentOrientation getOrientation() {
        return LanguageManager.getOrientation();
    }

    public static ComponentOrientation getOppositeOrientation() {
        return LanguageManager.getOppositeOrientation();
    }

    public static void setOrientation(ComponentOrientation orientation) {
        LanguageManager.setOrientation(orientation);
    }

    public static void changeOrientation() {
        LanguageManager.changeOrientation();
    }

    static {
        globalTooltipFont = WebFonts.getSystemTooltipFont();
        globalAlertFont = WebFonts.getSystemAlertFont();
        globalMenuFont = WebFonts.getSystemMenuFont();
        globalAcceleratorFont = WebFonts.getSystemAcceleratorFont();
        globalTitleFont = WebFonts.getSystemTitleFont();
        globalTextFont = WebFonts.getSystemTextFont();
    }

    public static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public void handle(Throwable thrown) {
            this.handleException(Thread.currentThread().getName(), thrown);
        }

        @Override
        public void uncaughtException(Thread thread, Throwable thrown) {
            this.handleException(thread.getName(), thrown);
        }

        protected void handleException(String tname, Throwable thrown) {
            System.err.print("Exception in thread " + tname + ": ");
            thrown.printStackTrace();
        }
    }
}

