/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf;

import com.alee.extended.image.WebImage;
import com.alee.extended.label.WebLinkLabel;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.window.ComponentMoveAdapter;
import com.alee.laf.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebFrame;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.tabbedpane.TabStretchType;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.laf.table.WebTable;
import com.alee.laf.text.WebTextArea;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.LM;
import com.alee.managers.language.LanguageAdapter;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.popup.WebPopup;
import com.alee.managers.version.VersionInfo;
import com.alee.managers.version.VersionManager;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.reflection.JarEntry;
import com.alee.utils.reflection.JarStructure;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;

public class LibraryInfoDialog
extends WebFrame {
    private static final String LIBRARY_DATA_SEPARATOR = " - ";
    private static LibraryInfoDialog instance;

    public static LibraryInfoDialog getInstance() {
        if (instance == null) {
            instance = new LibraryInfoDialog();
        }
        return instance;
    }

    private LibraryInfoDialog() {
        this.setIconImages(WebLookAndFeel.getImages());
        this.setLanguage("weblaf.info.title", new Object[0]);
        ComponentMoveAdapter.install(this);
        final WebTabbedPane tab = new WebTabbedPane();
        tab.setTabbedPaneStyle(TabbedPaneStyle.attached);
        tab.setTabStretchType(TabStretchType.always);
        tab.addTab(LM.get("weblaf.info.general.title"), this.createTabSeparator(this.createGeneralTab()));
        tab.addTab(LM.get("weblaf.info.libraries.title"), this.createTabSeparator(this.createLibrariesTab()));
        tab.addTab(LM.get("weblaf.info.properties.title"), this.createTabSeparator(this.createPropertiesTab()));
        LanguageManager.addLanguageListener(new LanguageAdapter(){

            @Override
            public void languageUpdated() {
                tab.setTitleAt(0, LM.get("weblaf.info.general.title"));
                tab.setTitleAt(1, LM.get("weblaf.info.libraries.title"));
                tab.setTitleAt(2, LM.get("weblaf.info.properties.title"));
            }
        });
        this.add(tab);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    private Component createTabSeparator(Component component) {
        WebPanel content = new WebPanel();
        content.add((Component)new TabAreaSeparator(), (Object)"North");
        content.add(component, (Object)"Center");
        return content;
    }

    private Component createGeneralTab() {
        WebPanel content = new WebPanel(new VerticalFlowLayout(30, 30));
        content.setMargin(60, 70, 60, 70);
        content.setUndecorated(false);
        content.setWebColoredBackground(true);
        content.setPaintSides(false, false, false, false);
        content.add((Component)this.createLibraryVersionPanel());
        content.add((Component)new WebSeparator(false, 0));
        content.add((Component)this.createJavaVersionPanel());
        content.add((Component)new WebSeparator(false, 0));
        content.add((Component)this.createOsVersionPanel());
        return content;
    }

    private WebPanel createLibraryVersionPanel() {
        VersionInfo versionInfo = VersionManager.getLibraryVersion();
        WebImage icon = new WebImage(WebLookAndFeel.getIcon(32));
        WebLinkLabel version = new WebLinkLabel(versionInfo.toString());
        version.setLink("http://weblookandfeel.com", false);
        SwingUtils.setBoldFont(version);
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy", Locale.getDefault());
        WebLabel date = new WebLabel();
        date.setLanguage("weblaf.info.general.updated", sdf.format(new Date(versionInfo.getDate())));
        return new GroupPanel(15, icon, new GroupPanel(false, version, date));
    }

    private WebPanel createJavaVersionPanel() {
        WebImage javaIcon = new WebImage(new ImageIcon(LibraryInfoDialog.class.getResource("icons/java.png")));
        WebLinkLabel javaVersion = new WebLinkLabel();
        javaVersion.setLanguage("weblaf.info.general.java.version", SystemUtils.getJavaVersionString());
        javaVersion.setLink("http://www.oracle.com/technetwork/java/javase/overview/", false);
        SwingUtils.setBoldFont(javaVersion);
        WebLabel javaName = new WebLabel(SystemUtils.getJavaName());
        return new GroupPanel(15, javaIcon, new GroupPanel(false, javaVersion, javaName));
    }

    private WebPanel createOsVersionPanel() {
        WebImage osIcon = new WebImage(SystemUtils.getOsIcon(32, false));
        WebLinkLabel version = new WebLinkLabel(SystemUtils.getOsName());
        version.setLink(SystemUtils.getOsSite(), false);
        SwingUtils.setBoldFont(version);
        WebLabel osVersion = new WebLabel();
        osVersion.setLanguage("weblaf.info.general.os.arch", SystemUtils.getOsArch());
        return new GroupPanel(15, osIcon, new GroupPanel(false, version, osVersion));
    }

    private Component createLibrariesTab() {
        try {
            final JarStructure structure = ReflectUtils.getJarStructure(this.getClass());
            JarEntry licensesFolder = structure.getRoot().getChildByName("licenses");
            JarEntry librariesDataFile = licensesFolder.getChildByName("libraries.data");
            String librariesDataText = FileUtils.readToString(structure.getEntryInputStream(librariesDataFile));
            Map<String, String> librariesData = this.parseUrls(librariesDataText);
            WebPanel librariesPanel = new WebPanel(new VerticalFlowLayout(0, 5));
            librariesPanel.setMargin(5);
            for (final JarEntry child : licensesFolder.getChilds()) {
                if (!child.getName().endsWith(".txt")) continue;
                String data = librariesData.get(child.getName());
                int i = data.indexOf(LIBRARY_DATA_SEPARATOR);
                String name = data.substring(0, i);
                String url = data.substring(i + LIBRARY_DATA_SEPARATOR.length());
                WebLabel nameLabel = new WebLabel(name);
                SwingUtils.setBoldFont(nameLabel);
                final WebLinkLabel fileLink = new WebLinkLabel(child.getName());
                fileLink.setLink(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String license = FileUtils.readToString(structure.getEntryInputStream(child));
                            final WebPopup licensePopup = new WebPopup();
                            WebTextArea textArea = new WebTextArea(license);
                            textArea.setEditable(false);
                            licensePopup.add((Component)new WebScrollPane(textArea, false));
                            licensePopup.showPopupAsModal(fileLink, true, true);
                            HotkeyManager.registerHotkey((Component)textArea, Hotkey.ESCAPE, new HotkeyRunnable(){

                                @Override
                                public void run(KeyEvent e) {
                                    licensePopup.hidePopup();
                                }
                            });
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                WebLabel licenseLabel = new WebLabel();
                licenseLabel.setLanguage("weblaf.info.libraries.license", new Object[0]);
                GroupPanel fileLinkPanel = new GroupPanel(5, licenseLabel, fileLink);
                WebLinkLabel urlLink = new WebLinkLabel(url);
                urlLink.setLink(url, false);
                WebLabel siteLabel = new WebLabel();
                siteLabel.setLanguage("weblaf.info.libraries.site", new Object[0]);
                GroupPanel urlLinkPanel = new GroupPanel(5, siteLabel, urlLink);
                GroupPanel libraryPanel = new GroupPanel(false, nameLabel, fileLinkPanel, urlLinkPanel);
                libraryPanel.setUndecorated(false);
                libraryPanel.setMargin(5);
                libraryPanel.setPreferredWidth(0);
                librariesPanel.add((Component)libraryPanel);
            }
            WebScrollPane scrollPane = new WebScrollPane(librariesPanel, false);
            scrollPane.setPreferredHeight(0);
            return scrollPane;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return this.createErrorLibrariesTab();
        }
    }

    private Map<String, String> parseUrls(String librariesUrlText) {
        HashMap<String, String> librariesUrl = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(librariesUrlText, "\n", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int i = token.indexOf(LIBRARY_DATA_SEPARATOR);
            librariesUrl.put(token.substring(0, i), token.substring(i + LIBRARY_DATA_SEPARATOR.length()));
        }
        return librariesUrl;
    }

    private Component createErrorLibrariesTab() {
        WebLabel errorLabel = new WebLabel(0);
        errorLabel.setLanguage("weblaf.info.libraries.error", new Object[0]);
        return errorLabel;
    }

    private Component createPropertiesTab() {
        Object[][] systemPropertiesData = this.createSystemPropertiesData();
        final DefaultTableModel model = new DefaultTableModel(systemPropertiesData, this.getPropertiesTableColumnNames());
        final WebTable propertiesTable = new WebTable(model);
        propertiesTable.setPreferredScrollableViewportSize(new Dimension(1, 1));
        propertiesTable.setEditable(false);
        LanguageManager.addLanguageListener(new LanguageAdapter(){

            @Override
            public void languageUpdated() {
                int[] selection = propertiesTable.getSelectedRows();
                model.setColumnIdentifiers(LibraryInfoDialog.this.getPropertiesTableColumnNames());
                for (int s : selection) {
                    propertiesTable.addRowSelectionInterval(s, s);
                }
            }
        });
        return new WebScrollPane(propertiesTable, false);
    }

    private String[] getPropertiesTableColumnNames() {
        return new String[]{LM.get("weblaf.info.properties.key"), LM.get("weblaf.info.properties.value")};
    }

    private Object[][] createSystemPropertiesData() {
        Properties properties = System.getProperties();
        Object[][] data = new Object[properties.size()][2];
        int i = 0;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            data[i][0] = entry.getKey();
            data[i][1] = entry.getValue();
            ++i;
        }
        Arrays.sort(data, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return ((String)o1[0]).compareTo((String)o2[0]);
            }
        });
        return data;
    }

    public static void main(String[] args) {
        WebLookAndFeel.install();
        HotkeyManager.registerHotkey(Hotkey.ALT_R, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                WebLookAndFeel.changeOrientation();
            }
        });
        HotkeyManager.registerHotkey(Hotkey.ALT_L, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                String current = LanguageManager.getLanguage();
                List<String> supported = LanguageManager.getSupportedLanguages();
                int i = supported.indexOf(current);
                if (i != -1) {
                    LanguageManager.setLanguage(i < supported.size() - 1 ? supported.get(i + 1) : supported.get(0));
                }
            }
        });
        LibraryInfoDialog.getInstance().setVisible(true);
    }

    private class TabAreaSeparator
    extends JComponent {
        private TabAreaSeparator() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(StyleConstants.backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
            g.setColor(StyleConstants.darkBorderColor);
            g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 4);
        }
    }
}

