/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.extended.window.ComponentMoveAdapter;
import com.alee.extended.window.PopOverAlignment;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.PopOverLocation;
import com.alee.extended.window.PopOverSourcePoint;
import com.alee.extended.window.WebPopOverStyle;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebDialog;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.skin.web.PopupStyle;
import com.alee.managers.style.skin.web.WebPopOverPainter;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.Styleable;
import com.alee.utils.swing.DataProvider;
import com.alee.utils.swing.WindowFollowAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class WebPopOver
extends WebDialog
implements Styleable {
    protected boolean movable = WebPopOverStyle.movable;
    protected PopOverSourcePoint popOverSourcePoint = WebPopOverStyle.popOverSourcePoint;
    protected WebPanel container;
    protected boolean attached = false;
    protected PopOverDirection preferredDirection = null;
    protected PopOverAlignment preferredAlignment = null;

    public WebPopOver() {
    }

    public WebPopOver(Frame owner) {
        super(owner);
    }

    public WebPopOver(Frame owner, String title) {
        super(owner, title);
    }

    public WebPopOver(Dialog owner) {
        super(owner);
    }

    public WebPopOver(Dialog owner, String title) {
        super(owner, title);
    }

    public WebPopOver(Component owner) {
        super(owner);
    }

    public WebPopOver(Component owner, String title) {
        super(owner, title);
    }

    public WebPopOver(Window owner) {
        super(owner);
    }

    public WebPopOver(Window owner, String title) {
        super(owner, title);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setUndecorated(true);
        this.setWindowOpaque(false);
        this.container = new WebPanel();
        this.container.setStyleId("pop-over");
        this.setContentPane(this.container);
        ComponentMoveAdapter moveAdapter = new ComponentMoveAdapter(){

            @Override
            protected Rectangle getDragStartBounds(MouseEvent e) {
                if (WebPopOver.this.movable) {
                    int sw = WebPopOver.this.getShadeWidth();
                    return new Rectangle(sw, sw, WebPopOver.this.container.getWidth() - sw * 2, WebPopOver.this.container.getHeight() - sw * 2);
                }
                return null;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.dragging && WebPopOver.this.attached) {
                    WebPopOver.this.attached = false;
                    WebPopOver.this.preferredDirection = null;
                    WebPopOver.this.setPopupStyle(PopupStyle.simple);
                }
                super.mouseDragged(e);
            }
        };
        this.container.addMouseListener(moveAdapter);
        this.container.addMouseMotionListener(moveAdapter);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                WebPopOver.this.setPopOverFocused(true);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                WebPopOver.this.setPopOverFocused(false);
            }
        });
    }

    @Override
    public String getStyleId() {
        return this.container.getStyleId();
    }

    @Override
    public void setStyleId(String id) {
        this.container.setStyleId(id);
    }

    public void setContentBackground(Color color) {
        this.container.setBackground(color);
    }

    public Color getContentBackground() {
        return this.container.getBackground();
    }

    public Insets getMargin() {
        return this.container.getMargin();
    }

    public WebPopOver setMargin(Insets margin) {
        this.container.setMargin(margin);
        return this;
    }

    public WebPopOver setMargin(int top, int left, int bottom, int right) {
        this.container.setMargin(top, left, bottom, right);
        return this;
    }

    public WebPopOver setMargin(int margin) {
        this.container.setMargin(margin);
        return this;
    }

    public WebPopOverPainter getPainter() {
        return (WebPopOverPainter)this.container.getPainter();
    }

    public void setPainter(WebPopOverPainter painter) {
        this.container.setPainter(painter);
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    public PopOverSourcePoint getPopOverSourcePoint() {
        return this.popOverSourcePoint;
    }

    public void setPopOverSourcePoint(PopOverSourcePoint popOverSourcePoint) {
        this.popOverSourcePoint = popOverSourcePoint;
    }

    public Color getBorderColor() {
        return this.getPainter().getBorderColor();
    }

    public void setBorderColor(Color color) {
        StyleManager.setCustomPainterProperty(this.container, "borderColor", color);
    }

    @Override
    public int getRound() {
        return this.getPainter().getRound();
    }

    @Override
    public void setRound(int round) {
        StyleManager.setCustomPainterProperty(this.container, "round", round);
    }

    @Override
    public int getShadeWidth() {
        return this.getPainter().getShadeWidth();
    }

    @Override
    public void setShadeWidth(int width) {
        StyleManager.setCustomPainterProperty(this.container, "shadeWidth", width);
    }

    public float getShadeTransparency() {
        return this.getPainter().getShadeTransparency();
    }

    public void setShadeTransparency(float transparency) {
        StyleManager.setCustomPainterProperty(this.container, "shadeTransparency", Float.valueOf(transparency));
    }

    public int getCornerWidth() {
        return this.getPainter().getCornerWidth();
    }

    public void setCornerWidth(int width) {
        StyleManager.setCustomPainterProperty(this.container, "cornerWidth", width);
    }

    public float getTransparency() {
        return this.getPainter().getTransparency();
    }

    public void setTransparency(float transparency) {
        StyleManager.setCustomPainterProperty(this.container, "transparency", Float.valueOf(transparency));
    }

    protected PopupStyle getPopupStyle() {
        return this.getPainter().getPopupStyle();
    }

    protected void setPopupStyle(PopupStyle style) {
        StyleManager.setCustomPainterProperty(this.container, "popupStyle", style);
    }

    protected int getCornerSide() {
        return this.getPainter().getCornerSide();
    }

    protected void setCornerSide(int cornerSide) {
        StyleManager.setCustomPainterProperty(this.container, "cornerSide", cornerSide);
    }

    protected int getRelativeCorner() {
        return this.getPainter().getRelativeCorner();
    }

    protected void setRelativeCorner(int relativeCorner) {
        StyleManager.setCustomPainterProperty(this.container, "relativeCorner", relativeCorner);
    }

    protected int getCornerAlignment() {
        return this.getPainter().getCornerAlignment();
    }

    protected void setCornerAlignment(int cornerAlignment) {
        StyleManager.setCustomPainterProperty(this.container, "cornerAlignment", cornerAlignment);
    }

    public boolean isPopOverFocused() {
        return this.getPainter().isPopOverFocused();
    }

    public void setPopOverFocused(boolean focused) {
        StyleManager.setCustomPainterProperty(this.container, "popOverFocused", focused);
    }

    public WebPopOver show(PopOverLocation location) {
        this.attached = false;
        this.preferredDirection = null;
        this.setPopupStyle(PopupStyle.simple);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        switch (location) {
            case center: {
                this.setLocation(ss.width / 2 - this.getWidth() / 2, ss.height / 2 - this.getHeight() / 2);
                break;
            }
            case topLeft: {
                this.setLocation(0, 0);
                break;
            }
            case topRight: {
                this.setLocation(ss.width - this.getWidth(), 0);
                break;
            }
            case bottomLeft: {
                this.setLocation(0, ss.height - this.getHeight());
                break;
            }
            case bottomRight: {
                this.setLocation(ss.width - this.getWidth(), ss.height - this.getHeight());
                break;
            }
            case topCenter: {
                this.setLocation(ss.width / 2 - this.getWidth() / 2, 0);
                break;
            }
            case bottomCenter: {
                this.setLocation(ss.width / 2 - this.getWidth() / 2, ss.height - this.getHeight());
                break;
            }
            case leftCenter: {
                this.setLocation(0, ss.height / 2 - this.getHeight() / 2);
                break;
            }
            case rightCenter: {
                this.setLocation(ss.width - this.getWidth(), ss.height / 2 - this.getHeight() / 2);
            }
        }
        this.setVisible(true);
        return this;
    }

    public WebPopOver show(Point location) {
        return this.show(location.x, location.y);
    }

    public WebPopOver show(int x, int y) {
        this.attached = false;
        this.preferredDirection = null;
        this.setPopupStyle(PopupStyle.simple);
        this.pack();
        this.setLocation(x - this.getShadeWidth(), y - this.getShadeWidth());
        this.setVisible(true);
        return this;
    }

    public WebPopOver show(Component invoker) {
        return this.show(invoker, PopOverDirection.down);
    }

    public WebPopOver show(Component invoker, PopOverDirection direction) {
        return this.show(invoker, direction, PopOverAlignment.centered);
    }

    public WebPopOver show(Component invoker, PopOverDirection direction, PopOverAlignment alignment) {
        return this.show(invoker, null, direction, alignment);
    }

    public WebPopOver show(Component invoker, int x, int y) {
        return this.show(invoker, x, y, PopOverDirection.down);
    }

    public WebPopOver show(Component invoker, int x, int y, PopOverDirection direction) {
        return this.show(invoker, x, y, direction, PopOverAlignment.centered);
    }

    public WebPopOver show(Component invoker, int x, int y, PopOverDirection direction, PopOverAlignment alignment) {
        return this.show(invoker, x, y, 0, 0, direction, alignment);
    }

    public WebPopOver show(Component invoker, int x, int y, int w, int h) {
        return this.show(invoker, x, y, w, h, PopOverDirection.down);
    }

    public WebPopOver show(Component invoker, int x, int y, int w, int h, PopOverDirection direction) {
        return this.show(invoker, x, y, w, h, direction, PopOverAlignment.centered);
    }

    public WebPopOver show(Component invoker, int x, int y, int w, int h, PopOverDirection direction, PopOverAlignment alignment) {
        final Rectangle bounds = new Rectangle(x, y, w, h);
        return this.show(invoker, new DataProvider<Rectangle>(){

            @Override
            public Rectangle provide() {
                return bounds;
            }
        }, direction, alignment);
    }

    public WebPopOver show(Component invoker, DataProvider<Rectangle> boundsProvider) {
        return this.show(invoker, boundsProvider, PopOverDirection.down);
    }

    public WebPopOver show(Component invoker, DataProvider<Rectangle> boundsProvider, PopOverDirection direction) {
        return this.show(invoker, boundsProvider, direction, PopOverAlignment.centered);
    }

    public WebPopOver show(final Component invoker, final DataProvider<Rectangle> boundsProvider, PopOverDirection direction, PopOverAlignment alignment) {
        DataProvider<Rectangle> actualBoundsProvider = boundsProvider == null ? null : new DataProvider<Rectangle>(){
            private Rectangle lastBounds = new Rectangle();

            @Override
            public Rectangle provide() {
                if (invoker.isShowing()) {
                    Rectangle bounds = (Rectangle)boundsProvider.provide();
                    Point los = invoker.getLocationOnScreen();
                    this.lastBounds = new Rectangle(los.x + bounds.x, los.y + bounds.y, bounds.width, bounds.height);
                }
                return this.lastBounds;
            }
        };
        this.attached = true;
        this.preferredDirection = direction;
        this.preferredAlignment = alignment;
        this.pack();
        this.updatePopOverLocation(invoker, actualBoundsProvider);
        this.installPopOverLocationUpdater(invoker, actualBoundsProvider);
        this.setVisible(true);
        return this;
    }

    protected void updatePopOverLocation(Component invoker, DataProvider<Rectangle> invokerBoundsProvider) {
        if (invokerBoundsProvider != null) {
            this.updatePopOverLocation(invokerBoundsProvider.provide());
        } else {
            this.updatePopOverLocation(invoker);
        }
    }

    protected void updatePopOverLocation(Component invoker) {
        if (invoker instanceof Window) {
            this.setPopupStyle(PopupStyle.simple);
            Rectangle ib = invoker.getBounds();
            Dimension size = this.getSize();
            this.setLocation(ib.x + ib.width / 2 - size.width / 2, ib.y + ib.height / 2 - size.height / 2);
        } else {
            this.updatePopOverLocation(SwingUtils.getBoundsOnScreen(invoker));
        }
    }

    protected void updatePopOverLocation(Rectangle invokerBounds) {
        this.setPopupStyle(PopupStyle.dropdown);
        Dimension size = this.getSize();
        int sw = this.getShadeWidth();
        int round = this.getRound();
        int cw = this.getCornerWidth();
        Dimension ps = new Dimension(size.width - sw * 2, size.height - sw * 2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        PopOverDirection actualDirection = this.getActualDirection(invokerBounds, ltr, cw, ps, screenSize);
        this.setCornerSide(actualDirection.getCornerSide(ltr));
        Point actualLocation = this.getActualLocation(invokerBounds, ltr, round, cw, ps, screenSize, actualDirection);
        actualLocation.x -= sw;
        actualLocation.y -= sw;
        this.setCornerAlignment(-1);
        this.setRelativeCorner(this.getRelativeCorner(invokerBounds, actualDirection, actualLocation));
        this.setLocation(actualLocation);
    }

    protected void installPopOverLocationUpdater(final Component invoker, final DataProvider<Rectangle> invokerBoundsProvider) {
        final Window invokerWindow = SwingUtils.getWindowAncestor(invoker);
        final WindowFollowAdapter windowFollowAdapter = new WindowFollowAdapter(this, invokerWindow){

            @Override
            public boolean isEnabled() {
                return !WebPopOver.this.attached;
            }
        };
        invokerWindow.addComponentListener(windowFollowAdapter);
        final ComponentAdapter invokerWindowAdapter = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (WebPopOver.this.attached) {
                    WebPopOver.this.updatePopOverLocation(invoker, invokerBoundsProvider);
                    windowFollowAdapter.updateLastLocation();
                }
            }
        };
        invokerWindow.addComponentListener(invokerWindowAdapter);
        final ComponentAdapter invokerAdapter = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (WebPopOver.this.attached) {
                    WebPopOver.this.updatePopOverLocation(invoker, invokerBoundsProvider);
                    windowFollowAdapter.updateLastLocation();
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (WebPopOver.this.attached) {
                    WebPopOver.this.updatePopOverLocation(invoker, invokerBoundsProvider);
                    windowFollowAdapter.updateLastLocation();
                }
            }
        };
        invoker.addComponentListener(invokerAdapter);
        final PropertyChangeListener orientationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebPopOver.this.updatePopOverLocation(invoker, invokerBoundsProvider);
                windowFollowAdapter.updateLastLocation();
            }
        };
        this.addPropertyChangeListener("componentOrientation", orientationListener);
        class PopOverCloseListener
        implements ComponentListener,
        WindowListener {
            PopOverCloseListener() {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.cleanupListeners();
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.cleanupListeners();
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            public void cleanupListeners() {
                WebPopOver.this.removeComponentListener(this);
                WebPopOver.this.removeWindowListener(this);
                invokerWindow.removeComponentListener(invokerWindowAdapter);
                invokerWindow.removeComponentListener(windowFollowAdapter);
                invoker.removeComponentListener(invokerAdapter);
                WebPopOver.this.removePropertyChangeListener("componentOrientation", orientationListener);
            }
        }
        PopOverCloseListener closeListener = new PopOverCloseListener();
        this.addComponentListener(closeListener);
        this.addWindowListener(closeListener);
    }

    protected int getRelativeCorner(Rectangle ib, PopOverDirection actualDirection, Point actualLocation) {
        switch (actualDirection) {
            case up: 
            case down: {
                return ib.x + ib.width / 2 - actualLocation.x;
            }
            case left: 
            case right: {
                return ib.y + ib.height / 2 - actualLocation.y;
            }
        }
        return -1;
    }

    protected Point getActualLocation(Rectangle ib, boolean ltr, int round, int cw, Dimension ps, Dimension screenSize, PopOverDirection actualDirection) {
        Point sp = this.getActualSourcePoint(ib, ltr, actualDirection);
        if (actualDirection == PopOverDirection.up) {
            if (this.preferredAlignment == PopOverAlignment.centered) {
                Point location = new Point(sp.x - ps.width / 2, sp.y - cw - ps.height);
                return this.checkRightCollision(this.checkLeftCollision(location), ps, screenSize);
            }
            if (this.preferredAlignment == (ltr ? PopOverAlignment.leading : PopOverAlignment.trailing)) {
                return this.checkLeftCollision(new Point(sp.x + cw * 2 + round - ps.width, sp.y - cw - ps.height));
            }
            if (this.preferredAlignment == (ltr ? PopOverAlignment.trailing : PopOverAlignment.leading)) {
                return this.checkRightCollision(new Point(sp.x - cw * 2 - round, sp.y - cw - ps.height), ps, screenSize);
            }
        } else if (actualDirection == PopOverDirection.down) {
            if (this.preferredAlignment == PopOverAlignment.centered) {
                Point location = new Point(sp.x - ps.width / 2, sp.y + cw);
                return this.checkRightCollision(this.checkLeftCollision(location), ps, screenSize);
            }
            if (this.preferredAlignment == (ltr ? PopOverAlignment.leading : PopOverAlignment.trailing)) {
                return this.checkLeftCollision(new Point(sp.x + cw * 2 + round - ps.width, sp.y + cw));
            }
            if (this.preferredAlignment == (ltr ? PopOverAlignment.trailing : PopOverAlignment.leading)) {
                return this.checkRightCollision(new Point(sp.x - cw * 2 - round, sp.y + cw), ps, screenSize);
            }
        } else if (actualDirection == (ltr ? PopOverDirection.left : PopOverDirection.right)) {
            if (this.preferredAlignment == PopOverAlignment.centered) {
                Point location = new Point(sp.x - cw - ps.width, sp.y - ps.height / 2);
                return this.checkBottomCollision(this.checkTopCollision(location), ps, screenSize);
            }
            if (this.preferredAlignment == PopOverAlignment.leading) {
                return this.checkTopCollision(new Point(sp.x - cw - ps.width, sp.y + cw * 2 + round - ps.height));
            }
            if (this.preferredAlignment == PopOverAlignment.trailing) {
                return this.checkBottomCollision(new Point(sp.x - cw - ps.width, sp.y - cw * 2 - round), ps, screenSize);
            }
        } else if (actualDirection == (ltr ? PopOverDirection.right : PopOverDirection.left)) {
            if (this.preferredAlignment == PopOverAlignment.centered) {
                Point location = new Point(sp.x + cw, sp.y - ps.height / 2);
                return this.checkBottomCollision(this.checkTopCollision(location), ps, screenSize);
            }
            if (this.preferredAlignment == PopOverAlignment.leading) {
                return this.checkTopCollision(new Point(sp.x + cw, sp.y + cw * 2 + round - ps.height));
            }
            if (this.preferredAlignment == PopOverAlignment.trailing) {
                return this.checkBottomCollision(new Point(sp.x + cw, sp.y - cw * 2 - round), ps, screenSize);
            }
        }
        return null;
    }

    protected Point checkTopCollision(Point location) {
        if (location.y < 0) {
            location.y = 0;
        }
        return location;
    }

    protected Point checkBottomCollision(Point location, Dimension ps, Dimension screenSize) {
        if (location.y + ps.height > screenSize.height) {
            location.y = screenSize.height - ps.height;
        }
        return location;
    }

    protected Point checkLeftCollision(Point location) {
        if (location.x < 0) {
            location.x = 0;
        }
        return location;
    }

    protected Point checkRightCollision(Point location, Dimension ps, Dimension screenSize) {
        if (location.x + ps.width > screenSize.width) {
            location.x = screenSize.width - ps.width;
        }
        return location;
    }

    protected PopOverDirection getActualDirection(Rectangle ib, boolean ltr, int cw, Dimension ps, Dimension screenSize) {
        for (PopOverDirection checkedDirection : this.preferredDirection.getPriority()) {
            Point sp = this.getActualSourcePoint(ib, ltr, checkedDirection);
            if (!(checkedDirection == PopOverDirection.up ? sp.y - cw - ps.height > 0 : (checkedDirection == PopOverDirection.down ? sp.y + cw + ps.height < screenSize.height : (checkedDirection == (ltr ? PopOverDirection.left : PopOverDirection.right) ? sp.x - cw - ps.width > 0 : checkedDirection == (ltr ? PopOverDirection.right : PopOverDirection.left) && sp.x + cw + ps.width < screenSize.width)))) continue;
            return checkedDirection;
        }
        return this.preferredDirection;
    }

    protected Point getActualSourcePoint(Rectangle ib, boolean ltr, PopOverDirection direction) {
        if (this.popOverSourcePoint == PopOverSourcePoint.componentCenter) {
            return new Point(ib.x + ib.width / 2, ib.y + ib.height / 2);
        }
        if (direction == PopOverDirection.up) {
            return new Point(ib.x + ib.width / 2, ib.y);
        }
        if (direction == PopOverDirection.down) {
            return new Point(ib.x + ib.width / 2, ib.y + ib.height);
        }
        if (direction == (ltr ? PopOverDirection.left : PopOverDirection.right)) {
            return new Point(ib.x, ib.y + ib.height / 2);
        }
        if (direction == (ltr ? PopOverDirection.right : PopOverDirection.left)) {
            return new Point(ib.x + ib.width, ib.y + ib.height / 2);
        }
        return null;
    }
}

