/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree.sample;

import com.alee.extended.tree.AbstractTreeDataProvider;
import com.alee.extended.tree.ChildsListener;
import com.alee.extended.tree.sample.SampleNode;
import com.alee.extended.tree.sample.SampleNodeType;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.ThreadUtils;

public class SampleDataProvider
extends AbstractTreeDataProvider<SampleNode> {
    @Override
    public SampleNode getRoot() {
        return new SampleNode("Root", SampleNodeType.root);
    }

    @Override
    public void loadChilds(SampleNode parent, ChildsListener<SampleNode> listener) {
        parent.setTime(0L);
        int time = MathUtils.random(100, 2000);
        ThreadUtils.sleepSafely(time);
        parent.setTime(time);
        if (parent.getName().toLowerCase().contains("fail")) {
            listener.childsLoadFailed(new RuntimeException("Sample exception cause"));
        } else {
            switch (parent.getType()) {
                case root: {
                    SampleNode folder1 = new SampleNode("Folder 1", SampleNodeType.folder);
                    SampleNode folder2 = new SampleNode("Folder 2", SampleNodeType.folder);
                    SampleNode folder3 = new SampleNode("Folder 3", SampleNodeType.folder);
                    SampleNode folder4 = new SampleNode("Fail folder", SampleNodeType.folder);
                    listener.childsLoadCompleted(CollectionUtils.copy(folder1, folder2, folder3, folder4));
                    break;
                }
                case folder: {
                    SampleNode leaf1 = new SampleNode("Leaf 1", SampleNodeType.leaf);
                    SampleNode leaf2 = new SampleNode("Leaf 2", SampleNodeType.leaf);
                    SampleNode leaf3 = new SampleNode("Leaf 3", SampleNodeType.leaf);
                    listener.childsLoadCompleted(CollectionUtils.copy(leaf1, leaf2, leaf3));
                    break;
                }
            }
        }
    }

    @Override
    public boolean isLeaf(SampleNode node) {
        return node.getType().equals((Object)SampleNodeType.leaf);
    }
}

