/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.image.WebImage;
import com.alee.extended.tree.AsyncTreeNodesFilter;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.menu.WebCheckBoxMenuItem;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.swing.DocumentChangeListener;
import com.alee.utils.text.TextProvider;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.ImageIcon;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class WebAsyncTreeFilterField<E extends AsyncUniqueNode>
extends WebTextField {
    public static final ImageIcon settingsIcon = new ImageIcon(WebAsyncTreeFilterField.class.getResource("icons/filter/settings.png"));
    public static final ImageIcon matchCaseIcon = new ImageIcon(WebAsyncTreeFilterField.class.getResource("icons/filter/matchCase.png"));
    public static final ImageIcon useSpaceAsSeparatorIcon = new ImageIcon(WebAsyncTreeFilterField.class.getResource("icons/filter/useSpaceAsSeparator.png"));
    public static final ImageIcon searchFromStartIcon = new ImageIcon(WebAsyncTreeFilterField.class.getResource("icons/filter/searchFromStart.png"));
    protected WeakReference<WebAsyncTree<E>> asyncTree;
    protected AsyncTreeNodesFilter<E> filter;
    protected Document document;
    protected DocumentListener documentListener;
    protected WebImage filterIcon;
    protected WebPopupMenu settingsMenu;
    protected WebCheckBoxMenuItem matchCaseItem;
    protected WebCheckBoxMenuItem useSpaceAsSeparatorItem;
    protected WebCheckBoxMenuItem searchFromStartItem;

    public WebAsyncTreeFilterField() {
        this(null, null);
    }

    public WebAsyncTreeFilterField(WebAsyncTree<E> asyncTree) {
        this(asyncTree, null);
    }

    public WebAsyncTreeFilterField(TextProvider<E> textProvider) {
        this(null, textProvider);
    }

    public WebAsyncTreeFilterField(WebAsyncTree<E> asyncTree, TextProvider<E> textProvider) {
        this.setAsyncTree(asyncTree);
        this.setFilter(new AsyncTreeNodesFilter());
        this.setTextProvider(textProvider);
        this.init();
    }

    protected void init() {
        this.setLanguage("weblaf.ex.asynctreefilter.inputprompt", new Object[0]);
        this.setHideInputPromptOnFocus(false);
        this.initFilterIcon();
        this.initSettingsMenu();
        this.initFieldListeners();
    }

    protected void initFilterIcon() {
        this.filterIcon = new WebImage(WebAsyncTreeFilterField.class, "icons/filter/settings.png");
        this.filterIcon.setMargin(0, 2, 0, 2);
        this.filterIcon.setCursor(Cursor.getDefaultCursor());
        this.filterIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WebAsyncTreeFilterField.this.settingsMenu.showBelowMiddle(WebAsyncTreeFilterField.this.filterIcon);
            }
        });
        this.setLeadingComponent(this.filterIcon);
    }

    protected void initSettingsMenu() {
        this.settingsMenu = new WebPopupMenu();
        this.matchCaseItem = new WebCheckBoxMenuItem(matchCaseIcon);
        this.matchCaseItem.setLanguage("weblaf.filter.matchcase", new Object[0]);
        this.matchCaseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebAsyncTreeFilterField.this.filter.setMatchCase(WebAsyncTreeFilterField.this.matchCaseItem.isSelected());
                WebAsyncTreeFilterField.this.updateFiltering();
            }
        });
        this.settingsMenu.add(this.matchCaseItem);
        this.useSpaceAsSeparatorItem = new WebCheckBoxMenuItem(useSpaceAsSeparatorIcon);
        this.useSpaceAsSeparatorItem.setLanguage("weblaf.filter.spaceseparator", new Object[0]);
        this.useSpaceAsSeparatorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebAsyncTreeFilterField.this.filter.setUseSpaceAsSeparator(WebAsyncTreeFilterField.this.useSpaceAsSeparatorItem.isSelected());
                WebAsyncTreeFilterField.this.updateFiltering();
            }
        });
        this.settingsMenu.add(this.useSpaceAsSeparatorItem);
        this.searchFromStartItem = new WebCheckBoxMenuItem(searchFromStartIcon);
        this.searchFromStartItem.setLanguage("weblaf.filter.frombeginning", new Object[0]);
        this.searchFromStartItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebAsyncTreeFilterField.this.filter.setSearchFromStart(WebAsyncTreeFilterField.this.searchFromStartItem.isSelected());
                WebAsyncTreeFilterField.this.updateFiltering();
            }
        });
        this.settingsMenu.add(this.searchFromStartItem);
    }

    protected void initFieldListeners() {
        this.documentListener = new DocumentChangeListener(){

            @Override
            public void documentChanged(DocumentEvent e) {
                WebAsyncTreeFilterField.this.filter.setSearchText(WebAsyncTreeFilterField.this.getText());
                WebAsyncTreeFilterField.this.updateFiltering();
            }
        };
        this.updateDocumentListener();
        this.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                WebAsyncTreeFilterField.this.updateDocumentListener();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (Hotkey.ESCAPE.isTriggered(e)) {
                    WebAsyncTreeFilterField.this.clear();
                }
            }
        });
    }

    protected void updateDocumentListener() {
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        this.document = this.getDocument();
        this.document.addDocumentListener(this.documentListener);
    }

    public WebAsyncTree<E> getAsyncTree() {
        return this.asyncTree != null ? (WebAsyncTree)this.asyncTree.get() : null;
    }

    public void setAsyncTree(WebAsyncTree<E> asyncTree) {
        this.clearFilter();
        this.asyncTree = new WeakReference<WebAsyncTree<E>>(asyncTree);
        this.applyFilter();
    }

    public AsyncTreeNodesFilter<E> getFilter() {
        return this.filter;
    }

    public void setFilter(AsyncTreeNodesFilter<E> filter) {
        this.filter = filter;
        this.applyFilter();
    }

    protected void applyFilter() {
        if (this.asyncTree != null && this.asyncTree.get() != null) {
            ((WebAsyncTree)this.asyncTree.get()).setFilter(this.filter);
        }
    }

    protected void clearFilter() {
        if (this.asyncTree != null && this.asyncTree.get() != null) {
            ((WebAsyncTree)this.asyncTree.get()).clearFilter();
        }
    }

    public TextProvider<E> getTextProvider() {
        return this.filter.getTextProvider();
    }

    public void setTextProvider(TextProvider<E> textProvider) {
        this.filter.setTextProvider(textProvider);
        this.updateFiltering();
    }

    protected void updateFiltering() {
        this.filter.clearCache();
        WebAsyncTree<E> asyncTree = this.getAsyncTree();
        if (asyncTree != null) {
            asyncTree.updateSortingAndFiltering();
        }
    }
}

