/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.AsyncTreeQueue;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.tree.TreeUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public abstract class AsyncTreeTransferHandler<T extends AsyncUniqueNode>
extends TransferHandler {
    protected boolean allowUncheckedDrop = false;
    protected DataFlavor nodesFlavor;
    protected DataFlavor[] flavors = new DataFlavor[1];
    protected List<T> nodesToRemove;

    public AsyncTreeTransferHandler() {
        try {
            this.flavors[0] = this.nodesFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=\"" + List.class.getName() + "\"");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean isAllowUncheckedDrop() {
        return this.allowUncheckedDrop;
    }

    public void setAllowUncheckedDrop(boolean allowUncheckedDrop) {
        this.allowUncheckedDrop = allowUncheckedDrop;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (!support.isDataFlavorSupported(this.nodesFlavor)) {
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath path = dl.getPath();
        if (path == null) {
            return false;
        }
        AsyncUniqueNode target = (AsyncUniqueNode)path.getLastPathComponent();
        if (target.isLoading() || target.isFailed()) {
            return false;
        }
        try {
            if (this.nodesToRemove != null) {
                for (AsyncUniqueNode node : this.nodesToRemove) {
                    if (target != node && !target.isNodeAncestor(node)) continue;
                    return false;
                }
            }
            List nodes = (List)support.getTransferable().getTransferData(this.nodesFlavor);
            boolean canBeDropped = this.canBeDropped(nodes, target, dl.getChildIndex());
            support.setShowDropLocation(canBeDropped);
            return canBeDropped;
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("UnsupportedFlavor: " + ufe.getMessage());
            return false;
        }
        catch (IOException ioe) {
            System.out.println("I/O error: " + ioe.getMessage());
            return false;
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        WebAsyncTree tree = (WebAsyncTree)c;
        List nodes = tree.getSelectedNodes();
        if (!nodes.isEmpty()) {
            if (nodes.contains(tree.getRootNode())) {
                return null;
            }
            TreeUtils.optimizeNodes(nodes);
            if (!this.canBeDragged(nodes)) {
                return null;
            }
            ArrayList<AsyncUniqueNode> copies = new ArrayList<AsyncUniqueNode>();
            for (AsyncUniqueNode node : nodes) {
                copies.add(this.copy(node));
            }
            this.nodesToRemove = nodes;
            return new NodesTransferable(copies);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if ((action & 2) == 2) {
            WebAsyncTree tree = (WebAsyncTree)source;
            AsyncTreeModel model = (AsyncTreeModel)tree.getModel();
            model.removeNodesFromParent(this.nodesToRemove);
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        List nodes;
        if (!this.canImport(support)) {
            return false;
        }
        try {
            nodes = (List)support.getTransferable().getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("UnsupportedFlavor: " + ufe.getMessage());
            return false;
        }
        catch (IOException ioe) {
            System.out.println("I/O error: " + ioe.getMessage());
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        int childIndex = dl.getChildIndex();
        TreePath dest = dl.getPath();
        final AsyncUniqueNode parent = (AsyncUniqueNode)dest.getLastPathComponent();
        final WebAsyncTree tree = (WebAsyncTree)support.getComponent();
        final AsyncTreeModel model = (AsyncTreeModel)tree.getModel();
        if (this.allowUncheckedDrop) {
            if (parent.isLoaded()) {
                this.performDropOperation(nodes, parent, tree, model, childIndex == -1 ? parent.getChildCount() : childIndex);
            } else {
                tree.addAsyncTreeListener(new AsyncTreeAdapter(){

                    @Override
                    public void childsLoadCompleted(AsyncUniqueNode loadedFor, List childs) {
                        if (loadedFor == parent) {
                            AsyncTreeTransferHandler.this.performDropOperation(nodes, parent, tree, model, parent.getChildCount());
                            tree.removeAsyncTreeListener(this);
                        }
                    }

                    @Override
                    public void childsLoadFailed(AsyncUniqueNode loadedFor, Throwable cause) {
                        if (loadedFor == parent) {
                            tree.removeAsyncTreeListener(this);
                        }
                    }
                });
                tree.reloadNode(parent);
            }
            return true;
        }
        if (!parent.isLoaded()) {
            tree.reloadNodeSync(parent);
        }
        if (parent.isLoaded()) {
            this.performDropOperation(nodes, parent, tree, model, childIndex == -1 ? parent.getChildCount() : childIndex);
            return true;
        }
        return false;
    }

    protected void performDropOperation(final List<T> nodes, T parent, WebAsyncTree<T> tree, AsyncTreeModel<T> model, int index) {
        model.insertNodesInto(nodes, parent, index);
        tree.setSelectedNodes(nodes);
        AsyncTreeQueue.execute(tree, new Runnable((AsyncUniqueNode)parent, tree, model, index){
            final /* synthetic */ AsyncUniqueNode val$parent;
            final /* synthetic */ WebAsyncTree val$tree;
            final /* synthetic */ AsyncTreeModel val$model;
            final /* synthetic */ int val$index;
            {
                this.val$parent = asyncUniqueNode;
                this.val$tree = webAsyncTree;
                this.val$model = asyncTreeModel;
                this.val$index = n;
            }

            @Override
            public void run() {
                AsyncTreeTransferHandler.this.nodesDropped(nodes, this.val$parent, this.val$tree, this.val$model, this.val$index);
            }
        });
    }

    protected abstract boolean canBeDragged(List<T> var1);

    protected abstract boolean canBeDropped(List<T> var1, T var2, int var3);

    protected abstract T copy(T var1);

    public abstract void nodesDropped(List<T> var1, T var2, WebAsyncTree<T> var3, AsyncTreeModel<T> var4, int var5);

    public String toString() {
        return this.getClass().getName();
    }

    public class NodesTransferable
    implements Transferable,
    Serializable {
        protected final List<T> nodes;

        public NodesTransferable(List<T> nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return AsyncTreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return AsyncTreeTransferHandler.this.nodesFlavor.equals(flavor);
        }
    }
}

