/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.extended.statusbar.MemoryBarListener;
import com.alee.extended.statusbar.WebMemoryBarStyle;
import com.alee.laf.StyleConstants;
import com.alee.laf.label.WebLabel;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.ComponentUpdater;
import com.alee.utils.swing.SizeMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WebMemoryBar
extends WebLabel
implements ShapeProvider,
SizeMethods<WebLabel> {
    public static final String THREAD_NAME = "WebMemoryBar.updater";
    private ImageIcon memoryIcon = WebMemoryBarStyle.memoryIcon;
    private Color allocatedBorderColor = WebMemoryBarStyle.allocatedBorderColor;
    private Color allocatedDisabledBorderColor = WebMemoryBarStyle.allocatedDisabledBorderColor;
    private Color usedBorderColor = WebMemoryBarStyle.usedBorderColor;
    private Color usedFillColor = WebMemoryBarStyle.usedFillColor;
    public boolean drawBorder = WebMemoryBarStyle.drawBorder;
    public boolean fillBackground = WebMemoryBarStyle.fillBackground;
    private int leftRightSpacing = WebMemoryBarStyle.leftRightSpacing;
    private int shadeWidth = WebMemoryBarStyle.shadeWidth;
    private int round = WebMemoryBarStyle.round;
    private boolean allowGcAction = WebMemoryBarStyle.allowGcAction;
    private boolean showTooltip = WebMemoryBarStyle.showTooltip;
    private int tooltipDelay = WebMemoryBarStyle.tooltipDelay;
    private boolean showMaximumMemory = WebMemoryBarStyle.showMaximum;
    private final List<MemoryBarListener> listeners = new ArrayList<MemoryBarListener>(1);
    private long usedMemory = 0L;
    private long allocatedMemory = 0L;
    private long maxMemory = 0L;
    private int refreshRate = 1000;
    private ComponentUpdater updater = null;
    private boolean pressed = false;
    private WebCustomTooltip tooltip;
    private final WebLabel tooltipLabel;

    public WebMemoryBar() {
        this.setOpaque(false);
        this.setFocusable(true);
        this.setHorizontalAlignment(0);
        this.updateBorder();
        this.tooltipLabel = new WebLabel(this.memoryIcon);
        this.tooltipLabel.setStyleId("memory-bar-tip");
        this.updateTooltip();
        this.updateMemory();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (WebMemoryBar.this.isEnabled() && (Hotkey.SPACE.isTriggered(e) || Hotkey.ENTER.isTriggered(e))) {
                    WebMemoryBar.this.pressed = true;
                    WebMemoryBar.this.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (Hotkey.SPACE.isTriggered(e) || Hotkey.ENTER.isTriggered(e)) {
                    WebMemoryBar.this.pressed = false;
                    if (WebMemoryBar.this.isEnabled()) {
                        WebMemoryBar.this.doGC();
                    } else {
                        WebMemoryBar.this.repaint();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (WebMemoryBar.this.allowGcAction && WebMemoryBar.this.isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
                    WebMemoryBar.this.pressed = true;
                    WebMemoryBar.this.requestFocusInWindow();
                    WebMemoryBar.this.doGC();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (WebMemoryBar.this.pressed && SwingUtilities.isLeftMouseButton(e)) {
                    WebMemoryBar.this.pressed = false;
                    WebMemoryBar.this.repaint();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                WebMemoryBar.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                WebMemoryBar.this.repaint();
            }
        });
        this.updater = ComponentUpdater.install((JComponent)this, THREAD_NAME, (long)this.refreshRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebMemoryBar.this.updateMemory();
            }
        });
    }

    public void doGC() {
        this.fireGcCalled();
        System.gc();
        this.updateMemory();
        this.fireGcCompleted();
    }

    private void updateBorder() {
        if (this.drawBorder) {
            this.setMargin(this.shadeWidth + 2, this.shadeWidth + 2 + this.leftRightSpacing, this.shadeWidth + 2, this.shadeWidth + 2 + this.leftRightSpacing);
        } else {
            this.setMargin(2, 2 + this.leftRightSpacing, 2, 2 + this.leftRightSpacing);
        }
    }

    protected void updateMemory() {
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.usedMemory = mu.getUsed();
        this.allocatedMemory = mu.getCommitted();
        this.maxMemory = mu.getMax();
        this.setText(this.getMemoryBarText());
        if (this.showTooltip) {
            this.tooltipLabel.setText(this.getMemoryBarTooltipText());
            this.tooltip.updateLocation();
        }
        this.repaint();
    }

    protected String getMemoryBarText() {
        long total = this.showMaximumMemory ? this.maxMemory : this.allocatedMemory;
        return FileUtils.getFileSizeString(this.usedMemory, this.getDigits(this.usedMemory)) + " " + LanguageManager.get("weblaf.ex.memorybar.of") + " " + FileUtils.getFileSizeString(total, this.getDigits(total));
    }

    protected String getMemoryBarTooltipText() {
        return "<html>" + LanguageManager.get("weblaf.ex.memorybar.alloc") + " <b>" + FileUtils.getFileSizeString(this.allocatedMemory, this.getDigits(this.allocatedMemory)) + "</b> " + LanguageManager.get("weblaf.ex.memorybar.used") + " <b>" + FileUtils.getFileSizeString(this.usedMemory, this.getDigits(this.usedMemory)) + this.getMaximumText() + "</b></html>";
    }

    private String getMaximumText() {
        if (this.showMaximumMemory) {
            return "</b> " + LanguageManager.get("weblaf.ex.memorybar.max") + " <b>" + FileUtils.getFileSizeString(this.maxMemory, this.getDigits(this.maxMemory));
        }
        return "";
    }

    private int getDigits(long size) {
        return size < 0x40000000L ? 0 : 2;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
        this.updater.setDelay(refreshRate);
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public Color getAllocatedBorderColor() {
        return this.allocatedBorderColor;
    }

    public void setAllocatedBorderColor(Color allocatedBorderColor) {
        this.allocatedBorderColor = allocatedBorderColor;
    }

    public Color getAllocatedDisabledBorderColor() {
        return this.allocatedDisabledBorderColor;
    }

    public void setAllocatedDisabledBorderColor(Color allocatedDisabledBorderColor) {
        this.allocatedDisabledBorderColor = allocatedDisabledBorderColor;
    }

    public Color getUsedBorderColor() {
        return this.usedBorderColor;
    }

    public void setUsedBorderColor(Color usedBorderColor) {
        this.usedBorderColor = usedBorderColor;
    }

    public Color getUsedFillColor() {
        return this.usedFillColor;
    }

    public void setUsedFillColor(Color usedFillColor) {
        this.usedFillColor = usedFillColor;
    }

    public int getLeftRightSpacing() {
        return this.leftRightSpacing;
    }

    public void setLeftRightSpacing(int leftRightSpacing) {
        this.leftRightSpacing = leftRightSpacing;
        this.updateBorder();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.updateBorder();
    }

    public boolean isFillBackground() {
        return this.fillBackground;
    }

    public void setFillBackground(boolean fillBackground) {
        this.fillBackground = fillBackground;
    }

    public boolean isAllowGcAction() {
        return this.allowGcAction;
    }

    public void setAllowGcAction(boolean allowGcAction) {
        this.allowGcAction = allowGcAction;
        if (!allowGcAction && this.pressed) {
            this.pressed = false;
            this.repaint();
        }
    }

    public boolean isShowTooltip() {
        return this.showTooltip;
    }

    public void setShowTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
        this.updateTooltip();
    }

    private void updateTooltip() {
        if (this.showTooltip) {
            this.tooltip = TooltipManager.setTooltip((Component)this, (JComponent)this.tooltipLabel, this.tooltipDelay);
        } else {
            TooltipManager.removeTooltips(this.tooltipLabel);
        }
    }

    public long getAllocatedMemory() {
        return this.allocatedMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public ImageIcon getMemoryIcon() {
        return this.memoryIcon;
    }

    public void setMemoryIcon(ImageIcon memoryIcon) {
        this.memoryIcon = memoryIcon;
    }

    public int getTooltipDelay() {
        return this.tooltipDelay;
    }

    public void setTooltipDelay(int tooltipDelay) {
        this.tooltipDelay = tooltipDelay;
    }

    public boolean isShowMaximumMemory() {
        return this.showMaximumMemory;
    }

    public void setShowMaximumMemory(boolean showMaximumMemory) {
        this.showMaximumMemory = showMaximumMemory;
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this, this.getShadeWidth(), this.getRound());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object old = LafUtils.setupAntialias(g2d);
        boolean enabled = this.isEnabled();
        if (this.drawBorder) {
            LafUtils.drawWebStyle(g2d, this, this.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round, this.fillBackground, !this.pressed);
        } else if (this.fillBackground) {
            g2d.setPaint(!this.pressed ? LafUtils.getWebGradientPaint(0, 0, 0, this.getHeight()) : this.getBackground());
            g2d.fill(this.getVisibleRect());
        }
        if (this.showMaximumMemory) {
            g2d.setPaint(enabled ? this.allocatedBorderColor : this.allocatedDisabledBorderColor);
            int allocatedWidth = this.getProgressWidth(this.allocatedMemory, false);
            g2d.drawLine(this.shadeWidth + allocatedWidth, this.shadeWidth + 2, this.shadeWidth + allocatedWidth, this.getHeight() - this.shadeWidth - 3);
        }
        Composite composite = LafUtils.setupAlphaComposite(g2d, Float.valueOf(0.5f), !enabled);
        g2d.setPaint(this.usedFillColor);
        g2d.fill(this.getProgressShape(this.usedMemory, true));
        g2d.setPaint(this.usedBorderColor);
        g2d.draw(this.getProgressShape(this.usedMemory, false));
        LafUtils.restoreComposite(g2d, composite, !enabled);
        LafUtils.restoreAntialias(g2d, old);
        super.paintComponent(g2d);
    }

    private Shape getProgressShape(long progress, boolean fill) {
        int arcRound = Math.max(0, this.round - 1) * 2;
        if (this.drawBorder) {
            return new RoundRectangle2D.Double(this.shadeWidth + 2, this.shadeWidth + 2, this.getProgressWidth(progress, fill), this.getHeight() - 4 - this.shadeWidth * 2 - (fill ? 0 : 1), arcRound, arcRound);
        }
        return new RoundRectangle2D.Double(1.0, 1.0, this.getProgressWidth(progress, fill), this.getHeight() - 2 - (fill ? 0 : 1), arcRound, arcRound);
    }

    private int getProgressWidth(long progress, boolean fill) {
        return Math.round((float)(this.getWidth() - (this.drawBorder ? 4 + this.shadeWidth * 2 : 2) - (fill ? 0 : 1)) * (float)progress / (float)(this.showMaximumMemory ? this.maxMemory : this.allocatedMemory));
    }

    public void addMemoryBarListener(MemoryBarListener listener) {
        this.listeners.add(listener);
    }

    public void removeMemoryBarListener(MemoryBarListener listener) {
        this.listeners.remove(listener);
    }

    public void fireGcCalled() {
        for (MemoryBarListener listener : CollectionUtils.copy(this.listeners)) {
            listener.gcCalled();
        }
    }

    public void fireGcCompleted() {
        for (MemoryBarListener listener : CollectionUtils.copy(this.listeners)) {
            listener.gcCompleted();
        }
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebMemoryBar setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebMemoryBar setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebMemoryBar setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebMemoryBar setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }
}

