/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.NinePatchIconPainter;
import com.alee.utils.NinePatchUtils;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class InnerShadePainter<E extends JComponent>
extends NinePatchIconPainter<E> {
    protected int shadeWidth = 10;
    protected int round = 0;
    protected float shadeOpacity = 0.75f;
    protected boolean drawTop = true;
    protected boolean drawLeft = true;
    protected boolean drawBottom = true;
    protected boolean drawRight = true;
    protected int cachedShadeWidth = 10;
    protected int cachedRound = 0;
    protected float cachedShadeOpacity = 0.75f;

    public InnerShadePainter() {
    }

    public InnerShadePainter(int shadeWidth, int round, float shadeOpacity) {
        this.shadeWidth = shadeWidth;
        this.round = round;
        this.shadeOpacity = shadeOpacity;
    }

    public InnerShadePainter(boolean drawTop, boolean drawLeft, boolean drawBottom, boolean drawRight) {
        this.drawTop = drawTop;
        this.drawLeft = drawLeft;
        this.drawBottom = drawBottom;
        this.drawRight = drawRight;
    }

    protected void updateNinePatchIcon() {
        this.cachedShadeWidth = this.shadeWidth;
        this.cachedRound = this.round;
        this.cachedShadeOpacity = this.shadeOpacity;
        this.setNinePatchIcon(NinePatchUtils.createInnerShadeIcon(this.shadeWidth, this.round, this.shadeOpacity));
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public InnerShadePainter<E> setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        return this;
    }

    public int getRound() {
        return this.round;
    }

    public InnerShadePainter<E> setRound(int round) {
        this.round = round;
        return this;
    }

    public float getShadeOpacity() {
        return this.shadeOpacity;
    }

    public InnerShadePainter<E> setShadeOpacity(float shadeOpacity) {
        this.shadeOpacity = shadeOpacity;
        return this;
    }

    public boolean isDrawTop() {
        return this.drawTop;
    }

    public InnerShadePainter<E> setDrawTop(boolean drawTop) {
        this.drawTop = drawTop;
        return this;
    }

    public boolean isDrawLeft() {
        return this.drawLeft;
    }

    public InnerShadePainter<E> setDrawLeft(boolean drawLeft) {
        this.drawLeft = drawLeft;
        return this;
    }

    public boolean isDrawBottom() {
        return this.drawBottom;
    }

    public InnerShadePainter<E> setDrawBottom(boolean drawBottom) {
        this.drawBottom = drawBottom;
        return this;
    }

    public boolean isDrawRight() {
        return this.drawRight;
    }

    public InnerShadePainter<E> setDrawRight(boolean drawRight) {
        this.drawRight = drawRight;
        return this;
    }

    public InnerShadePainter<E> setDrawSides(boolean drawTop, boolean drawLeft, boolean drawBottom, boolean drawRight) {
        this.drawTop = drawTop;
        this.drawLeft = drawLeft;
        this.drawBottom = drawBottom;
        this.drawRight = drawRight;
        return this;
    }

    @Override
    public Insets getMargin(E c) {
        return new Insets(this.drawTop ? this.shadeWidth : 0, this.drawLeft ? this.shadeWidth : 0, this.drawBottom ? this.shadeWidth : 0, this.drawRight ? this.shadeWidth : 0);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        if (this.cachedShadeWidth != this.shadeWidth || this.cachedRound != this.round || this.cachedShadeOpacity != this.shadeOpacity || this.icon == null) {
            this.updateNinePatchIcon();
        }
        if (this.icon != null) {
            this.icon.setComponent((Component)c);
            this.icon.paintIcon(g2d, bounds.x - (this.drawLeft ? 0 : 10), bounds.y - (this.drawTop ? 0 : 10), bounds.width + (this.drawLeft ? 0 : 10) + (this.drawRight ? 0 : 10), bounds.height + (this.drawTop ? 0 : 10) + (this.drawBottom ? 0 : 10));
        }
    }
}

