/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.layout.OverlayData;
import com.alee.extended.layout.OverlayLocation;
import com.alee.extended.panel.WebOverlay;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

public class OverlayLayout
extends AbstractLayoutManager
implements SwingConstants {
    public static final String COMPONENT = "COMPONENT";
    public static final String OVERLAY = "OVERLAY";
    protected Map<Component, String> constraints = new HashMap<Component, String>();
    protected Insets componentMargin = null;
    protected Insets overlayMargin = null;

    public Insets getComponentMargin() {
        return this.componentMargin;
    }

    public void setComponentMargin(int margin) {
        this.setComponentMargin(margin, margin, margin, margin);
    }

    public void setComponentMargin(int top, int left, int bottom, int right) {
        this.setComponentMargin(new Insets(top, left, bottom, right));
    }

    public void setComponentMargin(Insets margin) {
        this.componentMargin = margin;
    }

    public Insets getOverlayMargin() {
        return this.overlayMargin;
    }

    public void setOverlayMargin(int margin) {
        this.setOverlayMargin(margin, margin, margin, margin);
    }

    public void setOverlayMargin(int top, int left, int bottom, int right) {
        this.setOverlayMargin(new Insets(top, left, bottom, right));
    }

    public void setOverlayMargin(Insets overlayMargin) {
        this.overlayMargin = overlayMargin;
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        String value = (String)constraints;
        if (value == null || !value.equals(COMPONENT) && !value.equals(OVERLAY)) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be 'COMPONENT' or 'OVERLAY' string");
        }
        this.constraints.put(component, value);
    }

    @Override
    public void removeComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets bi = parent.getInsets();
        Insets ci = this.getActualComponentInsets(parent);
        Dimension ps = new Dimension();
        for (Component component : parent.getComponents()) {
            String constraint = this.constraints.get(component);
            if (constraint == null || !constraint.equals(COMPONENT)) continue;
            Dimension cps = component.getPreferredSize();
            ps = SwingUtils.max(ps, new Dimension(bi.left + ci.left + cps.width + ci.right + bi.right, bi.top + ci.top + cps.height + ci.bottom + bi.bottom));
        }
        return ps;
    }

    protected Insets getActualComponentInsets(Container parent) {
        return this.componentMargin != null ? (parent.getComponentOrientation().isLeftToRight() ? this.componentMargin : SwingUtils.toRTL(this.componentMargin)) : new Insets(0, 0, 0, 0);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets bi = parent.getInsets();
        Insets ci = this.getActualComponentInsets(parent);
        for (Component component : parent.getComponents()) {
            Insets om;
            String constraint = this.constraints.get(component);
            if (constraint == null) continue;
            int pw = parent.getWidth();
            int ph = parent.getHeight();
            if (constraint.equals(COMPONENT)) {
                component.setBounds(bi.left + ci.left, bi.top + ci.top, pw - bi.left - bi.right - ci.left - ci.right, ph - bi.top - bi.bottom - ci.top - ci.bottom);
                continue;
            }
            if (!constraint.equals(OVERLAY)) continue;
            WebOverlay webOverlay = (WebOverlay)parent;
            OverlayData data = webOverlay.getOverlayData(component);
            Insets insets = om = this.overlayMargin != null ? this.overlayMargin : new Insets(0, 0, 0, 0);
            if (data.getLocation().equals((Object)OverlayLocation.fill)) {
                component.setBounds(bi.left + om.left, bi.top + om.top, pw - bi.left - om.left - bi.right - om.right, ph - bi.top - om.top - bi.bottom - om.bottom);
                continue;
            }
            if (data.getLocation().equals((Object)OverlayLocation.align)) {
                Dimension ps = component.getPreferredSize();
                int halign = this.getActualHalign(component, data);
                int x = halign == 2 || halign == -1 ? bi.left + om.left : (halign == 4 ? pw - bi.right - om.right - ps.width : pw / 2 - ps.width / 2);
                int valign = data.getValign();
                int y = valign == 1 || valign == -1 ? bi.top + om.top : (valign == 3 ? ph - bi.bottom - om.bottom - ps.height : ph / 2 - ps.height / 2);
                component.setBounds(x, y, halign == -1 ? pw - bi.left - om.left - bi.right - om.right : ps.width, valign == -1 ? ph - bi.top - om.top - bi.bottom - om.bottom : ps.height);
                continue;
            }
            component.setBounds(data.getRectangleProvider().provide());
        }
    }

    protected int getActualHalign(Component component, OverlayData data) {
        boolean ltr = component.getComponentOrientation().isLeftToRight();
        if (data.getHalign() == 10) {
            return ltr ? 2 : 4;
        }
        if (data.getHalign() == 11) {
            return ltr ? 4 : 2;
        }
        return data.getHalign();
    }
}

