/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.managers.notification.DisplayType;
import com.alee.managers.notification.NotificationManager;
import com.alee.managers.notification.WebNotificationPopup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingConstants;

public class NotificationsLayout
extends AbstractLayoutManager
implements SwingConstants {
    private List<WebNotificationPopup> notifications = new ArrayList<WebNotificationPopup>(2);

    @Override
    public void addComponent(Component component, Object constraints) {
        if (component instanceof WebNotificationPopup) {
            this.notifications.add((WebNotificationPopup)component);
        }
    }

    @Override
    public void removeComponent(Component component) {
        if (component instanceof WebNotificationPopup) {
            this.notifications.remove(component);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return null;
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.notifications.size() > 0) {
            int startY;
            int location = NotificationManager.getLocation();
            boolean east = location == 4 || location == 2;
            boolean south = location == 4 || location == 6;
            boolean flowDisplayType = NotificationManager.getDisplayType() == DisplayType.flow;
            Insets margin = NotificationManager.getMargin();
            int gap = NotificationManager.getGap();
            boolean cascade = NotificationManager.isCascade();
            int cascadeAmount = NotificationManager.getCascadeAmount();
            int width = parent.getWidth();
            int height = parent.getHeight();
            int maxWidth = 0;
            int maxCascade = 0;
            int x = east ? width - margin.right : margin.left;
            int y = startY = south ? height - margin.bottom : margin.top;
            int count = 0;
            for (WebNotificationPopup popup : this.notifications) {
                Dimension ps = popup.getPreferredSize();
                if (south ? y - ps.height < 0 : y + ps.height > height) {
                    int gapsAmount = cascade ? Math.max(1, maxCascade) : 1;
                    y = startY;
                    x = east ? x - maxWidth - gap * gapsAmount : x + maxWidth + gap;
                    maxWidth = 0;
                    maxCascade = 0;
                    count = 0;
                }
                int cascadeShear = cascade ? gap * count : 0;
                int x1 = east ? x - ps.width - cascadeShear : x + cascadeShear;
                int y1 = south ? y - ps.height : y;
                popup.setBounds(x1, y1, ps.width, ps.height);
                maxWidth = Math.max(maxWidth, ps.width);
                y += (south ? -1 : 1) * (flowDisplayType ? ps.height + gap : gap);
                if (!cascade) continue;
                maxCascade = Math.max(maxCascade, ++count);
                if (count <= cascadeAmount - 1) continue;
                count = 0;
            }
        }
    }
}

