/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.drag;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class TextDragHandler
extends TransferHandler {
    private String text;
    private boolean defaultBehavior = true;

    public TextDragHandler(JComponent component) {
        this(component, null);
    }

    public TextDragHandler(JComponent component, String text) {
        this(component, text, true);
    }

    public TextDragHandler(final JComponent component, String text, boolean defaultBehavior) {
        this.setText(text);
        this.setDefaultBehavior(defaultBehavior);
        component.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TextDragHandler.this.isDefaultBehavior() && SwingUtilities.isLeftMouseButton(e) && component.isEnabled()) {
                    TextDragHandler.this.exportAsDrag(component, e, TextDragHandler.this.getSourceActions(component));
                }
            }
        });
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isDefaultBehavior() {
        return this.defaultBehavior;
    }

    public void setDefaultBehavior(boolean defaultBehavior) {
        this.defaultBehavior = defaultBehavior;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new StringSelection(this.getText());
    }
}

