/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.extended.dock.FrameType;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.painter.Painter;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class WebDockableFrame
extends WebPanel {
    private static final ImageIcon dockTop = new ImageIcon(WebDockablePane.class.getResource("icons/dock_top.png"));
    private static final ImageIcon dockLeft = new ImageIcon(WebDockablePane.class.getResource("icons/dock_left.png"));
    private static final ImageIcon dockRight = new ImageIcon(WebDockablePane.class.getResource("icons/dock_right.png"));
    private static final ImageIcon dockBottom = new ImageIcon(WebDockablePane.class.getResource("icons/dock_bottom.png"));
    public static final String ID_PREFIX = "WDF";
    private String frameId;
    private FrameType frameType;
    private final WebPanel titlePanel;
    private final WebLabel titleLabel;
    private final WebButton dock;

    public WebDockableFrame() {
        this("");
    }

    public WebDockableFrame(String frameTitle) {
        this(TextUtils.generateId(ID_PREFIX), frameTitle);
    }

    public WebDockableFrame(String frameId, String frameTitle) {
        this(frameId, null, frameTitle);
    }

    public WebDockableFrame(Icon frameIcon, String frameTitle) {
        this(TextUtils.generateId(ID_PREFIX), frameIcon, frameTitle);
    }

    public WebDockableFrame(String frameId, Icon frameIcon, String frameTitle) {
        super(true);
        this.frameId = frameId;
        this.setShadeWidth(0);
        this.setWebColoredBackground(false);
        this.setPaintSides(false, false, false, false);
        this.titlePanel = new WebPanel(true){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Color.WHITE);
                g.drawLine(0, 0, 0, this.getHeight() - 2);
                g.drawLine(0, 0, this.getWidth() - 1, 0);
                g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 2);
            }
        };
        this.titlePanel.setPaintSides(false, false, true, false);
        this.titlePanel.setShadeWidth(0);
        this.add((Component)this.titlePanel, (Object)"North");
        this.titleLabel = new WebLabel(frameTitle, frameIcon);
        this.titleLabel.setMargin(3, 3, 3, 20);
        this.titleLabel.setDrawShade(true);
        this.titlePanel.add((Component)this.titleLabel, (Object)"Center");
        this.dock = new WebButton();
        this.dock.setLeftRightSpacing(0);
        this.dock.setShadeWidth(0);
        this.dock.setDrawSides(false, true, false, false);
        this.titlePanel.add((Component)this.dock, (Object)"East");
    }

    public String getFrameId() {
        return this.frameId;
    }

    public void setFrameId(String frameId) {
        this.frameId = frameId;
    }

    public void setIcon(Icon icon) {
        this.titleLabel.setIcon(icon);
    }

    public Icon getIcon() {
        return this.titleLabel.getIcon();
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void setFrameType(FrameType frameType) {
        this.frameType = frameType;
        this.setPaintSides(frameType.equals((Object)FrameType.bottom), frameType.equals((Object)FrameType.right), frameType.equals((Object)FrameType.top), frameType.equals((Object)FrameType.left));
        this.dock.setIcon(this.getDockIcon(frameType));
    }

    public void setTitlePainter(Painter painter) {
        this.titlePanel.setPainter(painter);
    }

    public Painter getTitlePainter() {
        return this.titlePanel.getPainter();
    }

    public WebPanel getTitlePanel() {
        return this.titlePanel;
    }

    public WebLabel getTitleLabel() {
        return this.titleLabel;
    }

    private Icon getDockIcon(FrameType frameType) {
        if (frameType.equals((Object)FrameType.top)) {
            return dockTop;
        }
        if (frameType.equals((Object)FrameType.left)) {
            return dockLeft;
        }
        if (frameType.equals((Object)FrameType.right)) {
            return dockRight;
        }
        if (frameType.equals((Object)FrameType.bottom)) {
            return dockBottom;
        }
        return null;
    }
}

