/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.checkbox;

import com.alee.extended.checkbox.CheckState;
import com.alee.extended.checkbox.WebTristateCheckBoxStyle;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import javax.swing.JToggleButton;

public class TristateCheckBoxModel
extends JToggleButton.ToggleButtonModel {
    public static final int MIXED = 128;
    protected boolean checkMixedOnToggle = WebTristateCheckBoxStyle.checkMixedOnToggle;

    public boolean isCheckMixedOnToggle() {
        return this.checkMixedOnToggle;
    }

    public void setCheckMixedOnToggle(boolean checkMixedOnToggle) {
        this.checkMixedOnToggle = checkMixedOnToggle;
    }

    public void setState(CheckState state) {
        switch (state) {
            case unchecked: {
                this.setSelected(false);
                break;
            }
            case checked: {
                this.setSelected(true);
                break;
            }
            case mixed: {
                this.setMixed(true);
            }
        }
    }

    public CheckState getState() {
        return this.isMixed() ? CheckState.mixed : (this.isSelected() ? CheckState.checked : CheckState.unchecked);
    }

    @Override
    public void setPressed(boolean pressed) {
        if (!this.isEnabled() || this.isPressed() == pressed) {
            return;
        }
        if (!pressed && this.isArmed()) {
            this.goToNextState();
        }
        this.stateMask = pressed ? this.stateMask | 4 : this.stateMask & 0xFFFFFFFB;
        this.fireStateChanged();
        if (!this.isPressed() && this.isArmed()) {
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiers();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            long time = EventQueue.getMostRecentEventTime();
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), time, modifiers));
        }
    }

    protected void goToNextState() {
        this.setState(this.getNextState(this.getState()));
    }

    @Override
    public void setSelected(boolean selected) {
        boolean mixed = this.isMixed();
        if (mixed) {
            this.stateMask &= 0xFFFFFF7F;
            this.stateMask = selected ? this.stateMask & 0xFFFFFFFD : this.stateMask | 2;
        }
        super.setSelected(selected);
    }

    public boolean isMixed() {
        return (this.stateMask & 0x80) != 0;
    }

    public void setMixed(boolean mixed) {
        if (this.isMixed() == mixed) {
            return;
        }
        this.stateMask = mixed ? this.stateMask | 0x80 | 2 : this.stateMask & 0xFFFFFF7F;
        this.fireStateChanged();
        this.fireItemStateChanged(new ItemEvent(this, 701, this, 3));
    }

    protected CheckState getNextState(CheckState checkState) {
        switch (checkState) {
            case unchecked: {
                return this.checkMixedOnToggle ? CheckState.mixed : CheckState.checked;
            }
            case checked: {
                return this.checkMixedOnToggle ? CheckState.unchecked : CheckState.mixed;
            }
            case mixed: {
                return this.checkMixedOnToggle ? CheckState.checked : CheckState.unchecked;
            }
        }
        return CheckState.unchecked;
    }
}

