# 一言で言うと
ユーザとインタラクションしながら重要なコンセプトを決め、そのコンセプトが含まれるようにILPな手法で要約を生成するPDS手法。Interactive Personalized Summarizationと似ている（似ているが引用していない、引用した方がよいのでは）。

# 手法
要約モデルは既存のMDS手法を採用。Concept-based ILP Summarization

フィードバックをユーザからもらう際は、要約を生成し、それをユーザに提示。提示した要約から重要なコンセプトをユーザに選択してもらう形式（ユーザが重要と判断したコンセプトには定数重みが与えられる）。
ユーザに対して、τ回フィードバックをもらうまでは、フィードバックをもらっていないコンセプトの重要度が高くなるようにし、フィードバックをもらったコンセプトの重要度が低くなるように目的関数を調整する。これにより、まだフィードバックを受けていないコンセプトが多く含まれる要約が生成されるため、これをユーザに提示することでユーザのフィードバックを得る。τ回を超えたら、ユーザのフィードバックから決まったweightが最大となるように目的関数を修正する。

ユーザからコンセプトのフィードバックを受ける際は、効率的にフィードバックを受けられると良い（最小のインタラクションで）。そこで、Active Learningを導入する。コンセプトの重要度の不確実性をSVMで判定し、不確実性が高いコンセプトを優先的に含むように目的関数を修正する手法（AL）、SVMで重要度が高いと推定されたコンセプトを優先的に要約に含むように目的関数を修正する手法（AL+）を提案している。

# 評価
oracle-based approachというものを使っている。要は、要約をシステムが提示しリファレンスと被っているコンセプトはユーザから重要だとフィードバックがあったコンセプトだとみなすというもの。
評価結果を見ると、ベースラインのMDSと比べてupper bound近くまでROUGEスコアが上がっている。フィードバックをもらうためのイテレーションは最大で１０回に絞っている模様（これ以上ユーザとインタラクションするのは非現実的）。

# 所感
評価甘すぎでは？？？十分なサイズのサンプルを得るのは厳しいからorable-based approachとりましたって書いてあるが、でもなんらかの人手評価はすべきでしょ。

そもそも、要約ってのはドキュメントを読む時間を短縮するためのものなのに、ユーザに数百単語ものフィードバックをもらうって、おかしくない？？もうドキュメント読んだ方が早いんじゃないですかね。そもそも、ユーザがどれだけこのインタラクションに協力してくれるかも不明。１０回も協力してくれる？

oracle-based approachでユーザのフィードバックをシミュレーションしてるけど、oracleの要約って、人がそのドキュメントクラスタの内容を完璧に理解した上で要約してるわけだよね？？実際にユーザが使うときは、ドキュメントクラスタの内容なんてなんも知らないわけで、そのユーザからもらえるフィードバックをoracle-based approachでシミュレーションするって、おかしくないですか？？仮に、ドキュメントクラスタの内容を完璧に理解しているユーザのフィードバックをシミュレーションするというのなら、わかる。でもそういうユーザのために要約作って提示したいわけではないですよね？？

この評価には全然納得できん。
