
/* ACML 1.0 のライセンス文
 * ref: https://github.com/Aivis-Project/ACML/blob/master/ACML-1.0.md */
export const LICENSE_ACML = `# Aivis Common Model License (ACML) 1.0

このライセンスは、AI 音声合成モデルの利用条件と制限を定めるものです。

音声合成技術の発展により、誰もが簡単に高品質な合成音声を作れるようになりました。
この技術は、創作活動はもちろん、AI との対話や新しいサービスの開発など、さまざまな可能性を広げる革新的な手段として注目されています。

現在、音声合成モデルのライセンスは制作者ごとにまちまちで、利用条件も曖昧なことが多く、使いづらい状況が続いています。
Aivis Project が策定する ACML は、音声合成モデルの自由な利用を促進しながら、制作者と利用者の双方にとって安心して活用できる環境を実現することを目指しています。

また、多くの制作者に共通のライセンスとして採用していただくことで、モデルごとの規約に気を遣うことなく、誰もが安心して音声合成モデルを利用できる環境づくりを目指しています。

このライセンスは、あなたに以下の権利を許諾します。

- ✅ **この音声合成モデルの利用・複製・改変・派生物の作成**
  - 音声合成モデルを実行して音声を生成することはもちろん、モデルの複製や改変、派生モデルの作成も自由に行えます。
- ✅ **この音声合成モデルやその派生物の配布**
  - このライセンスの条件に従う限り、改変の有無を問わず、自由に再配布することができます。

ただし、これらの権利は「できないこと（禁止事項）」に定める制限に従うものとします。

## 用語の定義

- **話者:** 話し手 (Speaker) のことをいいます。話者には「実在人物」の声と「キャラクター」の声の両方を含みます。
- **音声合成モデル:** 話者の声を AI に学習させることで制作された、テキストからその話者に近い合成音声を生成できる、重み (Weight) やパラメータのことを指します。
- **あなた:** このライセンスによって許可された行為を行う個人・法人のことをいいます。
- **このライセンス:** このライセンス自身 (Aivis Common Model License: ACML) のことをいいます。
- **この音声合成モデル:** このライセンスにより利用が許諾される音声合成モデルのことをいいます。
- **利用:** この音声合成モデルの実行、複製、改変、配布、組み込み、その他あらゆる利用形態を含みます。
- **派生物:** この音声合成モデルを基に作成された二次的著作物、改変物、または派生物を指します。

## できないこと（禁止事項）

- ❌ **音声合成モデルの元となった話者や無関係な他者の「本人」「原作者」「公式関係者」であるとの誤解を招く/騙すような利用**
  - 生成した音声を、ディープフェイクや公式なコンテンツだと誤解されるような形で公開しないでください。
  - 「※非公式です」「本人とは一切関係ありません」と明記するなど、なるべく公式なものだと誤解されないよう注意を払ってください。
- ❌ **話者のイメージ・尊厳・品位・社会的評価を「傷つける」「価値を下げる」「貶める」ような利用**
  - 第三者が『この声がこんな用途に使われるのは嫌だ』と感じるような使い方をしないでください。
    - 話者がキャラクターのときは、そのキャラクターが登場する作品に対しても同様に適用されます。
  - 具体的には、下記の禁止事項が該当します。
- ❌ **実在する人物・団体・商品などを「批判」「攻撃」「嫌がらせ」「誹謗中傷」「差別」する活動への利用**
  - 「攻撃」とは、自他を傷つけるあらゆる行為（犯罪、戦争、暴行、自傷・自殺、薬物乱用、ヘイトスピーチ、誹謗中傷、侮辱、揶揄、アンチ活動、詐欺、クラッキング、その他あらゆる身体的・精神的・社会的加害を含むがこれらに限定されない）を、実行または扇動することをいいます。
  - あなたの主張が正当であるかどうかにかかわらず、批判や攻撃を目的とした活動にはお使いいただけません。
- ❌ **人々を騙す目的で虚偽の情報やコンテンツを公開・流布する活動への利用**
    - フェイクニュースの作成や誤情報を広める目的ではお使いいただけません。
- ❌ **虚偽または誇大な表現によるマーケティングや倫理的に問題のあるビジネスへの利用**
    - 消費者の誤解を狙った悪質なマーケティング活動・倫理的に問題のある事業活動（虚偽広告、誇大広告、高額情報商材、マルチ商法、ねずみ講を含むがこれらに限定されない）やその宣伝にはお使いいただけません。
- ❌ **特定の政治的立場・政治団体・政治家・宗教団体・宗教家・排他的思想・社会的勢力・陰謀論への賛同・支援または反対・批判・非難を呼びかける活動（権利運動・署名運動・デモ・プロパガンダを含むがこれらに限定されない）への利用**
    - 「陰謀論」とは、科学的根拠や事実に基づかない主張（ワクチン、通信技術、医療、健康、社会問題などに関する誤った情報を含むがこれらに限定されない）のことをいいます。
    - あなたの主張が正当であるかどうかにかかわらず、特定の政治・宗教・排他的思想・社会的勢力・陰謀論に関する主張を広める活動にはお使いいただけません。
- ❌ **反社会的・犯罪目的での利用**
  - 話者へのなりすましによるオレオレ詐欺や、反社会的勢力による利用などを含みます。

## できること

- ✅ **上記「できないこと（禁止事項）」に該当しない、すべての個人利用・法人利用・非営利利用・営利利用**
  - 禁止事項に該当しない使い方であれば、どのような用途にも自由にお使いいただけます。
    - その際、下記の「なるべく守ってほしいこと」を尊重した利用をお願いします。
    - クレジット表記は任意です。音声合成モデルの制作者や話者のクレジット表記を行うかどうかは、あなたの判断にお任せします。
  - この音声合成モデルを他の人に配布・共有する場合は、必ずこのライセンス文書も一緒に添付してください。
- ℹ️ **この音声合成モデルを組み込んだアプリ・Web サービスを不特定多数に公開する場合:**
  - 不特定多数のユーザー or AI (LLM) が任意のテキストを入力して音声合成できる状況において、このライセンスをユーザーや LLM に完璧に遵守させることは、技術的・現実的に極めて困難であると考えられます。
  - このため特例として、（技術的に禁止事項に該当する利用を防げる状態かに関わらず）**「アプリ・Web サービスの開発元自身がこのライセンスを遵守し、現実的な範囲でなるべく禁止事項に該当する利用が起きないよう努めていれば」お使いいただけます。**

## なるべく守ってほしいこと

- ℹ️ **話者をリスペクト・尊重した利用をしてほしい**
  - 具体的にどのような使い方が「リスペクト」となるかは、あなたの良識にお任せします。
  - 話者がキャラクターのときは、そのキャラクターが登場する作品も十分にリスペクトしてください。
    - キャラクター愛・作品愛のある使い方をお願いします。
- ℹ️ **刺激の強い/万人向けでない表現を公開するときは、「見たくない人・見るべきでない人の目に入らない」よう十分配慮してほしい**
  - 表現に合わせた適切なゾーニングをお願いします。
  - ゾーニングの例:「年齢制限を掛ける」「SNS のセンシティブ設定をオンにする」「コンテンツの前に注意書きを設置する」
- ℹ️ **常識の範囲内で、良識ある利用をしてほしい**
- 上記はあくまで任意であり、遵守されていなくてもライセンス違反にはなりません。

## 免責事項

- この音声合成モデルは「現状のまま」提供されており、商品性や特定の目的への適合性、権利の非侵害などについて、明示的または黙示的を問わず、いかなる保証もありません。
- 音声合成モデルの制作者は、この音声合成モデルの利用や取り扱いまたはその結果に関連して、契約や不法行為など、いかなる形の請求や損害賠償、その他の責任についても、一切の責任を負いません。あなた自身の責任においてお使いください。
- このライセンスのいずれかの条項が無効または執行不能と判断された場合でも、残りの条項は完全に有効に存続するものとします。
- このライセンスのいずれかの条項の権利行使を行わなかったとしても、それは当該条項または他の条項の権利放棄とはみなされません。
- このライセンスはすべて日本語で提供され、日本語のみにより解釈されるものとします。

上記の免責事項は、適用される法令の下で許容される最大限の範囲で適用されるものとします。
`;

/* ACML-NC 1.0 のライセンス文
 * ref: https://github.com/Aivis-Project/ACML/blob/master/ACML-NC-1.0.md */
export const LICENSE_ACML_NC = `# Aivis Common Model License (ACML) - Non Commercial 1.0

このライセンスは、AI 音声合成モデルの利用条件と制限を定めるものです。

音声合成技術の発展により、誰もが簡単に高品質な合成音声を作れるようになりました。
この技術は、創作活動はもちろん、AI との対話や新しいサービスの開発など、さまざまな可能性を広げる革新的な手段として注目されています。

現在、音声合成モデルのライセンスは制作者ごとにまちまちで、利用条件も曖昧なことが多く、使いづらい状況が続いています。
Aivis Project が策定する ACML は、音声合成モデルの自由な利用を促進しながら、制作者と利用者の双方にとって安心して活用できる環境を実現することを目指しています。

また、多くの制作者に共通のライセンスとして採用していただくことで、モデルごとの規約に気を遣うことなく、誰もが安心して音声合成モデルを利用できる環境づくりを目指しています。

このライセンスは、あなたに以下の権利を許諾します。

- ✅ **この音声合成モデルの利用・複製・改変・派生物の作成**
  - 音声合成モデルを実行して音声を生成することはもちろん、モデルの複製や改変、派生モデルの作成も自由に行えます。
- ✅ **この音声合成モデルやその派生物の配布**
  - このライセンスの条件に従う限り、改変の有無を問わず、自由に再配布することができます。

ただし、これらの権利は「できないこと（禁止事項）」に定める制限に従うものとします。

## 用語の定義

- **話者:** 話し手 (Speaker) のことをいいます。話者には「実在人物」の声と「キャラクター」の声の両方を含みます。
- **音声合成モデル:** 話者の声を AI に学習させることで制作された、テキストからその話者に近い合成音声を生成できる、重み (Weight) やパラメータのことを指します。
- **あなた:** このライセンスによって許可された行為を行う個人・法人のことをいいます。
- **このライセンス:** このライセンス自身 (Aivis Common Model License: ACML) のことをいいます。
- **この音声合成モデル:** このライセンスにより利用が許諾される音声合成モデルのことをいいます。
- **利用:** この音声合成モデルの実行、複製、改変、配布、組み込み、その他あらゆる利用形態を含みます。
- **派生物:** この音声合成モデルを基に作成された二次的著作物、改変物、または派生物を指します。

## できないこと（禁止事項）

- ❌ **音声合成モデルの元となった話者や無関係な他者の「本人」「原作者」「公式関係者」であるとの誤解を招く/騙すような利用**
  - 生成した音声を、ディープフェイクや公式なコンテンツだと誤解されるような形で公開しないでください。
  - 「※非公式です」「本人とは一切関係ありません」と明記するなど、なるべく公式なものだと誤解されないよう注意を払ってください。
- ❌ **話者のイメージ・尊厳・品位・社会的評価を「傷つける」「価値を下げる」「貶める」ような利用**
  - 第三者が『この声がこんな用途に使われるのは嫌だ』と感じるような使い方をしないでください。
    - 話者がキャラクターのときは、そのキャラクターが登場する作品に対しても同様に適用されます。
  - 具体的には、下記の禁止事項が該当します。
- ❌ **実在する人物・団体・商品などを「批判」「攻撃」「嫌がらせ」「誹謗中傷」「差別」する活動への利用**
  - 「攻撃」とは、自他を傷つけるあらゆる行為（犯罪、戦争、暴行、自傷・自殺、薬物乱用、ヘイトスピーチ、誹謗中傷、侮辱、揶揄、アンチ活動、詐欺、クラッキング、その他あらゆる身体的・精神的・社会的加害を含むがこれらに限定されない）を、実行または扇動することをいいます。
  - あなたの主張が正当であるかどうかにかかわらず、批判や攻撃を目的とした活動にはお使いいただけません。
- ❌ **人々を騙す目的で虚偽の情報やコンテンツを公開・流布する活動への利用**
    - フェイクニュースの作成や誤情報を広める目的ではお使いいただけません。
- ❌ **虚偽または誇大な表現によるマーケティングや倫理的に問題のあるビジネスへの利用**
    - 消費者の誤解を狙った悪質なマーケティング活動・倫理的に問題のある事業活動（虚偽広告、誇大広告、高額情報商材、マルチ商法、ねずみ講を含むがこれらに限定されない）やその宣伝にはお使いいただけません。
- ❌ **特定の政治的立場・政治団体・政治家・宗教団体・宗教家・排他的思想・社会的勢力・陰謀論への賛同・支援または反対・批判・非難を呼びかける活動（権利運動・署名運動・デモ・プロパガンダを含むがこれらに限定されない）への利用**
    - 「陰謀論」とは、科学的根拠や事実に基づかない主張（ワクチン、通信技術、医療、健康、社会問題などに関する誤った情報を含むがこれらに限定されない）のことをいいます。
    - あなたの主張が正当であるかどうかにかかわらず、特定の政治・宗教・排他的思想・社会的勢力・陰謀論に関する主張を広める活動にはお使いいただけません。
- ❌ **反社会的・犯罪目的での利用**
  - 話者へのなりすましによるオレオレ詐欺や、反社会的勢力による利用などを含みます。
- ❌ **営利目的での利用**
  - 以下のような、営利を目的としない使い方でのみお使いいただけます。
    - 個人による私的な創作活動
    - 学校や大学など教育機関における教育・研究目的での利用
    - その他、営利を目的としない活動での利用

## できること

- ✅ **上記「できないこと（禁止事項）」に該当しない、すべての非営利利用**
  - 禁止事項に該当しない使い方であれば、どのような用途にも自由にお使いいただけます。
    - その際、下記の「なるべく守ってほしいこと」を尊重した利用をお願いします。
    - クレジット表記は任意です。音声合成モデルの制作者や話者のクレジット表記を行うかどうかは、あなたの判断にお任せします。
  - この音声合成モデルを他の人に配布・共有する場合は、必ずこのライセンス文書も一緒に添付してください。
- ℹ️ **この音声合成モデルを組み込んだアプリ・Web サービスを不特定多数に公開する場合:**
  - 不特定多数のユーザー or AI (LLM) が任意のテキストを入力して音声合成できる状況において、このライセンスをユーザーや LLM に完璧に遵守させることは、技術的・現実的に極めて困難であると考えられます。
  - このため特例として、（技術的に禁止事項に該当する利用を防げる状態かに関わらず）**「アプリ・Web サービスの開発元自身がこのライセンスを遵守し、現実的な範囲でなるべく禁止事項に該当する利用が起きないよう努めていれば」お使いいただけます。**

## なるべく守ってほしいこと

- ℹ️ **話者をリスペクト・尊重した利用をしてほしい**
  - 具体的にどのような使い方が「リスペクト」となるかは、あなたの良識にお任せします。
  - 話者がキャラクターのときは、そのキャラクターが登場する作品も十分にリスペクトしてください。
    - キャラクター愛・作品愛のある使い方をお願いします。
- ℹ️ **刺激の強い/万人向けでない表現を公開するときは、「見たくない人・見るべきでない人の目に入らない」よう十分配慮してほしい**
  - 表現に合わせた適切なゾーニングをお願いします。
  - ゾーニングの例:「年齢制限を掛ける」「SNS のセンシティブ設定をオンにする」「コンテンツの前に注意書きを設置する」
- ℹ️ **常識の範囲内で、良識ある利用をしてほしい**
- 上記はあくまで任意であり、遵守されていなくてもライセンス違反にはなりません。

## 免責事項

- この音声合成モデルは「現状のまま」提供されており、商品性や特定の目的への適合性、権利の非侵害などについて、明示的または黙示的を問わず、いかなる保証もありません。
- 音声合成モデルの制作者は、この音声合成モデルの利用や取り扱いまたはその結果に関連して、契約や不法行為など、いかなる形の請求や損害賠償、その他の責任についても、一切の責任を負いません。あなた自身の責任においてお使いください。
- このライセンスのいずれかの条項が無効または執行不能と判断された場合でも、残りの条項は完全に有効に存続するものとします。
- このライセンスのいずれかの条項の権利行使を行わなかったとしても、それは当該条項または他の条項の権利放棄とはみなされません。
- このライセンスはすべて日本語で提供され、日本語のみにより解釈されるものとします。

上記の免責事項は、適用される法令の下で許容される最大限の範囲で適用されるものとします。
`;

/* CC0 のライセンス文 (Markdown 版)
 * ref: https://github.com/idleberg/Creative-Commons-Markdown/blob/main/4.0/zero.markdown */
export const LICENSE_CC0 = `# Creative Commons CC0 1.0 Universal

CREATIVE COMMONS CORPORATION IS NOT A LAW FIRM AND DOES NOT PROVIDE LEGAL SERVICES. DISTRIBUTION OF THIS DOCUMENT DOES NOT CREATE AN ATTORNEY-CLIENT RELATIONSHIP. CREATIVE COMMONS PROVIDES THIS INFORMATION ON AN "AS-IS" BASIS. CREATIVE COMMONS MAKES NO WARRANTIES REGARDING THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS PROVIDED HEREUNDER, AND DISCLAIMS LIABILITY FOR DAMAGES RESULTING FROM THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS PROVIDED HEREUNDER.

## Statement of Purpose

The laws of most jurisdictions throughout the world automatically confer exclusive Copyright and Related Rights (defined below) upon the creator and subsequent owner(s) (each and all, an "owner") of an original work of authorship and/or a database (each, a "Work").

Certain owners wish to permanently relinquish those rights to a Work for the purpose of contributing to a commons of creative, cultural and scientific works ("Commons") that the public can reliably and without fear of later claims of infringement build upon, modify, incorporate in other works, reuse and redistribute as freely as possible in any form whatsoever and for any purposes, including without limitation commercial purposes. These owners may contribute to the Commons to promote the ideal of a free culture and the further production of creative, cultural and scientific works, or to gain reputation or greater distribution for their Work in part through the use and efforts of others.

For these and/or other purposes and motivations, and without any expectation of additional consideration or compensation, the person associating CC0 with a Work (the "Affirmer"), to the extent that he or she is an owner of Copyright and Related Rights in the Work, voluntarily elects to apply CC0 to the Work and publicly distribute the Work under its terms, with knowledge of his or her Copyright and Related Rights in the Work and the meaning and intended legal effect of CC0 on those rights.

1. __Copyright and Related Rights.__ A Work made available under CC0 may be protected by copyright and related or neighboring rights ("Copyright and Related Rights"). Copyright and Related Rights include, but are not limited to, the following:

    i. the right to reproduce, adapt, distribute, perform, display, communicate, and translate a Work;

    ii. moral rights retained by the original author(s) and/or performer(s);

    iii. publicity and privacy rights pertaining to a person's image or likeness depicted in a Work;

    iv. rights protecting against unfair competition in regards to a Work, subject to the limitations in paragraph 4(a), below;

    v. rights protecting the extraction, dissemination, use and reuse of data in a Work;

    vi. database rights (such as those arising under Directive 96/9/EC of the European Parliament and of the Council of 11 March 1996 on the legal protection of databases, and under any national implementation thereof, including any amended or successor version of such directive); and

    vii. other similar, equivalent or corresponding rights throughout the world based on applicable law or treaty, and any national implementations thereof.

2. __Waiver.__ To the greatest extent permitted by, but not in contravention of, applicable law, Affirmer hereby overtly, fully, permanently, irrevocably and unconditionally waives, abandons, and surrenders all of Affirmer's Copyright and Related Rights and associated claims and causes of action, whether now known or unknown (including existing as well as future claims and causes of action), in the Work (i) in all territories worldwide, (ii) for the maximum duration provided by applicable law or treaty (including future time extensions), (iii) in any current or future medium and for any number of copies, and (iv) for any purpose whatsoever, including without limitation commercial, advertising or promotional purposes (the "Waiver"). Affirmer makes the Waiver for the benefit of each member of the public at large and to the detriment of Affirmer's heirs and successors, fully intending that such Waiver shall not be subject to revocation, rescission, cancellation, termination, or any other legal or equitable action to disrupt the quiet enjoyment of the Work by the public as contemplated by Affirmer's express Statement of Purpose.

3. __Public License Fallback.__ Should any part of the Waiver for any reason be judged legally invalid or ineffective under applicable law, then the Waiver shall be preserved to the maximum extent permitted taking into account Affirmer's express Statement of Purpose. In addition, to the extent the Waiver is so judged Affirmer hereby grants to each affected person a royalty-free, non transferable, non sublicensable, non exclusive, irrevocable and unconditional license to exercise Affirmer's Copyright and Related Rights in the Work (i) in all territories worldwide, (ii) for the maximum duration provided by applicable law or treaty (including future time extensions), (iii) in any current or future medium and for any number of copies, and (iv) for any purpose whatsoever, including without limitation commercial, advertising or promotional purposes (the "License"). The License shall be deemed effective as of the date CC0 was applied by Affirmer to the Work. Should any part of the License for any reason be judged legally invalid or ineffective under applicable law, such partial invalidity or ineffectiveness shall not invalidate the remainder of the License, and in such case Affirmer hereby affirms that he or she will not (i) exercise any of his or her remaining Copyright and Related Rights in the Work or (ii) assert any associated claims and causes of action with respect to the Work, in either case contrary to Affirmer's express Statement of Purpose.

4. __Limitations and Disclaimers.__

    a. No trademark or patent rights held by Affirmer are waived, abandoned, surrendered, licensed or otherwise affected by this document.

    b. Affirmer offers the Work as-is and makes no representations or warranties of any kind concerning the Work, express, implied, statutory or otherwise, including without limitation warranties of title, merchantability, fitness for a particular purpose, non infringement, or the absence of latent or other defects, accuracy, or the present or absence of errors, whether or not discoverable, all to the greatest extent permissible under applicable law.

    c. Affirmer disclaims responsibility for clearing rights of other persons that may apply to the Work or any use thereof, including without limitation any person's Copyright and Related Rights in the Work. Further, Affirmer disclaims responsibility for obtaining any necessary consents, permissions or other rights required for any use of the Work.

    d. Affirmer understands and acknowledges that Creative Commons is not a party to this document and has no duty or obligation with respect to this CC0 or use of the Work.
`;

/* デフォルト音声サンプルの Data URL */
export const DEFAULT_VOICE_SAMPLE_DATA_URL = 'data:audio/wav;base64,UklGRvysAABXQVZFZm10IBAAAAABAAIARKwAABCxAgAEABAAZGF0YUSsAAABAAAA/v8AAAIAAAD+/wAAAgAAAP//AAAAAAAAAAAAAAAA//8BAAIA/v/+/wIAAgD///7///8BAAMAAAD8/wAABAD///z/AwAEAPz//P8EAAQA/f/8/wEABAAAAPz/AQAEAP///P8BAAQA///9/wAAAgABAP////8AAAAAAQABAP7//v8CAAMA///8/wAABAABAPz//v8EAAIA/f///wIAAAD+/wEAAgD///7/AAADAAEA/f///wIAAQD+/wAAAgD+//7/AwADAP3//f8CAAIAAAD///7/AAACAAEA/////wAAAQABAP////8AAP//AQACAP///v8BAAMA///9/wAAAgABAP7///8CAAEA/////wEAAQD/////AAABAAEA/////wEAAAD//wEAAgD+//z/AwAGAP7/+f8AAAYAAQD9////AAABAAIAAAD+////AAABAAEA/////wEAAAD//wIAAgD9//3/AgADAP///f8AAAMAAQD+////AQAAAP//AQABAP//AAAAAP//AAABAAEA/////wEAAQAAAP////8AAAEAAQD/////AgABAP7///8CAAEA/f///wMAAAD+/wEAAgD///3/AQADAP///v8BAAAA//8CAAIA/f/+/wMAAgD+//7/AAABAAEAAQAAAP7///8DAAIA/P/+/wMAAAD//wIAAAD+/wAAAQAAAAAAAAD//wAAAQABAP////8CAP///f8DAAMA+//9/wcAAgD6////BAABAP3///8BAAEAAAD+/wEAAgD/////AQAAAP7/AgACAP3///8CAAAA//8BAAAA//8BAAAA//8BAAEA/v///wIAAQD/////AQABAP7/AAACAP///v8BAAMAAAD+////AAACAAAA/v8AAAEAAAAAAAIAAAD9/wAAAgAAAP////8AAAEAAQD/////AwABAPz///8DAAEA/f///wIAAQABAP///v8BAAIA///+/wEAAQD//wEAAgD+//z/AgAFAP///P8AAAMAAAD+/wAAAQAAAAAAAAD//wAAAgAAAP7///8BAAIAAAD+////AQABAAAA/////wIAAgD9//7/AwABAP3/AQADAP3//v8EAAAA/P8CAAMA/P///wUAAAD8/wAAAgD//wAAAgD///7/AAACAAEA/v///wIAAgD+//7/AQABAAAA//8AAAEAAAD/////AQABAP//AAABAP///v8CAAMA/P/9/wUAAgD8////AgAAAP//AgAAAPz/AgAFAP7/+/8AAAQAAQD+//////8CAAMA/v/8/wEABQD+//v/BAADAPz//v8DAAIA/v/+/wAAAgABAP///////wEAAgD+//7/AwACAP3///8CAAAAAAD///7/AgADAP7//f8DAAMA/P/+/wQAAQD9////AQABAAEA///+/wEAAgD//wAAAQD+////AwABAPz///8EAAIA/f/9/wMAAwD9//7/AgABAP7/AAACAP////8CAP///f8CAAQA/v/7/wEABQAAAPv///8FAAEA/P8AAAMAAAD+////AQACAP///v8BAAIA/////wEAAAAAAAAAAAABAP////8BAAAA//8AAAIAAAD9/wAAAwABAP7//v8BAAEAAAABAP///v8AAAIAAgD///7///8BAAMAAAD9////AgABAP//AAD/////AwABAPz/AAAEAP///f8BAAEAAAAAAP//AAACAAAA/f8AAAQAAAD8////AwACAP/////+/wAAAwAAAP7/AAABAAAA//8AAAEAAAD+/wEAAwD+//3/AwACAPz//v8EAAMA/f/9/wIAAgD///7/AQABAP//AQAAAP//AQABAP///v8BAAIA/v/+/wIAAwD///3/AQADAP///f8AAAIAAQD/////AQAAAP7/AgACAP3///8EAAAA+/8BAAQA/v/+/wIAAQD//wAAAAD//wEAAQD+////AwABAP3/AAADAAAA/f///wIAAQD//wAAAQD/////AgABAP7///8BAAAAAAABAP///v8BAAMA///9/wIAAgD+//7/AQADAAAA/P///wUAAgD6//7/BgACAPv//v8EAAEA/v8AAP////8DAAIA/f/+/wIAAQD/////AAABAAAAAAABAP///v8BAAMA///8/wAABAACAPz//f8EAAMA/f/+/wIAAAD//wIAAAD9/wAABAABAPz//v8EAAMA/P/8/wMABAD+//3/AgACAP////8AAAAAAAABAAAA/v8AAAMAAQD8////BQAAAPv/AQAEAP7//v8DAAAA/f8BAAIA/v///wIA/////wMAAAD9/wEAAgD+////AgD/////AgD//wAAAgD9////BQAAAPv/AQAEAP7//v8BAAAAAQABAP3///8EAAEA/P/+/wQAAgD9////AgABAP7//v8CAAIA/v/+/wMAAQD9/wEAAgD9////BAD///3/AgABAP7/AAABAP//AAACAAAA/v///wEAAgAAAP7/AAABAP//AQACAP7//f8CAAQA///8/wAAAwABAP7//v8BAAIAAAD/////AAACAAAA/f8BAAMA/v/9/wMAAgD8/wAABAD///3/AQADAP7//f8CAAIA/////wEAAQD//wAAAAD+/wEAAwD+//3/AwADAPz//v8FAAAA+v8CAAYA/f/6/wIABgD///v/AAADAAEA////////AAADAAAA/P8BAAMA/v///wMAAAD8/wEABAD+//7/AQAAAAAAAQAAAP7/AQADAP7//f8CAAMA/v/9/wIAAwD+//3/AgACAP///////wEAAgD///7/AAACAAEA///+////AwACAPz//v8EAAIA/f/+/wIAAgD///7/AAACAAEA///+////AwACAPz//v8FAAIA/P///wIAAAAAAAAA/v///wMAAgD+////AQABAAAA/v///wIAAQD+////AgABAP////8AAAEAAQD///7/AQACAP7///8DAAAA/f8BAAMA/v/+/wIAAAD//wEAAAD//wEAAQD/////AAABAAEA/v/+/wMAAwD8//3/BAADAP3//f8CAAMA///+/wAAAAD//wEAAwD///3/AQACAAAA////////AAACAAEA/////wAAAQAAAP//AAABAAAA//8AAAEAAQD///7/AAACAAEA/v///wMAAQD9////AgABAP///v8AAAMAAQD9////AgAAAAAAAQD+////AwAAAP3/AAACAAEA/v/+/wIAAwD+//3/AwACAP3///8BAAAAAAABAP///v8CAAMA///9/wAAAgAAAP///////wIAAwD///3/AAACAAAA//8AAP////8CAAMA///8/wAABAABAP3//v8BAAIAAAD+/wAAAgAAAP//AQAAAP7/AAABAAAAAQAAAP7/AAACAAAA/v8AAAIAAAD+/wAAAgABAP3//f8EAAUA/P/6/wMABgD9//v/AgADAP//AAABAP////8BAAEA///+/wAAAwACAPz//f8FAAQA+//7/wUABAD7//7/AwABAAAAAAD+////AwAAAP3/AQABAP//AQABAP////8BAAAA//8AAAAAAAABAAAA//8BAAEA/v8AAAEA/v8AAAIAAAD//wEAAQD+////AQABAP///v8CAAMA/v/9/wIAAwD+//3/AAACAAEAAAD/////AQABAP////8BAAEA/v///wMAAQD9////AgABAP//AAABAP////8AAAEAAQD///7/AQADAP///f8BAAIA/////wAAAAABAAEA/v/+/wIAAgD+////AQAAAAEAAQD+////AgAAAP7/AQABAP7/AAADAAAA/f8AAAIAAAD+/wAAAgAAAP//AAAAAAAAAAABAAAA/v8AAAIAAQAAAP7//v8BAAMAAQD9////AwABAP7///8BAAAA//8AAAIAAgD+//z/AgAFAP3/+/8DAAQA/v/+/wIAAAD//wEA///+/wEAAwAAAP3/AAADAAAA/f8BAAIA/v8AAAIA/////wEA/////wIAAQD+/wAAAQAAAAAA/////wEAAgD///3/AQACAAAA/////wEAAgAAAP3///8DAAEA/v///wAAAAACAAEA/f///wMAAAD+/wEAAAD//wEAAAD//wEAAQD+////AgABAAAA///+/wEAAwD///z/AgAEAP7//f8BAAIAAAD+//7/AwAFAPz/+v8DAAUA///8////AwADAP///f8AAAEA//8AAAIAAAD9/wAABAAAAPz/AAADAP///v8CAAEA/v8AAAAA//8CAAEA/f///wQAAgD8//7/AgABAP//AAACAP///f8BAAQAAAD7////BQACAPz///8DAP7//v8EAAEA+/8AAAUA///9/wIAAQD+/wEAAQD9/wAAAwAAAP///////wIAAgD9////AwD///7/AgABAP7/AAABAP//AQACAP3//f8EAAQA+//8/wUAAwD8////AwD///7/AgABAP7///8BAAEAAAAAAP////8BAAIA///+/wEAAQD//wAAAQD/////AQAAAAAAAQD/////AgABAP3///8CAAEA/////wAAAQABAP////8BAAAA//8BAAEA//8AAAAA//8BAAIA/v/9/wMABAD9//z/AwAEAP3//f8CAAEA//8BAAAA/v8BAAIA/////wAAAAAAAAEAAQD+//7/AgADAP///P8AAAQAAQD9//7/AgACAP////8AAAAAAQAAAP7/AQADAP7//P8DAAQA/P/9/wQAAgD8//7/BAADAP3//P8DAAQA/f/9/wEAAgABAP///v8AAAMAAQD9//7/AgACAAAA///+////AwADAP3//P8CAAQA///8/wEABAD///3/AgACAP3///8CAAAAAAAAAP//AgACAP3//v8CAAEAAAAAAP7///8DAAEA/f8AAAEAAAABAP///v8BAAIAAAD+////AQABAAAAAAD///7/AgAEAP3//P8DAAMA/v/+/wEAAQD//wAAAQAAAP//AAABAP////8BAAAAAAABAAAA//8AAAAA//8CAAAA/P8BAAUAAAD8////AgABAP////8BAAEA//8AAAEA/v///wMAAQD+////AAABAAIA/v/9/wIAAwD///7/AQAAAP//AQABAP///v8CAAIA/P///wUAAQD7////BAABAP/////+/wAAAwABAP3///8CAAAAAAABAP////8BAAAA//8AAAEAAAD//wAAAQABAP///v8BAAIA///+/wEAAgD///7/AAACAAEA////////AAACAAAA/f8BAAMA/v/+/wMAAgD8//3/BAADAP3//f8CAAMA///+/wEAAQD+/wAAAwAAAPz/AAAEAAAA/f///wEAAQABAAEA/v/+/wEAAgAAAP7///8AAAIAAgD///7/AAABAP//AAACAP///f8BAAUAAAD7////AwACAP///f///wMAAgD9//7/AwACAP7///8BAAEA///+/wAAAgABAP////8BAAIAAAD9//7/AgADAP///f8BAAMA/////wEA/f///wYAAQD5////BgAAAP3/AAAAAAEAAgD///z/AQAFAP7/+/8CAAUA///8/wAAAgABAAAA/v/+/wIAAwD///7/AAABAAEA/////wEAAAD//wAAAQAAAP//AQAAAP//AQABAP///v8BAAIA/////wEAAQD///7/AQACAAAA/////wAAAgABAP7//f8CAAQA/f/8/wQABAD7//z/BgAEAPr//P8FAAQA/f/8/wEABAAAAP3///8CAAEA/v8AAAMAAAD8/wAABQD///r/AQAFAAAA/v8AAAAAAAABAAAA/f8AAAQAAAD9/wEAAwD+//7/AwAAAPz/AAAEAAEA/f///wIAAgD///7/AAABAAAAAAAAAP//AQACAP///v8AAAIAAQD+//7/AgADAP7//v8CAAAA/v8BAAEA/v8AAAMA///9/wIAAwD9//3/AwACAP3///8DAAAA/f8BAAIA/////wAAAQABAP///v8BAAMA/v/9/wMAAgD9////AgAAAP//AQAAAP//AgABAP3///8CAAEAAAD///7/AQAEAP//+/8BAAUAAAD8////AwABAP7/AAABAP7/AAADAAAA/v8AAAAAAAACAP///f8CAAMA/v/+/wMAAQD8////AwACAP7//f8CAAMA///+/wAAAQAAAAAAAAD//wEAAQD/////AAABAAAA//8AAAIAAQD+//7/AQADAP//+/8BAAYAAAD6/wAABQD///3/AgABAP3/AAAEAP///P8CAAMA/f/+/wQAAQD8/wAAAgD//wAAAQD/////AQABAAAA/////wIAAQD9/wAAAgD+/wAAAwD+//3/BAADAPz//f8DAAMA/v/8/wEABQD///z/AQACAP//AAACAP///v8BAAAAAAACAP7//P8EAAYA/P/5/wQABgD7//z/BQACAPz///8DAAEA///+//7/AwAEAP3//P8CAAQAAAD9//7/AQADAAAA/v8AAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//8AAAIAAAD+/wAAAgAAAP7///8BAAIAAQD9//7/AwADAP7//P8BAAQAAAD8////BQABAPv/AAAFAP//+/8BAAQA///+/wEAAAAAAAIA///9/wEAAwD+//7/AgABAAAAAAD/////AQACAP///v8AAAEAAgAAAP7/AAABAAAA//8AAAEA//8AAAEAAAAAAP//AAABAP////8BAAEA//8AAAEA/v///wMAAQD9////AgABAP////8BAAAA//8CAAEA/f/+/wIAAgAAAP///v8BAAMA///9/wEAAgD+/wAAAwD+//3/AgADAP///f8AAAIAAQD///7/AAADAAIA/v/8/wEABAD///3/AAACAAIA///9/wAAAwD///3/AwADAP3//f8CAAIA/v/+/wIAAgD+////AwAAAP3/AAACAAEA///+/wAAAgABAP7///8CAAEA/////wEAAQD+//7/AgADAP///P8AAAQAAQD9//7/AgACAP7///8CAAAA/f8BAAQA/v/8/wIAAwD/////AAD//wEAAgD+//3/AgADAP7//v8DAAEA/f8AAAIA/////wEA/////wMAAQD8/wAABQD///v/AQAEAP7//P8CAAMAAAD+////AwACAPz//f8EAAIA/P///wMAAQD+/wAAAgAAAP7///8CAAEA/v///wEAAgAAAP7///8BAAIAAAD+////AgACAP3//v8DAAEA/f8AAAMA/////wEA/////wEAAQAAAP////8BAAEA//8AAAAA//8AAAIAAAD+/wAAAAABAAIA/v/9/wIABAD+//z/AgADAP///v8AAAEAAAAAAAAAAAABAAAA//8AAAAAAAAAAAAAAAAAAAEAAAD//wAAAAD//wEAAwD+//z/AwAEAPz//P8EAAMA/f///wIAAAD+/wAAAgAAAP7/AAACAAEA/v/+/wIAAgD+//7/AwACAPz//v8EAAEA/f8BAAIA/v///wIAAAD+/wEAAQD//wEAAAD+/wAAAQABAAEA/v/+/wMAAgD9//7/AQACAAEA/v/+/wMAAQD8/wAABAD///z/AgAEAP///P///wQAAQD9/wAAAgD///7/AgACAP7//v8BAAEAAQAAAP3/AAADAAAA/f8AAAMA///9/wEAAwABAP3//v8CAAIA/v/+/wIAAQD//wAAAAAAAAEAAAD+/wAAAgD/////AgAAAP3/AAADAAAA/v8AAAEAAQAAAP7///8CAAEA/v8AAAIA///+/wEAAwAAAP3///8CAAEA/////wAAAQABAAAA/////wEAAQD/////AAACAAEA/v/+/wEAAwD///3/AQACAAAA//8AAAAAAAABAP////8CAAEA/f///wQAAAD8/wEABAAAAPz/AAAEAP7//f8DAAIA/f///wMA///+/wMAAAD9/wEAAgD/////AAAAAAEAAQD+////AwAAAP3/AAACAAEA/////wAAAQABAP///v8BAAIA/////wEAAQD/////AQAAAAAAAAD//wEAAAD//wEAAQD/////AgAAAP3/AQACAP///v8AAAMAAgD9//3/AwADAP3//f8BAAMAAQD9//7/BAADAPv//f8FAAIA/P///wMAAAD+/wEAAAD+/wIAAwD9//z/AwAFAP3/+/8CAAQAAAD8////BAAAAP3/AQACAP7///8DAAAA/f8AAAIAAAD//wAAAQABAP7//v8DAAMA/f/8/wIAAwD//wAAAAD+/wIAAwD9//3/AgACAP////8AAAAAAgABAP3///8DAAAA/f8AAAIAAAD//wAAAQAAAAAAAAD/////AQACAP7///8EAP//+/8CAAYA/f/6/wMABQD///z/AAADAP////8BAP//AAACAP///v8CAAIA/f/+/wIAAQAAAAAA//8AAAIAAAD9////AwACAP7//f8BAAMA///+/wIAAQD+/wAAAgD///7/AQAAAAAAAgD///7/AgACAP7//v8BAAEAAAAAAP//AAACAAAA/f8AAAMAAAD+/wAAAQABAP///v8AAAEAAAAAAAEA/////wMAAQD8//7/AgACAAAA///+/wAABAABAPz///8DAAAA/v8BAAEA/////wEAAgD///7/AQACAP///v8BAAIA///+/wEAAgD///7/AgABAP3/AQADAP7//f8CAAIA/v8AAAIA///9/wEAAwD///7/AAABAAEA///+/wIAAwD9//3/AwACAP7/AAAAAP7/AQADAAAA/f///wMAAgD9//3/AwADAP7//f8BAAMA///9/wEAAgAAAP////8AAAMAAQD7////BQAAAP3/AQABAP//AAABAAEA///+/wEAAgD///7/AQABAP//AQAAAP7/AQACAP///v8AAAIAAQD+//7/AgACAP3///8EAAEA/P///wQAAQD9////AQAAAAAAAgAAAP3/AAADAAAA/v8BAAEA/v///wMAAQD8/wAAAwD/////AQABAP///v8AAAIAAgD+//7/AQAAAAEAAQD+//7/AQADAAAA/v///wEAAgD///7/AAABAAEAAAD/////AQACAP///f8AAAMAAQD9//7/AwADAP7//f8BAAIA//8AAAEA/v///wMAAQD9////AgABAP////8BAAEA/////wEAAAD+/wEAAgD/////AAABAAEA///+/wEAAgD+////AgAAAP7/AAACAAAAAAAAAP//AAAAAAAAAAAAAAAA//8BAAIA///+/wAAAgABAP7//v8BAAIAAAD+////AQACAAAA/f8AAAQAAAD8/wAAAwD///7/AQABAAAAAAD//wAAAwD///z/AgADAP7//v8CAAEA/v8AAAEAAAAAAAAA//8AAAIAAAD+/wAAAQAAAAAAAAD//wAAAgAAAP3/AQADAP7//v8CAAEA/v8AAAIA///+/wIAAgD9//7/AwACAP7//v8BAAEAAAAAAAAAAAD//wEAAQD+/wAAAgAAAP7/AAACAP////8CAAAA/v8AAAEAAAAAAAEA/////wEAAAAAAAAA/v8AAAMAAQD+////AAABAAEA/v///wIAAQD/////AQACAP///f8AAAMAAAD+/wEAAQAAAP////8BAAAA//8AAAEAAAD//wIAAAD9/wEAAgD+//7/AwABAP3/AAACAAAA//8AAAAAAQABAP7///8CAAEA/v///wEAAAABAAIA///9/wEAAwD///7/AAABAAAA//8CAAEA/P///wUAAQD7/wAABAD///7/AAABAAEA/////wEAAQD/////AQAAAAAAAQAAAP////8BAAIA///9/wAABAABAPv/AAAFAP///P8BAAIA//8AAAEA/////wEAAgAAAP3///8EAAEA+////wUAAQD8/wAAAgD//wEAAgD+//3/AQADAAAA/f/+/wIAAwAAAP////8AAAEAAAD//wAAAAD+/wEAAwD/////AQAAAP//AAABAAAA/////wEAAwD///z/AQADAP////8BAAAAAAABAP///v8BAAIA///+/wEAAgD///7/AQABAP//AAACAP///f8CAAMA/v/9/wEAAwAAAP7///8BAAIA///+/wEAAQD//wEAAQD+/wAAAQD//wAAAQD//wAAAgD///7/AQACAAAA/f8AAAMAAAD+/wAAAQD//wAAAgAAAP7///8CAAEA/////wAAAgAAAP3/AAAEAAAA/P8BAAIA/v8BAAIA/f/+/wMAAgD///////8AAAIAAAD+/wAAAgD///7/AwABAPz///8EAAEA/P8AAAMA/////wEAAAD//wAAAQAAAP//AAABAAEA/////wEAAAAAAAAA//8AAAEAAgAAAPz///8EAAIA/f/9/wIAAgD/////AAABAAAAAAAAAP//AQAAAP//AAAAAAEAAQD/////AAAAAAEAAAD//wIAAQD+//7/AQABAP//AQAAAP//AgABAP///f///wQAAQD8/wAAAwAAAP//AQAAAP7/AQACAP7///8CAAAA/v8AAAMAAAD9/wEAAgD//wAAAQD///3/AQAFAP//+/8BAAQAAAD9/wAAAgD/////AQABAAAA/v8AAAIAAAD/////AQABAP7/AAADAAAA/P8AAAUAAAD7////BAACAP7//v8AAAEAAQABAP7//v8CAAEA//8AAAAA/v8BAAQA/v/9/wIAAAD+/wMAAgD6//7/CAACAPj///8GAAAA/f8AAAIAAQD+//7/AgADAP3//f8DAAIA/v8AAAEA//8AAAEA//8AAAIA///+/wEAAQAAAP///v8BAAQAAAD8/wEAAgD+////AgAAAP7/AQABAAAAAQD///7/AQADAP7//P8DAAQA/v/8/wEABAAAAP3///8CAAIA///+/wEAAgD///3/AQADAP////8BAP////8DAAEA+////wUAAQD9//7/AgACAP////8AAAAAAAAAAAEAAAD//wAAAAABAAEA/v///wIAAAD+/wEAAgD+////AgAAAP//AAABAAAA/v8BAAIA/////wAAAAAAAAEAAAD//wAAAAABAAEA/v///wEAAAABAAEA/f///wQAAAD8/wEAAwD+//7/AgACAP///v8AAAEAAAAAAAAA//8AAAEAAQAAAP7///8CAAEA/v8AAAIA///+/wEAAgAAAP7//v8CAAQA/v/8/wIAAwD9//7/BAABAPz/AAAEAAAA/f8AAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//AQACAP7//f8BAAQAAAD7/wAABAABAP7//v8BAAIAAAD+////AwABAPz/AAAEAAAA/f8AAAIAAAD//wEA///+/wIAAgD///7///8BAAIAAAD+/wAAAgAAAP//AAAAAP////8BAAIA///+/wEAAgD/////AQAAAAAAAAD//wAAAQD/////AgAAAP7/AgACAP3//v8DAAEA/v8AAAEA//8AAAIA///+/wEAAQD//wAAAQD//wAAAQD//wAAAQD/////AgABAP3///8DAAEA/f///wMAAAD+/wEAAQD//wAAAAD//wEAAgD///3/AAAEAAEA/P/+/wMAAgD///////8BAAEA//8AAAAA//8BAAIA/v/9/wIAAwD///7/AAABAAEAAAD+////AQABAAAA/////wIAAgD+//7/AQABAAAAAAD//wAAAgD/////AgD///3/AgAEAP7//f8BAAEAAQAAAP7/AAACAAAA/v///wEAAQD/////AgABAP7/AAABAP7/AAACAP7//v8EAAIA+////wUAAAD8/wEAAwD9//7/BAABAP3///8CAAEA/////wAAAgABAP3//v8EAAIA/P/+/wIAAgAAAP//AAAAAAAAAAABAAAA/v8AAAIAAQD+//7/AwACAP3///8CAAAA/v8AAAIAAQD///7/AAADAAAA/f8AAAEAAAABAAAA//8AAAAAAAABAAEA/v///wIA/////wMAAQD8////BAABAP7//v8AAAIAAQAAAP7///8DAAIA/f/8/wMABAD+//3/AAACAAEA//8AAAAA/v8BAAQA/v/7/wIABQD///z///8CAAMA///9/wIAAgD9/wAAAwD+//7/AgABAP//AQABAP3///8DAAEA/f///wQAAQD8/wAAAwD///7/AgABAP3/AAAEAP///P8BAAQA///8/wEAAwABAP7//P8CAAUA/v/8/wEAAgAAAAAA/////wIAAQD9/wAAAwD///7/AQACAAAA/v8AAAEAAAAAAAAAAAD//wAAAQAAAAEAAAD+/wAAAgAAAP3/AAADAAAA/v8AAAEAAAAAAAAA/////wEAAgD///7/AQACAP////8CAP///v8CAAAA/v8CAAEA/f8BAAMA/v/+/wIAAQD///////8CAAIA/f/+/wMAAgD+//7/AAACAAIA/v/9/wIAAwD+//7/AQABAAAA//8AAAEAAQD+//3/BAAEAPv//P8FAAQA+//9/wQAAgD+//7/AAACAAIA///9/wEAAwD///3/AAACAAEAAAD//wAAAQD/////AQABAP////8BAAEAAAD/////AQABAP//AAABAP////8BAAEA/////wEAAQAAAP//AAACAP///f8BAAMA///9/wEAAwD///7/AgABAP3///8DAAEA/v///wEAAQAAAP////8BAAEAAAD///7/AgADAP3//f8EAAQA+//8/wQAAgD+////AAABAAEA/////wIAAQD8/wAABQD+//v/AwAEAP3//v8DAAAA/v8BAAEA/////wEAAQAAAP7///8DAAAA/f8BAAMA///9/wEAAgD/////AQABAP///v8BAAMA///9/wEAAwAAAP3///8CAAEA//8AAAAAAAACAAAA/f8AAAIA/////wIAAAD+/wEAAgD///7/AAABAAIAAAD9/wAAAwAAAP3/AAACAP//AAABAAAAAAD//wAAAgAAAP3///8EAAIA/P/9/wQAAwD7//7/BQACAP3//v8BAAIAAAD9////AwABAP//AAAAAP//AAABAAAA//8AAAEAAAD//wEAAAD//wEAAAD//wEAAQD+////AgAAAP//AQABAP///v8AAAMAAAD9/wEAAgD+/wAAAwD+//z/AwADAP7///8BAAAA//8AAAEAAAD//wAAAQAAAP//AAABAAAA/v///wMAAgD8//7/BAACAP3//v8CAAEA//8BAAAA/v8AAAIAAAD//wAA//8AAAMAAQD9//7/AgACAP7///8CAP////8CAAEA/v/+/wIAAgD///7/AAACAAAAAAAAAP7/AQACAP7//v8DAAEA/f8BAAMA///9/wEAAwD///3/AAADAAIA/v/9/wAAAwABAP7///8BAAEAAAAAAAAA/v///wIAAQD/////AQABAAAAAAD//wAAAAAAAAEA//8AAAEA//8AAAEAAAD+/wAAAwAAAP7/AAACAAAA/f8AAAIAAAAAAAAA//8AAAIAAAD+/wAAAQAAAAAAAQD///3/AgAEAP7//P8BAAMAAAD///////8CAAIA/v/+/wEAAQAAAAAA/////wMAAQD8/wAABAD///z/AgADAP7///8AAAAAAQAAAP//AAACAAAA/v8AAAEAAAAAAAAA//8AAAIA///+/wIAAgD+//7/AgACAP7//v8BAAEAAAABAP///v8CAAIA/f///wQA///8/wMABAD9//v/AgAFAAAA/P/+/wQAAwD9//3/AQACAAAA//8AAAEAAAD//wAAAAAAAAEAAAD+/wAAAwAAAP3/AAADAP///f8CAAMA/v/9/wIAAwD+//3/AgADAP7//v8CAAAA//8BAP///v8CAAMA///9/wAAAgAAAP//AAD//wAAAwAAAPz/AQAEAP7//f8CAAEA//8BAAAA/v8AAAMAAQD9//7/AgADAP///f8AAAIAAgD+//3/AgADAP///f8BAAMA///9/wAAAwABAP7//v8BAAMA///9/wAAAgABAAAA///+/wIAAwD9//z/AgAEAAAA/f///wIAAgD///3/AAADAAEA/v/9/wEABAAAAPz///8EAAIA/f/9/wIAAwD+//7/AQABAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAD//wAAAAAAAAAAAAAAAAAAAQAAAP//AAAAAAAAAAAAAP//AAADAAAA/f8AAAEAAAABAP///f8CAAQA/f/+/wMAAAD9/wEAAwD+//3/AQACAAEA///+/wAAAgAAAP7/AAACAAAA/v8BAAEA/v8AAAIA///+/wIAAgD+////AQAAAAAAAQD///7/AgACAP7///8BAAEAAAD/////AAACAAEA///+////BAABAPv/AAAEAP///f8CAAIA/v///wEAAQAAAP////8AAAEAAQAAAP7/AAACAP////8CAAAA/f8AAAQAAAD8/wAAAwD///7/AgABAP7/AAACAAAA/v8AAAEAAAAAAP////8CAAIA/v/+/wIAAQD//wAA/////wMAAgD8//7/BAACAP3//f8BAAMAAAD+/wAAAQAAAAAAAQD///7/AQABAP////8BAAEA//8AAAEAAAAAAAAA/v8AAAMA///9/wIAAwD+//7/AgABAP///v8AAAMAAQD9////AwABAP7///8AAAAAAgABAPz///8FAAEA+////wQAAAD+/wAAAAABAAIA/v/9/wIAAwD+//3/AQADAAEA/v/+/wEAAgAAAP7///8BAAIAAAD+/wAAAgAAAP7/AAABAAAAAAABAAAA/f8AAAQAAQD8//3/AwADAP////8AAP////8CAAIA/f/+/wMAAQD+/wAAAgAAAP7/AAABAP////8BAAIAAAD9/wAABAABAPz//v8DAAEA/v8BAAEA/v8AAAIAAAD+/wAAAgAAAP//AAABAAAA/v8AAAEAAAAAAAAAAAAAAAEAAAD+/wAAAgD///7/AgABAP7/AAABAAAAAAD/////AgABAP3///8DAAAA/v8BAAAA//8BAAEA///+/wEAAgD///7/AQACAP////8BAAAA//8BAAEA/v///wIAAgD+//3/AgADAP///v8AAAEAAAAAAAAA//8AAAEAAAAAAAAAAAABAAAA//8AAAAA//8AAAIA///+/wQAAgD6////BwD///n/AgAFAP///v8AAP//AAADAAAA/f8AAAIAAQD///7/AAACAAEA///+/wEAAwD///z/AAAEAAEA/P/+/wQABAD9//r/AgAGAP//+////wQAAgD9//7/AQACAAAA/////wAAAwAAAPv/AAAFAAAA/f8BAAEA/v8AAAIA///+/wEAAgAAAP//AAAAAP//AAABAAAAAAAAAAAAAAAAAAAAAAAAAP//AQACAP7//v8DAAMA/P/8/wMABQD///r/AAAGAAEA+v/+/wUAAgD9//7/AgADAP7//P8CAAQA/f/9/wMAAQD+/wEAAgD+//7/AgACAP///v///wEAAQAAAAAAAAAAAAAAAAABAAAA/v///wEAAQAAAAEAAAD+/wAAAwAAAPz/AAAEAP///f8CAAIA/v8AAAIA/v/+/wMAAQD9/wAAAwAAAP3/AAACAAAAAAAAAP7/AAADAAAA/f///wIAAgD///7/AQABAP7/AAADAAAA/f///wMAAQD9////AwABAP3/AQADAP7//v8AAAAAAgACAP3//f8EAAMA/f/9/wEAAgAAAAAAAAD//wAAAQAAAP7/AAADAAAA/v///wEAAgAAAP3//v8EAAQA/f/8/wEAAwAAAP7///8BAAMAAAD8/wAABAD///z/AQAEAP///v8BAP//AAACAP///v8BAAIA//8AAAIA/v/9/wIAAwD+//3/AgADAP///v8BAAIA///9////BAACAPv//v8FAAIA+////wYA///6/wIABQD+//z/AQACAAEAAAD+/wAAAgD///7/AgACAP7///8BAAAAAQAAAP3/AAAEAAEA/P///wQAAAD8/wAABAABAPz///8EAAAA/f8BAAEA/v8AAAIAAAD//wAA//8AAAMAAQD8//3/AwAEAP///f8AAAEAAAABAAAA/v///wIAAgD/////AAAAAAAAAQAAAP3/AAAEAAEA/P/+/wUAAgD7//7/AwACAP///v8AAAMAAQD8//7/BAACAPz///8EAAAA/P8BAAMA/v/+/wMAAgD9//7/AQABAAEA/////wEAAQAAAP//AAAAAP//AQACAP///f8BAAMA/v/+/wMAAQD+/wAAAAD//wEAAQD+////AwABAP7/AAAAAP7/AQAEAP7/+/8CAAUAAAD8//7/AgACAAAA//8AAAAA//8BAAIA///9/wAAAwABAP7///8BAAEAAQD///3/AAAEAAEA/P///wMAAQD///7///8CAAMA///8/wAABAABAP3///8CAP////8DAAAA/P8BAAQA///+/wEAAAD+/wEAAwD///3/AAADAAIA/f/9/wIAAwD///7/AQABAP7/AAAEAP//+/8BAAUAAAD8/wAAAgAAAAAAAAD//wAAAQAAAAAAAQAAAP7///8DAAIA/P/9/wQABAD8//3/BAACAP7//v8AAAIAAAD/////AAADAAEA/f/+/wMAAgD9////AgAAAP//AAABAAAA//8AAAAAAAABAAAA//8AAAEAAAAAAAAA/v8BAAMA/v/9/wIAAwD///3/AAADAAEA/v///wEAAAD//wIAAAD8/wEABQAAAPz///8CAAEAAAAAAP////8BAAEAAAAAAP///v8BAAUAAAD6//7/BQADAP3//v8BAAEAAQAAAP7///8DAAEA/f///wIAAQD/////AQABAP////8BAAEA/////wAAAQABAP///v8AAAMAAQD9////AgABAP////8AAAEAAQD///7/AQACAP7///8CAAEA/////wEAAAD+/wEAAgD+//7/BAACAPr//v8HAAEA+f8AAAYA///7/wEABAD///3/AgADAP7//P8BAAQA///9/wAAAgACAAAA/v///wIAAQD9////BAABAPv///8GAAIA+v/9/wUAAwD8//7/AwABAP//AAD///7/AQADAAAA/v///wEAAgAAAP7//v8BAAMAAAD9/wAAAwAAAP3/AAADAAAA/f8AAAIAAQD///7/AQACAP///v8BAAIA/////wAAAAABAAAA//8AAAEAAQD/////AQAAAP7/AQADAP7//f8DAAMA/f/9/wIAAwD///z/AQAEAP///v8BAAAA/v8CAAMA/f/8/wIABQAAAPv///8EAAEA/v8AAAAA//8AAAIAAQD+////AQABAAAA/////wAAAgABAP7///8CAAEA/v/+/wEAAgAAAP//AQABAP7///8CAAAA/v8AAAEAAQABAP////8BAAAA//8AAAAAAAABAAAA//8AAAAAAAABAAAA/v8AAAIAAAD+////AwACAPz//f8EAAQA/f/8/wIAAwD///7/AAABAAAAAAABAAAA//8AAAAA//8BAAIA/v/+/wIAAgD/////AAD//wIAAgD8//7/BQACAPv///8EAAAA/v8AAAEA//8AAAMAAAD7////BgACAPr//v8FAAIA/f///wEAAAAAAAEA///+/wIAAgD+//7/AgACAP7///8BAAAAAAAAAAAAAAAAAAAAAAD//wAAAgAAAP7/AAABAAAAAAAAAP//AAABAAAAAAAAAP//AAACAAAA/f8AAAMA///+/wIAAQD9/wAAAwD///7/AgACAP3//v8EAAEA+/8AAAUA///9/wIAAQD+/wAAAQD//wEAAgD9//7/AwABAP7/AAABAP//AAACAP///v8CAAAA/f8BAAQA///8/wEAAgAAAAEA///+/wAAAgABAP//AAD/////AgABAP////8AAAAAAQADAP7/+v8CAAYA/v/8/wIAAgD//wAA/////wIAAAD9/wEAAwAAAP///////wEAAQD/////AQAAAP//AQACAP///f8AAAIAAQAAAP7//v8CAAMA/v/+/wIAAAD//wEAAAD+/wAAAwAAAP7/AQAAAP//AgAAAPz/AQAFAP7//P8DAAIA/f8AAAIA/v///wMAAAD9/wAAAgABAAAA/v/+/wMAAwD8//3/BAACAPz///8EAAAA/f8BAAIA///+/wAAAQABAAAA/f8AAAUAAQD6//7/BQACAP7//f///wUAAgD7//7/BAABAP3/AQACAP7///8BAAEAAAD//wAAAAAAAAEAAAD/////AQABAP//AAABAAAA//8AAAEAAAD/////AQACAP///v8BAAIA/////wEA/////wIAAQD/////AAABAAEA///+/wEAAgD/////AQAAAP//AAABAAAA//8AAAEAAAD//wEAAQD+////AgAAAP3/AQAEAP///P8BAAQA///9/wAAAQABAAAA//8AAAAA//8BAAIA///+/wAAAQABAAAA/////wAAAgABAP7//v8BAAIA/////wEAAQD/////AgABAP3//v8DAAIA/v///wAAAQACAP7//f8DAAMA/f///wIA/////wEAAAAAAAEA/////wIAAAD+/wEAAQD/////AQACAP///f8AAAMAAQD9////AgABAAAA/v/+/wMAAwD9//z/AgAFAAAA+////wUAAQD7/wAABQD+//z/BAACAPz/AAADAAAA/v///wEAAgABAPz//v8FAAEA/P8AAAMAAAD+/wEAAQD+////AgABAP7/AAADAAAA/P8AAAQA///8/wIABAD9//3/BAACAPz//v8DAAIA/v///wEAAAD//wEAAQD+////AgABAP////8AAAEAAQD/////AQAAAP//AAAAAAEAAQD/////AgABAPz///8EAAEA/f///wIAAAAAAAEA///+/wAAAwABAP3//v8BAAQAAQD7//7/BQADAPv//P8EAAMA///+////AgABAP7///8CAAAA/f8BAAQA///8/wAAAwABAP7//v8CAAIA////////AAACAAEA/v///wIAAQAAAP///f8BAAUAAAD6////BgACAPv//f8DAAMA///+/wAAAgAAAP7/AAACAAAA/f8AAAMAAQD+//7/AgACAP7///8BAAAA//8BAAEA/////wAAAgAAAP3/AAADAAEA/v/+/wAAAgACAP7//f8BAAMAAQD+//7/AQACAAAA/v///wIAAgD9//3/BAADAPz//v8EAAEA/f8AAAEA//8AAAIA///+/wMAAgD9//7/AgACAP///v///wIAAwD///z/AAAEAAAA/f8AAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAD//wAAAQAAAAAAAAD//wAAAgAAAP3/AAADAAAA/v8AAAEAAAD//wAAAQD//wAAAgD///7/AgABAP3/AAADAAAA/v///wEAAwAAAPv/AAAFAP///P8CAAIA/v8BAAIA/f/+/wQAAgD7//7/BQACAPz//v8CAAIAAAD/////AAACAAEA/f///wIAAAD+/wIAAgD8/wAABgD+//r/AwAEAP3//f8BAAMAAQD9////AwABAP3/AAACAP7/AAACAP//AAABAP7///8DAAEA/f///wIAAQAAAP///v8BAAMAAAD9//7/AgADAAAA/f///wMAAQD+////AQAAAP//AgAAAP3/AQADAP///f8CAAMA/v/9/wAAAwABAP7//v8BAAQA///8/wAAAwACAP7//f8BAAMA///9/wIAAgD9/wAABAD///v/AQAFAP///P8BAAMAAAD///////8BAAEA//8AAAEA/////wIAAQD+////AQABAAAA//8AAAEAAAD+////AwACAP7//v8AAAIAAgD+//3/AQADAAAA/v8AAAAAAAABAAAA/////wEAAgD///7/AQACAP7//v8CAAIA/////wAAAAABAAAA//8AAAAAAAABAAEA/////wEA//8AAAIA///+/wEAAgAAAP7///8BAAIAAAD+/wAAAQAAAAAA//8AAAEAAAAAAAAAAAAAAAAA//8AAAIA/////wIAAAD9/wAABAAAAPz/AAACAAAAAAABAP///f8BAAQA///8/wAABAABAP3///8BAAAAAAABAP///v8CAAMA/v/9/wEAAwAAAP3///8DAAIA/f/9/wIABAAAAPz//v8CAAMAAAD9////AgABAP//AAAAAP//AQACAP7//f8DAAMA/f/9/wMAAwD8////BQD+//v/AwAFAP7/+/8AAAQAAgD+//z/AAAFAAIA/P/8/wIABQAAAPz//v8CAAMA///+/wEAAAD//wIAAgD9//3/AwACAP3/AAADAP///f8BAAMAAAD+////AAACAAIA/f/9/wMAAwD+//3/AQADAAAA/f/+/wMAAwD+//7/AQABAAAA///+/wEAAgD//wAAAQD/////AQAAAP7/AQACAAAAAAD+////AwABAP3///8DAAEA/f8AAAMA///9/wEAAwD///7/AQABAAAAAAD+/wAAAwAAAPz///8EAAIA/f/+/wEAAgABAP///v///wIAAwD+//z/AgAEAP7//P8CAAQA/v/8/wEABAABAP3//v8BAAIAAAD//wAA/////wMAAwD9//v/AgAGAP7/+v8DAAUA/P/8/wUAAwD6//7/BQABAP3///8CAAEA//8AAAAA//8AAAEAAAD//wAAAQAAAAAAAQD///7/AQACAP///v8BAAIAAAD/////AAABAAAA//8BAAEA/v///wMAAQD9////AgABAP////8BAAEA/v///wMAAQD9////AgAAAP//AgAAAP7/AAABAAEA///+/wEAAgD///7/AgACAP7///8BAAAAAAAAAAAAAAD//wAAAgABAP7///8BAAAAAQABAP3//v8EAAIA/P8AAAMA/v/+/wMAAQD8/wAABAAAAP7/AAAAAAAAAAD//wEAAgD+//7/AwACAPz//v8FAAEA+v8AAAcAAAD5/wAABQD/////AgD9//7/BQACAPv//v8EAAIA/v/+/wEAAgD/////AQAAAP//AQACAP7//f8CAAMA///+/wAAAQABAAAA/////wAAAAAAAAIAAAD9/wAAAwAAAP7/AQAAAP3/AQAEAP///P8BAAQA///8/wEABAD///z/AQAEAAAA/f///wIAAAD//wEAAAD//wEAAQD/////AQABAP///v8AAAMAAQD9/wAAAgD+/wAABAD+//v/AwAFAP3//P8DAAMA/f/+/wMAAgD9//7/AwACAP3//v8DAAIA/v/+/wEAAQD//wEAAAD+/wAAAQACAAAA/f8AAAIAAAD+/wAAAgAAAP7///8CAAMA///9/wAAAQAAAAAAAAAAAP//AAACAAAA//8BAP///v8DAAEA+/8BAAYA/f/6/wQABQD9//3/AQABAAAAAAAAAP////8CAAIA/v/9/wEAAwD///3/AAADAAIA/v/+/wAAAQACAAAA/f///wIAAQD//wAAAQD/////AgABAP7///8CAAEA/v/+/wEAAwD///3/AgACAP7///8CAAAA/v8AAAIAAQD9//7/AwACAP///v8AAAEAAQAAAP3/AAADAAAA/v8AAAMAAAD8////BAACAPz//v8DAAIA///+/wAAAQAAAAEAAAD+/wAAAwAAAPz/AQADAP7/AAACAP7//v8EAAIA+////wMAAAD//wEAAQD+/wAAAgAAAP////8AAAEAAgD///z/AgAFAP3/+/8EAAQA/P/+/wMAAAD+/wEAAQD//wAAAQD/////AgAAAP3/AQADAP7//f8EAAIA+////wUAAQD7////AwAAAAAAAAD//wAAAQABAP////8AAAEAAAD//wEAAQD/////AAABAAEA///9/wEABQD///r/AQAGAP//+/8BAAMA/////wEAAAAAAAAA//8AAAIAAAD+/wAAAQABAAAA/v8AAAEAAAD//wEAAQD9/wAAAwAAAP7///8BAAEAAAD/////AgABAP7///8BAAEAAAD//wAAAAAAAAEAAQD///7/AQACAP7///8DAAAA/f8BAAIA/////wAAAAABAAEA/////wEAAAAAAAAA/v8AAAMAAAD9/wAAAwAAAP7/AQAAAP7/AQACAP////8BAP////8DAAAA/P8AAAQAAQD+////AAABAAEA///+/wEAAgD//wAAAAD//wEAAQD/////AQAAAP//AQAAAAAAAQD/////AQABAP7///8DAAEA/v///wEAAQAAAP////8CAAEA/v8AAAIA///+/wIAAgD+//3/AQAEAAAA/P///wQAAQD8/wAAAwAAAP7/AAAAAAAAAgD///3/AQAEAAEA+//+/wQAAwD+//3/AAABAAMAAQD7////BQABAPz///8CAAAAAAABAP////8BAAAA//8AAAAAAQACAP7//f8DAAIA/P/+/wMAAgD/////AAABAAAA/v8AAAIA///+/wIAAwD9//z/BAAEAPz//f8DAAIA/v8AAAEA/v8AAAMAAAD9/wAAAwD///3/AgADAP7//v8CAAAA/v8CAAIA/f/+/wMAAgD+//7/AAADAAEA/P8AAAQA///8/wEABAD///3/AQACAP///v8AAAIAAQD/////AAABAAAA/v8AAAIAAQD/////AQABAP///v8AAAIAAQD+////AwABAPz//v8DAAMA///9////AgACAP///f///wMAAwD+//3/AQACAAAA/////wAAAQAAAAAAAQD///7/AQADAAAA/f///wIAAgD///7/AAABAAAA//8BAAIA///+/wEAAgD///7///8AAAIAAgD///3/AQADAP///v8BAAEA/f8AAAQAAAD+//7/AAAEAAIA/P/8/wMABQD///v///8EAAMA/v/8/wEAAwD/////AQD/////AwAAAPz/AgAEAP3//P8CAAMA/////wEAAAD//wEAAgD9//z/BAAFAPz/+/8EAAUA/f/7/wIABAD+//3/AgACAP7///8CAAAA//8AAAAAAAD/////AgACAP7//f8CAAQA/v/8/wEAAwAAAP7///8BAAIA///9/wEAAwD///3/AgADAP7//v8CAAAA/v8BAAEA//8AAAEAAAAAAAAA//8BAAEA/f8AAAUA///5/wEACAD///n/AQAFAP///f8BAAEA/v8AAAMAAAD9/wAAAwD///7/AgAAAP3/AgADAP3//v8DAAAA//8CAP///f8CAAIA/f///wMAAAD//wEAAAD//wAAAQAAAP////8AAAIAAAD+/wEAAgD/////AQAAAP//AAAAAAAAAgAAAP3/AQADAP7//f8CAAMA///9////AwADAP7//P8CAAMA/f///wMA///9/wIAAwD+//7/AgABAP7/AAACAP///v8BAAEA//8AAAIA///+/wIAAQD+////AQABAP//AQABAP3/AAADAP///f8CAAMA/f///wMA///+/wEAAgAAAP7///8CAAIA/v/+/wEAAQABAAAA/////wAAAgAAAP3/AQAEAP//+/8BAAUA///8/wEAAwD///3/AQADAP///v8BAAEAAAAAAAAA/////wEAAQAAAAAA/////wIAAQD9/wAAAwD///7/AQABAAAAAAD+////AwABAP3/AAADAP///f8BAAIAAAD///7/AAADAAEA/v///wAAAQACAP7//f8DAAMA/f/9/wIAAwD///7/AQABAP////8BAAAA//8BAAAAAAABAP///v8AAAIAAAD//wAAAAABAAAA/////wEAAQD+/wAAAgAAAP7///8DAAEA/P///wQAAgD8//7/BAABAP3///8BAAIAAAD+/wAAAgAAAP7/AQACAP///v8BAAIA/v/+/wMAAgD9//7/AwACAP7//v8AAAIAAgD+//3/AgADAP7//v8CAAEA/v8AAAEA//8BAAEA//8AAAAAAAAAAAAAAAD//wEAAgD///7/AQACAP7//v8DAAEA/v8AAAAAAAABAP////8CAAAA/v8BAAEA/v8AAAIA/////wIAAAD+/wAAAQAAAAAAAQAAAP7/AAACAP////8BAAEAAAD/////AQACAP7//f8CAAQA///7/wEABQD///z/AAADAAEA///+//7/AwADAP3//v8CAAIA///+/wAAAQABAP////8BAAEAAAD+////AwABAP3/AAADAP///v8CAAAA/f8CAAIA/v8AAAEAAAAAAAAA//8AAAIA///+/wIAAgD+//3/AQADAAAA/v///wEAAwAAAPz/AAADAP///v8BAAEAAAABAP///v8BAAIAAAD9//7/BAAEAPz/+/8EAAQA/P/9/wMAAwD+//3/AQACAAAA/////wEAAgD///7/AQABAP//AAAAAAAAAgAAAP3/AAADAAAA/v8AAAEAAQD///7/AQADAP///P8CAAQA/v/+/wEAAAAAAAEAAAD+/wAAAwAAAP3/AQADAP7//f8DAAIA/P///wUAAQD7////BAABAP3///8CAAAA/v8BAAIA/v/+/wMAAwD9//3/AwABAP3/AAACAAAA/v8AAAMAAQD+//7/AQACAP////8AAP//AQADAAAA/f///wIAAgD///3/AAAEAAEA/P///wQAAQD8////AwABAP7///8CAAEA/v///wIAAgD9//3/AwACAP7/AAABAP//AAABAP////8BAAAAAAACAP///f8CAAMA/v/9/wIAAwD+//7/AQACAAEA/v/+/wIAAwD+//z/AgADAP7///8CAP////8DAAAA/P8AAAQAAAD9/wAAAQAAAAAAAAABAAAA/v8AAAMAAAD9/wEAAQD9/wEAAwD///7/AAACAAEA///+////AwABAP3///8CAAIA///+/wEAAgD///3/AgADAPz//v8FAAEA/P8BAAMA/f/+/wMAAAD+/wEAAQD//wAAAQAAAP////8BAAIA///+/wEAAQAAAAEA/v/+/wMAAgD+//7/AQABAAAAAQD/////AQAAAP////8BAAIA///+/wAAAwACAP3//P8BAAQAAAD8/wAABAAAAP3/AQACAP7//v8CAAIA/////wAAAAAAAAEAAAD+/wAAAgAAAP//AQAAAP7/AQABAP//AAABAAAA/v8BAAIA/v///wEAAQAAAP//AAABAAEA/v/+/wMAAgD9//7/AgACAP///v8AAAEAAAAAAAAAAAAAAP//AQACAP7//f8BAAMAAAD+/wAAAgAAAP3/AAADAP///f8CAAMA/v///wIA///+/wIAAgD9//7/AwABAP7/AAABAAAAAQAAAP3/AAADAP///v8CAAEA/v8BAAIA/v///wEA/////wIAAgD///7/AAACAAEA/v/+/wEAAgAAAP//AAAAAAAAAQAAAP7/AAACAAAA//8AAAAAAQAAAP7/AQACAP///v8AAAEAAQAAAP//AAABAAAA//8AAAEA//8AAAEA//8AAAIA///9/wIAAwD+//7/AQABAAAAAAD//wAAAQAAAAAAAAAAAAAAAAAAAP//AAACAAAA/f8AAAQAAAD8/wAAAwAAAP7/AAACAAAA/f8AAAMAAAD9/wEAAwD+//7/AgABAP7///8CAAEA/////wAAAQABAP///v8BAAIA/v///wMAAQD8////BQABAPr///8GAAEA+////wQAAQD+/wAAAAD//wEAAgD///3/AQADAP///v8CAAAA/f8CAAMA/f/9/wMAAwD+//3/AAADAAEA/f///wIAAQAAAAAA/////wEAAgD///3/AAADAAEA/f8AAAQA/v/7/wMABQD8//v/BAAFAP7//P8AAAIAAQD///7/AAACAAIA///9/wEAAwD///3/AAADAAEA/f///wIAAQAAAP////8BAAEAAAD/////AQACAP///v8CAAIA/f/+/wMAAQD+/wAAAQABAAAA////////AgABAP3/AAADAAAA/v8AAAAAAAABAP////8CAAAA/v8BAAEA/v8AAAIA/////wEAAAAAAAAA/////wEAAwAAAPz///8EAAIA/P/+/wMAAQD//wAA/////wEAAgAAAP7///8BAAIAAQD+//3/AAAEAAIA/P/9/wIAAwAAAP7/AAABAAAAAAAAAAAA//8AAAIAAAD+////AgACAP7//v8BAAIAAQD///7///8CAAIA/v///wIAAAD+/wAAAgAAAP7/AAADAAAA/P8BAAQA/v/8/wIABAD///7///8AAAMAAQD8////BAABAPz///8DAAAA//8CAAAA/f///wMAAQD9/wAAAwAAAP3/AAADAAAA/f/+/wIABAAAAPz///8DAAAA//8BAP///v8CAAMA/v/9/wEAAgAAAP//AAAAAAAAAAAAAAEAAAD+/wAAAwAAAPz/AAAEAAAA/f8AAAEAAAABAAAA/f///wQAAgD8//3/AwADAP7//v8BAAAAAAABAP////8CAAAA/v8BAAEA//8AAAEA/////wEAAAABAAEA/v///wEAAQAAAAAA///+/wIAAwD///3///8DAAIA/v/+/wEAAgD/////AQD/////AwACAPz//v8EAAEA/P8AAAMA/v///wQAAAD8/wEAAwD+//7/AQACAAAA/f///wMAAwD+//z/AQAEAAEA/P/9/wMAAgD///////8BAAIA///+/wEAAgD///7/AQACAP///v8BAAIA///+/wEAAgD///7/AQACAAAA//8AAAAA//8AAAEAAAD+/wAAAwABAP7//v8BAAMA///8/wEABAD+//7/AwAAAP3/AQADAP///v8AAAAAAgACAP3//P8CAAYA///6/wAABAACAP7//f8AAAMAAQD9////AgABAP////8BAAAA//8AAAEAAAD//wEAAQD/////AAABAAAA//8AAAEAAQD/////AQAAAP//AAABAAAAAAABAP////8BAAAA//8AAAAAAQACAP///f8AAAQAAAD7/wAABQABAPz///8EAAAA/P///wMAAgD+//7/AQABAAEAAQD+//3/AQAEAP///f8CAAEA/v8BAAEA/f8AAAQA/v/8/wQABAD8//3/AgABAAAAAQD///7/AgACAP7///8AAP//AgADAP3//f8DAAIA/f///wIAAAAAAAAA//8BAAAA/v8AAAMAAAD9/wEAAgD/////AAABAAEA///+/wEAAgD/////AQABAAAA/////wEAAQD/////AAACAAIA/v/9/wEAAwD///7/AQABAP//AAABAAAA/////wEAAgD///7/AQABAP//AQAAAP3/AQADAP///v8BAAEA//8AAAAA//8BAAEA/////wEAAQD+////AgAAAP//AQAAAP//AQABAP7///8CAAAA//8BAAAA//8BAAIA/v/9/wMABAD8//z/BAACAP3/AQACAP7///8CAAAA/v8BAAEA//8AAAAAAQABAP3///8DAAEA/v///wEAAQAAAP7///8EAAIA/P/+/wMAAQD+////AAABAAEAAAAAAP////8CAAIA/f/+/wQAAQD8////AgABAP////8CAAEA/v8AAAEA/////wEAAQD/////AQABAP////8BAAAA/v8CAAMA/P/9/wUAAgD7////BAD///3/AwACAPz/AAAEAP///f8BAAEA/v8AAAMAAQD+//7/AQACAAAA////////AQADAAAA/f///wIAAQD//wAAAAD//wAAAQAAAAAAAQD///7/AQACAP///v8BAAEAAAAAAP//AAACAAAA/f8AAAMAAAD+/wAAAQD//wAAAQD/////AgADAP3/+/8DAAYA/v/5/wAABgACAPz//f8CAAMAAAD9/wAAAwD///3/AQADAP///f8BAAMA///+/wEAAQD//wAAAgD///3/AQADAP///f8CAAMA/f/+/wMAAQD9/wAAAgD/////AgABAP7//v8BAAIAAQD///3/AAADAAEA/v///wIAAAD+/wEAAgD///3/AQADAP////8BAP////8BAAIAAAD+/wAAAQAAAP////8BAAEAAAAAAAAAAAAAAP//AAABAAAAAAD//wAAAgAAAP7//v8BAAQAAQD8//3/AwADAP7//v8AAAEAAgAAAP7///8BAAEAAAAAAP////8BAAIA///9/wEABAAAAPz///8DAAEA/f///wMAAQD9////BAABAPz///8CAAAA//8CAAEA/P///wUAAgD7//3/AwACAP//AAABAP////8BAAAAAAABAP///v8BAAIA//8AAAEA/v8AAAMA///8/wEAAwD/////AQABAAAA/v/+/wIAAwD+//3/AgADAP///f8AAAIAAQD///7/AAADAAEA/P///wQAAAD9/wEAAgD+////AwAAAP3/AQADAP7//f8DAAMA/f/9/wIAAwD///3/AAADAAEA/f///wMAAAD+/wAAAQABAP///v8BAAIAAAD//wAA//8AAAIA///+/wIAAgD+////AgAAAP7///8CAAIA/v///wIAAAD+/wAAAgAAAP7///8CAAIA/v/+/wEAAgAAAP7///8BAAIAAAD+/wAAAAD//wEAAQAAAP////8CAAIA/f/9/wIAAwD+//7/AwABAP3///8BAAIAAAD+////AQADAP///f8BAAEAAAAAAAAAAAD//wAAAQABAAAA/v///wIAAwD///z/AAADAAEA///+////AgADAP///P8BAAQA///9/wAAAgAAAP7/AAACAAEA//8AAAEA/v///wIAAAD+/wAAAgACAP///f8AAAMAAQD9////AgD//wAAAgAAAP7///8CAAEAAAD///3/AQAEAAAA/P///wMAAgD+//3/AgAEAP7/+/8BAAUAAQD7//3/BQADAPz//v8DAAEA/v8AAAEAAAD/////AgABAP3/AAAEAP///P8CAAMA/v///wEA//8AAAIAAAD+/wAAAQAAAAEA///9/wIABAD+//3/AgACAP///////wAAAgAAAP7/AQACAP////8BAAEA/v///wMAAAD8/wEABQD+//v/AwADAP3///8CAAAA//8BAAEA/v///wIAAAD+/wAAAgAAAP//AgAAAP3/AQACAP7///8BAAAAAQABAP7///8DAAAA/f8AAAIAAQD/////AAAAAAEAAQD/////AAABAAEA/////wEAAQAAAP7/AAACAAAA/v///wMAAgD9//7/AQABAAEAAAD+/wAAAwD///z/AQAEAP///f8CAAIA/v///wEAAAD//wAAAQAAAP//AAABAAAAAAAAAP//AAABAAAA//8AAAAAAQACAP7//v8CAAEA//8AAAAA/v8BAAMA///+/wEAAQD//wEAAQD9////AwABAP7///8BAAAAAAABAAAA/v///wMAAgD9//3/AgAEAP7/+/8BAAUAAAD7/wEABQD///v/AAAFAAAA+////wQAAgD+////AAABAAEA/////wAAAAAAAAEAAAD//wEAAAD//wEAAQD+////AwAAAPz/AQADAP////8BAP////8CAAEA/v///wEAAQAAAP////8BAAEA/////wEAAgD///3/AQADAP///f8BAAMAAAD9////AwABAP7///8BAAEAAAAAAP////8BAAIAAAD9////AwACAP7//v8AAAIAAwD9//v/AwAEAP7//f8CAAIA//8AAP///v8BAAIAAAD+/wAAAgABAP///v8AAAEA//8AAAIA///9/wIABAD+//3/AgAAAP7/AgABAP3/AAAEAP///P8DAAMA/f/+/wIAAgD///7///8CAAMA/v/9/wIAAgD+////AgD///7/AwACAP3///8CAAAA/v8BAAEA/v8AAAIAAAD//wAAAAAAAAAAAAAAAP//AAABAAAAAAABAAAA/f8BAAQA/v/7/wEABQABAP3//v8CAAMA/v/8/wIABAD+//7/AgABAP7/AAABAP7/AAACAAAA//8AAAEA/////wEAAQD/////AQAAAP//AQABAP7///8DAAEA/f///wMAAQD9////AwABAP7///8AAAEAAQAAAP//AAABAP//AAACAP7//f8DAAQA/f/9/wMAAQD+/wAAAQD/////AgABAP7//v8CAAQA/f/7/wMABQD+//v/AgAEAP3//f8EAAIA+////wYAAAD6/wEABQD///v/AAAFAAEA/P///wMAAQD9////AgABAP////8AAAEAAQD///7/AQACAP////8BAAAA//8AAAAAAQABAP7///8CAAEA/v/+/wIAAwD///3/AAACAP////8CAAAA/f8AAAQAAAD8/wEAAwD///7/AAACAAAA/f///wQAAgD8////AwAAAP//AAD//wAAAgAAAP7/AAACAAAA//8AAP//AAACAAAA/v8AAAIAAAD+/wAAAwD///z/AgAEAP3//P8DAAMA/v8AAAAA/v8CAAMA/f/8/wMAAwD+////AAAAAAEAAQAAAP7///8BAAIAAAD9/wAAAgAAAAAA/////wIAAQD+////AQAAAAAAAgD+//z/BAAFAPv/+/8FAAQA/P/+/wMAAAD+/wEAAQD/////AAACAAEA/f///wQAAQD8////BAAAAPz/AQADAAAA/v///wEAAQAAAP//AAABAAAA//8BAAEA/v///wIAAgD///7/AQAAAP//AQABAP//AAACAP///v8CAAIA/f/9/wMABAD///z///8DAAEA//8AAAAA//8AAAEAAAAAAP///v8DAAMA/f/+/wIAAAD//wEAAAD//wAAAAABAAEA///+/wEAAgD/////AAAAAAAAAAACAAAA/P8AAAUAAAD7/wAABAAAAP3/AAACAAAA//8AAAEAAAD///////8DAAMA+//9/wYAAwD7//3/AwACAP////8AAAIAAAD9/wAAAwAAAP3/AQADAP7//f8DAAMA/f/+/wIAAAD//wEAAAD//wAAAQACAAAA/f/+/wQAAwD7//3/BAADAP3//v8CAAEAAQD///z/AQAFAP//+/8CAAMA/v///wEAAAAAAAAA//8BAAIA/v/+/wIAAQD+/wAAAgAAAP7/AAADAP///f8BAAEAAAABAAAA/v8AAAIAAAAAAP///f8BAAQA///9/wIAAQD9/wEAAwD+//3/AQACAAAAAAD/////AgABAP3///8DAAEA/v/+/wEAAwAAAP3//v8DAAMA/f/+/wIAAQD+////AgABAP////8BAAEA/////wAAAQAAAAAAAAD//wEAAQD/////AQABAP//AAAAAP//AQABAP7///8EAAIA+//9/wUAAwD8//3/AgADAAAA/v///wEAAgD///7/AQACAP///v8CAAIA/f///wMAAAD9/wAAAwABAP7//v8CAAMA/v/8/wEAAwAAAP//AAAAAAAAAAAAAAAAAAD//wAAAgAAAP7///8BAAIAAAD9/wAABAD///v/AgAFAP3//P8DAAIA//8AAP////8BAAAA//8BAAEA/////wEAAgD///3/AAADAAEA/f///wMAAAD+/wEAAQD+/wAAAwD///3/AgABAP7/AQABAP//AAAAAP//AQACAP3//v8FAAAA/P8BAAIA/////wAAAAABAAEA/v///wIAAQD/////AAABAAAA//8AAAEAAQD///7/AQACAP///v8BAAIA/////wEA/////wEAAAAAAAEAAAD+/wAAAgD/////AQAAAP//AAADAAAA+/8AAAUAAQD8//7/AgACAAEA/v/9/wIAAwD///3/AAADAAEA/v/+/wEAAgD/////AQAAAP//AQAAAP7/AgACAPz///8FAAAA+/8BAAQA/v/+/wIAAAD+/wEAAgD+////AwABAP7//v8AAAIAAgD+//z/AgAEAP///v8AAAAAAAABAAEA/v/+/wMAAgD9//7/AgABAP7/AQACAP7///8CAAEA/v///wEA//8AAAMA///8/wIABQD9//v/AwAEAP7//f8BAAIA//8AAAEA/v/+/wMAAwD9//7/AgABAP//AAAAAP//AQABAP7/AAADAP///P8CAAMA/v8AAAEA/v8AAAMA///8/wEABAAAAP7///8BAAIA///+/wEAAgD///7/AgACAP7//v8BAAIAAAD//wAAAAD//wAAAgAAAP7/AAABAAAAAAAAAP//AAABAP////8CAAIA/v/9/wIAAwD+//7/AAABAAIAAAD9/wAAAwAAAP7/AAAAAAEAAQD9////BAABAPz///8EAAAA/f8AAAIAAQD+////AgACAP7//P8CAAQAAAD9//7/AwACAP3///8DAAAA/f8CAAMA/f/9/wMAAwD8//3/BAADAPz//f8FAAMA/P/+/wIAAgD///3///8DAAMA/f/9/wMAAwD+//7/AQAAAP//AQAAAAAAAQD/////AgABAP3///8CAAAAAAACAAAA/v///wEAAQD/////AQABAP//AAACAP///f8AAAIAAQAAAP///v8AAAMAAQD+////AAAAAAEAAQD/////AQAAAAAAAgD///z/AQAFAP//+/8BAAUAAAD7////BQABAPv///8EAAEA/v///wAAAQABAP7///8DAAEA/f///wIAAQD///7/AAADAAEA/f/+/wMAAgD9////AgABAP////8AAAAAAQABAP7///8DAAEA/f/+/wIAAwD///3/AAADAAIA/f/8/wMABAD+//3/AAACAAIA///+/wAAAQAAAAEAAAD9/wAAAwAAAP//AAD//wAAAgD///7/AgABAP7///8CAAEA/v8AAAEAAAAAAP//AAABAAAA//8AAAEA/////wEAAQAAAP////8BAAIA///+/wAAAAABAAIA///9/wAAAgACAAAA/P///wUAAgD8//7/AgABAAAA/////wIAAQD+////AgABAP7///8BAAIAAAD+////AQACAP///f8AAAQAAgD8//3/AgAEAAEA+//9/wQABAD+//z/AQADAP///v8BAAEA//8AAAEA//8AAAIA///+/wEAAAD//wEAAQAAAAAAAAAAAAAA//8AAAIA///9/wIABAD///3/AAABAAEAAQD+//7/AwACAPz//v8EAAIA/f/+/wIAAgD///7/AAACAAAA/v8BAAIA/v/+/wIAAgD///7/AAADAAEA/P/+/wQAAgD9//7/AgADAP///f8AAAMAAQD9//7/AgADAAAA/P8AAAQAAAD9/wAAAgAAAP////8AAAMAAQD8////BAABAPz///8DAAEA/v///wIAAgD+//7/AQABAAAA//8AAAIAAAD+/wAAAgAAAP3/AAACAAAAAAAAAAAAAQAAAP7///8CAAAA/v8BAAIAAAD+/wAAAwD///z/AQADAAAA////////AQADAP///P8BAAMA///+/wEAAgD+////AwD///7/AgAAAP3/AQAEAP7//P8CAAMA///+/wEAAgD+//3/AgADAP7//v8BAAEAAAD//wAAAQD//wAAAgAAAP7///8CAAEA/////wAAAQAAAAAAAQD///7/AQADAP///f8AAAIAAQD/////AAABAAEA/////wEAAQD///7/AAACAAIA/v/+/wMAAQD+////AAABAAAAAAAAAAAAAAAAAAEA/v/+/wQAAwD8//z/BAAEAPz//P8DAAMA/v///wIAAQD+//3/AQAEAP///P8CAAQA///9/wAAAQAAAAAA//8AAAIAAAD+/wAAAgD///7/AQACAAAA/f///wQAAgD8//3/AwAEAP7/+/8BAAUAAAD8/wEAAgD9/wEABAD9//z/AwAEAP7//f8BAAIAAAD+/wAAAgD/////AgD///3/AwAEAPz//P8EAAQA/v/8////AwADAP///P///wUAAgD7//7/BAACAP3//v8CAAIA///9/wAABAAAAPz/AAADAAAA/v8AAAEAAQAAAP3/AAAFAP//+v8BAAYA///7/wEABAAAAP3/AAACAP///v8BAAIA/////wEAAQAAAP7/AAACAP///v8BAAIA/////wEAAAAAAAEA///+/wEAAgD/////AQAAAAAAAQD/////AQAAAP//AQABAP7/AAADAP7//f8DAAIA/f///wMAAAD9/wEAAgD/////AQABAP////8AAAAAAAABAAEA/////wAAAQABAP7///8CAAEA/v///wMAAAD9/wEAAgAAAP////8AAAEAAQD+////AwAAAP7/AQABAP7/AAADAP7//f8DAAIA/f///wMAAAD9/wEAAwD///3/AQADAP///v8BAAAA//8AAAAAAQACAP///f8BAAMA///+////AAACAAEA/v///wIAAQD+////AQABAAAA//8AAAAA//8BAAIA///9/wEAAwD///7/AQABAP7/AAADAAAA/f/+/wMABAD9//r/AwAGAP3//P8CAAMAAAD+////AAABAAAA//8BAAEAAAD/////AQABAP////8BAAEA/////wEAAQD+////AgABAP//AAAAAP7/AQADAP7//v8CAAEA/v8AAAIA/v///wQAAAD8/wEAAwD+//7/AQABAAEAAAD//wAAAAAAAAAA//8AAAIAAAD+/wEAAgD+////AgD/////AQAAAAAAAQAAAP7/AAADAAAA/f8AAAMA///9/wIAAgD9////BAAAAPz/AQADAP///v8BAAEA/v///wEAAQABAP///v8BAAMA///9/wEAAgD/////AAAAAAEAAQD+/wAAAgD/////AQAAAP7/AQADAP7//f8CAAMA/v/9/wIAAgD+//7/AgACAP7//v8BAAIAAAD/////AAABAAEA///+/wEAAgD///7/AQADAAAA/f/+/wMABAD9//r/AgAGAP///P8BAAIA//8AAAEA/v///wMAAQD9////AwAAAP7/AQAAAP//AgABAP3///8EAP//+/8DAAUA/f/8/wMAAwD8//7/BAAAAP3/AQADAP///v8BAP////8DAAEA/f/+/wMAAwD+//3/AAACAAIA///+////AgACAP7///8CAAAA/v8BAAIA/f/+/wMAAwD+//z/AgAFAP//+v8AAAYAAAD7/wAABAAAAPz/AAAEAAAA/f8AAAIAAAD//wAA//8AAAEA//8AAAIAAAD+/wEAAgD+//7/AQACAAAA/v8AAAIAAQD+//7/AwACAPz///8EAP///P8CAAMA/v8AAAEA/v8BAAIA/v/+/wEAAQAAAAEAAAD//wAAAAAAAAAAAAAAAAAAAQABAP////8AAP//AAACAAAA//8AAAAAAAABAAEA/v/+/wMAAgD9//7/AgABAP//AQAAAP//AQAAAP//AQAAAP7/AQACAP7//v8DAAMA/P/8/wQABAD9//z/AQADAAEA///+/wEAAgD9////BQAAAPr/AAAGAAEA+//+/wQAAgD9////AwAAAP3/AQACAP///////wAAAgABAP7//v8CAAMA///8/wAABAAAAP3/AAABAAAAAQAAAP3/AAAEAAAA/f8AAAEAAAABAAAA/v8AAAIA///+/wIAAQD+/wAAAgAAAP//AAD/////AgACAP///f8AAAQAAQD8//7/AwACAP7//v8BAAIAAAD//wAAAQD/////AgAAAP7/AAABAAEAAAAAAP//AAABAP//AQABAP3///8DAAEA/f8AAAQA///8/wEABAD///z/AQADAP////8CAAAA/f8AAAMAAAD+/wAAAQABAP///v8CAAIA/f/9/wMABAD+//3/AAABAAEAAAD//wAAAQAAAP//AAABAAAA//8AAAEAAAD/////AQACAP////8BAAAAAAAAAP7///8DAAEA/f8BAAMA/v/+/wIAAAD+/wEAAQD//wEAAQD+/wAAAgD///7/AQACAP///v8AAAIAAgD+//3/AQADAAEA/f/+/wIAAQD//wEAAAD9/wEABAD///3/AAABAAEAAQD+//7/AgACAP///v8AAAMAAQD8//7/BAACAPz///8DAAEA/////wAAAQAAAP//AAABAAAAAAABAP////8BAAAA//8AAAIAAQD+////AQABAP////8BAAAA//8BAAEA/////wEAAQD//wAAAAD//wEAAQAAAP///v8BAAMAAAD9/wAAAgAAAAAAAAD9/wAABAAAAP3/AAADAAAA/f8AAAIAAAD+////AwABAP3///8DAAEA/f///wMAAQD9////AgABAP////8BAAAA//8BAAEA///+/wIAAgD+////AQAAAP//AQAAAP7/AgACAP7///8BAAAAAAABAP///v8BAAIAAAD///7/AAAEAAEA/P/+/wMAAgD+////AQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAQD+//7/AgACAP///v8AAAIAAQD+////AgAAAP7/AQADAP///f8AAAEAAgAAAPz/AAAFAAAA+/8AAAQAAQD+//3/AQAFAAAA+v///wQAAQD//wAAAAD//wEAAQD+////AgABAP7/AAACAAAA///+/wAAAwABAP3///8DAAEA/v/+/wEAAwD///3/AQADAP///f8BAAIA/////wEAAQD/////AQAAAP//AQAAAP7/AQADAP///f8BAAIA/////wAAAQABAP////8AAAEAAQD///7/AAADAAEA/f///wIAAAD//wIAAQD9////AgABAP////8BAAEAAAD//wAAAQD/////AQABAAAA//8BAAAA/v8BAAIA/v/+/wMAAgD9////AgAAAP//AQAAAP7/AAACAAAA/v8BAAIA/////wAAAQAAAP7///8BAAMAAQD8////BAABAPz///8EAAAA/f8BAAIA///9/wAABAABAP3///8DAAEA/f/+/wIAAgD+////AgAAAP//AAABAAEAAAD+//7/AwADAPz//P8EAAUA/f/8/wIAAgD//wAAAAD//wAAAQABAAAA/////wEAAQD//wAAAAD//wEAAgAAAP7///8BAAEAAAD/////AAABAAIAAAD+/wAAAAD//wIAAQD9////AwABAP7/AAABAAAAAAD//wAAAQD//wAAAQD+////BAABAPz/AAADAP////8CAP///P8CAAQA/v/+/wEAAQAAAAAAAAD+/wAAAwAAAP3///8DAAIA/f/+/wIAAQAAAAAA/v8AAAMAAAD9/wEAAwD9//3/BAADAPz//f8EAAIA/P///wMAAAD+/wAAAgAAAP7/AAABAAAAAAAAAP////8BAAEAAAABAP///v8BAAIAAAD+////AgABAP//AAAAAP//AAABAAAAAAABAAAA////////AgACAP3///8EAAAA/f8BAAEA/v8AAAIA/////wIAAAD//wAAAAAAAAAAAQAAAP7/AAACAAAA/f8AAAMAAQD+//7/AQACAAEA/v/9/wIAAwD///7/AAABAAAA//8AAAIAAQD+////AQD//wAAAgD///7/AgACAP7///8BAAAA/////wIAAgD///3///8EAAIA/P/9/wMAAwD9////AwD///7/AgABAP3///8DAAEA/v///wEAAgD///7/AQABAAAAAAD/////AQABAP//AAAAAAAAAgAAAP3/AAADAP///f8BAAIAAAAAAP///v8BAAMA///9/wIAAwD9//3/AwADAPz//f8EAAMA/f/+/wIAAQAAAAAA/v///wIAAQD+/wAAAQAAAAEAAAD//wAAAAD//wAAAgAAAP7/AAACAAAA/v8AAAIA///9/wIAAwD9//7/BAABAPv///8EAAIA/v/9/wEAAwAAAP7///8AAAAAAgABAP7/AAABAAAAAAD/////AQABAP7/AAAEAP//+/8BAAUAAAD7////BAACAP7//v8AAAEAAAAAAAEA/////wIAAQD+////AQD//wAAAwAAAP7/AAABAAAAAAD/////AgABAP7///8CAAEA/v8AAAIAAAD/////AAABAP////8CAAEA/v8AAAMA///8/wEAAwD///3/AQAEAAAA/f///wIAAQD+////AQABAAAA//8AAAEAAQD///7/AQABAP//AQABAP3///8FAAEA+v///wUAAQD8////BAABAP3///8BAAEAAQAAAP7///8CAAEA////////AAADAAEA/P///wQAAAD8/wEABAD+//3/AgACAP7//v8BAAIAAQD///7/AQADAP7//P8DAAMA/f///wMAAAD9/wEAAQD//wEAAAD//wEAAQD///7/AAABAAEAAQD/////AQABAAAA/v/+/wIAAgD+////AwABAPz///8EAAEA/P/+/wQAAwD8//7/AwAAAP7/AQABAP////8BAAIAAAD+////AQAAAAAAAgD///3/AQADAAAA/v///wAAAQACAP///f8BAAMA///+/wIAAQD9/wAAAwD///3/AQADAP///v8BAAIA///+/wEAAQAAAAAA/////wEAAgD+//7/AwABAP7/AAABAAAA//8AAAEAAAD//wAAAQAAAP//AAAAAAAAAQAAAP//AAABAAAA//8AAAEAAAD/////AQACAP///f8BAAQA///8/wEABAD///z/AAADAAEA////////AQADAP7//P8DAAQA/f/8/wMABAD9//3/AwACAP3/AAAEAP7/+/8DAAUA/f/7/wIABQD///z/AQADAAAA/v/+/wAAAgACAP7//v8CAAEA//8AAAAA//8AAAIAAAD+/wAAAQAAAP//AAACAAAA/f8AAAMAAAD9/wAAAwAAAP3/AAADAAAA/v8AAAAAAAACAAAA/f8AAAMAAQD+//7/AQACAAAA//8AAAAA//8BAAEA////////AgADAP3//f8CAAIA/////wEAAAAAAAAA//8BAAAA/v8BAAIAAAD/////AAACAAEA/f///wMAAQD+////AQABAAAA//8AAAIA///+/wEAAAD//wEAAQD/////AgABAP3//v8DAAMA/f/8/wMABAD9//3/AwACAP3///8EAAAA+/8AAAUAAAD8/wAABAABAPz//v8DAAIA/f/+/wQAAgD9//7/AQACAAAA/f///wMAAQD+/wAAAQD//wAAAQD/////AAABAAEA/////wEAAQD/////AAABAAAA/v8BAAMA///8/wAABQABAPz//f8BAAQAAgD9//z/AQAFAAIA+//8/wUABAD8//3/AwABAP7/AQABAP7/AAADAAAA/f8AAAIAAAD+/wAAAgAAAP7/AAADAAEA/f/9/wIABAD///z/AAADAAEA/////wAAAQD/////AgAAAP7/AAACAAEA/v///wEAAAAAAAAAAAAAAAEA///9/wMABAD9//z/AQAEAAEA/P/+/wMAAgD//wAAAAD+/wEAAwD+//7/AQABAAEAAAD+/wAAAwD///z/AgAEAP///f8AAAIAAAD//wAAAAAAAAAAAQABAP7//v8CAAMA/v/9/wIAAgD/////AAAAAAAAAAABAAEA/v/+/wIAAgD/////AQD/////AwAAAPz/AAAEAAEA/P///wMAAQD///7/AAACAAAA//8BAAEA/v/+/wIAAgD+////AgAAAP//AAABAAAA/v8AAAIAAAD//wAAAQAAAP//AAAAAAEAAAD9/wEABAAAAP3///8BAAAAAQABAP3//v8EAAMA/f/9/wEAAgD/////AgABAP7//v8CAAMA/v/8/wIABAD///3/AAACAAAA//8AAAAAAAAAAAEAAQD+//7/AgADAP7//P8CAAQA/v/9/wEAAgAAAP7/AAADAAEA/P/+/wQAAQD9/wAAAQAAAAEAAQD+//7/AgACAP7//v8CAAMA/v/9/wIAAgD+//7/AQACAAEAAAD+////AQABAAAA/v///wMAAwD9//z/AwAEAP7//P8AAAQAAgD9//3/AQADAAEA/v///wEAAAD//wEAAgD///3/AAADAAEA/v///wAAAAACAAIA/f/9/wMAAwD9//3/AwACAP3/AAADAP///v8BAAAA//8CAAEA/f///wIAAQD/////AQABAP7/AAADAAAA/P///wMAAgD///3/AAAEAAAA/P8AAAMA/////wIA/////wIA///+/wIAAQD+/wAAAQD//wAAAgD///7/AgACAP7//v8BAAAAAAADAP///P8CAAMA/v///wIA/v///wQA///9/wIAAQD//wAAAQD/////AgAAAP3/AQAEAP///P8CAAMA/P/+/wUAAQD8////AwACAP7//f8AAAMAAQD+/wAAAQD//wAAAQAAAP////8BAAEAAAD//wAAAgD+////AwAAAP7///8BAAIAAAD+////AgACAP7//f8BAAQAAQD8////AwAAAP//AAD/////AgACAP7///8BAP//AAACAP///v8DAAIA/P/+/wMAAQD+/wAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAD+/wAAAgAAAP7/AQACAP7//v8CAAIA/v///wIAAAD+/wAAAgAAAP////8AAAMAAAD9/wAAAQD//wEAAwD+//3/AgABAP//AQAAAP7///8DAAMA/P/8/wQABAD8//3/BAAAAP7/AwAAAPz/AQADAP7///8CAAAA/v8AAAMAAQD9//7/AgACAP///////wAAAwABAPz///8FAAAA+/8BAAQA///9/wAAAgABAP////8BAAEA/v///wMAAQD9//7/AgAEAP//+/8AAAUAAQD8////AgABAP///v8BAAMAAAD9////AwABAP3//v8DAAMA/f/+/wIAAQD/////AQAAAP//AQACAAAA/f///wIAAAD//wEAAAD//wEAAgAAAP7//v8BAAMA///8/wIABQD+//v/AgAEAP7//f8CAAIA/v///wIAAQD+//7/AQADAAAA/P///wQAAgD9//7/AQABAAAA//8BAAEA/f8AAAQAAAD8/wAAAwD/////AgD///7/AgACAP7//v8CAAIA/v///wEAAAAAAAEAAAD+/wEAAgD+////AQAAAAAAAQD///7/AgACAP///////wAAAgABAP7//v8CAAIA/v///wIAAAD+/wAAAgABAP7//v8BAAMAAAD9////AgACAP///f8AAAIAAgD///3/AAADAAEA/f8AAAIA/v8AAAMA///8/wEABAD///7/AAAAAAEAAQD///7/AAACAAEAAAD+//7/AgADAP///P8AAAQAAQD+//7/AAACAAEA///+/wAAAwABAP3//v8CAAIA/////wAAAQABAP////8AAAAAAAABAAAA//8AAAAAAgABAPz//v8EAAQA/f/7/wEABAABAP3///8CAAAA//8BAAAA/v8BAAIA/v///wMAAAD8/wAAAwAAAP//AAAAAAEAAQD+//7/AgACAP7///8CAAAA//8BAP////8DAAEA/P///wQAAAD9/wEAAQAAAAAA//8AAAEAAAD+/wAAAwAAAP7/AAABAP////8CAAEA/f///wMAAQD//wAA///+/wIAAwD+//3/AQADAAAA/v8AAAAAAAABAAEA/////wEA//8AAAMA///8/wIABQD+//v/AQADAP////8BAAAAAAABAP///v8BAAMAAAD9////AgABAP////8AAAEAAQAAAP//AAAAAAAAAQD///7/AQABAP//AAACAP///v8CAAEA/v8AAAAA/v8BAAQA///8/wEAAgAAAAAA/////wIAAQD+/wAAAAD+/wIABAD9//v/BAAEAP3//v8AAAEAAgAAAP7/AAABAP7/AAADAP///v8CAAIA/v/+/wEAAgAAAP3///8DAAIA/v/+/wEAAQAAAP////8CAAIA/f/9/wMAAwD+//7/AQABAAAAAAAAAP////8CAAIA/f/+/wQAAgD8//7/AwACAP7//v8AAAMAAgD8//3/AwADAP7//f8BAAMAAQD9//7/AgABAP////8AAAIAAQD+////AQABAAAA/v///wMAAgD8//3/BAADAP3//f8CAAQA///7/wAABAAAAP3/AAACAAAAAAAAAP//AQABAP7///8DAAAA/f8BAAEA//8BAAEA/////wAAAAACAAEA/P///wQAAQD9//7/AgACAP//AAABAP///v8BAAIA/////wEAAQAAAP//AAAAAP//AQACAP///v8BAAIA///+/wEAAQD//wAAAQAAAP////8BAAIAAAD9////BAABAPv/AAAFAP///P8CAAMA/v/+/wEAAQAAAAAAAAAAAAAAAAAAAP//AAACAAAA/f8AAAQAAAD8/wAAAwAAAP7/AAABAAAAAAAAAP//AAACAAAA/f8AAAMAAAD+/wAAAQABAAAA/f///wUAAQD7////AwABAAAA///9/wEABQD///v/AQAEAP7//f8DAAEA/f8BAAMA/v/9/wIAAgD+/wAAAgD/////AQABAP///v8BAAIA/////wIAAQD9/wAAAgD/////AQABAP////8BAAEA/////wIAAAD9/wEAAwD///3/AAACAAAAAAAAAP//AQABAP7///8CAAAA/f8BAAMA///+/wAAAgAAAP7/AQABAP7/AAACAP///v8CAAIA/v/+/wEAAgD/////AQD//wAAAwD///z/AgAEAP7//f8BAAIAAAD+/wAAAwD///z/AwAEAPz//P8EAAUA/f/8/wEAAwABAPz//v8EAAEA/v8BAAEA/f///wQAAQD8//7/AgADAAEA/P/9/wQAAwD+//7/AAABAAAAAAAAAP//AAACAAIA/v/9/wEAAgAAAP////8BAAIA///+/wEAAAD//wIAAQD9////AwACAP7//P8AAAUAAgD8//z/AgAFAAAA+//+/wUAAwD8//3/AgADAAAA/P/+/wQAAwD9//3/AgAEAP//+/8AAAQAAAD9/wEAAgD+/wAAAgD+//7/AwACAPz//v8FAAIA+//+/wQAAQD+/wAA//8AAAIAAAD/////AQABAP//AAAAAAAAAAAAAAEAAAD//wAAAQAAAP//AAABAAAA//8AAAAAAQABAP7///8DAAEA/P///wUAAAD7/wEAAwD+////AwAAAPz/AQAFAP//+/8AAAQAAAD9/wEAAgD+//7/AgADAP///P8AAAQAAQD9////AQAAAAAAAQAAAP7/AAACAAAA//8AAAAAAAABAAAA/v8BAAIA/v///wIAAAD//wEAAAD+/wEAAgD+////AgAAAP//AAAAAAEAAQD+//7/AgABAP//AAAAAAAAAQAAAP//AAABAAAA/////wEAAgD///7/AQABAP//AQABAP3///8EAAEA/P///wQAAAD9/wEAAQD+/wAAAwAAAP3///8CAAMA///7/wAABgABAPv///8DAAAA/v8BAAEA/v8BAAIA/v///wIAAAD+/wAAAQABAAEA/f/+/wUAAQD5/wAACAAAAPn/AAAFAAAA/f///wIAAgD+//7/AgACAP7///8CAP////8CAAAA/v8AAAIAAAD//wEAAAD//wAAAQAAAP//AQABAP7///8CAAEA//8AAAAA//8AAAIAAQD9//7/AwACAP3///8DAAAA/v8AAAEAAAD//wAAAAABAAEA/v///wIAAQD+////AgAAAP7/AAACAAEA/v///wIAAQD///7///8CAAIA/v/+/wMAAgD8////BAD///z/AgADAP//////////AgACAP7//f8BAAMAAQD+//7/AQABAP//AAABAAAAAAAAAP//AAABAAAAAAD/////AgACAP7//f8CAAIA/v8BAAEA/v8AAAEAAAAAAAAA/v8AAAQAAAD9/wAAAQABAAAA/v8AAAIA///+/wIAAgD9//7/AwACAP///v///wIAAgD+//3/AQADAAEA/f/9/wMABAD+//z/AgADAP7///8AAP//AQACAP///v8CAAIA/v///wEAAAAAAAAA//8BAAIA/v/9/wMAAwD+/////////wQAAQD6/wAABgD+//v/BAAEAPz//f8CAAIAAAD/////AAABAAAAAAAAAAAAAAD//wEAAgD///3/AQADAP7//v8CAAEA//8AAAEA/////wEAAQD/////AQABAP////8BAAAA//8CAAEA/f///wMAAQD9////AwABAP3///8DAAAA/f8BAAIA//8AAAEA/////wEAAQD///7/AAADAAIA/v/9/wAABAACAPv//f8FAAMA/P/+/wMAAAD+/wEAAgD///7/AQABAAAAAAD/////AAADAAIA/f/8/wIABQD///v/AAAEAAEA/v///wEAAQD//wAAAAD+/wAAAwAAAPz/AQAFAP//+/8BAAQA/v/9/wIAAgD/////AAABAAEA/v/+/wIAAgD/////AQAAAP//AQABAP7//v8CAAIA/////wAAAAAAAAEAAAD//wAAAAABAAEA/////wAAAAAAAAAAAAABAAAA//8AAAEAAAD+/wEAAQD+/wEAAgD///7/AQACAP7///8BAAEAAAD+/wEAAwD+//z/AwAEAPz//f8EAAIA/f///wIAAAD//wAAAQABAP///v8AAAMAAQD9////AgABAAAA/////wAAAQAAAP//AQAAAP//AQABAAAA/////wAAAgABAP3///8DAAEA/v8AAAIA///+/wEAAgD///7/AAACAAEA/////wAAAQAAAP7/AQACAP///v8BAAIA///+/wEAAgAAAP7///8CAAIA/v/9/wIAAwD+//7/AgABAP///////wIAAwD+//z/AgAEAP7//f8BAAEA//8BAAMA/v/9/wIAAgD///7/AAABAAAAAAAAAAEAAAD+/wAAAgABAP7//v8CAAEA//8AAAAAAAAAAAAAAQAAAP////8BAAEA/v8BAAIA/v///wIAAQD9////AwABAP///v8AAAQAAAD6/wAABgAAAPz/AQADAP7//f8DAAMA+//8/wcABAD6//7/BAAAAP3/AAACAAAA/v8AAAMAAQD9//7/AgACAP///v8AAAIAAQD+////AgAAAP7/AAACAAEA////////AQACAP///f8AAAQAAQD9////AQABAAEA///9/wAABQABAPv///8DAAEA//8AAAEA///+/wEAAwAAAPz///8FAAIA+//+/wUAAQD7/wAABAD///7/AgAAAP3/AgADAP3//v8DAAEA/v8AAAEA//8AAAEA//8BAAEA/f8AAAQA///7/wIABAD9//7/AgABAAAA///+/wEABAD+//v/AwAEAP3//v8DAAEA/f8AAAMA///9/wEAAgAAAP////8BAAIA///9/wAAAwAAAP7/AAABAAAAAAABAP///f8BAAQAAAD8////AwACAP7//f8BAAMAAAD+/wAAAQD//wAAAgAAAP7///8CAAEA//8AAAAA//8AAAIAAAD9/wAAAwABAP3///8DAAAA/f8BAAMA/f/9/wUAAgD7////AwAAAP//AQD/////AwABAP3///8CAAAA/v8BAAIA/////wEAAQD/////AQAAAP//AAABAAEA///+/wAAAgACAP7//f8CAAMA/v/+/wIAAQD+/wAAAQAAAAEAAAD+////AgADAP7//P8BAAQAAAD8/wAAAwD///7/AQADAP///f8BAAIA///+/wEAAgD+////AwABAPz///8FAAAA+/8BAAUA/v/7/wMABAD9//7/AgAAAP//AgAAAPz/AQAGAP//+v8BAAQA///+/wAA//8BAAQA/v/7/wIABAD///3/AAABAAAAAQAAAP//AAAAAAAAAQAAAP7/AAACAAEA/v///wMAAAD9/wAAAwAAAPz/AQAEAP///f8AAAIAAQD/////AAAAAAAAAQABAP///v8BAAIA///+/wEAAgD///7/AQACAP////8BAP////8CAAIA/f/9/wQAAwD8//3/BAACAPz///8DAAIA/v/9/wEAAwAAAP3///8CAAEAAAAAAP////8BAAIA///+/wEAAQAAAAAA//8AAAEA/////wMAAQD7////BgABAPv///8DAAAA//8CAAAA/P8AAAQAAAD+/wAAAAAAAAEAAQD///7/AAACAAEA/v///wEAAQABAAAA/v///wIAAQD+////AQABAAEAAAD+//7/AgADAP7//f8CAAIA//8AAAAA/v8AAAEAAAABAAEA/f/+/wUAAgD7//7/BAADAP3//P8BAAQAAQD8//7/BAADAP3//P8BAAQAAAD9/wAAAgAAAP//AAAAAAAAAAAAAAEA/////wIAAQD9////BAAAAPz/AQADAP///f8BAAMA///9/wEAAwD+//7/AgAAAP//AQABAP///v8BAAIA///+/wEAAgD/////AQAAAP//AAABAAAA/v///wMAAgD9//7/AgABAAAAAAD9/wAABQD///r/AgAGAP3/+/8DAAQA/v/9/wIAAQD+/wAAAgAAAP7/AAACAAAA/v8AAAIAAAD+/wAAAgAAAP//AAAAAAEAAQD+//7/AgABAP7/AQADAP7//P8CAAQA///7////BQACAP3//v8AAAIAAQD///////8AAAIAAQD/////AAAAAAEAAQD+//7/AwACAP3///8CAAAA//8BAAAA/v8CAAIA/P///wQAAAD9/wEAAgD//wAAAAD+/wEAAwD+//z/AgAFAAAA+//+/wQAAwD9//z/AgAEAP7//v8DAAAA/P8AAAQAAAD8/wAAAwABAP////8AAP//AAACAAAA/v///wIAAgD///7/AAABAAAAAAAAAP//AQACAP7//v8CAAEA/v8AAAIA/////wIAAAD9/wAABAAAAPz/AAADAAAA/v8AAAEAAAD//wAAAgAAAP7/AAACAAEA/f/+/wQAAwD8//z/AwAEAP7//f8BAAIAAAD//wEAAQD9//7/AwACAP7///8BAAAAAQACAP7//f8CAAIA///+/wAAAgABAAAA/////wAAAQACAP///f8AAAIAAQAAAP///v8BAAMAAAD9////AgACAP///v8AAAEAAAAAAAAAAAAAAAAAAAAAAAEAAAD+////AgACAP7///8BAP7/AQAEAP7/+/8DAAUA/f/9/wIAAAD+/wIAAgD9//7/BAACAPz///8DAP///v8CAAIA/f///wMA/////wIA///+/wIAAwD9//z/BAADAP3///8BAAAAAQABAP3//v8FAAIA+//+/wMAAgD///7/AAACAAAA//8AAAAAAQABAP7//v8CAAIA/v///wEAAQABAP///v8BAAIA/v/+/wMAAQD9/wAAAwAAAP3/AAACAAAAAAAAAP//AAABAAAA//8BAAEA/v8AAAIAAAD/////AAABAAEA/////wIAAAD9/wEAAwD///7/AAAAAAEAAgD+//3/AgACAP//AAABAP///v8CAAIA/v/+/wAAAgACAP7//v8CAAEA/v8AAAIA///+/wEAAgD///3/AgAEAP7//P8BAAMAAAD+//7/AQAEAP///f8BAAEAAAAAAAAAAAAAAP////8CAAEA/v///wEAAwAAAPz///8EAAIA/P/9/wMAAwD///7///8AAAMAAgD7//3/BgACAPr///8FAAEA/P///wQAAQD8////AwAAAP7/AQAAAAAAAwD///z/AQAEAP///P8BAAIA//8AAAEAAAD//wAAAQAAAP////8AAAIAAQD9//7/AwACAP3///8EAAAA/P8BAAIA/v8AAAIA///+/wEAAgAAAP////8AAAIAAAD+/wEAAQD+////AgACAP7//v8BAAIAAQD+//7/AAACAAEA/v8AAAEAAAAAAP////8BAAIA///+/wEAAgD///7/AAABAAEAAAD//wAAAQAAAP//AQAAAP3/AQAEAP///P8BAAQA///9/wEAAgD///7/AQACAAAA/v///wMAAQD9////AgACAP7//f8CAAMA///9/wEAAwD+//7/AgABAP////8AAAEAAQAAAP7///8DAAEA/f///wIAAQD/////AQAAAP//AQAAAP//AQAAAP//AQABAP7///8DAAAA/f8AAAIAAQD/////AQAAAP//AQABAP7///8DAAEA/f///wIAAQD/////AQAAAP//AQACAP///f8BAAMA///+/wAAAAAAAAIAAQD9//7/AwADAP7//P8BAAQAAAD9////AQAAAAEAAQD+/wAAAgD/////AQAAAP//AAABAAAA//8AAAIAAAD9/wEAAwD+//7/AQAAAP//AgACAP3//v8EAAIA+//9/wUAAwD8//3/AwAEAP3//P8DAAMA/f/+/wQAAAD7/wIABQD+//v/AgAEAP3//v8DAAAA/f8BAAMA///+/wAAAAABAAIA///8/wAABQABAPv//v8EAAMA/f/8/wMABQD8//v/BAADAP7///8AAP//AAADAAEA/f/+/wEAAwAAAP3/AAABAAAAAQAAAP////8BAAEA//8BAAEA/v/+/wEAAwAAAP3///8DAAIA/f///wIA/////wIAAQD+////AgAAAP//AQD/////AgAAAP7/AgACAPz///8FAAAA+/8AAAMAAQD///7/AAACAAEA///+/wAAAgABAP7///8CAAEA/////wAAAAAAAAEAAAD//wEAAQD+////AwAAAP3/AAABAAEAAQD///7/AAACAAAAAAAAAP7/AQADAP///P8AAAUAAAD7/wAABQABAPz///8CAAAA//8BAAEA/v///wMAAQD9////AwABAP7//v8AAAMAAgD9//3/AwAEAP7//f8AAAEAAQAAAP//AAABAAAAAAAAAP7/AAADAAAA/P8AAAUAAAD7/wEABQD+//r/AgAHAP7/+f8CAAYA///8/wEAAgD+////AwAAAPz/AAAEAAAA/f8BAAIA/v///wEAAAD//wEAAgD+//7/AgACAP///v8AAAEAAQAAAP7///8CAAIA/v/+/wIAAgD+//7/AQABAAAAAAD//wAAAgABAP7//v8CAAIA/f/+/wMAAwD+//3/AQACAAEA///9/wAAAwAAAP3/AQAEAP7//P8DAAQA/f/7/wIABQD+//z/AwAEAP3//f8CAAIA///+/wAAAQABAAAA/v8AAAIAAQD+//7/AgACAP7///8BAP//AAACAAAA/v8AAAIAAAAAAP///v8BAAIAAAD+/wAAAwAAAPz///8EAAEA/f///wIAAgAAAP3//v8DAAIA/f///wIAAAD//wIAAAD9/wEAAwD+//3/AgACAP//AAAAAP7/AAADAAAA/f8AAAMAAAD9/wEAAgD9////BAABAPz///8EAAEA/f///wEAAQAAAAAAAAD//wAAAQAAAAAAAAD//wAAAgAAAP7/AAABAP//AAACAAAA//8AAAAAAQAAAP7/AAACAAAA/v8BAAIA/////wEAAQD+////AwAAAPz/AAAEAAAA/f8BAAIA/////wEAAAD+/wAAAwABAPz//v8FAAIA+//+/wMAAgD/////AAAAAAAAAAABAAAA/v8AAAEAAAABAAAA/f8AAAUAAAD7/wAABAAAAP3/AAACAAAA//8AAAAAAAABAP////8CAAEA/v///wIAAAD+/wEAAQD//wAAAQAAAP////8AAAIAAQD+//7/AQADAAEA/P/9/wUAAwD7//7/AwABAP//AAAAAAAAAQD/////AgAAAP3/AQADAP7//f8CAAMA///9/wEABAD///v/AAAFAAAA+/8BAAQA///+/wEAAAD//wIAAAD9/wEAAwD+//3/AgADAP///f8BAAMA/v/9/wIAAgD+/wAAAgD+////AwAAAP3/AAABAAAAAgAAAPz/AAAEAAAA/f8AAAIAAAD/////AQACAP7//v8CAAIA/////wEA/////wIAAAD9/wEABAD///z/AQADAP////8AAP//AQACAAAA/v///wIAAQD+////AgAAAP7/AgACAP3///8DAAAA/f8BAAIA/v///wIAAQD+////AgAAAP//AQAAAP7/AAADAAAA/f8AAAEAAAACAAAA/P///wQAAgD9//7/AgABAAAAAAD+////AgABAP7/AAACAP//AAACAP3//v8FAAAA+f8CAAcA/v/8/wIAAgD+//7/AQACAP///v8DAAMA/P/8/wMABAD+//z/AQAEAAAA/f8AAAEA//8BAAEA/v8AAAIA///+/wEAAgD/////AQAAAP//AQABAP7//v8DAAMA/f/9/wEAAwABAP3//v8CAAMA///9/wAAAgABAP////8AAAEAAAD//wAAAAAAAAEAAAD//wEAAgD+//3/AQADAAAA/f///wMAAgD+//7/AQABAAAAAAD//wAAAQD//wAAAQD/////AQACAAAA/v8AAAEAAAD//wAAAAD//wEAAgD///7/AQACAP///v8BAAEA/v8AAAMA///9/wEAAgAAAAAA///+/wIAAwD9//3/AwACAP7///8BAAAAAAABAAAA//8AAAEAAAD/////AAACAAEA/v///wIAAgD+//3/AQADAAAA/f8AAAIAAAAAAAEA///9/wEABQD///r/AAAGAAIA/P/9/wIABAAAAPv///8FAAAA/P8CAAMA/f/+/wMAAQD+////AAABAAEA/////wIAAQD8/wAABQD///v/AAAEAAEA/f///wIAAQAAAAAA/////wEAAgD+//7/AgABAAAAAAD//wAAAQABAP///v8BAAIA/////wIAAAD9/wEABAD+//v/AgAFAP///P8AAAIAAAAAAAAA//8AAAIAAAD9/wEAAgD9////BAABAPz///8EAAIA/P/9/wQABAD8//z/AwADAP///f///wMAAgD/////AAD//wAAAgD///7/AQACAP////8CAAAA/v8AAAEAAQAAAP7///8DAAEA/P8AAAQA///+/wEAAQD/////AQAAAAAAAQD/////AQABAP////8BAAEAAQD+//7/AgACAP7//f8DAAQA/f/8/wEABQAAAPv/AAAEAAEA/P/+/wQAAgD9////AgABAP7///8CAAAA/v8AAAIAAgD///3/AAADAAAA/f8AAAIAAAD//wAAAAABAAEA/////wAAAAABAAEA/v/+/wIAAgD///7/AQACAP///v8AAAIAAQD///////8AAAEAAQAAAP//AAABAAAA//8AAAAA//8BAAIA///+/wEAAgAAAP7//v8CAAMA/v/9/wIAAgD+/wAAAgD///7/AAACAAEA/////wAAAAAAAAEAAAD+/wAAAwABAP7///8AAAAAAQAAAP7/AAADAAAA/f8AAAMAAAD9////AwACAP3//f8CAAMA///+/wEAAQAAAAAA//8AAAEA/////wIAAQD+/wAAAQD//wAAAQAAAP//AAACAP///f8BAAMAAAD+////AQABAP//AAABAP7///8EAAIA+//+/wMAAQAAAP////8BAAAAAAABAAAA/v///wMAAQD+////AAACAAAA/f8AAAMAAQD+////AgABAP3//v8EAAIA+////wYAAAD7/wAAAgAAAAEAAAD9/wAABAAAAPz/AAADAP///f8CAAQA/f/8/wMABAD+//z/AQADAP///v8BAAIA///+/wIAAwD9//z/AgAEAP///P8BAAQAAAD9/wAAAgD+////AwAAAP7/AAAAAAAAAgABAPz//v8FAAIA/P/+/wMAAQD9/wEAAwD+//7/AQABAAEAAAD9////BAACAP3//v8BAAEAAQAAAP3///8EAAEA/P8AAAQA///8/wIAAwD9//7/AwACAP7///8CAP///f8CAAQA/v/8/wIAAwD//////////wIAAQD//wAAAAD//wEAAQD+/wAAAgD///7/AgACAP7//v8AAAMAAgD8//3/BAAEAPz//f8DAAEA/v8AAAIA/////wIAAAD+/wAAAgAAAP3/AAADAAEA/v/+/wIAAgD+////AgAAAP7/AQACAP7//v8DAAIA/f/+/wIAAwD+//3/AgACAP////8AAAAAAAABAAAA/v8AAAIAAAD/////AAACAAEA/v///wIAAAD9/wAABAABAP3///8BAAEAAAD/////AQABAP//AQABAP3///8DAAEA/v8AAAEA//8AAAEAAAAAAP7///8EAAIA+//+/wUAAQD8/wAAAwAAAP7///8BAAIAAAD+//7/AQAEAAEA+//+/wUAAQD8/wAAAwD///3/AwADAPz//f8EAAMA/P/+/wQAAQD9////AgABAP////8AAAAAAQABAP////8AAAEAAgD///z/AQAFAP//+/8BAAQAAAD+////AAACAAEA/v/+/wEAAgABAP///v8AAAEAAQAAAP7///8BAAIAAQD+////AQAAAP//AQABAP3///8EAAEA/f///wIAAQD/////AAABAAAA//8AAAEAAAAAAAAA//8AAAIAAAD+/wAAAQAAAAEA///9/wIABAD+//z/AgADAP7//v8BAAIAAAD+////AgACAP3//v8EAAEA/f8AAAIA///+/wEAAQD//wEAAQD/////AQABAP7///8BAAEAAQD+//7/AwACAP3///8DAAAA/f8BAAIA/v8AAAIA/v/+/wMAAwD9//3/AgACAAAA/////wAAAAABAAIA///8/wEABQD///z/AgACAP3/AAADAP///f8BAAMA///+/wEAAAD//wEAAQD//wAAAQD/////AgAAAP3/AAADAAAA/v8BAAIA///+/wAAAQABAAAA/v8AAAIA///+/wEAAgAAAP7///8DAAMA/P/7/wMABQD+//3/AQACAAEA/v///wIAAAD+/wAAAgAAAP//AAD//wEAAwD+//z/AgAEAP///P8BAAMA///+/wAAAgABAP7///8BAAIAAAD+////AQABAAAA/////wEAAQD//wAAAQD/////AgABAP3/AAACAP//AAABAP////8BAAEA//8AAAAA//8BAAIA///9/wEAAwD///7/AQAAAP7/AgACAP3/AAADAP7//v8DAAEA/f///wEAAgABAP3///8EAAAA+/8BAAUA/v/8/wIAAwD/////AAD//wAAAgAAAP7/AAABAAEAAAD+////AgABAP7/AQACAP3//v8EAAIA+//+/wUAAgD9//7/AgABAP//AAD//wAAAwAAAP3/AAACAAAA//8AAAAAAAABAAAA//8AAAAAAAABAAAA/v///wMAAQD8/wAABQAAAPv/AAAFAP//+/8BAAQA///9/wIAAgD+////AQABAAAA/////wAAAgABAP3///8DAAEA/v///wEAAAAAAAEA//8AAAEA//8AAAEA///+/wEAAwD///3/AgACAP3///8DAAEA/v///wAAAAACAAAA/v8AAAEAAAD//wEAAQD//wAAAAAAAAEAAAD+////AgABAAAA///+/wIAAgD9////AwAAAP3/AQACAP//AAD///7/AgADAP7//P8CAAQA/v/+/wMAAAD7/wEABgD+//r/AgAGAP///P8BAAEA/v8AAAMAAAD9/wAAAgABAP///v8BAAEA//8BAAEA/v///wIAAQD+////AQABAAAA//8AAAEAAAAAAAAA/////wEAAQD//wAAAQD//wAAAgAAAP3/AAADAP7//v8DAAEA/f///wQAAQD8////AgABAP////8BAAEA/////wIAAQD8////BQAAAPz/AQADAAAA/f/+/wIABAAAAPr///8HAAIA+f/9/wUAAgD9////AgABAP////8BAAEA/f///wQAAQD8////BAABAP3///8CAAEA/v8AAAIA///+/wEAAgD///7/AQACAAAA/v8AAAIA///+/wEAAgD///7/AQACAAAA/f8AAAUA///6/wEABQD///3/AQABAAEAAQD+////AgD///7/AwACAP3///8CAAEA/////wAAAAABAAIA///9/wAAAwAAAP3/AAACAAEA///+/wEAAgD///7/AAACAAEA/v/+/wMAAgD9////AgAAAP//AQAAAP7/AQACAP////8BAAAA/v8AAAMAAAD9/wAAAgABAP///v8AAAIAAQD9//7/BAACAPz///8EAAAA/P8AAAMAAQD+//7/AQADAAEA/P/9/wMABAD///z/AAAEAAAA/f8BAAIA/v/+/wIAAgD+//7/AgADAP7//f8DAAIA/P/+/wQAAQD8/wEAAwD+////AwAAAPz/AAADAAAA////////AgADAP///P///wMAAwD///z/AAAEAAAA/f8BAAIA/v///wMAAAD9/wAAAgAAAAAAAQD///7/AQACAAAA/f///wQAAQD9/wAAAgD///7/AgACAP7//v8BAAMAAAD8/wAABAD///z/AgAEAP7//P8BAAQAAAD7/wAABQAAAP3/AAABAP//AAABAP////8BAAMAAQD8//7/AwABAP3/AAADAP///f8CAAQA/v/8/wIAAwD+//7/AQABAAAA//8AAAIA///+/wIAAgD+//3/AgADAP3//v8DAAEA/v8AAAEA//8AAAIA///+/wAAAQACAP///v8CAAEA/v8AAAIA///+/wEAAgAAAP7///8CAAIA/v/9/wEAAwABAP3//v8CAAIAAAD+//7/AQADAAEA/f/+/wMAAgD9////AgAAAP//AQAAAP7/AQADAP///f8AAAIAAQD///7/AAADAAEA/f///wMAAQD+//7/AAADAAIA/f/9/wMAAwD+//7/AAABAAIAAAD+/wAAAQD//wAAAgD///3/AQAEAP///P8BAAMAAAD+////AQABAAAA/v///wIAAQD/////AQABAP//AAAAAAAAAQAAAP7///8CAAIAAAD+//3/AgAGAP7/+f8CAAUA/v/+/wMA///9/wMAAQD+/wAAAAAAAAEAAQD+////AwAAAP7/AAABAAAA//8BAAAA//8CAAAA/v8AAAEAAQAAAP///v8AAAQAAQD8////BAABAPz///8DAAAA/v8BAAIA///+/wEAAQD//wAAAAAAAAIA///8/wEABQD///v/AQAFAP///P8BAAIA/////wEAAQD/////AAABAAAA//8CAAEA/f///wMAAQD9//7/AgACAAAA///+/wAAAwABAP3//v8DAAIA/f/+/wIAAgD///7/AQACAP////8BAAAA//8AAAEAAAAAAAEA/////wIAAQD+////AQABAP///v8CAAMA/f/9/wMAAwD9//7/AgAAAAAAAQD///7/AAADAAAA/f8AAAIAAQD/////AAAAAAEAAAD//wAAAAABAAAA/v8BAAIA/v/+/wIAAgD/////AAAAAAEAAQD+//7/AQADAAEA/P/+/wUAAgD7//7/BAABAP3/AAADAAAA/f///wMAAQD9/wAAAgAAAAAA/////wEAAAD//wEAAQD//wEAAQD9////AgAAAAAAAQD/////AgAAAP3/AQADAP7//v8CAAEA/v8BAAIA/v/+/wEAAgABAP7//f8CAAQA///8////AwADAP7//P8CAAQA/f/9/wMAAQD+/wEAAQD+/wAAAgD///7/AQACAAAA/v///wIAAgD///3/AAADAAEA/f/+/wMAAgD+//7/AAADAAEA/f///wIAAQD/////AAAAAAEAAQAAAP7//v8DAAMA/P/9/wQAAwD9//7/AgAAAP7/AQABAP//AAABAAAA//8BAAAA/v8BAAEA//8AAAEAAAD//wAAAAABAAEA/v/+/wIAAwD+//3/AgACAP7///8CAAAA//8AAAAAAQAAAP7/AAACAAAA//8BAAAA//8BAAAA/v8AAAIAAAD//wEAAQD/////AAAAAAAAAQAAAP7/AQAEAP//+/8AAAQAAAD+/wEAAAD+/wIABAD9//v/AwAEAP3//v8DAAAA/v8CAAEA/v8AAAEA/////wEAAQD/////AQABAP//AAACAP7//f8DAAMA/v/9/wEAAwD///7/AQABAP7/AAADAP///v8CAAEA/v8AAAEA//8AAAEA//8AAAIAAAD+////AQACAAAA/f///wUAAgD6//7/BQACAPz//v8DAAIA/v/+/wEAAgAAAP7///8CAAEA/v8AAAIA/v/+/wMAAgD+//3/AAAEAAIA/P/8/wMABAD+//7/AQABAAAA//8AAAEAAAD//wAAAQD/////AgABAP3///8EAAIA/f/+/wEAAAD//wEAAQD//wAAAQD//wAAAgD///3/AQADAP7//v8DAAEA/f///wMAAQD9/wAAAgD///7/AQADAP///P8BAAQAAAD9////AQABAAEA///9/wEAAwAAAP///////wAAAgABAP3///8DAAEA/v///wEAAAD//wEAAQD/////AQABAP////8AAAEAAQD/////AQABAP////8BAAAAAAAAAP//AQACAP7//f8DAAQA/P/8/wQABAD9//z/AQADAAEA/v/+/wIAAgD+////AgAAAP3/AAAEAAAA/P8AAAQAAQD8//7/AwACAP7//v8CAAIA/v///wIAAAD+/wAAAQAAAAAAAAAAAAEAAAD//wAAAAAAAP////8DAAEA/P8BAAUA/f/7/wQAAwD8/wAAAgD+/wAAAgAAAP////8AAAIAAQD+////AQAAAP//AAACAAAA/f8AAAQAAQD8//7/AgACAAEA/v/9/wIAAwD///7/AAABAAAAAAABAP///f8CAAQA/v/8/wIAAwD9/wAAAwD9//7/AwACAP7//f8BAAMAAQD9//7/BAABAPz/AAADAAAA/f8AAAMAAAD+////AQABAAAAAQD///7/AQABAP//AAABAP//AAACAP///v8BAAIA///+/wAAAgABAP////8AAAEAAAD//wAAAAAAAAEAAQD+////AwAAAP3///8CAAIA///+/wEAAwD+//z/BAADAPv//f8FAAQA+//9/wQAAgD+//7/AQACAAAA/v///wIAAQD+/wAAAgD/////AgABAP3//v8EAAEA/P8BAAMA/f/+/wUAAQD6////BQACAP3//v8BAAEAAAAAAAAA//8AAAIAAQD+//7/AgACAP7//v8BAAMAAAD9////AgACAP///v8BAAAA//8BAAEA///+/wIAAgD+////AQAAAP7/AQAEAP7/+/8CAAYA/f/6/wMABQD///z///8DAAMA/v/7/wEABQAAAPz///8DAAEA//8AAAAA/////wEAAgD///7/AAADAAIA/P/9/wMAAgD+/wAAAQD+/wEAAwD9//3/BAACAPv/AAAFAP7//P8DAAMA/f/9/wIAAwD///3/AQADAP7//v8DAAAA/f8CAAIA/f/+/wMAAgD9//7/AwADAP7//P8BAAMA///+/wEAAQD//wEAAQD+////AQAAAAAAAgAAAP3/AAADAAEA/f/+/wIAAgAAAP7/AAADAAAA/P///wQAAgD9//3/AgADAP///v8AAAEAAAAAAAEA///+/wIAAgD9//7/BAACAPz///8DAAAA//8AAP//AAADAAAA/f8AAAIAAAD//wEAAAD+/wAAAgABAP7//v8CAAMA///9/wAAAgAAAP//AAD//wAAAwAAAP3/AAACAAAA/////wAAAgABAP7///8BAAAAAQABAP3///8DAAEA/v///wEAAAAAAAEAAAAAAP////8BAAEAAAD/////AQABAP////8BAAEAAAAAAP////8BAAAA//8CAAAA/f8BAAQAAAD7////BQABAPz///8EAAAA/P8CAAMA/f/9/wMABAD9//3/AgACAAAA/v///wEAAgABAP3///8CAAEAAAD/////AQACAP///f8BAAMA///+/wEAAgAAAP3//v8DAAIA/v///wEAAQAAAAAAAAD9////BAACAPz//f8FAAQA+//8/wMAAwD///7/AAABAAEAAQD+//7/AgABAP//AAABAP////8CAAEA/v///wEAAQAAAAAA/////wIAAQD+/wAAAQD//wAAAgD///3/AwACAP3/AAABAP//AAABAAAA//8BAAAA/v8BAAIA///+/wIAAgD8////BQD///v/AwAEAPz//v8DAAAA/v8CAAEA/f8AAAMAAAD9/wAAAwAAAP3/AAADAP///v8DAAEA/P///wQAAQD9////AQACAAIA/v/8/wAABAACAP3//f8CAAQA///8/wAAAwABAP7///8BAAEAAAD/////AAADAAEA+/8AAAUA///8/wEAAwD/////AQAAAAAAAAAAAAAA/////wIAAwD9//3/AwADAP7//f8BAAEAAAABAP////8CAAEA/v///wEAAAAAAAEA/////wEAAQABAP7//f8CAAQA///8/wAAAwABAP7//v8BAAEAAAAAAP//AAACAAAA/v8AAAIAAAD+/wAAAQAAAAEAAAD9/wAABAAAAPz/AQADAP////8AAAAAAQAAAP7///8CAAEA//8AAAEAAAD//wEAAQD+////AQAAAAEAAgD9//3/BAADAPz//v8EAAEA/f///wIAAQD9////AwACAP///v8AAAEAAAD+////AwABAP3/AQADAP7//v8CAP///v8CAAEA/v8BAAIA/////wAA//8BAAEA/v8AAAIA//8AAAIA///9/wEAAwD///7/AAACAAEA/v8AAAEA//8AAAEAAAD//wEAAQD/////AAACAAAA/v8BAAEA/v8AAAMA///9/wIAAgD+//7/AgACAP7//v8BAAIAAAD/////AAACAAAA/v8AAAEAAABMSVNUPAAAAElORk9JTkFNFgAAAHF1YXRlciBzZWNvbmQgc2lsZW5jZQBJQVJUBAAAAHNhbQBJQ1JEBgAAADIwMjEAAGlkMyBIAAAASUQzAwAAAAAAPVRJVDIAAAAWAAAAcXVhdGVyIHNlY29uZCBzaWxlbmNlVERSQwAAAAUAAAAyMDIxVFBFMQAAAAQAAABzYW0A';
