<a href="https://postmarkapp.com">
    <img src="postmark.png" alt="Postmark Logo" title="Postmark" width="120" height="120" align="right">
</a>

# Postmark Java Library
[![Build Status](https://circleci.com/gh/ActiveCampaign/postmark-java.svg?style=shield)](https://circleci.com/gh/ActiveCampaign/postmark-java)
[![License](http://img.shields.io/badge/license-MIT-blue.svg?style=flat)](http://www.opensource.org/licenses/MIT)
[![Maven Central](https://maven-badges.herokuapp.com/maven-central/com.postmarkapp/postmark/badge.svg)](https://maven-badges.herokuapp.com/maven-central/com.postmarkapp/postmark)

:star: :star: **IMPORTANT UPDATE** :star: :star: **As of version 1.9.0, we migrated from groupid ```com.wildbit.java``` to ```com.postmarkapp```.**
Please update your pom.xml file with new groupid and your imports to use the latest versions of the library. 

Check out the new groupid in pom example below, under [installation section](#installation).

Postmark allows you to send your application's emails with high delivery rates, including bounce/spam processing and detailed statistics. 
In addition, Postmark can parse incoming emails which are forwarded back to your application.

The Postmark Java Library makes it easier to use the Postmark API from your Java 8+ projects without having to build your own API calls. 

## Usage

Please see the [wiki](https://github.com/ActiveCampaign/postmark-java/wiki) for detailed instructions about sending email, using the bounce api, and other Postmark API options.
For details about Postmark API in general, please check out [Postmark developer docs](https://postmarkapp.com/developer).

## Installation

Add the dependency to your project:

``` xml
<dependency>
    <groupId>com.postmarkapp</groupId>
    <artifactId>postmark</artifactId>
    <version>{version}</version>
</dependency>
```

Note: to retrieve the latest version number, visit [maven central repository](https://repo1.maven.org/maven2/com/postmarkapp/postmark/) , or check the badge at top of the page which is showing the latest version synced to Maven repository.
[Maven central repository link](https://repo1.maven.org/maven2/com/postmarkapp/postmark/) might be slightly more accurate, in case when new version was published recently.

Old versions of the library can be found in this [maven central repository](https://repo1.maven.org/maven2/com/wildbit/java/postmark/).

## Issues & Comments

Feel free to contact us if you encounter any issues with the library or Postmark API. For any known issues and resolutions, please check out the [wiki section](https://github.com/ActiveCampaign/postmark-java/wiki/Known-issues-and-how-to-resolve-them).
Please leave all comments, bugs, requests and issues on the Issues page.  

## License

The Postmark Java Library is licensed under the [MIT](http://www.opensource.org/licenses/mit-license.php) license. 
Refere to the [LICENSE](https://github.com/ActiveCampaign/postmark-java/blob/master/LICENSE) file for more information.
