# Food Delivery App

## Introduction

Welcome to the Food Delivery App, built using the amazing React Native framework! This app allows you to order your favorite food from the comfort of your home, without the need to go out and face the traffic.

## 💻 Requirements

- Any Operating System (ie. MacOS X, Windows)
- Android Studio IDE
- A little knowledge of Android.




## 📸 ScreenShots

<img src="https://user-images.githubusercontent.com/62107887/226867792-391e6d0c-64d5-4baf-897e-bf80e103c4a8.png" width="325" height="650">   |
<img src="https://user-images.githubusercontent.com/62107887/226867827-421c458f-6b0b-4e4b-9ef2-9076d0cdbab8.png" width="325" height="650">   |
<img src="https://user-images.githubusercontent.com/62107887/226867872-926ac761-6fd4-49f7-8042-c847bc99beed.png" width="325" height="650">   |
<img src="https://user-images.githubusercontent.com/62107887/226867890-12bec657-a532-4baf-ab3c-07917c123725.png" width="325" height="650">   |
<img src="https://user-images.githubusercontent.com/62107887/226867917-d8bb3889-bc53-421d-941f-4df111f06681.png" width="325" height="650">   |


## ✨ Features

- #### Sign up or log in 🚪

    If you're a new user, click on "Sign Up" and enter your details 📝
    
    If you're an existing user, click on "Log In" and enter your credentials 🔑
- #### Browse and select 🍔

    Browse through the menus of your favorite restaurants 🍴
    
    Select the items you want to order 📝
    
    Customize your order according to your taste 🌶️
- #### Checkout and pay 💳

    Review your order 🧐
    
    Add any promo codes if you have them 💰
    
    Choose your payment method and make the payment 💳
- #### Sit back and relax 🛋️

    Wait for your food to be prepared and delivered 🚚
    
    Track your order in real-time ⏰
    
    Enjoy your delicious food 🍕
    
## ✨ Steps    

Here's how you can get started with the app:

- #### Clone the repository 📥

    Go to the repository page on GitHub 🌐
    
    Click on the "Code" button and copy the repository link 🔗
    
    Open your terminal and navigate to the directory where you want to clone the repository 🖥️
    
    Run the command git clone <repository link> and wait for the repository to be cloned 🕐
    
- #### Install the dependencies 📦

    Navigate to the cloned repository in your terminal 🖥️
    
    Run the command npm install to install all the dependencies 📝
    
    Run the app 🚀
    
    Run the command npm start to start the app 🚀
    
    Scan the QR code with your phone camera or use an emulator to run the app 📱
    
- #### Contribute and make a pull request 🙌

    Make your own changes to the code and test it locally 🛠️
    
    Push your changes to your own fork of the repository 🚀
    
    Create a pull request to merge your changes into the main repository 🙏
    
    
    Thank you for checking out the Food Delivery App! We hope you find it useful and would love to see your contributions. Happy coding! 🍟🍗🌭
    
## Design Credits : 

[FoodHub](https://www.figma.com/community/file/1016293188579696778) Figma Community Design


## 🤓 Author(s)

**Abdullah Sheikh**
[![Twitter Follow](https://img.shields.io/twitter/follow/Abdullah_shk_.svg?style=social)](https://twitter.com/Abdullah_shk_)

## 🔖 LICENCE

[MIT](https://github.com/Abdullah-Sheikh/WeatherApp_Android/blob/master/licence)
