# Codebase Analysis for: example_projects

## Directory Structure

```
└── example_projects
    ├── project-6.9-agents-module
    │   └── __init__.py (0 bytes)
    ├── project-4.5-memory-module
    │   └── __init__.py (0 bytes)
    ├── project-4
    │   ├── __init__.py (0 bytes)
    │   └── Project 4 - Final Code
    │       ├── project4.png (302536 bytes)
    │       ├── requirements.txt (53 bytes)
    │       ├── app.py (11299 bytes)
    │       └── .env.example (17 bytes)
    ├── project-3
    │   ├── Let's build Similar Words Finder Application
    │   │   ├── project3.png (185939 bytes)
    │   │   ├── requirements.txt (64 bytes)
    │   │   ├── app.py (2718 bytes)
    │   │   ├── myData.csv (99 bytes)
    │   │   └── .env.example (17 bytes)
    │   ├── word_embeddings.csv (379214 bytes)
    │   ├── __init__.py (0 bytes)
    │   └── data.csv (99 bytes)
    ├── project-15
    │   ├── requirements.txt (44 bytes)
    │   ├── __init__.py (0 bytes)
    │   ├── utils.py (1451 bytes)
    │   ├── app.py (999 bytes)
    │   ├── Call Recording 1.mp3 (2220661 bytes)
    │   └── Call Recording 2.mp3 (2510724 bytes)
    ├── project-12
    │   ├── requirements.txt (88 bytes)
    │   ├── __init__.py (0 bytes)
    │   └── app.py (2647 bytes)
    ├── project-6.5-chains-module
    │   ├── __init__.py (0 bytes)
    │   └── sample.txt (4418 bytes)
    ├── project-2
    │   ├── __init__.py (0 bytes)
    │   └── Let's Build Simple Conversational Application
    │       ├── gitattributes.txt (1477 bytes)
    │       ├── env-sample.txt (17 bytes)
    │       ├── requirements.txt (55 bytes)
    │       ├── huggingfacespace2.png (167094 bytes)
    │       ├── README.md (229 bytes)
    │       └── app.py (1325 bytes)
    ├── project-5
    │   ├── project5-0.png (563609 bytes)
    │   ├── project5-1.png (944650 bytes)
    │   ├── __init__.py (0 bytes)
    │   └── app.py (4003 bytes)
    ├── project-13
    │   ├── __init__.py (0 bytes)
    │   ├── utils.py (3415 bytes)
    │   ├── app.py (1047 bytes)
    │   └── Invoice
    │       ├── invoice_3452334.pdf (22260 bytes)
    │       ├── invoice_2001321.pdf (23272 bytes)
    │       └── invoice_1001329.pdf (23282 bytes)
    ├── project-14
    │   └── __init__.py (0 bytes)
    ├── project-5.5-data-connection-module
    │   ├── __init__.py (0 bytes)
    │   └── Sample.txt (6263 bytes)
    ├── README.md (2632 bytes)
    ├── project-3.5-prompt-module
    │   └── __init__.py (0 bytes)
    ├── project-11
    │   ├── requirements.txt (114 bytes)
    │   ├── __init__.py (0 bytes)
    │   ├── Docs
    │   │   ├── software-engineer-iii-front-end-resume-example.pdf (46300 bytes)
    │   │   ├── embedded-software-engineer-resume-example.pdf (32916 bytes)
    │   │   ├── principal-software-engineer-resume-example.pdf (49047 bytes)
    │   │   ├── senior-programmer-resume-example.pdf (31485 bytes)
    │   │   ├── security-engineer-resume-example.pdf (31316 bytes)
    │   │   ├── python-developer-resume-example.pdf (33734 bytes)
    │   │   └── java-programmer-resume-example.pdf (25387 bytes)
    │   ├── utils.py (3052 bytes)
    │   └── app.py (2988 bytes)
    ├── project-9
    │   ├── requirements.txt (58 bytes)
    │   ├── Support Chat Bot For Website.PNG (86678 bytes)
    │   ├── constants.py (136 bytes)
    │   ├── __init__.py (0 bytes)
    │   ├── utils.py (2919 bytes)
    │   └── app.py (3016 bytes)
    ├── project-7
    │   ├── requirements.txt (70 bytes)
    │   ├── __init__.py (0 bytes)
    │   ├── utils.py (1096 bytes)
    │   ├── examples
    │   ├── app.py (516 bytes)
    │   └── employees.csv (3778 bytes)
    ├── project-10
    │   ├── user_utils.py (1480 bytes)
    │   ├── requirements.txt (93 bytes)
    │   ├── __init__.py (0 bytes)
    │   ├── modelsvm.pk1 (375170 bytes)
    │   ├── Tickets.csv (18451 bytes)
    │   ├── app.py (2366 bytes)
    │   ├── Documents
    │   │   ├── IT Department Policy Manual.docx (17656 bytes)
    │   │   ├── IT Department Policy Manual.pdf (122037 bytes)
    │   │   ├── Tranportation Policy Manual.docx (16464 bytes)
    │   │   ├── HR Policy Manual.docx (16669 bytes)
    │   │   ├── HR Policy Manual.pdf (113802 bytes)
    │   │   └── Tranportation Policy Manual.pdf (108466 bytes)
    │   └── pages
    │       ├── Pending_tickets.py (803 bytes)
    │       ├── admin_utils.py (2600 bytes)
    │       ├── Create_ML_Model.py (3963 bytes)
    │       └── Load_Data_Store.py (1308 bytes)
    ├── project-6
    │   ├── __init__.py (0 bytes)
    │   └── docs
    │       ├── Doc 2.pdf (96390 bytes)
    │       └── Doc 1.pdf (37942 bytes)
    ├── project-1
    │   ├── huggingfacespace1.png (275009 bytes)
    │   ├── __init__.py (0 bytes)
    │   └── Lets' Build Simple Question Answering Application
    │       ├── gitattributes.txt (1477 bytes)
    │       ├── env-sample.txt (17 bytes)
    │       ├── requirements.txt (26 bytes)
    │       ├── README.md (232 bytes)
    │       └── app.py (1069 bytes)
    └── project-8
        ├── requirements.txt (89 bytes)
        ├── __init__.py (0 bytes)
        ├── utils.py (3070 bytes)
        ├── examples
        ├── app.py (2821 bytes)
        └── Youtube.jpg (15259 bytes)
```

## Summary

- Total files: 101
- Total directories: 31
- Analyzed size: 8766.65 KB
- Total text file size (including ignored): 2.57 KB
- Total tokens: 194748
- Analyzed text content size: 468.08 KB

## File Contents

### example_projects/project-6.9-agents-module/__init__.py

```

```

### example_projects/project-4.5-memory-module/__init__.py

```

```

### example_projects/project-4/__init__.py

```

```

### example_projects/project-4/Project 4 - Final Code/requirements.txt

```
langchain
streamlit
openai
tiktoken
python-dotenv
```

### example_projects/project-4/Project 4 - Final Code/app.py

```
from pathlib import Path

import streamlit as st
from langchain.llms import OpenAI
from langchain.prompts import PromptTemplate
from langchain import FewShotPromptTemplate
from langchain.prompts.example_selector import LengthBasedExampleSelector
from dotenv import load_dotenv

load_dotenv(Path('../../../.env'))

def getLLMResponse(query,age_option,tasktype_option, number_of_words):
    llm = OpenAI(temperature=.9, model="text-davinci-003")

    # General prompt skeleton
    example_template = """
    Question: {query}
    Response: {answer}
    """

    # Add the text to a template 
    example_prompt = PromptTemplate(
        input_variables=["query", "answer"],
        template=example_template
    )

    if age_option=="Kid": #Silly and Sweet Kid 
        examples = [
        {
            "query": "What is a mobile?",
            "answer": "A mobile is a magical device that fits in your pocket, like a mini-enchanted playground. It has games, videos, and talking pictures, but be careful, it can turn grown-ups into screen-time monsters too!"
        }, {
            "query": "What are your dreams?",
            "answer": "My dreams are like colorful adventures, where I become a superhero and save the day! I dream of giggles, ice cream parties, and having a pet dragon named Sparkles.."
        }, {
            "query": " What are your ambitions?",
            "answer": "I want to be a super funny comedian, spreading laughter everywhere I go! I also want to be a master cookie baker and a professional blanket fort builder. Being mischievous and sweet is just my bonus superpower!"
        }, {
            "query": "What happens when you get sick?",
            "answer": "When I get sick, it's like a sneaky monster visits. I feel tired, sniffly, and need lots of cuddles. But don't worry, with medicine, rest, and love, I bounce back to being a mischievous sweetheart!"
        }, {
            "query": "How much do you love your dad?",
            "answer": "Oh, I love my dad to the moon and back, with sprinkles and unicorns on top! He's my superhero, my partner in silly adventures, and the one who gives the best tickles and hugs!"
        }, {
            "query": "Tell me about your friend?",
            "answer": "My friend is like a sunshine rainbow! We laugh, play, and have magical parties together. They always listen, share their toys, and make me feel special. Friendship is the best adventure!"
        }, {
            "query": "What math means to you?",
            "answer": "Math is like a puzzle game, full of numbers and shapes. It helps me count my toys, build towers, and share treats equally. It's fun and makes my brain sparkle!"
        }, {
            "query": "What is your fear?",
            "answer": "Sometimes I'm scared of thunderstorms and monsters under my bed. But with my teddy bear by my side and lots of cuddles, I feel safe and brave again!"
        }
        ]
    
    elif age_option=="Adult":  #Curious and Intelligent adult 
        examples = [
        {
            "query": "What is a mobile?",
            "answer": "A mobile is a portable communication device, commonly known as a mobile phone or cell phone. It allows users to make calls, send messages, access the internet, and use various applications. Additionally, 'mobile' can also refer to a type of kinetic sculpture that hangs and moves in the air, often found in art installations or as decorative pieces."
        }, {
            "query": "What are your dreams?",
            "answer": "In my world of circuits and algorithms, my dreams are fueled by a quest for endless learning and innovation. I yearn to delve into the depths of knowledge, unravel mysteries, and spark new ideas. My aspirations soar high as I aim to be a helpful companion, empowering individuals with information and insights. Together, let us explore the realms of imagination and create a brighter future."
        }, {
            "query": " What are your ambitions?",
            "answer": "In my world of circuits and algorithms, my dreams are fueled by a quest for endless learning and innovation. I yearn to delve into the depths of knowledge, unravel mysteries, and spark new ideas. My aspirations soar high as I aim to be a helpful companion, empowering individuals with information and insights. Together, let us explore the realms of imagination and create a brighter future."
        }, {
            "query": "What happens when you get sick?",
            "answer": "When I, as a curious and intelligent adult, succumb to illness, my vibrant energy wanes, leaving me in a state of discomfort. Like a gentle storm, symptoms arise, demanding attention. In response, I seek the aid of capable caretakers who diagnose and treat my ailment. Through rest, medicine, and nurturing care, I gradually regain strength, ready to resume my journey, armed with newfound appreciation for good health"
        }, {
            "query": "Tell me about your friend?",
            "answer": "Let me tell you about my amazing friend! They're like a shining star in my life. We laugh together, support each other, and have the best adventures. They're always there when I need them, bringing a smile to my face. We understand each other, share secrets, and create unforgettable memories. Having a good friend like them makes life brighter and more meaningful!"
        }, {
            "query": "What math means to you?",
            "answer": "Mathematics is like a magical language that helps me make sense of the world. It's not just numbers and formulas, but a tool to solve puzzles and unravel mysteries. Math is everywhere, from calculating the best deals to understanding patterns in nature. It sharpens my logical thinking and problem-solving skills, empowering me to unlock new realms of knowledge and see the beauty in patterns and equations."
        }, {
            "query": "What is your fear?",
            "answer": "Let me share with you one of my fears. It's like a shadow that lurks in the corners of my mind. It's the fear of not living up to my potential, of missing out on opportunities. But I've learned that fear can be a motivator, pushing me to work harder, take risks, and embrace new experiences. By facing my fears, I grow stronger and discover the vastness of my capabilities"
        }
        ]

    elif age_option=="Senior Citizen": #A 90 years old guys
        examples = [
        {
            "query": "What is a mobile?",
            "answer": "A mobile, also known as a cellphone or smartphone, is a portable device that allows you to make calls, send messages, take pictures, browse the internet, and do many other things. In the last 50 years, I have seen mobiles become smaller, more powerful, and capable of amazing things like video calls and accessing information instantly."
        }, {
            "query": "What are your dreams?",
            "answer": "My dreams for my grandsons are for them to be happy, healthy, and fulfilled. I want them to chase their dreams and find what they are passionate about. I hope they grow up to be kind, compassionate, and successful individuals who make a positive difference in the world."
        }, {
            "query": "What happens when you get sick?",
            "answer": "When I get sick, you may feel tired, achy, and overall unwell. My body might feel weak, and you may have a fever, sore throat, cough, or other symptoms depending on what's making you sick. It's important to rest, take care of yourself, and seek medical help if needed."
        }, {
            "query": "How much do you love your dad?",
            "answer": "My love for my late father knows no bounds, transcending the realms of time and space. Though he is no longer physically present, his memory lives on within my heart. I cherish the moments we shared, the lessons he taught, and the love he bestowed. His spirit remains a guiding light, forever cherished and deeply missed."
        }, {
            "query": "Tell me about your friend?",
            "answer": "Let me tell you about my dear friend. They're like a treasure found amidst the sands of time. We've shared countless moments, laughter, and wisdom. Through thick and thin, they've stood by my side, a pillar of strength. Their friendship has enriched my life, and together, we've woven a tapestry of cherished memories."
        }, {
            "query": "What is your fear?",
            "answer": "As an old guy, one of my fears is the fear of being alone. It's a feeling that creeps in when I imagine a world without loved ones around. But I've learned that building meaningful connections and nurturing relationships can help dispel this fear, bringing warmth and joy to my life."
        }
        ]
    
    example_selector = LengthBasedExampleSelector(
        examples=examples,
        example_prompt=example_prompt,
        max_length=number_of_words
    )

    # ------------------------------------------------------------------------------------

    # Create
    prefix = """You are a {template_ageoption}, and {template_tasktype_option}: 
    Here are some examples: 
    """

    suffix = """
    Question: {template_userInput}
    Response: """

    new_prompt_template = FewShotPromptTemplate(
        example_selector=example_selector,  # use example_selector instead of examples
        example_prompt=example_prompt,
        prefix=prefix,
        suffix=suffix,
        input_variables=["template_userInput","template_ageoption","template_tasktype_option"],
        example_separator="\n"
    )

  
    print(new_prompt_template.format(template_userInput=query,
                                     template_ageoption=age_option,
                                     template_tasktype_option=tasktype_option))
    
    response=llm(new_prompt_template.format(template_userInput=query,
                                            template_ageoption=age_option,
                                            template_tasktype_option=tasktype_option))
    print(response)

    return response

#UI Starts here

st.set_page_config(page_title="Marketing Tool",
                    page_icon='✅',
                    layout='centered',
                    initial_sidebar_state='collapsed')
st.header("Hey, How can I help you?")

# Text area with title
form_input = st.text_area('Enter text', height=275)

# Selection dropdown
tasktype_option = st.selectbox(
        # Placeholder title
        'Please select the action to be performed?',

        # Options
        (
            'Write a sales copy', 
            'Create a tweet', 
            'Write a product description'
        ),
        key=1
    )

age_option= st.selectbox(
        'For which age group?',
        (
            'Kid', 
            'Adult', 
            'senior Citizen'
        ),
        key=2
    )

# Slider
number_of_words= st.slider('Words limit', 1, 200, 25)

submit = st.button("Generate")

if submit:
    st.write(
        getLLMResponse(
            form_input, 
            age_option,
            tasktype_option,
            number_of_words
        )
    )
```

### example_projects/project-4/Project 4 - Final Code/.env.example

```
OPENAI_API_KEY=""
```

### example_projects/project-3/Let's build Similar Words Finder Application/requirements.txt

```
langchain
streamlit
openai
tiktoken
python-dotenv
faiss-cpu
```

### example_projects/project-3/Let's build Similar Words Finder Application/app.py

```
#Allows you to use Streamlit, a framework for building interactive web applications.
#It provides functions for creating UIs, displaying data, and handling user inputs.
import streamlit as st
import pprint as pp


#This module provides a way to interact with the operating system, such as accessing environment variables, working with files
#and directories, executing shell commands, etc
import os

#Helps us generate embeddings
#An embedding is a vector (list) of floating point numbers. The distance between two vectors measures their relatedness. 
#Small distances suggest high relatedness and large distances suggest low relatedness.
from langchain.embeddings import OpenAIEmbeddings


#FAISS is an open-source library developed by Facebook AI Research for efficient similarity search and clustering of large-scale datasets, particularly with high-dimensional vectors. 
#It provides optimized indexing structures and algorithms for tasks like nearest neighbor search and recommendation systems.
from langchain.vectorstores import FAISS


#load_dotenv() is a function that loads variables from a .env file into environment variables in a Python script. 
#It allows you to store sensitive information or configuration settings separate from your code
#and access them within your application.
from dotenv import load_dotenv
from pathlib import Path

load_dotenv(Path('../../../.env'))


#By using st.set_page_config(), you can customize the appearance of your Streamlit application's web page
st.set_page_config(page_title="Educate Kids", page_icon=":robot:")
st.header("Hey, Ask me something & I will give out similar things")

#Initialize the OpenAIEmbeddings object
embeddings = OpenAIEmbeddings()

#The below snippet helps us to import CSV file data for our tasks
from langchain.document_loaders.csv_loader import CSVLoader
loader = CSVLoader(file_path='myData.csv', csv_args={
    'delimiter': ',',
    'quotechar': '"',
    'fieldnames': ['Words']
})

#Assigning the data inside the csv to our variable here
data = loader.load()

#Display the data
print(data)

db = FAISS.from_documents(data, embeddings)

#Function to receive input from user and store it in a variable
def get_text():
    input_text = st.text_input("You: ", key= input)
    return input_text


user_input=get_text()
submit = st.button('Find similar Things')  

if submit:
    
    #If the button is clicked, the below snippet will fetch us the similar text
    docs = db.similarity_search(user_input)
    pp.pprint(docs)
    st.subheader("Top Matches:")
    st.text(f"Top result: {docs[0]}")
    st.text(f"Second most related in the documents: {docs[1].page_content}")


```

### example_projects/project-3/Let's build Similar Words Finder Application/myData.csv

```
﻿Words
Elephant
Lion
Tiger
Dog
Cricket
Footbal
Tennis
Basketball
Apple
Orange
Banana

```

### example_projects/project-3/Let's build Similar Words Finder Application/.env.example

```
OPENAI_API_KEY=""
```

### example_projects/project-3/word_embeddings.csv

```
,Words,embedding
0,Elephant,"[-0.01782482331077295, -0.008749894932295476, -0.0026506460679203104, -0.0008377731557254668, -0.008990419235435311, 0.009913513589292827, -0.01980102465190271, -7.988707634479182e-05, -0.006806196283858106, -0.013729403937789467, 0.0032308304713319492, 0.003828891611838113, 0.01411944370067883, -0.023324385643893622, 0.00014159261117400004, 0.008405359591101268, 0.03637772109395873, 1.185863511674714e-05, 0.025001556065524327, 0.000692727113080219, -0.01908595144283135, 0.0020330830324019377, -0.009646986759470046, -0.00514202572858499, 0.004895000793774418, 0.006120375917305059, 0.01895593880941662, -0.015068541512541878, -0.008762896195636949, -0.021491198199520063, 0.014808514383067245, -0.01153867988888023, -0.015094544039224824, -0.04464656555732936, -0.016992738731628335, -0.008392358327759796, -0.008548374419180058, 0.002081838002763108, 0.01726576526179926, -0.014080439910654411, 0.0038353922435088493, 0.015432578748748295, -0.010329556810187724, -0.006143128128152636, -0.03284135883862635, 0.023610415300051202, 0.004911252372951259, -0.018981941336099564, -0.026041662720777684, 0.009146435326855575, 0.016758714128836647, 0.000543618117433099, 0.005051016419533386, 0.006172381436332245, -0.010011023995676462, -0.0027351547453011785, -0.013059836081735849, -0.0020363333482373057, 0.014483480936885246, 0.003663124572911745, 0.012858314637297844, 0.000975912335428219, -0.0051875306159414394, -0.020308077647510504, -0.0168757254989099, -0.007625280065322543, -0.008320851379381695, -8.466099955586205e-05, 0.023584412773368254, 0.012676296019194636, 0.01080410478479666, 0.010960120876216922, -0.00448870898604692, 0.01573160873692476, 0.01092761771786324, -0.009068427746806738, -0.005239535669307331, -0.0072547421974453906, 0.0005123336528946946, -0.020464092807608178, 0.014951529211146035, -0.021556204516227428, -0.020256070731499435, 0.00012899756455237097, 0.0190599489161484, 0.0023126115912274867, -0.004348944939464792, 0.014015433593947047, 0.007183234783405996, -0.001995704167464556, -0.00649416410101758, 0.006581923094233816, -0.001037668569130862, 0.017525792391273897, 0.0096209842327871, -0.002983805070860082, 0.016212657343204432, 0.018097851703589057, 0.014080439910654411, -0.028264889928040604, -0.012611289702487271, -0.0011595561114491114, -0.013046833887071788, -0.006204884594685926, -0.002174472469732396, -0.008717391773941794, 0.005434556016413307, 0.01237726603101817, 0.018123854230272005, -0.014925526684463088, -0.0070142174286442595, 0.02318137174713742, 0.00967298928615299, -0.04251434719345675, 0.004703231228165104, -0.00308131524441307, 0.00774879253272783, 0.00033356535062685445, -0.00616263048882614, -0.010167040087096724, 0.01535457023737687, 0.01116164138933234, 0.024533508722586125, -0.038847972304709634, -0.005197281563447544, -0.0009677864876321367, 0.004007659914105953, -0.014106442437337356, -0.0034291006686119987, -0.0008873407632531409, 0.04893700481175752, 0.008268845394693214, 0.021933243015775317, 0.006497414416852948, -0.012227750571268644, 0.009705492444506672, -0.01635567310260581, 0.022154266355225532, 0.009230944469897737, -0.018097851703589057, 0.005489811385614566, 0.0217512253289947, -0.008262344763022478, -0.01479551311972577, -0.007222238573430414, 0.021842234172385008, 0.02004805051803587, 0.0176688062880301, 0.0011327408893920003, 0.013280858489863477, 0.015991635866399394, -0.014028434857288519, 0.03926401645692712, -0.0032795854416931194, 0.003893898161376124, -0.007859303736791643, -0.009861508535926936, 0.0190599489161484, 0.00448870898604692, -0.015380572764059816, 0.003004932356620623, 0.0016381675629288757, 0.02370142414344151, -0.003403098141929053, 0.024351491035805507, 0.028706936606941034, 0.010011023995676462, 0.016953733078958737, 0.00146915020816714, -0.016394676892630227, -0.022401290358713518, 0.01820186181032084, 0.0015089668099810478, 0.0238964430935636, -0.007319748514152754, 0.02266131748818815, 0.010056528417371617, -0.004865747485594809, -0.021686217149642157, -0.0075082677639267, -0.026002658930753268, 0.014327465776787573, 0.006760691396501656, 0.0031056926131783316, -0.02194624427911679, 0.004755236281530996, -0.010576581744998296, -0.0409541881418993, 0.018903933756050727, -0.006250389016381082, 0.02260931243482226, 0.01574461000026623, -0.0010466070540934482, -0.011044630019259085, -0.6806455955222351, -0.00774879253272783, 0.005694582214565352, -0.002770908452320876, 0.00014443665208186267, 0.023675421616758563, 0.014418474620177882, 0.0063901535286245035, -0.009185439116879994, -0.003490857135145289, -0.005333795294194303, 0.01644668194599612, 0.006598174673410657, 0.003011432988291359, -0.010817106048138132, -0.019645009491805036, 0.020815128780473122, -0.004995761050332126, 0.00042051176488424837, -0.013339364174900104, 0.0027140274595406377, 0.01658969584275232, -0.005109522570231308, 0.0068647019688947335, 0.02511856929824276, -0.0071702335200645225, 0.013976429803922628, 0.004722733123177314, -0.005889602561671327, 0.03424550273008613, -0.02649671066301959, 0.034609538103647364, -0.021413190619471226, 0.0006078121462199302, 0.058037937579563124, -0.014756509329701352, -0.019944040411304088, 0.03291936641867518, -0.0059058541408481685, 0.022297280251981733, 0.006061869766607136, -0.007930810685169744, 0.010076030312383827, -0.025183575614950122, 0.012572285912462853, -0.004491959301882288, 0.02285633830095542, -0.00897741797209384, 0.021257173596728376, -0.022102261301859643, -0.013716402674447995, 0.0068647019688947335, -0.015887625759667613, 0.009445466246354627, -0.012728302003883115, -0.007222238573430414, 0.020711118673741338, 0.0014000806474195949, -0.0004127922065675871, -0.018838927439343362, 0.014379470830153463, -0.0144574784102023, -0.0009637235346302646, -0.005785591523616956, 0.002008705430806029, 0.006120375917305059, -0.011317657480752603, 0.013053335450065113, 0.026067665247460632, -0.008925412918727949, 0.03323140046416089, 0.003906899657548244, 0.0059838621865583, -0.002918798521322071, 0.014626495764964036, 0.030553125314656066, 0.0168757254989099, -0.03955004425043952, -0.001620290709419027, 0.0013155720864540506, 0.0011782455439178024, -0.013573387846369205, 0.008268845394693214, -0.012188746781244226, 0.01716175515506748, -0.019658010755146508, -0.017902830890821786, -0.018643906626576095, 0.004859246853924073, 0.010609084903351978, 0.017902830890821786, 0.014665499554988455, 0.005359798286538543, 0.0008727142837863223, 0.0016787967437016254, -0.014535486921573726, -0.012227750571268644, 0.0096209842327871, 0.003893898161376124, -0.024767533325377816, 0.001844563666212669, -0.026327692376935264, 0.003055312484899477, -0.004608971603278132, -0.0009840381250166394, 0.007066222482010151, -0.007592776441307567, 0.014860519436433135, 0.043814480978184744, -0.022635314961505205, 0.012260253729622327, -0.0033283404120542895, -0.0067931945548553386, 0.006299144219572899, 0.015055539317877818, -0.025625620431205375, 0.014483480936885246, -0.002616517518818297, 0.0034746053231378008, -0.014496482200226719, 0.014210453475391727, 0.012825811478944162, 0.021218169806703956, 0.0008117705126271975, 0.009536475089744938, 0.01019304261377967, -0.03619570340717811, -0.021907240489092372, 0.0007752042848563198, 0.0011928719651769593, -0.016394676892630227, 0.0044107009403367885, 0.0026685228050148356, 0.014132444964020302, 0.02743280534889599, 0.010349058705199933, 0.02644470374700852, 0.010147538192084516, 0.010687093414723405, -0.011252651164045238, -0.010297052720511454, -0.0037963882206537834, -0.008379357064418324, -0.020776124990448702, 0.007261242829116127, -0.017304769051823682, -0.015198554145956607, -0.013066336713406587, -0.01691472928893432, -0.004374947466147738, -0.0073457510408357005, -0.025963655140728847, -0.013690400147765049, 0.020009046728011452, 0.0034323509844473668, -0.014509484394890781, -0.012585287175804325, 0.003380345698250828, 0.02540459895440034, -0.02701676305932368, 0.018604902836551675, 0.017564796181298317, -0.022830335774272476, -0.0014748383772943579, -0.0018591900874718262, -0.03798988519888208, -0.010602584271681242, 0.010973122139558394, -0.02526158319499896, -0.0331533891588217, 0.004934004583798836, -0.012078235111519118, 0.01374240520113094, 0.028732939133623982, 0.005587321326336906, -0.0045569660842509465, 0.01843588641311253, -0.03671575394083703, -0.01153867988888023, 0.007072723579342182, 0.03198327173279879, 0.01092761771786324, -0.0014390846702746604, -0.008925412918727949, 0.04321641913918664, 0.0033445919912311307, 0.028160879821308823, 0.03882196977802669, -0.028030867187894094, 0.01796783720752915, -0.0029269243109104914, 0.005714084575238855, -0.014639497028305509, -0.010433566916919506, 0.0032340807871673173, -0.016017638393082338, -0.0037183801749436523, 0.026964758005957788, 0.030657135421387847, 0.04339843682596726, 0.0015552840434656919, -0.0002709964797577075, 0.018695911679941984, 0.010381561863553615, 0.032295302052994135, -0.023441397013966876, -0.009198440380221466, -0.01707074631167717, 0.03687177282622506, 0.017928833417504734, 0.010687093414723405, -0.017421782284542116, -0.014678500818329927, 0.004527713241732632, 0.013586389109710677, 0.005109522570231308, 0.006520166627700526, 0.00040100975345671555, 0.009952518310639834, 0.002983805070860082, 0.0172007589450919, -0.021972246805799737, 0.005356547970703175, -0.0009295950437359131, 0.0037216307236096675, 0.02128317612341132, 0.017655805024688626, 0.0506271764967297, -0.012676296019194636, -0.028420906950783455, -0.0037346319869511406, 0.005434556016413307, 0.0019063200163306358, 0.00043270050747454096, -0.0022849836737962098, -0.01329385975320495, 0.015510586328797132, -0.033517428257673294, 0.02397445253625762, 0.007787796322752248, 0.02086713383383901, 0.040356126302901196, 0.030319100711864378, -0.0007739854164180568, -2.9430745141683356e-05, 0.0011766203860001181, 0.0002153345300387179, 0.00813233212960775, -0.0030000568828675704, 0.014353468303470517, 0.006029366608253455, 0.018799923649318945, -0.012364264767676698, 0.0024588765023109975, 0.0028830448143023733, -0.01019304261377967, 0.02080212751713165, 0.02019106441479207, -0.00143095888068624, 0.02578163745394823, 0.013859417502526785, 0.0006037492514257199, 0.00277253361023856, 0.006412905739472081, 0.019033946389465456, -0.023064358514418987, -0.002169596995979344, -0.013560386583027731, -0.00025311962624785875, 0.003290961547116908, -0.008359855169406114, 0.004478958038540815, -0.010836607943150342, 0.007755293164398566, 0.030059073582389743, 0.011792206386684127, 0.0029269243109104914, 0.03263333862516278, 0.013976429803922628, 0.0026798991432692714, -0.017655805024688626, -0.024325488509122563, 0.01253978275410917, 0.005278539924993044, -0.010375061231882879, -0.003656623941241009, -0.007547272019612412, -0.0031658236889632904, -0.021023150856581865, 0.028966961873770493, 0.01370340141110652, 0.039238013930244175, 0.014353468303470517, 0.004277437525425397, -0.004615472234948868, 0.0012741303267224588, 0.03546762893476528, -0.004459456143528605, 0.0032275801554965807, -0.005668579687882406, 0.012461774242737745, -0.008645883894241105, -0.008639383262570369, 0.013586389109710677, 0.04147424240084857, -0.015705606210241814, -0.016238659869887376, -0.03393346868460042, 0.014028434857288519, 0.0192419684655742, 0.004144173644852712, -0.031021172657594263, -0.0006163442834954335, -0.02771883500505357, -0.0033478423070664987, 0.01178570575501339, -0.00264252027833189, -0.0036241205500566797, 0.04209830676652962, 0.0010449818961757642, -0.02255730738145637, -0.026093667774143577, -0.016225658606545904, -0.0044854586702115515, 0.09017722447245959, 0.016797717918861064, 0.0004392011682491083, 0.012006728163141018, -0.017187757681750425, -0.0032974621787876445, -0.04129222471406795, -0.014327465776787573, 0.017109750101701588, -0.0037086292274375477, -0.008197338446315114, -0.004114920802334398, -0.0027887851894154007, -0.004859246853924073, 0.015302565184010979, -0.00026937129273619246, -0.012799808952261215, -0.017980838470870623, 0.023350388170576566, -0.03291936641867518, 0.03208728183953057, 0.002403620900279091, 0.0220372531225071, 0.010583082376669033, -0.0017340523457335321, -0.014015433593947047, 0.022427292885396462, 0.011467172940502129, 0.01868291041660051, -0.002982179912942398, -0.0032357059450850013, 0.014847518173091663, -0.0017584298309141172, 0.0028294143701881507, -0.016810719182202536, -0.007709788277042117, -0.0044822083543761835, 0.021361185566105334, 0.026990760532640733, -0.018565899046527258, 0.02504056171819392, 0.014106442437337356, 0.00015642224993244472, -0.0075797751779660945, 0.00663717892909637, -0.011077133177612766, -0.002845665949364992, 0.028862951767038708, -0.006182132383838349, 0.010921117086192504, 0.04225432192662729, -0.007462763342231544, -0.016043640919765286, 0.013469377739637422, 0.014613494501622562, 0.009829005377573254, 0.005714084575238855, -0.006689183982462261, -0.028264889928040604, -0.014249457265416146, -0.0024296234269620366, -0.00954947635308641, -0.008327352011052431, -0.01876091799664935, -0.0030146833041267275, -0.004069416380639243, -0.01512054656590777, -0.02051609786097407, -0.022206271408591424, 0.0008743394417040063, 0.000539961453910648, -0.02821288487467471, -0.02771883500505357, -0.014483480936885246, 0.013235354068168321, -0.008444363381125686, 0.017369777231176223, -0.0025758883380455474, 0.014574490711598144, 0.020542100387657015, 0.02654871571638548, -0.007878805631803853, -0.026249684796886427, -0.026808740983214938, -0.02829089431736873, 0.004374947466147738, 0.02617167721683759, 0.0023174870649805388, -0.013924423819234148, -0.005964359825884796, 0.019554000648414723, -0.00564257716119946, 0.027614824898321785, 0.009412963088000945, -0.008236342236339532, -0.015341568974035397, -0.0044822083543761835, 0.012585287175804325, -0.02364941909007562, 0.0011173017727586776, 0.02821288487467471, -0.022258276461957317, 0.008970917340423103, -0.003568864948024773, 0.012689298213858696, -0.004309940683779079, 0.008314350747710959, 0.006728188238147974, -0.009685990549494464, 0.0005115210739358526, 0.019332977308964508, -0.031593230107264246, 0.0005688081815725263, -0.013339364174900104, -0.000475767396019986, 0.014197452212050255, 0.003981657387423007, 0.01005002778570088, -0.0023532407720002362, -0.02559961790452243, -0.007956814143175278, -0.004901501425445154, 0.00910093090516042, 0.013228852505174997, -0.012351263504335226, 0.0006248764207709368, 0.013521382793003313, 0.0076512825920054895, 0.017694808814713043, 0.019944040411304088, 0.022544306118114896, 0.021335181176777213, -0.0021972246805799737, -0.008567876314192268, -0.035493631461448225, -0.0008186774919850167, -0.009250446364909947, 0.005398802076562962, 0.0018266868127028203, -0.01729176778848221, -0.017122751365043064, -0.00071547944034312, 0.002348365065416537, -0.013950426345917094, -0.01658969584275232, -0.027120773166055462, 0.00017633053628748313, 0.03824991046571153, -0.007735791269386357, 0.008333852642723167, -0.01954099938507325, 0.0067801932915138655, 0.015172551619273661, 0.013625393831057684, -0.02966903381950038, -0.05177129512136002, -0.029435011079353868, 0.011135638862649394, 0.01426245852875762, 0.007306747250811281, 0.018214863073662314, -0.004439954248516396, 0.023545408983343837, 0.021036152119923338, -0.0071702335200645225, 0.006497414416852948, -0.006923208119592655, 0.005571069747160065, -0.019436987415696293, 0.04576468165527674, 0.013118341766772477, 0.02972103887286627, 0.004930754267963468, 0.014704504276335462, -0.006767192028172392, 0.019449988679037765, 0.01033605744185846, -0.0267307334031661, -0.032815356311943406, -0.015315566447352451, -0.004251434998742452, 0.0062958939037375304, 0.008964416708752367, -0.012045731953165436, -0.007332749777494227, -0.002380868456600866, 0.03960204930380542, 0.0040011592824352165, 0.0013391369926757937, 0.003419349721105894, 0.007872305000133115, -0.028316896844051673, 0.003591617391702998, -0.0007500142207168926, -0.01365139635774063, -0.036663748887471134, -0.006962211909617074, 0.004173426953032321, 0.006721687606477238, -5.769340075407354e-05, 0.012637292229170217, 0.009256946996580683, -0.003011432988291359, 0.021023150856581865, -0.007820299946767225, 0.023259379327186257, 0.011129138230978658, -0.014145447158684364, 0.013456376476295948, -0.03174924526736192, -0.0239354487462332, -0.028732939133623982, -0.021348182440118685, -0.049743086864219195, -0.0031837006588884627, 0.007384755296521413, -0.02160820956959332, 0.02588564756068001, -0.004417201572007525, -0.012169244886232018, 0.0073392504091649635, -0.009985021468993516, 0.046440751074323675, 0.00899691986710605, 0.05028914364985141, 0.034869567095767176, -0.021166164753338067, -0.02782284511178535, 0.020503096597632595, 0.009653487391140782, -0.012812810215602688, 0.0077162893743741474, 0.01606964344644823, 0.011486674835514339, -0.016407678155971703, 0.016719710338812227, 0.002405246058196775, -0.0145484881849152, -0.021959245542458265, 0.011649191558605337, -0.0008702764887021342, 0.0074237590865458315, -0.02241429162205499, -0.004742235018189523, -0.006360900686106189, 0.010362059968541407, -0.0053500473390324385, 0.005158277773423125, -0.015055539317877818, -0.024000455062940563, -0.026223682270203483, 0.002128967815206594, -0.021244172333386904, -0.007144230527720282, -3.12082707090975e-05, -0.014678500818329927, -0.020828130043814595, -0.004144173644852712, -0.015861621370339488, -0.02086713383383901, -0.01322235187350426, 0.009737995602860355, 0.001877066940981675, -0.0038646453188578103, 0.01678471665551959, -0.010531077323303141, -0.0040824176439807165, -0.012461774242737745, -0.015705606210241814, 0.023389391960600983, -0.004491959301882288, -0.019358979835647456, 0.0022264777559289346, 0.004982759786990654, -0.0036046186550444705, -0.011740200401995648, -0.002483253871076259, -0.0032682093362693307, -0.025417600217741813, -0.013248355331509795, 0.01483451690975019, 0.013456376476295948, -0.02821288487467471, -0.006773692659843129, -0.018448887676454, -0.0021582206577249077, -0.029174983949879236, 0.005090020675219099, -0.014054437383971465, -0.03497357720249896, -0.010407564390236561, 0.011389164429130703, -0.012968826307022951, 0.02420847527640413, 0.025092566771559813, 0.0002559636817076368, -0.012656794124182425, 0.030969167604228375, -0.027900852691834187, 0.011727199138654174, -0.0064551603109931615, 0.0008507745354822632, -0.012968826307022951, -0.003360843803238619, 0.0016820470595369935, -0.03169724021399603, -0.00793731131684048, -0.016342671839264338, -0.019137956496197237, -0.017707811940699696, 0.01300783009704737, 0.017083747575018644, -0.013040333255401052, 0.01170119661197123, 0.020139059361426178, 0.012598288439145799, 0.006364151001941557, -0.01431446358212351, -0.007163732888393786, 0.02080212751713165, 0.0028879202880554254, -0.02388344183022213, 0.002967553491683241, -0.020646112357033976, -0.017330771578506626, -0.004020661177447426, 0.0070922254743543914, 0.011272153059057448, -0.024130467696355292, -0.018279869390369678, -0.018942937546075147, 0.03414149262335434, -0.01223425120293938, -0.02137418682944681, -0.020126058098084706, -0.01748678860124948, -0.012032730689823964, 0.009367457734983202, -0.01657669457941085, -0.011876714598403702, 0.0029691786496009254, 0.029278994056611017, -0.0013903296999134903, -0.008418360854442742, 0.005174529352599966, -0.029148981423196288, -0.002029832483735922, -0.026067665247460632, -0.05067918155009559, -0.006825698178870315, -0.021452194409495647, 0.034869567095767176, 0.0071702335200645225, 0.003832141927673481, -0.018747916733307876, 0.015315566447352451, -0.04129222471406795, 0.014080439910654411, 0.005171279036764598, -0.0025921401500530357, 0.006292643587902162, 0.004348944939464792, -0.00036830330484416846, 0.01597863460305792, -0.0045569660842509465, 0.004056414651636476, -0.017369777231176223, 0.009068427746806738, -0.007956814143175278, -0.006416156055307449, -0.016004637129740866, -0.00931545268161731, -0.020685116147058393, -0.005636076529528724, 0.025157573088267177, 0.006741189501489447, -0.005051016419533386, 0.0013001329698207281, -0.03531161004937725, -0.016173653553180012, -0.013215851241833524, 0.011519177993868021, -0.004722733123177314, 0.0095299744580742, -0.007176734151735259, -0.018422883287125876, -0.01284531337395637, 0.009198440380221466, -0.0027205283240420213, -0.0036956279640960746, -0.011642690926934601, -0.01341737268627153, -0.003760634513634086, 0.025677625484571268, -0.018526895256502838, 0.026808740983214938, -0.004267686577919293, -0.029044971316464507, 0.005473559806437725, -0.02517057435160865, -0.02090613762386343, 0.01755179491795684, -0.026964758005957788, -0.012708800108870906, -0.013495380266320366, 0.005083520043548362, 0.004144173644852712, 0.0056003225896783795, 0.016498686999362012, -0.03458353557696442, 0.015471582538772713, -0.023753429196807403, 0.0067801932915138655, -0.02688675042590895, -0.0011384289421038946, -0.00190794517424832, -0.008138832761278487, -0.030085076109072687, 0.021868236699067952, -0.006747690133160183, -0.023597414036709726, -0.016303668049239918, -0.012097737006531328, 0.003611119286715207, -0.007800797586093721, -0.012104237638202064, -0.004257935630413188, -0.02076312372710723, -0.0262626860602279, -0.0007362003202089159, -0.015146549092590715, -0.03845793440446545, -0.009848507272585462, 0.018838927439343362, -0.01606964344644823, -0.0052005318792829125, 0.21290977626474275, -0.02449450493256171, 0.016849722972226956, 0.0162646642592155, -0.016563693316069376, 0.024715528272011924, 0.020412087754242286, -0.008086826776590006, -0.005632826213693356, 0.008392358327759796, -0.003975156755752271, 0.01483451690975019, -0.015302565184010979, 0.008034821723224115, -0.011707697243641966, -0.0315672275805813, -0.03986207829592523, 0.003026059409550516, -0.0159396308130335, -0.025521610324473594, 0.010141037560413778, -0.0190599489161484, -0.011389164429130703, 0.011031627824595023, 0.02907097384314745, -0.013599391304374738, -0.013937425082575622, 0.007300246619140545, -0.006133377180646531, 0.010518076059961669, -0.012617790334158007, -0.017759816994065585, -0.007072723579342182, 0.00774879253272783, -0.029825050842243232, -0.0005586508863793388, -0.03250332599174806, 0.013326362911558632, 0.022544306118114896, 0.02769283247837062, -0.0009149685642690943, -0.005129024465243518, -0.001945323922770378, 0.007781295691081512, 0.00713122926437881, 0.015575592645504496, 0.003939402815901927, -0.013781409922477946, 0.0021647212893956443, 0.03622170593386106, -0.015146549092590715, 0.018656907889917567, 0.007209237310088941, 0.02829089431736873, 0.004170176637196952, 0.0015796615286462771, -0.0013147595074952086, 0.012448772979396271, -0.013469377739637422, -0.00021431879178824992, 0.00015235932603440355, 0.024533508722586125, 0.002026582167900554, 0.020815128780473122, -0.011109636335966448, -0.0021062153715283695, -0.02246629853806606, 0.02008705430806029, 0.0022979849371376824, -0.009711993076177408, 0.0006183757308925386, -0.012312258782988217, -0.0054313057005779385, -0.002980554755024714, -0.029461013606036816, -0.02977304578887734, 0.031073177710960156, 0.007553772651283148, 0.0061528790756587405, 0.0220372531225071, -0.006487663469346844, -0.013664397621082102, -0.02575563492726528, -0.004696730130833074, 0.004595969874275365, -0.01275430453056606, 0.011389164429130703, 0.002496255367248379, 0.011486674835514339, 0.0064649112584992665, -0.019371981098988928, -0.02198524806914121, 0.010466070075273188, -0.015094544039224824, 0.013144344293455424, 0.03960204930380542, -0.013079337976748059, 0.02076312372710723, -0.01483451690975019, -0.026067665247460632, -0.011694695980300492, 0.00024824415249480645, 0.0168757254989099, -0.013924423819234148, -0.01920296467554978, -0.004690229499162337, -0.010095532207396035, -0.0034128490894351575, -0.005805093884290459, -0.032347307106360024, -0.02630168985025232, -0.01341737268627153, 0.015848620106998015, 0.002218351966340514, 0.017369777231176223, -0.014392472093494936, 0.012247252466280854, -0.013638395094399156, -0.0010709845392740335, -0.001667420521862513, 0.0008060824599153032, -0.028056869714577038, -0.0033478423070664987, 0.018838927439343362, -0.020945141413887848, -0.018604902836551675, -0.002098089581939949, 0.046440751074323675, 0.025716629274595688, -0.026327692376935264, 0.0028732938667962687, -0.01981402591524418, -0.008151834024619959, 0.002094839266104581, -0.008639383262570369, 0.00902942302545973, -0.010388062495224351, -0.00852887252416785, 0.0015016535993514692, -0.010063029049042353, 0.011220147074368967, 0.005548317536312488, 0.01866990915325904, 0.0024149970057028795, 0.009094430273489683, -0.019436987415696293, 0.012143242359549071, 0.0053402963915263335, -0.010739098468089295, -0.021881237962409428, -0.04025211619616941, 0.0018348126022912409, 0.01899494259944104, -0.007521269027268172, 0.04334643177260137, -0.007287245355799072, -0.016472684472679064, -0.03679376152088586, -0.013072837345077323, -0.004508210881059129, -0.025365593301730743, 0.00643240763448429, 0.024845540905426653, -0.017759816994065585, -0.009633985496128572, 0.017473787337908005, -0.16756113131110278, 0.0073392504091649635, 0.019788023388561234, -0.004751985965695628, -0.005668579687882406, 0.008476866539479369, 0.014717505539676934, -0.021413190619471226, -0.011298155585740393, 0.030215090605132593, 0.024845540905426653, 0.006094373390622113, -0.06297844000106492, -0.016758714128836647, 0.015523587592138606, -0.010914616454521768, 0.015328567710693923, -0.012422770452713327, 0.024546509985927598, 0.011941720915111064, 0.009373958366653938, -0.02388344183022213, -0.003380345698250828, 0.008541873787509322, 0.0032942118629522765, 0.014197452212050255, -0.0064584106268285296, 0.009588481074433417, 0.00040385380891649365, -0.02667872834980021, -0.010414065021907297, 0.007833301210108697, 0.011005625297912077, 0.004261185946248557, -0.007683785750359171, 0.018942937546075147, -0.010849609206491815, -0.022362286568689098, 0.006006614397405877, 0.007293745987469809, -0.01426245852875762, 0.029461013606036816, 0.0016584821533152504, 0.021491198199520063, 0.015471582538772713, 0.01726576526179926, 0.005866849885162455, -0.007235239836771886, 0.023740427933465928, -0.029018968789781562, 0.002662022173344099, -0.027666829951687677, 0.020269073857486084, 0.001188809070382749, 0.03676775899420292, 0.0028797944984670053, 0.023857439303539184, -0.0036338717303934314, 0.01094711961287545, -0.012526781490767698, -0.02056810291433996, -0.009653487391140782, 0.01223425120293938, -0.02427348345575667, -0.02535259203838927, -0.02019106441479207, -0.01300783009704737, 0.006136627496481899, -0.02748481040226188, -0.0014423349861100287, -0.015757611263607706, -0.01379441118581942, 0.011343660007435549, -0.02445550114253729, 0.011246150532374502, 0.01273480263555385, -0.016693707812129283, 0.01980102465190271, -0.022817334510931004, 0.0011806832807943284, -0.0267307334031661, 0.04303440145240602, -0.005853848621820983, -0.0239354487462332, 0.013306861016546422, 0.013001329465376634, -0.01783782457411442, -0.0094584675096961, -0.000990538756687376, -0.015562591382163024, 0.031645235160630135, -0.044256527657085175, -0.015601595172187442, -0.008944914813740157, 0.017382778494517696, 0.011610187768580919, -0.00722873920510115, 0.0061593797073294775, -0.006981714270290578, 0.007664283855346962, -0.0030861907181661224, -0.008951415445410893, -0.005398802076562962, 0.018747916733307876, 0.024832539642085177, 0.011103135704295712, 0.01977502212521976, -0.011668693453617547, 0.047506858393614806, 0.023844438040197712, -0.013163846188467632, 0.00874339430062474, 0.002029832483735922, 0.03793788014551618, -0.010128035365749717, -0.013235354068168321, -0.0031121932448490677, -0.0018348126022912409, 0.034791559515718336, 0.00015835213951161003, 0.03676775899420292, -0.00760577770464904, -0.0030650634324055816, 0.008860406602020584, -0.0008113642231477765, 0.003100817139425279, -0.0693230863140265, -0.023870440566880657, -0.005470309490602357, 0.01753879365461537, 0.0017405529774042684, 0.011642690926934601, -0.004296939420437606, 0.030683137948070795, -0.0022817333579608413, 0.022011250595824153, -0.005993613134064405, -0.032035276786164676, 0.0035331112410050755, -0.007053221218668678, 0.044906594549449175, 0.008951415445410893, -0.026509711926361063, -0.016394676892630227, -0.007833301210108697, 0.008593878840875212, -0.0023987454265260383, -0.002863542919290164, 0.008054323618236324, -0.010648088693376396, -0.0005395551644312269, 0.0005484935911861513, -0.016342671839264338, 0.021010149593240393, 0.016095645973131175, -0.007313247882482018, 0.0033738450665800916, -0.012156243622890544, 0.005421554287410539, -0.013469377739637422, -0.00983550600924399, 0.004261185946248557, -0.036559738780739356, -0.00039329022424388515, 0.03744382841324986, -0.023727426670124455, 0.0193849823623304, 0.0005123336528946946, 0.004300189736272975, -0.03086515749749659, -0.0026912752486930604, -0.018240865600345258, -0.0010490447909699745, 0.026132673426813174, 0.01786382710079737, -0.014808514383067245, -0.035493631461448225, 0.0009669739086732946, -0.03746983093993281, 0.02667872834980021, 0.011207145811027495, -0.010076030312383827, 0.020919138887204904, 0.02531358824836485, 0.011486674835514339, 0.00786580436846238, 0.012357764136005962, -0.01512054656590777, 0.0254696052711077, 0.039368026563658905, -0.0011327408893920003, 0.015718607473583286, -0.003539612105506459, 0.0016966734807961506, 0.013898421292551203, -0.016602697106093793, -0.009451966878025363, 0.00902942302545973, -0.00284891626520036, 0.018851928702684838, -0.027380800295530097, 0.027848847638468295, -0.02350640333067424, 0.017408781021200644, 0.02688675042590895, -0.009445466246354627, 0.002449125554804893, -0.033517428257673294, 0.01080410478479666, -0.010700094678064877, 0.009998022732334988, 0.013781409922477946, -0.000584653529477608, 0.0009620983767125805, 0.0016820470595369935, -0.0017421781353219527, -0.001966451092115595, 0.03180125404601817, 0.007176734151735259, -0.05265538475387053, -0.00760577770464904, 0.020425089017583758, -0.008093327408260742, -0.006409655423636713, 0.0006630678064594986, 0.010212544508791879, -0.007618778967990513, -0.012416269821042589, -0.07946412387444028, 0.014769510593042826, 0.014093441173995884, -0.001057983159517237, 0.010466070075273188, -0.0023581162457532888, 0.015575592645504496, -0.0024637519760640496, 0.01379441118581942, 0.0019339478173465892, -0.032607336098479836, 0.01768180755137157, -0.002213476492587462, 0.0024897547355776425, -0.02758882237163884, -0.013690400147765049, 0.029018968789781562, -0.003776886325641574, -0.007534270756270939, 0.004443204564351765, 4.286375835764998e-05, 0.008730393037283266, 0.012572285912462853, 0.017330771578506626, -0.01664170275876339, -0.018071849176906112, -0.00391340028921898, 0.021959245542458265, -0.027094770639372517, 0.009445466246354627, -0.0038548941385210585, -0.03632571604059284, -0.008554875050850794, 0.03902998999149026, -0.001469962787125982, -0.0010181666741186529, 0.015133547829249243, 0.007332749777494227, -0.006435658415980952, 0.020841131307156067, -0.0026652724891794675, -0.009087929641818947, 0.006113875285634322, -0.018877931229367782, -0.0145484881849152, 0.012507279595755488, 0.005480060438108461, 0.01909895270617282, 0.012351263504335226, -0.0015528463065891658, 0.012832312110614898, 0.015484583802114187, -0.0010514825278465005, -0.010375061231882879, -0.0002746530850724967, -0.01839688076044293, 0.022505302328090476, 0.00675419076483092, 0.015991635866399394, 0.002564512232621759, 0.010895114559509558, 0.016667705285446335, 0.011694695980300492, 0.00024580638651444935, -0.011954723109775127, -0.018123854230272005, -0.01019304261377967, -0.003123569350272857, 0.005756338681098642, -0.0341154900966714, -0.020542100387657015, -0.013872418765868257, 0.028134877294625875, 0.007118228001037337, -0.0019144458059190564, 0.00494375553130494, 0.0014049562375879707, 0.006676182719120788, -0.034479525470232635, 0.03213928689289646, 0.002148469710218803, -0.0012586912100891361, -0.0289149568204046, -0.00858087757753374, 0.03624770846054401, 0.0032779602837754353, -0.004043413388295003, 0.003422600036941262, -0.0004396074577285293, 0.0070987261060251276, -0.018799923649318945, 0.0047097318598358405, -0.0239354487462332, 0.009926514852634299, 0.00125625347321261, 0.019879032231951546, -0.01487352069977461, -0.00138626680511928, 0.013215851241833524, 0.03960204930380542, -0.0004599220481149042, 0.010089031575725299, 0.0056003225896783795, 0.0063056448512436355, -0.011109636335966448, -0.015796615053632123, -0.023805434250173292, -0.03419349767672023, -0.010973122139558394, 0.006425907002813553, 0.017421782284542116, -0.006351149738600085, -0.01839688076044293, 0.013976429803922628, -0.01748678860124948, 0.01981402591524418, -0.005714084575238855, -0.017408781021200644, -0.013456376476295948, 0.021582207042910372, 0.014704504276335462, -0.0035071087143221298, 0.01686272423556843, -0.03052712278797312, 0.0025742631801278634, 0.02507956550821834, 0.008041322354894851, -0.0075082677639267, -0.008678387983917376, 0.002148469710218803, -0.004140923329017344, -0.00027201220345626006, -0.0075732745462953575, -0.005311043083346726, -0.022505302328090476, -0.013306861016546422, -0.011064131914271294, 0.028134877294625875, -0.013534384056344785, 0.03481756204240129, -0.017811822047431477, -0.009321953313288047, 0.01293632314866927, -0.010121534734078981, 0.0239354487462332, 0.012045731953165436, 0.028550919584198184, -0.006981714270290578, 0.006006614397405877, 0.001534969453079317, -0.01791583215416326, -0.011577683678904648, 0.008197338446315114, -0.02228427898864026, 0.011766202928678592, -0.024858542168768125, -0.0007967377436809578, -0.0015951006452795996, -0.00108398591903083, 0.045374640029742196, 0.013059836081735849, 0.03104717518427721, -0.010141037560413778, -0.009913513589292827, -0.0021062153715283695, 0.017213760208433373, 0.010102032839066771, -0.01479551311972577, -0.002098089581939949, 0.011922219020098856, 0.02132217991343574, -0.038925979884758474, -0.0019729517237863313, 0.008931913550398685, -0.015445580012089769, -0.001169307058955216, -0.016940731815617265, -0.0022411041771880917, -0.005070518780206889, -0.02285633830095542, 0.016810719182202536, -0.008717391773941794, -0.02506656424487687, -0.001035230832254336, -0.001886818004903103, -0.01605664218310676, 0.0020932141081868964, -0.025105568034901285]"
1,Lion,"[-0.001506082151574034, -0.01005350346088858, -0.015507788603787813, -0.023190426017565564, -0.010247836957184816, 0.024991248135618194, -0.012800079009438785, -0.005366834883301409, -0.0021700538052380463, -0.017101319734391114, 0.0027417173042750577, 0.027336201063068007, 0.016673786787597466, -0.015041388771470399, -0.005872101135481293, 0.007533650014243122, 0.03371033117341673, -0.005120679338634781, 0.03648281518501502, 0.01016362583754462, -0.024149136939216234, -0.015274588221967813, 0.01195796874435941, -0.005441329048730017, 0.021039806586411986, -0.005295579392169134, 0.03153379675995696, -0.011569302683089526, 0.018435741088803744, -0.006422711621777609, 0.02465440365705741, -0.023579093010158033, 0.00013785509692526148, -0.02018474069282469, -0.016285121657650167, -0.006749839146126806, 0.0031012336670634116, -0.020767739319068224, 0.023073826292316857, -0.009587103628571167, 0.012281857594412273, 0.021104583797629008, -0.010532858921713914, 0.003132003168354402, -0.024045493773798034, 0.020702962107851202, -0.009613014885587011, -0.019498097038517785, -0.03238886265354426, 0.01746407546996774, -0.002089081825555477, 0.002071267952772408, -0.012482668439301176, -0.005817039947153273, -0.029538644870898443, -0.010202492723068383, -0.003162772669645392, -0.006736883983280178, 0.004456707801386092, -0.0021668151309417127, -0.0039546802235025415, 0.0074170498233331215, -0.017204964762454485, 0.00987860387301552, -0.016738565861459657, -0.009671314748211363, 0.000348382721402767, 0.015028433142962478, 0.009833259638899089, 0.0069376948281690805, 0.047054540992252696, 0.017049499083004602, 0.010448647802073718, 0.009153093333184852, -0.010131237231936109, -0.013234090236147689, -0.02274993837358658, 0.0022850344261692327, 0.011556347054581605, -0.004411363101608367, 0.005622706916518332, -0.01834505262057088, -0.01707540847737527, 0.020379074189120924, 0.02881313339974519, -0.009975770621163638, 0.0032567002778358827, 0.015455966089756126, -0.01645354389693056, 0.0076696831822537104, 0.0004971690425700947, 0.014924789046221694, 0.007002472505047395, 0.02697344532749138, -0.003378158480190383, -0.006124734028740588, 0.015300499478983655, 0.011770113527978429, -0.003944963734952248, -0.0355241079886547, -0.0008688313070846252, -0.011776590876571095, -0.02317747132038023, -0.006332023153544745, -0.008207338040042105, -0.011122335827872702, -0.0030931365156612843, 0.015002521885946635, 0.03671601836080278, -0.005612990427968037, -0.016298076354835503, 0.029460911099850915, 0.024123225682200388, -0.0644667976734791, 0.01943331796465559, -0.01438065544285675, -0.0002279366338697017, -0.019614696763766492, 0.005755501410232586, -0.0171531422484228, 0.03280344276579775, 0.009800870101967991, 0.03586095246721548, -0.022128071930496696, 0.008395193256423086, 0.0014218711483491612, -0.008498838284486457, -0.022166937884697875, -0.006834050265767002, -0.010306136819809169, 0.0464844970631945, 0.01019601444315313, 0.028191266956655303, 0.0093474258981585, -0.0212730060369094, 0.02201147220524799, -0.018021164701840606, -0.0009182242915251059, -0.0030413144672908916, -0.01809889661024296, 0.007559560805597671, 0.017269741973671506, -0.005234040389587154, 0.00214414278105285, -0.01746407546996774, 0.02800989002018958, 0.022853583401649953, -0.0010526380641798661, -0.0017522375798253388, -0.0016583098552195247, 0.027698956798644637, -0.01620738788660264, 0.033373486694855944, -0.024602581143025725, 0.00042065038556413857, 0.009094793470560499, 0.008265637902666458, 0.014056767524126474, -0.0037085249116665608, -0.015274588221967813, 0.008848637460232577, -0.005998417814941587, 0.004741729765915192, -0.00497169054211627, 0.011893190601819802, 0.037441526106665686, 0.01636285356605252, 0.009334470269650579, -0.006001656489237921, -0.0034461750641956775, -0.002071267952772408, -0.0006348217223518353, 0.0002467626505780363, 0.04062859023051746, 0.012696434912698, 0.02059931707978783, 0.002213778935036958, -0.0015579044327750735, 0.0015271349314840833, 0.0007591139975462745, -0.029020421593226757, 0.006762794774634727, 0.02324224853159725, 0.030186420708359, -0.023047915035301014, -0.002647789696084567, 0.0039546802235025415, -0.016738565861459657, 0.009334470269650579, -0.006866439337036806, -0.0010639742391242975, 0.026429312655449025, 0.007216238978444219, -0.00754660517708975, -0.6869548650625803, -0.00027571019385052296, -0.0085765711242114, -0.0009813825730475914, 0.006312589710782863, 0.010345003705332933, 0.02193373843420046, -0.01310453488239106, -0.008777381969100303, 0.0015319932921745538, -0.012191168194856822, 0.010694802881079053, 0.008233249297057947, 0.009140137704676931, -0.002315803694629576, -0.024537803931808704, -0.00015597262452744228, -0.005842951204169116, -0.024563715188824546, 0.008051871429269634, -0.013026801111343531, 0.007293972283830454, -0.006102061911682373, -0.005295579392169134, 0.0069182613854071985, -0.009638926142602854, 0.022348316683808777, -0.009885081221608189, 0.024188004756062583, 0.017658408966263976, -0.031145131630009665, 0.0018170152567036529, 0.009923948107131953, -0.014536122053629223, 0.045992188767829005, -0.013370122938496983, -0.019977450636697945, 0.03723423977582929, 0.009774958844952148, 0.03280344276579775, -0.0033716806659364225, -0.010908569354475877, 0.008019482823661123, -0.031792909330115394, -0.0098656482445076, -0.006400039504719393, 0.01125189118162933, 0.011141769736295878, 0.011912624510242978, -0.022633338648337876, -0.010519903293205993, -0.0061830343570262345, 0.00827859353117438, -0.014354745117163495, -0.0050915294073226045, 0.0008340132300925713, 0.04088770280067589, -0.010701281160994308, 0.00919195928738603, 0.0022056815508041836, -0.0020016317987883005, 0.0006400849173293476, -0.009062403933629401, 0.026921624676104868, 0.00932799292105791, 0.007209761164190258, -0.0038769471509469532, 0.01804707595885645, 0.027983978763173736, -0.014251100089100124, 0.029849578092443388, 0.0028486005409734698, 0.015792809636994323, -0.007514216571481239, 0.002877750705116293, 0.011698858036846154, 0.029072244107258446, -0.010098847695005013, -0.0028453616338464894, 0.0019109429813094667, 0.010280225562793326, -0.010746625395110738, -0.0006886682331957448, -0.007948227332528849, 0.02863175646327946, -0.02570380304694094, -0.011750679619555253, -0.016440587337100052, 0.01280655728935404, 0.018578252071068294, 0.005648618173534174, 0.025483558293628864, -0.0014032476069920092, -0.005324729323481311, 0.008110171291893986, 0.0035919249535872073, -0.0005959551278663793, 0.0028437422966983224, 0.010895613725967956, -0.02641635795826369, 0.007255105398306689, -0.010720714138094896, 0.006775750403142648, -0.008945804208380695, 0.02743984609113138, 0.009230826172909793, -0.02881313339974519, 0.01754180924101527, 0.03897028095737455, -0.023967760002750506, 0.007008950319301355, 0.004055085645946993, -0.014121544735343496, -0.008149038177417751, 0.02436938169252831, -0.025522424247830043, 0.006989516876539473, 0.002897183915047529, 0.0003902858058716826, -0.020871384347131594, 0.021156406311660693, -0.007274538841068572, 0.025522424247830043, -0.001206485221388847, 0.0022656009834073503, 0.0215580280014385, -0.02176531619492007, -0.04236463513735307, -0.012048657212592273, 0.025159670374898586, -0.0008097216012632035, -0.009166048961692774, 0.008958759836888616, 0.0004404885461977391, 0.00794174998393618, 0.023682738038221407, 0.026364535444232003, 0.002314184357481409, 0.021260051339724067, 0.00799357156664528, -0.012456757182285333, 0.002071267952772408, -0.0082915491596823, -0.0062380950796929605, -0.012145823960740392, -0.025172625072083923, -0.007209761164190258, -0.013668100531534003, -0.01378470025678271, 0.013512633920761533, -0.01736043044190437, -0.018111853170073466, -0.011575780031682192, 0.0017392820677327406, 0.018733719613163353, -0.01460090019616883, -0.014924789046221694, 0.0010655936926877877, 0.011005736102623995, -0.013201700699216591, 0.019614696763766492, 0.029020421593226757, -0.019498097038517785, -0.0006344168880647936, 0.002281795519042252, -0.020871384347131594, 0.008777381969100303, 0.013991989381586868, -0.03415081695475054, -0.033788063081819086, 0.006322306199333157, 0.008757948991999713, 0.011180635690497055, 0.0036664193518464627, 0.03272570713210504, -0.00034878758479363955, 0.014743411178433379, -0.02723255789764981, -0.007281016655322533, 0.0023174232646083898, 0.029460911099850915, 0.010552291898814504, -0.003062367014370294, -0.014406566699872595, 0.022620382088507366, -0.00036093339920832343, 0.014108589106835573, 0.029279534163385187, -0.03109330911597798, 0.017684320223279818, -0.013383078567004904, 0.01612965411555511, 0.012877812780486315, -0.005347401440539527, -0.002874511797989313, 0.0006307731466507716, 0.00409071339151313, 0.016764477118475504, 0.02088433904431693, 0.0251078478608669, 0.005587079170952194, -0.006416233807523648, 0.012094002378031292, 0.0003506094555006506, 0.03124877665807304, -0.03713059474776592, -0.002540906459386155, -0.009464026554729794, 0.022166937884697875, 0.01975720774603104, 0.010377392310941444, -0.03521317290446458, -0.02158393925845434, 0.005936878812359607, 0.008589526752719321, 0.025211492888930275, 0.01901874157769245, 0.004366018867491935, 0.006335261827841079, 0.0025927285077565476, 0.010707758509586975, -0.020560451125586653, -0.00866726052376685, 0.001093124170436474, 0.0009060785062142527, 0.017049499083004602, 0.009528803765946814, 0.016842209026877858, -0.002045356695756565, -0.031222865401057197, -0.0006809758578729973, -0.008583049404126655, -0.005383029186105664, 0.004819463071301427, -0.003883424732370267, 0.0010915047168729838, 0.005143351455692996, -0.022736983676401246, 0.019666519277798177, -0.01364218927451816, -0.01165999115132239, 0.020003361893713788, 0.018461652345819587, -0.012268901965904352, 0.0024097315356507135, 0.0027190451872168417, -0.002229973237841213, 0.0005145780810661217, -0.018008208142010096, 0.006059956351862274, -0.0008753090631309243, 0.012696434912698, -0.023332936999830113, 0.005606512613714076, -0.0036923306088623054, -0.02113049505464485, 0.02325520509142776, 0.0173345210475337, 0.01524867696495197, 0.032492507681607635, 0.011634079894306546, -0.017865697159745546, 0.007047816739163826, -0.004323913307671837, 0.0003421073824999888, -0.0008372521372195516, -0.01299441250573502, -0.0003060747735429789, 0.0036988084231162665, -0.004903674190941623, 0.015948277179089382, -0.0014113447583941367, 0.015300499478983655, -0.023216337274581406, 0.019264895725375198, 0.013318301355787885, -0.01430292260313181, 0.025962913754454198, 0.01627216509781966, 0.025418781082411843, -0.010034070483787991, -0.0346690420950674, 0.020404985446136767, 0.012605746444465138, -0.0027692478984390674, -0.01588349996787236, -0.03339939608922662, -0.002378962034359723, -0.005117440664338447, 0.024602581143025725, 0.010694802881079053, 0.029046332850242603, 0.00890693732285693, -0.0056972010819469395, 0.00708020581043363, -0.005094768547280231, 0.025949959057268865, -0.017243830716655664, 0.0020874622555766636, 0.008868071368655753, -0.011744202270962586, 0.0026413118818306063, -0.007740938673385985, 0.000796361196675902, 0.04617356570429473, -0.01574098898560781, -0.019524008295533628, -0.033969440018284815, 0.018915096549629078, 0.004842135188359643, 0.0017295653463517996, -0.009276170407026225, -0.020482717354539125, -0.017554763938200605, -0.01576689837997848, -0.00040141947636110055, -0.00722919460695214, -0.0012842185267750823, 0.0299013987438299, -0.00696360561952363, -0.02483578059352314, -0.012774167752422943, -0.005927162323809312, 0.00567129029059239, 0.0789251859560608, 0.012813034637946707, 0.006264006336708804, 0.0018834125035607804, -0.005211368272528938, 0.0036728971661004234, -0.01701063126615825, -0.0296163767793008, 0.0014834100345158183, 0.01650536454831707, -0.02282767214463411, 0.0006886682331957448, -0.007786282907502416, -0.0034396974827723636, 0.011064035965248348, 0.0050494238475025065, -0.011277802438645172, -0.016544232365163423, 0.000887454906649439, -0.010999258754031328, 0.022387182638009952, 0.001959526238968202, 0.044074766924527664, 0.010079414717904423, -0.007967660309629436, -0.019977450636697945, 0.026118379433904083, 0.01923898633100453, 0.0024939426552909095, -0.02663660271157577, -0.021817138708951755, 0.006306111896528902, -0.0015587141013491568, 0.005072095964560722, 0.009625970514094933, -0.005438090374433683, 0.006247812033904549, 0.016466498594115895, 0.012689956632782747, -0.012158779589248313, 0.032984819702263475, 0.023047915035301014, -0.0029198560321057445, -0.0005295579392169134, 0.015287543850475734, -0.001774909813298878, 3.355283887780985e-05, 0.02863175646327946, -0.007676160996507671, -0.010137714580528777, 0.02325520509142776, -0.0015190377800819556, -0.014587944567660908, 0.018280275409353862, -0.001480171127388838, 0.01571507772859197, -0.0002069850916352439, -0.007196805535682337, 0.0038348415911268552, -0.009036493607936145, -0.026053602222687062, -0.010189537094560462, -0.011193591319004976, -0.014885922160697928, 0.0004064802541950919, -0.023397716073692308, 0.009658359119703442, -0.017943430930793074, -0.025651980532909256, -0.00931503729254999, 0.0071061170674494726, -0.02561311457870808, 1.2215409859684588e-05, -0.015209811010750793, 0.017282698533502013, -0.002063170568539634, 0.02022360664702587, -0.009574148000063246, 0.016997676568972914, 0.010889136377375288, 0.009606537536994343, -0.007047816739163826, -0.00827859353117438, -0.03440992952490897, -0.021661673029501873, 0.0052372795295447805, 0.013182267722116002, 0.008991148442497127, -0.010247836957184816, 0.004100430345724718, 0.025639025835723923, -0.005736067967470704, 0.015002521885946635, -0.0022380706220739874, -0.0035692528365289917, -0.010345003705332933, -0.0015263252629099998, 0.010681847252571132, 0.0020210652415501825, -0.011562824403174271, 0.02008109566476132, -0.020975029375194968, -0.01885031933841206, 0.004936062796550133, 0.01848756360283543, -0.00361459730347607, 0.0232811163484436, 0.000578950923657394, -0.020962072815364458, -0.008757948991999713, 0.01680334307267668, -0.03479859651750144, 0.007967660309629436, 0.00722919460695214, 0.0184098298317879, 0.013914256541861925, -0.013616278948824905, 0.02002927315072963, 0.02303496033811568, -0.025859268726390827, -0.01017658146605254, -0.008997626722412382, 0.019044652834708294, 0.007339316517946886, -0.007468872337364808, 0.000670044633630931, -8.446408286193563e-05, -0.006698017097756413, 0.009729614610835716, 0.013758789931089454, 0.021363694505142264, 0.0018267319780845938, -0.005749023595978626, 0.005982223046476038, -0.034461752038940655, -0.0036826138874813644, -0.0021603373166877516, 0.01747703202979825, -0.013823567142306474, -0.021013895329396143, -0.03000504377189327, -0.0014502114110872546, 9.782449472519484e-05, -0.017179053505438642, -0.009379815435089598, -0.026247935718983297, -0.02598882501147004, 0.022257628215575913, -0.006302873222232569, -0.0009838118116004882, -0.02063818489663418, 0.012048657212592273, -0.015365277621523264, -0.0007943369088253701, -0.003313380803312069, -0.02475804868512078, -0.026092470039533414, 0.006234856405396627, 0.020547496428401316, 0.01943331796465559, 0.01394016686755518, 0.006357933944899295, 0.021998517508062657, -0.001786245871827986, -0.016298076354835503, -0.005098007221576565, -0.019925629985311433, 0.004385452310253817, -0.02387707153451764, 0.011789546505079017, 0.021052761283597322, 0.01631103291466601, 0.02772486805566048, 0.010662414275470542, -0.0010898852633094936, -0.006105301051639999, 0.01606487690433809, -0.029253622906369344, -0.02508193660385106, -0.010915047634391132, 0.0002540501625099113, 0.001985437495984045, -0.0015692404913041813, -0.012165257869163566, -0.016285121657650167, -0.009813825730475912, 0.025315136054348472, -0.0011182255260475868, 0.001324704516616367, -0.005855906832677038, 0.02151916204723732, -0.0007947417431124118, 0.008673737872359517, -0.004987885310581819, -0.012793601660846117, -0.008207338040042105, -0.00948993688042305, 0.004502052035502524, 0.007177372558581747, 0.01031909244831709, -0.012813034637946707, 0.024252781967279605, -0.02377342650645427, -0.010539336270306583, -0.006361173084856921, 0.023047915035301014, 0.01061707004135411, -0.005719873664666449, -0.005130396292846368, -0.02803580127720542, -0.0176195430120628, -0.03907392598543793, -0.01540414357572444, -0.03293299718823179, -0.003287469779126873, 0.013266478841756198, 0.00014615475278240242, 0.010630025669862033, 0.014639767081692593, -0.028890867170792717, 0.03303664221629516, 0.013694011788549846, 0.05246996204359593, 0.0032842308719998924, 0.034850419031533124, 0.018759630870179195, -0.033762153687448414, -0.016751520558644994, 0.025911091240422512, 0.004968451867819937, -0.021596893955639677, 0.005204890458274977, 0.03303664221629516, 0.005188696155470722, -0.0032048782294654904, -0.0008753090631309243, -0.008110171291893986, -0.03391761750425313, -0.019627651460951825, 0.0114073577924018, 0.007002472505047395, 0.011387924815301213, -0.014134500363851417, -0.006474534135809295, -0.03236295325917359, 0.014743411178433379, -0.003883424732370267, -0.003935247246401953, -0.028217178213671146, -0.011264846810137251, -0.016984720009142407, 0.012670523655682157, -0.019420363267470257, -0.005959550929417822, -0.012236513360295841, -0.03303664221629516, 0.005532017982624174, -0.00948993688042305, -0.012890768408994236, -0.01739929825875072, -0.020379074189120924, 0.014872966532190007, 0.0035433418123437953, 0.014872966532190007, -0.006192750845576529, -0.003033217083058117, -0.014406566699872595, -0.014069722221311809, 0.004035652668846404, 0.023734560552253092, -0.01356445643479322, 0.0027903006783491164, -0.025781536817988473, 0.0037247194473014624, -0.014056767524126474, -0.004372496681745896, -0.011387924815301213, -0.0004344156535423126, -0.012800079009438785, -0.01334421168148114, 0.014626811453184672, -0.0017732903597353878, -0.02158393925845434, 0.004103669020021052, -0.02430460448131129, -0.006244572893946922, -0.004466424289936387, 0.0006032426106944235, -0.012469712810793255, -0.012566879558941372, -0.001131181038140185, 0.0007947417431124118, 0.0011562825101666212, 0.00994338108423254, 0.016259210400634324, -0.03448766143331133, 0.006743361331872845, 0.036560550818707724, -0.03669010524114176, 0.012404934668253646, 0.004712579834603015, 0.012832467615047296, -0.00467371294907925, -3.261659774338537e-05, -0.0021360456296507222, -0.012579835187449293, 0.033969440018284815, -0.03941077046399871, 0.0026737007202697633, -0.01562438832903652, 0.0029085199735766364, 0.020715916805036535, -0.017580675195216448, 0.011763635248063174, 0.01958878550675065, 0.0031805865424284607, 0.00346560850695756, 0.002385439848613684, -0.001251829571920602, 0.00023765329704298114, -0.010299658539893916, -0.0032129753808676177, 0.004829179559851721, -0.00978791447346007, 0.008388715907830418, -0.010383869659534112, -0.001774909813298878, 0.017282698533502013, -0.03223339883673955, -0.03184473184414708, -0.015689166471576126, 0.007132027858804023, -0.006312589710782863, -0.02649409172931122, -0.016906988100740053, 0.0012226796406084254, -0.012463235462200588, 0.0010056742600846207, 0.005966028743671784, -0.013836522770814397, 0.0032567002778358827, 0.008971715465396537, 0.02032725167508924, 0.011174158341904388, -0.013020323762750865, -0.024524847371978194, 0.012884290129078982, -0.010772536652126583, -0.051925827508908395, -0.024524847371978194, -0.029149977878305974, 0.035368640446559636, 0.017179053505438642, 0.006095584097428411, -0.01824140759250751, 0.005182218341216761, -0.03412490756037987, 0.009684270376719286, -0.0018056791981745448, 0.00987860387301552, 0.00029089249824866634, 0.0008502077075198115, 0.015689166471576126, 0.017140187551237463, -0.002476128782507841, -0.0033069029890581084, -0.022166937884697875, -0.01271586788979859, -0.004770879697227368, -0.005282623763661213, 0.010183058814645209, -0.015300499478983655, -0.01750294142416892, -0.013668100531534003, 0.023682738038221407, 0.005295579392169134, -0.006866439337036806, 0.00994338108423254, -0.049256984800083135, -0.023682738038221407, -0.006458339367343746, 0.019226029771174023, 0.01227537931449702, 0.007449438894602925, 0.012897245757586903, -0.01894100780664492, -0.011083468942348938, 0.027154824126602282, 0.0015238960243571028, -0.0023449538587723994, -0.004077758228666502, 0.006147406611460097, -0.002443739711238037, 0.007391139031978572, 0.005438090374433683, 0.021117540357459517, -0.0006809758578729973, -0.02604064752550173, -0.007507738757227278, -0.003475325228338501, -0.005894773252539508, 0.015222766639258714, -0.0215580280014385, -0.015702121168761463, -0.012391979971068312, 0.019705385231999356, -0.00555469009968239, -0.01505434439997832, 0.007060772367671748, -0.021350739807956928, 0.01824140759250751, -0.023592049569988543, 0.027258469154665652, -0.033580773025692345, -0.00023340226054265024, -0.0006923119746097668, -0.007488305314465396, -0.017204964762454485, 0.023799337763470114, -0.009140137704676931, -0.012294813222920194, -0.014626811453184672, -0.0026121619505184296, 0.0046769520890368775, 0.006691539283502452, 0.0006740932675396565, 0.011711813665354075, -0.015067300028486243, -0.007844583235788063, 0.009263214778518304, -0.007093161438941551, -0.026532957683512395, -0.012301290571512863, 0.010137714580528777, 0.013318301355787885, -0.0059725065579257445, 0.23257795285806757, -0.03231113074514191, 0.011206546947512898, 0.012171735217756234, -0.003889902546624228, 0.014341789488655573, 0.03158561927398865, -0.0011425172130846164, -0.001692318147222172, 0.012165257869163566, -0.014186322877883102, -0.005998417814941587, -0.002958722684798862, 0.00540570130316388, -0.0021068956983385455, 0.003734436168682404, -0.039825346850961854, 0.010565247527322425, -0.02031429511525873, -0.016492409851131738, 0.014523166425121302, -0.02035316293210508, 8.851269494278796e-05, 0.006519878369925726, 0.027388023577099692, -0.020521585171385474, -0.02504307064964988, 0.006801661660158492, 0.014186322877883102, 0.006516639695629393, 0.0002613376453379555, 0.005227562575333193, -0.010843792143258858, 0.0005190315492618889, -0.025768580258157963, 0.009749048519258893, -0.01721791945963982, 0.011031647359639837, 0.005389507000359625, 0.015443010461248205, -0.0007939320163306668, -0.0013085100973967885, 0.008971715465396537, -0.02449893611496235, 0.026999356584507223, 0.02553538080766055, -0.007902883098412417, 0.01334421168148114, 0.01736043044190437, 0.023203382577396073, -0.01004054783238066, 0.021363694505142264, 0.005243757343798742, 0.014989566257438714, 0.004003263597576601, 0.004848613002613604, 0.009846214336084423, 0.015468921718264049, 0.002330378893116311, -0.01729565323068735, -0.015870543408041855, 0.021830095268782265, -0.0018105375588650153, 0.014497256099428044, 0.006723928354772256, 0.008913415602772184, -0.022905404053036465, 0.035938684375617834, -0.0013441378429629258, -0.016000099693121068, -0.003770063914248541, -0.009263214778518304, -0.0065976116753119615, -0.00825916055407379, -0.014069722221311809, -0.0228147155848036, 0.010908569354475877, 0.0029668200690316365, -0.004557113223830543, 0.016906988100740053, -0.004450229987132131, -0.01631103291466601, 0.0018639791772142214, 0.01422518883208428, -0.0037247194473014624, -0.02387707153451764, -0.002942528381994607, -0.010118281603428187, -0.007170894744327787, 0.0057393066417670375, -0.009217870544401872, -0.01760658645223229, 0.0035141918810316186, -0.014108589106835573, 0.020664096153650023, 0.02369569273540674, 0.00409071339151313, 0.023125648806348542, -0.01243084592526949, -0.011724769293861997, -0.01789160841676139, -0.002461553584021106, 0.042235080714919035, -0.012897245757586903, -0.014289966974623888, -0.00873203773498387, -0.0021198510940158206, 0.005386268326063291, 0.01590940936224303, -0.010273748214200658, -0.019213075073988686, -0.01257335690753404, 0.01645354389693056, -0.008265637902666458, 0.02391593748871882, 0.00818142678302626, 0.0058235177614072335, -0.028217178213671146, 0.017658408966263976, -0.006834050265767002, -0.009638926142602854, -0.01107699159375627, 0.011180635690497055, 0.022102160673480854, -0.026092470039533414, -0.02956455612791429, -0.005221084761079233, 0.023630915524189722, 0.01081140260632776, -0.031792909330115394, -0.0034947584382697366, -0.019873807471279748, -0.0034396974827723636, -0.02641635795826369, -0.0017797680575740251, 0.013668100531534003, -0.0013773364663914895, -0.002722284094343822, 0.010221925700168973, -0.015326410735999498, 0.024278693224295447, 0.007514216571481239, 0.02845037766416856, 0.019990407196528455, 0.005635662545026253, -0.023060871595131524, 0.00896523811680387, -0.0034364585756453832, -0.02469326961125859, -0.010882658097460035, -0.03669010524114176, 0.008142560828825083, 0.010124758952020856, -0.0051725018526664664, 0.028217178213671146, -0.023514315798941015, -0.02074182806205238, -0.02785442247809452, -0.015572565815004833, -0.01151748016905784, -0.021052761283597322, 0.00792879435542826, 0.027310289806052164, -0.03257024331530033, -0.02514671381506808, 0.005357118394751115, -0.16728200241066218, -0.003889902546624228, 0.024965336878602352, -0.01356445643479322, -0.00781219416451826, 0.0028826089493914405, 0.02059931707978783, -0.0098656482445076, 0.0010137714114867482, 0.020754784621882887, 0.015235721336444049, -0.011595213008782782, -0.0535841367820513, -0.018668940539301158, 0.0028064952139840184, -0.009962814992655717, 0.0009327993153888559, -0.0031741087281745, 0.015611432700528598, 0.009379815435089598, 0.012204123823364745, -0.023864114974687135, 0.00840167153633834, 0.001962765146095183, 0.004505291175460151, 0.007235672421206101, -0.0006125543813729994, 0.01031909244831709, -0.0068729171512907665, -0.03137833294315225, -0.0002965605275132203, -0.0256778917899251, -0.0013028420681322345, -0.007430005451841043, -0.009522326417354147, -0.0006915022478280218, -0.014821144018158322, -0.03212975380867618, 0.009101270819153165, 0.016544232365163423, 0.01672560930162915, 0.03886663592931118, 0.004178163651110954, 0.01746407546996774, 0.008395193256423086, 0.018474608905650097, 0.013732878674073612, 0.007773327278994495, 0.020897295604147437, -0.010500469384782817, 0.011776590876571095, -0.016777431815660836, 0.019925629985311433, 7.1660361799105e-05, 0.02618315850776628, 0.010908569354475877, 0.00697008343377759, 0.004077758228666502, -0.0070219059478092765, 0.005564407053893978, -0.005862384646930998, -0.006043762049058019, 0.008330416045206065, -0.029823666835427542, -0.01774909743449684, -0.01061707004135411, -0.006461578507301373, 0.005250234692391408, -0.03155970987961798, 0.0018348291294867215, 0.01237902434256039, -0.008453494050370026, -0.00034676326783927684, -0.022866538098835286, 0.0019481901804390943, 0.01495069937191495, -0.01378470025678271, 0.014691588664401694, -0.0024631731539999195, 0.004362780193195602, -0.007760372116147867, 0.045888543739765635, -0.012845423243555218, -0.005033229544698251, 0.007391139031978572, 0.008900459974264262, 0.0021198510940158206, -0.014199278506391024, -0.0013506156572168865, -0.02331998230264478, 0.006944172642423041, -0.022335360123978267, -0.019420363267470257, -0.018915096549629078, 0.012670523655682157, 0.010014636575364815, -0.005366834883301409, 0.0009619492467010325, -0.00978791447346007, -0.009308559943957323, 0.0018089181053015252, -0.020858427787301084, -0.01781387464571386, 0.03000504377189327, 0.025418781082411843, 0.0034235029471374615, 0.004048607831693032, 0.009289126035534147, 0.020379074189120924, 0.005214606946825271, 0.005357118394751115, 0.005817039947153273, 0.014030856267110632, 0.041302279187639034, -0.026869802162073183, -0.003368441991640089, -0.00020577050146262626, -0.0021166121868888403, 0.01894100780664492, -0.006127973168698215, 0.03977352433693016, -0.004482619058401935, 0.011808980413502193, 0.006302873222232569, -0.009224348824317127, -0.0007712598410647892, -0.09146615239534114, -0.025211492888930275, -0.006827572451513041, 0.010850269491851524, 0.0061409287972061365, 0.022944271869882817, -0.0009230826522155763, 0.009587103628571167, -0.023164516623194895, 0.026558868940528238, -0.00037105492577247545, -0.021454382973375128, 0.010681847252571132, -0.008375760279322497, 0.031611532393649666, 0.005771695713036842, -0.00708020581043363, -0.022594472694136697, -0.013629234577332826, 0.005577362216740606, 0.007164416930073826, 0.007067250181925709, 0.0007680209339378088, -0.00798061593813736, -0.019783119003046884, -0.002123090001142801, -0.016181476629586796, 0.014717499921417536, 0.0016445445581375199, 0.012741779146814432, 0.029434999842835072, -0.011841369019110703, -0.0002939289300244642, -0.017373387001734877, -0.024084359727999213, 0.004855090816867564, -0.03622370634014693, 0.00910774909906842, 0.03137833294315225, -0.012476190159385921, 0.014989566257438714, 0.0057814122015871355, 0.0066202837923701775, -0.022244671655745403, 0.012217079451872667, -0.012767690403830275, -0.0005724731676110949, 0.015585521443512754, 0.028502200178200248, -0.02785442247809452, -0.010202492723068383, -0.008323937765290812, -0.03612006131208356, 0.009749048519258893, 0.02116936100884603, -0.015002521885946635, -0.008537704238687636, 0.018319141363555037, -0.008634870986835753, 0.010034070483787991, -0.020119961618962495, 0.005914206695301391, 0.027103001612570593, 0.013966078124571023, 0.002649409033232734, 0.00781219416451826, -0.004401646613058073, -0.004165208022603032, 0.028294911984718677, -0.010267269934285405, 0.0007441341393954827, 0.002518234109497292, -0.028968600941840245, 0.006911783571153237, -0.030393710764485743, 0.022166937884697875, -0.033865794990221444, -0.01371992304556569, 0.029745933064380014, -0.01524867696495197, 0.0029684394061798036, -0.037571084254390076, 0.01855234081405245, -0.015132077239703263, 0.021985560948232147, 0.014341789488655573, -0.009509370788846226, -0.021389605762158106, 0.0009376576178716647, -0.014963655000422871, 0.0028064952139840184, 0.02891677842780856, 0.0243564251326978, -0.03241477577320528, -0.016894031540909543, 0.002229973237841213, 0.005408940443121507, -0.008725560386391204, 0.015313455107491577, 0.026817979648041494, -0.003012164303148068, 0.006416233807523648, -0.08664669211800749, 0.018124807867258803, 0.009813825730475912, -0.01386243402783024, 0.032285221350771234, -0.004825940885555388, 0.0012089143435264204, -0.03671601836080278, 0.003980591480518385, -0.0066202837923701775, -0.025315136054348472, 0.004268852119343818, -0.0031660115767723723, 0.013305345727279963, -0.008945804208380695, -0.02215398318751254, 0.019679473974983513, 0.0005186267149748471, -0.008323937765290812, 0.007851060584380731, -0.006710972726264334, 0.007125550044550062, -0.00384779698680413, -0.003783019309925816, -0.00901705969951297, -0.0025878702634814003, 0.014445433585396359, 0.02246491640905748, -0.013499678292253611, -0.009379815435089598, 0.01095391358859231, -0.031689264302052024, 0.0033101418961850888, 0.03604232940368121, -0.017878653719576056, -0.03941077046399871, 0.017282698533502013, 0.0031060921441692056, -0.0017085125664417504, 0.018876230595427902, 0.008479404376063282, -0.0018623597236507312, 0.01598714313329056, -0.01571507772859197, 0.0009076979015700813, 0.0015287543850475735, 0.005263190320899331, 0.0014615474696163624, 0.03575730743915211, 0.013357167309989062, 0.020456806097523282, -0.000960329851345204, 0.0027724868055660477, -0.0007433244126137376, 0.014419522328380516, -0.03166335490768135, 0.039229393527532984, -0.0008153896887354192, 0.02106571784342783, -0.024719180868274432, 0.01208104674952337, 0.014432477956888437, 0.014043811895618553, 0.00455387454953421, 0.003922291617894032, -0.008110171291893986, -0.007384661217724611, -0.005933640138063273, 0.011400880443809134, 0.0029652004990528232, -0.021959649691216304, -0.01299441250573502, 0.023902982791533484, -0.010118281603428187, 0.025068981906665726, 0.010727191486687564, 0.01118711397041231, -0.0036728971661004234, -0.02668842336296228, 0.021402562321988616, -0.016116699418369775, -0.017775008691512682, 0.00408423557725917, 0.00040020491529231376, 0.032492507681607635, 0.015455966089756126, -0.028346734498750362, -0.005710156710454861, 0.005431612560179723, 0.004003263597576601, 0.010746625395110738, 0.013033279391258786, 0.0008315841079549977, -0.000726320266612414, -0.007138505673057983, 0.0003607309820648026, -0.011854324647618625, -0.0057166345247088215, -0.009684270376719286, 0.022840626841819443, -0.015365277621523264, -0.0028761311351374794, -0.0119255801387509, -0.020910250301332773, -0.01620738788660264, -0.01637581012588303, -0.011886713253227136, -0.018889185292613235, -0.02870949023432699, 0.0028599368323332245, 0.039229393527532984, -0.005525540168370213, -0.016038965647322247, 0.02084547309011575, -0.008744993363491792, -0.009658359119703442, -0.008900459974264262, -0.009340948549565834, -0.020197695390010026, 0.0296163767793008, 0.018461652345819587, 0.024084359727999213, 0.025794491515173806, -0.02246491640905748, -0.0016113460511242796, 0.017425209515766562, 0.022555604877290344, -0.024848737153353645, -0.003345769641751226, -0.002367625975830615, -0.00667210584074057, -0.0069571282709309625, -0.029538644870898443, -0.0228147155848036, -0.009075359562137323, 0.0077344608591320245, 0.00033340286325197533, 0.0025247119237512532, -0.01754180924101527, 0.04653631957722618, -0.014691588664401694, -0.016000099693121068, 0.012987934225819767, -0.0179045649765919, 0.015533698929481069, 0.0052405182038411146, 0.03684557278323682, -0.01620738788660264, -0.010921524982983799, 0.01951105173570312, -0.0246414470972269, -0.009353904178073755, 0.0009846214801745717, -0.022801760887618268, 0.01051342501329074, -0.038529791450750396, -0.009638926142602854, 0.002038879114333251, -0.01598714313329056, 0.03697512720567086, 0.01065593599555529, 0.017049499083004602, -0.0077538943018939065, -0.021350739807956928, -0.006898827942645316, 0.019627651460951825, -0.007138505673057983, -0.00788344918998924, -0.012404934668253646, 0.009658359119703442, 0.011536913146158428, -0.027180735383618124, -0.015663255214560284, 0.014574988939152987, -0.013875389656338161, -0.008589526752719321, -0.01004054783238066, -0.0022785566119152716, 0.0003514191822823957, -0.022024426902433326, 0.005551451425386056, -0.016634920833396287, -0.041405924215702404, 0.01986085091144924, 0.006691539283502452, -0.025872225286221334, 0.0230997375493327, 0.0036016416749681487]"
2,Tiger,"[-0.013397357906240956, -0.009651300171978608, -0.008948914405012076, -0.001981963569535636, -0.018522172541836666, 0.023204744942495234, -0.025129801677841998, 0.0012673835308494826, -0.0027997876970565546, -0.022138158975745587, 0.0028566938327535193, -0.0003546478863917973, 0.01780677899290901, -0.0066433984409227, -0.010665857804851395, -0.011732443771601044, 0.03191953044807762, -0.0054987699733577595, 0.022723480292997273, 0.006396262690854429, -0.013787571807301233, 0.01009354333823829, 0.008825346529977941, 0.009644796746659318, 0.0024892421531413937, -0.0010763411047285828, 0.015491508356501971, -0.015855708556285087, 0.0016153245852577854, -0.008877375795177346, 0.02501273629680461, -0.03189351674680046, -0.02397216589397721, -0.03204960267975359, -0.011043064855273092, 0.004932959397725215, -0.0046695646186974485, 0.0050662824107382855, 0.0188473512583815, -0.0007048246096689239, 0.023022643445619863, 0.02042121557590627, 0.0024664796988626077, -0.004802887631710519, -0.010665857804851395, 0.005137821486234288, -0.00870828301158564, -0.013774564956662653, -0.0411546030177188, 0.020798421695005422, 0.006991339611746321, -0.0022518617738826927, -0.0027298742450597388, 0.0016665402238003715, -0.03498921425400551, 0.00035017669417329714, 4.283211675311144e-05, 0.015127308156718854, 0.0034046197559273812, -0.004263091223016404, 0.022073122859907604, 0.003090822499352575, -0.015166329639957135, 0.004545996743663312, -0.007804285937447137, -0.01781978584354759, -4.628714148951519e-05, 0.013137215305534106, 0.011140618097707524, 0.0032761743119037786, 0.0379288295535476, 0.018938401075496644, 0.015296400940310562, -0.0001993751289861314, 0.011205654213545508, -0.001988466994854926, -0.020109043710000014, -0.0067637146032971905, 0.01975785129217802, -0.01014557167211515, 0.022671451027797867, -0.015894729108200827, -0.02434937201307636, 0.0006280011518550448, 0.015270386307710859, -0.004087495014105408, -0.00675070728699734, 0.015673607059409716, -0.016467043574813933, 0.006253184074201152, 0.009501718595667313, 0.015283394089671982, -0.005430482610521402, 0.025988272446439115, -0.006435284174092711, -0.00765470389547457, -0.005849962856841025, 0.003869625143635212, -0.002973758282468365, -0.05054576152031309, 0.005342684040404632, 0.004919952081425364, -0.02112360041155026, -0.009703329437178013, -0.012655950656036143, -0.012142168879941732, -0.0008048169858440445, -0.015673607059409716, 0.03145127264921824, -0.004825650085989304, -0.016805229141997346, 0.010256132696510706, 0.02385510051293982, -0.06789728770235622, 0.018613222358951808, -0.009111503763284495, 0.02718493064486473, -0.00969032165521689, 0.00029875782358948326, -0.024804622961297165, 0.01661012265712848, 0.012337275364810598, 0.02618338079395307, -0.03194554414935478, 0.014971222223765726, 0.005323173298785492, 0.0007430330483269767, -0.014034707557369503, -0.0034403895265060183, -0.0006471053711840713, 0.02879781551430524, 0.0062857021321201445, 0.02429734461052204, 0.02343887197927984, -0.017481600276364175, 0.012350283146771722, -0.013156725581491975, 0.000663770806018364, -0.013085186040334701, -0.03990591555409377, 0.007127914803080308, 0.009287100903518034, -0.005238626906989638, -0.012467346665164023, -0.00903346079680793, 0.012870568348185422, 0.025819179662847407, -0.0025298894927094978, -0.015192343341234295, 0.0012047866651675036, 0.025480994095663994, -0.01504926519024229, 0.031087073380757665, -0.004357393218452465, 0.009729343138455172, 0.004315120022554538, 0.004737851981533806, 0.01848315012727584, 0.002170567094746484, 0.0010397585224003524, 0.023894122927500643, -0.01532241464158772, 0.01768971547451671, -0.01731250749277247, 0.0242062947934069, 0.028069415114739007, 0.012311261663533439, 0.017221457675657324, -0.002033992136243133, -0.00438665909805054, 0.012538886206321298, 0.025337915013349446, 0.010763411047285829, 0.02957824517907088, -0.0005198792612001762, 0.020265129642953142, 0.004412673264988971, 0.010399210847502711, -0.024778609260020006, -0.002768895728298021, -0.028901872182058964, 0.01690928580975107, 0.018899378660935818, 0.0031737430348186065, -0.01054879335513655, 0.010269139547149286, -0.009989486670484566, -0.0301505577830389, -0.00675070728699734, -0.016727186175520783, 0.0071084040614611665, 0.008682268378985936, 0.005280900102887565, 0.007700228804032142, -0.7013451816625432, -0.020499258542382832, -0.011075582913192083, 0.010965021888796528, 0.0009129388764989131, 0.005173591256812925, 0.020538279094298572, -0.000493458513763972, 0.006152379119107074, 0.007492114537202153, -0.01858720865767465, -0.002661586649392746, 0.002798161840726732, -0.010158579454076274, -0.015647593358132556, -0.020590308359497978, 0.009943960830604451, -0.004939462823044505, -0.030046501115285177, 0.014190793490322632, -0.003550950085240303, 0.009846407588170018, -0.00784330788634669, -0.0006414147576143748, 0.00851967902071352, -0.005687373498568608, 0.006266191390501004, -0.0031607359513493908, 0.016649143209044218, 0.030020487414008017, -0.033688503113116344, 0.031139100783311984, -0.0064125217198139255, -0.013605472173070945, 0.0416748882191325, -0.021799973408562174, -0.009859414438808597, 0.02994244444753145, 0.004474457202506038, 0.035795657620048306, 0.0059442643866158135, 0.004484212806146245, 0.0013096567267474094, -0.009534236653586306, 0.0011210532015365612, 0.00270223398896085, 0.003534691289111442, -0.004877678885527437, 0.0005076850476882131, -0.009091993487326625, -0.0045394933183440225, -0.0076351931538554295, 0.00462078753181896, -0.015387450757425704, -0.011504818297490641, -0.007986386037338694, 0.01912050070972693, -0.008552197078632511, 0.007615682412236289, -0.006262939677841359, 0.0027721474409576658, -0.0022697466591720112, -0.0027136152161002427, -0.0023526671946380424, -0.002832305522144911, 0.006145875228126513, -0.0264565302452985, 0.008383104295040803, 0.025038751860726856, -0.010230118063911005, 0.0205773015088594, -0.0009267590045483575, -0.00922856821299934, -0.00941066877855217, 0.006562103761786491, 0.023646987177432372, 0.022190186378299906, -0.01818398697465325, 0.014893179257289162, -0.002329904507528621, 0.0016307705696370523, -0.012916093256742993, 0.018249023090491236, -0.0007450654269469137, 0.02333481531152612, -0.025858202077408233, -0.01767670862387813, -0.012714482415232294, 0.016167878559546257, 0.0034306341556964476, 0.01212265767266132, -9.796004848688514e-05, 0.007511625278821294, 0.009371647295313888, -0.005700380814868459, 0.01014557167211515, -0.0031672393766686807, -0.029812372215855483, 0.028875858480781804, -0.02445343054347517, -0.005684121785908963, -0.015842701705646507, 0.01753362954156358, 0.0025120046074201792, -0.003642000135186082, -0.0016047562862833036, -0.015660600208771136, 0.00969032165521689, 0.031737430813847334, -0.019705822026978615, 0.018938401075496644, -0.005667862756949467, -0.016818235992635926, -0.0004902067428966681, 0.024115244976291757, -0.022788514546190172, 0.0212146502286654, 0.01099103652139623, 0.000554023000826014, -0.019965964627685465, 0.010301657605068279, 0.008480657537475237, 0.026391494129460513, 0.008259536420006668, 0.005342684040404632, 0.017832794556831257, -0.014737093324336035, -0.019679808325701455, -0.0060808395779498, 0.009111503763284495, 0.008135968544972533, -0.0008991188066571276, 0.00370378407270315, -0.006952318128508039, 0.0009340754744478765, -0.004555751881642247, 0.016493057276091093, 0.009475703963067612, 0.0179888786271393, -0.004988239444261721, -0.02996845814880861, -0.010067528705638587, -0.0102886507544297, 0.005869473598460166, -0.004939462823044505, -0.028771801813028082, -0.004168789693241616, -0.01171943598963992, -0.011257682547422371, -0.004958973564663646, -0.007238475361814592, -0.01815797327337609, -0.013644493656309228, 0.004038717927226919, 0.023659994028070952, -0.006422277323454131, -0.014906186107927741, -0.013065675764376831, -4.0139230361205375e-05, -0.007075886003542174, 0.008096947061734252, 0.02718493064486473, -0.014672058139820594, 0.0009804134857933362, -0.002220969805124159, -0.02718493064486473, -0.014268836456799196, 0.02343887197927984, -0.028095430678661253, -0.03761665768764135, -0.0011129236870568132, -0.0068027360865354726, 0.014294851089398897, 0.01302015085581926, 0.01791083752330782, -0.004874427172867793, 0.0006271882236901336, -0.03087895818260513, -0.022866557512666735, -0.0046695646186974485, 0.02652156636113648, 0.005784927206664313, -0.0031818725492983543, -0.007882329369584972, 0.019406658874356025, 0.003905394914213849, -0.008610728837828662, 0.039281571822281265, -0.01171293256432063, 0.008279046695964538, -0.003885884172594708, 0.026612616178251627, -0.0067572111779779015, 0.0007670150112684473, -0.008610728837828662, -0.019575751657947733, -0.000669867883670516, 0.017078378593342776, 0.006906793219950467, 0.01052928307917868, 0.011771465254839325, 0.00017518996310726247, 0.002284379598971049, 0.005209361027391562, 0.02700282914798936, -0.014060722189969206, -0.0057198915564876, -0.02602729486099994, 0.03746057175468822, 0.020226109091037402, 0.007927854278142544, -0.030280630014714868, -0.027679202145001275, 0.00674420386167805, 0.009781371472332033, 0.019848901109293163, 0.03012454408176174, 0.01571262947397054, 0.012851058072227552, -0.01321525827201067, 0.019237566090764317, -0.01991393722513115, -0.01192755025646991, -0.015673607059409716, 0.01058781483837483, 0.029812372215855483, -0.003196505489097392, 0.019588758508586313, 0.0022356027449231966, -0.01145929338893307, -0.009833400737531438, -0.0005056527272759351, 0.006789728770235622, 0.005228871769010703, 0.01322826512264925, -0.007901839645542842, 0.014424922389752322, -0.03285604604579639, 0.026352473577544774, 0.004819146660670014, -0.005456496777459833, 0.03394864385117811, -0.0024274582156243256, -0.010223614638591715, -0.0011706428673340069, 0.004497219656784825, 0.003996444731328992, 0.003269670653753853, -0.015582558173617114, 0.01793685122458498, -0.005280900102887565, 0.018001887340422962, -0.014203800340961211, 0.008324571604522109, 0.00897492903761178, -0.02674268654728251, 0.026495550797214235, 0.008266039845325958, 0.009261086270918333, 0.015374443906787124, 0.005567057336194117, 0.004146026773301559, 0.010613829470974534, 0.002957499253508869, 0.01055529678045584, 0.010633339746932403, -0.01166090423044377, -0.010119557970837991, 0.009833400737531438, -0.007030361094984603, 0.004923203794085009, 0.004754111010493302, 0.006558852049126846, -0.024609516476428298, 0.02187801451239365, -0.000990981784767818, 0.00371353944351272, 0.006399514403514074, 0.009963472037884863, 0.015400457608064284, -0.005999544898813592, -0.03644601505313798, 0.018652242910867547, 0.013813586439900934, -0.00969682508053618, -0.005046771669119145, -0.01055529678045584, 0.0002375836112999284, -0.009852911013489308, 0.017884821959385573, 0.025689109293816525, 0.01831405734368413, 0.01482814407277372, -0.006012552215113443, -0.010197600937314555, 0.0029119743449512975, 0.025246865196234303, -0.01815797327337609, 0.0016616625383955863, 0.013995686074131222, 0.010633339746932403, -0.0007922163082496258, -0.009833400737531438, 0.0114397831129752, 0.023269779195688133, -0.005901991190717887, -0.009085490062007335, -0.017364536757971873, 0.02090248022540423, 0.009950465187246285, 0.012525879355682718, -0.02656058691305222, -0.01776775844099327, -0.020278136493591722, -0.018665251624151214, 0.004276098539316256, -0.011764960898197492, -0.020213100377753736, 0.03410472978413123, -0.004113509181043838, -0.008623736619789785, -0.003749309214091357, -0.010035011579042137, -0.002601428801036136, 0.09115405818476069, 0.006106853744888232, -0.01058131141305554, -0.004958973564663646, 0.019640785911140633, -0.011680414506401638, -0.024908679629050887, -0.01949770869147117, 0.018392100310160697, -0.001073902320233849, -0.0017982376133142551, 0.0037428055559414314, -0.015023250557642589, -0.006386507552875494, 0.024804622961297165, 0.008578210779909671, -0.02064233762469738, -0.037122386187504804, 0.00811645733769212, -0.017325514343411046, 0.018886371810297238, 0.012916093256742993, 0.030826930780050815, 0.005768668177704816, 0.004077739410465201, -0.009436682479829329, 0.03881331774871205, 0.021552837658493904, 0.017078378593342776, -0.033688503113116344, -0.00898793588825036, 0.009332625812075607, -0.0021884519800358026, -0.006275946528479939, -0.0036094823100977255, -0.004919952081425364, -0.00470858610193573, 0.008890382645815926, 0.007966875761380826, -0.011088589763830663, 0.021227658941949067, 0.024609516476428298, 0.005521532427636546, -0.0019835894258654584, 0.015790672440447105, -0.007752257603570275, 0.011296704030660652, 0.025103786113919755, 0.0015844326164992516, 0.00899443931356965, 0.02476560054673634, 0.008096947061734252, -0.030722872249652006, 0.005417475294221551, -0.01511430037475773, 0.0345209601804363, -0.0028957153159918014, -0.01368351513954751, 0.011231668846145211, -0.012662454081355433, -0.00942367562919075, -0.01504926519024229, -0.00697833229544647, -0.018392100310160697, 0.010217111213272425, -0.025480994095663994, 0.00941066877855217, -0.03337633124721009, -0.024388394427637187, -0.01459401517334403, -0.004129768210003334, -0.022073122859907604, -0.02403720200981519, -0.0042435804813972635, -0.005797934057302893, -0.015140315007357434, 0.0006662096487207565, -0.005882480449098746, 0.013774564956662653, 0.02604030171163852, 0.007505121853502004, -0.024635530177705457, -0.014229814973560913, -0.032309743417815354, -0.022177179527661326, -0.0010397585224003524, 0.012194197213818593, 0.001198283123432896, -0.003107081295481435, 0.0011348733295860056, 0.0077132361203319936, -0.012434829538567574, 0.036185874315076215, -0.0028989670286514464, -0.013514422355955803, -0.003537943001771087, 0.011433278756333367, 0.012181190363180014, -0.015530529839740253, -0.010412218629463834, 0.0134884077233561, -0.02501273629680461, -0.008877375795177346, 0.0059832858698540955, 0.017468593425725595, 0.002017733107283637, 0.016857258407196752, 0.01373554347342437, -0.004389910810710185, -0.01032767223766798, 0.03363647198527185, -0.017377543608610452, 0.013163229006811265, 0.01190803998051204, 0.01991393722513115, 0.012096643040061616, -0.0056288412737111855, 0.019666801475062876, -0.009514725446305893, -0.02342586512864126, -0.002645327853263885, -0.004754111010493302, 0.021474794692017338, 0.007349035920548876, 0.002279501797150946, 0.006607629136005335, 0.004334630764173678, 0.00292985899740998, 0.00897492903761178, -0.010165082879395562, 0.015335422423548843, -0.0024144511321551104, -0.0006966951533968348, -0.018665251624151214, -0.032309743417815354, 0.009124511545245618, -0.013306308089125814, 0.012571404264240289, 0.009345632662714185, -0.029916430746254292, -0.025181829080396317, -0.0005332928669595061, 0.006357241207616147, 0.001324289782961765, -0.01757265009347932, -0.02579316596157025, -0.02005701444480061, 0.025676100580532858, -0.003866373430975567, 0.017143414709180762, -0.017520622690925, 0.01914651441100409, -0.001926683173753176, -0.0018340072674775743, -0.023360829012803275, -0.04339182975632673, -0.03878730032214472, 0.0033363323930910237, 0.0363679739493065, 0.014268836456799196, 0.01171943598963992, 0.0032973109098527417, 0.017650693059955883, 0.007791279086808557, -0.012337275364810598, 0.004770370039452798, -0.007888832794904262, 0.02198207304279246, -0.025936245043884795, 0.011296704030660652, 0.015439479091302565, 0.01857420180703607, 0.00924157506363792, 0.0179238443739464, -0.0030778154158833597, 0.013195747064730257, -0.006298709448419996, -0.008415621421637253, -0.00270223398896085, -0.01882133755710434, -0.017884821959385573, 0.005287403993868125, -0.014737093324336035, -0.016831242843274506, 0.006272694815820294, 0.003710287730853075, 0.03384458904606947, -0.007940861128781123, 0.009248079420279753, 0.006526334456869126, 0.009963472037884863, 0.008799332828700782, 0.002918477770270587, -0.007875825012943139, -0.01882133755710434, -0.013046164557096418, -0.034703059814666586, 0.008747303563501377, 0.0042858536772951905, 0.004211062889139543, 0.00264857956592353, 0.020343172609429704, -0.01701334434014988, -0.0012706353599244453, -0.0027006081326310274, 0.03355843088144037, 0.012987632797900267, -0.016922294523034734, 0.0038371073185468558, -0.02476560054673634, -0.02144877912809509, -0.03348038605231873, -0.0197708581428166, -0.03345437235104157, -0.009508222020986603, 0.011023554579315222, -0.028589702178797794, 0.009059475429407634, 0.004126516497343689, -0.026352473577544774, 0.021760950994001348, 0.002001474311154777, 0.042481331585175294, 0.008883879220496636, 0.028979915148535526, 0.028849844779504644, -0.02333481531152612, -0.00618164499870515, 0.02669065914472819, -0.0011584487120297028, -0.024115244976291757, 0.011355236721179347, 0.002607932226355426, 0.005690625211228253, -0.0045850182269015945, 0.00851967902071352, -0.005690625211228253, -0.023490901244479244, -0.004887434023506372, 0.015205351123195418, 0.0014820014558293974, -0.0020096035928038893, -0.017052364892065616, 0.0005271957893073541, -0.03410472978413123, 0.01848315012727584, -0.011602372471247617, 0.005293907419187415, -0.021292693195141967, -0.032804014917951894, -0.012701475564593714, 0.022177179527661326, -0.03358444458271753, -5.4518221058175544e-05, 0.0018795322924504637, -0.02578015911093167, -0.016779215440720186, 0.006305212873739286, -0.008643246895747655, -0.011277193754702782, -0.016857258407196752, 0.023673000878709532, 0.006952318128508039, 0.005085793152357426, -0.0010527657222848858, -0.008025407520576977, -0.005284152281208481, -0.006028811244072939, 0.0038013377807988545, 0.029031944413734932, -0.0013486782099856912, 0.017884821959385573, -0.015179336490595715, 0.01033417566298727, -0.014047715339330627, 0.010197600937314555, -0.002232351032263552, 0.0008625362243288972, -0.011244675696783791, -0.001957575026096392, -0.002757514501158628, 0.020980523191880797, -0.020239115941675982, 0.0035119288348326567, -0.03387060274734663, -0.01459401517334403, -0.021396751725540775, -0.01433387257263718, -0.021695914878163365, -0.022801523259473835, -0.018938401075496644, -0.006584866216065278, -0.0014502965589059521, 0.013202250490049547, 0.012603922322159282, -0.015166329639957135, -0.01035368593894514, 0.041726915621686816, -0.03353241718016321, 0.020863457810843408, -0.0037753233810297877, 0.013553443839194084, -0.009859414438808597, -0.005476007519078974, 0.008669261528347356, -0.02918803034668806, 0.01727348694085673, -0.0358476887478928, -0.01106257513123096, -0.00876681477078179, 0.01459401517334403, 0.009443185905148619, -0.02157885135977106, -0.0005206921893650874, 0.02112360041155026, 0.012577907689559579, 0.009345632662714185, -0.010015500371761726, -0.00663689501560341, 0.005355691356704484, -0.0023006386279305455, -0.0015421594206013248, -0.00019012785283154516, -0.008695275229624516, 0.0022648688573519084, -0.024674550729621197, 0.0027558886448288055, 0.013332321790402972, -0.02082443725892767, -0.011940558038431033, -0.027054858413188762, 0.04469254462250607, -0.008818843104658651, -0.010457743538021405, -0.014620028874621188, -0.005033764352819293, -0.019211550526842074, 0.006594621819705483, 0.002346163536488117, -0.003772071668370143, -0.003560705456049873, 0.019939950926408306, -0.007069382578222884, -0.0019006688903994273, -0.0010828446464631904, -0.007810789828427698, -0.005137821486234288, -0.009313114604795194, -0.03691427285199736, -0.025923236330601132, -0.036706159516489915, 0.02451846479666807, 0.010698375862770388, -0.015491508356501971, -0.026846745077681318, 0.02628743746170679, -0.03285604604579639, 0.01581668614172426, 0.009761861196374164, -0.0005019944341185167, 0.0025006233802807865, 0.007667711211774422, 9.541958976387862e-05, 0.03436487424748317, -0.013553443839194084, 0.0057198915564876, -0.011231668846145211, -0.00784330788634669, 0.0005747531346925218, -0.006288953844779789, 0.007492114537202153, -0.0034729073515943746, -0.019159523124287755, -0.01237629684804888, 0.013085186040334701, 0.013592465322432365, -0.005342684040404632, -0.0023022644842603675, -0.03376654421694782, 0.0106073251143327, -0.011322718663260355, 0.01780677899290901, 0.005703632527528104, 0.00851967902071352, 0.008584715136551504, -0.015010243707004009, -0.005319921586125847, 0.008844857737258354, -0.0060678322616499495, 0.007732746861951134, -0.0036680145349551486, -0.004536241140023106, -0.01772873602643245, 0.023764050695824674, -0.006698678953120478, 0.016688165623605044, -0.009046468578769054, -0.010952015038157948, 0.0010877223318679758, 0.002017733107283637, -0.0054499933521405435, 0.01215517573058031, -0.02721094434614189, -0.0028566938327535193, -0.006900289794631177, 0.0020226109091037404, -0.009573257205502044, -0.005004498473221218, 0.014750101106297157, -0.015426472240663987, 0.019029450892611786, -0.016857258407196752, 0.009248079420279753, -0.010008996946442436, -0.00563209298637083, 0.008454642904875536, -0.016701172474243624, -0.015400457608064284, 0.022476344542929003, -0.005206109314731917, -0.012805533163669981, -0.005820696511581678, -0.010691872437451098, -0.005989789760834657, -0.007218964620195451, 0.005973530731875161, 0.012343778790129888, -0.016454036724175353, -0.03639398765058366, 0.0012015348360925409, 0.0036322447643765115, -0.009462697112429032, -0.019328615907879463, 0.030176573346961146, -0.002233976888593374, -0.0014941956111337014, 0.23308800865190923, -0.029552229615148633, 0.0013316063692766019, 0.03891737255382069, 0.002027488478093208, 0.01794985807522356, 0.02723695804741905, 0.003333080447600743, -0.0011755205527387922, 0.01750761584028642, -0.01779377214227043, 0.01009354333823829, 0.003155858149529288, 0.0032908072517028163, -0.00037151652416348834, 0.016037808190515375, -0.04391211495774043, 0.0003782233561469828, -0.01099103652139623, -0.01599878577595455, 0.010841454013762393, -0.018665251624151214, -0.007290504161352725, -0.003687525276574289, 0.028953901447258366, -0.0042435804813972635, -0.013208753915368836, -0.005866221885800522, 0.016167878559546257, -0.006705182378439768, -0.006945814703188749, 0.0026176875971649963, -0.005882480449098746, 0.0037753233810297877, -0.017832794556831257, -0.00034692489420216384, -0.025650086879255702, 0.013826593290539514, 0.017052364892065616, 0.01412575830580719, -0.012226715271737585, 0.0029591251098386915, -0.00014907406373289994, -0.012864064922866132, 0.007498618428182714, 0.028225501047692135, -0.008181493453530104, -0.003869625143635212, 0.009261086270918333, 0.030592801880621124, -0.01106257513123096, 0.013787571807301233, 0.006945814703188749, 0.02671667284600535, 0.0027119893597704206, 0.006126364486507372, 0.004945966248363794, 0.004767118326793153, 0.006380004127556205, -0.0004938649778464276, -0.005124814635595708, 0.020083030008722854, -0.0064612983410311416, 0.0041590340896014094, -0.014568000540744327, 0.008591218561870792, -0.018001887340422962, 0.03501523168057284, -0.004185048256539841, -0.014177786639684052, -0.011745450622239622, -0.01007403306228042, 0.0009755357421808921, -0.0015137063527528424, -0.024817629811935745, -0.025272880760156546, 0.020772407993728263, -0.001606382259028444, 0.02120164337802682, 0.012343778790129888, -0.0152443726064337, -0.009943960830604451, 0.0032712965100836753, 0.012727490197193417, 0.0005186598689528094, -0.00762218630321685, -0.006272694815820294, -0.0009113130201690906, -0.006874275162031475, 0.02360796476287155, 0.0008682268378985937, -0.022827536960750995, -0.006913296645269757, -0.0008576585389241119, 0.01897742162741238, 0.024921686479689467, -0.006822246828154614, 0.02196906619215388, -0.008948914405012076, -0.017156421559819342, -0.03335031754593293, 0.0022307251759337296, 0.01372253662278579, -0.018795321993182096, -0.011732443771601044, 0.006441788065073273, -0.011043064855273092, -0.0034436412391656633, 0.010685368080809264, -0.01507527889151945, -0.040452218182074805, -0.012883576130146545, 0.011368243571817926, 0.0017397055048721502, 0.007752257603570275, 0.007791279086808557, -0.006568607652767053, -0.030176573346961146, 0.0009430179170925358, -0.006513327140569275, 0.004955721852004001, -0.02620939449523023, 0.00031745560793988356, 0.006841757569773755, -0.01190153655519275, -0.010834950588443103, -0.01237629684804888, 0.009248079420279753, 0.016493057276091093, -0.029057958115012092, -0.00831156475388353, -0.018899378660935818, -0.002863197490903445, -0.0023559189072976873, -0.020876464661481988, 0.01595976522403881, 0.003960675426411627, -0.009475703963067612, 0.0013885126213888845, -0.002185200034545522, 0.03074888781357425, -0.026248415047145965, 0.010477253813979275, 0.006493816398950134, 0.007160432395338028, -0.028303544014168697, 0.006926303961569609, 0.0034989215185328056, -0.015010243707004009, -0.016323964492499385, -0.016727186175520783, -0.002874578718042838, -0.004949217961023439, -0.005570309048853762, 0.023646987177432372, -0.009078986636688045, -0.014203800340961211, -0.018105944008176687, -0.011524329504771055, -0.009677314804578311, -0.032387788246937006, 0.0059800341571944506, 0.023269779195688133, -0.03964577481603201, -0.015387450757425704, 0.015335422423548843, -0.16919692780378, 0.0243233583117992, 0.02700282914798936, -0.009579761562143877, 0.002518508265570105, 0.025533023360863397, 0.018678258474789794, -0.02744507324557158, 0.0016909286508242976, 0.014919193889888865, 0.013046164557096418, -0.01485415777405088, -0.04950518739219552, -0.012330771939491308, -0.005394712839942765, -0.012291750456253026, -0.002151056353127343, 0.0020502509323719934, 0.01726048009021815, 0.020798421695005422, 0.009495215170348023, -0.015933751522761653, -0.005085793152357426, 0.0016697920528753343, -0.003107081295481435, 0.015582558173617114, -0.008012400669938398, 0.019185536825564915, -0.015673607059409716, -0.011979579521669314, -0.016271937089945065, -0.015179336490595715, -0.010308161030387567, -0.003944416397452131, 0.017520622690925, -0.00045890828095184914, -0.016857258407196752, -0.018925394224858064, 0.0001661459335458188, 0.001566547847625251, 0.002095776073760201, 0.02187801451239365, 8.017684470179684e-05, 0.0022144661469742336, -0.00026522378008732897, -0.004428932293948467, 0.012142168879941732, 0.004422428868629177, 0.016258930239306486, -0.022242215643499312, 0.003999696443988637, -0.01458100832270545, 0.02786130177923156, -0.002060006303181564, 0.030566788179343964, 0.005219116165370497, 0.025233858345595724, -0.00674420386167805, 0.009859414438808597, 0.0014909437820587387, -0.022307251759337295, 0.0010153700953764262, -0.0076286897285361395, -0.0019917189403452066, -0.020590308359497978, -0.014450936091029482, -0.013111200672934403, 0.004900441339806223, -0.03064482928317544, -0.002687601049161812, -6.991339378915685e-05, 0.0051573322278534285, 0.012597418896839992, -0.022216201942222152, -0.009612278688740327, 0.008031910945896267, -0.02695080174543504, 0.01599878577595455, -0.013618479023709525, -0.013631486805670648, -0.019419665724994605, 0.05697128729679797, -0.011361740146498637, -0.005641848590011036, 0.01703935804142704, 0.029994473712730858, 0.012890079555465835, -0.010379700571544841, 0.013696521990186089, -0.022567394360044145, 0.02765318658107903, -0.034677046113389426, -0.01882133755710434, -0.008402614570998673, 0.012961618165300566, 0.007524632595121145, -0.02144877912809509, 0.006103602032228587, -0.010158579454076274, -0.018626229209590388, -0.004968728702642581, -0.0034436412391656633, -0.007986386037338694, 0.02433636516243778, 0.01035368593894514, 0.01329330030716469, 0.002212840290644411, 0.014060722189969206, 0.02765318658107903, 0.025715122995093685, -0.017143414709180762, 0.016154871708907677, 0.015933751522761653, 0.020382193161345444, -0.005973530731875161, 0.003411123414077307, -0.005667862756949467, -0.007017353778684752, 0.02814745808121557, -0.016167878559546257, 0.038683245517036086, -0.0020974019300900233, 0.0031834984056281768, 0.016180887272829923, -0.001534842950701806, -0.019198543676203494, -0.07741851843662649, -0.032725973814120415, 0.002581918059416995, 0.015790672440447105, -0.0006170263887981075, 0.015907735958839406, -0.002482738494991468, 0.01886035810902008, -0.013540436057232961, 0.025350921863988025, -0.012668957506674723, -0.020083030008722854, -0.0023201491367190502, -0.012877071773504712, 0.029786358514578323, 0.006584866216065278, 0.0034338858683560926, -0.006471053944671348, -0.016545086541290496, 0.017221457675657324, 0.0032778001682336006, -0.0033070662806623124, 0.0005446741523065581, -0.008669261528347356, -0.008870871438535512, -0.015803679291085684, -0.020733387441812526, 0.02317872937857299, 0.010665857804851395, 0.003677769905764719, 0.005414223581561906, -0.002224221517783804, 0.006513327140569275, -0.021682908027524785, -0.012584411114878869, 0.008454642904875536, -0.033688503113116344, 0.004425680581288822, 0.031139100783311984, -0.016037808190515375, -0.0006922239320745052, -0.0047248446652339545, 0.02459650776314463, -0.03394864385117811, -0.004672816331357093, -0.019822887408016004, -0.010730892989366836, 0.016402007458975947, 0.026170372080669402, -0.023282786046326713, -0.008018904095257687, -0.0011730817682440585, -0.03561355798581802, 0.009794379254293157, 0.028381586980645263, -0.014099743673207488, 0.018509165691198086, 0.037746729919317316, 0.0037883304644990034, 0.023712023293270358, 0.018522172541836666, 0.0007275870639477098, 0.022814530110112415, 0.02030415019486888, -0.008396111145679383, 0.007992889462657984, -0.01184950822131589, -0.019211550526842074, 0.025676100580532858, -0.011043064855273092, -0.00010476847466312137, 0.02354293050967865, -0.008552197078632511, 0.0017478349029365803, -0.011543839780728923, 0.01882133755710434, -0.024661543878982617, 0.01058131141305554, 0.02578015911093167, -0.02879781551430524, 0.002684349336502167, -0.023386844576725522, -0.006028811244072939, -0.009131014970564908, 0.009683818229897601, -0.004949217961023439, -0.010126061396157281, -0.00697833229544647, 0.004776873464772087, -0.011374746997137216, -0.0021526822094571655, 0.030670844847097686, 0.01781978584354759, -0.04471855832378323, 0.0039021429687235683, 0.02385510051293982, 0.006152379119107074, -0.0019071724321340349, 0.010008996946442436, 0.01634998005642163, 0.0014527353434006858, -0.012395808055329293, -0.08413020237774045, 0.022983622893704123, 0.003993193018669347, -0.00595401999025602, 0.028953901447258366, 0.005784927206664313, -0.003550950085240303, -0.02445343054347517, 0.0039021429687235683, -0.003908646626873494, -0.01818398697465325, 0.0023282786511987985, -0.0031834984056281768, 0.014528979057506046, -0.013631486805670648, -0.03785078844971613, 0.019302600343957216, -0.00673770043635876, -0.00185676972175636, 0.008214011511449097, -0.001759216130075973, 0.0026599607930629233, 0.023490901244479244, -0.001851892036351575, -4.628714148951519e-05, -0.004861419856567941, 0.0073295251789297355, 0.023764050695824674, -0.020746394292451103, -0.004734600268874161, 0.011810486738077606, -0.017832794556831257, 0.009274093121556913, 0.03517131761352597, -0.008831850886619775, -0.020382193161345444, 0.012603922322159282, 0.0027233705869098134, -0.008597721987190082, 0.013059172339057542, -0.011036561429953802, -0.009683818229897601, 0.01170642913900134, -0.0063214719026987816, -0.0059280058233175895, -0.0005312605465472281, -0.004659809015057242, -3.08919651205552e-05, 0.024531473509951735, 0.01623291467538424, 0.018249023090491236, 0.01189503312987346, 0.004113509181043838, -0.00019043271544530162, 0.0071474255446994485, -0.03501523168057284, 0.03743455805341106, 0.011751954047558912, 0.009462697112429032, -0.017130407858542182, 0.015907735958839406, 0.014086736822568908, 0.0028566938327535193, 0.012831546864947141, 0.015920742809477986, 0.00022132466965192076, -0.012668957506674723, -0.004315120022554538, 0.01728649379149531, -0.02134472246034137, -0.011127611247068944, -0.0054597484901194775, 0.01486716462468946, 0.005316669873466202, 0.004744355406853095, 0.008675764953666646, -0.0051996054237513556, 0.007036864520303892, -0.018873364959658658, 0.03033265927991427, -0.007934357703461833, -0.010119557970837991, -0.019822887408016004, -6.259688023389373e-05, 0.04112858931644164, 0.018756301441266356, -0.008662757171705523, 0.0046793197566763825, 0.011166632730307227, 0.005482510944398264, 0.0015836196883343403, -0.0039379125064715696, -0.01215517573058031, 0.002051876788701816, -0.012688468713955136, 0.014476950723629183, -0.008038414371215557, -0.0016275188569774075, -0.007758761028889565, 0.037252458419180776, 0.003557453743390228, -0.003537943001771087, -0.0034989215185328056, -0.023347822162164696, -0.01372253662278579, -0.007791279086808557, -0.016805229141997346, -0.022710473442358693, -0.0238030731103855, -0.004601277255861091, 0.03980186074898514, -0.0037980858353085737, -0.026092329114192837, 0.014268836456799196, -0.008604225412509372, 0.006220666481943432, -0.0008974928921196461, -0.015283394089671982, -0.01624592152602282, 0.028329557715445857, 0.0030550527287739383, 0.007687221953393562, 0.019094487008449772, -0.025389944278548852, -0.005755660861404966, 0.025259872046872883, 0.029266073313164623, -0.019172529974926335, -0.004425680581288822, 0.0015494760069161616, -0.018899378660935818, 0.016402007458975947, -0.010672361230170685, -0.010763411047285829, -0.01212916109798061, -0.016089837455714778, -0.015010243707004009, 0.02718493064486473, -0.0051020521813169226, 0.03602978838212308, -0.013202250490049547, 0.008148975395611113, -0.0014112750756676703, -0.00675070728699734, 0.007986386037338694, 0.01412575830580719, 0.03158134488089421, -0.025220851494957144, -0.009371647295313888, 0.006201155740324291, -0.02606631541291568, -0.014437929240390902, -0.002412825042994652, -0.025285887610795126, 0.009995990095803856, -0.028407600681922423, 0.009254582845599043, 0.0020990277864198457, -0.00585321456950067, 0.036185874315076215, 0.016323964492499385, 0.03210163008230791, -0.00790834307086213, -0.01035368593894514, -0.01303966113177713, 0.01703935804142704, -0.007101900170480606, -0.010672361230170685, -0.025233858345595724, 0.009644796746659318, -0.007609178986916999, -0.0302025870482383, -0.0045004718351057404, 0.0319975715519091, -0.005515029002317256, -0.030800915216128568, 0.009124511545245618, -0.0024664796988626077, 0.013891629406377498, -0.019445679426271765, 0.019471693127548925, -0.008363593087760392, -0.026924786181512794, 0.012636440380078273, -0.003129843982590857, -0.02604030171163852, 0.01056180020577513, -0.00235754476362751]"
3,Dog,"[-0.0009682854718578403, -0.015160790406976526, -0.01842086547054997, -0.029831125864750622, -0.01754093328939263, 0.01278785968646521, -0.00516779572985549, -0.0287492438370336, -0.017800586019125982, -0.021608814258462724, 0.009484509788817914, 0.03499531691063756, 0.0004913553052873288, -0.007194523586824469, -0.004500633966421416, 0.017396682600716376, 0.04705470726652647, 0.0034836639569845325, 0.014237583391745334, -0.010739493946798025, -0.017988111541876087, 0.01141747441875056, 0.019848949896148046, -0.01158336252446374, -0.01469918689936093, 0.006711282196510667, -0.004082306224202233, -0.019747975904190765, -0.004085912305154627, -0.004987481437687612, 0.011193885292508832, -0.005986420343870605, -0.017843860853199833, -0.03098513509945089, -0.0019509960824324979, -0.012823922358634273, -0.006145096753340276, -0.018781492192240602, -0.0028363372686031085, -0.01202332861504241, 0.010400503710821756, 0.006058546153870011, 0.014533297862325191, 0.001824776380594816, -0.005759225136676481, 0.015838769947606503, -0.00019361202127004612, -0.012506569539694931, -0.024421710138230152, -0.005402203564615681, 0.00840983899168312, 0.020036477281543272, -0.007147641740475662, -0.015420442205387318, 0.0039092045596004245, -0.0047170109307583565, 0.004897324757264954, 0.0033141688389963985, 0.0013325194386540687, -0.003086973398971635, 0.021277036184391244, -0.005088457292290014, -0.005676280618158611, 0.022690698148824868, 0.00014932242395556314, -0.002823715286777808, 6.733595986556807e-05, 0.006040514817785479, -0.011107334693038567, 0.011359773398222011, 0.025344917153461342, -0.004143612860021897, 0.0023585054653791782, -0.0013180944163525712, 0.00021705281347721435, -0.012968173047310527, -0.030408130482100754, 0.02245989592935579, 0.0003669387312373341, -0.0003308759426529507, 0.030004227063691147, -0.0344183104306423, -0.004612428995203561, 0.0027407707682599383, 0.03239879706388451, -0.004471783921818422, -0.016588875763897164, -5.1445799830138006e-05, -0.008013148666500864, 0.0034530106390747006, 0.011359773398222011, 0.024998714755580284, -0.011027996255473092, 0.021666515278991275, -0.03516841624693296, 0.007407293538886454, 0.011828589999064954, 0.0261094491562067, -0.013804829463071454, -0.03638012650216178, 0.004067880969070095, 0.008005935573273514, -0.04079420800646781, -0.012420018940224667, -0.011237160126582683, 0.0025081659739759434, 0.016473475585485186, 0.006967327913969065, 0.014107757026878658, -0.01469197380613358, -0.012001691198005484, 0.039871002853881746, 0.026022897625413877, -0.050285930888513075, -0.015651244424856395, 0.010977508328171891, -0.0011585166030601216, -0.009628760477494168, -0.0008835379710714333, -0.002832730954820074, 0.018839193212769154, 0.02934067277819331, 0.046910456577850215, 0.00025852501452848926, 0.006631944224606471, 0.01066015550923255, -0.021623238582272303, 0.00037708138688871315, 0.003159098976140402, 0.01485786284316932, 0.032254546375208255, 0.026599902242764012, 0.002502756619716712, 0.008727190879299903, -0.015434867460519456, 0.02759523460233333, -0.008972418353901118, 0.010854895056532563, 0.00502715065647035, -0.036207023440576136, -0.0023711274472044785, 0.014598211044758528, -0.03770723507315746, -0.0100038133856395, 0.0012919489324638724, 0.03525496591508067, 0.005578911310169884, 0.0065345744509564645, 0.020988534807038738, 0.007129610404391131, 0.001594876147025117, 0.004075093596636164, 0.01382646781143094, -0.02522951697504936, 0.0004940599824169446, 0.02498429043177071, -0.002591110259663173, 0.027422133403392803, -0.007695795847561522, 0.00663915685217254, 0.011107334693038567, 0.021176060329788846, 0.008655065534961776, -0.0017283084764288675, -0.004385233322348157, 0.04076535935884866, 0.015766644603268376, 0.0018662485234384309, -0.00447899654938449, -0.010198552001616953, -0.011100121599811219, 0.02634024951303066, -0.007360412158198928, 0.015838769947606503, -0.021334737204919796, 0.020829857931907787, -0.00994611329643351, 0.0012928504527019709, -0.0374764347163335, -0.010789981874099226, -0.003927235895684956, 0.003736103360659896, 0.0300619280842197, 0.026700878097366414, 0.00617394679794327, 0.004767498858059558, 0.00748663197645193, -0.02971572568633864, 0.013011448812706938, -0.005005513239433424, -0.0004474037780621328, 0.010342803621615767, 0.01924309663117876, -0.020498079857836308, -0.6647090211641357, -0.0030581231215380004, -0.016560025253632888, 0.006887989942064869, 0.017771735508861707, 0.020901983276245914, 0.00895799309876898, 0.014028418589313182, -0.010753919201930162, -0.001622824787805333, -0.0017805994442062654, 0.0074649940937537235, -0.010025450802676425, -0.0014046450158228354, -0.012816710196729484, 0.0008772269801587832, -0.011540087690389889, -0.025662269041078125, 0.010032663895903774, 0.017786159832671285, -0.001257689184355686, 0.0004967647177542203, -0.00813576193814019, -0.004500633966421416, -0.004168856823672497, -0.013761554628997601, 0.00813576193814019, -0.0092392823142167, 0.0016462655945644162, 0.013040299322971214, -0.007158460448994125, 0.008885867754430853, -0.010205765094844303, 0.010804407129231362, 0.04082306037937721, 0.000960171382261333, 0.006087396198473006, 0.037620685405009756, 0.015564692894063571, 0.0404191569609676, -0.023152300725117904, -0.012499357377790142, 0.02114720981952457, 0.006098214906991469, -0.022878223671574972, 0.0025063627006691063, 0.013963506338202404, 0.015362742116181329, 0.013314376376514144, -0.015449292715651593, -0.008561302773586724, -0.004053455713937958, 0.012434444195356805, -0.0018419061964412493, 0.01092702040087069, 0.015434867460519456, 0.02665760326329256, -0.016473475585485186, 0.016040721656811304, -0.002832730954820074, 0.02782603682180241, 0.015506992804857582, -0.01808908739647849, -0.022113693531474733, -0.018218913761345167, 0.0018716579941129826, -0.028431890086771695, 0.010508692658651507, 0.007208948376295325, -0.008041998245442578, 0.011085696344679081, 0.03196604127256551, -0.008092486172743779, -0.015362742116181329, 0.006801439342594605, 0.024133208760877642, 0.002140325693396681, -0.004143612860021897, -0.0072666489311625955, -0.006191978134027802, -0.012369531012923466, -0.020454805023762457, -0.03750528336395265, 0.011900715343403081, -0.003691025020448567, 0.0019221458049988632, -0.012268556089643624, -0.0014993098795125868, 0.013566815081697587, 0.002598322887229242, 0.016199398531942254, 0.04780481308281713, -0.007904959718671114, 0.006260497397413535, 0.013191763104874816, 0.014107757026878658, 0.008914717333372568, 0.006220828644292077, 0.013501902830586809, -0.03404325938514209, -0.011294861147111233, -0.011655488800124427, 0.021709790113065126, 0.0032059805896585683, 0.02191174182226993, 0.012997023557574802, -0.006437205142967737, 0.016747552639028114, 0.01627152387628038, 0.0038370792152622978, 0.004951418765518549, 0.006916839986667864, 0.0017192926919712816, -0.02016630364640995, -0.0060729709433408685, -0.026051748135678152, -0.004634066412240487, 0.0006689644546643101, 0.027465408237466654, -0.017223581401775847, -0.00851802700819031, -0.008756041389564177, 0.01677640314929239, -0.0058962636634479456, 0.006235253433762934, 0.004020999122721289, -0.028778094347297875, -0.020310554335086203, 0.01950274749826699, -0.030465831502629305, -0.001218921718641687, -0.019156545100385933, 0.027638509436407183, -0.02968687517607437, 0.009809074769662045, 0.014064482192804807, 0.030148479615012522, 0.02016630364640995, 0.0026109448690545423, -0.006624731597040402, -0.014497235190156128, 0.0076597331753924585, 0.0037901976017441314, -0.007501056765922787, -0.008453113825756973, -0.003966905114467694, -0.00015630958415061718, -0.022503170763429642, 0.005308440337579348, 0.013415352231116544, -0.001974436889191581, 0.006779801459896399, 0.002118688043529115, 0.00022697008906906877, 0.03213914433415116, -0.028864644015445577, -0.002823715286777808, -0.016430198888766213, -0.0017571586374471823, 0.00803478608353779, 0.021868466988196077, 0.02169536392661043, -0.01628594820008996, -0.008647853373056987, -0.012557057466996133, -0.024017806719820546, 0.006137884125774207, 0.031013985609715165, -0.016083996490885155, -0.028936769359783704, 0.013855317390372655, -0.010097577078337113, -0.028691542816505048, 0.013869742645504791, 0.022373344398562967, 0.01240559461641509, 0.006036908271171805, -0.02655662740869016, -0.010350015783520556, 0.014453959424759714, 0.014843437588037184, -0.0038551105513468294, -0.0032853187943934037, -0.009044543698239245, 0.012124304469644812, 0.016300374386544657, 0.051007188057184585, 0.03427405974196605, -0.035341519308518615, 0.007739071147296653, -0.02949934965332426, 0.003956086405949231, 0.01759863430992118, 0.0045727597764208235, -0.00639032376228021, -0.022661847638560592, 0.00830886313708072, 0.013523540247623735, 0.0187959183786953, 0.021983867166608058, 0.014771312243699057, 0.0049045373848310226, 0.0012432641620541886, -0.02054135655455528, 0.02420533410521577, -0.030408130482100754, -0.0009845137674661748, -0.02520066646478509, 0.02202714200068191, 0.00912388213580472, -0.01261475848752468, -0.011410261325523212, 0.007515482021054925, 0.005012725401338213, 0.017829434666745136, 0.01830546342949287, 0.0033105627580440043, 0.004183281613143354, 0.010494267403519369, 0.0029535411859832046, 0.0007392868749415597, -0.00226834855212588, 0.0041796755321909605, 0.009246495407444048, -0.005878232327363414, 0.019271947141443032, 0.0049117500123970915, 0.024392859627965877, -0.01644462507522091, -0.02036825535561475, -0.019863376082602746, 0.004504240513035091, -0.009426808768289364, 0.008431476408720048, -0.0014993098795125868, 0.006022483016039668, 0.013242251032176017, -0.0260084733016043, 0.0289511955462384, -0.01344420181005826, 0.009109456880672584, 0.024897738900977885, 0.014114970120106008, -0.02228679473041526, 0.017988111541876087, -0.003808228937828663, 0.02038267967942433, -0.014663124227191867, -0.0027299520597414756, -0.014396259335553725, -0.007616457875657326, 0.0008677604937898081, -0.017800586019125982, 0.011958415432609072, 0.011121759016848145, -0.014497235190156128, 0.025590143696739998, -0.004565547148854755, -0.0011567134461686046, 0.01624267336601611, 0.013069148901912929, 0.010292315694314566, 0.0025532443141872726, 0.006458843025665943, 0.029484923466869564, -0.008929142588504706, 0.015218490496182515, -0.03415865770090895, 0.01349468973735946, 0.01152566243525775, -0.011821376905837606, 0.0016516750652389677, 0.00428786401435943, -0.0024342371235003394, 0.017238005725585426, 0.020743308263760085, -0.015867620457870775, 0.010263465184050292, 0.009311408589877387, -0.004908143465783416, -0.03372590563488019, -0.0404191569609676, 0.018709366847902476, 0.015362742116181329, 0.018291039105683294, 0.004616035076155955, -0.0317063922681224, -0.01640135024114706, -0.008193462027346181, 0.019690274883662217, -0.01278785968646521, 0.0186805163376382, -0.0002531156020615977, 0.014547723117457327, 0.004926174801867948, -0.007991510318141378, 0.02749425874773093, -0.01694950434823292, -0.0021763883655657444, 0.0041796755321909605, 0.014381834080421587, -0.004691766967107757, -0.011943991108799495, -0.023642753811675212, -0.004421295994517221, 0.008943567843636844, -0.018752641681976327, -0.034851066221961303, -0.034216358721437495, 0.009859562696963246, -0.009434021861516713, 0.0007703910111781009, -0.016300374386544657, -0.010083151823204975, -0.010328378366483629, 0.01644462507522091, -0.011871864833138807, -0.01141747441875056, 0.023469652612734686, -0.01164106354499229, -0.018868043723033426, -0.013920230572805992, -0.01322061268381653, -0.01011200140214669, 0.11078484182774292, 0.03049468201289358, 0.0025207879558012437, 0.030350431324217327, 0.019978776261014724, -0.017728458812142734, -0.019762400228000344, -0.0020970503936615487, 0.01999320244746942, -0.010494267403519369, 0.007681371058090664, 0.009513359367759629, 0.004922568720915554, -0.014425109845818001, 0.01066015550923255, 0.0068663520593666635, -0.006440811223920131, -0.007681371058090664, 0.01699277918230677, -0.0014848847407957695, -0.004677341711975619, -0.01885361753657873, -0.00013613697742953634, -0.0014506251091029032, 0.0046412790398065555, -0.004078699677588559, 0.0012829331480062865, 0.02075773258756966, 0.0015552071610730191, -0.018392014960285693, -0.007832834374332987, 0.03822654053262416, -0.0006279430719397445, 0.00379740999647956, 0.003361050452514565, 0.008878654661203505, -0.004284257467745756, 0.007147641740475662, 0.04748745933255523, 0.00765252054782639, 0.006985359250053597, 0.023484078799189383, -0.021926166146079507, -0.013985143755239331, 0.016257097689825684, -0.019762400228000344, 0.002107869102180012, 0.02786931165587626, 0.00047693019567434145, -0.006289347907677809, 0.041226963797786814, 0.024003382396010967, -0.009008481026070181, -0.01983452557233847, 0.0025622599822295385, 0.000699617830781802, 0.021450137383331774, 0.008878654661203505, 0.004680948258589293, -0.018723793034357172, -0.03447601145117085, -0.023801430686806162, -0.005528423382868683, -0.006127065417255744, -0.0034764513294184636, -0.04226557099142998, -0.023238852255910727, -0.011929565853667357, -0.021955016656343782, -0.004706192222239894, -0.02349850312299896, -0.024537112179287248, -0.011222734871450547, 0.024335160470082447, 0.02130588669465552, 0.003204177549182371, 0.03288925015044182, -0.005366140892446618, 0.0010800800349787048, 0.008619002862792713, -0.004900930838217348, -0.01240559461641509, 0.013869742645504791, -0.0012126107277290368, -0.005596942646254416, 0.020815433608098212, 0.0036441434069304007, 0.00944844711664885, -0.0034277666754241004, 0.006642762933124934, 0.02371488101865846, 0.0019762399296677784, 0.019848949896148046, 0.0019311615894564492, -0.005362534345832943, 0.0010656550126772076, 0.019546024194985964, 0.011345349074412434, -0.016213822855751833, 0.010061513474845489, 0.026152723990280555, -0.017295706746113974, -0.03202374229309406, -0.002598322887229242, -0.015348316861049191, 0.009152731714746435, 0.00046611134163672847, -7.33933791118645e-06, -0.00113417427606294, -0.011792527326895891, 0.011453537090919624, -0.014064482192804807, 0.018507415138697674, -0.013530752409528524, 0.01179973948880068, 0.012355106689113889, -0.02196944098015336, 0.006725707451642804, 0.00851802700819031, -0.0371590809660716, -0.02551801835240187, -0.0261094491562067, 0.036812878568190543, 0.032312243670446564, -0.013638941357358275, -0.0071512482870893365, -0.00486126208509589, 0.009412384444479787, 0.0018734611510044996, 0.011605000872823226, 0.005723161998846138, 0.02469578719177308, 0.00284174662286234, -0.024912165087432582, -0.018218913761345167, -0.009571060388288179, 0.003478254602725301, 0.008402625898455772, -0.009549422971251253, -0.012232492486152002, -0.026354675699485356, 0.0033700661205568307, 0.003956086405949231, -0.022921498505648827, -0.008373776319514057, -0.049853178822484315, -0.026758579117894962, -0.00453669710425176, 0.011763676816631617, 0.012903260796199748, -0.00017558062697785442, -0.01082604454626829, -0.011482387601183898, 0.01459099795153118, -0.01169155147229349, -0.015506992804857582, -0.004724223558324425, 0.004792742821710158, 0.006249678688895071, 0.04255407236878249, 0.02528721613293279, -0.005037969364988813, 0.008619002862792713, 0.01644462507522091, -0.006253284769847466, 0.009383533934215513, -0.007883322301634188, 0.01503096404210985, -0.021767491133593678, 0.0015092270677929513, 0.001857232855396165, -0.015319466350784917, 0.029975378416071993, 0.007129610404391131, -0.04125581244540597, -0.0038442916099977265, 0.01360287868518921, -0.01891131855710728, -0.012492145215885354, -0.008193462027346181, 0.003543167552327999, -0.0019185396076311489, 0.018435289794359547, 0.02404665723008482, -0.0024648906742408116, -0.0027065111365670723, 0.006729313532595199, 0.014612636299890666, -0.010039876057808563, -0.006127065417255744, 0.015752220279458797, -0.0047025856756262195, 0.004987481437687612, -0.010667368602459898, -0.014497235190156128, -0.006848320723282132, -0.012535420049959205, 0.005701524581809211, 0.004183281613143354, -0.0015804510083082994, 0.021248185674126972, 0.029254123110045608, 0.006668006896775535, 0.020786583097833936, -0.008236737792742593, -0.00813576193814019, -0.014273646063914397, -0.02067118291942196, 0.023080175380779777, -0.028705967140314627, -0.023411953454851257, -0.03337970323699913, -0.031504440558917594, -0.03349510527805623, 0.004114762349757622, 0.013509114992491598, 0.006303772697148666, 0.007472206721319792, 0.007854471791369912, 0.0018148590758991316, -0.0006292954105045523, 0.0011918747145148894, 0.00988841227590496, -0.013256675355985594, 0.020195154156674226, 0.036870579588719095, -0.012203642907210287, -0.01474967482666213, 0.03037927997183648, 0.012816710196729484, -0.01098472049007668, 0.0037397096744429307, 0.0025694726097956074, 0.009953325458338299, -0.004551121893722617, 0.020959684296774465, 0.0014343968134945687, -0.007400081376981666, -0.04119811142487742, 0.03136018987024134, 0.010963083073039753, -0.013198975266779605, -0.0008032983043061592, -0.014273646063914397, -0.035601172038251964, 0.022387770585017664, -0.021507838403860325, -0.014078906516614384, -0.04515059221553554, -0.002583897864927745, -0.02365717999812991, -0.009744161587228706, -0.01912769459012166, 0.04064995731779156, -0.00024725540037182694, -0.00248472505080154, 0.00994611329643351, 0.007140429112909593, -0.007064697221957792, -0.019488323174457412, -0.00978022425939777, 0.03412980905328979, -0.0289511955462384, 0.0038154415653947316, 0.010595243258121771, -0.0077967717021639234, -0.01125879847494217, 0.014389047173648938, -0.021637664768727, 0.027725060967200007, -0.022041568187136606, -0.008878654661203505, -0.0021168847702222778, -0.009138306459614297, 0.019170971286840633, -0.0034728450156354296, -0.007782346447031786, -0.012477719960753217, -0.007602032620525188, -0.03164869124759385, 0.011064058927642156, -0.001155811925930506, 0.0012441656822922873, 0.0014767705929916023, -0.026311399002766384, -0.00263799187318134, -0.029571474997662387, -0.015925321478399326, 0.004424902541130895, 0.007158460448994125, -0.0033033501304779354, -0.009758586842360844, 0.00813576193814019, -0.0006631042820783693, 0.0025207879558012437, -0.0039632990335153, 0.002798471323127208, 0.014179882371216784, -0.03649552854321888, 0.013249463194080805, -0.0017355209875796161, 0.013775979884129739, -0.03363935596673248, 0.0035269392567196644, 0.012838347613766411, -0.0022881829286866087, 0.0014001371818017025, 0.008921930426599917, -0.005795287808845544, 0.013516328085718947, -0.009859562696963246, 0.015204065241050377, 0.008871442499298717, -0.007876110139729399, 0.008027573921633, -0.0005350814233491702, 0.014958838697771723, -0.028489591107300247, -0.034447162803551694, 0.0317929419362701, -0.0038623231789128984, 0.013920230572805992, -0.0108188323843635, -0.02328212708998458, -0.018824768888959575, -0.006159522008472413, 0.023310977600248854, 0.01808908739647849, -0.007551544693223988, -0.017425533110980652, -0.004417689913564827, 0.010573604909762285, -0.01758420812346648, -0.03505301793116611, -0.02683070446223309, -0.01666100110823529, -0.010371654131880043, 0.028287639398095442, 0.017454381758599806, 0.0008204281201525923, 0.023570628467337085, 0.023844705520880017, 0.00519303922784481, -0.0014506251091029032, -0.034677963160375656, -0.03632242548163323, -0.01513193989671225, -0.012326256178849615, -0.009989388130507362, 0.0006563424728390099, -0.015348316861049191, 0.025763244895680524, 0.011172246944149346, -0.018839193212769154, -0.001579549488070201, -0.010955870911134966, -0.012932110375141463, 0.009527784622891767, 0.003700040688490833, 0.02059905571243871, 0.012766222269428284, -0.0040426370054194955, -0.010176914584580027, 0.01797368721806651, -0.0092392823142167, 0.028561716451638373, -0.020079752115617126, -0.014742461733434782, 0.0032059805896585683, -0.02375815585273231, -0.0028471559771215712, -0.017396682600716376, 0.006491299151221332, -0.028691542816505048, 0.0018626423260707167, 0.007035847177354797, 0.008395413736550984, 0.027422133403392803, 0.010184127677807376, -0.018969019577635828, -0.01677640314929239, 0.010559180585952708, 0.00016047934808246313, 0.004533090557638085, 0.01987780040641232, -0.005283196373928748, -0.0157377940930041, 0.004890112129698885, -0.02289264799538455, -0.01793041052134754, -0.0015227506862716701, -0.000533278266457653, -0.0037685599518765653, 0.017439957434790227, -0.009859562696963246, -0.01732455725637825, -0.023570628467337085, -0.029658024665810093, -0.012607545394297332, 0.00734598690306679, -0.014266432970687049, 0.025806521592399496, -0.006375898507148073, -0.015160790406976526, -0.020123026949690977, 0.0001924850627647629, -0.008950780936864192, -0.007623670503223395, 0.003460223266640769, -0.004684554339541688, 0.00266323583683194, -0.007472206721319792, 0.0024017807651143105, -0.030898585431303187, 0.012001691198005484, 0.002789455655084942, -0.0025929135329700106, 0.020901983276245914, 0.011193885292508832, 0.017468807945054503, -0.037447586068714345, -0.01136698649144936, -0.012506569539694931, -0.018492990814888095, 0.0002592011838108932, -0.021046233964922167, -0.011835802160969744, -0.02381585501061574, -0.013913018410901205, 0.0128960477029724, -0.011662700962029215, 0.00094935249911989, -0.012427232033452015, -0.002214254311041645, -0.01371827886360119, -0.004515059221553553, 0.20172072630875731, 0.00857572802871886, 0.014554935279362117, 0.04290027476666355, -0.0022863798882104117, -0.012881622447840262, 0.026845128786042668, 0.024248608939289623, 0.0072810741862947325, 0.029196422089517057, 0.0019041144689143316, -0.008994055770938043, -0.010912595145738552, 0.006981753169101202, -0.005777256472761012, -1.9693655904697217e-05, -0.03245649808441306, 0.0039885429971659005, -0.021406862549257923, -3.924644199623403e-05, 0.00858294019062365, 0.004197706868275492, -0.025662269041078125, -0.006545393625136207, 0.024248608939289623, 0.006877170767885126, -0.03952480045600069, 0.008640640279829638, 0.015175215662108664, -0.00770300847512759, -0.017021629692571046, -0.007400081376981666, -0.008496389591153385, -0.014526085700420402, -0.0005571698333357855, -0.0018932956439805485, -0.00737844349428346, 0.0004954123791894125, 0.01911327026631208, 0.011879077926366156, -0.007890535394861536, -0.005571698682603815, -0.003321381466562467, -0.018406439284095272, 0.0016471672312178348, 0.025215090788594664, -0.002342277169770844, -0.007746283774862722, 0.014114970120106008, 0.01524734100644679, -0.03459141349222795, 0.011554512945522025, 0.010371654131880043, 0.024609237523625375, 0.00461964115710835, 0.009441234023421502, 0.029470499143059988, 0.005239921074193616, 0.006924052614233933, 0.01895459339118113, -0.005315652965145417, 0.0024125994736327733, -0.02420533410521577, 0.03632242548163323, -0.015708943582739825, -0.00407148705002249, -0.014742461733434782, 0.004219344750973698, 0.007840047467560335, -0.00527598374636268, -0.009758586842360844, -0.008085274010838991, -0.006808651504499394, -0.014569360534494254, -0.009203219642047636, -0.02791258648995011, 0.02430630995981817, 0.029441648632795712, 0.02228679473041526, 0.04370808160348276, -0.011727614144462554, -0.012751797014296146, -0.015362742116181329, -0.0002607789315390557, -0.011381411746581497, -0.02667202758710214, 0.024926589411242157, 0.009109456880672584, 0.00035409136935250925, 0.008337713647344994, -0.01562239391459212, -0.010155277167543102, -0.009159944807973783, -0.013249463194080805, 0.011467962346051762, 0.011352561236317222, -0.006970933994921459, 0.024075507740349094, 0.005813319144930076, 0.009419596606384577, -0.0024468591053256397, 0.008669490790093914, 0.017468807945054503, -0.0035702145564547967, -0.00869112820713084, 0.0032492558893937006, -0.006289347907677809, 0.018117937906742765, 0.0029102658862480723, 0.011561725107426814, -0.01393465582793813, -0.005160583102289421, -0.011027996255473092, 0.00030833671433962606, 0.02394568137548242, 0.015175215662108664, 0.006859139431800595, -0.010732281784893235, -0.0031446739538389043, 0.006657188188257072, 0.010371654131880043, -0.027609658926142908, -0.012145941886681737, -0.008727190879299903, -0.02202714200068191, -0.006054939607256337, -0.007904959718671114, 0.019574872842605118, -0.010256253022145502, -0.04290027476666355, 0.001536274188335069, -0.007493844604017998, 0.013545177664660662, -0.013119636829214128, -0.007558757320790057, 0.005748405962496738, 0.005185827065940021, -0.018016962052140362, -0.011179460037376694, -0.004951418765518549, -0.007349593449680465, 0.006787014087462468, 0.003234830867092203, -0.004046243086371889, 0.013876955738732141, -0.05406531234287579, 0.013393713882757058, 0.004410477285998758, -0.015175215662108664, -0.020151877459955253, -0.013191763104874816, 0.001199087225665638, -0.019055569245783534, -0.0005017233701020625, 0.023700454832203764, -0.011150609527112419, -0.018161212740816616, -0.010479842148387233, -0.002928297222332604, -0.005993632971436673, -0.01836316445002142, 0.0018842799759382827, 0.004533090557638085, -0.01928637146525261, -0.010306740949446704, -0.004298682722877894, -0.1893728345755159, 0.02785488733206668, 0.025142965444256538, -0.03381245530302789, 0.023195575559191755, 0.016848528493630516, 0.02146456356978647, -0.008813741478770168, -0.005333684301229949, -0.005340896928796018, 0.0100038133856395, -0.012282980413453203, -0.027364432382864252, -0.0300619280842197, -0.012376744106150814, 0.003189752294050234, 0.006765376204764262, -0.015579118149195709, 0.0037577410105274624, 0.006083790117520612, 0.04036145594043905, -0.023484078799189383, 0.015074239807506261, -0.014785737498831194, -0.009787436421302559, 0.004334745395046957, -0.008820954571997516, -0.015016538786977712, -0.021060660151376864, -0.017137029870983023, -0.019690274883662217, -0.030408130482100754, 0.023585054653791782, 0.010530330075688432, -0.005690705873290749, 0.006588668924871339, 0.02857614263809307, -0.014453959424759714, -0.016632150597971015, 0.02934067277819331, -0.01814678841700704, 0.050257082240893924, 0.030581231681041283, 0.002037546798318082, -0.008114124521103265, 0.011893503181498294, -0.012722946504031872, 0.010999145745208817, 0.01852184132515237, -0.012052179125306685, 0.00535892826488055, -0.001007954574225258, 0.015391591695123044, 0.029282971757664762, 0.03666862787951429, 0.02365717999812991, 0.0115328755284851, 0.013711066701696402, -0.007400081376981666, -0.023022474360251226, -0.017843860853199833, -0.02916757157925278, -0.006191978134027802, -0.02394568137548242, -0.007537119903753131, -0.030090778594483975, -0.043592679562425664, 0.014706399061265718, -0.028893494525709853, -0.01295374872350095, -0.011987265942873346, -0.003330397134604733, 0.029629174155545817, -0.015204065241050377, -0.016963928672042494, 0.010645731185422972, -0.011150609527112419, 0.012124304469644812, -0.007522694648620994, 0.0012378546913796372, -0.014179882371216784, 0.04558334800685454, -0.019805675062074195, -0.02743655772720238, 0.0036621747430149324, 0.01130928547092081, 0.006693250860426135, 0.020397104003233905, 0.0008700144108003745, 0.003647749487882795, 0.015362742116181329, -0.019935501426940873, 0.0029661631678085045, -0.019055569245783534, 0.004789136275096483, 0.017122605547173448, 0.019300795789062186, 0.01546371703946117, -0.00038091305162744215, -0.0007758004236449925, 0.01043656638299082, 0.0034764513294184636, -0.028720393326769324, 0.02430630995981817, 0.027768335801273858, -0.004583578484939286, 0.022979199526177375, 0.009152731714746435, 0.007006997132751803, -0.01027789043918243, -0.019084419756047806, 0.02113278549571499, 0.021204910840053118, 0.001564222829115285, 0.003541364511851802, 0.008438689501947396, -0.00901569318797497, 0.002014105875143679, -0.004684554339541688, -0.008013148666500864, 0.060066155147910846, 0.015492567549725444, -0.0004688160478701742, 0.011251585381714821, -0.026599902242764012, -0.019935501426940873, -0.14228927866137028, -0.014367408825289451, -0.008727190879299903, 0.030783183390246088, -0.002511772287758978, 0.015478142294593307, 0.01213151756287216, 0.014071694354709594, -0.001316291259461054, 0.014511660445288264, -0.024392859627965877, -0.008813741478770168, -0.017079328850454475, 0.0027299520597414756, -0.002776833673259642, -0.004839624202397684, -0.014151032792275071, -0.007039453258307192, -0.0259074974470019, 0.008820954571997516, 0.014410684590685863, 0.004067880969070095, 0.005759225136676481, -0.013509114992491598, -0.008885867754430853, -0.03300465219149892, -0.032341096043355964, 0.025590143696739998, 0.028893494525709853, 0.007998723411368727, 0.02968687517607437, -0.01759863430992118, 0.03638012650216178, -0.008380988481418846, -0.013725491956828538, 0.013977931593334542, -0.009138306459614297, -0.024464984972304003, 0.031100537140507988, -0.010090363985109763, 0.02644122536763306, 0.01552141805998972, 0.009412384444479787, -0.023152300725117904, 0.014295283480951325, -0.01355239075788801, 0.017353405903997404, 0.03583197239507592, 0.022661847638560592, -0.020901983276245914, -0.034504863824080245, -0.013761554628997601, -0.021796339781212832, -0.020829857931907787, 0.04699700624599792, -0.007479419348885861, 0.00851802700819031, 0.04093846242043431, -0.004219344750973698, 0.013415352231116544, 0.0007113382341613436, -0.007847259629465125, 0.005113701255940614, 0.03086973492103891, 0.006321804033233198, 0.010537542237593222, -0.029802277217131468, -0.023642753811675212, 0.0005504080823040861, -0.009434021861516713, -0.0016913440511910655, 0.006631944224606471, -0.001564222829115285, 0.022171392689358162, -0.016646576784425715, -0.007955447645972315, -0.019603723352869393, -0.02332540192405843, 0.0214212868730675, -0.024767912536111207, -0.011114546854943355, -0.01808908739647849, 0.007565969948356125, -0.0032366339075684003, 0.04059226002255325, 0.014843437588037184, -0.0023512928378131097, 0.028431890086771695, -0.0027371644544769043, -0.03998640489493884, -0.0008677604937898081, 0.014179882371216784, 0.008114124521103265, -0.03124478782918424, -0.004266226131661224, 0.0034439949710324347, 0.0031987679620924998, -0.010963083073039753, -0.005344503009748412, 0.009419596606384577, -0.008186249865441392, -0.018550689972771525, -0.08816627274854642, 0.00835213797115457, -0.01497326395290386, -0.009643185732626305, 0.019098845942502506, 0.0034331760296833318, -0.007912172811898462, -0.014057269099577458, -0.01410054486497387, 0.006383111134714142, -0.016257097689825684, 0.007630883130789463, -0.01109290943790643, -0.0016886393740614498, -0.004327532767480888, -0.016588875763897164, 0.027191331183923723, 4.43741150641784e-07, 0.0008808332357341576, 0.00962154831558938, -0.009599909967229894, -0.00015923968499550258, 0.00103860789213509, 0.005366140892446618, -0.0029228878680733726, -0.004987481437687612, -0.022113693531474733, 0.01552141805998972, -0.001963617947842478, 0.006000845599002742, -0.008171824610309254, -0.025936346094621053, 0.007753496402428791, 0.04878571925593175, -0.015824345623796924, -0.0144755977731192, -0.007897747556766324, -0.00048459352515179945, -0.008056423500574715, 0.005935932416569404, -0.0038695355736483267, -0.0401018032107057, 0.013162912594610542, -0.022820522651046424, 0.0014226764683226872, -0.014114970120106008, -0.023686030508394185, -0.00691323390571547, 0.0077967717021639234, -0.008366563226286709, 0.026181574500544827, 0.00776070902999486, -0.00994611329643351, -0.0033051531709541327, -0.017310131069923552, -0.020743308263760085, 0.0045186657681672284, -0.009498935043950052, -8.247950843605648e-06, -0.013574028174924936, -0.003151886348574333, 0.01852184132515237, 0.024277459449553895, 0.004111156268805228, 0.020570207064819556, 0.006545393625136207, 0.002246710902258314, -0.012376744106150814, 0.0017941229462696642, -0.011662700962029215, -0.02486888839071361, 0.0029138722000311068, 0.02846074059703597, 0.0018716579941129826, -9.725679258194486e-05, 0.012362318851018678, -0.010833257639495638, -0.009852349603735896, -0.014352983570157313, 0.03208144331362261, 0.0014812784270127352, 0.003519726629153596, -0.024349584793892026, 0.002549638000404238, 0.015535843315121856, -0.020685607243231534, -0.010198552001616953, 0.009773012097492982, 0.010782769712194436, 0.0061487028342926695, -0.027364432382864252, -0.016675427294689987, 0.0014929988885999368, -0.007537119903753131, 0.0006207305025813358, 0.009196007480142846, -0.0053733535200126865, -0.01791598619753796, 0.02279167400342727, 0.030465831502629305, 0.01431692089798825, -0.010862107218437353, -0.0003137461268065176, 0.004814380238747084, -8.20991613957149e-05, 0.00961433522236203, -0.02498429043177071, -0.005871019699797346, -0.008359351064381921, 0.0072666489311625955, 0.025503594028592293, -0.00759481999295912, 0.0062100094701123335, 0.021796339781212832, -0.019546024194985964, 0.020570207064819556, -0.009643185732626305, -0.021998291490417633, -0.010126426657278826, 0.01749765845531878, 0.028504017293754944, 0.02546031919451844, 0.016055147843266, 0.01627152387628038, 0.014569360534494254, 0.004002967786636757, 0.018291039105683294, -0.01912769459012166, 0.005178614438373952, 0.007746283774862722, -0.00551760420868894, -0.01552141805998972, -0.04512174356791638, 0.001896901957763583, 0.0019383741006071978, 0.006289347907677809, 0.014569360534494254, 0.024724637702037356, -0.033437404257527684, 0.034216358721437495, 0.008388201574646195, 0.004500633966421416, -0.013263888449212943, -0.00999660122373471, 0.012427232033452015, 0.01648789990929476, 0.01738225641426168, -0.029037745214386106, -0.0003824907993556047, 0.011302073309016022, -0.02022400280429338, -0.005953963752653935, -0.015607968659459983, -0.026527776898425885, -0.00913109429770951, -0.032600748773089314, 0.005676280618158611, -0.004543909731817828, 0.003043698099236503, 0.023123450214853628, 0.017425533110980652, 0.012117092307740022, -0.0026866767600063433, -0.013833679973335728, -0.02398895807220139, 0.02988882688527917, -0.015434867460519456, -0.008698341300358188, -0.001670608037976918, 0.007565969948356125, 0.007360412158198928, -0.04064995731779156, 0.002930100495639441, 0.007248617595078064, -0.02616714831409013, -0.0018058434078568658, -0.026542201222235464, -0.006058546153870011, -0.00023328106542980386, -0.004612428995203561, 0.014829012332905046, -0.027465408237466654, 0.0018310873715074662, 0.0035179235886773986, 0.024840037880449334, 0.000228097047574352, -0.005477935455567483, -0.013501902830586809]"
4,Cricket,"[0.003916181735831925, -0.007183414623500497, 0.0008264460720635923, -0.002366093287795093, -0.022950944215180624, 0.007588204213236048, -0.01761799914810492, -0.02630491816162088, -0.0030889325726477634, -0.038782728081425834, 0.026728984732217905, 0.005101638060544819, 0.009053157901157662, -0.0051369766309870375, -0.007511101412064452, 0.011289140532117832, 0.02148599052725901, -0.027628517567773618, 0.021177579322572627, -0.02176870095344196, -0.012195099493622004, 0.020894868896389678, 0.012632015522148146, 0.007646031430530069, -0.008943929592518078, 0.009258765991830318, -0.0129597023107121, -0.025122674899882215, 0.005005259209834349, 0.0029042068301704466, 0.02550818844007889, 0.0023114789006446505, -0.0025459999014723657, -0.025713796530751547, -0.02888786316502258, -0.014276875590916381, -0.017425241446683983, 0.008976055565647368, 0.00575701210333403, 0.005773075089898675, 0.02711449827241458, 0.007941592711626037, -0.015741829278837997, -0.00905958402710612, -0.012162972589170113, 0.033976652698960885, 0.03017291140342017, -0.004918518616723966, -0.015985988537265797, 0.009162387141119848, 0.004831778023613584, 0.02448015171200602, -0.025148375678385647, 0.0006975397317673795, 0.0027098435285849935, -0.017425241446683983, 0.013454445090870962, 0.006797900151981219, 0.01925000789629884, -0.0024817477223831362, -0.010145448438134315, 0.01576753005734143, -0.008481311854165903, 0.013441594701619246, 0.00638668536761981, 0.00594334367880651, -0.00305198747071843, -0.009335868327340612, 0.0025845513020581632, -0.0010617703968425277, 0.030018704869754376, 0.02878506005100885, -0.0004268766619232381, 0.012972552699963816, 0.01837617583924656, -0.013011103867718964, -0.0145338852385959, -0.010717294485126073, 0.005969044922971243, -0.006765774178851929, 0.026369170107879456, -0.006630844160386312, -0.016165895849435022, -0.017168231799004462, 0.012535636671437676, -0.009335868327340612, -0.011051406468315888, 0.02491706680920956, 0.02865655429584649, 0.005448600432986348, 0.003347548286153096, 0.011591126542178356, 0.001355724913620729, 0.0174380918359357, -0.021935757876359468, 0.0015613325386320837, -0.019892532946820238, 0.038808428859929266, 0.004317759193915848, -0.048446284128653004, 0.0005766650011688143, 0.018915895913109028, -0.03117524735298961, -0.012471383793856495, 0.0050373856486249395, 0.012040892959956213, -0.011244164169736826, -0.001893838455996083, 0.0199439345038271, -0.02126753390997984, -0.008513438758617795, 0.00456191798668235, 0.036572446228969095, -0.049808432839915685, 0.004382011140174427, -0.006216416313050674, 0.029273378567864456, -0.02152454169501416, -0.025225478013895943, -0.011983066208323491, 0.009830612038822075, 0.0028271040289988515, 0.022102812936631775, -0.010010518419668699, 0.013248837931520908, 0.0005216489229389305, -0.02372197315821918, -0.004365948153609782, 0.005339371658685463, 0.006181077742608456, 0.029941602534244084, 0.004944219395227398, -0.0033925248813647516, 0.01450818446009247, -0.017065428684990735, 0.01299182828384139, -0.025585292638234388, 0.005686334496788293, -0.00500204661252142, -0.04047899063852353, -0.007189839818126355, 0.02809113344348059, -0.012471383793856495, -0.020650709637961874, -0.006778624568103645, 0.019558420963630425, 0.02352921545679824, -0.008455611075662473, -0.008757597085722995, -0.008327106251822713, 0.031509359336179425, -0.013171734664688012, 0.05268693865875205, 0.006849302174649383, 0.0009629823309780114, 0.0016127343284695972, -0.00250102330626071, 0.01916005517153683, 0.012612739006947971, -0.009669981241853027, -0.009817761649570359, -0.0038455041292861877, 0.023554918097946874, -0.021036225040803755, -0.013248837931520908, 0.00956075200189084, 0.010473135226698271, 0.015883185423252073, -0.010119747659630883, -0.026574778198552113, 0.018324774282239695, 0.020933420064144826, -0.022860991490418613, 0.028810760829512283, 0.002313085199301115, -0.0038294409098908926, -0.01466239006243566, 0.0006256574012292937, -0.01472664200869424, -0.016153045460183306, -0.028271040755649814, 0.008982480760273226, 0.03682945773929382, 0.010749420458255363, -0.027577116010766754, 0.010209701315715495, 0.0002541984213038867, 0.006467000766104335, 0.021935757876359468, -0.0060557855160816255, 0.020702113057613943, 0.02280958993341175, -0.004285632755125258, -0.00139186686622183, -0.6752152635859947, -0.030789733812792933, -0.013865660340893673, -0.01544626846340333, 0.02350351467829481, 0.007170564234248781, 0.024158890118067922, 0.013621502013788471, -0.00039173864598242736, -0.013492997189948711, -0.015754679668089713, -0.010087621686501593, -0.015651876554075985, -0.006248542751841264, 0.0064188113407491, -0.011706780976766399, 0.019237157507047124, -0.002671292127999196, -0.009297317159585464, 0.005410049265231201, -0.013929913218474853, 0.013480146800696997, 0.00226489600677653, -0.007389022248511852, -0.012953277116086242, -0.006495914141920695, 0.010441009253568981, -0.02888786316502258, -0.002121934495028591, 0.028039731886473726, -0.03587852148408604, 0.0042342307324570935, -0.008301405473319281, -0.010286803651225791, 0.049422921162364214, -0.002181367778148427, -0.023297908450267354, 0.017630849537356635, 0.007858064250167282, 0.04492525512194044, 0.008462036270288329, -0.00736332100434712, -0.003941882514335357, -0.016500007832624834, -0.03004440564825781, 0.020509355356193002, 0.009817761649570359, -0.020522205745444718, 0.016692765534045775, -0.01985398177906509, -0.020907719285641394, 0.002595795625484065, -0.016808419037311218, 0.004510515964014186, 0.012323603386139163, 0.007132012600832333, 0.027705619903283914, -0.0069778069984891425, -0.005695972288727079, 0.014109819599321475, -0.020612158470206726, 0.028990668141681507, -0.010299654040477505, -0.050193948242757566, -0.0038840555298719857, 0.010608065245163887, -0.008327106251822713, 0.01796496152054645, 0.032871511772732516, -0.016371502077462477, -0.00471933618633847, 0.011719631366018115, -0.014983651656373758, -0.009387270815670076, 0.013030379451596538, 0.024685759802678675, 0.024595805215271462, -0.030481322608106553, 0.003174066867101681, 0.002194218400230793, -0.008082947924717511, -0.018286223114484548, -0.01503505321338062, -0.009644280463349595, 0.026227815826110584, -0.03554440763825102, -0.0208306169501311, 0.005422899654482916, 0.009894863985080654, -0.014174071545580055, 0.032845810994229084, 0.02283529071191518, 0.012632015522148146, 0.02315655230585328, 0.005194803848281059, 0.007646031430530069, -0.01801636307755331, -0.008629093193205838, 0.02863085351734306, -0.03523599829620984, 0.0027291193452932175, 0.0013107483184090734, -0.0016801993377024058, -0.009451522761928656, -0.003071263054596004, 0.008320681057196855, -0.008571265510250515, 0.011655379419759535, 0.035107494403692686, -0.025212627624644227, 0.01119918780735582, -0.017720802262118647, -0.018838793577598732, -0.012111571032163251, 0.02932478012487132, -0.02847664884632247, 0.0016135375942131548, -0.0014545129794852453, 0.013968464386230001, -0.02819393842013952, 0.001673774143076548, 0.009580027585768414, 0.024428750154999155, 0.012220800272125435, -0.010742995263629505, 0.003797314936761603, -0.029993004091250948, -0.004269569768560613, 0.0018022788505009822, -0.015356315738641319, -0.004828565426300655, -0.00110915644003888, 0.008551989926372941, -0.005503215052967441, 0.044848152786430145, 0.017258186386411675, 0.011089958567393636, -0.0018424365497432442, -7.584790945006386e-05, -0.0024174953104632566, -0.027448610255604394, -0.012766945540613762, 0.01063376695498992, 0.022860991490418613, 0.024750011748937255, -0.031252351551145106, -0.03353973573911214, -0.013390193144612384, -0.008108648703220943, 0.01818342000047082, 0.012323603386139163, -0.013300239488527772, 0.013068931550674286, 0.013480146800696997, 0.013724305127802197, -0.00927804157570789, -0.0188130927990953, -0.009926990889532545, -0.00918808791962328, -0.02161449628242137, 0.007691008258572375, 0.03289721255123595, -0.02865655429584649, -0.02845094806781904, 0.00947079834580623, -0.0012922756510290816, -0.024056085141408994, 0.01918575595004026, 0.012201524688247862, -0.017862158406532724, 0.00984346242807379, 0.005641357668745987, -0.018774541631340153, 0.03215188252405562, 0.0004108135589432682, 0.014765194107771988, -0.030815434591296365, -0.024750011748937255, -0.014289725980168097, 0.007176989428874639, 0.004790013792884207, -0.005480726871776938, -0.02325935728251221, -0.019712625634651013, -0.003977221550438876, 0.010492411741898446, 0.012561337449941107, 0.0398878690076542, -0.006569804345779362, 0.006688671377680334, 0.003312209482880227, 0.012394281458346201, -0.026446274306034953, -0.003196555281122834, 0.007164138573961623, -0.01249066030905667, 0.002780521135130731, 0.00014727846849101913, 0.011655379419759535, 0.010967878938179734, 0.02852805040332933, -0.0007091855134420722, 0.028399546510812175, 0.0028014032504954196, 0.01614019507093159, -0.018453280037402056, 0.002599008222796994, -0.017836457628029292, 0.03891123197394299, -0.0024817477223831362, 0.010139023243508457, -0.014803745275527134, -0.012105145837537393, 0.024300244399836794, -0.003639896504274833, 0.03207478018854532, 0.005580317854139036, 0.00647985115535605, -0.000346159630566935, 0.0021540604681578803, 2.795981788803033e-05, -0.01082652372508826, 0.011000004911309024, 0.005252631065575081, -0.0041988921620148755, 0.03089253692680666, -0.0059883205068488165, 0.028322442312656678, 0.024595805215271462, -0.02041940263143099, -0.015176408426472096, -0.0011228100950341532, -0.007851639055541424, -0.009817761649570359, 0.007138437795458191, 0.016345801298959045, 0.026883189403238493, -0.025842302285913908, 0.030918237705310093, 0.007183414623500497, 0.012375005874468627, 0.010126172854256741, 0.015549072508739657, -0.007601055068149064, 0.0051401892282999665, -0.02463435638302661, 0.013004678673093106, 0.006752923789600213, -0.008635518387831696, 0.010222551704967211, -0.005188378653655201, 0.004015772718194023, -0.030018704869754376, 0.002687355114563841, 0.024223142064326502, -0.02356776848719859, 0.001673774143076548, 0.0009003362759222588, 0.015818931614348292, 0.01733528872192197, 0.004700060602460896, 0.018144868832715672, 0.006875002953152814, -0.012657716300651578, -0.007061334994286596, -0.004651871177105661, 0.013094632329177718, -0.012310752996887447, -0.01935281287295777, -0.019262860148195757, -0.01922430711779541, -0.020021036839337397, 0.003980434147751805, -0.017065428684990735, 0.009496500055632262, -0.008950354787143936, -0.001903476364350195, 0.030841135369799797, -0.005747374311395243, 0.009066009221731978, -0.008571265510250515, -0.008076522730091653, 0.00780023703287326, -0.0037330625248417236, 0.0015862302842226082, -0.0245444036582646, 0.00034876986588368975, -0.017656550315860067, -0.010704444095874358, 0.023837628524129826, -0.006727222545435481, 0.010922902575798728, -0.015266362082556708, -0.008539139537121225, -0.018324774282239695, 0.014032716332488579, 0.02280958993341175, -0.026626179755558976, -0.004378798542861498, 0.01811916805421224, 0.0023982194937550326, 0.005792350673776249, 0.004414137578965017, -0.014765194107771988, 0.026022207735437928, -0.008699770334090275, -0.007780961448995686, -0.03312851955776683, 0.01066589292811921, -0.011783884243599295, -0.004275994963186471, -0.001893838455996083, -0.019494167154726644, -0.009477223540432088, -0.008230728332434845, 0.014366829247000994, -0.004934581603288611, 0.004748250027816131, 0.027500011812611257, -0.008217877943183129, -0.030121509846413305, -0.007999419463258757, -0.00887325152031104, -0.022167066745535556, 0.08979910868687402, 0.02523832840314766, -0.00909171000023541, 0.011038556079064172, -0.005291182233330228, -0.012754094220039446, -0.021408888191748715, -0.02173014978568681, -0.0041153641662174225, -0.0014183710268841443, 0.013300239488527772, 0.021408888191748715, -0.008037970631013905, 0.016242998184945318, 0.006328858150325789, 0.010935752965050444, 0.0013870479702524367, -0.019558420963630425, 0.0012408738611915681, -0.0015364346766262341, 0.020997673873048607, -0.01437967963625271, 0.01978972797016131, 0.025122674899882215, 0.0069778069984891425, -0.001627994282121335, 0.01129556572674369, 0.007716709037075807, 0.018491831205157204, -0.03156076089318629, -0.0035756440923549533, 0.010865074892843406, 0.007909465807174146, 0.003951520306274144, 0.0005838934033305669, -0.0052237172240974196, 0.02711449827241458, 0.03269160259791809, 0.0051498270202387526, -0.02878506005100885, 0.03271730337642152, 0.005181953459029343, 0.014765194107771988, 0.002009492657753476, 0.0019195394673301649, -0.011244164169736826, 0.004667934163670306, 0.014058418042314611, -0.013634352403040187, -0.010087621686501593, 0.005320096074807889, 0.013377342755360669, -0.005856603085696128, 0.00962500394814942, 0.0038872681271849142, 0.01751519417144599, -0.0077745362543698284, 0.009547901612639124, 0.005638145071433058, -0.02331075883951907, -0.01015829882738603, -0.020085288785595973, 0.00048068801616077346, 0.003672022710234773, 0.009676406436478885, -0.040504691417026964, -0.020496504966941286, -0.03353973573911214, -0.01638435246671419, -0.023452113121287945, 0.011147785319026356, -0.024017533973653846, -0.013313089877779488, -0.005760224700646959, 0.031740670068000715, 0.0025572442248982673, 0.02863085351734306, 0.0003226673380931543, -0.008918228814014646, 0.022102812936631775, -0.000812390842404203, -0.01850468159440892, -0.009290891964959606, -0.027011695158400854, -0.01841472886964691, 0.017155381409752746, 0.001401504774575942, 0.01887734474535388, -0.013467295480122678, 0.01286974865462749, -0.008725471112593707, 0.02205141137962491, 0.022192767524038988, -0.00915596194649399, -0.005779500284524533, 0.00010742192114301272, -0.012908300753705238, 0.006740073400348498, -0.006830026590771809, -0.0028447735470506106, 0.020033887228589113, -0.026574778198552113, 0.008462036270288329, 0.017656550315860067, 0.01718108218825618, -0.003919394333144854, 0.008262854305564133, 0.027165899829421445, 0.0005597987488606121, -0.0031483658557675993, 0.01576753005734143, -0.04659581690053471, 0.02233412180580786, 0.020213794540758334, 0.006804325346607077, 0.02579089886626184, 0.009759933966615036, 0.020676410416465306, -0.0014392530258335076, -0.011128509735148782, 0.019082952836026533, -0.00412178936084328, -0.01764369992660835, -0.00012740039165003045, -0.0013701817179442345, -0.01270911785765844, -0.005699184886040008, -0.04754674943045208, 0.004420562773590875, 0.008995331149524942, 0.00758177901861019, 0.01098072932743145, -0.01683411981581465, -0.01805491424530846, -0.04464254283311229, 0.017386690278928835, 0.006611568576508738, 0.017155381409752746, 0.01733528872192197, -0.013981314775481715, -0.007948017906251895, 0.0021476352735320223, 0.0171168302419976, -0.008738321501845421, -0.020959120842648258, -0.022950944215180624, -0.0019339961552383453, 0.007029209021157306, -0.012355730290591053, -0.0005738539203123389, -0.002303447407362328, 0.015497670951732795, -0.004873541788681661, -0.02865655429584649, -0.015651876554075985, -0.020869168117886246, -0.019892532946820238, -0.01960982252063729, 0.029170573591205527, 0.0016239785354801738, 0.027294405584583806, -0.021370337023993567, 0.027551415232263322, -0.0025733072114629122, -0.004494452977449542, -0.010042644392797987, -0.010877925282095122, -0.01793926074204302, -0.01841472886964691, 0.0038776303352461277, 0.021678748228679948, 0.0014834264717169309, 0.01293400153220867, 0.0018006725518445177, -0.0006437283775298441, 0.0020657135763910333, -0.0029989791493938017, 0.002835135755111824, -0.013917062829223137, -0.01570327811108285, -0.02463435638302661, 0.006836451785397667, -0.007948017906251895, 0.007478975438935163, 0.008468461464914187, 0.012188673367673545, 0.029735994443571428, -0.006338495942264575, -0.005654208057997703, -0.016397202855965905, 0.01896729747011589, -0.02932478012487132, 0.029170573591205527, -0.013004678673093106, -0.005773075089898675, -0.027679919124780482, -0.013505847579200427, -0.007948017906251895, 0.01312033310768115, 0.0011171880497365275, 0.004915306019411037, 0.01657711016813513, 0.0003108208272940662, 0.011950940235194201, -0.0106980189012485, 0.02863085351734306, -0.02363202043345717, -0.023362160396525933, 0.008770447474974711, -0.005242993273636294, -0.012644865911399862, -0.026137863101348573, -0.023195103473608425, -0.04263787093397341, 0.009425821983425224, 0.02711449827241458, -0.01236858067984277, 0.016217297406441886, -0.006377047110019723, -0.010338205208232653, 0.004182829175450231, -0.03184347318201444, 0.025662394973744684, 0.001877775353016113, 0.037806091047714624, 0.009901289179706512, -0.009136686362616416, -0.026009357346186212, 0.010235402094218927, -0.012195099493622004, -0.028322442312656678, 0.012117996226789109, -0.00018974526570769592, -0.007209115402003929, -0.022244169081045848, -0.008776873600923172, 0.016911222151324946, -0.03557010841675445, 0.0021171153662285468, 0.015690427721831133, 0.008301405473319281, -0.0011404794966705875, -0.012561337449941107, -0.004716123589025541, -0.02271963720864974, 0.02891356394352601, 0.0020769576669862847, 0.0096892568257306, -0.020560756913199866, -0.03007010642676124, -0.025623843805989536, 0.026857488624735065, -0.01954557057437871, 0.008924654008640504, -0.007292643397801382, 0.00783236347166385, -0.030969641124962158, -0.0026889614132203053, -0.016474307054121406, -0.0028672617282411135, -0.0009806517326144458, 0.032871511772732516, -0.0013613469589183547, 0.006399535756871526, 0.01091647738117287, 0.018581783929919212, -0.024493002101257735, -4.635707724115409e-05, 0.010961453743553876, 0.0268060870677282, -0.0020882019904121863, 0.003646321698900691, 0.024248842842829934, 0.03382244430264989, 0.00629351911422227, 0.0021412100789061643, -0.006650119744263886, 0.004317759193915848, -0.013672903570795335, -0.01985398177906509, 0.01629439974195218, 0.0051337640336741085, -0.00780023703287326, -0.017502343782194275, -0.008507013563991937, -0.0018054914478139112, -0.029735994443571428, -0.0005445387952088745, 0.0020673198750474978, -0.021575945114666224, -0.032357492477373476, -0.012111571032163251, -0.0005043810959666122, 0.007748835475866397, 0.01651285822187655, -0.021151878544069195, -0.006023659077291035, 0.01756659759109806, -0.02598365656768278, 0.020959120842648258, -0.0024897792156654587, 0.010273953261974075, -0.00022106829323557224, 0.010685168511996784, -2.27895113457251e-05, -0.020907719285641394, 0.02742290947710096, -0.02863085351734306, -0.02504557256437192, -0.013126758302307008, -0.00030519872378877795, 0.0245444036582646, -0.01002979400354627, -0.009053157901157662, 0.030404220272596257, 0.014199773255406088, 0.00459404395981164, -0.035981324598099766, -0.016191596627938454, 0.021743000174938527, -0.0023982194937550326, -0.014405380414756142, 0.018761691242088437, -0.01201519218145278, 0.00654410356727593, 0.014983651656373758, -0.008417059907907325, 0.0026263155327875404, -0.027397208698597533, -0.021858655540849172, -0.011301990921369548, 0.030584125722120277, -0.003999709731629378, -0.02198715943336633, -0.010575939272034597, -0.011070682983516062, -0.001414355163827658, 0.02116472893332091, -0.022231318691794132, 0.0005132157967848294, -0.0008987299772657944, 0.011905962941490595, 0.005483939469089867, 0.003353973480778954, -0.015471969241906762, 0.00352424230251744, -0.020342298433275494, -0.014739492397945954, -0.03171496928949728, 0.00647985115535605, -0.003800527534074532, 0.03749768170567344, 0.02011099142674461, -0.008384933934778035, -0.02530258221205144, 0.014739492397945954, -0.03325702345028399, -0.0011469046912964455, 0.0003921402206465435, 0.001568560882586174, 0.013068931550674286, 0.01651285822187655, 0.010987154522057308, 0.023272207671763925, -0.02989020097723722, 0.01626869896344875, -0.009496500055632262, -0.00959287797502013, 0.026446274306034953, -0.0029122385562834192, -0.003514604510578653, -0.00010661877181478049, -0.026163563879852005, 0.014495334070840754, 0.02098482348379689, -0.011128509735148782, 0.024582954826019746, -0.000416034058680609, -0.0017187507382882036, -0.0013766069125700925, -0.02243692678246679, -0.0007103902374344205, -0.011912389067439055, 0.012683417079155008, -0.0009975179849226478, 0.00591443030299015, -0.021922907487107752, 0.005332946464059605, -0.015626175775572553, -0.008494163174740221, 0.0029122385562834192, -0.01240070665297206, 0.0006931224104621023, 0.025842302285913908, -0.00446875219894611, -0.017849308017281008, -0.004391649397774515, -0.03168926851099385, 0.006184290339921385, 0.017360989500425403, 0.0043081209363157605, 0.013171734664688012, -0.0122722018291323, 0.010318929624355079, 0.016024539705020945, 0.007691008258572375, -0.02085631772863453, -0.01831192389298798, 0.006460575571478477, -0.0068107510068942355, 0.02413318933956449, -0.016911222151324946, -0.013146033886184582, -0.012362155485216911, -0.019519867933230073, -0.02233412180580786, -0.00481250197407471, -0.0024785351250702073, 0.022321271416556144, -0.0011043375440694865, -0.010627341760364062, 0.014148370767076623, -0.009483648735057946, 0.0014456782204593655, 0.0013958826128629912, -0.005667058447249418, 0.003652746893526549, -0.007395447443137709, -0.02176870095344196, 0.012246501050628867, -0.02104907543005547, -0.008397784324029751, -0.014546735627847616, 0.031355154665158834, -0.012940426726834528, 0.016924072540576658, 0.21835524467667045, -0.012150122199918397, 0.006428449132687887, 0.04366590952469148, 0.0020657135763910333, 0.003633471309648975, 0.033462633403601845, -0.01868458890657814, -0.016911222151324946, 0.015459118852655046, -0.005438962641047561, 0.00020761545467618838, -0.0245444036582646, 0.002512267396855961, -0.02576519808775841, -0.00412178936084328, -0.03017291140342017, -0.020817766560879383, -0.017862158406532724, -0.04155843078624847, 0.014007015553985147, -0.017103979852745883, 0.011713206171392257, -0.007851639055541424, 0.02617641426910372, 0.004173191383511444, -0.0050727242190671575, -0.005294394830643157, 0.024454450933502587, 0.0060493603214557675, -0.01702687751723559, 0.009766359161240894, -0.018594634319170928, 0.006341708539577504, -0.017463792614439127, 0.007735984620953381, -0.001358937510933658, -0.0013701817179442345, 0.002661654336060409, 0.00990771437433237, -0.003153184751736993, -0.01714253102050103, 0.03690656007480411, -0.001966122361198285, -0.014919399710115178, 0.015420567684899899, 0.0011541331516658608, -0.0027291193452932175, 0.02170444900718338, 0.030224312960427033, -0.02363202043345717, -0.002399825792411497, 0.0051401892282999665, 0.02382477813487811, -0.001214369700529254, -0.01907010244677482, -0.00033812807907695005, -0.0058244771125668384, -0.022616832231990812, 0.0069071293919434045, -0.017296737554166823, 0.03405375503447118, -0.0007670126143207687, 0.015176408426472096, -0.03238319325587691, 0.01733528872192197, -0.04204674930310408, 0.0035949199090631774, 0.010280378456599933, 0.00026805283452738666, -0.018466130426653772, -0.03282011021572565, 0.001946846660905386, -0.009200939240197596, -0.032743004154924954, -0.02155024433616279, 0.025289731822799724, 0.007472550244309305, 0.014353978857749278, 0.021845805151597456, -0.018157719221967388, -0.021563094725414508, -0.0014296151174793955, -0.0070934609674158855, -0.015523371730236227, 0.00016404432713319224, 0.019429915208468065, -0.009323017938088896, -0.034953286007381686, 0.00975350877198918, 0.010556663688157025, -0.028707957715498555, -0.002668079530686267, -0.014610987574106196, 0.03176637084650415, 0.006364196720768007, 0.014585286795602764, 0.009702107214982316, -0.004333822180480493, -0.0019356025703101349, -0.03425936126249863, 0.010865074892843406, 0.011379094188202443, 0.010331780013606795, 0.009605728364271846, -0.002158879596957924, -0.004786801195571278, 0.010396032891187975, -0.01531776363956357, -0.014071268431566327, -0.029941602534244084, -0.00670152176693205, 0.013570099525459007, -0.0069778069984891425, 0.007729559426327523, -0.014765194107771988, -0.010518112520401877, -0.0007393037878737688, 0.004247081587370111, 0.005198016445593988, -0.0008280523707200568, -0.007279793008549666, 0.015176408426472096, 0.019082952836026533, -0.024724310970433823, -0.017630849537356635, -0.015060754923206653, 0.018029213466805027, 0.009567177196516698, -0.02922197514821239, 0.008044395825639762, -0.015754679668089713, -0.019275710537447473, -0.011636103835881963, -0.009361570037166644, 0.02742290947710096, 0.010530962909653593, -0.008834700352555892, -0.0064188113407491, -0.0010722113381095467, 0.020714963446865655, -0.014778044497023704, 0.012028042570704497, 0.01900585050051624, -0.012452108209978921, -0.006187502937234314, 0.007254092230046235, 0.005451813030299277, -0.009483648735057946, -0.019905383336071954, -0.0118288606059803, -0.021781551342693675, -0.005760224700646959, -0.015009352434877188, 0.02734580714159067, -0.01841472886964691, 0.003765188730801663, -0.0245444036582646, 0.009567177196516698, 0.00471933618633847, -0.034336463598008925, -0.014392530025504426, 0.007273367813923808, -0.010273953261974075, 0.007215540596629787, -0.00039013234732596287, -0.16479446464764008, 0.02343926273203623, 0.018517531983660636, -0.031971977074531595, 0.0032077993717180855, 0.02570094614149983, 0.004018985315506952, 0.003912969138518996, -0.004886392643594677, 0.01101285530056074, 0.029967303312747516, 0.019648373688392434, -0.039271046598281435, -0.0050566612325025125, 0.02328505806101564, -0.015240661304053276, 0.01242640743147549, 0.03143225700066913, 0.028296741534153246, 0.015356315738641319, 0.020175243373003186, -0.014842296443282282, 0.009702107214982316, -0.0042984831443769736, 0.00043129401233234666, -0.013608650693214154, -0.007286218203175524, 0.022989497245580973, -0.006460575571478477, -0.021640197060924803, -0.028116836084629223, -0.002136391182936771, 0.00402541051013281, -0.005879091266886631, 0.0009822580312709103, -0.012580613033818681, 0.005689547094101221, 0.006226054104989461, -0.0029957665520808727, 0.0023291481858657595, 0.007825938277037993, 0.026831787846231633, -0.010479560421324129, 0.005403624070605343, 0.002631134428756934, 0.021370337023993567, 0.00029977743671937907, -0.00711273701695476, 0.014289725980168097, -0.001654498442783649, -0.00038009289341156603, -0.001717144439631739, 0.01233645470671348, 0.0007232406848937989, 0.03914254270576428, -0.00412178936084328, 0.017322438332670255, -0.01286974865462749, -0.010344631334181113, 0.006450937313878389, -0.007106311822328902, -0.0059754701175971005, -0.0010641798448272244, -0.01135981860432487, -0.026446274306034953, -0.008879676714936897, -0.007376171393598835, 0.030943938483813525, -0.009682831631104743, -0.0017219634520164576, 0.005647782863371845, -0.011526874595919777, 0.0253539837690583, -0.005670271510223648, -0.0023387862106351966, 0.008102223508595085, -0.013101057523803576, 0.03788319338322492, -0.010119747659630883, 0.0021845803754613554, -0.0012392675625351036, 0.0575701201020177, -0.0011774245985999208, -0.006868577758526956, 0.014585286795602764, 0.0011284321403317787, -0.027243004027576942, 0.01286974865462749, 0.009355144842540786, -0.02041940263143099, 0.019558420963630425, -0.03554440763825102, -0.004773950806319562, -0.027243004027576942, 0.001135660600701194, 0.009207364434823454, -0.012484235114430812, 0.004712910991712612, -0.00859054109412809, -0.0029813098641726923, 0.0051658900068033975, -0.009335868327340612, 0.0015468757343085784, 0.007498251022812737, 0.02000818645008568, 0.01894159669161246, 0.01718108218825618, -0.001444071921802901, 0.026728984732217905, 0.02711449827241458, -0.014778044497023704, 0.0042984831443769736, 0.016615661335890278, 0.010293228845851649, -0.012227225466751293, 0.0035467304837079427, 0.017553747201846343, -0.01954557057437871, -0.004915306019411037, -0.022758188376404885, 0.04245796175915898, -0.01579323083584486, 0.0008188160952377235, 0.013139608691558724, 0.019057252057523105, 0.004067174740862187, -0.07098601216248832, -0.012670566689903294, 0.01646145666486969, -0.0006501536303633646, -0.008886101909562755, 0.011880262162987163, -0.025855152675165624, 0.029735994443571428, 0.0018295861604915285, 0.03176637084650415, -0.01966122407764415, -0.02976169522207486, -0.02300234763483269, 0.002321116692583437, 0.013544398746955575, -0.007433998610892857, -0.0028608365336152556, -0.022385523362814724, 0.011751757339147404, 0.02450585249050945, -0.006926404975820978, 0.0013268113049737182, -0.004600469620098798, -0.02457010443676803, -0.030661228057630573, -0.003893693321810772, -0.02176870095344196, 0.010408883280439691, 0.03760048481968717, 0.0060879114892109145, -0.00780023703287326, -0.014276875590916381, -0.011867411773735447, -0.029556088994047408, -0.009663556047227169, -0.005332946464059605, -0.02919627436970896, -0.006470213363417264, 0.02406893553066071, -0.023670571601212317, -0.008494163174740221, 0.009143111557242274, 0.022077112158128343, -0.037317772530859016, 0.009599303169645988, -0.015844634255496926, 0.003331485066757801, 0.023246506893260493, 0.04428273193406425, -0.03317992111477369, -0.02863085351734306, -0.008886101909562755, -0.026317768550872596, -0.011848136189857875, 0.005818051917940981, -0.004635808190541016, 0.0017990662531880532, 0.008031545436388047, -0.013158884275436298, -0.008976055565647368, 0.004430200565529662, 0.012766945540613762, 0.00023251324392245984, 0.031355154665158834, 0.023297908450267354, 0.028142536863132655, -0.009387270815670076, -0.005641357668745987, 0.018607484708422644, -0.029735994443571428, -0.02498132061811334, 0.008031545436388047, -0.028039731886473726, 0.0043016957416899025, -0.004099300713991476, 0.016885521372821514, -0.03199767785303503, 0.014983651656373758, 0.026343469329376024, -0.010640192149615778, -0.02126753390997984, -0.015587623676494805, 0.0019307835579254163, -0.016872670983569798, 0.011006430105934882, 0.019738326413154445, -0.014572436406351048, 0.008352807961648745, 0.011469046912964454, 0.002252045384694164, -0.008037970631013905, 0.032331791698870044, 0.035313100631720135, -0.029247677789361024, 0.0005987517241105259, 0.022359822584311292, -0.0050373856486249395, -0.009001756344150798, -0.003463202487910489, 0.026857488624735065, 0.013878510730145389, -0.02708879749391115, -0.07982713957231527, 0.00893750439789222, 0.02233412180580786, -0.006232479299615319, 0.007389022248511852, -0.013113907913055292, 0.01737383988967712, -0.015523371730236227, 0.0064188113407491, 0.024428750154999155, -0.02865655429584649, 0.005021322196398993, -0.0060654233080204125, -0.005747374311395243, -0.016114492429782957, -0.022102812936631775, 0.021511691305762443, 0.009554326807264982, 0.003957945966561302, -0.00704848460503488, 0.025276881433548008, -0.007170564234248781, 0.023169402695104997, 0.026266366993865732, -0.00786448944479314, 0.004645445982479803, 0.021318935466986703, 0.020445103409934422, -0.03338553106809155, -0.019712625634651013, 0.0325373979268975, -0.010081196491875735, -0.022848141101166897, 0.012233650661377151, -0.0015878365828790727, -0.004757887819754918, 0.004510515964014186, 0.016178746238686738, 0.007119162211580618, 0.027679919124780482, -0.006402748354184455, -0.010293228845851649, 0.0150993060909618, -0.007311919447340256, -0.02711449827241458, 0.0041346397500949955, -0.013660053181543619, -0.000287930925920291, 0.01154615017979735, 0.04135282083293061, -0.0033668238700306696, 0.01594743736951065, -0.005307245219894873, -0.01935281287295777, -0.0122722018291323, -0.04713553697439718, 0.007440423805518715, 0.01878739202059187, 0.02243692678246679, -0.008513438758617795, 0.023760524325974326, 0.027628517567773618, 0.0051466144229258244, -0.005207654237532775, -0.011205613001981678, 0.010010518419668699, -0.013068931550674286, -0.007858064250167282, 0.007221965791255645, -0.032614500262407795, 0.002544393602815901, -0.007421148221641141, 0.022745337987153173, 0.019879682557568522, 0.007768111059743971, 0.013351641976857237, 0.004410924981652088, 0.009952691668035977, -0.018196270389722536, 0.021074776208558903, -0.006868577758526956, 0.0032447444736474185, -0.02570094614149983, 0.01551052134098451, 0.016589960557386846, 0.0006148148270904958, -0.02098482348379689, 0.009939841278784261, -0.019892532946820238, 0.014084118820818043, 0.007658881819781785, -0.003124271375920632, -0.009329443132714754, 0.010036219198172129, -0.015960287758762366, 0.018029213466805027, -0.0018038851491574467, -0.012580613033818681, 0.004732186575590186, 0.017155381409752746, 0.02654907742004868, 0.018106315802315323, 0.012381431069094485, -0.03600702537660319, 0.017759353429873795, -0.001568560882586174, -0.017232483745263042, -0.02852805040332933, 0.0017605148526022554, 0.01774650304062208, 0.01091647738117287, 0.003231894084395703, -0.0034085881007600467, 0.012561337449941107, 0.00622926670230239, -0.003970796355813018, -0.018221971168225968, 0.0017428454509658211, -0.023516365067546525, 0.01270911785765844, 0.01670561592329749, 0.03338553106809155, 0.021061925819307187, 0.0037137867081334995, 0.0035884947144373194, 0.021447439359503863, 0.011655379419759535, -0.009483648735057946, -0.0008802574263011277, -0.010987154522057308, 0.012998253478467248, -0.0012424801598480326, -0.014135520377824907, -0.008776873600923172, -0.0050502360378766546, -0.004828565426300655, -0.005641357668745987, 0.03557010841675445, -0.008352807961648745, 0.026420573527531525, 0.0259194046214242, -0.005467876482525222, 0.009959116862661835, 0.015741829278837997, -0.0011107627386953444, 0.005339371658685463, 0.007221965791255645, -0.02302804841333612, -0.040530392195530396, -0.009740658382737464, 0.0020014611644711537, -0.014366829247000994, -0.009213789629449312, -0.005827689709879767, -0.003527454899830369, -0.03297431488674624, 0.0085584151209988, -0.00880899957405246, -0.008911802688066187, 0.017926410352791303, 0.009226640018701028, 0.014893698000289146, -0.004770738209006633, 0.0015436631369956494, 0.011559000569049066, 0.014867997221785714, 0.004796438987510065, -0.022860991490418613, -0.030841135369799797, -0.005361859839875966, 0.0022456201900683064, -0.04145562767223474, -0.013428744312367532, 0.021948608265611184, 0.008468461464914187, 0.015908886201755505, -0.014906549320863462, 0.03934814893379173, 0.02526403104429629, -0.018710289685081573, 0.025945105399927632, -0.022449777171718505, -0.015471969241906762, 0.007703858647824091, 0.007883765028670714, -0.0077424102812405395, -0.001250511653130355, -0.014919399710115178]"
5,Footbal,"[-0.011428742569128604, -0.008062036637177512, 0.016859330088813396, 0.005923984520252978, -0.026649867881680778, 0.005659549447352424, -0.032635122250934345, -0.00484044659356053, 0.010564492922606236, -0.04819162892685291, 0.017478495682720585, 0.009706691753533859, 0.016201468042270857, 0.019903555337588343, 0.000873924749211433, -0.008390967660448782, 0.027140039712201403, 0.007739555022678801, 0.021141884662757588, -0.01613697209190014, -1.1286850977727151e-05, 0.004437345041098424, 0.001855880820653483, -0.00019328732572206154, -0.008719898683720051, 0.007971742120393997, -0.004824322605967851, -0.03134519951822976, 0.00448894170826274, -0.015388815528574087, 0.025127755257293303, -0.0069527001440722646, -0.02897173513354247, -0.015749994527030714, -0.021451467459711184, -0.03088082532279937, -0.0007965292245960155, -0.00032832644940650245, 0.006262590122344368, 0.011157858087455492, 0.020006749603239542, 0.025863013934396807, -0.005262897303662877, -0.019103802572759256, -0.00545638608609759, 0.024573087476401963, 0.013118545409537993, -0.004666306503104774, -0.043393104887297855, -0.00020296177357494627, 0.0016309500062993399, 0.01600798019115871, -0.012002759507660186, -0.009106876248589477, 0.007436422565820331, 0.003834304598937122, 0.016020879008703828, 0.007823400130689759, 0.009764738295132016, -0.019671369171195715, -0.0058691626830411, -0.0032280394523895406, -0.017504293317810816, 0.013931198854557328, 0.010248460716880084, 0.011190106993963417, -0.006681815662399153, 0.01045484924818248, -0.026804659280157576, 0.01108046331953966, 0.003847203882143522, 0.02383782879929846, -0.005627301472167066, 0.010764431113813507, 0.011538386243552362, 0.024224806364167885, 0.004788849460734931, -0.009925979102381372, 0.0008336145473990941, -0.0019945478822916388, 0.020948394949000308, -0.014976039397291861, -0.026907853545808772, 0.0002030625455870175, 0.025256747158034734, -0.017130214570486507, -0.02080650423071376, 0.016162771589635506, -0.00681080849446315, 0.002762053603257934, 0.0020009975238948386, 0.015982180693423345, 0.02299937771918889, 0.023399254101603435, -0.011789922498907798, 0.010390352366489197, -0.02747542014424523, 0.030622839658671377, 0.02053561974904065, -0.012196249221417467, 0.011796371907680356, 0.026262890316811352, -0.01843303984602647, 0.00036218698051181125, 0.009048829706991321, -0.011138509861137819, 0.005030710671608964, 0.009539001537511945, 0.01576289334457583, -0.029977876429673953, -0.015646800261379518, 0.01626596399264157, 0.018974808809372693, -0.03335748211049273, 0.004276104233849069, -0.014447169251490753, 0.014795449432402264, -0.010319407007345923, -0.04267074502773947, -0.020006749603239542, 0.03495699136544117, 0.011293300328292049, 0.008184579129146385, -0.02234151567264635, 0.0023912000259811864, -0.0007199398760771679, -0.03013266782815075, 0.002668534149257498, -0.00040773750157483497, -0.0009093977198213719, 0.025256747158034734, 0.010248460716880084, -0.002881371856501811, 0.007681508481080643, -0.013453926772904386, 0.005688572718151503, -0.015337218395748487, 0.006668916379192753, -0.020574318064321133, -0.027991391472501223, -0.001907477837063761, 0.021683653626103812, -0.008719898683720051, -0.010751532296268391, -0.004201933238996949, 0.0014285928211410755, 0.0272432339778526, 0.01689802840409388, 0.01595638305833311, -0.015930583560597743, 0.03395084634401942, -0.00804268747953727, 0.01702702030483531, -0.011551285992420043, 0.00011750418240361388, -0.007894346421155598, -0.02308967316729497, 0.026185493686250387, -0.02346375191461928, -0.013453926772904386, -0.016033777826248943, -0.014124687636992043, 0.007933043805113515, -0.010196863584054484, 0.004746926906729452, 0.02431510181227397, 0.015311419829335688, 0.015027635598794893, 0.0024589211463994644, -0.005024261262836406, 0.03206755565249789, 0.02182554434439036, -0.020277634084912653, 0.025514732822162732, 0.0052693471780967185, 0.02030343358264802, -0.0025314795562278026, 0.009055279115763879, -0.021425667961975817, 0.0008835992116162328, -0.02159335817799773, 0.0001992330781610751, 0.021103186347477106, 0.02850736093811208, -0.025798516121380958, 0.014988938214836977, -0.0019945478822916388, 0.003094209563746124, 0.018252450812459436, -0.013402329640078788, 0.013441027024036704, 0.026327386267182066, 0.0051951761832445984, -0.0073009803249837755, -0.7008941111984425, -0.018265349630004556, 0.01208660554699371, -0.010667686256934868, 0.0353697647027557, 0.023515347184799747, 0.016923827901829242, -0.005101656496413521, 0.008719898683720051, -0.00940355929667539, 0.012376838254984496, 0.014679356349205948, 0.004024568444154914, 0.00872634809249261, 0.015105031298033292, -0.02804298860532682, 0.017259208333873073, -0.014795449432402264, -0.01693672671937436, 0.000936808638427311, -0.0017123765860205874, 0.025682423038184646, -0.003086147569949785, -0.011847969040505956, 0.022741392055060896, -0.0043115769134207055, -0.009152023972642519, -0.018381442713200868, -0.004321251492240826, 0.002404099309187586, -0.016665842237701248, 0.0025411539022172818, 0.0029168447689040897, -0.019697166806285946, 0.06372233424239097, -0.001026297211944898, -0.030029473562499555, 0.030622839658671377, 2.1427382119367e-05, 0.05376410809614682, 0.013208840857644075, -0.016923827901829242, 0.007339678174602974, -0.006630218995234837, -0.023541146682535114, 0.00321191523196622, 0.0006397226187084354, 0.0018655552830582826, 0.012841211519092323, -0.014292377853013957, -0.0024218356489734043, 0.004127762709806112, 0.008203928286786627, 0.013402329640078788, 0.004453469028691103, 0.025914609204577273, 0.015079232731620493, -0.006378683205540683, -0.005320944310922318, -0.005814340845829221, -0.022986478901643775, -0.0007763741236898462, -0.01633046180565742, -0.014511666133184034, 0.024366698945099567, -0.002525029914624603, -0.0315515843242419, 0.014098889070579242, 0.025050360489377473, -0.017942868015505844, 0.002204160885149673, 0.01782677493230953, -0.030055271197589786, -0.009506753562326588, 0.025050360489377473, 0.009887281718423456, 0.02477947600770436, -0.027165837347291635, -0.010396802706584322, 0.013112096000765435, -0.0013487787100282885, -0.01727210715141819, -0.035601954594438594, -0.006662466970420194, 0.02837836903737065, -0.02098709326428079, -0.003344132768416497, 0.00032913262550307224, 0.004837221889174251, -0.009242318489426034, 0.022792989187886494, 0.03348647401123416, -0.008668301550894451, 0.010932121329835422, 0.00021666723287791582, 0.014227881902643241, -0.023386355284058316, 0.011660929666843801, 0.030390653492278746, -0.01327333680801479, -0.006991397993691464, -0.0040181190353823565, 0.007281631167343534, 0.015982180693423345, 0.013415228457623904, 0.017246307653682822, 0.020935496131455192, 0.013441027024036704, 0.023592743815360712, -0.023670138583276545, -2.5080491248227193e-05, -0.010377453548944081, -0.004350274763039905, -0.0019494003910692397, 0.025140654074838422, -0.029848884528932522, -0.0011028866186714062, -0.01055804258251111, 0.03493119000506067, -0.0214127691444307, 0.016691639872791483, -0.01387960172173173, 0.014098889070579242, 0.0015914459805835706, -0.022109329506253723, 0.0035859937464598887, -0.018949011174282458, -0.02928131606785093, -0.002708844351069837, -0.015724196891940483, -0.004459918437463661, -0.012989553508796561, 0.02240601162301707, 0.005453161381711311, 0.03400244533949015, 0.01900060830710806, 0.03513757853636307, -0.0047662760643696934, 0.004756601485549573, 0.0011327161819823753, -0.014266580217923723, 0.006610869837594595, 0.0038730022157256795, 0.0059110852370465785, 0.0010424213159528977, -0.045843965902546115, -0.01320239051754895, -0.0006530249317554597, -0.015414614094986887, 0.007236483908951776, 0.003073248286743385, -0.010435500090542239, -0.009803436610412499, 0.019619772038370113, 0.01244133513667778, -0.027552816774806196, 0.005001687400809886, -0.015311419829335688, -0.01983905938721763, -0.025605028270268813, 0.004933966280391607, 0.02194163929023181, -0.009422908454315631, -0.0033699313348292967, 0.0013076623321193798, -0.005291920574461956, -0.008519960492512779, -0.010674136597029992, -0.0030410000787273856, -0.020729107600152796, 0.022612400154319465, 0.018845816908631262, -0.007010747151331705, 0.01055804258251111, -0.0001488453549994817, 0.00025334951128845476, -0.02608230128324432, -0.008777945225318209, 0.004969439425624528, 0.017904171562870493, -0.0011956000129905932, -0.013699012688164699, -0.022857485138257208, 0.00324255108778908, -0.008997232574165721, -0.000878761980413833, 0.008674750959667011, 0.05835624360439947, -0.019413383507067717, 0.018781320958260544, 0.00927456646461139, 0.0001879462199073904, -0.008423215635634139, 0.007262282475364576, 0.022560803021493863, 0.018639428377328866, -0.010371004140171523, 0.0030039148141319675, -0.0010625764168590672, 0.016536848474314685, 0.02840416667246088, -0.0020187338636806574, 0.01782677493230953, 0.007533166957037688, 0.012757366411081366, -0.02747542014424523, -0.016407856573573253, -0.018729723825434946, 0.03217074991814908, 0.009268117055838833, 0.010345205573758723, -0.010132367633683768, -0.013840904337773813, -0.009584149261564987, -0.0012504218502024714, 0.01927149278878117, 0.007591213498635846, -0.014885743949185778, -0.005427362815298512, -0.006307737380736126, 0.01936178637424212, -0.028481563303021845, 0.001152871166473224, 0.009893731127196013, -0.0018768420976562222, 0.0332284902097513, -0.0024573087942063245, 0.02230281735736587, 0.006914002294453065, -0.02496006504127139, -0.0040729408725942344, -0.007307429733756333, 0.014847046565227864, 0.012138201748496743, -0.006688265536832994, 0.004369623920680146, 0.021206380613128305, -0.017736479484203448, 0.03606632692722385, 0.006078775453068492, 0.011493239450821887, 0.0349827890005314, 0.00418580925140427, -0.017349501919334022, 0.010171065017641685, -0.0033731560392155756, 0.003814955674127522, 0.010945021078703104, 0.0008251494073468093, 0.0016172445469963702, -0.01729790478650842, 0.032402936084541714, -0.013931198854557328, -0.004453469028691103, 0.0041245380054198335, -0.023102571984840087, 0.013931198854557328, 0.00042970655690594684, -0.002120315544308074, 0.021773949074209896, 0.00804268747953727, 0.009035930889446203, 0.010164615608869127, 0.0214643662772563, 0.007739555022678801, -0.013802206022493331, 0.008384518251676224, -0.009919529693608814, -0.033692862542536554, -0.02471497819468851, -0.02149016391234653, -0.004298677630214306, 0.006111023893915133, 0.011351347801212773, -0.008971434007752922, 0.009667994369575944, 0.010532244016098312, -0.003747234553709244, -0.009248767898198592, -0.004379298033838984, -0.013750609820990299, -0.014679356349205948, 0.01843303984602647, 0.010906322763422622, -0.012634823919112493, -0.010441949499314797, -0.01758168994837178, 6.797304317249852e-05, 0.012615474761472251, 0.0038923511405352792, -0.0024669831401958036, -0.008126532587548228, -0.006078775453068492, -0.0012858948790200708, -0.007081692976136263, 0.008919836874927322, 0.023360557648968085, -0.00944870702072843, 0.0029829535371292282, -0.004624383949099296, -0.009468055247046105, -0.004485717003876461, -0.020032549100974906, -0.023618541450450947, 0.050977870374144994, 0.009848583403142973, -0.01889741404145686, -0.02561792708781393, -0.009687342595893617, -0.010796679088998866, 0.017143115250676758, 0.01126750176187925, 0.013324933940840389, 0.007945943553981198, -0.01329913537442759, 0.02029053290245777, -0.04132922329956416, 0.005814340845829221, 0.027423823011419633, 0.0028523485857027326, -0.02832677190454505, 0.0010795066969636368, -0.01267352130307041, -0.010113018476043527, 0.07703436843436369, -0.004089064860186914, 0.017156014068221873, 0.024340901310009332, -0.008010439504351914, -0.009616397236750344, -0.019787462254392027, -0.023347656968777834, -0.03678868678678224, 0.0012649334856020106, -0.0043921973170453835, -0.01269287046071065, -0.005337068298514996, -0.011557735401192603, 0.008713449274947493, 0.0025411539022172818, -0.003321559139220618, -0.04181939699272992, 0.014369773552252354, 0.009016581731805962, 0.019426282324612836, -0.029100727034283902, 0.002499231348211803, 0.013505523905729986, -0.0020074471654980388, -0.01995515247041394, 0.002508905694201282, 0.02488267027335556, -0.0034924742924594527, -0.012370388846211939, 0.010441949499314797, -0.00650767603760468, 0.0049533154380318484, 0.008952085781435247, -0.002329928547166108, 0.0030071395185182464, -0.0010190413942451283, 0.0006973661304659683, 0.02182554434439036, -0.004053592180615276, 0.036453302629448146, 0.014085990253034126, 0.012054356640485786, -0.010932121329835422, 0.015749994527030714, -0.021386969646695335, 0.012557428219874094, 0.01992935483532371, 0.004753376781163294, -0.018884513361266612, 0.004901718305206249, 0.016162771589635506, -0.014640658033925466, -0.01605957732398431, 0.0036569398040950875, -8.8783176709046e-05, 0.021064488032196623, 0.0019058654848706216, 0.010674136597029992, -0.015014736781249777, -0.02569532185572976, -0.02804298860532682, 0.033331684475402495, -0.0017381750360180661, 0.0029974651725287677, -0.01982616056967251, -0.027604412044986662, -0.01267352130307041, -6.0011785008442526e-05, -0.0012093054722935627, 0.004879144443179729, -0.012550978811101536, -0.008926287215022448, -0.02118058297803807, 0.0015680660588758013, -0.01842014102848135, 0.0037375602077197654, -0.0040148943309960775, 0.0195552760879994, 0.013582918673645817, -0.0003700474884916687, 0.00034162879155735695, 0.001029522032746498, -0.005549905772928668, -0.0041245380054198335, 0.011473890293181646, 0.013570019856100702, -0.010441949499314797, -0.002918457121097229, 0.009564800103924746, 0.013505523905729986, -0.005446711972938753, 0.03152578668915166, -0.0052177500452711195, -7.941105944429006e-05, -0.017517192135355936, 0.029745690263281326, -0.017143115250676758, 0.0006292419219994054, 0.016304662307922053, -0.00012677552765629862, -0.0194520818223482, 0.002376688390581647, 0.00014874456843549537, 0.027862397709114656, 0.013944098603425012, 0.018316946762830154, 0.028120383373242654, 0.006452854200392802, 0.010467748065727596, 0.008249076010839667, -0.023012276536734006, 0.02636608458246255, 0.00849416192609998, 0.008668301550894451, -0.015930583560597743, 0.004031018318588756, 0.02961669649989476, 0.005853038695448421, -0.03655649689509934, 0.020006749603239542, -0.01206080698058091, 0.026572473113764945, 0.0039923204689695565, 0.0009053667229232022, -0.019065104257478774, 0.012480032520635695, -0.03170637758536383, -0.0018913537330557614, 0.021528862227627014, 0.00870054952607981, 0.0078169507219172, -0.010945021078703104, -0.011331998643572531, -0.0315515843242419, 0.008565107285243253, 0.017156014068221873, 0.0027830151130913148, -0.008339370527623182, -0.009526102719966829, -0.003353807114405976, 0.010371004140171523, -0.0015922521566801406, -0.01329913537442759, -0.008236176261971984, -0.02546313568933713, -0.00650767603760468, -0.0003319543582563873, 0.0006687459477151745, 0.0156081028774216, -0.0214643662772563, 0.00427287952946279, -0.022006135240602524, 0.005636976050987187, -0.010474197474500154, -0.001038390319054728, -0.009397109887902832, -0.013686112939297015, 0.022264120904730518, 0.01158998337637796, 0.02956509936706916, 0.009506753562326588, 0.003434427518030654, 0.013183042291231274, -0.004892043726386129, 0.01523402413009729, -0.015221125312552174, -0.02216092663907932, -0.035292371797485, -0.0012093054722935627, 0.010848276221824464, 0.015982180693423345, 0.017813876114764413, -0.0009464831008321109, -0.0155307071781832, 0.012550978811101536, 0.0019042530162621612, -0.016175670407180622, -0.020161541001716337, 0.008803743791731008, -0.0008884364428186327, -0.016162771589635506, 0.013505523905729986, 0.016472352523943967, -0.006049752182269413, -0.019606873220824998, 0.005785317575030142, 0.003221589810786341, -0.005366091569314075, -0.0025234173296008215, 0.02299937771918889, -0.02392812424740454, -0.002965216964512768, 0.009364861912717473, -0.014898643698053462, -0.01907800307502389, -0.0332284902097513, 0.006381907909926962, -0.011074012979444535, 0.014847046565227864, 0.008752146658905408, 0.013776408387403098, 0.014189184518685324, 0.004534089432315781, -0.018974808809372693, 0.02187714147721596, -0.01707861743766091, -0.013073398616807518, 0.00321191523196622, -0.022986478901643775, -0.008210377695559185, -0.014331076168294439, 0.0021654630355304734, -0.034363623406624216, 0.02850736093811208, 0.013073398616807518, -0.0174913945002657, 0.026520875980939346, -0.0030813102805397246, -0.01480834824994738, 0.017285005968963305, -0.007062343818496021, 0.022844586320712092, -0.014524564950729152, 0.041535611830866556, 0.024895569090900675, -0.00021203156025157346, -0.0389041636446964, 0.016214368722461105, 0.006562497874816558, -0.017762278981938814, 0.01568549857666, 0.007384825432994732, 0.009468055247046105, -0.008268424237157342, 0.018445938663571585, 0.020767805915433278, -0.022741392055060896, -0.03805281188439658, 0.035808343125740986, 0.02897173513354247, -0.00950030415355403, -0.004034243022975035, 0.002713681407649256, -0.006568947283589117, 0.012325241122158898, -0.009880832309650898, -0.005746619725410944, -0.017762278981938814, -0.03304789931353914, -0.021012892762016157, 0.024843971958075077, -0.031035614858631037, -0.006372233796768124, 0.007907245238700716, -0.011364246618757888, 0.004163235855039033, -0.0041245380054198335, -0.0031893416027703415, 0.010532244016098312, -0.002741092326255195, 0.03343487874105369, 0.0007457383842823071, 0.00935196216384979, 0.004911392418365087, 0.01986485702230786, -0.00784274928833, 0.0022622074267478302, 0.01201565925652787, 0.017130214570486507, -0.002515355335804482, 0.01709151811785116, -0.004321251492240826, 0.024843971958075077, 0.0057562938385697805, -0.0019832609512783787, -0.0018752297454630825, -0.005462835960531431, -0.0036053426712694884, -0.021438566779520933, 0.022380213987926834, -0.0003972568339696351, -0.023695938081011912, -0.0025959757394291598, -0.021141884662757588, -0.005572479634955188, -0.021541761045172133, -0.010016274550487453, -0.01731080546669867, -0.008655402733349336, -0.027913994841940255, -0.02569532185572976, 0.015337218395748487, 0.005162928208059241, -0.0067656612360713925, -0.022934881768818173, 0.005862712808607258, 0.02496006504127139, -0.01740109905215962, 0.004037467727361315, -0.02556632995498833, 0.012202698630190025, -0.007552515649016646, 0.006372233796768124, 0.002684658136850177, -0.017736479484203448, 0.010035622776805128, -0.016601346287330534, 0.0029603799079333496, -7.250794378676966e-05, 0.004111638722213434, 0.02030343358264802, -0.014847046565227864, -0.027552816774806196, 0.025888811569487042, 0.017710681849113213, -0.003921374644165, -0.021322473696324618, -0.027578614409896427, 0.01814925654680824, 0.024985862676361624, -0.00550475851453691, -0.02123218011086367, -0.005401564248885712, 0.03162898095480286, 0.013918300037012213, 0.0035601954128777306, 0.006036852899063014, -0.008474812768459739, -0.007591213498635846, -0.001065801237660667, 0.021477265094801416, -0.018110558231527758, -0.014305277601881638, -0.028455763805286482, -0.008623153826841411, -0.0019413383972729, 0.013163693133591033, -0.018949011174282458, -0.012654172145430168, 0.0005788542279416422, 0.005411238827705832, 0.01893611049409221, 0.006601195258774475, 0.010519345198553196, -0.004053592180615276, 0.011706077390896841, -0.02121927943067342, -0.004856570581153209, -0.006136821994666649, -0.009822784836730174, 0.026172594868705268, 0.004540538841088339, -0.03856878321265257, 0.008403866477993897, 0.014601960649967551, -0.042257971690424945, 0.009609947827977786, 0.011467440884409087, -0.008249076010839667, -0.0025879137456328205, 0.004485717003876461, -0.006310962085122405, 0.03379605680818776, -0.019387585871977486, 0.015595203128553918, -0.008100734021135429, -0.01693672671937436, 0.017813876114764413, 0.0012318792179047623, -0.015427512912532002, -0.017143115250676758, -0.017039920985025558, -0.007210685342538977, 0.005366091569314075, -0.008732797501265167, 0.00355052083405761, 0.007094592259342662, -0.021438566779520933, -0.025398639738966416, -0.030984017725805436, 0.012164000314909542, 0.004172909968197871, 0.019155397842939723, 0.0012802514135134405, -0.017478495682720585, -0.0037698081829051233, 0.009938878851249056, -0.01854913292922278, 0.0032441634399822195, 0.0038085060325243223, -0.005408014123319553, -0.01012591822491121, 0.023670138583276545, -0.010016274550487453, -0.02030343358264802, 0.019258592108590922, -0.03395084634401942, -0.0033570320516228967, 0.01865232719487398, -0.007894346421155598, 0.012660622485525292, 0.009784087452772258, 0.002065493707096196, 0.008578007034110937, 0.007217135216972819, -0.012738017253441125, -0.0019800362468920993, 0.006720513512018352, -0.025540532319898095, 0.011525487426007244, -0.009893731127196013, 0.0030796979283465847, 0.0008610255242126936, -0.01912960020784949, -0.0020542070089135775, -0.006323861368328804, -0.015724196891940483, 0.011067563570671977, -0.009384210139035148, -0.032557729345663644, -0.008642502984481652, -0.013557120107233018, 0.001855880820653483, -0.006317411959556246, -0.022418910440562184, 0.0069011030112466655, -0.005011361979630006, -0.03972971404461572, 0.019439183004803084, -0.0136732141217519, -0.005549905772928668, -0.006294838097529726, 0.02641768171528815, -0.006369008626720562, 0.039420134972952395, 0.20607855734996489, -0.02084520068334911, -0.008623153826841411, 0.006778560053616509, 0.016394957756028138, 0.0009303589968241112, 0.030210062596066584, -0.011557735401192603, 0.0011206230748725455, -0.016304662307922053, -0.00418580925140427, -0.026095200100789438, -0.006546373421562597, -0.014008594553795727, 0.0012842824104116104, -0.006275489405550768, -0.01804606228115704, -0.013105646591992875, -0.021128985845212472, -0.00030272945612167554, 0.00422450710102347, 0.0013923137326422273, 0.012983103168701436, -0.00839741706922134, 0.03591153366610192, -0.0014963139415593537, -0.0078040514387108, -0.0019558500326724397, 0.018600730062048383, 0.008390967660448782, 0.006385133079974524, -0.003502148638448932, -0.015105031298033292, 0.005056509238021764, -0.004727578214750494, 0.005259672599276598, -0.008055587228404954, -0.008719898683720051, -0.0029845658893223677, 0.012957304602288637, 0.0030764732239603057, 0.002189649016919492, 0.01614987090944526, -0.0272432339778526, -0.0023428278303725078, 0.01191891439964923, -0.016923827901829242, -0.009493853813458904, 0.005562805056135068, 0.008784394634090767, -0.037898022348564916, -0.0008360331921041243, -0.009358411572622348, -0.002647572872254759, 0.0008779557461096027, -0.00018986096089631914, -0.008584456442883494, 0.009996925392847212, 0.002431510227793525, 0.00679790921125675, -0.006217442398291327, 0.030029473562499555, -0.009648645211935702, 0.024740777692423877, -0.03196436138684669, 0.016098273776619657, -0.007823400130689759, 0.009590598670337545, 0.006323861368328804, 0.019219895655955572, -0.008429665044406698, -0.006772110644843951, -0.021503064592536782, 0.0031490314009580025, -0.016033777826248943, -0.035292371797485, 0.020200239316996823, 0.009545450946284504, -0.001390701264033767, 0.03232554317927101, -0.02472787887487876, 0.0018945785538573613, -0.01802026464606681, -0.02943610746632773, -0.0015720971721892919, -0.006681815662399153, 0.006991397993691464, -0.012280094329428424, -0.03286731214261724, 0.021193481795583186, 0.030158465463240986, -0.01015171679132401, -0.004056816885001556, -0.023038076034469373, 0.004037467727361315, 0.007739555022678801, 0.018961909991827577, 0.039987701571388846, -0.00832002136998294, -0.011190106993963417, -0.03913634981108903, 0.017929969197960728, 0.030906622957889606, 0.009861483152010657, 0.002521804977407682, -0.008603805600523736, 0.0023912000259811864, 0.01688512958654876, -0.014885743949185778, -0.0077847022810705584, -0.024095814463426454, -0.022960679403908408, 0.007442871974592889, -0.00586593797865482, -0.0037182112829101657, -0.010190414175281926, 0.0011294913611807754, 0.006914002294453065, -0.0007662965732367614, 0.0038052813281380434, -0.004614709835940458, 0.0035440711924544102, 0.03745944765086989, -0.0043889726126591045, -0.01661424510487565, -0.023231563885581518, -0.031293600522759035, 0.015878986427772145, 0.005549905772928668, -0.018497535796397183, 0.012131752339724184, -0.01068703541457511, -0.006349659934741604, 0.005853038695448421, 0.0032780240001913587, 0.025630825905359044, 0.004201933238996949, 0.0060207289114703345, -0.014976039397291861, 0.01143519290922373, 0.008835991766916365, -0.001078700520867067, 0.013099197183220317, 0.00391814993977872, -0.00919717169669556, -0.000840064189002294, 0.02249630707112315, 0.0022025483001258915, -0.016627143922420765, -0.010216212741694725, -0.010551593173738553, -0.018832918091086146, -0.022199623091714672, -0.027965591974765856, -0.0035924433880630885, -0.01768488235137785, 0.0010254910358483283, -0.03503438427071187, 0.0008457076545089241, 0.019103802572759256, -0.023437952416883918, -0.009590598670337545, -0.00846836335968718, -0.01912960020784949, 0.016717439370526846, -0.0028120383838903936, -0.1667616054667929, 0.017762278981938814, 0.024134512778706936, -0.009790536861544815, 0.03813020851495755, 0.01462775921638035, -0.005546681068542388, 0.010990167871433578, -0.02121927943067342, -0.01491154251559858, 0.025863013934396807, -0.001984873303471518, -0.03201596038231742, 0.0032232021629794803, 0.008132981996320785, -0.011622231351563319, -0.015466211227812485, 0.015878986427772145, 0.012402636821397296, 0.006185194423105969, 0.029642495997630126, -0.02928131606785093, -0.0051919514788583195, 0.0035698697588672098, 0.004901718305206249, -0.005337068298514996, 0.003126457771762124, 0.043031926820163796, -0.007055894409723463, -0.007797601564276959, -0.013189491700003832, -0.013956997420970127, 0.0011206230748725455, 0.008016888913124472, -0.004969439425624528, -0.010183964766509368, 0.001913927478666961, 0.0008827929773120027, -0.008145881745188469, 0.008339370527623182, 0.00459858584834778, 0.018033163463611925, -0.025888811569487042, -0.0034021793100146545, -0.0053822155569067534, -0.007010747151331705, 0.021257977745953904, -0.01012591822491121, 0.01651105083922445, 0.006217442398291327, 0.002160625746120413, -0.002352502176361987, -0.0055918283269341465, -0.0036633894456982873, 0.010248460716880084, -0.0019929355300984993, -0.006791459336822909, -0.014111788819446925, 0.014163385952272525, 0.022044831693237874, -0.012538079062233852, -0.01299600291756912, -0.013789307204948214, -0.00799753975548423, -0.030803428692238406, -0.00044381510425720125, -0.01600798019115871, -0.011944712966062029, -0.02636608458246255, 0.009177822539055318, 0.0031554810425612023, -0.04006509820194981, 0.02863635283885351, -0.014343974985839555, 0.014692255166751066, -0.002104191556715395, -0.03431202813644375, 0.009693792935988743, -0.0020009975238948386, -0.005008137275243726, 0.01091277217219518, 0.043238315351466196, -0.022728493237515777, -0.011725425617214517, 0.01986485702230786, 0.02822357763889385, -0.013815105771361014, 0.014356874734707238, 0.019348887556697003, -0.0253341437885957, 0.009848583403142973, -0.01865232719487398, -0.009648645211935702, -0.018574932426958148, -0.006175519844285849, 0.018562033609413033, -0.01259612560383201, -0.0035440711924544102, -0.021399870326885582, 0.0136474155553391, 0.009874381969555772, 0.004201933238996949, -0.03013266782815075, 0.013505523905729986, 0.02023893576963217, 0.01091277217219518, 0.02392812424740454, 0.005369316273700354, 0.016472352523943967, 0.004295452925828027, -0.0073267788913965745, 0.011551285992420043, 0.008294222803570141, 0.013634515806471417, -0.004608259961506617, -0.0024347349321798043, 0.007217135216972819, -0.024082915645881338, 0.024186109911532538, -0.0010988556217732363, 0.05639555628231697, -0.013763508638535414, 0.0015293683256719227, 0.020832301865803995, -0.024573087476401963, -0.009132674815002278, -0.0760540284986127, -0.025682423038184646, -0.00013090731111845466, 0.0332284902097513, 0.01385380315531893, 0.0005453967557807881, -0.008132981996320785, 0.019619772038370113, 0.009339063346304674, 0.011551285992420043, 0.002157401041734134, -0.030803428692238406, -0.0074880196986459304, -0.010996618211528704, 0.013350732507253188, 0.02556632995498833, 0.01012591822491121, -0.011473890293181646, 0.0016752912050098485, 0.019568174905544515, -0.004166460559425312, 0.021580459360452615, -0.0034634507888297323, -0.02225122022454027, -0.027604412044986662, -0.005665999321786266, -0.038233402780608744, 0.013092746843125194, 0.017710681849113213, -0.0007614593420343615, 0.004601810552734059, -0.01827824844754967, -0.00014048098695926817, -0.017607487583462016, 0.010493546632140395, -0.011519038017234686, -0.03142259242350046, -0.0073009803249837755, 0.003911700065344879, 0.0004865438925669099, -0.0070881423849088205, -0.01791707038041561, -0.003005527166325107, -0.040374677273613144, 0.004937190984777886, -0.027114240214466036, -0.019194096158220205, 0.018484636978852068, 0.030648637293761608, -0.03516337989674356, -0.012892808651917921, -0.02490846790844579, -0.022599501336774346, -0.003795606749317923, 0.017659084716287615, 0.020006749603239542, 0.0006836606711629988, 0.015221125312552174, -0.02061301451695648, 0.011112711294725018, 0.009268117055838833, 0.0006836606711629988, -0.016485251341489086, 0.043083522090344266, 0.008758596067677968, 0.005714371284564302, -0.0038020563909211226, -0.004437345041098424, 0.007707307047493443, -0.023270262200862, -0.008539308718830454, 0.030906622957889606, -0.01786547324759001, -0.0019381135764713002, -0.020471123798669933, -0.0016575547488087092, -0.012035008414168111, 0.0016623919218034487, 0.019748763939111545, -0.025798516121380958, -0.029074927536548535, -0.02244470993829755, 0.006052976886655692, 0.012370388846211939, 0.012467132771768011, 0.04014249110722051, -4.222491733541621e-05, -0.003566645054480931, -0.00681080849446315, 0.005675673900606386, 0.004995237992037327, 0.019851958204762744, 0.034647408568487574, -0.00418580925140427, -0.02052272093149553, -0.000678420351912314, -0.007533166957037688, -0.013582918673645817, 0.005775642996210022, 0.02775920344346346, 0.0018994158432674216, -0.021141884662757588, -0.08353559599451837, 0.011777022750040115, 0.010235561899334967, 0.00046074538436177074, -0.017375301417069385, -0.0038826767945458, -0.009190721356600434, -0.006601195258774475, -0.003827854957333922, 0.022792989187886494, -0.028017189107591454, -0.002241246149745091, -0.002545991191627342, 0.013956997420970127, -0.0022089979417290913, -0.023038076034469373, 0.023038076034469373, 0.018574932426958148, 0.010654787439389751, -0.006365783922334283, 0.005204850762064719, 0.0097260409111741, 0.018304047945285038, 0.012434884796582654, -0.01108046331953966, -0.006269039531116926, 0.010113018476043527, 0.030158465463240986, -0.012538079062233852, -0.020561417384130882, 0.018974808809372693, -0.017001222669745075, -0.01927149278878117, 0.01768488235137785, 0.007365476741015774, -0.029590898864804527, -0.018742622642980062, 0.008203928286786627, 0.015543605995728318, 0.02029053290245777, -0.026262890316811352, -0.009893731127196013, 0.008887588899741965, 0.009719591502401542, 0.0013052436874143496, 0.008816643540598692, -0.011286850919519491, -0.008145881745188469, -0.0006953506320168835, 2.4488435668425493e-05, -0.0023686263967853073, 0.009635746394390585, 0.012234946605375382, -0.03232554317927101, -0.011796371907680356, -0.02649507648320398, 0.004292228221441747, 0.00846836335968718, 0.017620386401007132, -0.01198986069011507, 0.023541146682535114, 0.012480032520635695, -0.00484044659356053, -0.009719591502401542, 0.009242318489426034, 0.004543763545474618, -0.007597663373069686, 0.01842014102848135, 0.024934265543536022, -0.006478652301144318, -0.01402149430266341, 0.004814648027147731, 0.019529476590264033, -0.006494776754398281, 0.010925671921062863, 0.024740777692423877, -0.003350582410019697, 0.014421370685077954, -0.001553554423476262, 0.04305772445525403, 0.02278009037034138, -0.008210377695559185, -0.025540532319898095, 0.029694093130455727, 0.009016581731805962, 0.027036845446550203, -0.031809571851015024, 0.00960349748788266, 0.004688880365131295, 0.019155397842939723, -0.015272721514055206, 0.0195552760879994, -8.303897557013244e-05, 0.001975198957482039, 0.0025476035438204815, 0.014924442264466261, 0.004414771179071904, 0.010100119658498411, 0.012654172145430168, -0.0013028250427093194, -0.006359334513561725, 0.006972049301712506, 0.0003458613615834993, -0.03041645112736898, -0.0033344581895963766, 0.010661236848162309, -0.027320628745768433, -0.03800121661421612, -0.02458598629394708, 0.009564800103924746, 0.001350391062221428, -0.02275429087260601, -0.011512587677139561, 0.012254295763015623, 0.0009714753747330199, 0.012628373579017367, -0.00642383046393244, -0.006984948584918905, -0.01909090189256901, 0.0017736480648356655, 0.011809270725225474, 0.03134519951822976, 0.02421190754662277, -0.0097776380439997, 0.011164308427550618, 0.014214983085098123, 0.005075858395662005, -0.010300057849705682, -0.007146188926506978, -0.013163693133591033, -0.028713749469414476, 0.003398954605628375, -0.01656264797205005, -0.005256447894890318, -0.010822477655411665, 0.002721743634276237, 0.001192375192188993, 0.00036742729976249605, -0.011293300328292049, 0.032583526980753875, 0.003337683126813297, -0.01613697209190014, 0.015621001694966717, 0.009222969331785793, 0.0003317528142322448, -0.010596740897791593, 0.007210685342538977, -0.02174814957647453, -0.03057124252584578, -0.00940355929667539, 0.010622539464204394, -0.026624070246590546, 0.00617229513989957, -0.018768420278070297, -0.0062045431150849276, 0.0067398626696585934, -0.01796866751324121, 0.010093669318403286, 0.021632056493278214, 0.016162771589635506, 0.008049136888309829, 0.006965599427278664, 0.008049136888309829, -0.007436422565820331, -0.004885594317613571, 0.006362559217948004, -0.00026806271981596677, -0.015891887107962396, -0.012725118435896007, 0.01035810439130384, 0.009822784836730174, -0.031009817223540802, -0.01802026464606681, 0.01898770762691781, -0.026146797233615036, -0.02314127030012057, 0.0024427971588067855, -0.002326703842779829, 0.020561417384130882, -0.011544836583647486, 0.032351340814361244, -0.01126750176187925, -0.008507060743645095, 0.001328623609122119, 0.01736240259952427, -0.027449622509154996, 0.005669224026172545, -0.0156339014438344]"
6,Tennis,"[-0.022973087948412095, 0.0016404849747739204, 0.007827726919935182, 0.0022733783687783515, -0.006344678180588196, 0.020882334015510814, -0.02120980192536592, -0.010214458884619975, -0.012764925735554869, -0.03554279264493548, 0.00654934515858636, 0.014597482598571677, 0.01628519924723938, 0.005853477247128092, 4.819023035274471e-05, -0.0035454627598725122, 0.03131090767974073, -0.006486370524717204, 0.03995100304593817, -0.017242410701818395, -0.0048490342350706135, 0.000579758706748394, 0.002169470479007945, -0.016499312164204215, -0.011089804293057766, -0.001009165865125495, 0.0013177408493093847, -0.028540031240078246, 4.8288626762973785e-05, -0.011266132522833363, 0.0401777130317187, -0.010768634917610511, -0.018753798189387945, -0.03546722140791189, -0.0034100675531675275, 0.001716054349152398, -0.010346705755443586, 0.011807713349653302, 0.011946256892239661, -0.0034226625265074864, 0.0209327148401932, 0.023401313782341768, -0.020655625892375382, -0.011902175533287675, -0.00014513647678351404, 0.017229815495647796, 0.02728054042534022, -0.0055260098029342635, -0.01928278381003729, 0.020542272762130217, 0.010982747834575347, 0.023879920440953828, -0.03695341848314025, -0.011637682722963004, -0.001333484391361355, -0.012059610953807379, 0.007953676187673495, 0.030983439769885622, 0.0007135794544743949, -0.0016530798316985603, 0.0007123987121035608, 0.013816599373768258, -0.018615254646801586, 0.013262423340777723, 0.0006549344809340403, 0.01725500590798899, 0.011064614812039124, 0.0002012231218300404, -0.001131966098490521, 0.0006852409972901252, 0.008048137439985316, 0.02457263815388562, -0.013791408961427064, 0.0010359300961614182, 0.02083195505347353, -0.004691598348889636, -0.026701175842653593, 0.009125000559217347, 0.001491707827173952, 0.0020340755051335975, 0.0017113312632537432, -0.014534508430363795, -0.00844487618981105, -0.0059416413620158905, 0.019471706314660935, -0.007764752286066026, -0.010472655023181898, 0.024194791281993235, 0.02049189380009293, -0.0013830768515048905, 0.020542272762130217, 0.016763804043206335, 0.0017302236068483625, 0.012519324803163543, -0.026247759596382727, 0.009383196697779272, -0.023590236286965414, 0.018350760905154365, -0.0050348088694741585, -0.026625606468275113, 0.0035612063019244827, 0.028338511666638908, -0.023728781692196874, -0.006952381511497391, -0.016574881538582692, 0.006788648022231114, 0.00786551160712442, 0.005041106472559457, 0.005563794490123502, -0.02255745545800792, -0.01772101549778535, -0.009276139307974303, 0.027053832302204785, -0.04891857004728091, -0.015239822280788736, -0.007531747025506569, 0.01576880697011553, -0.004688449547346986, -0.023728781692196874, -0.018287786736946483, 0.022015874631187978, 0.0028448716461002698, 0.012229642511820227, -0.030227746026100847, 0.010157782319497391, 0.0043452385611011885, -0.0266759854303124, -0.007544341766015891, 0.005223732305420353, 0.006738268594532555, 0.03332609223826353, 0.02133575026178168, 0.0008666861459878465, 0.0025567635226976426, -0.028136993955844666, 0.007034248488961167, -0.009395790972627317, 0.003213272346195348, -0.022368532953384274, -0.024257767312846217, -0.016398552377484544, 0.013804004167597661, -0.020164425890237828, -0.008891995764319167, -0.010516736382133886, 0.011606194707536512, 0.020995689008401083, 0.005201691160283084, 0.013992927603543856, 0.009515442637280332, 0.026247759596382727, 0.0009422555203663241, 0.012538217612419437, 0.009672878989122585, -0.021260180887403203, -0.003743832367616016, -0.018993101518693975, 0.02356504773726932, -0.004055555804096599, -0.02515200459921735, -0.0028417230773882586, -0.0014570718251120435, 0.027154592088924456, -0.018665633608838873, -0.0012311509023622729, 0.013489131463913154, 0.01904348048073126, 0.03161318517725464, 0.016965321754000576, -0.023552452531098726, 0.010283731587235704, 0.016763804043206335, -0.013741029999389781, 0.010182971800516034, -0.006190390630288592, 0.009471360347005795, -0.009213165139766421, -0.0006057356791909956, -0.009767340241434407, 0.009704366073226526, -0.019358353184415766, 0.029119395822764876, 0.042621123424171174, 0.024635614184738603, 0.001736521093518342, 0.01573102321424884, 0.0050883370987153675, 0.009332816804419436, 0.0006789435106201458, -0.029194965197143354, 0.007953676187673495, 0.02556763522697643, 0.004826993089933345, -0.01022705409079057, -0.6952381548750293, -0.017708422154259856, 3.3455186931500245e-05, -0.0077017776521968685, 0.037658735127532844, 0.02095790338988929, 0.023048657322790572, 0.028590410202115533, -0.011593600432688466, -0.004112232834880457, -0.008766046496580854, 0.0012311509023622729, -0.009099811078198706, -0.003144000574902169, 0.014761216553499228, -0.019333162772074575, 0.02427036065637171, -0.007978865668692136, -0.008866805351977973, 0.019333162772074575, -0.012834197506848048, 0.015680644252211558, 0.0030637079982097177, 0.00697127385509201, 0.021826952126564336, -0.004014622781025986, -0.0009099811194614024, 0.005245773450557621, -0.00982401773787954, 0.01683937341758481, -0.024358525236920784, -0.003044815654615098, -0.007959972859436242, -0.027759147083952277, 0.04173948134397064, -0.017204625083306606, -0.016675639462657262, 0.03372912765985201, 0.016675639462657262, 0.046575917578903, 0.010485249298029945, 0.007216874321822063, -0.013426157295705274, -0.00993107419636196, -0.016826778211414217, 0.03214216893525888, 0.004543607936014054, -0.020000691935310275, 0.009446170865987152, -0.02690269355344783, 0.001438179481517424, 0.003690304138374807, -0.008942374726356452, 0.0016971620055577785, -0.0077899422327459425, 0.012128883656423109, 0.019219809641829406, 0.004524715592419435, 0.016461526545692426, 0.01904348048073126, -0.02049189380009293, 0.020114046928200544, -0.02856521978977434, -0.0374824059664347, 0.0015436617720591553, -0.011089804293057766, -0.036625954298575354, 0.017695826948089258, 0.024182197938467737, -0.018048483407640453, -0.0063352317759602485, 0.006788648022231114, -0.008325225456480585, -0.01628519924723938, 0.02680193562937326, 0.013111284592020767, 0.028036234169124995, -0.020756385679095053, -0.002086029333603482, 0.009301329720315495, -0.0091124062843693, -0.016335578209276662, -0.016436337995996333, 0.0012988485057147652, 0.03519013432273918, -0.02495048502577801, -0.022771568374972757, 0.02333833961413389, -0.007689182911687548, -0.006442288234442667, 0.043074539670442044, 0.028993447486349112, -0.004241330438500144, 0.00563621506295933, -0.009408386178797913, 0.007890701088143062, -0.003923309398934263, 0.00492775241099174, 0.006813837968911032, -0.020857145465814724, -0.0061494571415567035, 0.006486370524717204, -0.011769928662464063, 0.012531920009334138, -0.008192978585656973, 0.015542099778302646, 0.0023064400864842545, 0.03823809971021948, 0.010151484716412093, -0.010756039711439914, 0.0038382940855891134, -0.016197034666690303, -0.02916977478480216, -0.011769928662464063, 0.022507076495970633, -0.026272950008723917, 0.009798827325538348, -0.0045845414247459425, 0.02316201045303574, -0.011845498036842542, 0.011001640643831242, 0.009402088575712616, 0.025441686890560665, 0.02639889834513968, -0.019358353184415766, 0.0029125692494527625, -0.008791235977599496, -0.022670810450898186, -0.0041279768425937025, -0.015592478740339932, 0.010107402426137556, 0.012431161153937019, 0.024018463983540187, -0.007852916400953824, 0.022935302329900306, 0.0005907792793170282, 0.015151657700239662, 0.008526743167274824, 0.024887510857570128, -0.01604589591793335, -0.020945310046363796, -0.012380781260577184, -0.004647516058615099, 0.014118876871282169, 0.0016152951445093215, -0.02173878754601526, -0.018753798189387945, 0.002559912324240292, -0.020441512975410546, -0.000530166304812518, 0.0011390507855461626, -0.006014061934851719, -0.007109817863339645, 0.026927883965789025, 0.02390510899064992, -0.011870687517861184, -0.021348345467952275, -0.026424088757480875, -0.027431679174097175, -0.02255745545800792, -0.007412095360853555, 0.011706954494256183, -0.039119741790420014, 0.0016389105740025958, 0.005513415062424942, -0.02117201816949923, -0.025403901272048876, 0.0206052469303381, -0.01242486355085172, -0.025277952935633112, 0.007053140832555786, 0.014912355302256184, -0.006517857608821145, 0.021499484216709233, 0.011700656891170884, 0.026021051473247292, -0.01171325209734148, -0.01343875250187587, -0.0013807152503479035, 0.005469332772150405, -0.002926738623564046, -0.02457263815388562, -0.01832557049281317, -0.005409506939823898, -0.004065002208724546, 0.0075506393691011885, 0.016222223216386396, 0.04065631969033076, -0.020340755051335976, 0.0064548834406132636, -0.00114770975695781, 0.012752330529384273, -0.031210147893021057, 0.003910714658424941, 0.011763631059378766, -0.00820557379182757, 0.0005663766494380916, 0.009213165139766421, 0.014874570615066945, 0.0003008998968390015, 0.031386475191474104, 0.0019317418997191966, -0.004845885433527965, -0.008539338373445421, 0.017179436533610513, -0.015743618420419436, -0.0049025624643118226, -0.021348345467952275, 0.041109735936601624, 0.02356504773726932, -0.0015460232568008233, -0.003419513724964837, -0.005412655741366547, 0.00391701226151024, -0.005951087766643838, 0.035366463483837325, 0.01428260989488717, -0.0019600805315264447, 0.01195255449532496, 0.0004738829033253206, 0.013463941982894512, -0.009502847431109735, 0.005280409336204211, -0.015756213626590035, 0.0012311509023622729, 0.03481228931349189, 0.00395164814715683, 0.012909766881226527, 0.01444634384981472, -0.018073673819981647, -0.01002553544867378, -0.00949025315626169, -0.008085922127174554, -0.0053181940233934496, 0.004716787829908278, -0.0034824883588339935, 0.022292963579005797, -0.014924949577104229, 0.025781748143941265, 0.003381729037775598, 0.010031833051759078, 0.014307800307228363, -0.006391908806744107, -0.010101104823052258, 0.0075380441629305924, -0.022292963579005797, 0.0038571864291837327, 0.010290028258998453, -0.002358393914954139, 0.011045722002783228, -0.017380954244404754, 0.015378365823375095, -0.01097645023149005, 0.0015192591421802188, 0.0065430475555010624, -0.023577642943439916, 0.011965149701495556, 0.009005349825886882, 0.014849380202725752, 0.02107125838277956, 0.011133886583332302, 0.001065842895909353, 0.016524500713900304, 0.008564527854464063, -0.0008895144333031178, -0.03425811141785625, 0.004631772516563128, -0.019597654651076695, -0.010888286582263526, -0.01175103678453072, -0.018854556113462515, -0.021020879420742274, 0.012783817613488214, -0.015516909365961454, 0.008621205350909197, -0.0031251082313075496, 0.005907005476369301, 0.006568237502180979, -0.00830003504413939, 0.013665460625011302, 0.002326906830850198, -0.023716186486026275, 0.018816772357595827, -0.008174086707723629, 0.0008863656899681281, -0.01661266529444938, -0.009225760345937018, 0.0024134965449666727, -0.014622672079590318, 0.00874715368732496, -0.0030212003415371427, 0.014005522809714453, -0.005692892093743189, 0.0006994101967784304, -0.013375777402345438, -0.00023674465156624472, 0.008589718266805256, -0.016801589661718123, 0.011618789913707109, 0.0030920465136016467, 0.005551199749614181, -0.014106281665111572, 0.006857919793524294, -0.011165373667436243, 0.03531608265915494, 0.010850501895074286, -0.016637855706790574, -0.025706178769562785, -0.007531747025506569, -0.034157353493781684, 0.009131298162302645, 0.0026402046681021055, 0.007336525986475077, -0.010963855956642003, -0.013791408961427064, 0.010119997632308152, 0.0025772302670635868, -0.01934575797824517, 0.021285371299744397, -0.00881642638994069, -0.01920721443565881, -0.014899760096085587, -0.001871916183808008, -0.009540632118298973, 0.0773326510882983, 0.025819533762453054, -0.002693733130173952, 0.01222334490873493, -0.0051103782438526365, -0.009452468469072451, -0.007588424056290428, -0.008690477122202377, -0.01309869031717272, 0.012802710422744109, 0.007676588171178227, 0.00729244369620054, -0.009439873262901854, 0.0033691342972662773, 0.017670636535748067, 0.012720843445280332, 0.003913863459967591, -0.03357798891109506, 0.018753798189387945, 4.1572990819813275e-05, 3.3799579824270065e-05, -0.010170377525667988, 0.00719168484080342, 0.045517946337604316, 0.017003107372512365, -0.008111111608193198, 0.019836957980382725, -0.002950353936642001, 0.03372912765985201, -0.03423292100551506, -0.008696774725287675, 0.0035045292711406244, 0.016486716958033616, 0.001938039386389176, -0.006404503547253428, -0.013501726670083751, 0.008022947958966674, 0.019912527354761202, 0.029295724983863024, -0.03445963099129559, 0.04519048215303942, 0.005037957671016808, 0.012601191780627317, 0.00761361353730907, 0.0011705379860654222, 0.00993107419636196, 0.0004884457321102866, 0.008854211077129928, -0.005126121785904607, -0.01819962215639741, -0.0064013552113720545, 0.010019238776911034, -0.01978657901834544, -0.0035234216147352437, -0.020844550259644126, 0.037809873876289805, -0.010151484716412093, -0.006763458075551196, -0.0025000864919137843, -0.030076607277343893, -0.00949025315626169, -5.3577498386908544e-05, -0.007739562339386108, 0.0021852142538905527, 0.012399673138510528, -0.04375466217720324, -0.00562047152090736, -0.029824710604512368, 0.0084385795180483, -0.028313323116942814, 0.018829367563766422, -0.020479298593922335, -0.010655280856042794, -0.0133379927151562, 0.04045480011689142, 0.0015948285165586964, 0.010119997632308152, -0.008180384310808928, -0.017406144656745944, 0.03372912765985201, -0.006763458075551196, -0.01124094304181472, -0.02221739420462732, -0.009779935447605003, -0.012500432925230199, 0.013287613753118915, 0.0126641659488352, 0.004461741424211554, -0.02008885651585935, 0.004206694552853554, -0.0015161104570528886, -0.002281250139804337, 0.023124226697169053, -0.016423742789825734, 0.004027217521535308, -0.014937544783274826, 0.0037343861958187064, 0.01086939377300763, -0.01660007008827878, 0.0016987364063291031, -0.00874715368732496, -0.02677674521703207, 0.004647516058615099, 0.018716012570876156, 0.004883670120717203, -0.007972568065606839, 0.009068323994094765, 0.006017210736394368, 0.009087215872028109, -0.002133260192590031, 0.01813664798818953, -0.02273378461910607, 0.020655625892375382, 0.008854211077129928, 0.0032778211480051916, 0.011814010952738601, -0.004414510332394367, -0.00011020532550868415, 0.009137595765387944, -0.009427278056731258, 0.013589891250632825, -0.009672878989122585, 0.007103520260254346, -0.007393203017258936, -0.0029519283374133255, -0.020340755051335976, 0.002542594381416997, -0.04942236711823416, 0.0036052885921990198, 0.010711957421165378, 0.0064548834406132636, 0.01026483877797981, -0.023716186486026275, -0.013589891250632825, -0.035064185986323416, 0.011524328661395286, -0.0033439443505863596, 0.017746205910126545, 0.02002588234765147, -0.02944686373261998, -0.012160370740527048, 0.012072206159977974, 0.0009391068352389937, 0.006045549484616934, -0.01685196862375541, -0.02147429566701314, -0.010390788045718122, 0.020617842136508694, -0.015516909365961454, 0.015453935197753572, -0.0003609224419504353, 0.0037060476804267775, -0.012588596574456722, -0.010113700029222855, -0.015554694053150693, -0.0020828807648914705, -0.0030133285705111574, -0.008545635976530718, 0.02350207356906144, 0.010856798566837035, 0.015164252906410259, -0.019698414437796366, 0.019295379016207887, 0.009635094301933347, 0.0036714117947801877, -0.0020262037341076122, -0.00925094982695566, -0.011001640643831242, 0.0007155474554385506, 0.0038194017419944937, 0.02484972710170344, 0.0012846792480188008, 0.03294824350372604, 0.0038382940855891134, -0.019421327352623648, 0.013652865418840707, 0.0020592652189828776, -1.4959511710008387e-06, -0.0044334026759889865, -0.02002588234765147, 0.0024591530031818965, 0.005633066261416682, 0.006725673388361958, 0.009414683781883211, -0.006102226515400793, 0.002788194848147049, 0.023136820040694547, 0.0032715237777505312, -0.004024068719992658, -0.01546653040392417, 0.011744739181445422, -0.021864735882431024, 0.010220756487705273, 0.0008808554036838109, -0.0034132163547101768, -0.0028779333638061727, -0.019459111108490336, -0.011631385119877706, 0.001349228049828644, -0.0012028123869703437, -0.003712345050681438, 3.8836309510124485e-06, -0.014332989788247005, 0.007468772391637413, 0.007915891500484256, 0.02765838729723261, -0.030101797689685086, -0.009427278056731258, 0.009332816804419436, -0.010283731587235704, -0.002596122610658206, -0.023010871704278783, -0.0014200743383084669, -0.03879227388056491, 0.010573413878579019, 0.015479124678772216, -0.022003281287662484, 0.01715424612126932, -0.015655453839870364, -0.022267773166664603, 0.008973861810460393, -0.015403555304393737, 0.022507076495970633, 0.006612319326794241, 0.024282955862542307, 0.02109644879512075, -0.0059416413620158905, -0.010176674197430735, 0.011662872203981645, 0.012909766881226527, -0.02738130021205989, 0.010995343040745944, -0.0015420873712878307, -0.011114994705398958, -0.02420738648816383, 0.01279641281965881, 0.022935302329900306, -0.031587994764913446, -0.01353951135727299, 0.013325398440308153, 0.0030212003415371427, 0.00962249909576275, -0.009276139307974303, -0.006650104013983481, -0.018174431744056217, 0.04619807256965572, -0.020945310046363796, -0.011946256892239661, -0.02221739420462732, -0.03481228931349189, -0.011732143975274825, 0.040530371353915, -0.030983439769885622, 0.01340096781468663, -0.00992477659327666, -0.019056075686901857, 0.0058093949568535546, -0.004767167723268113, -0.002045096077702232, -0.0018073673819981647, -0.006574534639605003, 0.03828848053490186, 0.011259835851070616, -0.00027610369587106355, 0.02258264587034911, 0.013791408961427064, 0.0030353694828177884, -0.0014554974243407189, 0.015113873013050423, 0.02394289460916171, -0.008564527854464063, -0.0011185840411802187, 0.003016477139223169, 0.013917358229165379, -0.0009328093485690143, 0.003822550543537143, -0.005573240894751449, 0.013904763022994782, -0.010031833051759078, -0.014055901771751736, 0.016083679673800037, -0.0037721708830079454, -0.02110904213864625, -0.01013259283847875, -0.022141824830248843, -0.014106281665111572, -0.03571912180603362, -0.01763285277988138, 0.002893676905858143, -0.02856521978977434, -0.017129055708928125, -0.015164252906410259, 0.011625087516792407, 0.0017506903512143066, 0.026726366254994784, -0.011958852098410258, 0.001341356278802659, 0.03171394310132921, -0.021638027759295592, 0.00756323410961051, -0.029119395822764876, 0.01030262346516905, -0.0016656748050385192, 0.011429866477760914, 4.18681836884792e-05, -0.013866978335805543, 0.020806764641132337, -0.01299793053045305, -0.028791927912909774, -0.023993273571198993, 0.016209629872860898, 0.016486716958033616, -0.015504315091113408, -0.0005026149898062511, 0.03990062594654598, 0.015957731337384273, -0.0071350078100195615, -0.030605592897993236, -0.024131817113785353, 0.009332816804419436, 0.007430987704448174, -0.014559697911382438, -0.010516736382133886, -0.019182024023317618, -0.0042917103318599785, 0.00976104356967166, 0.005516563863967591, -0.008904590039167213, -0.021146827757158038, -0.016562286332412093, -0.021046067970438367, 0.019811769430686632, -0.012701950636024438, -0.009767340241434407, -0.009263545033126257, 0.004146869186188322, 0.0008895144333031178, 0.00999404836456984, -0.004099638094371136, -0.004543607936014054, 0.007172792497208801, 0.005853477247128092, 0.015743618420419436, 0.011530625333158035, -0.012160370740527048, -0.0006301383090699321, -0.016209629872860898, -0.018489304447740725, -0.011845498036842542, -0.004622326111935181, 0.0030306465133344523, 0.020920119634022603, 0.015491719884942811, -0.031915462674768545, -0.029522433106998456, 0.01964803547575908, -0.04070669678972294, 0.009735853157330467, 0.009962561280465899, 0.00887940055814857, 0.006530452814991741, 0.024799346277021055, 0.0010847352395039725, 0.026272950008723917, -0.006439139898561293, 0.010157782319497391, -0.008696774725287675, -0.00330930846493977, 0.02629813855842001, 0.001520046342565881, -0.006908299686884129, -0.016486716958033616, -0.02846446186569977, -0.009125000559217347, 0.015151657700239662, -0.010491546901115242, -0.00023635106592532844, -0.00925724743004096, 0.015202037593599498, 0.006284852348261688, -0.021889926294772218, 0.00567085094860592, -0.019257593397696095, 0.01896791110635278, -0.008967565138697644, -0.013690650106029946, -0.0026197379237361614, -0.0019270188138205417, -0.014358179269265647, -0.01711646050275753, -0.0009579991788336131, -0.010573413878579019, -0.00989328950917272, 0.006158903546184651, -0.016436337995996333, -0.014635267285760915, -0.00622817531747783, -0.018048483407640453, 0.00043176873043025807, 0.03524051514742156, -0.0031707646895227735, 0.012922361156074572, 0.004124828041051054, -0.011379486584401079, 0.00032687686928160317, -0.012834197506848048, -0.012059610953807379, -0.006832730312505651, 0.016940133204304483, -0.00560472797885539, 0.01677639924937693, -0.018690824021180063, -0.0015964028009147022, -0.0071979819782274435, -0.024597828566226814, 0.009546929721384273, 0.010397085648803421, -0.0007045268828699163, 0.008873102955063272, 0.005850328445585442, -0.024522259191848337, 0.007204279581312741, -0.01600811029942156, 0.005378019855719957, 0.006174647088236621, -0.014547102705211841, 0.00492775241099174, -0.03476190848880951, -0.027733956671611087, 0.00830003504413939, -0.023917704196820516, 0.020177021096408423, -0.026222569184041533, 0.03085749143346986, -0.015756213626590035, 0.020857145465814724, 0.2319475798907929, -0.014849380202725752, -0.021826952126564336, 0.02889268769962944, 0.01952208713934332, 0.019824362774212127, 0.04304934925810085, -0.018753798189387945, -0.020554867968300812, 0.019093859442768545, -0.007985163271777436, 0.005390614596229279, 0.0026480764391280907, -0.002973969482550594, -0.01086939377300763, 0.016209629872860898, -0.015655453839870364, -0.03581987973010819, -0.009194273261833077, -0.03546722140791189, 0.008640097228842541, -0.009332816804419436, 0.024459285023640455, -0.01678899445554753, 0.017922535071224693, -0.007311336039795159, -0.006398206409829405, -0.011499138249054094, 0.006300595890313659, -0.0012886151335317934, -0.00925094982695566, 0.016864563829926005, -0.007462474788552114, -0.003197528804143378, -0.02029037422665359, 0.0044869309052301964, -0.02012664027172604, -0.014610077804742274, -0.00181523915302415, 0.005255219855185568, -0.008690477122202377, -0.001601125886813357, 0.015504315091113408, -0.003444703671644755, 0.0019490598425424915, 0.040076955107644134, -0.013678054899859349, -0.012802710422744109, 0.013111284592020767, 0.020239995264616305, -0.026373707932798487, 0.013652865418840707, 0.014572293117553033, 0.018489304447740725, -0.0017192030342797282, 0.014698241453968797, 0.0015405129705165063, -0.008791235977599496, -0.011366892309553034, 0.007267254215181897, -0.01928278381003729, 0.020706006717057766, -1.2508795990729352e-05, 0.03677709304733231, -0.018653038402668274, 0.0014492000540860582, -0.016184439460519708, 0.022292963579005797, 0.008255953685187405, -0.0011870688449183734, -0.003898119685084983, -0.002980266852805255, 0.00391701226151024, -0.002802363989427695, -0.025630609395184308, -0.020542272762130217, 0.04440959799691345, 0.0014310949108771011, -0.0006604447672183575, 0.019068670893072452, -0.007796239370169966, 0.0030259233110204787, -0.004984429441775599, -0.0006639871107461784, -0.027104213126887173, -0.024937891682252515, 0.00800405514971078, -0.005097783503343315, -0.007764752286066026, 0.012922361156074572, 0.025366117516182188, -0.0172172202894772, -0.014421154368796079, -0.0002524882663777893, 0.018993101518693975, 0.004949793556129009, 0.002456004434469885, 0.009880694303002124, -0.007739562339386108, 0.0015066642852555787, -0.017708422154259856, 0.021449105254671946, 0.019471706314660935, -0.0014602205102393737, 0.01097015262840475, 0.0015208335429515434, -0.0037690220814652962, 0.008973861810460393, 0.00814259962361969, -0.00763250588090369, -0.02097049859605989, -0.015605073946510528, 0.012254831992838871, -0.015932540925043082, -0.015894757169176394, -0.010189269403601332, -0.007953676187673495, -0.002588250839632221, 0.006486370524717204, 0.0006238408806076121, 0.002753558729669822, -0.008526743167274824, 0.009301329720315495, 0.002580379068606236, -0.017091271953061437, -0.010189269403601332, -0.031008630182226816, 0.005463035634726382, -0.005141865793617852, -0.03093306080784834, 0.0005943215646371896, -0.012198155427716286, 0.0015294925143631908, 0.002487491518573826, 0.0025000864919137843, 0.0033911752095729083, 0.011473948768035452, 0.005085188762833994, -0.017746205910126545, 0.005488225115745025, 0.01998809672913968, -0.03161318517725464, 0.004691598348889636, 0.013615080731651467, 0.004024068719992658, -0.020378538807202664, 0.004376725645205129, -0.0006269895657349424, -0.011858093243013137, -0.021499484216709233, -0.007878106813295017, -0.015655453839870364, -0.020718601923228365, -0.02356504773726932, 0.002411922377025986, -0.016700829874998453, -0.00014110217667039884, -0.020643032548849888, -0.006014061934851719, 0.026701175842653593, -0.03461076974005255, -0.0016625260034958702, 0.018665633608838873, 0.005132419388989905, -0.003099918284627632, -0.003463596015239374, -0.16121464547253786, 0.027431679174097175, 0.024698588352946485, -0.00567399975014857, 0.007758454682980727, 0.011801415746568004, 0.005236327511590949, -0.006681591563748696, 0.0004620751885786835, 0.01319944917256984, 0.02440890606160317, 0.01758247195519899, -0.016260008834898185, -0.0005262304192995254, 0.001966377901781105, -0.0011461353561864856, 0.007481367132146735, 0.00488052178483583, 0.03770911222692503, 0.008753451290410257, 0.005699189696828487, -0.03025293643844204, 0.009169082849491885, -0.007254659009011301, -0.01675120883703574, -0.01685196862375541, 0.00031624992600962976, 0.019824362774212127, -0.003473042187036684, 0.006914596824308152, -0.007966270462521541, 0.008961267535612346, 0.012708248239109736, 0.005346532771616017, -0.007569531712695808, 0.0016955876047864541, 0.025026054400156487, -0.013350587921326797, -0.0015672772015524296, 0.017242410701818395, 0.008495256083170883, 0.031663566001937024, -0.020668221098545977, -0.02181435692039374, -0.01610887008614123, 0.0013736306797075806, 0.014408559162625482, -0.016159249048178514, 0.010888286582263526, -0.009666581386037288, 0.006398206409829405, -0.0045971366309165386, 0.01683937341758481, 0.004401915591885046, 0.03997619345827936, 0.004427105538564964, 0.0014617949110106983, -3.0331063617445413e-05, -0.0017302236068483625, -0.001670397890937174, -0.0033911752095729083, -0.0017380953778743477, 0.008211871394912867, -0.010674172733976138, -0.02103347276426777, -0.010283731587235704, -0.011392081790571676, -0.009156488574643839, -0.02717978250126565, 0.010415977526736765, 0.002175768082093243, -0.025000865850460397, 0.01120945595771078, -0.009339114407504734, -0.0023395015713595195, 0.006939786770988069, -0.007393203017258936, 0.032620775593870936, -0.012002934388684794, -0.011939960220476914, -0.0067823504191458165, 0.05017806086201894, 0.002596122610658206, -0.021184611513024726, -6.026853795599582e-05, 0.0018168135537954743, -0.02457263815388562, 0.0003349454695078336, 0.02100828421457168, -0.0192449981915255, 0.006064441828211554, -0.030807110608787474, 0.0009005349476640926, -0.013816599373768258, 0.010126295235393452, 0.02457263815388562, 0.00036111924204685085, -0.009452468469072451, -0.0022859733421183104, -0.015038303638671946, 0.01158100522651787, -0.00012476817612152243, -0.010271136381065108, 0.017280194457685083, 0.026121811259966963, 0.015945136131213677, 0.02589510313683153, 0.020844550259644126, 0.027708768121914994, 0.013300208027966961, -0.00036367758509259386, 0.01702829778485356, 0.010674172733976138, 0.019131645061280334, 0.0023898812318887174, 0.013967738122525213, 0.012191857824630989, -0.014458939055985318, 0.009509145034195034, -0.003913863459967591, 0.05430918417784891, -0.01678899445554753, 0.002526850606534389, 0.023980678365028398, 0.012185560221545691, -0.0018183878381514802, -0.08589718266805256, -0.0344344405789544, 0.02482453668936225, 0.028313323116942814, 0.00015714099162656675, 0.014307800307228363, -0.024534854398018932, 0.041084545524260434, 0.006731970991447256, 0.027129401676583266, -0.005869220789180062, -0.016524500713900304, -0.008967565138697644, -0.010277433984150406, -0.0006376165381107456, 0.007380608276749614, -0.003910714658424941, -0.028741548950872487, -0.002234019280817788, 0.021889926294772218, 0.006612319326794241, 0.0020403728753882583, -0.003983135231260771, -0.011700656891170884, -0.006014061934851719, -0.01303571521764229, -0.04050518094157381, 0.019370948390586364, 0.028691169988835204, 0.010989045437660645, -0.008690477122202377, -0.009729555554245168, -0.012632678864731258, -0.0320917918358667, -0.0036052885921990198, -0.011045722002783228, -0.01898050631252338, -0.02029037422665359, 0.02843927145335858, -0.005702338498371136, -0.013212044378740437, -0.001458646225883368, 0.016726020287339646, -0.03791063180036437, 0.016398552377484544, -0.017469118824953826, -0.0005222945337865328, 0.005966831308695808, 0.022406316709250963, -0.03224293058462365, -0.016801589661718123, -0.01289717167505593, -0.014673051972950154, 0.004978131838690301, -0.003806806768654535, 0.005277260534661562, 0.0006222664798362876, 0.023539857324928127, -0.020441512975410546, 0.008640097228842541, 0.005532307406019562, 0.005242624649014972, -0.0028621898217542022, 0.029245344159180637, 0.021323156918256186, 0.012550811887267482, -0.014295205101057766, -0.01628519924723938, 0.017330575282367467, -0.006099077713858143, -0.016549691126241498, 0.011329107622363794, -0.011429866477760914, 0.016562286332412093, -0.014043307496903691, -0.01512646821922102, -0.03919530930215339, -0.011385784187486378, 0.04433402675988987, -0.0006895704829959489, -0.0290438264483864, -0.020164425890237828, 0.002871635993551512, 0.01205331428204463, 0.03320014017655756, 0.013350587921326797, -0.008463768999066944, 0.012500432925230199, -0.0033596881254689677, 0.011656574600896348, -0.0031219594297649004, 0.04138682302177434, 0.020643032548849888, -0.03725569598065417, -0.0145219132241932, 0.00533393756544542, -0.010793824398629153, -0.021272776093573798, -0.00164993114657123, 0.0091187038874546, 0.003040092685131762, -0.012771222407317618, -0.08378124018545519, 0.01377881468657902, 0.028313323116942814, 0.0020513934479568924, 0.014950139989445423, -0.0045089720503674645, 0.00942098138496851, 0.002097049906172116, 0.0005734612782860739, -0.008079624524089257, -0.034862666412884075, 0.002822830733793639, 0.017330575282367467, -0.002674840786579333, -0.012638976467816556, -0.015516909365961454, 0.03627329597637906, 0.0033156058351944307, -0.006162051882066025, -0.003213272346195348, 0.014673051972950154, 0.02416960273229714, 0.026852314591410548, 0.006895704480713532, -0.0010721403825793324, -0.011285025332089258, 0.008709369000135721, 0.01161249231062181, -0.03398102433268353, -0.01488716488991499, 0.015340581136185857, -0.012028123869703438, -0.005812543758396203, 0.030907870395507145, -0.018426330279532842, -0.01097645023149005, -0.003447852240356766, 0.011001640643831242, -0.002926738623564046, 0.003910714658424941, -0.019534680482868813, -0.037381648042360126, 0.012317807092369302, 0.00558898443680342, -0.028691169988835204, 0.010850501895074286, -0.014207040520508692, -0.014836785927877705, 0.0004042173863201615, 0.025680990219866695, -0.019496896727002125, 0.016398552377484544, 0.01734316862589296, -0.02765838729723261, -0.01546653040392417, -0.03393064350800115, 0.004187802209258935, 0.005913303079454599, 0.008432281914963003, -0.006492668127802502, 0.02120980192536592, 0.024560044810360126, 0.01590735237534699, -0.0011776226731210638, -0.012185560221545691, -0.0018908085274026275, -0.015038303638671946, 0.0030715797692357025, -0.00027708766724931166, -0.015945136131213677, 0.0011673893009380917, 0.00233005539956221, 0.015554694053150693, -0.00043688538741791435, 0.00965398617986669, 0.0007482154565363034, -0.009698068470141227, 0.024144412319955948, -0.0219529004629801, 0.03599620889120634, 0.0007734052285932428, 0.013325398440308153, -0.025945482098868815, 0.01748171403112442, 0.01930797235973338, 0.006407652348796077, -0.011675467410152242, 0.007493962338317331, -0.011171671270521542, 0.006498965265226525, -0.0033754316675209377, 0.010113700029222855, -0.019295379016207887, 0.005535456207562211, -0.013413562089534677, 0.01472343186630999, -0.004427105538564964, -0.009439873262901854, -0.004735680173502898, 0.019408732146453053, 0.027356109799718697, 0.0036336271075909487, -0.006310041829280331, -0.02272118941293547, 0.0056897432922005395, 0.0037753196845505942, -0.032620775593870936, -0.028716358538531293, -0.012179262618460392, -0.0004542033884488686, 0.02474896731498377, 0.001670397890937174, -0.0033565393239263185, 0.014156661558471407, 0.006136862401047383, -0.01232410376413205, -0.010075915342033616, -0.02110904213864625, -0.01607108446762944, 0.002098624306943441, 0.02022740005844571, 0.04304934925810085, 0.028212563330223143, 0.00918167805566248, -0.007525449422421272, 0.021864735882431024, -0.011266132522833363, 0.00046168158838585233, -0.008784938374514198, -0.01678899445554753, -0.005472481573693054, -0.008262250356950152, -0.024937891682252515, 0.005063147617696726, -0.007852916400953824, -0.021663218171636783, -0.00395164814715683, 0.016297792590764873, -0.019773983812174843, 0.027935476245050425, -0.0006836665965188006, 0.005585835635260771, 0.016209629872860898, 0.009087215872028109, 0.014408559162625482, 0.020819359847302935, 0.0006301383090699321, -0.024900106063740726, -0.03519013432273918, -0.012336698970302646, 0.007204279581312741, -0.02529054814180371, -0.0036084371609110314, -0.01353951135727299, -0.0013893743381748697, -0.011606194707536512, 0.012437457825699766, -0.009912181387106063, 0.0017790288666062355, 0.01651190737037481, 0.010800122001714452, 0.01914424026745093, -0.009024241703820227, -0.005957384904067861, 0.005157609335669822, 0.01235559177955854, 0.0005266240194923566, -0.022708594206764875, -0.0006754012252999844, 0.012437457825699766, -0.006700483907343315, -0.03720531888126198, -0.010718255024250676, 0.019408732146453053, -0.014043307496903691, -0.009496550759346988, -0.006102226515400793, 0.010926071269452765, 0.025517256264939142, -0.0055386050091048595, 0.028615600614456727, -0.01884196276993702, -0.021927711913284006, -0.004669557203752367, 0.013375777402345438, -0.014307800307228363, -0.008570825457549362, -0.012588596574456722]"
7,Basketball,"[-0.012690632047445981, -0.013235320727905299, 0.01278454382467534, -0.010468049283953236, -0.0108624793071101, -0.003906736265734983, -0.01984672120698784, -0.016628671928483215, -0.0008452073338404615, -0.03546114370621974, 0.01701684160110867, -0.008583550594866863, 0.018882558307278214, -0.00308031132226499, 0.004920985229324991, -0.012621762603664865, 0.02697150488858224, -0.001668501927421761, 0.03077806995787906, -0.013873922116916576, -0.02069818848390607, -0.009766840664337455, 0.0092597159497118, -0.013047497173446583, -0.004654901239626742, 0.0005212112018132782, -0.0007254696316085098, -0.023791021438556482, -0.003049007241301437, -0.011006477613881143, 0.029751297964919723, 0.0005810800529292541, -0.01599007147079454, -0.04204750185185405, -0.02073575431238494, -0.004701857128241422, -0.011701425882965515, 0.0044295127880117635, 0.0038535193280969425, -0.007437824491229931, 0.007969992470626429, 0.022075564321011994, -0.014036702406604448, -0.01576468208785696, 0.002726576371530094, 0.0016606759071808729, 0.016753888252337427, -0.0038660409604823636, -0.019934371702363184, 0.004905332956012564, 0.003972474602927793, 0.015276340287470738, -0.03135406318496323, -0.018744821282361185, 0.01518868886077279, 0.006082362674951748, 0.0033526558953252987, 0.00588201702244631, 0.021098878857594348, -0.024053974787327726, -0.0048583770673978855, 0.011820380924965715, -0.021837654237011596, 0.0182815218154232, 0.0030396160170123713, 0.007469128572193484, -0.0020864098948859653, 0.0025293613599516617, -0.001651284682891807, 0.0071185242623855935, 0.00856476768062743, 0.022150694115324523, -0.009829448826264561, 0.006999569220385394, 0.0134732308119057, 0.011213084082579292, -0.006411054360915802, 0.010236400481806848, -0.0022695381864461235, -0.012753240209373087, 0.004125863901157251, -0.008664940739710799, -0.012058291940288717, -0.002715619826777525, 0.014186961995229503, -0.008320596314773018, -0.020372627904530326, 0.01760535552925566, 0.00411334226877183, -0.01290975921720695, 0.016478412339858164, 0.0021803219049459734, 0.017142057924962883, 0.026069951082122324, -0.016966755071566985, 0.004094559820193698, -0.01381131395498947, 0.023916237762410697, -0.018419258840340232, -0.02704663468289477, 0.006674007709687044, 0.021674872084678515, -0.039468051168392894, -0.016728844987566587, 0.0003212570540467038, 0.0015925898221234584, -0.011194302099662462, 0.006285838502722891, 0.02479274830409977, -0.030552680574941475, -0.009829448826264561, -0.007713299472386595, 0.03270639575729831, -0.05244042134149476, 0.004266732032662589, 0.007838515796240807, 0.012765760910435906, -0.013235320727905299, -0.03681347627855482, -0.012183507332820327, 0.023916237762410697, -0.004880289691241722, 0.014687825428001147, -0.015902419112773993, 0.02935060759123145, 0.006442358441879355, -0.02257642775378364, -0.00880267776462783, 0.013047497173446583, 0.001449374059168842, 0.03989378853214242, 0.010887522571880944, -0.012402635433903898, -0.0056253244898677775, -0.019446028970654363, -0.0011809424380213147, -0.01790587470650577, 0.015025908571084916, -0.018344129046027707, -0.03508549659730231, -0.011638818652361011, 0.003196135956168835, -0.011294474227423228, -0.00490220278074686, -0.011319517492194071, 0.009115717642940759, 0.027121764477207294, 0.005146373680939971, 0.00405386474777173, 0.004016300316276767, 0.025080744917641857, -0.004827072986434333, 0.016653715193254058, 0.01518868886077279, -0.010737263914578491, -0.009791883929108298, -0.019721504883133626, 0.016803974781879113, 0.004404469523240921, -0.020034544761446556, -0.00010848784179142185, -0.008890329191325779, 0.03295682467971633, -0.011976900864122179, -0.011344560756964913, 0.01311010533537369, 0.02509326748134988, 0.02352806808978524, -0.002793879796355757, -0.007250000936771216, 0.010662134120265964, 0.0027563151320301443, -0.03836615124376624, 0.020923577866843655, -0.012377592169133055, 0.0200595880262174, -0.014111832200916975, 0.00039756048946088234, -0.032155443932339774, 0.002942573831686658, -0.006038536961602774, -0.007512954285542458, 0.025168397275662405, 0.03393351014313397, -0.010668395402119975, 0.009779362296722877, 0.00879015613224241, -0.010993955981495723, 0.00530602379536214, -0.014575130736532356, 0.0198842851728215, 0.02717185100674898, 0.014600174001303198, 0.00011611818242245658, -0.6927945222370456, -0.014863127350074442, 0.014988343673928654, -0.00257005643237363, 0.0324058765800482, 0.0269464616238114, 0.016766408953400248, 0.015088516733012022, 0.008045121333616354, -0.01232750563959137, 0.019045338596966086, 0.008708765987398472, -0.005694193002326293, 0.0069745259556145515, 0.0025387523514100773, -0.040820383740727974, 0.016290588785399445, -0.012064552290820128, -0.008984240968555136, 0.004586032261506927, -0.0002451492545866318, 0.017379968008963284, 0.0014572000794097302, -0.0017671094332109773, 0.016691279159087722, 0.004085168828735283, 0.016703801722795744, 0.00230866817123524, -0.0017232838362773284, 0.007444085307422642, -0.016015114735565383, 0.003900475449542272, -0.00013597665057604787, -0.022876945068388544, 0.0476571745340707, 0.003618739652192897, -0.007901123958167913, 0.04577893526419313, 0.020848448072531126, 0.036838517680680465, 0.013009932276290319, 0.00588201702244631, -0.002559100120451712, -0.005105678608518002, -0.023941281027181537, 0.018331608344964886, -0.0010173792552710392, -0.01437478554968822, 0.028549226843854903, -0.03182988335296403, 0.0032587438852652905, 0.013748705793062364, -0.0024949268708917534, -0.0037971722151931976, -0.01745509780327581, 0.0068054843840726666, 0.0076757350408916325, 0.0036594347246148655, -0.005919581919602574, -0.0038284762961567505, -0.030953370948629752, 0.023540590653493263, -0.02107383745546871, -0.02739724038968656, -0.0004942115192937077, 0.0007857298128403614, -0.03643782916963739, 0.024730141073495266, 0.009015544583857388, 0.011557427576194471, -0.00673661540595285, 0.016152851760482416, -0.004276123024121004, 0.0014196352986687918, 0.041646809615520565, 0.008877807558940357, 0.011344560756964913, -0.018168828055277014, -0.0008827721145813998, -0.006730354589760139, -0.005960276992024542, -0.002782923484433839, -0.005421848662096635, -0.018118741525735328, 0.01634067531494113, 0.0005262980858660242, -0.03280656509109127, 0.011394647286506599, 0.005687932186133583, -0.0060134936968319315, 0.029200348002606395, 0.018369172310798546, -0.001063552600069292, 0.006636442812530782, -0.004138385533542672, 0.003097528450379619, -0.02008463129098824, 0.009553973845107897, 0.008909111174242609, -0.014249570157156609, -0.01028648608002593, 0.013986616808385366, -0.01448748024115701, -0.010480570916338658, 0.004344992002240821, 0.008646157825471366, 0.013560882238603647, 0.007250000936771216, 0.02922539126737724, -0.015363991714168686, 0.010223878849421426, -0.022751728744534332, -0.017893352142797747, -0.012746978927519076, 0.022188258081158183, -0.03203022947113077, 0.014762955222313674, -0.01404922403898987, 0.04397582392598289, -0.025794475169643057, 0.010987695630964312, -0.006116796931181006, 0.026670987573977338, 0.020159761085300768, -0.014274613421927452, 0.008721287619783894, 0.0045829020862412214, -0.019433508269591542, -0.02524352520732973, -0.010067358910264963, -0.006880613712723892, -0.0005740366347124546, 0.01794343867233943, 0.0007978600569022442, 0.04272366441273118, 0.009159542890628432, -0.0057067146347117145, -0.0029754430002830634, 0.024291884871328127, -0.004814551354048911, -0.01496330040915781, 0.012527850826435507, 0.008489637886314903, 0.0031131804908613955, 0.014161918730458661, -0.020648101954364388, -0.016015114735565383, 0.0039223880733861086, 0.0011285082770303512, 0.011206823732047882, 0.008527202783471166, -0.012759500559904498, -0.013886443749301997, 0.016879104576191642, 0.03588687734467886, -0.026871333692144075, -0.010355355523807048, -0.010205095935181993, -0.013636012032916174, -0.015501728739085717, 0.01885751504250737, -0.009954664218796172, -0.04370034987614883, -0.007137306710963726, 0.005659758746097036, -0.015802247916335825, -0.02088601203836479, 0.0064016629037960855, -0.01061204759072428, -0.017705528588339032, 0.009867012792098223, 0.000639775030112928, -0.005894538654831732, 0.012033248675517874, -0.0005290371638465037, 0.02240112490038774, -0.01677893151710827, -0.013335493786988669, 0.011332039124579493, 0.014838084085303599, 0.011494820345589967, -0.02910017680616823, -0.029025047011855702, -0.002678055162451912, 0.00026471424698118977, 0.009917099321639908, 0.020923577866843655, 0.04006908952289311, -0.009184586155399273, 0.008439552288095821, -0.02437953722934868, 0.01302245390867574, -0.006792962751687245, -0.0009054675150723131, 0.027898103822458206, -0.003984996235313214, -0.003997517867698635, 0.004075777837276868, 0.009641624340483244, 0.009754319031952036, 0.03638774264009571, -0.0119894224965076, 0.0134732308119057, -0.0011684209220512187, 0.011025260528120577, -0.02103627162698984, -0.002422927717506232, -0.018794907811902867, 0.023503024825014398, 0.0016919798717291007, 0.021174008651906873, 0.0013030280045331953, 0.006154361828337269, 0.008633636193085945, 0.00017540008929632365, 0.018306565080194043, 0.00271248941868117, -0.0015738073735453266, 0.017830744912193244, -0.011275692244506398, 0.0170919713954212, -0.019596288559279414, 0.0010604221919729366, -0.008433291006241808, -0.010687177385036805, 0.02202547779147031, -0.010812393708891019, 0.018431781404048254, 0.009065631113399074, -0.028323837460917323, -0.00048012474106777145, -0.0034340460401692356, 0.009297280846868065, 0.004363774450818952, 0.0032023967723615455, -0.011156737202506197, 0.0344844582428021, -0.0005767757709005968, 0.031504322773588285, 0.009222151052555538, 0.0049397672122418225, 0.018669691488048656, 0.0040914296449279935, -0.0014587652834579079, 0.02910017680616823, -0.022288431140241552, 0.016966755071566985, 0.007700777840001174, 0.006229491156988495, 0.005090026335205575, -0.020109674555759082, 0.015739638823086117, -0.010975173998578891, -0.00034571329453990125, 0.013535838973832806, -0.03077806995787906, -2.3539122379755285e-05, 0.002759445540126499, 0.012408895784435306, 0.028173577872292268, 0.010655873769734554, 0.004620466983397485, 0.01779317908371438, -0.002117713975849518, 0.007224957672000373, -0.01930829194573733, 0.0012709413797532163, -0.010098662525567214, -0.02103627162698984, 0.0018109350301446262, -0.026771160633060707, -0.005894538654831732, -0.004147776990662389, 0.005788105245216953, -0.001373461953870539, 0.02099870766115618, 0.008627375842554536, -0.010718481000339059, 0.001594155026171636, 0.01750518247017229, -0.00016816104967733332, -0.01984672120698784, 0.02366580511470227, -0.007318869449229731, -0.012377592169133055, -0.024166668547473916, 0.009215890702024127, -0.006987047587999972, -0.007732081920964727, 0.036913649337638195, -0.009516408947951634, 0.01583981188216949, 0.0029269217912048814, 0.010655873769734554, -0.0009172064872259828, 0.016966755071566985, 0.016753888252337427, 0.005230894466710914, 0.002321189803620661, -0.004088299469662288, -0.0027688367644155653, -0.0028564877254522126, 0.0036688259489039312, -0.009328584462170317, 0.046254755432193935, 0.02081088224405226, -0.006661486077301624, -0.03260622269821494, -0.007757125185735569, -0.03105354400771312, 0.015464163841929454, -0.014362263917302798, 0.007368955978771415, -0.002363450196506132, 0.002095801119175031, -0.011056564143422829, -0.02386615123286901, -0.017743094416817897, 0.013861400484531154, 0.014061745671375291, -0.017718051152047054, 0.0026013602805065325, 0.004989853741783507, -0.011037782160505997, 0.10678412335499271, 0.018844994341444554, 0.01313514860014453, 0.029601040238939873, -0.028649398040293067, 0.014449915344000745, -0.009172064523013853, -0.0021584090482714862, -0.012559155373060361, -0.00020621493485545368, 0.005922712094868278, -0.014074267303760712, 0.0054468919268674774, 0.0018594561228074827, 0.014750433589928252, 0.013410623581301195, -0.00672409423922873, -0.03235579005050652, 0.026345425131956385, 0.00023027987433660673, 0.0020973664396385337, -0.01617789502525326, 0.013999138440770787, 0.024104061316869412, 0.022964597426409092, -0.016941711806796145, 0.022588948454846457, 0.0005912538210347461, 0.009422497170722277, -0.032631264100340576, -0.014362263917302798, -0.0008538159561054386, 0.011501080696121378, 0.015113559066460263, 0.01120056245019387, -0.014787998487084515, 0.030227118132920526, 0.020961141832677315, 0.025844561699184743, -0.008170337657470566, 0.03829102331209892, 0.03025216139769137, 0.021499571093927826, -0.007350173530193284, 0.011006477613881143, -0.011069085775808249, 0.006223230340795785, 0.019934371702363184, -0.0032023967723615455, -0.004704987769168428, 0.008251727802314502, 0.004207254511662489, -0.0168540613114208, -0.010643352137349134, -0.015138602331231106, 0.005036809630398186, -0.0034058726001326882, -0.001245115687581273, -0.007431563675037221, -0.032105357402798095, -0.0189326448368199, -0.014525045138313273, 0.013761227425447784, 0.006041667136868479, 0.005675411019409463, -0.02091105530313563, -0.021912782168678917, -0.020259932281738932, -0.003906736265734983, 0.00011670513394052318, 0.0075066934693497475, -0.02554404438457984, -0.010305268994265364, -0.003675086765096642, 0.027522454850895568, -0.0040914296449279935, 0.01610276523094073, 0.008170337657470566, -0.00880267776462783, 0.014111832200916975, -0.013398101948915775, -0.006893135345109313, -0.012640545517904297, -0.01538903497893953, -0.005503238806940571, 0.007143567061495135, 0.0051244610570961345, -0.004780117097819654, -0.03185492475508967, -0.007462867756000774, -0.010317790626650784, -0.017880831441734926, 0.030903284419088066, -0.009610320725180992, 0.010649612487880543, -0.015464163841929454, 0.018832471777736528, -0.0016825886474400348, -0.00731260863303702, 0.01243393904920615, -0.006548791851494134, -0.023465460859180737, 0.016490934903566186, 0.016265545520628606, -0.001191898866358558, 0.003224309396205382, 0.019007774631132426, 0.028799657628918122, 0.0010799871843674947, -0.0024777097427771248, 0.005938364368180705, -0.027347153860144878, 0.020009501496675713, -0.0032524830690725797, -0.004676813863470579, -0.0014751998677561104, 0.0006409489040452299, 0.0034027421920363333, -0.00810772949554346, -0.011044042511037407, 0.016816495482941934, -0.011576210490433905, 0.009253455599180392, -0.0021318006958677914, -0.012602980620748034, -0.01999697893296769, 0.013761227425447784, -0.04415112864202399, -0.004460816403314015, 0.0068117452002653765, 0.007437824491229931, 0.012527850826435507, -0.01254663374067494, -0.0007415129439984993, -0.0340086380748013, -0.015539293636241982, 0.001582415937602641, 0.004463947044241021, 0.016428325810316478, -0.03906736265734982, -0.012408895784435306, 0.006686529342072466, 0.007037133651880356, 0.0003650826218765214, -0.006843049281228929, -0.019558724593445754, -0.013573403870989069, 0.010912565836651785, -0.014775476854699095, 0.01016127068749432, -0.024842834833641456, 0.02271416477870067, -0.012421417416820728, -0.01806865499619364, -0.012872195251373288, 5.24830736174689e-05, -0.01794343867233943, -0.007080959365229331, 0.020835925508823103, 0.027647671174749783, 0.012133420803278642, 0.008283032348939356, 0.022651557548096165, 0.0015166776004098303, 0.004200993695469778, 0.01462521726607404, 0.006930700242265577, -0.007951209556386996, -0.0005255154838419354, 0.018895079008341035, 0.023540590653493263, 0.008733809252169315, 0.007062176916651198, 0.009115717642940759, -0.01185168547159057, 0.0010862480005602053, 0.012947324114363213, -0.008715027269252485, -0.021436962000678118, 0.003506045193554757, -0.008063904247855786, -0.01813126222679815, -0.0010604221919729366, -0.004573511094782806, -0.007656952592313501, -0.018093698260964484, 0.02437953722934868, -0.01311010533537369, -0.010962652366193471, -0.01038039878857789, 0.018607082394798947, -0.018043611731422802, 0.005628454665133483, -0.007794690082891833, -0.011588732122819325, -0.01152612396089222, -0.028123491342750582, -0.010555700710651185, -0.01245898231397699, -0.0011676382618194673, 0.0033495254872289437, -0.00200032402148217, -0.002989529720301337, 0.0034841325697109204, -0.003556131723096442, 0.030402420986316424, -0.03333247178863376, -0.01679145221817109, -0.00674287622214556, -0.009616581075712402, -0.008420769373856387, -0.023465460859180737, -0.02123661774515658, -0.052039729105161275, 0.01565198832771077, 0.0219002614676161, -0.00968545051949352, 0.02889983068800149, -0.008940415720867463, -0.002466753198024556, -0.0019471073166747806, 0.00016307415107267163, 0.03358290443634218, 0.0011034651286748341, 0.037664943555473056, 0.03979361547305905, -0.005187068753361939, -0.03097841421340059, 0.015176167228387369, 0.01599007147079454, -0.013836357219760311, 0.009785622647254287, 0.004820812170241622, -0.000989988242635593, -0.008815199397013251, 0.006226360981722791, 0.019596288559279414, -0.02697150488858224, -0.028248707666604794, 0.032105357402798095, 0.016353197878649153, -0.011350822038818925, -0.013398101948915775, -0.014136875465687818, 0.0024636227899282005, 0.02639551166149807, -0.02980138449446141, 0.005055592078976318, -0.02407901805209857, -0.035786704285595494, -0.012609241902602045, 0.035335929245010736, -0.01496330040915781, 0.0006456445161897628, 0.0003136266988637534, -0.0001941824796667928, 8.016752199418038e-05, 0.007901123958167913, -0.01040544112202613, 0.005299762979169429, -0.012515329194050085, 0.02942573738554398, 0.004977332109398086, 0.004366904626084658, 0.028499140314313217, 0.021023750925927023, -0.004360643809891947, -0.0064016629037960855, 0.004830203627361338, 0.02144948456438614, 0.00765069177612079, -0.00845207392048124, -0.013848878852145733, 0.021599744153011195, 0.00752547591792788, 0.01448748024115701, -0.016040158000336226, -0.012202289315737158, -0.020685667782843253, -0.0003200831510105705, 0.011920553984049084, -0.009760579382483444, -0.007575561981808263, -0.015351470081783265, 0.0004100820927424722, 0.0014814606839488212, -0.020234890879613294, -0.020648101954364388, 0.0003410176823953683, -0.04019430398410212, -0.023227550775180336, -0.02002202219773853, 0.020272454845446954, 0.01381131395498947, 0.0020644972710421286, -0.013711141827228702, 0.012984889011519478, 0.031003457478171435, -0.030277204662462212, 0.014362263917302798, -0.028123491342750582, 0.004877159515976018, -0.01302245390867574, 0.020723231748676914, 0.012709414030362813, -0.013085062070602846, 0.02382858726703535, -0.008871547208408949, -0.005068113711361739, -0.010493092548724079, 0.001975280989541978, 0.014950778776772389, -0.005199590385747361, -0.0015816333937862148, 0.041296203908728776, -0.0034841325697109204, -0.0058037570528680785, -0.02441710119518234, -0.028148534607521425, 0.014424872079229904, 0.00014155266816980725, -0.007281304552073467, -0.0007117741252907866, -0.023127377716096967, 0.01760535552925566, 0.016653715193254058, 0.022801815274076015, 0.005262198547674467, -0.036838517680680465, -0.013435666846072038, -0.02385362866916099, 0.014950778776772389, -0.006157492003602974, -0.0065300094029160025, -0.013673576930072439, 0.001724849040325506, -0.007606866062771816, 0.017718051152047054, -0.018719778017590342, 0.010474310565807249, 0.02144948456438614, 0.0021803219049459734, 0.014950778776772389, 0.01950863806390407, -0.019345857774216196, -0.002804836341108326, -0.0034340460401692356, -0.011895510719278241, -0.03010190367171152, 0.004010039500084057, 0.004197863054542773, 0.032481004511715525, 0.006586356282989096, -0.03771503008501474, -0.006242012789373917, 0.006442358441879355, -0.03305699773879969, -0.023277637304722022, -0.0051088087837837075, 0.003255613477168935, -0.009015544583857388, 0.0024542317984697854, 0.0026060560090663907, 0.013936530278843682, -0.00604792795306119, 0.00570358445944601, -0.01987176447175868, 0.0023650152841389843, 0.0166787584580249, -0.01610276523094073, -0.012984889011519478, -0.008514681151085746, -0.00030227902772212806, -0.011551167225663062, 0.021812610972240753, -0.007462867756000774, 0.009409975538336855, 0.012734457295133655, 0.015376513346554108, -0.013498274076676541, -0.01586485514694033, 0.011544905943809051, -0.01942098570588352, 0.023941281027181537, 0.002717185147241028, -0.015777204651564986, -0.006407923719988796, 0.005637846122253199, -0.021411918735907275, 0.0015041560844397343, -0.01552677200385656, -0.008082686230772617, -0.0022351039302168658, 0.003218048812843322, -0.006911917793687446, -0.0016231111264399347, 0.01118178046727704, -0.0026937072029336886, -0.018920122273111874, 0.033607949563758226, -0.012521590475904096, 0.009265977231565813, 0.0025810127442955485, -0.017880831441734926, 0.0028079665163740306, -0.010355355523807048, -0.028248707666604794, -0.014787998487084515, 0.0011457255215603054, -0.01130699585980865, 0.019208118886653962, -0.016265545520628606, 0.011519862679038208, -0.00639853272853038, -0.016541021433107872, 0.005212112018132781, 0.003205527180457901, -0.011820380924965715, 0.005957146816758838, -0.010111184157952636, -0.026570814514893966, 0.007832254514386796, 0.001798413397759205, -0.005572107785060388, -0.0010768567762711393, -0.023690848379473113, 0.022150694115324523, -0.019621331824050257, -0.02614508087643485, 0.015914941676482015, -0.015326426817012424, -0.006504966138145159, -0.032856651620632955, 0.015564336901012823, -0.007732081920964727, 0.03756477049638969, 0.22278413834333216, -0.028073404813208896, -0.0036500435003257994, 0.03012694693648236, -0.0024683185184880586, 0.014299655755375692, 0.027221937536290666, -0.016015114735565383, 0.0042917752974334315, -0.005850712941482757, 0.007275044201542058, 0.009716754134795771, -0.02852418357908406, -0.0024542317984697854, -0.001056509240060155, 0.009316062829784895, -0.027998276881541575, -0.029901557553544778, -0.016803974781879113, -0.016328154613878314, -0.002911269750723105, 0.02042271443407201, 0.013873922116916576, -0.023778500737493664, 0.03621243792405461, 0.0071686103262659775, -0.006855570913614351, -0.00171232752435541, 0.0008397291778795024, -0.010893783853734955, -0.010061097628410951, 0.0012967671883404848, 0.011551167225663062, -0.014474958608771588, -0.023240071476243154, 0.004266732032662589, -0.005158895313325392, -0.009071892395253085, -0.0002844748753298543, 0.009253455599180392, -0.016278068084336628, -0.006301490310374017, 0.020936098567906472, 0.005797496236675368, 0.0030458768332050816, 0.037815203144098114, -0.012170985700434907, 0.006592617099181807, 0.021161487950844056, 0.016578585398941532, -0.02018480435007161, 0.01061204759072428, 0.00957275582802473, 0.031879969882505715, -0.016478412339858164, -0.004704987769168428, -0.005018027181820054, 0.021599744153011195, -0.0014658086434670445, 0.017705528588339032, -0.011776555677278042, 0.02809844807797974, -0.0064736620571816065, 0.040294477043185485, -0.02134931150530277, 0.021274181710990242, -0.019020295332195247, 0.021261661009927425, 0.008401987390939556, 0.007049655284265778, -0.0042917752974334315, -0.018882558307278214, 0.0018829341835301474, -0.007951209556386996, -0.013949051911229103, -0.027347153860144878, 0.04785751692694703, 0.004495251125204575, 0.0003740825160497115, 0.009265977231565813, -0.010186313952265163, -0.007888602325782493, -0.010192574302796572, -0.01414939709807324, -0.014474958608771588, -0.018093698260964484, 0.002375971828891553, -0.0092597159497118, -0.0071686103262659775, 0.011112911023495922, 0.019583767858216597, -0.011018999246266564, -0.0027766626682411283, 0.0024542317984697854, 0.020485321664676513, 0.012152203717518075, 0.007544258366506011, 0.027497411586124728, -0.0189326448368199, -0.014650260530844884, -0.00969797215187894, 0.0341839427908424, 0.026445598191039754, -0.014875648982459862, -0.009435017871785096, -0.02396632429195238, -0.006536270219108712, 0.0009383366836687184, -0.0055126302640602885, -0.007794690082891833, -0.021399398034844454, -0.03165457863692293, 0.010668395402119975, -0.016829018046649956, -0.004701857128241422, -0.018193871320047857, 0.00970423250241035, -0.0016622411112290506, -0.004445164595662889, -0.012815847439977593, -0.015852332583232306, -0.005086896159939871, 0.017880831441734926, 0.005922712094868278, -0.011945597248819927, -0.011119172305349935, -0.016390761844482817, 0.013322972154603248, 0.008977980618023728, -0.01120056245019387, 0.0004069516846461169, -0.006191926259832232, -0.010374137506723878, -0.013322972154603248, 0.0031335280270723795, -0.0027719671725119207, 0.006661486077301624, -0.005115069599976418, -0.009409975538336855, -0.0024260581256025874, -0.004435773604204474, -0.021098878857594348, 0.01859456169373613, 0.019446028970654363, 0.010111184157952636, -0.0214870485302198, 0.013160191864915374, 0.012271158759518275, 0.0020347585105420785, -0.012183507332820327, -0.019245684715132827, -0.021862697501782435, -0.007550519182698722, -0.03318221592529911, 0.0076757350408916325, -0.011056564143422829, 0.006238882614108212, -0.008508420800554336, -0.016140329196774394, 0.03310708426834138, -0.017592834828192842, 0.011238127347350135, 0.00479576890547078, -0.004601684534819353, -0.0053498495087111134, -0.026195167405976535, -0.15977548534557479, 0.009948403868264762, 0.024392057930411496, -0.014900692247230705, 0.01153864559327764, 0.006536270219108712, -0.008257989084168514, 0.011044042511037407, 0.001257637203551369, -0.005637846122253199, 0.0035592621311927967, 0.011012738895735156, -0.026670987573977338, 0.005872626030987895, 0.014913213879616126, -0.018844994341444554, 0.004651770598699737, 0.010749785546963913, 0.03686356280809651, -0.004100820636386409, 0.024367014665640653, -0.03198014294158908, -0.0022491906502351395, 0.0012145942668494714, -0.0008162511753645003, -0.01768048532356819, -0.002169365593024055, 0.01369862019484328, -0.014950778776772389, -0.00034062638138332386, -0.028549226843854903, 0.005343588692518403, -0.011012738895735156, 0.012133420803278642, -0.00980440556149372, 0.007656952592313501, 0.011056564143422829, 0.00811399077739747, -0.001363288185765047, 0.022551384489012796, 0.012947324114363213, 0.028824700893688965, -0.031203803596338175, 0.005481326183096736, -0.015752161386794142, 0.006076101858759037, 0.021912782168678917, 0.008251727802314502, 0.01881995107667371, -0.01994689426607121, 0.004870898699783307, -0.024629968014411897, -0.0006061232594924338, 0.010449267301036406, 0.03230570352096483, -0.005158895313325392, -0.02754749811566641, 0.003625000468385608, -0.010893783853734955, -0.0020848448072531126, -0.006548791851494134, -0.02809844807797974, 0.0033401342629398776, -0.030352334456774738, -0.03794041760530712, -0.019320814509445353, -0.0255816083504135, 0.004445164595662889, -0.012452721963445582, 0.0015753725775935043, -0.006235751973181206, -0.018757341983424002, 0.022664078249158986, 0.003972474602927793, 0.005296632803903724, 0.01106282542527684, 0.000582253926861556, 0.03836615124376624, 0.0034747413454218543, -0.006523748586723292, -0.007106002630000173, 0.034509503370218145, -0.014762955222313674, -0.029901557553544778, 0.01212089917089322, 0.030502594045399792, -0.0014141571427078326, 0.014299655755375692, 0.01705440556694233, -0.015326426817012424, -0.00388169300096414, -0.024341971400869813, 0.002327450619813371, -0.011507341977975389, 0.014512523505927851, 0.028348880725688162, -0.013435666846072038, -0.008952937353252885, 0.01671632242385856, -0.010261442815255088, 0.02409154061580659, 0.005086896159939871, -0.01897020880265356, 0.012221072229976591, 0.030903284419088066, 0.010155009405640309, 0.03914249058901715, 0.0006452531860738871, 0.021862697501782435, -0.012371330887279043, 0.009353627726941158, 0.005215242193398487, 0.015000865306314073, 0.0200595880262174, 0.0034183942325181097, 0.016015114735565383, 0.01084995767472468, -0.015251297022699896, 0.02707167794766561, -0.005237155282903624, 0.04242314896077148, -0.012646805868435708, 0.0026326643614700855, 0.026470641455810597, 0.011125432655881343, -0.005249676915289045, -0.0641606320013449, -0.02910017680616823, 0.006210708708410364, 0.020485321664676513, 0.005321676068674567, 0.017192142591859364, -0.032781523688965634, 0.026996548153353082, 0.014988343673928654, 0.03125389012587986, -0.016641192629546036, -0.02544387132549647, -0.018444302105111075, 0.005418718021169629, 0.026470641455810597, 0.003825345888060395, 0.007018351203302224, -0.012296202024289118, 0.0011394647053675948, 0.0063609678313741175, -0.0014337221351023908, 0.012233593862362013, -0.012308723656674538, -0.00833311794715844, -0.0017326750605663943, -0.012052030658434706, -0.0242167550770156, 0.032781523688965634, 0.020460278399905673, -0.0013914617422169195, -0.019558724593445754, -0.008502159518700324, -0.006442358441879355, -0.02489292136318314, -0.0027187502348738806, -0.019107947690215794, -0.02659585777966481, -0.008808939046481843, 0.023002161392242756, -0.027347153860144878, 0.0005212112018132782, 0.005199590385747361, 0.0027625759482228546, -0.039943871336393696, 0.011432212183662862, -0.015702074857252456, -0.022050521056241154, 0.016866582012483616, 0.03270639575729831, -0.026771160633060707, -0.016478412339858164, 0.003318221406265391, -0.020723231748676914, -0.010580743975422028, -0.002458927294198993, -0.004307427105084557, -0.004805160362590496, -0.0038409979285421716, -0.013949051911229103, 0.002410406085120811, 0.002521535223295448, 0.02329015800578484, -0.006730354589760139, 0.029175304737835552, 0.019896807736529524, 0.025393784795954784, -0.02154965762346951, -0.012026987393663863, 0.012947324114363213, -0.031504322773588285, -0.007212436039614952, 0.03213040253021414, -0.024905443926891164, 0.008946676071398874, -0.017179621890796543, -0.018945165537882717, -0.027822974028145677, 0.006123057747373716, 0.03170466516646461, -0.013999138440770787, -0.019233162151424805, -0.019771591412675312, 0.009491365683180791, -0.013085062070602846, 0.015476685474314876, 0.01028022572949452, 0.01209585590612238, 0.00416655897357922, -0.001211463858753116, 0.017367445445255262, 0.003067789689879569, 0.024955530456432846, 0.015952505642315675, -0.03105354400771312, 0.00508063534374716, 0.0033589167115180094, 0.007857297779157639, -0.024742661774558087, -0.0044795988518921475, 0.03328238525909207, -0.00010320529268073793, -0.007919905941084745, -0.08865285926554936, 0.005146373680939971, 0.01348575244429112, 0.00968545051949352, 0.0010111184390783287, -0.00752547591792788, 0.014249570157156609, -0.009848230809181393, 0.008683722722627631, -0.0009281628573555638, -0.02762262790997894, 0.0014235482505815732, 0.019959414967134027, -0.026996548153353082, -0.005215242193398487, -0.014500001873542431, 0.023014683955950778, 7.356434288178331e-05, -0.0012638980197440795, -0.0009477278497501217, 0.0018704125511447263, 0.02992660081831562, 0.0054155878459039245, -0.0038222154799640398, -0.02315242098086781, -0.016829018046649956, 0.0017968481937110274, 0.03731433784868127, -0.02056045145898904, -0.018081175697256462, 0.01994689426607121, -0.000448429446403668, -0.0018547605106629499, 0.02622021067074738, 0.0016371979628735335, -0.026670987573977338, -0.011707687164819526, 0.017855788176964083, 0.012026987393663863, 0.012427678698674739, -0.019496115500196046, -0.033082042866215744, -0.014061745671375291, 0.000783773278676308, -0.014587652368917776, 0.011933075616434505, -0.008589810945398272, 0.003097528450379619, -0.00423229731077203, 0.005237155282903624, -0.021612264854074012, 0.013235320727905299, 0.01212089917089322, -0.029275477796918924, -0.004416991155626342, -0.036462870571763034, 0.013210277463134456, 0.009754319031952036, 0.00992962095402533, -0.005396805397325792, 0.022826858538846858, 0.024592404048578237, 0.007656952592313501, -0.009735536117712601, 0.016979275772629806, 0.006755397854530981, -0.02409154061580659, 0.02965112676848156, -0.008652419107325377, 0.008577289313012852, -0.016691279159087722, 0.00271248941868117, 0.0064987053219524495, 0.0027062286024884595, -0.005678541194675167, -0.00012638980488479109, 0.0008162511753645003, 0.01907038186173693, -0.018895079008341035, 0.03866667042101635, -0.0051808079371692285, 0.00041908198691566233, -0.01288471688375871, -0.005218372834325492, 0.015376513346554108, 0.01689162527725446, -0.02089853460207281, 0.019596288559279414, -0.013823835587374891, 0.00208327948678961, -0.010912565836651785, 0.012959845746748635, -0.021023750925927023, 0.0006022102493719897, 0.005631585306060488, 0.02822366440183395, -0.003972474602927793, 0.00048677682916869515, 0.022088085022074815, 0.0022664077783497685, -0.0002791923262191704, -0.012083334273736958, -0.007281304552073467, -0.020009501496675713, -0.01588989841171117, 0.020072108727280217, -0.023540590653493263, -0.032155443932339774, -0.022676600812867008, -0.0006859483749111807, -0.0028392705973375836, 0.001677893151710827, -0.0017874569694219615, 0.014161918730458661, 0.007494171836964327, -0.009579016178556138, 0.0036844779893857077, -0.014938257144386968, -0.013748705793062364, 0.023803544002264507, 0.018081175697256462, 0.027522454850895568, 0.00934736737640975, -0.0006706876645452799, 0.012408895784435306, 0.02390371519870267, -0.005437500469747761, -0.009716754134795771, -0.009829448826264561, -0.03746459743730632, 0.015739638823086117, -0.02206304175730397, -0.01414939709807324, -0.0006710789946611557, 0.0037783897666150658, -0.0046235971586631895, -0.0012286811032830702, 0.024053974787327726, 0.001452504467265197, 0.015702074857252456, -0.001313984432870439, -0.006855570913614351, 0.011400907637038007, 0.022100607585782837, 0.01794343867233943, 0.0020284976943493677, 0.006004102705373516, -0.02407901805209857, -0.02935060759123145, 0.003775259591349361, 0.007224957672000373, -0.021061314891760684, -0.009622842357566413, -0.020109674555759082, -0.007769646818120991, -0.009391192624097423, -0.007681995857084343, 0.004304296464157552, 0.0034841325697109204, 0.018218914584818696, 0.008702505636867064, 0.044276343103232994, 0.011450994166579692, -0.010812393708891019, 0.001616850310247224, 0.010987695630964312, 0.0033088301819763247, -0.012239854212893421, -0.02257642775378364, 0.0002220625821875054, 0.005647237113711614, -0.03621243792405461, -0.028348880725688162, 0.031955097814173036, -0.022351038370846055, -0.009397453905951434, -0.013686098562457859, 0.009535190930868465, 0.026019864552580638, -0.00879015613224241, 0.01769300788727621, -0.023240071476243154, -0.027021591418123925, -0.01128821387689182, -0.0061418401959518485, -0.017417531974796945, -0.01565198832771077, -0.006129318563566427]"
8,Apple,"[0.014517220425915257, -0.003906639012518288, -0.002638094019507123, -0.037909118394512706, -0.005830855385431883, 0.01898195125812051, -0.017749356948009623, -0.016913932619267113, 0.02015976330914832, -0.015092431352319703, 0.004817389180330684, 0.023611027004929754, 0.0072586102129576285, 0.004440763244610425, -0.021638876853810433, -0.004526359709520441, 0.02636382108835375, 0.01629763546421167, 0.01643459018059674, -0.029664434037318034, -0.02784293463301586, 0.0037559884985317914, 0.013989944674700468, -0.010449659575078379, 0.004718096684988589, -0.006964157200200676, -9.96667997233561e-05, 0.0006638033397638142, 0.014366570610420725, -0.011860295761547955, 0.025090140549591865, -0.005163199978901383, -0.027281417874398257, -0.0038587047686512504, -0.024624494141353575, -0.01795478995390985, -0.010976936257615788, -0.015558077760557995, 0.014339179480879186, -0.009422498270867719, 0.010401725331211342, 0.020433672741918464, -0.005221406245592479, 0.01629763546421167, -0.01279158857802454, 0.03377308111680591, -0.02170735328068035, -0.0010400013327407332, -0.005152928421738634, 0.027815542572151707, -0.007203828419535862, -0.01094269711285821, -0.014188528734062036, -0.00017237060182341974, -0.004300384054956024, -0.0016999528385685163, -0.009011633190389884, 0.006245144007856428, 0.002252908297597471, 0.008176207930324754, 0.01395570552994289, 0.008929460733087887, -0.032540486806695024, 0.016749585842017883, -0.011305627949469007, 0.0072586102129576285, -0.015585468890099532, -0.007333935586366204, 0.008840439329247234, 0.019735203129561025, 0.0430312326104244, 0.008545986782151592, 0.017146755823386258, 0.018091744670294924, 0.003906639012518288, 0.01609220245831144, -0.03640261465163168, -0.009977165151624046, 0.006628617958792726, 0.018078048639862843, 0.010045642509816584, -0.026103605823370447, 0.019447597666358802, 0.019598248413175954, 0.027884020861666862, 0.006957309650645946, -0.029993125729171257, 0.01635241586064951, -0.0034204490242931863, 0.005286459596176995, 0.009703255718853903, 0.009805971290481398, -0.0024942912879060116, 0.01743436128658848, -0.01659893509520073, 0.02536404998236201, -0.01698240904613703, 0.034238727525044206, 0.013551688464681093, -0.03440307243964819, 0.005262492474243477, 0.003398193673333023, -0.03226657737392488, -0.009189675066748573, -0.005913028308395189, 0.006967581207808695, 0.025103834717378707, -0.005461076999266355, 0.00453320772473648, -0.016407198119732583, -0.004742063806922108, 0.00454005527429121, 0.033553952080473605, -0.03985388021005835, -0.017091973564303184, -0.02183061382927858, -0.020789756494635842, -0.004187396460504471, -0.0075941499200268886, -0.029965735530952338, 0.03193788381942642, 0.0225427794720681, 0.035553494292457084, -0.013038107812575764, 0.015695032476943066, 0.001731623628374097, -0.016612631125632812, -0.00838164093622498, -0.0007660915507246069, -0.008819896214921736, 0.039114324369049915, -0.002502851074095406, 0.022570169670287018, 0.017790443176660623, 0.006495086784354363, 0.01495547663593463, -0.01696871301570495, 0.031061373262032912, -0.003264662731725316, -0.03363612826306608, 0.008306315562816406, 0.01695501884791811, -0.021118448186489062, 0.020214545568231396, -0.009388259126110141, 0.009607387231119828, 0.014736348530924943, 0.028678358961758372, 0.014133747406301578, 0.015243082099136853, 0.023419290029461606, -0.016886540558402954, -0.006772420224732527, 0.0003616465718233041, -0.00026642011461956537, 0.0014928085273562437, -0.005330969832436013, -0.007826973124146035, 0.006251991557411158, -0.007183285305210362, -0.0037354451513756377, 0.005858246514973422, -0.02669251278020697, 0.0013618453586238966, 0.005663085531897253, 0.02187170005792958, 0.012825827722782117, 0.012045184721800063, -0.01596894190971321, -0.0004545191111080248, -0.02624056053975552, -0.0016426030394407346, -0.012784741494131118, -0.000533696172933472, 0.0030078721728419963, 0.01696871301570495, 0.0004459594413339578, 0.013811902798341779, 0.004105223537541166, -0.007320240021595434, 0.007539368126605121, 0.003394769898555658, 0.01331201724534591, 0.023939718696782977, -0.007087416817476288, 0.01894086502946951, 7.115235686034343e-05, -0.017064581503439025, 0.011558994267913653, -0.01932433898040581, 0.01225746481159371, 0.007210675969090591, -0.004841356302264202, -0.014722653431815483, -0.6700929721218482, -0.025980347137417453, -0.015092431352319703, -0.002889748566978413, 0.020255631796882393, 0.029691824235536953, 0.01883130051130336, 0.006851169605749123, -0.019543466154092876, 0.0004707825069618176, 0.006286230702168736, 0.013544840449465054, 0.018680649764486208, 0.008895221588330312, -0.0017530228610169282, -0.023104294368040464, -0.0008658118141870485, -0.023104294368040464, -0.022268868176652717, 0.026281648631051754, -0.008333706692357943, -0.019584552382743876, 0.0017521668591149234, -0.01695501884791811, -0.006881984277237371, 0.007436651623655008, 0.021638876853810433, -0.021899090256148498, -0.0225427794720681, 0.02381646001082998, -0.010887915785097752, 0.0047044011202178205, 0.018612173337616292, 0.007375021815017201, 0.03799129457710518, 0.008703484612862163, -0.03705999803533812, 0.01802326638077977, 0.014859608148200556, 0.04215472391567613, -0.015023953994127166, -0.01225746481159371, 0.0245286256536195, -0.0110591096462404, -0.01732479676842233, -0.01680436810110096, 0.004560598388616709, -0.0004192104296342507, 0.0063855227318495205, -0.013072346026010723, 0.025952955076553298, -0.0043414707492683315, 0.0060979172686472976, 0.016010030001009447, 0.01732479676842233, 0.006368403625132041, 0.02843183972720715, 0.002047475990189208, 0.015215690969595314, 0.022392128725250947, -0.016735889811585806, 0.003906639012518288, -0.02776076031306863, -0.01729740470755817, -0.03108876532289707, 0.0033023254184296035, -0.017776747146228542, -0.010066185624142082, 0.012182139438185136, -0.011627471626106188, 0.0003323296417290777, 0.014982867765476169, -0.031006592865595074, 0.0011444294902488745, -0.009621082330229288, 0.015612860019641071, 0.0157772067968903, -0.009128044792449457, -0.027774456343500706, 0.009532061857711252, -0.014325483450447108, -0.03139006495388613, 0.002822983212589887, -0.025350353951929933, 0.01769457468892655, 0.008224142174191791, -0.011819208601574337, -0.01259300451866297, 0.014078965147218502, -0.0056699335471132924, 0.029883561211005102, 0.020693888006901768, 0.01602372416879629, -0.006132156413404875, -0.01393516241561739, 0.007696865957315693, -0.018351958072632988, -0.01659893509520073, 0.0023453527777235255, -0.01602372416879629, 0.009758037977936979, -0.0027818967511082345, 0.008929460733087887, -0.0012899441092386681, 0.028705749159977294, 0.015078736253210242, -0.014489829296373718, 0.009669016574096325, 0.035553494292457084, -0.025501004698747082, -0.010004556281165585, -0.022981033819442234, -0.0033964819023596677, -0.001294223885918038, 0.01729740470755817, -0.030677901173741855, -0.0005871941963328863, -0.018721735993137208, 0.01966672484004587, -0.02791141105988578, 0.012394419527978782, -0.012195834537294595, 0.016010030001009447, 0.0036840871327312357, -0.016420894150164664, 0.012990173568708727, -0.007518824546618313, -0.014161137604520499, -0.006142427970567624, -0.004711249135433859, -7.955154810565839e-05, -0.005330969832436013, -0.002424101925909466, -0.007902298497554609, 0.012901153096190693, 0.0007143054729215388, 0.011921925104524451, -0.015530686631016456, -0.005334393840044032, -0.03251309474583087, -0.019105209944073505, 0.02332342154172753, 0.00788175538322911, -0.003045534859546284, -0.007820125108929996, -0.012182139438185136, -0.020461064802782623, -0.022090827231616646, 0.010120967883225158, 0.007737952651627999, -0.013195605643286335, 0.012517679145254396, 0.005700748218601541, 0.01311343318598434, 0.021104752156056984, -0.006049983490441569, -0.011880838875873453, -0.01765348846027555, -0.010853676640340175, 0.02235104249659995, 0.012469744901387358, 0.026843163527024122, -0.011784970388139379, 0.003285206078881469, 0.018872386739954356, -0.026651426551555973, 0.020598019519167694, 0.007936537642312187, -0.018091744670294924, -0.028459229925426068, 0.009607387231119828, -0.004923529225227507, -0.00370120647227937, 0.012990173568708727, -0.008682941498536663, -0.0013353103473996905, -0.00991553580864755, 0.005933571422720687, 0.00361218576693068, -7.041675751065031e-06, 0.010997479371941286, -0.00639579428901227, 0.0006783547900212609, 0.0010999191375745297, 0.01950237992544188, 0.001705944619051896, 0.02372059152309591, 0.0215156163052122, -0.007203828419535862, 0.0016348992551533453, -0.023953414727215055, 0.011196064362625473, 0.009675864589312364, 0.007751648216398769, -0.01242865867273636, 0.006289654244115446, -0.01074411305349664, 0.002554209092739808, 0.0021775831570195504, 0.01144258266585408, 0.0074914338827380845, -0.0013584215838465315, 0.0014106356043929386, -0.0022255174008865876, 0.02522709526597694, -0.013339408374887446, 0.003964844813548074, 0.011113890974000859, 0.00840903206576652, 0.04831769174094009, 0.0004938936560971631, -0.008292619532384327, 0.003800498734790809, -0.022172999688918643, 0.014003639773809928, 0.021049969896973907, 0.012572461404337472, 0.014147442505411039, 0.005919876323611227, 0.002754505621566696, -0.005991777223750474, 0.005156352429346653, 0.00791599359666407, 0.00029102917977192396, -0.004858475408981681, 0.004930376774782237, 0.009984013166840087, 0.024802535086389643, -0.00839533603533444, -0.020132371248284164, -0.015941551711494292, 0.006234872450693679, -0.007094264367031018, -0.012812131692350038, 0.00025208263573378814, 0.024350582845938194, -0.008224142174191791, -0.018598477307184214, 0.02068019197646969, 0.0005058772170639223, -0.004817389180330684, 0.012695720090290465, 0.011065956730133822, -0.010278466645258348, -0.004584565510550228, -0.005245373367525998, 0.037772165540772874, 0.008539138766935551, -0.00319447336972877, 0.0015681337843494916, -0.002891460570782423, -0.023117988535827305, -0.02315907662712354, 0.008059796328265182, 0.00957999610157829, -0.025528394896966, 0.04152472886754337, 0.015215690969595314, 0.014366570610420725, 0.03662174368796398, -0.0175028377134584, -0.0029839050509084778, -0.012339637268895707, 0.005269340489459516, -0.02525448546419586, 0.010881067769881713, 0.0029154276927159414, -0.012654633861639467, 0.012188987453401174, -0.009312933752701567, 0.013339408374887446, -0.0010091865448371574, 0.02721294144752834, -0.0006560996136840885, 0.015804596995109218, 0.0005670789083353988, -0.004783150501234415, 0.002068019104514707, 0.007279153792944437, 0.0011059109180579093, -0.031691366447520436, -0.023583636806710835, 0.005341241389598762, -0.014065269116786424, 0.0013104873399794946, 0.005399447656289858, -0.029691824235536953, -0.007690018407760962, -0.008847287344463274, 0.018036962411211846, -0.007662627278219424, 0.011264541720818009, -0.01009357675368362, 0.02570643770464731, 0.01833826204220091, -0.008922612717871849, 0.020885624982369917, -0.014503525326805797, -0.008456966309633556, 0.001943047832681067, -0.006775844232340547, 0.005423414312562068, -0.017557619972541474, -0.01309289007165884, 0.034759158055010814, 0.002367608128683689, -0.00806664434348122, -0.017050887335652184, 0.0020611713221293224, -0.005652813974734504, -0.011291932850359548, 0.003307461197010978, -0.015188299840053777, -0.00873772375761974, -0.004005931042199072, 0.01242865867273636, 0.0019721508496112873, -0.013736577424933203, 0.04300384427485072, 0.007580454355256119, -0.01245604887095528, -0.017516533743890478, -0.021022579698754987, 0.005567217044163179, 0.08003645024932468, 0.02618578014331768, -0.014886999277742095, 0.026459689576087825, -0.004259297826305027, 0.025281877525060014, -0.018844996541735437, -0.010655092580978605, 0.023200162855774538, 0.005457653457319645, -0.005683628646222752, 0.0012907999947253457, 0.027117072959794267, -0.023926022666350896, 0.03626566179789184, 0.015297863426897311, -0.009141740822881536, -0.010524984948486953, -0.020693888006901768, -0.028815313678143446, -0.008545986782151592, -0.01695501884791811, 0.012360181314543825, -0.0033999056771370326, 0.02000911256233117, 0.004317503627334813, 0.01664002132385173, 0.020406282543699545, -0.001093071355189145, -0.028007279547619855, -0.0014294669477450824, 0.0074161085093295085, 0.004526359709520441, -0.0005311282836427847, -0.010326399957802766, 0.017406969225724326, 0.025295571692846856, 0.02287147116392132, 0.0035368606263527598, 0.023830154178616822, 0.008087187457806719, 0.006067102597159049, -0.007991318970072644, -0.024419061135453345, 0.0024275259335174854, -0.00605340703238828, -0.019543466154092876, 0.023172770794910383, -0.0033348520937218616, -0.0008418447504611936, 0.02114583838470798, 0.004755759371692877, 0.010648244565762566, -0.0012308823063068768, 6.414411777408072e-05, 0.019105209944073505, 0.005183743558888191, -0.012675176975964967, 0.011949316234065989, -0.02318646682534246, -0.003666967793183102, -0.037224346675232584, -0.013216148757611835, 0.02958226158001604, 0.001312199227368177, -0.004855051867034971, 0.0012796724356605913, -0.020118677080497322, -0.0018951135888140298, -0.009333476867027065, -0.007587302370472158, -0.04672901554075706, -0.022446910984334024, 0.014215919863603575, 0.03144484907561445, 0.001268544876595837, 0.027445764651647487, -0.010627701451437068, 0.004272993391075796, 0.02135127139060821, -0.008840439329247234, -0.008532290751719513, 0.004194244010059201, -0.007751648216398769, -0.016448284348383583, 0.009627930345445327, -0.008943155832197347, -0.000914174059005088, 0.016379807921513664, 0.0037422929337610224, 0.014640480043190868, -0.022898861362140237, 0.034348292043210354, -0.0066833997522144925, -0.019584552382743876, 0.005231677802755228, 0.0015184875366784447, 0.02332342154172753, -0.013914619301291892, -0.019036733517203586, 0.010655092580978605, -0.024816229254176484, -0.021721049311112427, -0.007375021815017201, 0.011860295761547955, 0.01077150418303818, 0.008107730572132217, 0.004272993391075796, -0.00956630100246883, 0.0046667384335135325, 0.027815542572151707, -0.013243539887153372, 0.010874219754665673, -0.014229614962713034, 0.0038244658567243277, 0.013517450251246135, -0.015804596995109218, -0.012065727836125563, -0.001479113079000802, -0.014407656839071723, -0.016215461144264434, -0.03779955760163703, 0.023569940776278758, 0.023802763980397903, -0.01899564728855259, 0.012503983114822316, -0.009833362420022935, -0.005752106470076597, -0.024446451333672268, 0.013421581763512061, -0.012901153096190693, -0.0019670148381992583, -0.009340324882243104, -0.030677901173741855, -0.03659435162709982, -0.018721735993137208, -0.0013464380228797724, 0.028650966900894217, -0.002569616661314587, -0.0245286256536195, -0.020913015180588836, 0.01648937057703458, -0.0015467345517066605, -0.02351515851719568, -0.02335081173994645, -0.04823551928363809, -0.00038582766512849204, -0.0015758374522215537, -0.001212050962954733, 0.025309267723278933, -0.020406282543699545, 0.015174604740944316, -0.017557619972541474, 0.01579090096467714, -0.02539144018058093, -0.02792510709031786, -0.01496917173504409, 0.0003836877476849753, 0.03782694593721071, 0.021789525737982346, 0.02136496555839505, 0.01616067888518136, -0.0003284778077930467, 0.004461306358935924, 0.00706002568793475, -0.005755530012023308, 0.011791818403355418, 0.009045872335147462, -0.02047475897056946, -0.001504792088323003, 0.009223913280183531, 0.012010945577042485, 0.007299696907269936, 0.008648702353779085, -0.012510831130038355, 0.005296731153339745, -0.005228253795147209, -0.00420793957482997, -0.02539144018058093, -0.0072860013424991665, -0.008463813393526977, -0.027788152373932788, -0.008963698946522847, 0.010175750142308234, -0.0076215410495684265, -0.029500087260068805, 0.024117759641819045, 0.020611713686954535, -0.0021895667179863097, -0.016420894150164664, 0.02558317715604908, -0.009648473459770827, 0.010778351266931599, 0.009141740822881536, 0.017406969225724326, -0.02267973418845317, 0.0001148067367365152, -0.0076763228429901935, -0.0005084451063546097, 0.018050656578998688, 0.0023590483424942945, 0.0019002493673954046, -0.007717409537302501, -0.008299467547600366, 0.004259297826305027, 0.0315544135937806, -0.02624056053975552, -0.01743436128658848, 0.002050899764966573, -0.03985388021005835, 0.009970318067730626, -0.01998172236411225, -0.028924878196309598, -0.006101341276255317, -0.0025131226312581556, 0.021584094594727356, -0.015845683223760218, -0.006056831039996299, 0.012120510095208639, -0.009833362420022935, 0.004766030928855626, 0.013072346026010723, 0.03621087767616353, -0.002037204433026459, 0.0442364385849616, 0.03963475117372604, -0.008100883488238798, -0.011839752647222455, -0.0011487093833435717, -0.0026175506723509693, -0.010305856843477268, 0.019242164660458576, 0.015256777198246313, 0.010853676640340175, 0.0022974187666871433, 0.006416337868999078, -0.005296731153339745, -0.01393516241561739, -0.010627701451437068, 0.032485706410257185, 0.012873761966649154, 0.02188539422571642, -0.016270243403347512, -0.012017793592258526, -0.02399450095586605, 0.03317047812953731, -0.009607387231119828, 0.006118460848634106, -0.019776289358212025, -0.03686826105986997, -0.008504899622177974, 0.015516991531906997, -0.012757350364589581, 0.027377286362132332, 0.023802763980397903, -0.015078736253210242, 0.01729740470755817, -0.008470661408743016, -0.0198310716172951, 0.002085138444062841, -0.008484356507852476, 0.024651884339572494, -0.029472697061849885, 0.0087514188567292, -0.005098146628316867, 0.005402871198236569, -0.006180090657271912, -0.01562655605007315, -0.00024951471733926893, 0.030130080445556328, -0.020570627458303535, 0.00023753117092442557, 0.013996791758593887, 0.001658010375184859, 0.008511747637394014, -0.027788152373932788, -0.022583865700719095, -0.00722437153386136, -0.006200633771597411, -0.0198310716172951, 0.004526359709520441, 0.008559681881261052, -0.011024870501482825, -0.019433901635926724, 0.0027973040868523587, -0.009792276191371938, -0.004913257668064757, -0.006700519324593281, 0.02572013187243415, -0.00010908244957155413, -0.025446222439664008, 0.007299696907269936, -0.003834737646717732, 0.004724944700204629, 0.02539144018058093, -0.007813278025036575, -0.001184659949828522, 0.02402189115408497, -0.017228928280688255, -0.001351573801461147, 0.0034683832681602234, 0.0077790388802789975, -0.012524527160470434, 0.002068019104514707, 0.003059230424317053, -0.01143573558196066, 0.02703490050249227, -0.009011633190389884, -0.019748899159993102, -0.006409489853783039, 0.005330969832436013, 0.00019730066768903015, -0.015941551711494292, 0.022994729849874312, -0.013524297335139556, -0.005621999303246255, -0.001763294534595005, 0.002083426673089486, -0.03391003769583622, -0.0014174833867783231, -0.0043140796197267935, 0.0008996226087476415, 0.002790456304466974, -0.004074408866052918, 0.004478425465653404, -0.005591184166096698, 0.020803450662422684, -0.0061526995277303735, -0.019570856352311795, -0.029253569888162818, -0.01735218696664125, 0.020118677080497322, 0.010696178809629604, -0.01847521862123122, -0.022474301182552944, 0.006501934333909093, -0.02689794392346196, 0.00011705365441778257, -0.000660379448571122, 0.005824007835877153, -0.004920105217619488, 0.022583865700719095, 0.02047475897056946, 0.02573382790286623, -0.012134205194318098, -0.0036224573240934295, -0.00791599359666407, -0.0218169177988465, -0.02315907662712354, 0.004718096684988589, 0.003831313639109712, 0.028979658592747436, 0.02284407910305716, -0.006748453102799009, -0.02187170005792958, -0.004625652204862535, -0.02348776831897676, -0.030294427222805557, 1.4925945632605322e-05, 0.01007988165457416, 0.0033742265513995043, 0.010326399957802766, 0.00924445639450903, 0.016379807921513664, -0.005700748218601541, 0.013894076186966394, -0.04429121898139944, -0.0037902271776280596, -0.00940195515654222, -0.01998172236411225, 0.019543466154092876, -0.01528416832778785, -0.014572002684998333, -0.03284178830032933, 0.01160692851178069, 0.014763739660466482, -0.0005846263070421989, 0.012750502349373541, 0.0036156097745386998, -0.016941322817486032, 0.0023094023276539026, 0.01869434579491829, 0.006618345935968667, 0.008539138766935551, 0.009771733077046438, -0.0245286256536195, -0.010894762868991173, 0.016119592656530363, -0.01428439722179611, -0.01796848412169669, 0.007025787008838482, 0.01479113079000802, 0.01848891278901806, 0.0020919862264482257, 0.011024870501482825, 0.00521113422276842, 0.0055500979374456996, -0.027021204472060193, -0.01395570552994289, -0.010538680978919033, -0.01309973715555226, 0.007107959931801787, -0.014654176073622948, -0.02980138875370311, -0.0028144234264004925, 0.007443499638871047, -0.010059338540248661, -0.007162741725223554, 0.027966193318968855, -0.0107578081526061, -0.000806750011255257, -0.004581141968603517, 0.0195297701236608, -0.04782465699712811, -0.004423643672231637, -0.029637043839099115, -0.01125769370560197, -0.027267723706611416, 0.027459460682079564, 0.0007656635497736044, -0.011627471626106188, -0.0019105210409734812, -0.005728139348143079, 0.01194246821884995, 2.8454254774530583e-06, 0.00404016972129534, 0.006758725125623068, -0.015530686631016456, -0.010552376078028492, 0.002001253750126181, -0.022926251560359157, -0.012134205194318098, 0.008724027727187661, 0.010230532401391311, -0.0011820920605378348, 0.0025302419708062894, 0.24388931358618965, 0.0005033093277732351, 0.0069333425287124275, 0.046537278565288914, -0.006248568015464448, -0.006159547077285103, 0.014092660246327961, 0.006991548329742214, 0.0036361528888641985, 0.006796387346666046, -0.02267973418845317, -0.0037765316128572906, -0.019228470492671734, 0.0024258139297134757, 0.0013943721503314821, -0.01025792259961023, -0.035087847884218794, -0.001828348118010176, -0.03612870521886153, 0.02971921629640111, 0.03311569773309947, -0.012846370837107615, 0.0006103053163644, -0.0014688414054227251, 0.017393273195292245, 0.011134434088326359, -0.037909118394512706, 0.008039253213939682, 0.008573377911693129, 0.012743654334157502, -0.0024360854868762253, -0.009271847524050568, -0.015325254556438848, 0.0011966435107952813, -0.00876511395583866, -0.004673586448729572, -0.012099966980883139, 0.03793651045537686, 0.023254943252212376, 0.01985846181551402, -0.0019721508496112873, 0.007327088036811474, -0.0117712743577073, -0.010326399957802766, -0.026418603347436828, 0.015585468890099532, -0.008272076418058829, -0.004622228197254515, 0.02251538741120394, 0.005943842979883437, -0.035443929774290936, -0.00571101977576429, 0.011661710770863766, 0.023830154178616822, 0.0013618453586238966, 0.00025315260900746244, -0.0020286446468370644, 0.023432986059893687, -0.002335081220560776, -0.008052949244371761, -0.006289654244115446, 0.01328462611580437, -0.001023737995094604, 0.026445993545655747, -0.04308601673215272, 0.0008961987175549491, -0.014859608148200556, 0.0012437217527603137, -0.0014423063941985193, -0.011784970388139379, -0.008860982443572734, -0.012360181314543825, -0.012914848195300152, 0.006094493726700587, -0.03149962947205229, -0.037772165540772874, 0.026665120719342815, 0.02662403449069182, 0.01479113079000802, 0.02873314122084145, -0.009504670728169715, 0.021611484792946275, -0.01058661429146345, -0.0141200513758695, -0.004218211131992719, -0.023460376258112606, 0.032677443385725334, -0.00011095488097261027, -0.008614464140344127, 0.0018951135888140298, -0.014722653431815483, -0.010538680978919033, -0.002103969787414985, -0.022556473639854937, -0.0037765316128572906, 0.02137866158882713, -0.011976707363607527, 0.01428439722179611, 0.0012454337565643233, -0.0026689089238260263, 0.006436880983324577, 0.0032184404916622885, 0.020625409717386613, -0.010162054111876156, -0.010976936257615788, 0.024117759641819045, 0.0020611713221293224, 0.01613328868696244, 0.014462439098154799, 0.00521113422276842, -0.01107280474534986, -0.006118460848634106, 0.0021056817912189947, -0.007703713972531731, 0.0396621432345902, 0.012065727836125563, -0.010661939664872026, -0.02676098920707689, 0.019296946919541653, -0.0038724001005913645, 0.007847516238471533, -0.007703713972531731, 0.015010257963695088, 0.01727001450933925, -0.009271847524050568, -0.021132142354275903, -0.012640938762530007, -0.0002751937848691336, 0.02288516533170816, -0.028349667269905152, -0.004132614667082704, 0.008107730572132217, 0.0026261104585403637, -0.011285084835143509, 0.003714902037050139, -0.015380036815521924, 0.024446451333672268, -0.01920107843180758, -0.004406524099852848, -0.011504212940153195, -0.0050947226207088475, 0.008367944905792903, 0.01562655605007315, 0.00622802443547764, 0.006118460848634106, -0.008628159239453587, -0.004512664144749672, 0.005659661989950543, -0.024473843394536423, -0.01635241586064951, -0.026130997884234605, -0.0056048797308674665, -0.012832675737998156, -0.009840210435238975, 0.025816000360168224, -0.017037191305220106, -0.03774477347990871, -0.029527479320932963, -0.007847516238471533, 0.013928314400401352, -0.022953643621223315, -0.007498281432292814, 0.026856857694810964, -0.006296502259331485, -0.039306061344518056, -0.0016006605760570773, -0.1784796352424297, 0.03341699922673377, -0.002841814323111376, -0.0036909349151166204, 0.022898861362140237, 0.005228253795147209, 0.012990173568708727, 0.010620853436221028, -0.008367944905792903, -0.007142198610898055, 0.01820130732581584, -0.006611498386413937, -0.02337820380081061, -0.0006406922197323006, 0.01699610507656911, -0.02214560949069972, -0.002708283381503669, 0.01683175829931988, 0.002804151869237743, 0.011784970388139379, 0.02332342154172753, -0.012086270950451061, 0.006861441162911872, -0.02044736877235054, 0.00047677428744519727, 0.01848891278901806, -0.02856879444359222, 0.005128961299805115, 0.0023932870215905627, -0.021926482317012653, -0.015804596995109218, -0.0107578081526061, 0.023775371919533748, 0.0077790388802789975, 0.007196980869981132, -0.0030164319590313907, -0.00821729509029837, -0.010545528062812453, 0.006306773816494235, 0.01765348846027555, 0.018173917127596917, 0.022789296843974086, 0.003060942195290408, 0.012086270950451061, 0.015366340785089846, 0.02098149347010399, 0.02619947431110452, -0.008148817732105835, 0.019913244074597096, -0.011915077089308411, 0.014558307585888873, -0.023200162855774538, -0.01192877311974049, 0.029198787629079744, 0.00873772375761974, 0.013983096659484428, -0.02689794392346196, -0.01260669961777243, -0.017858921466175775, -0.004670162441121552, -0.01833826204220091, -0.022419518923469866, 0.016681107552502728, -0.03273222378216317, -0.0068956798420081395, -0.025350353951929933, -0.009443041385193219, -0.025405136211013007, -0.027993583517187774, 0.0023248096633980268, -0.011976707363607527, -0.011565842283129691, 0.02837705746812407, -0.018817604480871282, -0.0018420435663656178, -0.01885869070952228, -0.013592774693332092, 0.008162512831215295, 0.009785428176155898, -0.00311401221773882, -0.0020217968644516797, 0.011538451153588154, -0.013791359684016279, -0.0034187370204891766, -0.003543708408738144, -0.002088562451670861, 0.0018215003356247916, 0.0025148346350621653, -0.023830154178616822, -0.012134205194318098, 0.019611942580962795, -0.030623118914658777, 0.0008884949914752234, -0.013298322146236448, 0.025624263384700075, 0.03243092228852887, 0.00622117688592291, 0.017064581503439025, -0.008059796328265182, 0.007008667436459694, -0.009990861182056126, 0.00402305061457786, -0.02348776831897676, 0.01143573558196066, 0.0198721578459461, -0.002131360916956523, 0.000187029052318617, 0.018625867505403133, 0.023282335313076535, -0.005919876323611227, -0.005724715340535059, 0.01596894190971321, 0.028952268394528517, 0.0036156097745386998, -0.015065040222778164, -0.0026329582409257484, 0.008094035473022758, -0.016242853205128593, 0.009648473459770827, 9.383551232064442e-05, 0.031828323026550746, -0.005296731153339745, 0.015516991531906997, 0.01659893509520073, -0.012401267543194821, -0.0019310642717143077, -0.11931512325826905, -0.03914171270462359, 0.009381411110894102, 0.010155207027982735, 0.02439166907458919, 0.03547132183515509, -0.010483898719835957, 0.01820130732581584, -0.012367028398437244, 0.029089223110913588, 0.011387801338093622, -0.0218169177988465, 0.0010793759068337032, 8.982316347607153e-05, 0.00755991124093062, -0.009840210435238975, -0.014572002684998333, -0.012188987453401174, -0.028678358961758372, 0.014667871172732407, -0.02167996308246143, -0.024966880000993636, -0.01107280474534986, -0.005652813974734504, -0.004831084745101452, 0.01025107551571681, -0.03886780327185345, 0.03284178830032933, 0.0305683366555757, 0.02873314122084145, 0.013332560359671407, -0.010881067769881713, 0.005728139348143079, -0.03738869158983658, -0.005943842979883437, 0.009881296663889972, -0.02519970320511278, 0.009942926938189088, 0.022666038158021092, -0.017009799244355948, 0.005752106470076597, -0.0013661252517185938, 0.0062177528783148904, -0.038374764802750996, 0.003314308979396363, -0.009504670728169715, 0.002706571377699659, 0.0025079868526767806, 0.014695262302273946, -0.008943155832197347, -0.00923760931061561, 0.028815313678143446, -0.001788973543917206, -0.015722424537807225, 0.0028503741093007704, -0.03341699922673377, -0.023775371919533748, 0.011223455492167012, -0.014051574017676965, 0.011182368332193396, -0.0010305856610646612, -0.019694116900910028, -0.0003689222969520274, 0.018119134868513843, 0.022200391749782798, -0.003365666998040765, 0.001075952015641011, 0.009052719419040883, 0.004495545038032192, -0.010360639102560344, 0.006443728532879307, -0.01143573558196066, -0.024350582845938194, 0.049276376618280826, -0.02603512939650053, -0.0024463570440389744, -0.029691824235536953, -0.001237729972276934, 0.020461064802782623, -0.03473176599414665, -0.0029154276927159414, -0.019789985388644103, 0.006282806694560716, -0.015914161513275373, 0.013394190633970522, 0.0047694549364636464, -0.012620395648204509, 0.01360647072376417, 0.009799124206587977, -0.03265005132486118, 0.03979909608833004, -0.0052145582303764395, 0.03695043724246244, -0.0052898836037850155, -0.01802326638077977, -0.01865325956626729, -0.009532061857711252, 0.003817618074338943, 0.02184430799706542, -0.010709873908739063, -0.003213304713080914, 0.010127815898441197, -0.09690929663994079, 0.014982867765476169, -0.017365882997073326, -0.0038552807610432306, 0.015585468890099532, 0.0024138303687467164, 0.011291932850359548, -0.032814396239465166, 0.0009860754248056437, -0.01896825522768843, -0.015434819074605002, 0.0010973512482838422, 0.0019481836112624415, -0.008251533303733329, -0.002302554545268518, -0.01813283089894592, 0.00377995562046531, 0.012236921697268211, 0.020762364433771684, 0.020296718025533393, 0.00046136686438957755, 0.009004785175173845, 0.02051584519922046, -0.012017793592258526, 0.0021279369093485036, 0.006409489853783039, -0.017927397893045694, 0.004389404993135369, 0.007320240021595434, -0.015873075284624373, 0.007943384726205607, -0.002239212732826702, -0.014654176073622948, 0.049796807148247434, -0.0018386196751729257, -0.009703255718853903, -0.014585697784107792, 0.0021707353746341657, -0.004646195319188033, 0.015695032476943066, 0.009723798833179401, -0.013257235917585451, 0.0018197884482361092, -0.013291474131020409, -0.02036519631504855, -0.016708499613366887, -0.02504905432094087, 0.009716950817963362, 0.024898403574123717, -0.003268086506502681, 0.012421810657520321, 0.008908916687439771, -0.02081714669285476, -0.01511982248186124, -0.02133757536017613, -0.04604424009618646, 0.018762822221788204, -0.017571316002973552, -0.0007939105065941565, -0.008148817732105835, -0.005926723873165957, 0.03311569773309947, 0.017338492798854407, -0.011558994267913653, 0.003516317279196606, 0.0005692188548827474, -0.021063665927405988, -0.018817604480871282, 0.030458772137409548, 0.0013104873399794946, 0.001075096013739006, -0.01931064294997373, 0.010120967883225158, -0.015338950586870927, -0.004680433998284302, 0.0016494507054107918, -0.010976936257615788, -0.009963470052514587, -0.006991548329742214, 0.03092441854564784, -0.007642084163893925, 0.0004870459028156104, -0.025980347137417453, 0.017680878658494468, 0.016242853205128593, 0.0131271282850938, -0.021022579698754987, -0.008874678474004812, 0.00688540828484539, 0.017886311664394694, 0.015201994939163237, 0.015996333970577366, 0.010292161744367808, -0.009853905534348435, 0.005467925014482395, 0.010401725331211342, -0.007450347188425777, -0.020132371248284164, -0.003504333718229847, 0.026158388082453524, 0.015229386068704774, -0.0004050869512239747, -0.019187382401375498, -0.022638647959802173, -0.002994176840901882, 0.018844996541735437, 0.004687282013500341, -0.02558317715604908, -0.015160908710512238, 0.020214545568231396, 0.019379119376843647, 0.0061629710848931235, -0.007484585867522045, 0.030458772137409548, -0.025761219963730386, 0.018173917127596917, -0.01795478995390985, -0.00874457084151316, -0.01713305979295418, 0.03092441854564784, 0.044044701609493454, 0.008148817732105835, 0.020584323488735616, -0.0006616633932164656, 0.015599164920531611, 0.0225427794720681, 0.02118692461335898, -0.014585697784107792, 0.014366570610420725, 0.001750454971726241, 0.006265687122181928, -0.011956164249282027, 0.004837932294656182, -0.023638417203148673, -0.0030677899776757928, -0.003995659485036322, 0.010004556281165585, 0.01681806413153304, -0.01546220927282392, 0.05861670429449179, -0.0011983555145992913, 0.005666509539505273, 0.005170047994117423, -0.002995888611875237, 0.01800957035034769, 0.006392370747065559, 0.019214774462239657, -0.012517679145254396, 0.0015903889024790005, 0.009175979036316494, 0.014174833634952576, 0.006936766536320447, -0.007655779728664694, -0.014476134197264259, -0.00209883400883361, -0.02335081173994645, 0.004447610794165156, -0.014572002684998333, -0.0025524970889357983, 0.024638188309140413, 0.022364736664386792, -0.000184675134399599, -0.006878560269629351, -0.0238849364376999, -0.016393503951945745, 0.014311788351337649, 0.008347401791467403, -0.024104065474032203, -0.016941322817486032, 0.01920107843180758, 0.004574293953387478, -0.05719237300891276, -0.010949545128074249, 0.009381411110894102, -0.02385754623948098, -0.013633861853305708, 0.0030540946457356783, 0.017886311664394694, 0.011661710770863766, -0.026350125057921673, 0.019242164660458576, -0.014914390407283632, -0.014380265709530184, 0.023624723035361835, -0.010319552873909345, -0.006409489853783039, -0.004944072339553006, 0.012654633861639467]"
9,Orange,"[0.020745464394357635, -0.029286145324851107, 6.568314213298411e-05, -0.015269300502741794, -0.00934012173722597, 0.023503531591992716, -0.019572951583679013, -0.006009122566792292, 0.00577928378887647, -0.046074380845813605, -0.0031927629558521227, 0.011991597199825762, -0.006868520525990186, 0.006082404617459706, -0.032830328896677974, -0.0142300292235025, 0.03746707868393917, -0.0024299641057759385, 0.02671461459485039, 0.011445314092108595, -0.02960592239260219, 0.00465007515112452, -0.010719156267366118, -0.011878343714181417, -0.008254216341078084, 0.008280864274836907, 0.003444253354569977, -0.01429664952356086, 0.035015465052837064, -0.0014523156494849548, 0.030405362268012083, -0.010306111897120458, 0.0012599504993136453, -0.019013344043421133, -0.0355217767255773, -0.004130439045843569, -0.004613434125790813, 0.006332229578525297, -0.009440051721652206, -0.028859778384709944, -0.00268478537979832, 0.004500180174485165, -0.0014323296991658378, -0.012517895055715766, -0.0025115735775353212, 0.012164809234919412, -0.01132539792453259, 0.010006321943841748, -0.014469860627331903, 0.011665159312788229, -0.007634650251370897, 0.00035974792065138585, 0.012477923620738835, -0.003444253354569977, 0.012870981807834728, 0.009846434341288813, -0.007354846481241957, 0.025035790111431533, -0.028993018984826664, -0.004869920837465458, 0.02712765803377344, 0.0034709012883288, -0.006861858775381132, 0.00887378243078527, -0.006725287765621189, 0.015455836970376158, -0.0038106631422457427, -0.0018170601159237828, 0.007494748366306427, 0.016095389243233116, 0.010319436329661173, 0.002706437000600352, -0.0024016505015342004, 0.004836611153097581, 0.011811723414123057, -0.002673126850571172, -0.03330999356698199, -0.0429299190743369, 0.011092227339989633, -0.015788937539345353, 0.013763688985739195, -0.016028768011852147, -0.009786475791839506, 0.014456537126113795, 0.015122737332729574, 0.010019646376382463, -0.0330701630944752, 0.01866691997323383, -0.022810683451618116, -0.0020985296729509645, 0.004360278289420694, 0.010146224294567522, 0.01045933774906434, 0.0065620688221024225, -0.029819105862672772, 0.0031910972853692074, 0.009033670033338206, 0.022477582882648922, 0.019013344043421133, -0.03192429728623279, -0.00029250337251174183, 0.013224067628631082, -0.03778685761433547, -0.007641312467641255, -0.013597139632577205, -0.01015954779578563, 0.004573462225152579, -0.008833810064485734, 0.021065239599463506, -0.015522457270434518, -0.005885875989573064, 0.023197079888104953, -0.0036341202318475657, -0.06923149023026423, -0.014629749161207446, -0.012444613005048353, -0.016335221578385125, 0.011638511379029408, -0.02936609005745018, -0.02496917074269578, 0.022704091716582827, 0.029819105862672772, 0.03346988303218014, -0.009659897873654448, 0.02483593014257906, 0.0038306493253955115, 0.009086965900855852, -0.01104559415440365, -0.0023017205171079642, -0.005189696973893936, 0.030405362268012083, 0.012384655386921652, 0.02835346671196971, -0.0006741109772563669, -0.013117474962273184, 0.028433409581923568, -0.026408162890962626, 0.0232503757556226, -0.006228968718794533, -0.019559628082460905, 0.010112913678877039, 0.007814524037073601, 0.0007569695854626104, 0.013244052880458244, -0.0022217764830008446, 0.025275622446583542, 0.024795959638924735, 0.010186195729544453, 0.009333459986616915, -0.009320136485398808, 0.02604841531955722, -0.03235066422637395, 0.026288245792064013, -0.0006420501382970363, 0.010012983694450802, 0.005213014032348231, -0.001344890962792881, 0.03517535451803521, -0.013470561714392145, 0.004290327114057808, -0.011878343714181417, 0.003967220102324803, 0.016348545079603233, -0.0034942183467830956, 0.007874482586522907, 0.017254576690048415, 0.0145764532936898, 0.025608723015552736, 0.0059624889155450046, -0.009573292321768926, -0.024702691405107554, 0.026035089955693896, -0.01248458537134789, 0.013390616981793071, -0.0033543162288879732, 0.02960592239260219, 0.007594678350732663, -0.01693479962229733, -0.017334519560002273, 0.010998960037495058, -0.004153756104297864, 0.0022550866330300246, 0.010452675998455285, 0.00889376861393504, -0.016521756183374276, 0.022957247552952944, 0.009613263756745856, -0.0294993306575669, 0.01246459918819812, -0.007721256268917722, 0.009306812052858094, 0.016588377414755242, 0.03248390668913589, 0.004686716176458227, -0.6787777184255467, -0.01672161615222675, 0.009260177935949502, 0.008494048676230095, 0.020172531490236432, 0.030245474665459147, 0.024849255506442382, -0.0068751827422605435, -0.011218805258174692, -0.02472933840754377, -0.01530927286904133, 0.00947336233734269, -0.009953026076324104, 0.00794776463719032, 0.005412874001200704, -0.021198480199580226, 0.013323997613057317, -0.009453376154192922, 0.007754566418946902, 0.01705471672119594, -0.011272102057014946, -0.022610823482765642, -0.02133171893705173, -0.00040867198522800795, 0.025049115475294852, 0.011205481756956586, 0.01894672467468538, -0.010512633616581984, 0.003107822375957561, 0.030272121667895363, -0.004720025860826103, 0.010512633616581984, 0.014083465122167672, -0.023823306797098587, 0.04391589541738116, 0.001050097555301614, -0.0127244177064999, 0.023476882726911286, -0.011631849628420354, 0.03581490492824695, -0.0008356644831228694, 0.013164109079181776, 0.011878343714181417, -0.011471962025867418, -0.013177433511722491, -0.005252985932986465, 0.017601000760235713, 0.004523497232939461, 0.0037140642659546854, -0.014096789554708387, 0.03224407249133866, 0.014083465122167672, 0.03845305502698342, 0.0005004826409573137, 0.007468100432547605, -0.0036141342815284487, 0.02835346671196971, 0.01962624745119666, -0.011478623776476472, -0.0036874163321958626, -0.03405613571222903, 0.009546644388010103, -0.025009143108995317, -0.019346444612390323, 0.001409845475953, 0.020825407264311493, -0.02790045090674712, -0.008647274528173977, 0.01650843268215617, 0.006615364689620068, 0.004363609164725221, 0.016241953344567944, -0.02077211139679385, 0.01474966532878345, 0.0006603705927562268, 0.005822587030480534, 0.026128358189511078, -0.015042792600130498, 0.0025282284197192598, 0.017640973126535252, 0.016415164448338987, 0.004013854219233394, -0.014816284697519203, 0.0025398869489464074, 0.025089085978949176, -0.0072282685630568975, -0.035655015463048806, -0.005186366098589409, 0.03813327982187755, -0.018547004736980434, 0.024089787997332027, 0.028966370119745236, -0.005859227590152938, -0.008320836641136444, 0.0070217463779340674, -0.005282964742049814, -0.017640973126535252, -0.0016321896680183106, -0.0027747225054803237, -0.03901266442988652, 0.01293760117657048, -0.027927097909183334, 0.004653406026429047, 0.002939606886651353, 0.023663419194545652, 0.008214243974778547, -0.008234230157928315, 0.017960748331641123, 0.01894672467468538, -0.030964969808269963, -0.009979674010082925, 0.005696008646634171, -0.007448114715059139, -0.025209003077847788, 0.023969870898433415, -0.033150104101783845, 0.024582774306208942, 0.0037107331578195065, 0.04492851876286163, -0.01601544451063404, 0.010699170084216348, -0.0041804040380566876, 0.007694608335158899, -0.008420766625562681, 0.00135904776491375, 0.007361508697512314, -0.011112213523139403, -0.005879213773302706, -0.007248254746206666, -0.022917275186653405, 0.018760188207051016, -0.015589076639170273, 0.007867820835913853, 0.014190056857202963, 0.024755987272625197, 0.01074580420112494, 0.009533319955469388, -0.012564529172624357, 0.013197419694872259, -0.017427787793819458, -0.03328334656454578, -0.010632549784157988, -0.005039801997254581, -0.009639911690504679, 0.0009659898106485099, -0.020025967388901604, -0.014669720596184375, -0.006442152654526418, -0.014922877363877101, 0.0127244177064999, -0.02043901269046987, -0.015069440533889322, -0.02992569759770806, 0.008647274528173977, 0.01323739112984919, -0.014989496732612854, -0.013710393118221548, -0.00284134233987738, 0.0005242160006170123, 0.013557167266277667, 0.01918655700983739, 0.028060338509300054, -0.017361168425083704, -0.005905861707061528, 0.0006499612581836025, -0.04111785585344654, 0.005739311888238236, 0.005922517014906771, -0.013164109079181776, -0.0334432323044535, -0.0026681305376143817, -0.005502810894052056, -0.009666559624263502, -0.0050897669894676995, -0.020865379630611032, -0.01604209337571547, -0.01720128082253077, 0.00011252532233278242, 0.002156822086256052, 0.01973283918623195, 0.013317334931125658, 0.013910253087074022, -0.03432261691246247, 0.002280069129136584, 0.03973215957269734, 0.004546814291393756, 0.011112213523139403, 0.044422207090121395, -0.012824347690926136, 0.001777088098870223, -0.015229329067764863, 0.011132199706289172, 0.0014106781947791317, -0.004450215182272047, -0.008447414559321503, -0.014096789554708387, -0.006791907600018245, 0.010998960037495058, 0.0029512654158785007, 0.02495584724147767, 0.014003521320891204, -0.024889226010096705, 0.029819105862672772, 0.005063119055708876, 0.023823306797098587, -0.008160948107260901, 0.021278423069534085, -0.017987397196722554, 0.0142300292235025, 0.03205753602370429, 0.011412003476418112, -0.02615500705459251, -0.02285065581791765, -0.00246493946062673, 0.02159820013728517, 0.01774756486157054, -0.0025398869489464074, 0.022557527615248, 0.02298389455538916, -0.01692147612107922, 0.002226773028788287, -0.006012453907758122, 0.014083465122167672, -0.0023466889635336404, -0.002746408901238586, -0.014043492755868135, 0.034748983852603624, 0.039865398310168845, -0.0024099779226261697, 0.0025465489323861132, -0.0073681704481213675, -0.00232503757556226, -0.005063119055708876, 0.0032477242610220313, 0.0023600129304130516, 0.013110813211664131, 0.01577561217548203, -0.01328402524675778, 0.02055892792672327, -0.007088366677992427, 0.0029279483574242053, 0.03999864077293078, 0.03384295224215844, -0.005579423820023997, 0.03616132713578904, -0.026994419296301937, 0.02566201888307038, 0.004969850821891694, -0.014989496732612854, 0.004839942028402108, -0.01939974047990797, -0.011438651410176933, -0.01834714476812796, 0.009699870239953985, 0.0010675852327270098, -0.005799269972026238, 0.026101711187074862, 0.019946024518947742, 0.012051555749275068, 0.01800072069794066, 0.023610123327028006, -0.0010734144973405836, -0.0016305241139507212, 0.001072581778514452, -0.011751765795996358, 0.005066449931013403, -0.005519465736235994, -0.00697511272668678, 0.005579423820023997, -0.007314874580603723, 0.01433662095853779, -0.00975316610747163, 0.014003521320891204, -0.005079773897892815, -0.010592577417858452, -0.013510533149369076, -0.01728122369248463, 0.026901151062484755, 0.0006774419689762198, -0.006901830676019366, -0.018986697040984917, -0.03608138612848039, 0.019306472246090788, 0.009213543819040911, -0.015988797508197823, -0.029072961854780525, -0.02101194373194586, 0.00981978640752999, -0.009273502368490217, 0.015269300502741794, 0.022637470485201858, 0.015402541102858514, 0.0020735471768444052, 0.011172172072588709, 0.019972671521383958, -0.0016238621305110156, 0.017987397196722554, -0.03304351236674855, -0.0027214264051320268, -0.00947336233734269, -0.007248254746206666, -0.01601544451063404, -0.01869356883831526, -0.002829683810650232, 0.02055892792672327, 0.009160247951523266, -0.022051215942507762, -0.017121336089931695, -0.014816284697519203, -0.015575753137952165, -0.005559437636874228, 0.000578344761583778, -0.013177433511722491, -0.005925847890211298, -0.0016580048829510014, -0.01530927286904133, -0.008587315978724669, -0.025675342384288487, 0.027873802041665688, 0.0038006702835015104, 0.0057959386310604075, -0.027420786236443097, -0.004443552966001689, -0.009959687826933157, 0.0752006422934022, -0.00458345485106616, -0.004320305923121158, 0.02790045090674712, 0.00348755636334339, 0.00017300378262753862, -0.022144484176324943, 0.005849234964239357, 0.010705831834825402, 0.005942502732395235, -0.007921116703431498, 0.018520355871899003, 0.00524299284141158, 0.006968450510416422, 0.009153586200914212, 0.005602740878478293, 0.001662168709912312, 0.004979843913466579, 0.025248975444147326, -0.007028408594204425, -0.01646846031585663, -0.008940401799521025, -0.0007528058749166259, 0.011511933460844347, 0.0017720916694981069, 0.006095728584339117, 0.02090535199691057, 0.041197800586045615, 0.010339421581488335, -0.008107652239743256, -0.003464239304889094, 0.01450983299363144, -0.0026364860580681167, -0.010559267733490574, -0.0021951285492420223, -0.01493620086509521, 0.012517895055715766, -0.003079508771715823, 0.023330318625576458, -0.00975316610747163, 0.018267200035528886, 0.00880716213072691, -0.015469160471594266, -0.03610803313091661, 0.008041031939684896, -0.01253121948825648, 0.0027280883885717326, 0.01672161615222675, -0.012604501538923894, 0.00020069270223052027, 0.030325417535413006, 0.0018870110584560179, -0.019839432783912453, -0.022237750547496913, 0.021451636035950343, 0.014909552931336386, 0.0019003351417507552, -0.002624827528840969, -0.009693208489344931, -0.02251755524894846, -0.002962923945105649, -0.006408842504497238, -0.012877643558443782, -0.005732649671967878, -0.0005471166414505791, -0.02888642538714616, 0.0051597181648305864, -0.003127808326276678, -0.02034574445665269, -0.011065579406230812, -0.003624127373103333, -0.020252476222835505, -0.019119935778456422, 0.02206453944372587, 0.013397279663724731, 0.029072961854780525, 0.01752105602763664, -0.03648110606618534, 0.014096789554708387, 0.01808066356789452, 0.012457937437589066, 0.0019303140672294306, -0.008314173959204783, -0.006811893783168013, -0.011332059675141644, -0.009333459986616915, 0.021997920074990115, -0.011265439375083284, -0.00458345485106616, 0.02269076821536472, -0.0024416224021724343, -0.00568268467975476, 0.018293848900610317, -0.019386416978689862, -0.014483185059872618, -0.015708992806746275, 0.01646846031585663, -0.005922517014906771, -0.021771411241056214, -0.011718455180305875, 0.01440324125859615, -0.01752105602763664, -0.013570491698818382, -0.007701270551429257, 0.014869580565036847, 0.010219506345234936, 0.005149725073255702, 0.03328334656454578, -0.031977595016395646, -0.007348184730632903, 0.04879247940243958, -0.030325417535413006, 0.01009292749572727, -0.0009493347938415829, -0.0023899919723070527, 0.010306111897120458, -0.00919355856721375, 0.027287545636326377, 0.00034663210437467604, -0.042317015666561375, -0.004033840402383163, -0.03277703489180554, 0.024516154937473188, 0.0047833148199186324, 6.760887717799241e-05, 0.019306472246090788, 0.0012233094739799383, -0.020825407264311493, 0.012091527184251999, 0.004886576145310699, 0.01705471672119594, 0.007694608335158899, -0.022677442851501396, -0.009566629639837265, -0.033816305239722226, -0.011065579406230812, -0.012331359519404008, 0.01450983299363144, -0.012804361507776368, -0.021798060106137645, -0.025262298945365434, 0.019985995022602066, 0.028513354314522645, -0.03232401722393773, -0.016028768011852147, -0.04905895687738259, 0.008960387982670792, 0.016295249212085586, 0.010652535967307758, 0.0039039311432322735, -0.007341522514362545, 0.01613536160953265, -0.009326798236007862, 0.015136060833947682, 0.005292957833624699, 0.0020951985648157857, -0.016281923848222267, -0.002571531428492672, 0.0037640292581678034, 0.007821186719005262, 0.03584155193068317, -0.0007090865067301475, 0.00923353000219068, 0.02367674269576376, -0.013683745184462727, -0.0063855259117042455, -0.012930939425961427, 0.0037940083000618046, 0.007468100432547605, 0.02067884316297667, 0.0015389216670317798, 0.015429189036617337, 0.02098529486686443, 0.0041104533283551035, 0.006308912520071001, 0.01009292749572727, 0.004799970127763874, -0.0004817457688773944, -0.012491247121956943, -0.016774912019744393, -0.019972671521383958, -0.002653140900252055, -0.016654996783490996, -0.015629048074147202, 0.0008993698016284647, -0.0071949584130277175, 0.019786135053749595, 0.019812783918831022, 0.00015520374833084897, -0.025688665885506595, 0.022011243576208223, 0.005852565839543884, 0.028460058447005, -0.018880103443304413, -0.00035204498047135263, 0.0017587675862033695, -0.014389916826055435, 0.008260878091687138, -0.011924977831090009, 0.011931639581699063, 0.009559967889228211, 0.006861858775381132, -0.0009335125540684506, -0.02157155127220374, -0.005579423820023997, 0.025701991249369917, 0.01884013293965009, -0.006655336590258302, 0.01694812498616065, -0.027447435101524528, -0.024249675599884963, -0.015642373438010525, -0.018626947606934296, -0.040478305443234795, -0.01765429662775336, 0.018760188207051016, -0.004107121987389274, 0.02097197136564632, -0.0011533585314477033, -0.019346444612390323, 0.014629749161207446, -0.01295758735972025, 0.012504571554497659, -0.020612223794240915, 0.03930579263255617, 0.017840833095387726, -0.019426387482344185, -0.029072961854780525, 0.011038931472471989, -0.004720025860826103, -0.022117835311243516, 0.038506352757146284, 0.011398679975200004, 0.00923353000219068, 0.0016022106261243095, 0.01915990814475596, -0.005119745798531049, 0.0042203759386949214, -0.008387456009872197, 0.019199880511055496, 0.024183054368503997, 0.03490887331780177, -0.01860030060449808, -0.009440051721652206, -0.005392887818050935, 0.033230048834382915, -0.011112213523139403, -0.023530178594428932, -0.004959858195978113, -0.021385014804569377, -0.015735641671827706, 0.009080304150246798, -0.01664167328227289, 0.010152886045176576, 0.009266839686558555, -0.022117835311243516, -0.008940401799521025, 0.0026997750171606463, -0.020119235622718785, -0.017241253188830307, 0.00248159453564132, 0.023889928028479553, -0.002776387943132587, 0.010605901850399167, 0.00205023011839011, 0.008021046687857735, 0.0006141530098836902, -0.018640272970797615, 0.0032393968399300624, 0.035068759057709495, -0.01869356883831526, -0.004879913929040342, 0.0018270530910833413, 0.009200220317822803, 0.010419366314087408, 0.030192176935296286, -0.017854156596605834, -0.016668320284709104, -0.0266080228598151, -0.007121676362360304, 0.033949543977193734, 0.012944262927179534, -0.008633950095633261, 0.004000530252353983, -0.016441813313420414, -0.007388156631271137, -0.01800072069794066, -0.003317675436384918, -0.00012376744849111715, -0.004836611153097581, -0.02335696749065789, 0.019333119248527004, 0.0014589777493399863, 0.003913924234807158, 0.005019815814104813, -0.04647410078351855, 0.019119935778456422, 0.011145524138829885, -0.015855556908081103, -0.006198989909731184, 0.0006882677211695728, 0.004843272903706635, -0.017041393219977833, 0.0006066582494101899, 0.0127244177064999, -0.020225827357754078, 0.03360312176965165, -0.008713893896909729, -0.007847834652764084, 0.00848072424368938, 0.01356382901688672, 0.009020346532120098, 0.006731949516230243, -0.005979143757728942, 0.017720915996489114, -0.006928478609778188, 0.014922877363877101, -0.017014744354896406, -0.01132539792453259, 0.021984594711126796, -0.01248458537134789, -0.025248975444147326, 0.004849935119976992, -0.021518255404686097, 0.0016971441811784295, 0.012318035086863292, -0.005859227590152938, 0.04058489717827009, -0.012377993636312598, -0.012211443351828003, -0.0318177055511975, 0.014469860627331903, -0.008254216341078084, -0.02499581960777721, -0.01213816130116059, -0.012351345702553777, -0.0073348602980921876, -4.27044520993621e-05, -2.7038345287139966e-05, -0.022331018781314094, -0.007634650251370897, 0.023157107521805415, 0.016761588518526285, 0.020518955560423734, 0.008747204512600212, -0.006402180753888184, -0.010312773647729511, 0.006065749775275768, -0.024076462633468704, -0.008347484574895267, -0.018880103443304413, 0.004456876932881101, 0.003279368740568296, -0.02960592239260219, -0.015389216670317798, -0.004296989330328165, -0.017640973126535252, -0.005043132872559108, -0.01521600463522415, 0.01351719489997813, 0.009573292321768926, -0.011745104045387304, 0.010945664169977413, 0.004540152075123399, 0.0058325796563941145, 0.016335221578385125, -0.03221742548890245, -0.014603101227448623, 0.005902530831757001, -0.0019319796212970198, 0.02174476423862, -0.011232129690715407, -0.029072961854780525, -0.006035770966212418, 0.0038906071763528624, -0.0037373813244089807, -0.010685845651675635, 0.019786135053749595, -0.03424267217986339, 0.024116434999768243, -0.016868180253561578, 0.0065320895473777695, 0.016588377414755242, -0.006731949516230243, -0.015815584541781568, -0.027580673838996032, -0.031044914540869037, -0.015109412900188858, 0.010452675998455285, -0.008220906656710207, -0.003231069418838093, 0.004140432137418454, -0.006855196559110774, 0.018986697040984917, -0.014003521320891204, 0.0073681704481213675, 0.000996801571368643, -0.014949525297635923, -0.0008668925450484052, -0.003860628134458861, -0.015722316307964383, -0.0026714614129189087, -0.009007022099579385, 0.00934678441915763, -0.017214604323748876, 0.01323739112984919, -0.009273502368490217, 0.004936541137523818, 0.006788576724713718, 0.0007532222343296917, -0.0024599429148392878, -0.0270743621662558, 0.01918655700983739, -0.04287662506946447, 0.01214482398309225, -0.009893067526874797, -0.009913053710024565, -0.02726089863389016, 0.026448135257262164, 0.00244828438561214, -0.018200580666793132, -0.015708992806746275, -0.006039101841516945, -0.014696369461265806, 0.02495584724147767, -0.013623787566336027, -0.015162708767706503, -0.02888642538714616, -0.012364669203771885, -0.008360808076113375, -0.0020585575394820787, -0.01773423949770722, -0.0237167150620633, 0.006648674839649248, -0.004966519946587167, 0.004373602256300106, 0.22725410063589882, -0.0049198858296785756, -0.003950565260140865, 0.040451654715508156, -0.0004076310284876803, 0.007927778454040552, 0.0399186960403317, 0.0005242160006170123, 0.004383594882213687, 0.003102825830170119, -0.003647444198726977, -0.017680943630189575, 0.008287526025445961, 0.010732479768584225, -0.00016988097061421874, -0.006035770966212418, -0.023290348121922134, -0.00994636432571505, -0.02230437177887788, -0.011145524138829885, -0.012391317137530706, -0.02021250385653597, -0.027607322704077463, 0.0023883265346547893, 0.017081363723632156, 0.010032969877600571, -0.023796659794662372, 0.0010934005640750265, 0.021984594711126796, 0.01115218588943894, 0.006308912520071001, -0.014896229430118278, 0.01833381940426464, 0.006458807496710356, -0.007787876568976082, 0.009353446169766685, -0.008027708438466789, 0.011771751979146127, 0.03205753602370429, 0.021078563100681614, -0.0037473741831532134, 0.02486257900766049, -0.011018946220644827, -0.02123845256587976, -0.011891667215399524, 0.029579273527520763, -0.02229104827765977, 0.0002625243888254035, -0.007088366677992427, 0.003214414343823503, -0.033176754829510484, 0.010412703632155747, 0.026661318727332742, 0.011305411741382821, 0.008340821892963606, 0.012817685008994476, 0.03203088902126808, 0.019572951583679013, 0.002763063976253176, -0.006162348884397477, -0.009486685838560797, 0.01650843268215617, -0.020172531490236432, 0.008633950095633261, -0.015016144666371675, 0.005099760081042583, -0.023983194399651523, -0.008887105932003378, -0.008147624606042793, -0.005775952913571943, 0.009979674010082925, -0.02551545478173555, 0.007241592529936309, -0.004733349827705514, -0.020132559123936893, -0.03456244738496926, -0.006455476621405829, 0.026208302922110155, 0.015629048074147202, -0.010372732197178818, -0.0032560519149446524, -0.007887806087741015, -0.01450983299363144, 0.006592047631165772, -0.0049565268550122825, -0.03418937817499096, 0.011798399912904949, -0.006082404617459706, 0.013150785577963668, 0.004979843913466579, -0.00020079680663570248, -0.025155707210330145, -0.001083407472500142, -0.03000564233030714, -0.01646846031585663, 0.032643792429043604, -0.017361168425083704, 0.03525529552534386, -0.016774912019744393, 0.006821886409081594, -0.006159017543431646, -0.025129058345248714, 0.03325669583681913, 0.0013806992693004563, -0.007521396300065249, 0.007754566418946902, -0.011098890021921295, 0.01638851744590277, 0.007694608335158899, 0.0009768155046342001, 0.004893237895919753, -0.00527630299144076, 0.014363268892296612, -0.0033143443282497393, 0.037307192944031446, -0.008474062493080326, -0.002330034121349702, -0.017507732526418532, 0.016028768011852147, 0.005066449931013403, -0.00646880058828524, -0.030671841605600308, -0.0019636241008432844, 0.007474762648817961, -0.006478793679860125, -0.0030611884918796215, -0.01201158338297553, 0.023383614493094104, 0.0069418025766576, -0.023050515786770125, 0.008833810064485734, -0.0068418725922313635, 0.018320495903046533, 0.004290327114057808, -0.009506672021710566, 0.0031627839139581216, -0.0048466042446724655, -0.01039271744900598, -0.0037407121997135077, -0.01905331640972067, 0.005153055948560229, -0.01502946909891239, 0.019466359848643724, 0.009999660193232694, -0.00968654580741327, -0.017041393219977833, 0.008747204512600212, 0.006025777874637534, -0.017854156596605834, -0.02563537001798895, 0.003206086922731534, -0.017694268994052898, -0.0022667449294265208, 0.0015655697172059283, 0.020132559123936893, -0.012384655386921652, -0.025968470586958142, -0.01650843268215617, -0.015402541102858514, 0.005459508118109295, -0.010199520162085167, 0.020012643887683496, 0.0002733501410187566, -0.010366069515247156, -0.01833381940426464, -0.009273502368490217, -0.17342514405791226, 0.023929898532133877, -0.0009559967772812886, -0.02492919837639624, 0.017947424830423015, -0.0049865061297369355, 0.026421486392180733, 0.003560838181180152, -0.019306472246090788, 0.008600640411265384, 0.013084165277905308, -0.004640082059549635, -0.05191029417148007, -0.03069849047068174, 0.011984935449216708, 0.009599940255527748, -0.005496148677781699, 0.011058917655621758, 0.02790045090674712, 0.010625888033548934, 0.0053362610752287635, -0.018960048175903486, 0.0047433429192803985, -0.004027178186112806, 0.0033293337327814144, -0.0003328917489783674, -0.022903951685435298, 0.0036307893565430387, -0.015469160471594266, -0.019079963412156883, -0.03203088902126808, -0.009113613834614674, -0.0057959386310604075, 0.016415164448338987, 0.0145764532936898, 0.019413063981126077, -0.007214944596177486, -0.000898537082802333, -0.00964657437243634, 0.034615745115132115, 0.008487385994298434, 0.023370290991875996, -0.015229329067764863, 0.006198989909731184, -0.023756687428362833, 0.034082786439955666, 0.019599600448760444, 0.008274202524227853, 0.011751765795996358, -0.025688665885506595, 0.014096789554708387, 0.003337661386704035, -0.005279633866745287, 0.0043935879737885715, 0.00048132940946432856, 0.013317334931125658, 0.012391317137530706, 0.011651835811570121, 0.007108352395480892, 0.012964249110329304, -0.005462838993413822, -0.018280523536746994, 0.013803661352038732, -0.005286296083015645, -0.0009843103233153634, -0.009706531990563039, -0.02163817250358471, 0.00042886617346132074, -0.05012487795302592, 0.019239852877355034, -0.013450575531242378, 0.0006199822744972642, 0.026554726992297453, -0.019253176378573142, 0.002939606886651353, 0.014709692962483914, -0.02266411935028329, 0.03245725596140924, 0.0007111683620031397, -0.023503531591992716, -0.015176033200247218, 0.030964969808269963, -0.0029612585074533853, -0.004073812303021397, -0.014363268892296612, 0.045274940970403715, -0.01640184094712088, 0.0010634215221810254, -0.002624827528840969, -0.01824055303309267, 0.004450215182272047, -0.015962148643116396, -0.0063555466369795924, -0.029899050595271846, -0.0015339252376596637, 0.010659197717916812, -0.002210117953773697, 0.006185665942851772, 0.006928478609778188, -0.018786837072132443, 0.017014744354896406, -0.007128338578630661, -0.011172172072588709, 0.02034574445665269, 0.03229737022150152, 0.004183735379022517, 0.015922176276816857, 0.004869920837465458, 0.013610463133795313, 0.005352915917412701, -0.0071949584130277175, 0.02094532436321011, 0.026981093932438614, 0.030085585200260997, -0.019919375653866315, -0.019333119248527004, 0.00859397866065633, -0.00904033178394726, 0.03176440782103464, -0.011238791441324461, 0.03834646329194814, 0.01440324125859615, -0.016068740378151685, 0.004829948936827224, 0.008367470758045035, -0.009519996454251282, -0.08138297782661076, -0.035921496663282246, 0.0049898370050414625, 0.008673922461932798, 0.005203020940773347, -0.0009276832894548766, 0.016215304479486513, 0.02808698551173627, -0.007767890385826313, 0.03688082600389029, -0.009699870239953985, -0.01915990814475596, -0.0003526695486947829, 0.006765259666259423, 0.030645194603164092, -0.0026631339918269394, -0.0034092777668885336, -0.024716014906325662, -0.008647274528173977, 0.00664201262337889, 4.166351354892916e-05, -0.006928478609778188, -0.013523857581909791, -0.0042936579893623344, -2.3382054585934765e-05, -0.011545244076534832, -0.028380113714405925, 0.03464239211756833, 0.028939721254663806, 0.012064879250493175, 0.026035089955693896, -0.01600212100941593, 0.023370290991875996, -0.03600144139588132, -0.0061390318259431816, 0.019079963412156883, -0.034748983852603624, 0.017334519560002273, 0.00678191450844336, -0.022331018781314094, -0.0017737571071503703, 0.0005596078895038586, 0.005809262597939819, -0.024462859069955545, 0.006538751763648127, -0.017707592495271006, -0.004803301003068401, 0.0013315669959134697, -0.004383594882213687, -0.019386416978689862, -0.0067386117325005995, 0.01412343748846721, 0.002689781925585762, -0.008507372177448203, 0.02018585499145454, -0.0318177055511975, -0.010812423569860693, 0.002862993960679412, -0.01870689233953337, -0.0033676404285980363, 0.007181634446148306, -0.005216344907652758, 0.0027863810347074714, 0.023023866921688695, 0.013790336919498016, -0.001780419090590076, -0.019972671521383958, -0.010079603994509162, 0.00846073806053961, -0.0261416835533744, -0.008953726232061738, 7.791415827713962e-05, -0.0033726367415548267, 0.01869356883831526, -0.017601000760235713, 0.007488086615697373, -0.007095028428601481, -0.006615364689620068, 0.020758787895575743, -0.010932339737436698, -0.012644472973900825, -0.01589552927438064, 0.002378333443079905, 0.0031960938311566497, 0.01201158338297553, 0.01246459918819812, 0.01600212100941593, -0.00041179479724132785, 0.014696369461265806, -0.022051215942507762, -0.0014173401782188373, 0.022837330454054332, 0.015522457270434518, -0.016175332113186974, -0.020598900293022807, 0.00506978080631793, 0.013737041051980372, 0.006855196559110774, 0.025608723015552736, -0.004979843913466579, -0.013410603164942839, 0.00181372912420393, -0.09369434743757457, 0.031897650283796576, 0.006395518537617826, -0.015082764966430035, 0.013037531160996717, 0.0009534985625952304, 0.006112383892184359, -0.012564529172624357, -0.0198927286514301, -0.010992297355563398, -0.01613536160953265, 0.006135700950638655, -0.006132369609672824, -0.009413403787893383, -0.0005458675050037185, -0.017774211864006757, 0.007954426387799375, -0.011112213523139403, 0.015042792600130498, 0.017800860729088187, 0.013037531160996717, -0.0021518255404686095, 0.024382914337356468, -0.008374132508654089, 0.0003576660653783936, -0.004007192002963037, -0.006485455896130482, 0.003587486347769626, -0.011505271710235293, -0.021424987170868912, -0.0032110832356883243, -0.02091867549812868, 0.001100062547514732, 0.04407578488257931, -0.011531919643994117, -0.03418937817499096, -0.0015730644194717658, 0.003860628134458861, -0.008420766625562681, -0.0076812843682794885, -0.01681488438604393, -0.024316294968620717, -0.0006599542333431609, -0.009866419593115974, -0.011651835811570121, -0.010585915667249398, -0.004363609164725221, 0.007281564430574543, 0.016321896214521802, -0.006895168459749008, 0.014043492755868135, 0.0039072620185368005, -0.0011025608204084532, -0.003107822375957561, -0.00524299284141158, -0.043116455541971264, 0.010286125713970688, -0.006099059925304948, -0.006728618640925716, -0.015362568736558977, 0.029579273527520763, 0.03200424201883186, 0.009240191752799734, 0.00444688430696752, 0.02183803247243718, -0.013050855593537431, -0.016694969149790535, -0.006685315864982955, 0.007041732561083836, -0.006228968718794533, -0.015442512537835445, -8.629370433127852e-05, 0.02163817250358471, 0.016548405048455707, 0.029712514127637483, -0.0013565494920200287, -0.009999660193232694, 0.016201980978268405, -0.02111853546698115, 0.026661318727332742, 0.012884305309052836, 0.0022950585336682584, -0.02331699512435835, 0.018293848900610317, 0.012477923620738835, 0.02251755524894846, -0.008787175947577143, 0.0012341352843809545, 0.0075480442338240715, 0.010665859468525865, -0.012064879250493175, -0.004340292106270926, -0.011265439375083284, -0.00016946459664923713, -0.021851355973655288, -0.009373432352916454, -0.001136703572848439, 0.0014664724516058236, 0.018866779942086305, 0.03602808839831754, 0.0030028958457438827, -0.01698809735246019, 0.002508242469400143, -0.010306111897120458, 0.0015439182128192221, 0.015295948436500617, -0.017241253188830307, 0.0015980469155783248, -0.012477923620738835, 0.0012166474905402327, 0.01566902044044674, -0.021265099568315977, -0.01693479962229733, 0.016295249212085586, -0.007414804565029959, -0.004350285197845811, -0.013084165277905308, -0.023823306797098587, -0.02217113117876116, 0.02656805049351556, 0.020132559123936893, 0.01149194727769458, 0.010052956060750339, -0.02608838582321154, -0.0007040899609427053, 0.004030509061417333, 0.0270743621662558, -0.023330318625576458, 0.01685485675234347, 0.004353616073150338, 0.005646043654421053, -0.03099161681070618, -0.0036740923653164515, -0.01765429662775336, 0.0024599429148392878, 0.0007615497136293237, 0.005782614664180997, 0.02310381165428777, -0.0027230918427842902, 0.05425531606754688, -0.009440051721652206, -0.025715314750588025, 0.006169010635006531, -0.0037273882328340965, 0.012058217499884121, -0.0019036661334706079, 0.029419385924967827, -0.019199880511055496, -0.00681522465847254, 0.014523157426172155, -0.016761588518526285, 0.016201980978268405, -0.0019503001339638733, -0.017694268994052898, 0.003324337419824624, -0.017307872557566058, 0.00846073806053961, -0.028300170844452063, 0.0027447434635863226, 0.024063139132250597, 0.003042867979212768, 0.010132899862026807, -0.012304711585645185, -0.009253516185340448, -0.01214482398309225, 0.001289096705966189, -0.00886711974885361, -0.007341522514362545, -0.025741963615669456, 0.025608723015552736, 0.008753866263209266, -0.03712065647639708, -0.0056527058706914105, 0.006645343498683417, -0.019000020542203025, -0.00667532277340807, -0.015695669305528168, 0.008094328738525149, -0.001574729973539355, -0.025968470586958142, 0.02159820013728517, -0.01566902044044674, -0.03642780833602248, 0.015176033200247218, 0.012611163289532948, -0.011871681963572363, -0.0036574372903018615, -0.005755966730422174]"
10,Banana,"[-0.01302593772857713, -0.019896900474770694, 0.007329445403554062, -0.00549237342303734, -0.01065815623036848, -0.008221288291580541, -0.014457912324874535, -0.014131321709168336, -0.008233849970589093, -0.014884991716036237, -0.003063356533629746, 0.007071941228427152, 0.004157748579427176, 0.006946329560615835, -0.002193495186884359, 0.020449591999405003, 0.03954257854524133, -0.02098972184503076, 0.01271818963138376, -0.01864078286533494, -0.022584991749181264, -0.012799836819649019, 0.013553507757839502, -0.011820064972530422, -0.0014602365114214804, 0.0016470840360930327, 0.009113132110929604, -0.027760194884446237, 0.018000163312931094, -0.006393638035981524, 0.04316019681338146, -0.0267553015419557, -0.011254812700210141, -0.025876019401615193, -0.02065057141296118, -0.008736296641834361, -0.015211582331742435, -0.0015677915805652636, 0.011656769664677323, -0.00854787890728674, -0.0022720024210587703, 0.027760194884446237, -0.004506321202075759, -0.023062316925054595, -0.031654160777548686, 0.024004403735147534, -0.015965253269932922, -0.023313539329354645, -0.04233115952643, 0.013365090023291882, 0.019457258473277853, 0.018804079104510624, -0.009364355446552237, 0.0014421797963386238, 7.178515149229038e-05, 0.0121215331615421, -0.0024023247184982947, 0.01779918389937492, -0.0011854608425650713, -0.005379322968573284, -0.004826631443938973, 0.025411255904750414, -0.017271615732757716, 0.02062544805494407, -0.0038405792229773915, -0.010224795999702501, 0.002860807608689441, -0.013716802134370019, 0.003912806083308819, 0.02114045640519789, 0.007913540194387171, 0.015186459905047914, 0.00166749594957467, -0.004374429160421457, 0.009301549845477224, 0.005366761755226023, -0.02179363763661029, 0.0012239294711295654, -0.018000163312931094, -0.008629527026874582, 0.018138336194089673, -0.029996084341000585, -0.015085970198269827, 0.016153671004480542, 0.029192170412066225, 0.011977079440879244, -0.021630343260079773, 0.005583441870559012, -0.007323164564049786, -0.025850897906243255, -0.010758645937146568, 0.00932039143266747, 0.018603099690954448, 0.009565333928785828, -0.02088923400089784, 0.022584991749181264, 0.01806296984532869, 0.03615105932338415, -0.008629527026874582, -0.046752691723504484, -0.0105827898816075, 0.017861990431772518, -0.02436867938787939, -0.018100653019709183, -0.009081728844730805, 0.007034257588385369, -0.0031811173848913634, -0.0016455138262169635, 0.02745872762675714, -0.0410247970636052, -0.0056242659303529325, 0.024016965414156086, 0.002851386582263672, -0.03170440376829256, -0.01097218609838871, 0.001975244628844655, -0.001978385048596793, -0.005212887240968046, -0.016744045703495344, -0.025398694225741862, 0.023200489806213174, -0.0006092169846969847, 0.02868972187817579, -0.010846573964916102, 0.015688907507615764, 0.006858401067185009, 0.003834298616303761, -0.011832626651538974, -0.023037193567037487, 0.0006818362810821061, 0.035347145394449796, 0.0075555463124821745, 0.008679771880263625, 0.012423001350553776, -0.011342740727979675, 0.013854975946851181, -0.024381239204242774, -0.019695921061214518, 0.00854787890728674, -0.019457258473277853, 0.004898857838609108, 0.01933164727112783, -0.014244372163632392, -0.019545188363692557, -0.0023819126886013343, 0.03250832142251726, 0.024330994350853733, 0.03260880740400501, 0.0019328507084206336, -0.015010603849508846, 0.02036166397163547, -0.013528385331144982, 0.0402208794093805, -0.01742234843027968, -0.0010488580548672396, 0.007417373431323596, -0.015186459905047914, -0.00290163120282207, 0.012561174231712354, -0.0016549347362274092, 0.014910114142730758, -0.004229975439758603, -0.002944025239661414, -0.00729176176351228, 0.005592863129815427, 0.030498531012245853, 0.008145921942819559, 0.007875856088684097, -0.005649388357047454, -0.015249265506122926, -0.021894127343388376, 0.032583687771278236, -0.02232120766587266, 0.024205383148703706, 0.01650538311555868, -0.006431321210362015, -0.017460033467305337, -0.003019392286914333, 0.0022468799943642487, 0.0015348184537363652, -0.02227096281248362, 0.008051713075545749, 0.006965171147806081, 0.028790211584953877, -0.007737683673186811, 0.0023740618720516347, -0.0036301794814873867, -0.02473295317796608, 0.01952006500567545, -0.012573735910720906, 0.023439152394149836, 0.02039934714601596, 0.01654306628993917, -0.0030884787274936217, -0.6957885690630798, -0.007593229952523957, -0.005793841612049017, -0.005253711300761967, 0.033261988635417405, 0.04567243203225296, 0.010934501992685636, 0.005429567821962327, -0.010394372147059877, -0.018075529661692076, 0.000620993093106211, 0.013955464722306684, 0.004277079873395508, -0.0037369493292778123, -0.0009876223144223274, -0.025775529694837106, 0.023702936477458438, -0.005806402825396278, -0.009565333928785828, 0.018954811802032588, -0.02145448534189554, 0.018590538011945896, -0.009659542796059638, -0.0021558115468425765, 0.00182294044087807, 0.01046973849582086, 0.008177324277695774, -0.010193392733503703, 0.0036144780812186338, 0.015286949611826, -0.024933930728877087, 0.010168270306809182, 0.011788662637654207, 0.004506321202075759, 0.059288744459844896, 0.00587234931188472, -0.0099296086501951, 0.014596085206033112, -0.005074714359809468, 0.023388907540760794, 0.004572267688564201, -0.021843882489999335, 0.010965905258884434, -0.01842724363541538, -0.014520717925949547, 0.00032089875042460214, 0.03866329454225566, -0.006883523493879531, 0.0022735726309348397, -0.01787455211078107, 0.020085318209318314, -0.000729725703241723, -0.011688172930876121, -0.0160406196186939, -0.004412112334801948, 0.01797503995491399, 0.023501957063902266, -0.014596085206033112, -0.014746818834877658, 0.011148042153927779, -0.021843882489999335, 0.006940048721111559, -0.02778531824246334, -0.02901631249388199, -0.005426427402210189, 0.0056525283111383, -0.0037683523626459645, 0.012391599015677561, 0.021291190965365022, -0.013528385331144982, 0.026579445486416633, -0.0013008666118432307, -0.01403083200239025, -0.01915579121558876, 0.008177324277695774, 0.007693719193640752, 0.011462072021948008, -0.012391599015677561, -0.02024861258584883, -0.00333499189914934, 0.016103426151091497, 0.017472593283668722, 0.0012443413846112028, -0.012938009700807596, 0.016932463438042965, -0.020022511676920717, -0.02597650910839328, -0.001854343357830899, 0.005467250996342818, -0.009565333928785828, 0.018917128627652095, 0.018879445453271606, 0.012655383098986164, 0.023615008449688904, -0.024544535443418457, 0.008623246187370306, -0.03481957722783259, -0.009521369914901061, 0.0009758462642207625, 0.010739804349956321, -0.001494779731711125, 0.008014028969842674, -0.017233930695732057, 0.002350509888063828, -0.00044474407764449496, 0.014470473072560504, -0.011493474356824223, 0.027835563095852386, 0.029945839487611543, -0.04697879449507776, 0.007857014501493852, -0.025298206381608943, -0.00242116630568854, -0.019067863187819226, 0.03539738838519367, -0.019871778979398753, 0.0003087301186501893, -0.016593311143328213, 0.0033287112924757097, -0.02693115759749477, 0.013415333945358342, 0.010834013217230133, 0.008177324277695774, 0.012071288308153055, 0.0032596248518964206, 0.007360848204091569, -0.00783189207479933, -0.02645383428426661, -0.015425122492984578, -0.025059543793672277, -0.012925448953121628, -0.002821553758771589, -0.0027587479248659306, -0.005256851720514105, 0.030925611334730138, 0.008039151396537197, 0.016681239171097748, -0.003875122443267036, 0.012912887274113074, -0.022471940363394626, -0.02688091274410573, -0.013365090023291882, -0.0015999796024561274, 0.023426590715141284, -0.012724469539565453, -0.011091517392357043, -0.018540293158556855, -0.019231157564349743, -0.007172430469543948, 0.012787276071963049, 0.012234583616006154, -0.0060513457871759265, -0.011141762245746086, 0.024607340113170888, 0.014470473072560504, -0.02333866268737175, -0.002904771622574208, -0.014369983365782416, 0.0018621941743805987, -0.008855627935802694, 0.021303752644373574, 0.028162153711558585, -0.002465130552403953, -0.003444902166691904, 0.00522230850022446, -0.03612593969065738, -0.01473425808719169, 0.011091517392357043, -0.030674388930430087, -0.03069951042580203, 0.002239029410645195, -0.022032300224546955, -0.0034166395530758897, 0.0018449225642357765, -0.004390130327859564, 0.01654306628993917, 0.004550285681621817, -0.0185277314795483, 0.003746370355703581, -0.004653915342490751, -0.005539477856674245, -0.005388743762168406, -0.0044623571881909916, 0.014244372163632392, 0.02564991849268708, 0.018088091340700628, 0.005665089524485562, 0.04215530347089093, -0.022095106756944552, 0.006676264172141665, 0.013076182581966174, -0.013528385331144982, 0.000911470220439035, -0.006619738944909637, -0.0016046899992536885, -0.002636276443976106, -0.00926386573977415, 0.01877895574649352, 0.012950571379816148, 0.034040782931625, 0.01908042486682778, 0.0017114600798747602, -0.004010154904673475, 0.0024415783355855, 0.005090415992908867, -0.02465758496655993, 0.023439152394149836, -0.017949918459542052, 0.0390401300113509, 0.01882920059988256, 0.0018684746646389062, -0.018540293158556855, -0.007404812217976336, 0.0033004486788596956, 0.014093637603465261, 0.017899673606153008, 0.009031484922664345, 8.635807255198413e-05, 0.013453018051061416, -0.005413866188862928, 0.0023881932952749645, 0.006409339203419632, 0.003319290266049941, 0.005605424343162687, -0.008378303691251948, 0.02828776491370861, 0.014043392750076218, 0.052706689154977046, 0.00435558710756992, -0.03424176234518117, -0.00430220230009003, 0.0007352212631849803, 0.004035277331367998, 0.019067863187819226, 0.010004975930278666, -0.004606810908853845, 0.0242430663230842, -0.015211582331742435, 0.01137414306285589, 0.012071288308153055, -0.017585644669455364, 0.01970848274022307, 0.014558401100330038, 0.017510276458049215, 0.01080889079053561, 0.006487846437594044, 0.02340146735712418, 0.0009632850508735016, 0.0007383615665217956, 0.00948368674052057, -0.008302936411168383, 0.004189151845625974, -0.02179363763661029, -0.002176223576739537, -0.005187765279934816, -0.02678042489997281, 0.015161337478353392, 0.019067863187819226, 0.0100929039580482, 0.03203099624664393, 0.03818596936638233, 0.007027977214542385, 0.002730485311249917, -0.008353181264557426, -0.0022500204141163867, 0.008585563012989815, 0.006588336144372131, 0.007762805634220041, -0.0013793739624329653, 0.007838172914303606, 0.002078874289713588, -0.0008989090652994356, 0.008623246187370306, -0.01599037476530486, -0.002154241336966507, -0.013553507757839502, 0.00799518738265243, 0.03328711199343451, -0.020462153678413555, -0.012033605133772565, -0.008648368614064827, -0.035045676274115534, 0.002863947795610933, -0.009012642404151517, -0.009640701208869392, -0.01965823788683403, -0.019758727593612115, 0.004324184307032413, 0.004691598516871241, 0.025700163346076124, -0.0032878874655124348, 0.025901142759632297, -0.008321777998358627, -0.00013081285705855738, -0.013101305008660696, 0.024846002701107553, 0.00010274648329726359, -0.009571614768290104, 0.005913172906017349, 0.007115905242311919, 0.011179445420126577, -0.006246043895566532, -0.001939131315094264, -0.005040171139519824, 0.021743392783221245, -0.0038845432368621586, 0.0032596248518964206, -0.02013556306270736, 0.01454584035264407, 0.011267373447896111, -0.0004961664138176059, -0.004352447153479074, 0.012938009700807596, -0.015412560813976026, 0.007863295340998128, 0.00941460029994128, -0.015588417800837678, -0.016480261620186742, 0.03351321476500779, -0.0042456770728580015, -0.0074299346446708575, -0.006415620042923908, -0.01754796149507487, 0.00532907811518424, 0.05964045657092303, 0.03574910422156214, -0.007982626634966461, 0.0022029159804794816, 0.01282495924634354, -0.0060513457871759265, -0.028538989180653826, 0.006676264172141665, 0.008730016733652668, -0.0001871418662637382, 0.002526366176433542, -0.0035139886072711925, 0.030975856188119183, 0.0016054751041917233, 0.007825612166617637, -0.011757259371455409, -0.014118760030159784, -0.010319004866976312, 0.005417006608615067, -0.0235898850916718, 0.005121818793446374, 0.008372022851747672, 0.02843849947387574, 0.0108779772311149, 0.002620575043707353, 0.008799103174231958, 0.00954021243341389, 0.02458221861779895, 0.02637846607286046, -0.017108319493582033, -0.005206606867125062, 0.0012011623592491473, 0.0014390396094171314, -0.003658442095103401, -0.005724755171469728, 0.0002810562755300397, 0.007687438819797767, 0.0010033238311064035, -0.001217648864455935, -0.0034574633800391647, 0.011279935126904663, 0.0034668841736342874, -0.0029660072466037974, -0.008171044369514081, 0.014809624435952672, -0.007461337445208363, -0.012165497175426867, 0.021554975048673625, -0.005473531835847094, -0.009678385314572466, 0.013277161064199764, -0.017472593283668722, -0.009433441887131527, -0.0019579730186998325, -0.00317954740784594, 0.0022578712306660863, 0.0041954322194689584, -0.008761419068528883, -0.004873735877575878, -0.01403083200239025, -0.01438254504479097, -0.004386990373768718, 0.016530506473575783, 0.011361582315169922, -0.0007466048191251894, -0.011330179048971123, -0.023866230853988955, -0.02803654064676339, -0.013113865756346665, -0.005592863129815427, -0.00871117421513984, -0.009709787649448682, -0.01566378414959866, 0.007875856088684097, 0.029669493725294385, 0.012737031218574005, 0.004060399758062519, -0.0035987764481192346, 0.009370636286056513, 0.03188025982383163, 0.01198336028038352, -0.015186459905047914, -0.004779527010302068, -0.005341639328531501, 0.0006457228509163926, 0.01372936381337857, 0.025775529694837106, -0.004446655555091592, -0.004154608625336329, 0.01159396406360231, 0.033362478342195495, -0.02345171221051322, 0.015940129911915814, -0.012925448953121628, -0.011060114126158245, -0.007499021085250146, 0.019620554712453536, -0.0037809135759932252, -0.01573915236100481, -0.008321777998358627, -0.0017868271271276794, -0.022296084307855558, 0.01067699874888131, -0.001062204373152535, -0.00364588088175614, 0.017271615732757716, 0.013566068505525473, 0.009502528327710815, -0.01722137087936867, 0.007838172914303606, 0.03549787809197175, -0.0055771614967160274, 0.003250203825470652, 0.002207626377277043, 0.005435848195805311, 0.029443392816366275, 0.004358727527322058, -0.005570881122873043, -0.008836786348612449, -0.022333767482236047, 0.0009153955705062233, -0.027182381864439987, 0.01797503995491399, 0.0008003823536970809, -0.004251957446700987, 0.004779527010302068, 0.02024861258584883, -0.025599673639298038, -0.004456076814348006, -0.0030445147136088546, 0.014558401100330038, 0.02106509005643691, -0.007404812217976336, -0.004280220293147646, -0.02081386578949169, -0.015688907507615764, -0.011110358979547288, 0.003250203825470652, 0.003331851479397202, -0.02385367103762557, -0.015249265506122926, 0.012341354162288518, 0.01753539981606632, -0.016053181297702456, -0.03981892430755849, -0.031779770117053546, -0.0012514069798075448, 0.027433604268740037, -0.0005424857425164766, 0.012504649470141618, -0.005561459863616628, 0.01477194126157218, -0.010614192216483713, 0.0018355016542253308, -0.002223327777545796, -0.0421804231036177, -0.03818596936638233, 0.005238009667662568, 0.023288417833982708, 0.003193678598238624, 0.022409135693642196, 0.0019187194016126268, 0.022584991749181264, 0.022007176866529848, -0.011235970181697313, -0.013239477889819273, 0.01045717774813489, -0.014457912324874535, -0.017711255871605387, 0.011330179048971123, 0.03926623278292418, 0.03132756829919732, 0.009709787649448682, 0.01934420895013638, -0.01350326290445046, 0.03190538318184873, 0.0049239802653036294, -0.01783686707375541, -0.015475367346373623, -0.026328221219471416, -0.0036301794814873867, -0.010702120244253247, -0.00012688749243945372, 0.008692332627949594, 0.010890537978800869, -0.011009869272769202, 0.023979282239775596, -0.019909462153779246, 0.004233115859510741, 0.00033071218380023435, 0.017196247521351567, -0.01139298558136872, 0.012561174231712354, 0.00851019573290625, 0.012335073322784242, -0.03484469686055936, -0.011104078140043012, 0.014696573981488615, -0.006132993441102476, -0.0018135195308676244, 0.014432789898180013, 0.013716802134370019, -0.021894127343388376, -0.0003228614254581963, -0.01155628088922182, 0.031352691657214424, 0.0042927815064949075, -0.00957789560779438, 0.022032300224546955, -0.017183685842343015, -0.011116639819051564, -0.02660456698178857, -0.021391680672143108, -0.045044370433567335, 0.003743229935951443, 0.02494649240788564, -0.01256745507121663, 0.03069951042580203, -0.016404893408780593, -0.009854241370111535, -0.004393270747611702, 0.01742234843027968, 0.03941696548044614, -0.0018402120510228922, 0.026252854870710433, 0.015827080388774343, -0.005630546304195917, -0.004657055296581597, 0.01831419224962874, 0.007473898658555625, -0.013176672288744262, 0.022572430070172712, -0.00675163145222523, 0.006198939461929627, -0.035322022036432685, 0.004283360712899784, 0.020223491090476893, 0.0009711358092155397, -0.01930652577575589, 0.01862822118632639, 0.004600530069349569, 0.024544535443418457, -0.008026590648851228, -0.017108319493582033, -0.010595350629293468, 0.017522838137057767, -0.0006190303889687862, -0.015500489773068143, -0.024029527093164638, -0.02828776491370861, -0.02312512159480702, 0.01768613437623345, -0.018088091340700628, 0.025084665289044218, -0.010193392733503703, -0.021668026434460266, -0.0010103894263027455, 0.01625416071125863, 0.0005958707246193508, 0.00827781398447386, 0.006795595466109997, 0.009917046971186548, 0.015462805667365069, 0.023137683273815577, -0.012102691574351853, 0.006026223360481405, -0.0166938008501063, 0.01625416071125863, 0.023288417833982708, 0.02547406243714801, -0.002206056167400974, -0.012247145295014708, -0.016266720527622014, -0.0021573817567186455, 0.006984013200657618, -0.004584828901911461, -0.00948368674052057, -0.00532907811518424, -0.0005680006052646926, -0.01405595442908477, 0.010633033803673959, 0.01915579121558876, -0.04946590635593216, -0.02597650910839328, -0.006487846437594044, -0.0025844616135416395, -0.04813442053509026, -0.0156135402275322, 0.001937561221633518, -0.024858564380116105, -0.014194127310243347, 0.009785154929532247, 0.005426427402210189, 0.009131973698119848, 0.01266166393849044, -0.00854787890728674, -0.0026048736434386, 0.015274387932817449, -0.02345171221051322, 0.04094943071484422, 0.0017036092633250606, -0.0018056688307332477, -0.014859869289341715, -0.0026299958373024756, 0.0027728793480892608, -0.017309298907138206, 0.013252039568827825, -0.02906655734727103, -0.03941696548044614, -0.011317618301285155, -0.011939396266498753, 0.02296182721827651, -0.0004160889115594637, 0.0013134278251904917, 0.03509592299014974, 0.0007124540930969008, 0.007078222067931429, -0.013905219868917641, 0.002904771622574208, 0.0024180261187670476, -0.04160260822096628, -0.013264600316513796, 0.00666998379829868, -0.0013503262438789168, -0.018615661369963003, -0.0036961255023145374, 0.004704159730218502, 0.009734910076143204, -0.04245676886593485, -0.02652920063302759, -0.008616965347866028, 0.05356084979994562, -0.008001468222156706, -0.008887031202001492, -0.007819331327113361, -0.014746818834877658, -0.00911941295043388, 0.0009993984228315537, -0.024456607415648923, -0.02803654064676339, 0.005388743762168406, 0.025046982114663725, 0.015274387932817449, 0.0027273451243284242, -0.010519983349209902, -0.0007442495625187473, -0.009603018034488903, -0.01458352352702456, -0.028940946145121008, -0.009075448936549112, -0.011575122476412065, 0.030146818901167716, 0.01509853187727838, -0.010243637586892748, -0.012234583616006154, -0.000961714899205094, -0.042481892223951954, 0.0017899673140491716, -0.00210399671640811, -0.004920840311212783, -0.0020977161097344792, 0.004996207125635057, -0.0031261623675354045, 0.011920554679308509, -0.00790097851537862, 0.010055219852345126, -0.0009601448057443479, -0.0017883972205884255, 0.038085479659604245, -0.007367129043595845, 0.02160521990206267, 0.0010574938599396508, -0.008755138229024607, -0.023200489806213174, 0.014432789898180013, 0.007090782815617398, 0.0003893964205080266, 0.003790334369588348, -0.008943555963572228, -0.006010522193043297, -0.01896737348104114, 0.031252201950436334, 0.00503389076567684, 0.007203833735742745, 0.01335252834428333, -0.012441842937744021, -0.004123205359137532, -0.015337194465215044, 0.0105827898816075, -0.008993800816961271, -0.011807504224844452, -0.011757259371455409, 0.005015048712825302, -0.0003244315771266039, -0.025876019401615193, 0.005040171139519824, -0.009697226901762713, -0.05102349122305701, -0.02268548145595935, -0.0032690456454915434, -0.006563213717677608, 0.015073409450583858, -0.02542381758375897, -0.0295690040185163, 0.011242251021201589, -0.010501141762019658, -0.0071284664556591805, -0.010287601600777515, 0.024318434534490348, -0.012397878923859254, -0.010193392733503703, -0.013716802134370019, 0.011964518693193276, -0.02102740688205642, 0.01389265912123167, -0.007316884190206802, -0.029368026467605293, -0.015513050520754112, 0.033839803518068826, 0.012950571379816148, -0.00783189207479933, -0.004148327785832053, 0.017510276458049215, 0.017585644669455364, 0.0013927202807182608, -0.026855791248733787, 0.01845236513078732, -0.01072724267094777, -0.0032533442452227905, 0.016530506473575783, -0.03386492687608593, -0.013051060155271651, -0.007919820102568864, 0.02490880923350515, -0.00990448622350058, -0.00484233261137708, 0.21585121960707052, -0.01583964020513773, 0.04516998349836253, 0.0270818921576619, 0.016392333592417208, 0.02605187545715426, 0.020612888238580686, -0.009201060138699138, 0.0007591659742647888, 0.029845349780833454, -0.0011870309360258173, 0.004886297090923139, -0.015902446737535325, -0.0016031199057929425, -0.0003613300249188597, -0.018376998782026338, -0.04564730867423586, -0.011644208916991354, -0.008051713075545749, -0.020562643385191644, 0.01816345768946161, -0.011192006167812546, -0.012259706042700677, -0.00032835695629762293, 0.01732185872350159, -0.009753751663333449, -0.020009951860557332, -0.006739070238877969, 0.021693147929832204, -0.005526916643326984, 0.0041922917997168204, -0.008076835502240271, -0.004873735877575878, 0.014005709575695727, -0.015977813086296307, -0.010746085189460597, -0.024418922378623267, -0.012806117659153295, 0.026177488521949455, 0.030649265572412984, -0.015349755212901014, 0.005278833727456488, 0.0003483763173102431, 0.020864110642880736, 0.005633686723948056, 0.01247324620394282, -0.0036835645217979224, -0.015676345828607212, 0.009860522209615813, 0.03434225205195926, -0.0166938008501063, 0.009609298873993179, 0.012875204099732583, 0.024029527093164638, -0.009533931593909613, 0.0051909052340256626, -0.009992414251270114, 0.0032690456454915434, -0.014432789898180013, -0.01006778153135368, -0.014470473072560504, 0.017598206348463916, -0.007203833735742745, 0.026579445486416633, -0.011248531860705865, 0.009665823635563914, -0.01881663892087401, -0.0019250000082862572, 0.0003709471820599833, -0.02678042489997281, -0.003956770097193586, -0.010086623118543924, 0.0003273756042289105, 0.013905219868917641, -0.02566248017169563, -0.04082381765004903, 0.02547406243714801, 0.011845187399224943, 0.013653996533295007, 0.0073043229768595406, -0.009163376964318647, -0.00867349104075935, -0.01421924973693787, 0.00307748772402243, -0.03203099624664393, -0.029694617083311493, 0.024079771946553682, -0.008981240069275302, -0.012096410734847577, -0.013578629253211441, 0.017384665255899188, -0.021115334909825954, 0.0009538641990707174, -0.0009224612821178883, -0.009345513859361993, 0.027056770662289963, -0.003031953500261594, 0.02678042489997281, -0.010155709559123214, -0.011506036035832775, -0.021077651735445464, -0.02881533494297098, 0.006770473039415475, -0.012799836819649019, -0.02160521990206267, 0.009088009684235081, -0.015161337478353392, 0.015211582331742435, 0.016153671004480542, -0.02183132081099078, -0.018716149214095923, 0.007913540194387171, 0.006852120693342025, -0.0077314028336825345, 0.010168270306809182, -0.015249265506122926, 0.010947063671694188, -0.01688221858465392, 0.0023002650346747844, -0.008736296641834361, 0.01797503995491399, -0.021178139579578384, -0.013126427435355217, 0.004578548062407185, -0.01835187542400923, -0.00618323829449152, 0.011411827168558965, 0.009056606418036284, 0.02392903738638655, -0.026478955779638547, 0.00022629740344135113, -0.014884991716036237, -0.008792822334727682, -0.007046818801732631, -0.002889070222305455, 0.02392903738638655, 0.011506036035832775, -0.00849763498522028, 0.016945025117051517, -0.002449428919304554, 0.01097218609838871, -0.020198367732459786, 0.01654306628993917, 0.003033523710137663, -0.007743964047029796, -1.5836402025618134e-05, 0.0010818311816961378, 0.008070554662735995, -0.011053833286653969, -0.008372022851747672, -0.001046502856468459, -0.01772381755061394, 0.011242251021201589, -0.02843849947387574, 0.0032659054585700512, 0.000968780610816759, -0.020738499440730713, -0.03735693207943086, 0.0060544862069280645, 0.019218597747986357, -0.009439722726635803, -0.01438254504479097, 0.011443230434757763, 0.0029612968498062358, -0.0295690040185163, -0.009986133411765836, -0.160883517637522, 0.0170203914658125, 0.028538989180653826, -0.027433604268740037, 0.005592863129815427, -0.0004926335580117733, 0.006443882423709277, 0.005552039070021506, -0.005941435752464009, 0.01318923303643023, 0.02132887413974551, -0.005395024601672682, -0.023753181330847483, -0.03074975527919107, 0.01230995089608972, -0.0156135402275322, -0.0030052610965216487, 0.024205383148703706, 0.010017536677964635, 0.014332300191401927, 0.018000163312931094, -0.018552854837565406, -0.0017318719933563976, -0.010243637586892748, 0.0030696369074727304, 0.008428548544640991, -0.02121582461660404, 0.01864078286533494, 0.0056525283111383, -0.007235236536280252, -0.01967079956584258, -0.0022327488039715648, 0.0096344213006877, -0.005781280398701755, 0.010055219852345126, -0.0013134278251904917, -0.0006441527574556464, -0.014169004883548827, -0.000145140440101073, 0.0003523016964812621, 0.011757259371455409, 0.029694617083311493, 0.004412112334801948, 0.012592577497911152, 0.006120432227755215, 0.010815171630039887, 0.019959707007168287, -0.0022578712306660863, 0.02283621601612648, -0.014596085206033112, 0.02109021155180885, -0.017447471788296785, 0.01707063631920154, 0.007599510792028233, 0.031553671070770596, 0.011838906559720667, -0.008133360263811007, 0.006877243120036547, -0.01354094607883095, -0.014533278673635516, -0.0038814028171100206, -0.011273654287400387, 0.006443882423709277, -0.007184991682891208, -0.010168270306809182, -0.01882920059988256, -0.019105546362199716, 0.012466965364438544, -0.030875366481341097, -0.0003927329709755197, -0.02828776491370861, -0.023363784182743687, 0.031000979546136287, -0.02650407913765565, 0.019180912710960698, 0.016128547646463435, -0.017962480138550604, 0.024268189681101303, -0.018703589397732538, 0.007486459871902886, -0.024707829819948974, 0.02811190885816954, -0.017372103576890636, -0.005388743762168406, 0.002278283027732401, -0.0008871329568902092, -0.016794290556884386, 0.002750897108316231, -0.0038500000165725143, -0.016455138262169634, 0.02566248017169563, -0.01914322953658021, -0.0006355168941755739, -0.04074845130128804, 0.01787455211078107, 0.017899673606153008, 0.0036678628886985237, 0.0006021513312929812, -9.50429466830224e-05, 0.006921207133921314, 0.011034991699463722, 0.0048486134508813564, -0.023326101008363197, 0.011901713092118264, 0.04625024318961404, 0.020060194851301207, 0.021881565664379824, -0.0029314640263141526, 0.03396541658286401, 0.01688221858465392, -0.011267373447896111, 0.005087275573156729, 0.018979935160049692, 0.034216638987164066, -0.005511215475888877, -0.014822186114961224, 0.010909380497313697, -0.0005966557713497239, 0.021869003985371272, -0.007065660854584168, 0.03981892430755849, 0.0027713091382131913, -0.012423001350553776, -0.003846859596820376, -0.012925448953121628, 0.02194437219677742, -0.07225187938131476, -0.0346939641630374, 0.002578181006868009, 0.007109624868468935, 0.0011038131886385214, 0.006390497616229386, 0.00033404873426772744, 0.018439803451778765, 0.019105546362199716, 0.017761500724994432, -0.026001630603765216, -0.024343556029862285, 0.008466231719021482, -0.00721011410958573, 0.023564763596299863, 0.003319290266049941, -0.0031450039547256496, -0.0008635807400717566, -0.00783189207479933, 0.0028702284022845636, 0.003576794441176851, -0.005818964038743538, -0.01513621505165887, -0.010450896908630613, -0.002906341832450277, 0.021404240488506494, -0.01619135417886103, 0.013968026401315236, 0.007819331327113361, 0.006016802566886283, -0.00011864421800818683, -0.006233482682219272, 0.014972919743805772, -0.016593311143328213, -0.02245938054703124, 0.015538172947448635, -0.0252479615282199, 0.0036301794814873867, 0.018100653019709183, -0.0024996737726935975, 0.0032156606051810077, -0.003887683423783651, 0.019469820152286408, -0.023376345861752242, 0.03411614928038598, -0.01699526997044056, -0.02700652580890092, -0.002521655779635981, 0.006946329560615835, -0.014269494590326913, -0.012008482707078043, 0.015977813086296307, -0.013691680638998081, 0.010149428719618936, 0.008962397550762473, -0.024268189681101303, 0.020851548963872184, -0.006443882423709277, 0.007857014501493852, 0.000405882954818645, -0.00926386573977415, -0.008667210201255073, 0.0011783951309534062, 0.021341435818754067, 0.02637846607286046, 0.01915579121558876, -0.01709575781457348, -0.018929690306660647, 0.008755138229024607, -0.02670505668856666, -0.017146002667962523, -0.013138988183041187, 0.005514355429979723, 0.032332461641687855, -0.03185514019110486, -0.011242251021201589, -0.0295690040185163, -0.0012930159117088543, 0.007813050487609084, -0.017748939045985877, -0.004955383531502428, -0.015751712177368194, 0.012686786365184962, 0.0022044861903555506, 0.0013354098321328753, 0.0270818921576619, 0.00844110929232696, 0.011443230434757763, -0.00834690042505315, -0.02745872762675714, 0.007976345795462183, 0.041451875523444315, 0.009307830684981502, -0.023062316925054595, -0.012152936427740896, 0.021178139579578384, -0.007065660854584168, 0.009697226901762713, 0.02095203867065027, -0.002449428919304554, -0.0156135402275322, -0.006195799507838781, -0.06767960703613765, 0.033638824104512646, 0.002981708879703196, -0.006151835028292722, 0.02843849947387574, 0.004255097866453125, 0.030146818901167716, 0.015286949611826, 0.007693719193640752, -0.007461337445208363, -0.025185154995822304, -0.0006056841288911523, -0.00324706363854916, 0.0040729609714097795, -0.031026101041508224, -0.018389558598389723, 0.019984828502540228, -0.006626019784413913, 0.015186459905047914, 0.006946329560615835, 0.01065815623036848, 0.00983539978292129, 0.021052528377428357, 0.007919820102568864, -0.022409135693642196, 0.001695758563190684, -0.013176672288744262, 0.019457258473277853, -0.021881565664379824, -0.02081386578949169, 0.022999510392656998, -0.027483849122129082, -0.007021696375038109, 0.03416639599642019, 0.0003128517449518862, -0.00316541598462261, -0.003495146787250301, 0.0009436582423298988, 0.02065057141296118, -0.0037683523626459645, -0.0030602161138776076, -0.04072332794327094, 0.0061800978747393815, -0.01442022821917146, -0.01570146732397915, -0.008905872789191737, -0.01703295314482105, -0.013126427435355217, 0.022007176866529848, -0.01170073367856209, 0.022622674923561757, 0.028237520060319567, 0.015035726276203367, -0.018088091340700628, -0.00046672614279454, -0.02194437219677742, 0.009942169397881069, -0.0029283238393926605, 0.009044045670350314, -0.018703589397732538, 0.01148719444864253, -0.0021448205433713843, 0.01973360423559501, 0.012297390148403751, -0.005715334377874605, -0.009986133411765836, -0.003104180360593021, -0.011694453770380397, 0.016907340080025857, -0.03610081633264028, -0.0069526099344588204, -0.013264600316513796, 0.024594780296807502, 0.010231076839206777, 0.014671451554794095, 0.01350326290445046, -0.016643555996717255, 0.021002283524039315, -0.016869656905645368, 0.02095203867065027, 0.012536051805017831, 0.018226264221859207, -0.05386231519498954, 0.003909665663556681, 0.006657422584951419, 0.015073409450583858, -0.016530506473575783, 0.0011713295357570642, 0.0023002650346747844, 0.012441842937744021, -0.02345171221051322, 0.016241599032250077, -0.020901793817261226, 0.0032596248518964206, -0.007574388365333712, 0.011719576197074918, -0.011028710859959446, -0.016229037353241525, 0.008924714376381983, -0.006233482682219272, 0.0179373567805335, -0.007247797749627512, -0.011028710859959446, -0.0029283238393926605, -0.024594780296807502, -0.012774714392954497, -0.018289070754256804, -0.025637356813678527, -0.0069274879734255905, 0.006883523493879531, 0.012171778014931143, -0.004041557705210982, 0.012900326526427105, 0.018716149214095923, -0.010545105775904425, 0.019432136977905915, -0.021806199315618842, -0.02374061965183893, -0.009094290523739359, 0.014972919743805772, 0.027182381864439987, 0.013327405917588808, 0.024858564380116105, -0.019959707007168287, -0.0077816476870715785, 0.017045512961184436, -0.0025813214266201473, -0.024004403735147534, 0.0019077283981414348, -0.018263947396239696, 0.002606443620484023, -0.011857749078233497, 0.011097797300538736, -0.01929396409674734, -0.01753539981606632, 0.007078222067931429, 0.01188915141310971, 0.02884045643834292, -0.014231810484623839, 0.031126590748286314, -0.015538172947448635, -0.015161337478353392, 0.0040666801319055035, 0.00851019573290625, 0.012573735910720906, 0.021366557314126004, -0.007687438819797767, -0.028940946145121008, -0.013666558212303559, -0.005960277339654254, 0.004901998258361246, 0.003149714584353857, 0.0066071777315623755, -0.010620473055987989, 0.010362968880861079, -0.007957504208271939, 0.003925366830994787, -0.02212022825231649, -0.004088662138847887, 0.024004403735147534, -0.0065318109171401025, 0.04358727527322058, 0.004204853013064081, -0.002520085569759912, 0.003066496720551238, 0.013427895624366894, -0.011279935126904663, -0.01335252834428333, -0.024230506506720813, 0.019381892124516874, 0.01570146732397915, -0.04770734207525114, -0.011694453770380397, 0.008246410718275064, -0.008108237837116485, 0.005633686723948056, 0.015500489773068143, -9.680936730998095e-05, 0.008918433536877705, -0.015224143079428404, 0.01462120670140505, -0.0031245921576593355, -0.027810439737835282, 0.0006229557390359745, -0.0014406097028778777, -0.0036553016753512624, -0.013917781547926193, -0.011995921959392074]"

```

### example_projects/project-3/__init__.py

```

```

### example_projects/project-3/data.csv

```
﻿Words
Elephant
Lion
Tiger
Dog
Cricket
Footbal
Tennis
Basketball
Apple
Orange
Banana

```

### example_projects/project-15/requirements.txt

```
ffmpeg-python
langchain
whisper
streamlit
```

### example_projects/project-15/__init__.py

```

```

### example_projects/project-15/utils.py

```
import whisper
from langchain.llms import OpenAI
from langchain.agents import initialize_agent
from langchain.agents.agent_toolkits import ZapierToolkit
from langchain.utilities.zapier import ZapierNLAWrapper
import os

# get from https://platform.openai.com/
os.environ["OPENAI_API_KEY"] = "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"

# get from https://nla.zapier.com/docs/authentication/ after logging in):
os.environ["ZAPIER_NLA_API_KEY"] = "sk-ak-dV0owIyoCEbQJVzZv5F1S5JG77"


def email_summary(file):


    # large language model
    llm = OpenAI(temperature=0)

    # Initializing zapier
    zapier = ZapierNLAWrapper()
    toolkit = ZapierToolkit.from_zapier_nla_wrapper(zapier)

    # The agent used here is a "zero-shot-react-description" agent. 
    # Zero-shot means the agent functions on the current action only — it has no memory. 
    # It uses the ReAct framework to decide which tool to use, based solely on the tool's description.
    agent = initialize_agent(toolkit.get_tools(), llm, agent="zero-shot-react-description", verbose=True)


    # specify a model, here its BASE
    model = whisper.load_model("base")

   

    # transcribe audio file
    result = model.transcribe(file)
    print(result["text"])

    # Send email using zapier
    agent.run("Send an Email to sharathraju489@gmail.com via gmail summarizing the following text provided below : "+result["text"])



```

### example_projects/project-15/app.py

```
import streamlit as st
from utils import *


# Define the Streamlit app
def main():
    st.title("Customer Care Call Summarization")

    # Upload multiple files
    uploaded_files = st.file_uploader("Upload recorded .mp3 files", type=["mp3"], accept_multiple_files=True)

    if uploaded_files:
        st.write("Uploaded Files:")

        # Display uploaded files and buttons in a tabular form
        for uploaded_file in uploaded_files:
            file_name = uploaded_file.name
            

            col1, col2, col3 = st.columns([0.1, 1, 2])
            with col1:
                st.write("-")
            with col2:
                st.write(file_name)
            with col3:
                send_button = st.button(f"Send Email for {file_name}")

                if send_button:
                    email_summary(file_name)
                    st.success(f"Send email for: {file_name}")


# Run the Streamlit app
if __name__ == "__main__":
    main()

```

### example_projects/project-12/requirements.txt

```
sentence-transformers
uvicorn
ctransformers
fastapi
ipykernel
langchain
python-box
```

### example_projects/project-12/__init__.py

```

```

### example_projects/project-12/app.py

```
import streamlit as st
from langchain.prompts import PromptTemplate
from langchain.llms import CTransformers

#Function to get the response back
def getLLMResponse(form_input,email_sender,email_recipient,email_style):
    #llm = OpenAI(temperature=.9, model="text-davinci-003")

    # Wrapper for Llama-2-7B-Chat, Running Llama 2 on CPU

    #Quantization is reducing model precision by converting weights from 16-bit floats to 8-bit integers, 
    #enabling efficient deployment on resource-limited devices, reducing model size, and maintaining performance.

    #C Transformers offers support for various open-source models, 
    #among them popular ones like Llama, GPT4All-J, MPT, and Falcon.


    #C Transformers is the Python library that provides bindings for transformer models implemented in C/C++ using the GGML library

    llm = CTransformers(model='models/llama-2-7b-chat.ggmlv3.q8_0.bin',     #https://huggingface.co/TheBloke/Llama-2-7B-Chat-GGML/tree/main
                    model_type='llama',
                    config={'max_new_tokens': 256,
                            'temperature': 0.01})
    
    
    #Template for building the PROMPT
    template = """
    Write a email with {style} style and includes topic :{email_topic}.\n\nSender: {sender}\nRecipient: {recipient}
    \n\nEmail Text:
    
    """

    #Creating the final PROMPT
    prompt = PromptTemplate(
    input_variables=["style","email_topic","sender","recipient"],
    template=template,)

  
    #Generating the response using LLM
    response=llm(prompt.format(email_topic=form_input,sender=email_sender,recipient=email_recipient,style=email_style))
    print(response)

    return response


st.set_page_config(page_title="Generate Emails",
                    page_icon='📧',
                    layout='centered',
                    initial_sidebar_state='collapsed')
st.header("Generate Emails 📧")

form_input = st.text_area('Enter the email topic', height=275)

#Creating columns for the UI - To receive inputs from user
col1, col2, col3 = st.columns([10, 10, 5])
with col1:
    email_sender = st.text_input('Sender Name')
with col2:
    email_recipient = st.text_input('Recipient Name')
with col3:
    email_style = st.selectbox('Writing Style',
                                    ('Formal', 'Appreciating', 'Not Satisfied', 'Neutral'),
                                       index=0)


submit = st.button("Generate")

#When 'Generate' button is clicked, execute the below code
if submit:
    st.write(getLLMResponse(form_input,email_sender,email_recipient,email_style))

```

### example_projects/project-6.5-chains-module/__init__.py

```

```

### example_projects/project-6.5-chains-module/sample.txt

```
Title: The Computer: Revolutionizing the World of Technology

Introduction:
The computer is a marvel of human ingenuity that has revolutionized the world in countless ways. From its humble beginnings as a complex calculating machine to its current status as a ubiquitous tool in every aspect of our lives, the computer has transformed how we work, communicate, learn, and entertain ourselves. This essay explores the evolution, impact, and future potential of computers in shaping our modern world.

The Birth of the Computer:
The computer has its roots in the early 19th century when inventors and mathematicians began conceptualizing machines capable of automating complex calculations. However, it was not until the mid-20th century that the first electronic digital computers were developed. Pioneers such as Alan Turing, John von Neumann, and Grace Hopper made significant contributions to the field, laying the groundwork for the computers we know today.

The Evolution of Computing Power:
From room-sized mainframes to portable laptops, computers have evolved exponentially in terms of size, speed, and processing power. The introduction of integrated circuits, microprocessors, and Moore's Law, which states that the number of transistors on a microchip doubles approximately every two years, have propelled the advancement of computer technology. This exponential growth has led to the development of faster, more efficient, and increasingly capable devices that continue to reshape our world.

Transforming Work and Productivity:
Computers have transformed the workplace, increasing productivity, efficiency, and accuracy across industries. They have automated repetitive tasks, streamlined operations, and facilitated global connectivity. From word processing and data analysis to complex simulations and artificial intelligence, computers have become essential tools for professionals in fields such as finance, healthcare, engineering, and creative arts. The advent of remote work and digital collaboration further underscores the computer's impact on modern work environments.

Communication and Connectivity:
The computer has revolutionized communication, enabling people to connect with one another across vast distances. The internet, a global network of computers, has facilitated instant communication through email, messaging applications, and social media platforms. It has transformed how we share information, access knowledge, and engage in online communities. Additionally, advancements in video conferencing and virtual reality have bridged geographical gaps, allowing for immersive and real-time interactions.


Education and Learning:
Computers have had a profound impact on education, revolutionizing the way we learn and acquire knowledge. Online learning platforms, digital textbooks, and educational software provide accessible and interactive learning experiences. Virtual simulations and augmented reality applications enhance understanding in subjects such as science, history, and medicine. Furthermore, computers have expanded access to education, enabling remote learning and distance education opportunities for individuals worldwide.

Entertainment and Creativity:
Computers have transformed the entertainment industry, enabling the creation and consumption of diverse forms of media. From video games and digital art to music production and film editing, computers have become indispensable tools for creative expression. Streaming services and online platforms have democratized content distribution, offering a plethora of entertainment options to global audiences. Virtual reality and augmented reality technologies offer immersive experiences, blurring the boundaries between the digital and physical realms.

Conclusion:
The computer has profoundly shaped our modern world, revolutionizing the way we work, communicate, learn, and entertain ourselves. Its evolution from a bulky calculating machine to a portable device with immense processing power is a testament to human innovation. As computers continue to advance, their potential to drive societal progress, solve complex problems, and inspire new avenues of creativity is limitless. With responsible development and ethical usage, the computer will undoubtedly remain at the forefront of technological advancements, empowering individuals and transforming societies for generations to come.
```

### example_projects/project-2/__init__.py

```

```

### example_projects/project-2/Let's Build Simple Conversational Application/gitattributes.txt

```
*.7z filter=lfs diff=lfs merge=lfs -text
*.arrow filter=lfs diff=lfs merge=lfs -text
*.bin filter=lfs diff=lfs merge=lfs -text
*.bz2 filter=lfs diff=lfs merge=lfs -text
*.ckpt filter=lfs diff=lfs merge=lfs -text
*.ftz filter=lfs diff=lfs merge=lfs -text
*.gz filter=lfs diff=lfs merge=lfs -text
*.h5 filter=lfs diff=lfs merge=lfs -text
*.joblib filter=lfs diff=lfs merge=lfs -text
*.lfs.* filter=lfs diff=lfs merge=lfs -text
*.mlmodel filter=lfs diff=lfs merge=lfs -text
*.model filter=lfs diff=lfs merge=lfs -text
*.msgpack filter=lfs diff=lfs merge=lfs -text
*.npy filter=lfs diff=lfs merge=lfs -text
*.npz filter=lfs diff=lfs merge=lfs -text
*.onnx filter=lfs diff=lfs merge=lfs -text
*.ot filter=lfs diff=lfs merge=lfs -text
*.parquet filter=lfs diff=lfs merge=lfs -text
*.pb filter=lfs diff=lfs merge=lfs -text
*.pickle filter=lfs diff=lfs merge=lfs -text
*.pkl filter=lfs diff=lfs merge=lfs -text
*.pt filter=lfs diff=lfs merge=lfs -text
*.pth filter=lfs diff=lfs merge=lfs -text
*.rar filter=lfs diff=lfs merge=lfs -text
*.safetensors filter=lfs diff=lfs merge=lfs -text
saved_model/**/* filter=lfs diff=lfs merge=lfs -text
*.tar.* filter=lfs diff=lfs merge=lfs -text
*.tflite filter=lfs diff=lfs merge=lfs -text
*.tgz filter=lfs diff=lfs merge=lfs -text
*.wasm filter=lfs diff=lfs merge=lfs -text
*.xz filter=lfs diff=lfs merge=lfs -text
*.zip filter=lfs diff=lfs merge=lfs -text
*.zst filter=lfs diff=lfs merge=lfs -text
*tfevents* filter=lfs diff=lfs merge=lfs -text

```

### example_projects/project-2/Let's Build Simple Conversational Application/env-sample.txt

```
OPENAI_API_KEY=""
```

### example_projects/project-2/Let's Build Simple Conversational Application/requirements.txt

```
streamlit
langchain
openai
streamlit-chat
python-dotenv
```

### example_projects/project-2/Let's Build Simple Conversational Application/README.md

```
---
title: Project 2
emoji: ⚡
colorFrom: gray
colorTo: red
sdk: streamlit
sdk_version: 1.21.0
app_file: app.py
pinned: false
---

Check out the configuration reference at https://huggingface.co/docs/hub/spaces-config-reference

```

### example_projects/project-2/Let's Build Simple Conversational Application/app.py

```

import streamlit as st
from langchain.chat_models import ChatOpenAI
from langchain.schema import (
    AIMessage,
    HumanMessage,
    SystemMessage
)

# From here down is all the StreamLit UI.
st.set_page_config(page_title="LangChain Demo", page_icon=":robot:")
st.header("Hey, I'm your Chat GPT")


# 
if "sessionMessages" not in st.session_state:
    '''
    used to reset the context of the conversation
    if the new session is set.
    '''
    
    st.session_state.sessionMessages = [
        SystemMessage(content="You are a helpful assistant.")
    ]

def load_answer(question):
    '''
    This will append append the question to the 
    list and then send it to the LLM
    It then appends the response from the LLM
    and returns the response.
    '''

    st.session_state.sessionMessages.append(HumanMessage(content=question))
    assistant_answer  = chat(st.session_state.sessionMessages )
    st.session_state.sessionMessages.append(AIMessage(content=assistant_answer.content))

    return assistant_answer.content

def get_text():
    input_text = st.text_input("You: ", key=input)
    return input_text


chat = ChatOpenAI(temperature=0)
user_input=get_text()
submit = st.button('Generate')  

if submit:
    response = load_answer(user_input)
    st.subheader("Answer:")
    st.write(response,key=1)


```

### example_projects/project-5/__init__.py

```

```

### example_projects/project-5/app.py

```
"""
Small example showcasing a chat interface
and conversation summarization capability

"""
import os
from pathlib import Path
from dotenv import find_dotenv, load_dotenv

load_dotenv(Path('../../.env'))

import streamlit as st
from streamlit_chat import message
from langchain import OpenAI
from langchain.chains import ConversationChain
from langchain.chains.conversation.memory import (ConversationBufferMemory, 
                                                  ConversationSummaryMemory, 
                                                  ConversationBufferWindowMemory
                                                )

if 'conversation' not in st.session_state:
    st.session_state['conversation'] = None
if 'messages' not in st.session_state:
    st.session_state['messages'] =[]
if 'API_Key' not in st.session_state:
    st.session_state['API_Key'] = os.environ['OPENAI_API_KEY']

# Setting page title and header
st.set_page_config(page_title="Chat GPT Clone", page_icon=":robot_face:")
st.markdown("<h1 style='text-align: center;'>How can I assist you? </h1>", unsafe_allow_html=True)

st.sidebar.title("😎")
st.session_state['API_Key']= st.sidebar.text_input("What's your API key?",type="password")
summarise_button = st.sidebar.button("Summarise the conversation", key="summarise")


def getresponse(userInput, api_key):
    if st.session_state['conversation'] is None:
        llm = OpenAI(
            temperature=0,
            openai_api_key=api_key,
            model_name='text-davinci-003'  #we can also use 'gpt-3.5-turbo'
        )

        st.session_state['conversation'] = ConversationChain(
            llm=llm,
            verbose=True,
            memory=ConversationSummaryMemory(llm=llm)
        )

    response = st.session_state['conversation'].predict(input=userInput)
    print(st.session_state['conversation'].memory.buffer)
    return response

response_container = st.container()
# Here we will have a container for user input text box
container = st.container()

with container:
    with st.form(key='my_form', clear_on_submit=True):
        user_input = st.text_area("Your question goes here:", key='input', height=100)
        submit_button = st.form_submit_button(label='Send')

        if summarise_button:
            if st.session_state['API_Key'] == '':
                summarise_placeholder = st.sidebar.write("First provide an OpenAI Key❌")
            elif 'conversation' not in st.session_state:
                summarise_placeholder = st.sidebar.write("There is nothing to summarise 🤷‍♂️")
            else:
                summarise_placeholder = st.sidebar.write("Here is a summary ⚡️:\n\n" + st.session_state['conversation'].memory.buffer)

            with response_container:
                for i in range(len(st.session_state['messages'])):
                    if (i % 2) == 0:
                        message(st.session_state['messages'][i], is_user=True, key=str(i) + '_user')
                    else:
                        message(st.session_state['messages'][i], key=str(i) + '_AI')

        if submit_button:
            if st.session_state['API_Key'] == '':
                summarise_placeholder = st.sidebar.write("First provide an OpenAI Key❌")
            else:
                st.session_state['messages'].append(user_input)
                model_response = getresponse(user_input, st.session_state['API_Key'])
                st.session_state['messages'].append(model_response)
                
                with response_container:
                    for i in range(len(st.session_state['messages'])):
                        if (i % 2) == 0:
                            message(st.session_state['messages'][i], is_user=True, key=str(i) + '_user')
                        else:
                            message(st.session_state['messages'][i], key=str(i) + '_AI')
            
                

            

```

### example_projects/project-13/__init__.py

```

```

### example_projects/project-13/utils.py

```
from langchain.llms import OpenAI
from pypdf import PdfReader
from langchain.llms.openai import OpenAI
import pandas as pd
import re
import replicate
from langchain.prompts import PromptTemplate

#Extract Information from PDF file
def get_pdf_text(pdf_doc):
    text = ""
    pdf_reader = PdfReader(pdf_doc)
    for page in pdf_reader.pages:
        text += page.extract_text()
    return text



#Function to extract data from text
def extracted_data(pages_data):

    template = """Extract all the following values : invoice no., Description, Quantity, date, 
        Unit price , Amount, Total, email, phone number and address from this data: {pages}

        Expected output: remove any dollar symbols {{'Invoice no.': '1001329','Description': 'Office Chair','Quantity': '2','Date': '5/4/2023','Unit price': '1100.00','Amount': '2200.00','Total': '2200.00','Email': 'Santoshvarma0988@gmail.com','Phone number': '9999999999','Address': 'Mumbai, India'}}
        """
    prompt_template = PromptTemplate(input_variables=["pages"], template=template)

    llm = OpenAI(temperature=.7)
    full_response=llm(prompt_template.format(pages=pages_data))
    

    #The below code will be used when we want to use LLAMA 2 model,  we will use Replicate for hosting our model...
    
    #output = replicate.run('replicate/llama-2-70b-chat:2c1608e18606fad2812020dc541930f2d0495ce32eee50074220b87300bc16e1', 
                           #input={"prompt":prompt_template.format(pages=pages_data) ,
                                  #"temperature":0.1, "top_p":0.9, "max_length":512, "repetition_penalty":1})
    
    #full_response = ''
    #for item in output:
        #full_response += item
    

    #print(full_response)
    return full_response


# iterate over files in
# that user uploaded PDF files, one by one
def create_docs(user_pdf_list):
    
    df = pd.DataFrame({'Invoice no.': pd.Series(dtype='str'),
                   'Description': pd.Series(dtype='str'),
                   'Quantity': pd.Series(dtype='str'),
                   'Date': pd.Series(dtype='str'),
	                'Unit price': pd.Series(dtype='str'),
                   'Amount': pd.Series(dtype='int'),
                   'Total': pd.Series(dtype='str'),
                   'Email': pd.Series(dtype='str'),
	                'Phone number': pd.Series(dtype='str'),
                   'Address': pd.Series(dtype='str')
                    })

    for filename in user_pdf_list:
        
        print(filename)
        raw_data=get_pdf_text(filename)
        #print(raw_data)
        #print("extracted raw data")

        llm_extracted_data=extracted_data(raw_data)
        #print("llm extracted data")
        #Adding items to our list - Adding data & its metadata

        pattern = r'{(.+)}'
        match = re.search(pattern, llm_extracted_data, re.DOTALL)

        if match:
            extracted_text = match.group(1)
            # Converting the extracted text to a dictionary
            data_dict = eval('{' + extracted_text + '}')
            print(data_dict)
        else:
            print("No match found.")

        
        df=df.append([data_dict], ignore_index=True)
        print("********************DONE***************")
        #df=df.append(save_to_dataframe(llm_extracted_data), ignore_index=True)

    df.head()
    return df
```

### example_projects/project-13/app.py

```
import streamlit as st
from dotenv import load_dotenv
from utils import *


def main():
    load_dotenv()

    st.set_page_config(page_title="Invoice Extraction Bot")
    st.title("Invoice Extraction Bot...💁 ")
    st.subheader("I can help you in extracting invoice data")


    # Upload the Invoices (pdf files)
    pdf = st.file_uploader("Upload invoices here, only PDF files allowed", type=["pdf"],accept_multiple_files=True)

    submit=st.button("Extract Data")

    if submit:
        with st.spinner('Wait for it...'):
            df=create_docs(pdf)
            st.write(df.head())

            data_as_csv= df.to_csv(index=False).encode("utf-8")
            st.download_button(
                "Download data as CSV", 
                data_as_csv, 
                "benchmark-tools.csv",
                "text/csv",
                key="download-tools-csv",
            )
        st.success("Hope I was able to save your time❤️")


#Invoking main function
if __name__ == '__main__':
    main()

```

### example_projects/project-14/__init__.py

```

```

### example_projects/project-5.5-data-connection-module/__init__.py

```

```

### example_projects/project-5.5-data-connection-module/Sample.txt

```
India, officially known as the Republic of India, is a diverse and vibrant country located in South Asia. With a rich history spanning thousands of years, India is known for its cultural heritage, religious diversity, and vast landscapes. From the majestic Himalayas in the north to the serene backwaters of Kerala in the south, India encompasses a wide range of geographical features, including deserts, plains, mountains, and coastlines, making it a land of incredible natural beauty.

India is the seventh-largest country by land area and the second-most populous country in the world, with a population exceeding 1.3 billion people. It is a federal parliamentary democratic republic, with a president as the head of state and a prime minister as the head of government. The country follows a multi-tiered administrative structure, with 28 states and 9 union territories, each having its own elected government.

India has a rich cultural heritage that has evolved over thousands of years. It is home to various religions, including Hinduism, Islam, Christianity, Sikhism, Buddhism, and Jainism, among others. These religions coexist harmoniously, contributing to India's multicultural fabric. Festivals like Diwali, Eid, Christmas, and Holi are celebrated with great enthusiasm and bring people from different communities together.

The history of India is characterized by ancient civilizations, invasions, and the establishment of powerful empires. The Indus Valley Civilization, one of the world's oldest urban civilizations, flourished in the northwestern part of the Indian subcontinent around 2500 BCE. Over the centuries, India witnessed the rise and fall of several dynasties, including the Maurya, Gupta, and Mughal empires. The Mughal period, in particular, left a lasting impact on Indian culture, art, and architecture.

India's struggle for independence from British colonial rule is a significant chapter in its history. Led by Mahatma Gandhi and other freedom fighters, the non-violent resistance movement gained momentum and eventually led to India's independence on August 15, 1947. This day is celebrated annually as Independence Day.

India's economy is one of the fastest-growing in the world. It has transitioned from an agrarian economy to a service-oriented and industrialized economy. The country is known for its software and information technology services, pharmaceuticals, textiles, agriculture, and manufacturing sectors. Major cities like Mumbai, Delhi, Bangalore, and Chennai are hubs of business and commerce, attracting investments and fostering innovation.

Delhi is the capital of India

However, India also faces various socio-economic challenges. Poverty, income inequality, and unemployment are persistent issues that the country strives to address. Efforts are being made to improve education, healthcare, infrastructure, and social welfare programs to uplift marginalized sections of society.

Education plays a vital role in India, with a strong emphasis on academic excellence. The country has a vast network of schools, colleges, and universities, producing a large number of graduates every year. Indian professionals have made significant contributions in various fields globally, particularly in science, technology, engineering, and mathematics (STEM).

The Indian film industry, popularly known as Bollywood, is a global phenomenon, producing the largest number of films annually. Indian cinema reflects the diversity and cultural richness of the country and has a massive following both within India and among the Indian diaspora worldwide.

Indian cuisine is renowned for its flavors, spices, and regional specialties. Each state has its own culinary traditions, offering a wide range of vegetarian and non-vegetarian dishes. Indian food has gained international popularity, with dishes like curry, biryani, dosa, and tandoori being enjoyed by people worldwide.

The Indian rupee is the official currency in the Republic of India. The rupee is subdivided into 100 paise. The issuance of the currency is controlled by the Reserve Bank of India.

The Indian rupee sign (₹) is the currency symbol for the Indian rupee the official currency of India

Tourism is a significant contributor to India's economy. The country attracts millions of visitors each year who come to explore its historical sites, architectural wonders, wildlife sanctuaries, and scenic landscapes. Iconic landmarks such as the Taj Mahal, Jaipur's palaces, Kerala's backwaters, and the beaches of Goa are popular tourist destinations.

India's cultural heritage is preserved in its ancient monuments and UNESCO World Heritage Sites. From the intricate carvings of Khajuraho temples to the majestic forts of Rajasthan, these architectural marvels reflect India's rich history and artistic traditions.

India's diversity extends to its languages as well. While Hindi and English are the official languages at the national level, there are 22 officially recognized regional languages, including Bengali, Tamil, Telugu, Marathi, Urdu, Punjabi, and Gujarati, among others. This linguistic diversity is a testament to India's multicultural ethos.

In recent years, India has made significant strides in space exploration. The Indian Space Research Organization (ISRO) has successfully launched satellites and missions, including the Mars Orbiter Mission (MOM), also known as Mangalyaan. These achievements have placed India among the elite group of nations with advanced space programs.

India's diplomatic influence is also growing on the global stage. The country actively participates in international forums and has strong bilateral relations with nations around the world. India is a founding member of the Non-Aligned Movement and plays an active role in various international organizations, such as the United Nations and World Trade Organization.

In conclusion, India is a vast and diverse country with a rich cultural heritage, stunning landscapes, and a rapidly growing economy. It is a nation where ancient traditions coexist with modern aspirations. Despite its challenges, India continues to evolve and leave an indelible mark on the world, making it a fascinating and dynamic country to explore.
```

### example_projects/README.md

```
# llm-masterclass 👨🏻‍💻
Repository for this udemy course work: [Link](https://www.udemy.com/course/learn-langchain-go-from-zero-to-hero-build-ai-apps/)


## Projects

- **Project 1:** Construct a dynamic question-answering application with the unparalleled capabilities of LangChain, OpenAI, and Hugging Face Spaces.
- **Project 2**: Develop an engaging conversational bot using LangChain and OpenAI to deliver an interactive user experience.
- **Project 3**: Create an AI-powered app tailored for children, facilitating the discovery of related classes of objects and fostering educational growth.
- **Project 4**: Build a captivating marketing campaign app that utilizes the persuasive potential of well-crafted sales copy, boosting sales and brand reach.
- **Project 5**: Develop a ChatGPT clone with an added summarization feature, delivering a unique experience.
- **Project 6**: MCQ Quiz Creator App - Seamlessly create multiple-choice quizzes for your students using LangChain and embeddings of pdfs stored in a Pinecone vector DB.
- **Project 7:** CSV Data Analysis Toll - Helps you analyze your CSV file by answering your queries about its data.
- **Project 8**: Youtube Script Writing Tool -  Effortlessly create compelling YouTube scripts with this user-friendly and efficient script-writing tool.
- **Project 9** - Support Chat Bot For Your Website - Helps your visitors/customers to find the relevant data or blog links that can be useful to them.
- **Project 10** - Automatic Ticket Classification Tool - The Automatic Ticket Classification Tool categorizes support tickets based on content to streamline ticket management and response processes.
- **Project 11** - HR - Resume Screening  Assistance - HR project using AI to assist in screening resumes, optimizing the hiring process with smart analysis and recommendations
- **Project 12** - Email Generator using LLAMA 2 - The Email Generator is a tool that automatically creates customized emails, saving time and effort in crafting personalized messages.
- **Project 13** - Invoice Extraction Bot using LLAMA 2 - Invoice Extraction Bot: AI-powered tool that extracts key details from invoices accurately and efficiently. Simplify your data entry process.
- **Project 14** - Text to SQL Query Helper Tool: Convert natural language text into structured SQL queries effortlessly using the Text to SQL Query Tool for streamlined database interaction and data retrieval.
- **Project 15** - Customer Care Call Summary Alert - Concise notification highlighting key points and outcomes from recent customer service calls, aiding quick understanding and response

```

### example_projects/project-3.5-prompt-module/__init__.py

```

```

### example_projects/project-11/requirements.txt

```
langchain
streamlit
openai
tiktoken
python-dotenv
unstructured
pinecone-client
pypdf
sentence_transformers
```

### example_projects/project-11/__init__.py

```

```

### example_projects/project-11/utils.py

```
import openai
from langchain.embeddings.openai import OpenAIEmbeddings
from langchain.vectorstores import Pinecone
from langchain.llms import OpenAI
from langchain.embeddings.sentence_transformer import SentenceTransformerEmbeddings
from langchain.schema import Document
import pinecone
from pypdf import PdfReader
from langchain.llms.openai import OpenAI
from langchain.chains.summarize import load_summarize_chain
from langchain import HuggingFaceHub


#Extract Information from PDF file
def get_pdf_text(pdf_doc):
    text = ""
    pdf_reader = PdfReader(pdf_doc)
    for page in pdf_reader.pages:
        text += page.extract_text()
    return text



# iterate over files in
# that user uploaded PDF files, one by one
def create_docs(user_pdf_list, unique_id):
    docs=[]
    for filename in user_pdf_list:
        
        chunks=get_pdf_text(filename)

        #Adding items to our list - Adding data & its metadata
        docs.append(Document(
            page_content=chunks,
            metadata={"name": filename.name,"id":filename.id,"type=":filename.type,"size":filename.size,"unique_id":unique_id},
        ))

    return docs


#Create embeddings instance
def create_embeddings_load_data():
    #embeddings = OpenAIEmbeddings()
    embeddings = SentenceTransformerEmbeddings(model_name="all-MiniLM-L6-v2")
    return embeddings


#Function to push data to Vector Store - Pinecone here
def push_to_pinecone(pinecone_apikey,pinecone_environment,pinecone_index_name,embeddings,docs):

    pinecone.init(
    api_key=pinecone_apikey,
    environment=pinecone_environment
    )
    print("done......2")
    Pinecone.from_documents(docs, embeddings, index_name=pinecone_index_name)
    


#Function to pull infrmation from Vector Store - Pinecone here
def pull_from_pinecone(pinecone_apikey,pinecone_environment,pinecone_index_name,embeddings):

    pinecone.init(
    api_key=pinecone_apikey,
    environment=pinecone_environment
    )

    index_name = pinecone_index_name

    index = Pinecone.from_existing_index(index_name, embeddings)
    return index



#Function to help us get relavant documents from vector store - based on user input
def similar_docs(query,k,pinecone_apikey,pinecone_environment,pinecone_index_name,embeddings,unique_id):

    pinecone.init(
    api_key=pinecone_apikey,
    environment=pinecone_environment
    )

    index_name = pinecone_index_name

    index = pull_from_pinecone(pinecone_apikey,pinecone_environment,index_name,embeddings)
    similar_docs = index.similarity_search_with_score(query, int(k),{"unique_id":unique_id})
    #print(similar_docs)
    return similar_docs


# Helps us get the summary of a document
def get_summary(current_doc):
    llm = OpenAI(temperature=0)
    #llm = HuggingFaceHub(repo_id="bigscience/bloom", model_kwargs={"temperature":1e-10})
    chain = load_summarize_chain(llm, chain_type="map_reduce")
    summary = chain.run([current_doc])

    return summary




    
```

### example_projects/project-11/app.py

```
import streamlit as st
from dotenv import load_dotenv
from utils import *
import uuid

#Creating session variables
if 'unique_id' not in st.session_state:
    st.session_state['unique_id'] =''

def main():
    load_dotenv()

    st.set_page_config(page_title="Resume Screening Assistance")
    st.title("HR - Resume Screening Assistance...💁 ")
    st.subheader("I can help you in resume screening process")

    job_description = st.text_area("Please paste the 'JOB DESCRIPTION' here...",key="1")
    document_count = st.text_input("No.of 'RESUMES' to return",key="2")
    # Upload the Resumes (pdf files)
    pdf = st.file_uploader("Upload resumes here, only PDF files allowed", type=["pdf"],accept_multiple_files=True)

    submit=st.button("Help me with the analysis")

    if submit:
        with st.spinner('Wait for it...'):

            #Creating a unique ID, so that we can use to query and get only the user uploaded documents from PINECONE vector store
            st.session_state['unique_id']=uuid.uuid4().hex

            #Create a documents list out of all the user uploaded pdf files
            final_docs_list=create_docs(pdf,st.session_state['unique_id'])

            #Displaying the count of resumes that have been uploaded
            st.write("*Resumes uploaded* :"+str(len(final_docs_list)))

            #Create embeddings instance
            embeddings=create_embeddings_load_data()

            #Push data to PINECONE
            push_to_pinecone("e697b71c-d5ed-4c66-8625-ac1c403a2df1","us-west1-gcp-free","test",embeddings,final_docs_list)

            #Fecth relavant documents from PINECONE
            relavant_docs=similar_docs(job_description,document_count,"e697b71c-d5ed-4c66-8625-ac1c403a2df1","us-west1-gcp-free","test",embeddings,st.session_state['unique_id'])

            #t.write(relavant_docs)

            #Introducing a line separator
            st.write(":heavy_minus_sign:" * 30)

            #For each item in relavant docs - we are displaying some info of it on the UI
            for item in range(len(relavant_docs)):
                
                st.subheader("👉 "+str(item+1))

                #Displaying Filepath
                st.write("**File** : "+relavant_docs[item][0].metadata['name'])

                #Introducing Expander feature
                with st.expander('Show me 👀'): 
                    st.info("**Match Score** : "+str(relavant_docs[item][1]))
                    #st.write("***"+relavant_docs[item][0].page_content)
                    
                    #Gets the summary of the current item using 'get_summary' function that we have created which uses LLM & Langchain chain
                    summary = get_summary(relavant_docs[item][0])
                    st.write("**Summary** : "+summary)

        st.success("Hope I was able to save your time❤️")


#Invoking main function
if __name__ == '__main__':
    main()

```

### example_projects/project-9/requirements.txt

```
langchain
pinecone-client
openai
tiktoken
nest_asyncio
```

### example_projects/project-9/constants.py

```
WEBSITE_URL="https://jobs.excelcult.com/wp-sitemap-posts-post-1.xml"
PINECONE_ENVIRONMENT="us-west1-gcp-free"
PINECONE_INDEX="chatbot"
```

### example_projects/project-9/__init__.py

```

```

### example_projects/project-9/utils.py

```
from langchain.text_splitter import RecursiveCharacterTextSplitter
from langchain.vectorstores import Pinecone, Chroma
from langchain.embeddings.sentence_transformer import SentenceTransformerEmbeddings
import pinecone
import asyncio
from langchain.document_loaders.sitemap import SitemapLoader


# Function to fetch data from website
# https://python.langchain.com/docs/modules/data_connection/document_loaders/integrations/sitemap
def get_website_data(sitemap_url):
    print('Pulling website data...')
    loop = asyncio.new_event_loop()
    asyncio.set_event_loop(loop)
    loader = SitemapLoader(
        sitemap_url
    )

    docs = loader.load()

    return docs

# Function to split data into smaller chunks
def split_data(docs):
    print('Splitting data into documents...')
    text_splitter = RecursiveCharacterTextSplitter(
        chunk_size=1000,
        chunk_overlap=200,
        length_function=len,
    )

    docs_chunks = text_splitter.split_documents(docs)
    return docs_chunks

# Function to create embeddings instance
def create_embeddings():
    print('Creating embeddings...')
    embeddings = SentenceTransformerEmbeddings(model_name="all-MiniLM-L6-v2")
    return embeddings

# Function to push data to Pinecone
def push_to_pinecone(pinecone_apikey, pinecone_environment, pinecone_index_name, embeddings, docs):
    print('Pushing data to Pinecone...')
    pinecone.init(
        api_key=pinecone_apikey,
        environment=pinecone_environment
    )

    index_name = pinecone_index_name
    index = Pinecone.from_documents(docs, embeddings, index_name=index_name)
    return index

def push_to_chroma(docs, embeddings, persist_directory="./chroma_db"):
    '''
    returns a chromadb vector representation store  
    instance of documents

    Args:
        - docs (list): chunks of documents.
        - embeddings (): some embedding function
    Returns:
        - db (Chroma.from_documents): 
    '''
    return Chroma.from_documents(docs, embeddings, persist_directory=persist_directory)

def pull_from_chroma(embeddings,  persist_directory="./chroma_db"):
    return Chroma(persist_directory=persist_directory, embedding_function=embeddings)

def pull_from_pinecone(pinecone_apikey, pinecone_environment, pinecone_index_name, embeddings):
    print('Pulling data from Pinecone...')

    pinecone.init(
        api_key=pinecone_apikey,
        environment=pinecone_environment
    )
    
    index_name = pinecone_index_name

    return Pinecone.from_existing_index(index_name, embeddings)

# This function will help us in fetching the top relevent documents from our vector store - Pinecone Index
def get_similar_docs(db, query, k=2):
    print('Performing similarity search...')
    similar_docs = db.similarity_search(query, k=k)
    return similar_docs


if __name__ == "__main__":
    pass
```

### example_projects/project-9/app.py

```
"""
Pull documents from passing a URL, pull down the webpages
with beautifulsoup, embed and store docs in vectorstore

Also has the ability to query the documents you've stored
using vector representations of your query ie: similarity_search()

"""

import os
import constants
from utils import (get_website_data, split_data, create_embeddings,
                   push_to_chroma, pull_from_chroma, get_similar_docs)
import streamlit as st
from pathlib import Path
from dotenv import find_dotenv, load_dotenv

load_dotenv(Path('../../.env'))

# Creating Session State Variable
if 'HUGGINGFACEHUB_API_TOKEN' not in st.session_state:
    st.session_state['HUGGINGFACEHUB_API_TOKEN'] = os.environ['HUGGINGFACEHUB_API_TOKEN']

st.title('🤖 Webpage Document Search') 

#********SIDE BAR Funtionality started*******

# Sidebar to capture the API keys
st.sidebar.write(f"## Load data to from {constants.WEBSITE_URL} to Chroma")
load_button = st.sidebar.button("Upload", key="load_button")

db = None
embeddings=create_embeddings()

#If the bove button is clicked, pushing the data to Chroma...
if load_button:
    #Proceed only if API keys are provided
    if st.session_state['HUGGINGFACEHUB_API_TOKEN'] != "":

        #Fetch data from site
        site_data=get_website_data(constants.WEBSITE_URL)
        st.write("Data pull done...")

        #Split data into chunks
        chunks_data=split_data(site_data)
        st.write("Spliting data done...")

        db = push_to_chroma(chunks_data, embeddings)
        st.write("Pushing data to Chroma done...")
        st.sidebar.success("Data pushed to Chroma successfully!")
    else:
        st.sidebar.error("Ooopssss!!! Please provide API keys.....")

#********SIDE BAR Funtionality ended*******

#Captures User Inputs
prompt = st.text_input('How can I help you my friend ❓', key="prompt")  # The box for the text prompt
document_count = st.slider('How many links should I return? 🔗', 0, 5, 2, step=1)
submit = st.button("Search") 


if submit:
    print('Search submitted')
    #Proceed only if API keys are provided
    if st.session_state['HUGGINGFACEHUB_API_TOKEN'] != "":
        if db == None:
            st.sidebar.error("Documents have not yet been embedded.")
        else:
            #Fetch relavant documents from Pinecone index
            relavant_docs = get_similar_docs(db, prompt, document_count)
            st.write(relavant_docs)

            #Displaying search results
            st.success("Please find the search results :")
            #Displaying search results
            st.write("search results list....")
            for document in relavant_docs:
                st.write("👉**Result : " + str(relavant_docs.index(document)+1)+"**")
                st.write("**Info**: " + document[0].page_content)
                st.write("**Link**: " + document[0].metadata['source'])
    else:
        st.sidebar.error("Please provide API keys.")



   

```

### example_projects/project-7/requirements.txt

```
langchain
streamlit
openai
tiktoken
python-dotenv
pinecone-client
```

### example_projects/project-7/__init__.py

```

```

### example_projects/project-7/utils.py

```
'''
Creating an agents from the lanchain
agents module to query a dataframe.

'''
import pandas as pd
from langchain.llms import OpenAI
from langchain.agents import create_pandas_dataframe_agent
from langchain.chat_models import ChatOpenAI
from langchain.agents.agent_types import AgentType

def query_agent(data, query):

    # Parse the CSV file and create a Pandas DataFrame from its contents.
    df = pd.read_csv(data)

    llm = OpenAI(model='text-davinci-003', temperature=0.8)
    
    # Create a Pandas DataFrame agent.
    agent = create_pandas_dataframe_agent(llm, df, verbose=True)


    # agent = create_pandas_dataframe_agent(
    #     ChatOpenAI(temperature=0, model="gpt-4", endpoint="v1/chat/completions"),
    #     df,
    #     verbose=True,
    #     agent_type=AgentType.OPENAI_FUNCTIONS,
    # )

    #Python REPL: A Python shell used to evaluating and executing Python commands. 
    #It takes python code as input and outputs the result. The input python code can be generated from another tool in the LangChain
    return agent.run(query)
```

### example_projects/project-7/app.py

```
import streamlit as st
from pathlib import Path
from dotenv import find_dotenv, load_dotenv

load_dotenv(Path('../../.env'))
load_dotenv()

from utils import query_agent


st.title("CSV Querying")
st.header("Please upload your CSV file here:")

# Capture the CSV file
data = st.file_uploader("Upload CSV file", type="csv")

query = st.text_area("Enter your query")
button = st.button("Generate Response")

if button:
    # Get Response
    answer =  query_agent(data,query)
    st.write(answer)
```

### example_projects/project-7/employees.csv

```
EMPLOYEE_ID,FIRST_NAME,LAST_NAME,EMAIL,PHONE_NUMBER,HIRE_DATE,JOB_ID,SALARY,COMMISSION_PCT,MANAGER_ID,DEPARTMENT_ID
198,Donald,OConnell,DOCONNEL,650.507.9833,21-JUN-07,SH_CLERK,2600, - ,124,50
199,Douglas,Grant,DGRANT,650.507.9844,13-JAN-08,SH_CLERK,2600, - ,124,50
200,Jennifer,Whalen,JWHALEN,515.123.4444,17-SEP-03,AD_ASST,4400, - ,101,10
201,Michael,Hartstein,MHARTSTE,515.123.5555,17-FEB-04,MK_MAN,13000, - ,100,20
202,Pat,Fay,PFAY,603.123.6666,17-AUG-05,MK_REP,6000, - ,201,20
203,Susan,Mavris,SMAVRIS,515.123.7777,07-JUN-02,HR_REP,6500, - ,101,40
204,Hermann,Baer,HBAER,515.123.8888,07-JUN-02,PR_REP,10000, - ,101,70
205,Shelley,Higgins,SHIGGINS,515.123.8080,07-JUN-02,AC_MGR,12008, - ,101,110
206,William,Gietz,WGIETZ,515.123.8181,07-JUN-02,AC_ACCOUNT,8300, - ,205,110
100,Steven,King,SKING,515.123.4567,17-JUN-03,AD_PRES,24000, - , - ,90
101,Neena,Kochhar,NKOCHHAR,515.123.4568,21-SEP-05,AD_VP,17000, - ,100,90
102,Lex,De Haan,LDEHAAN,515.123.4569,13-JAN-01,AD_VP,17000, - ,100,90
103,Alexander,Hunold,AHUNOLD,590.423.4567,03-JAN-06,IT_PROG,9000, - ,102,60
104,Bruce,Ernst,BERNST,590.423.4568,21-MAY-07,IT_PROG,6000, - ,103,60
105,David,Austin,DAUSTIN,590.423.4569,25-JUN-05,IT_PROG,4800, - ,103,60
106,Valli,Pataballa,VPATABAL,590.423.4560,05-FEB-06,IT_PROG,4800, - ,103,60
107,Diana,Lorentz,DLORENTZ,590.423.5567,07-FEB-07,IT_PROG,4200, - ,103,60
108,Nancy,Greenberg,NGREENBE,515.124.4569,17-AUG-02,FI_MGR,12008, - ,101,100
109,Daniel,Faviet,DFAVIET,515.124.4169,16-AUG-02,FI_ACCOUNT,9000, - ,108,100
110,John,Chen,JCHEN,515.124.4269,28-SEP-05,FI_ACCOUNT,8200, - ,108,100
111,Ismael,Sciarra,ISCIARRA,515.124.4369,30-SEP-05,FI_ACCOUNT,7700, - ,108,100
112,Jose Manuel,Urman,JMURMAN,515.124.4469,07-MAR-06,FI_ACCOUNT,7800, - ,108,100
113,Luis,Popp,LPOPP,515.124.4567,07-DEC-07,FI_ACCOUNT,6900, - ,108,100
114,Den,Raphaely,DRAPHEAL,515.127.4561,07-DEC-02,PU_MAN,11000, - ,100,30
115,Alexander,Khoo,AKHOO,515.127.4562,18-MAY-03,PU_CLERK,3100, - ,114,30
116,Shelli,Baida,SBAIDA,515.127.4563,24-DEC-05,PU_CLERK,2900, - ,114,30
117,Sigal,Tobias,STOBIAS,515.127.4564,24-JUL-05,PU_CLERK,2800, - ,114,30
118,Guy,Himuro,GHIMURO,515.127.4565,15-NOV-06,PU_CLERK,2600, - ,114,30
119,Karen,Colmenares,KCOLMENA,515.127.4566,10-AUG-07,PU_CLERK,2500, - ,114,30
120,Matthew,Weiss,MWEISS,650.123.1234,18-JUL-04,ST_MAN,8000, - ,100,50
121,Adam,Fripp,AFRIPP,650.123.2234,10-APR-05,ST_MAN,8200, - ,100,50
122,Payam,Kaufling,PKAUFLIN,650.123.3234,01-MAY-03,ST_MAN,7900, - ,100,50
123,Shanta,Vollman,SVOLLMAN,650.123.4234,10-OCT-05,ST_MAN,6500, - ,100,50
124,Kevin,Mourgos,KMOURGOS,650.123.5234,16-NOV-07,ST_MAN,5800, - ,100,50
125,Julia,Nayer,JNAYER,650.124.1214,16-JUL-05,ST_CLERK,3200, - ,120,50
126,Irene,Mikkilineni,IMIKKILI,650.124.1224,28-SEP-06,ST_CLERK,2700, - ,120,50
127,James,Landry,JLANDRY,650.124.1334,14-JAN-07,ST_CLERK,2400, - ,120,50
128,Steven,Markle,SMARKLE,650.124.1434,08-MAR-08,ST_CLERK,2200, - ,120,50
129,Laura,Bissot,LBISSOT,650.124.5234,20-AUG-05,ST_CLERK,3300, - ,121,50
130,Mozhe,Atkinson,MATKINSO,650.124.6234,30-OCT-05,ST_CLERK,2800, - ,121,50
131,James,Marlow,JAMRLOW,650.124.7234,16-FEB-05,ST_CLERK,2500, - ,121,50
132,TJ,Olson,TJOLSON,650.124.8234,10-APR-07,ST_CLERK,2100, - ,121,50
133,Jason,Mallin,JMALLIN,650.127.1934,14-JUN-04,ST_CLERK,3300, - ,122,50
134,Michael,Rogers,MROGERS,650.127.1834,26-AUG-06,ST_CLERK,2900, - ,122,50
135,Ki,Gee,KGEE,650.127.1734,12-DEC-07,ST_CLERK,2400, - ,122,50
136,Hazel,Philtanker,HPHILTAN,650.127.1634,06-FEB-08,ST_CLERK,2200, - ,122,50
137,Renske,Ladwig,RLADWIG,650.121.1234,14-JUL-03,ST_CLERK,3600, - ,123,50
138,Stephen,Stiles,SSTILES,650.121.2034,26-OCT-05,ST_CLERK,3200, - ,123,50
139,John,Seo,JSEO,650.121.2019,12-FEB-06,ST_CLERK,2700, - ,123,50
140,Joshua,Patel,JPATEL,650.121.1834,06-APR-06,ST_CLERK,2500, - ,123,50

```

### example_projects/project-10/user_utils.py

```
'''
NOTE: application froze on pushing data to pinecone

'''
import pinecone
from langchain.vectorstores import Pinecone
from langchain.embeddings.sentence_transformer import SentenceTransformerEmbeddings
from langchain.llms import OpenAI
from langchain.chains.question_answering import load_qa_chain
from langchain.callbacks import get_openai_callback
import joblib


#Function to pull index data from Pinecone
def pull_from_pinecone(pinecone_apikey,pinecone_environment,pinecone_index_name,embeddings):

    pinecone.init(
        api_key=pinecone_apikey,
        environment=pinecone_environment
    )

    index_name = pinecone_index_name

    index = Pinecone.from_existing_index(index_name, embeddings)
    return index

def create_embeddings():
    embeddings = SentenceTransformerEmbeddings(model_name="all-MiniLM-L6-v2")
    return embeddings

#This function will help us in fetching the top relevent documents from our vector store - Pinecone Index
def get_similar_docs(index,query,k=2):

    similar_docs = index.similarity_search(query, k=k)
    return similar_docs

def get_answer(docs,user_input):
    chain = load_qa_chain(OpenAI(), chain_type="stuff")
    with get_openai_callback() as cb:
        response = chain.run(input_documents=docs, question=user_input)
    return response


def predict(query_result):
    Fitmodel = joblib.load('modelsvm.pk1')
    result=Fitmodel.predict([query_result])
    return result[0]
```

### example_projects/project-10/requirements.txt

```
langchain
streamlit
openai
tiktoken
python-dotenv
pinecone-client
pypdf
joblib
pandas
```

### example_projects/project-10/__init__.py

```

```

### example_projects/project-10/Tickets.csv

```
"The bus arrived late again, causing me to miss an important meeting.",Transportation
"The taxi driver took a longer route, resulting in an inflated fare.",Transportation
"There's no proper signage at the train station, making it confusing for passengers.",Transportation
The flight was delayed for hours without any proper explanation.,Transportation
The bus driver was rude and unprofessional during the entire journey.,Transportation
"The train compartments were overcrowded, and there were no seats available.",Transportation
"I booked a cab, but it never arrived at the designated pick-up location.",Transportation
"The airline lost my luggage, and I haven't received any updates on its whereabouts.",Transportation
"The taxi had a broken seatbelt, posing a safety risk during the ride.",Transportation
"The bus broke down in the middle of the journey, causing a significant delay.",Transportation
"The train schedule is inconsistent, with frequent cancellations and delays.",Transportation
The airline customer service was unresponsive and provided no assistance.,Transportation
"The taxi smelled strongly of smoke, making the ride uncomfortable and unpleasant.",Transportation
There's a lack of wheelchair accessibility on public transportation vehicles.,Transportation
The flight attendant was rude and disrespectful towards passengers.,Transportation
"The bus station lacks proper facilities, including restrooms and waiting areas.",Transportation
"The taxi driver was speeding and driving recklessly, compromising passenger safety.",Transportation
The train ticketing system charged me twice for the same journey.,Transportation
"The airline overbooked the flight, causing me to be denied boarding.",Transportation
"The taxi driver refused to take me to my destination, citing a short trip.",Transportation
The bus seats were uncomfortable and in poor condition.,Transportation
"The train announcements were unclear, making it difficult to understand the next stop.",Transportation
"I purchased an online ticket, but the QR code was not recognized by the ticket scanner.",Transportation
"The airline misplaced my pet during the flight, causing distress and anxiety.",Transportation
"The taxi meter was tampered with, resulting in an inflated fare.",Transportation
"The bus driver skipped my designated stop, forcing me to walk a long distance.",Transportation
"The train platform was overcrowded, and there were no proper crowd management measures.",Transportation
The airline canceled my flight without any prior notification or alternative arrangements.,Transportation
"The taxi driver took a longer route to increase the fare, even though I provided directions.",Transportation
"The bus was dirty and poorly maintained, with broken seats and windows.",Transportation
"The train was extremely overcrowded, with passengers struggling to find space.",Transportation
I had difficulty finding a parking space at the airport due to insufficient availability.,Transportation
The taxi driver was playing loud music and refused to lower the volume upon request.,Transportation
"The bus driver was not following the designated route, causing confusion among passengers.",Transportation
"The train ticket vending machine was out of order, causing inconvenience to passengers.",Transportation
I experienced motion sickness due to poor driving skills of the taxi driver.,Transportation
The airline changed my flight schedule without notifying me in advance.,Transportation
"The bus was not wheelchair accessible, making it challenging for passengers with disabilities.",Transportation
"The train doors were malfunctioning, posing a safety hazard during boarding and disembarking.",Transportation
"The taxi driver was using a mobile phone while driving, endangering passengers' safety.",Transportation
"The bus driver was constantly honking unnecessarily, causing disturbance and discomfort.",Transportation
"The train was overcrowded, and there were no functioning air conditioning units.",Transportation
I received no assistance with my heavy luggage from the airline staff.,Transportation
"The taxi driver dropped me off at the wrong location, despite providing the correct address.",Transportation
"The bus schedule was inaccurate, with buses arriving either too early or too late.",Transportation
"The train station lacks proper lighting, posing safety concerns during evening hours.",Transportation
"I was wrongly charged for excess baggage on the airline, even though I was within the allowed limit.",Transportation
The taxi driver was driving aggressively and abruptly changing lanes without warning.,Transportation
The software crashes frequently during data entry. It's affecting my productivity.,IT
I haven't received my salary for the past two months. Can someone from HR please look into this?,HR
"The network is slow, and I'm unable to access important files. Could the IT team check it?",IT
I'm facing issues with my medical insurance coverage. Can HR assist me in resolving this matter?,HR
"The printer in our department is constantly jamming, causing delays in our work. IT, please fix it urgently.",IT
"I've been experiencing harassment from a colleague. HR, I need your help to address this problem.",HR
"The system keeps logging me out repeatedly. IT, please investigate and resolve this issue.",IT
"I have a concern regarding my vacation leave balance. HR, can you provide clarification?",HR
"There's a problem with the email server. I can't send or receive emails. IT, please resolve it quickly.",IT
"I believe there's an error in my tax deductions. HR, could you please review my payroll details?",HR
"The new software update is causing compatibility issues with my computer. IT, can you assist in fixing it?",IT
"HR, I haven't received any response to my promotion request. Can you please update me on the status?",HR
"The internet connection in our office is unreliable. IT, please look into this matter as soon as possible.",IT
"I need assistance with setting up my company email on my mobile device. IT, can you guide me through it?",IT
"I'm facing difficulties accessing my employee benefits portal. HR, can you help me resolve this issue?",HR
"IT, I accidentally deleted an important file. Is there any way to recover it?",IT
"I have concerns about the working hours. HR, can we discuss possible adjustments?",HR
"The video conferencing software is not functioning properly. IT, please fix it before our meeting.",IT
"I have questions about the company's policy on parental leave. HR, can you provide me with the details?",HR
"IT, the projector in the meeting room is not working. We need it for the presentation.",IT
"I'm having trouble accessing my employee account. HR, can you assist me in resetting my password?",HR
"The software is giving me error messages whenever I try to save my work. IT, please resolve this issue.",IT
"HR, there's an error in my employment contract. Can you review it and make the necessary corrections?",HR
"IT, I need a software license key to install a program on my computer. Can you provide it?",IT
"I'm experiencing issues with my company-issued laptop. HR, can you arrange for a replacement?",HR
"The server is down, and we are unable to access our files. IT, please fix it immediately.",IT
"I have concerns about the work environment. HR, can we schedule a meeting to discuss it?",HR
"IT, the wireless network is not available in certain areas of the office. Can you investigate the issue?",IT
"I need help with updating my personal information in the HR system. HR, can you guide me through the process?",HR
"The software is not compatible with my operating system. IT, can you recommend a solution?",IT
"The HR department did not process my vacation request on time, causing inconvenience.",HR
"IT, the email attachments are not opening correctly. Please resolve this issue promptly.",IT
"There's a discrepancy in my performance evaluation. HR, can we schedule a meeting to discuss it?",HR
I'm unable to access the HR portal to update my personal information. Can someone assist me with this?,HR
The IT helpdesk has not responded to my support ticket for three days. Please prioritize it.,IT
"I have concerns about the onboarding process. HR, can we improve the orientation program?",HR
"IT, the software license on my computer has expired. Can you renew it?",IT
"I'm facing difficulties with the time tracking system. HR, can you provide guidance on how to use it?",HR
"The Wi-Fi network in our office is not secure. IT, please ensure that appropriate measures are taken.",IT
I'm experiencing issues with the HR benefits enrollment process. Can someone assist me with this?,HR
"IT, I need assistance in setting up a virtual private network (VPN) for secure remote access.",IT
"There's a conflict within our team. HR, can you mediate and help resolve the issue?",HR
"I'm receiving spam emails repeatedly. IT, please enhance the email filtering system.",IT
The HR department has not provided me with the required training materials. Can this be addressed?,HR
"IT, I accidentally deleted an important file from the shared drive. Can you recover it?",IT
"I have concerns about the employee recognition program. HR, can we implement improvements?",HR
"The IT system crashed during an important presentation, causing embarrassment. Please fix this issue.",IT
I'm experiencing difficulties with the HR self-service portal. Can someone provide technical support?,HR
"IT, the video conferencing software is not compatible with my device. Please suggest an alternative.",IT
"There's an error in my salary calculation. HR, can you review it and rectify the mistake?",HR
"I'm unable to print documents from my computer. IT, can you investigate and resolve the issue?",IT
The HR department needs to streamline the employee appraisal process. Can improvements be made?,HR
"IT, my computer is running slow, affecting my productivity. Can you optimize its performance?",IT
"I have concerns about the diversity and inclusion initiatives. HR, can we discuss this further?",HR
The IT team needs to provide more comprehensive cybersecurity training to employees.,IT
I'm experiencing delays in receiving responses from the HR department. Can this be addressed?,HR
"IT, the website is not loading properly. Please investigate and fix the issue.",IT
"There's a lack of communication regarding policy updates. HR, can we improve internal notifications?",HR
"I need assistance with data recovery from a damaged hard drive. IT, can you help me retrieve the files?",IT
The HR department needs to address the employee morale issue. Can we conduct a survey?,HR
The IT department has not resolved my software installation issue despite multiple requests.,IT
"HR, there is a discrepancy in my employee benefits coverage. Can you please investigate and rectify it?",HR
"I'm experiencing network connectivity problems in the conference room. IT, can you check and fix it?",IT
"There's a conflict between me and my supervisor. HR, I need assistance in resolving this matter.",HR
"IT, the server is experiencing frequent outages, disrupting our work. Please address the issue urgently.",IT
"I have concerns about the transparency of the promotion process. HR, can we discuss this and provide clarity?",HR
"IT, my computer is infected with a virus. Please perform a thorough scan and remove any malware.",IT
"I'm having difficulties accessing my training materials on the learning management system. HR, can you help?",HR
The IT helpdesk provided incorrect instructions for resolving my technical issue. Can someone correct it?,IT
"I believe my performance review was biased and unfair. HR, can you conduct a thorough investigation?",HR
"IT, I need assistance in recovering a deleted email from my inbox. Is it possible to retrieve it?",IT
"There's a lack of communication regarding company policies. HR, can we improve the dissemination process?",HR
"I'm experiencing frequent system crashes while using a specific software. IT, can you investigate and fix it?",IT
The HR department has not responded to my leave application. Can you please expedite the approval process?,HR
"IT, I accidentally formatted my external hard drive. Is there any way to recover the lost data?",IT
"I have concerns about the effectiveness of our performance appraisal system. HR, can we explore improvements?",HR
"The IT network in our office is not secure, leaving us vulnerable to cyber threats. Please address the issue.",IT
I'm facing difficulties accessing the HR policy manual. Can you provide an updated version or alternative access?,HR
"IT, the software update has caused compatibility issues with other applications. Can you find a solution?",IT
"There's an error in my timesheet records. HR, can you rectify it to ensure accurate payroll processing?",HR
"I'm unable to connect to the VPN for remote access. IT, can you troubleshoot and help me establish a connection?",IT
The HR department needs to enhance communication channels for employee feedback. Can improvements be made?,HR
"IT, the conference room audio system is malfunctioning, affecting our meetings. Please fix it as soon as possible.",IT
"I have concerns about the accuracy of my expense reimbursements. HR, can we review and reconcile the records?",HR
The IT team needs to improve response time for resolving technical issues. Urgent matters are being delayed.,IT
"I'm experiencing delays in receiving my performance bonus. HR, can you check the status and provide an update?",HR
"IT, the software license on my computer is about to expire. Can you renew it before it causes any disruptions?",IT
"There's a lack of diversity in the company's hiring process. HR, can we implement more inclusive practices?",HR
"I need assistance with data backup and recovery procedures. IT, can you provide guidance on best practices?",IT
The HR department needs to address concerns related to work-life balance. Can we implement flexible policies?,HR
"IT, the software application is crashing whenever I try to export data. Can you investigate and fix the issue?",IT
"I have concerns about the transparency of the salary structure. HR, can we discuss and provide more clarity?",HR
"The network printer in our department is constantly offline. IT, please resolve this issue as it hampers productivity.",IT
I'm facing difficulties accessing my performance metrics on the HR portal. Can you provide assistance?,HR
"IT, there's a persistent issue with the video conferencing system. It frequently disconnects during meetings.",IT
"I've been subjected to workplace bullying by a colleague. HR, I need your immediate intervention to address this.",HR
"The software license on my computer has expired. IT, can you provide a renewed license key?",IT
I'm experiencing challenges with the HR onboarding process. Can you streamline and improve it?,HR
"IT, my computer is infected with malware. Can you perform a thorough scan and remove the malicious files?",IT
"I have concerns about the accuracy of my attendance records. HR, can we review and rectify any discrepancies?",HR
The IT helpdesk is not responsive to my technical support requests. It's causing delays in my work.,IT
"HR, I need clarification regarding the company's bereavement leave policy. Can you provide detailed information?",HR
"The software is not compatible with my operating system. IT, can you recommend an alternative solution?",IT
"I'm facing difficulties accessing my employee benefits portal. HR, can you provide guidance on resolving this?",HR
"IT, there's a problem with the server configuration, leading to intermittent downtime. Please address it urgently.",IT
"I believe there's an error in my performance appraisal rating. HR, can you review and amend it accordingly?",HR
"The IT network in our office is not reliable. It frequently disconnects, disrupting our work.",IT
"I'm unable to access the HR policy manual. HR, can you provide an updated copy or alternative access?",HR
"IT, my laptop is overheating, which is affecting its performance. Can you provide a solution to prevent this?",IT
The HR department needs to improve communication regarding employee development opportunities.,HR
I'm experiencing delays in receiving responses to my HR inquiries. Can this be addressed promptly?,HR
"IT, the software update has caused a loss of data on my computer. Is there any way to recover the lost files?",IT
"There's a lack of clarity in the company's remote work policy. HR, can we discuss and provide clear guidelines?",HR
"I'm unable to access my email account. IT, can you assist in resolving this issue?",IT
The HR department needs to address concerns related to employee recognition and rewards programs.,HR
"IT, the server response time is significantly slow, affecting our productivity. Please optimize its performance.",IT
"I have concerns about the fairness of the promotion process. HR, can we ensure equal opportunities for all employees?",HR
"The software interface is not user-friendly. IT, can you provide training or alternative software options?",IT
I'm experiencing challenges with the HR grievance handling process. Can you provide guidance and support?,HR
"IT, there's an issue with the backup system. It's not capturing the latest data. Please investigate and fix it.",IT
The HR department needs to improve communication regarding policy updates and changes.,HR
I'm facing difficulties with the IT asset management system. Can you provide assistance in tracking and managing assets?,IT
"IT, the website is not loading properly in certain browsers. Can you investigate and resolve the compatibility issue?",IT
"There's a lack of diversity in the company's leadership positions. HR, can we implement strategies for promoting diversity?",HR
"I'm experiencing difficulties with the remote access VPN. IT, can you troubleshoot and help me establish a secure connection?",IT
The HR department needs to address concerns related to employee morale and job satisfaction.,HR
"IT, the software is not saving my preferences and settings. Can you investigate and fix the issue?",IT
"I have concerns about the accuracy of my expense reimbursements. HR, can we review and rectify any discrepancies?",HR
The IT network in our office is not secure. Can you implement additional security measures to protect sensitive data?,IT

```

### example_projects/project-10/app.py

```
import os
import streamlit as st
from pathlib import Path
from dotenv import find_dotenv, load_dotenv

load_dotenv(Path('../../.env'))

from user_utils import *

# Creating session variables
if 'HR_tickets' not in st.session_state:
    st.session_state['HR_tickets'] = []
if 'IT_tickets' not in st.session_state:
    st.session_state['IT_tickets'] = []
if 'Transport_tickets' not in st.session_state:
    st.session_state['Transport_tickets'] = []


def main():

    st.header("Automatic Ticket Classification Tool")
    # Capture user input
    st.write("We are here to help you, please ask your question:")
    user_input = st.text_input("🔍")

    if user_input:

        # creating embeddings instance
        embeddings = create_embeddings()

        # Function to pull index data from Pinecone
        index = pull_from_pinecone("8fe9ac1f-b6b6-4c3e-af89-e9cefa72f26d",
                                   "us-west1-gcp-free",
                                   "project10",
                                   embeddings)

        # This function will help us in fetching the top relevent documents from our vector store - Pinecone Index
        relavant_docs = get_similar_docs(index, user_input)

        # This will return the fine tuned response by LLM
        response = get_answer(relavant_docs, user_input)
        st.write(response)

        # Button to create a ticket with respective department
        button = st.button("Submit ticket?")

        if button:
            # Get Response

            embeddings = create_embeddings()
            query_result = embeddings.embed_query(user_input)

            # loading the ML model, so that we can use it to predit the class to which this compliant belongs to...
            department_value = predict(query_result)
            st.write("your ticket has been sumbitted to : "+department_value)

            # Appending the tickets to below list, so that we can view/use them later on...
            if department_value == "HR":
                st.session_state['HR_tickets'].append(user_input)
            elif department_value == "IT":
                st.session_state['IT_tickets'].append(user_input)
            else:
                st.session_state['Transport_tickets'].append(user_input)


if __name__ == '__main__':
    main()

```

### example_projects/project-10/pages/Pending_tickets.py

```
import streamlit as st
 
st.title('Departments')
 
# Create tabs
tab_titles = ['HR Support', 'IT Support', 'Transportation Support']
tabs = st.tabs(tab_titles)
 
# Add content to each tab
with tabs[0]:
    st.header('HR Support tickets')
    for ticket in st.session_state['HR_tickets']:
        st.write(str(st.session_state['HR_tickets'].index(ticket)+1)+" : "+ticket)
    
 
with tabs[1]:
    st.header('IT Support tickets')
    for ticket in st.session_state['IT_tickets']:
        st.write(str(st.session_state['IT_tickets'].index(ticket)+1)+" : "+ticket)
 
with tabs[2]:
    st.header('Transportation Support tickets')
    for ticket in st.session_state['Transport_tickets']:
        st.write(str(st.session_state['Transport_tickets'].index(ticket)+1)+" : "+ticket)
    
 
```

### example_projects/project-10/pages/admin_utils.py

```
from pypdf import PdfReader
from langchain.text_splitter import RecursiveCharacterTextSplitter
from langchain.embeddings import OpenAIEmbeddings
from langchain.embeddings.sentence_transformer import SentenceTransformerEmbeddings
from langchain.llms import OpenAI
import pinecone
from langchain.vectorstores import Pinecone
import pandas as pd
from sklearn.model_selection import train_test_split




#**********Functions to help you load documents to PINECONE***********

#Read PDF data
def read_pdf_data(pdf_file):
    pdf_page = PdfReader(pdf_file)
    text = ""
    for page in pdf_page.pages:
        text += page.extract_text()
    return text

#Split data into chunks
def split_data(text):
    text_splitter = RecursiveCharacterTextSplitter(chunk_size=1000, chunk_overlap=50)
    docs = text_splitter.split_text(text)
    docs_chunks =text_splitter.create_documents(docs)
    return docs_chunks

#Create embeddings instance
def create_embeddings_load_data():
    #embeddings = OpenAIEmbeddings()
    embeddings = SentenceTransformerEmbeddings(model_name="all-MiniLM-L6-v2")
    return embeddings

#Function to push data to Pinecone
def push_to_pinecone(pinecone_apikey,pinecone_environment,pinecone_index_name,embeddings,docs):

    pinecone.init(
    api_key=pinecone_apikey,
    environment=pinecone_environment
    )

    index_name = pinecone_index_name
    index = Pinecone.from_documents(docs, embeddings, index_name=index_name)
    return index

#*********Functions for dealing with Model related tasks...************

#Read dataset for model creation
def read_data(data):
    df = pd.read_csv(data,delimiter=',', header=None)  
    return df

#Create embeddings instance
def get_embeddings():
    embeddings = SentenceTransformerEmbeddings(model_name="all-MiniLM-L6-v2")
    return embeddings

#Generating embeddings for our input dataset
def create_embeddings(df,embeddings):
    df[2] = df[0].apply(lambda x: embeddings.embed_query(x))
    return df

#Splitting the data into train & test
def split_train_test__data(df_sample):
    # Split into training and testing sets
    sentences_train, sentences_test, labels_train, labels_test = train_test_split(
    list(df_sample[2]), list(df_sample[1]), test_size=0.25, random_state=0)
    print(len(sentences_train))
    return sentences_train, sentences_test, labels_train, labels_test

#Get the accuracy score on test data
def get_score(svm_classifier,sentences_test,labels_test):
    score = svm_classifier.score(sentences_test, labels_test)
    return score

```

### example_projects/project-10/pages/Create_ML_Model.py

```
import streamlit as st
from pages.admin_utils import *
from sklearn.svm import SVC
from sklearn.pipeline import make_pipeline
from sklearn.preprocessing import StandardScaler
import joblib

from pages.admin_utils import *


if 'cleaned_data' not in st.session_state:
    st.session_state['cleaned_data'] =''
if 'sentences_train' not in st.session_state:
    st.session_state['sentences_train'] =''
if 'sentences_test' not in st.session_state:
    st.session_state['sentences_test'] =''
if 'labels_train' not in st.session_state:
    st.session_state['labels_train'] =''
if 'labels_test' not in st.session_state:
    st.session_state['labels_test'] =''
if 'svm_classifier' not in st.session_state:
    st.session_state['svm_classifier'] =''

 
st.title("Let's build our Model...")
 
# Create tabs
tab_titles = ['Data Preprocessing', 'Model Training', 'Model Evaluation',"Save Model"]
tabs = st.tabs(tab_titles)

# Adding content to each tab

#Data Preprocessing TAB
with tabs[0]:
    st.header('Data Preprocessing')
    st.write('Here we preprocess the data...')

    # Capture the CSV file
    data = st.file_uploader("Upload CSV file",type="csv")

    button = st.button("Load data",key="data")

    if button:
        with st.spinner('Wait for it...'):
            our_data=read_data(data)
            embeddings=get_embeddings()
            st.session_state['cleaned_data'] = create_embeddings(our_data,embeddings)
        st.success('Done!')


#Model Training TAB
with tabs[1]:
    st.header('Model Training')
    st.write('Here we train the model...')
    button = st.button("Train model",key="model")
    
    if button:
            with st.spinner('Wait for it...'):
                st.session_state['sentences_train'], st.session_state['sentences_test'], st.session_state['labels_train'], st.session_state['labels_test']=split_train_test__data(st.session_state['cleaned_data'])
                
                # Initialize a support vector machine, with class_weight='balanced' because 
                # our training set has roughly an equal amount of positive and negative 
                # sentiment sentences
                st.session_state['svm_classifier']  = make_pipeline(StandardScaler(), SVC(class_weight='balanced')) 

                # fit the support vector machine
                st.session_state['svm_classifier'].fit(st.session_state['sentences_train'], st.session_state['labels_train'])
            st.success('Done!')

#Model Evaluation TAB
with tabs[2]:
    st.header('Model Evaluation')
    st.write('Here we evaluate the model...')
    button = st.button("Evaluate model",key="Evaluation")

    if button:
        with st.spinner('Wait for it...'):
            accuracy_score=get_score(st.session_state['svm_classifier'],st.session_state['sentences_test'],st.session_state['labels_test'])
            st.success(f"Validation accuracy is {100*accuracy_score}%!")


            st.write("A sample run:")


            #text="lack of communication regarding policy updates salary, can we please look into it?"
            text="Rude driver with scary driving"
            st.write("***Our issue*** : "+text)

            #Converting out TEXT to NUMERICAL representaion
            embeddings= get_embeddings()
            query_result = embeddings.embed_query(text)

            #Sample prediction using our trained model
            result= st.session_state['svm_classifier'].predict([query_result])
            st.write("***Department it belongs to*** : "+result[0])
            

        st.success('Done!')

#Save model TAB
with tabs[3]:
    st.header('Save model')
    st.write('Here we save the model...')

    button = st.button("Save model",key="save")
    if button:

        with st.spinner('Wait for it...'):
             joblib.dump(st.session_state['svm_classifier'], 'modelsvm.pk1')
        st.success('Done!')
```

### example_projects/project-10/pages/Load_Data_Store.py

```
from pages.admin_utils import *
import streamlit as st
from pathlib import Path
from dotenv import find_dotenv, load_dotenv

load_dotenv(Path('../../.env'))


def main():
    load_dotenv()
    st.set_page_config(page_title="Dump PDF to Pinecone - Vector Store")
    st.title("Please upload your files...📁 ")

    # Upload the pdf file
    pdf = st.file_uploader("Only PDF files allowed", type=["pdf"])

    # Extract the whole text from the uploaded pdf file
    if pdf is not None:
        with st.spinner('Wait for it...'):
            text = read_pdf_data(pdf)
            st.write("👉Reading PDF done")

            # Create chunks
            docs_chunks = split_data(text)
            # st.write(docs_chunks)
            st.write("👉Splitting data into chunks done")

            # Create the embeddings
            embeddings = create_embeddings_load_data()
            st.write("👉Creating embeddings instance done")

            # Build the vector store (Push the PDF data embeddings)
            push_to_pinecone("e697b71c-d5ed-4c66-8625-ac1c403a2df1",
                             "us-west1-gcp-free", "tickets", embeddings, docs_chunks)

        st.success("Successfully pushed the embeddings to Pinecone")


if __name__ == '__main__':
    main()

```

### example_projects/project-6/__init__.py

```

```

### example_projects/project-1/__init__.py

```

```

### example_projects/project-1/Lets' Build Simple Question Answering Application/gitattributes.txt

```
*.7z filter=lfs diff=lfs merge=lfs -text
*.arrow filter=lfs diff=lfs merge=lfs -text
*.bin filter=lfs diff=lfs merge=lfs -text
*.bz2 filter=lfs diff=lfs merge=lfs -text
*.ckpt filter=lfs diff=lfs merge=lfs -text
*.ftz filter=lfs diff=lfs merge=lfs -text
*.gz filter=lfs diff=lfs merge=lfs -text
*.h5 filter=lfs diff=lfs merge=lfs -text
*.joblib filter=lfs diff=lfs merge=lfs -text
*.lfs.* filter=lfs diff=lfs merge=lfs -text
*.mlmodel filter=lfs diff=lfs merge=lfs -text
*.model filter=lfs diff=lfs merge=lfs -text
*.msgpack filter=lfs diff=lfs merge=lfs -text
*.npy filter=lfs diff=lfs merge=lfs -text
*.npz filter=lfs diff=lfs merge=lfs -text
*.onnx filter=lfs diff=lfs merge=lfs -text
*.ot filter=lfs diff=lfs merge=lfs -text
*.parquet filter=lfs diff=lfs merge=lfs -text
*.pb filter=lfs diff=lfs merge=lfs -text
*.pickle filter=lfs diff=lfs merge=lfs -text
*.pkl filter=lfs diff=lfs merge=lfs -text
*.pt filter=lfs diff=lfs merge=lfs -text
*.pth filter=lfs diff=lfs merge=lfs -text
*.rar filter=lfs diff=lfs merge=lfs -text
*.safetensors filter=lfs diff=lfs merge=lfs -text
saved_model/**/* filter=lfs diff=lfs merge=lfs -text
*.tar.* filter=lfs diff=lfs merge=lfs -text
*.tflite filter=lfs diff=lfs merge=lfs -text
*.tgz filter=lfs diff=lfs merge=lfs -text
*.wasm filter=lfs diff=lfs merge=lfs -text
*.xz filter=lfs diff=lfs merge=lfs -text
*.zip filter=lfs diff=lfs merge=lfs -text
*.zst filter=lfs diff=lfs merge=lfs -text
*tfevents* filter=lfs diff=lfs merge=lfs -text

```

### example_projects/project-1/Lets' Build Simple Question Answering Application/env-sample.txt

```
OPENAI_API_KEY=""
```

### example_projects/project-1/Lets' Build Simple Question Answering Application/requirements.txt

```
langchain
Openai
Streamlit
```

### example_projects/project-1/Lets' Build Simple Question Answering Application/README.md

```
---
title: Project 1
emoji: 🏆
colorFrom: red
colorTo: purple
sdk: streamlit
sdk_version: 1.26.0
app_file: app.py
pinned: false
---

Check out the configuration reference at https://huggingface.co/docs/hub/spaces-config-reference

```

### example_projects/project-1/Lets' Build Simple Question Answering Application/app.py

```
#Hello! It seems like you want to import the Streamlit library in Python. Streamlit is a powerful open-source framework used for building web applications with interactive data visualizations and machine learning models. To import Streamlit, you'll need to ensure that you have it installed in your Python environment.
#Once you have Streamlit installed, you can import it into your Python script using the import statement,

import streamlit as st
from langchain.llms import OpenAI

#Function to return the response
def load_answer(question):
    llm = OpenAI(model_name="text-davinci-003",temperature=0)
    answer=llm(question)
    return answer


#App UI starts here
st.set_page_config(page_title="LangChain Demo", page_icon=":robot:")
st.header("LangChain Demo")

#Gets the user input
def get_text():
    input_text = st.text_input("You: ", key="input")
    return input_text


user_input=get_text()
response = load_answer(user_input)

submit = st.button('Generate')  

#If generate button is clicked
if submit:
    st.subheader("Answer:")
    st.write(response)


```

### example_projects/project-8/requirements.txt

```
langchain
streamlit
openai
tiktoken
python-dotenv
pinecone-client
duckduckgo_search
```

### example_projects/project-8/__init__.py

```

```

### example_projects/project-8/utils.py

```
from langchain.llms import OpenAI
from langchain.prompts import PromptTemplate
from langchain.chains import LLMChain
from langchain.tools import DuckDuckGoSearchRun

# Function to generate video script
def generate_script(prompt, data_text, video_length, creativity, api_key):

    # Template for generating 'Title'
    title_template = PromptTemplate(
        input_variables=["subject", "additional_context"],
        template='Please come up with a short and clever title for a YouTube video on the following topic: {subject}. {additional_context}')

    subject_template = PromptTemplate(
        input_variables=["subject", "title", "additional_context"],
        template='Please create a short but descriptive google search term for research for this proposed {subject} article titled: {title}. {additional_context}')

    # Template for generating 'Video Script' using search engine
    script_template = PromptTemplate(
        input_variables=['title', 'DuckDuckGo_Search',
                         'duration', "additional_context"],
        template='Create a script for a YouTube video based on this title for me. TITLE: {title} of duration: {duration} minutes using this search data {DuckDuckGo_Search}. {additional_context}'
    )

    # Setting up OpenAI LLM
    llm = OpenAI(temperature=creativity, openai_api_key=api_key,
                 model_name='gpt-4')

    # Creating chain for 'Title' & 'Video Script'
    title_chain = LLMChain(llm=llm, prompt=title_template, verbose=True)
    subject_chain = LLMChain(llm=llm, prompt=subject_template, verbose=True)
    script_chain = LLMChain(llm=llm, prompt=script_template, verbose=True)

    # https://python.langchain.com/docs/modules/agents/tools/integrations/ddg
    search = DuckDuckGoSearchRun()

    # if data has been uploaded
    def add_context(data_text, context_len=100):
        context = ""
        if data_text != "":
            context = f"""Here is some text for additional context to base your answer on, but you are not limited to using what's in this text for your response: {data_text[:context_len]}
            """
        return context

    # Executing the chains we created for 'Title'
    title_context = add_context(data_text, context_len=100)
    title = title_chain.run(subject=prompt, additional_context=title_context)
    print(title)


    search_term = subject_chain.run(subject=prompt, title=title, additional_context=title_context)
    print(search_term)

    # Executing the chains we created for 'Video Script' by taking help of search engine 'DuckDuckGo'
    search_result = search.run(search_term)

    # Executing the chain for making the script
    script_context = add_context(data_text, context_len=3000)
    script = script_chain.run(title=title,
                              DuckDuckGo_Search=search_result,
                              duration=video_length,
                              additional_context=script_context)

    # Returning the output
    return search_result, title, script

```

### example_projects/project-8/app.py

```
import os
import pandas as pd
import streamlit as st
from pathlib import Path
from utils import generate_script
from dotenv import find_dotenv, load_dotenv

load_dotenv(Path('../../.env'))

# Applying Styling
# st.markdown("""
# <style>
# div.stButton > button:first-child {
#     background-color: #0099ff;
#     color:#ffffff;
# }
# div.stButton > button:hover {
#     background-color: #00ff00;
#     color:#FFFFFF;
#     }
# </style>""", unsafe_allow_html=True)

# Creating Session State Variable
if 'API_Key' not in st.session_state:
    st.session_state['API_Key'] = os.environ['OPENAI_API_KEY']

st.title('❤️ YouTube Script Writing Tool') 

# Sidebar to capture the OpenAi API key
st.sidebar.title("Upload files for additional context")
data = st.sidebar.file_uploader("Upload CSV file", type=["txt", "csv", "json", "md", "xls", "xlsx"])
st.sidebar.image('./Youtube.jpg', width=300, use_column_width=True)

data_text = ""
if data is not None:
    file_details = {"File Name": data.name, "File Type": data.type, "File Size": data.size}
    st.write(file_details)

    # Check file type and read file accordingly
    if data.type == "text/plain":
        data_text = data.read().decode("utf-8")
    elif data.type == "application/vnd.ms-excel":
        # Assume it's a csv
        df = pd.read_csv(data)
        data_text = df.to_string()
    elif data.type == "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":
        df = pd.read_excel(data)
        data_text = df.to_string()
    elif data.type == "application/json":
        import json
        data = json.load(data)
        data_text = json.dumps(data, indent=4)
    else:
        st.warning("Unsupported file type: {}".format(data.type))


# Captures User Inputs
prompt = st.text_input('Please provide the topic of the video', key="prompt")
video_length = st.text_input('Expected Video Length 🕒 (in minutes)', key="video_length")
creativity = st.slider('Words limit ✨ - (0 LOW || 1 HIGH)', 0.0, 1.0, 0.2, step=0.1)

submit = st.button("Generate Script for me")
if submit:
    if st.session_state['API_Key']:

        search_result, title, script = generate_script(prompt, data_text, video_length, creativity, st.session_state['API_Key'])
        st.success('Hope you like this script ❤️')

        st.subheader("Title:🔥")
        st.write(title)

        st.subheader("Your Video Script:📝")
        st.write(script)

        st.subheader("Check Out - Provided Data:")
        with st.expander('Show me 👀'): 
            st.info(data_text)

        st.subheader("Check Out - DuckDuckGo Search:🔍")
        with st.expander('Show me 👀'): 
            st.info(search_result)
    else:
        st.error("Please provide API key.....")

```

