# LMS Platform

Welcome to Eduflex our Learning Management System (LMS) platform! This project is built with Next.js, Tailwind CSS, and TypeScript, providing a visually appealing, SEO-friendly, and secure environment for online learning.

## Features

- Server-side rendering for improved performance and SEO
- Integration with NextAuth and Google-based secure authentication
- Utilizes Tailwind CSS for customizable and visually appealing design
- PostgreSQL and Prisma for efficient data storage and management
- AWS S3 for media storage and on-demand video streaming
- Integration with Razorpay for seamless payment processing
- Admin dashboard for easy management and customization
- Custom video player for streaming with all rich features
- Separate video transcoding service
- AWS SES for handling business emails.
- Shadcn-ui as Ui library

## Installation

1. Clone the repository
2. Install dependencies: `npm install`
3. Configure environment variables
4. Start the development server: `npm run dev`

## Contributing

Contributions are welcome! Please check the [contribution guidelines](CONTRIBUTING.md).

## License

This project is licensed under the [MIT License](LICENSE).
