# generated by fastapi-codegen:
#   filename:  openapi.yml
#   timestamp: 2023-09-16T00:59:36+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Dict, Any

from pydantic import BaseModel, Field


class NotFoundResponse(BaseModel):
    message: str = Field(
        ...,
        description="Message stating the entity was not found",
        example="Unable to find entity with the provided id",
    )


class Pagination(BaseModel):
    total_items: int = Field(..., description="Total number of items.", example=42)
    total_pages: int = Field(..., description="Total number of pages.", example=97)
    current_page: int = Field(..., description="Current_page page number.", example=1)
    page_size: int = Field(..., description="Number of items per page.", example=25)


class Artifact(BaseModel):
    artifact_id: str = Field(
        ...,
        description="ID of the artifact.",
        example="b225e278-8b4c-4f99-a696-8facf19f0e56",
    )
    agent_created: bool = Field(
        ...,
        description="Whether the artifact has been created by the agent.",
        example=False,
    )
    file_name: str = Field(
        ..., description="Filename of the artifact.", example="main.py"
    )
    relative_path: Optional[str] = Field(
        None,
        description="Relative path of the artifact in the agent's workspace.",
        example="python/code/",
    )


class ArtifactUpload(BaseModel):
    file: bytes = Field(
        ..., description="File to upload.", example="binary representation of file"
    )
    relative_path: Optional[str] = Field(
        None,
        description="Relative path of the artifact in the agent's workspace.",
        example="python/code",
    )


class StepOutput(BaseModel):
    pass


class TaskRequestBody(BaseModel):
    input: Optional[str] = Field(
        None,
        description="Input prompt for the task.",
        example="Write 'Washington' to the file 'output.txt'.",
    )
    additional_input: Optional[Dict[str, Any]] = None


class Task(TaskRequestBody):
    task_id: str = Field(
        ...,
        description="The ID of the task.",
        example="50da533e-3904-4401-8a07-c49adf88b5eb",
    )
    artifacts: List[Artifact] = Field(
        ...,
        description="A list of artifacts that the task has produced.",
        example=[
            "7a49f31c-f9c6-4346-a22c-e32bc5af4d8e",
            "ab7b4091-2560-4692-a4fe-d831ea3ca7d6",
        ],
    )


class StepRequestBody(BaseModel):
    input: Optional[str] = Field(
        None,
        description="Input prompt for the step.",
        example="Write the words you receive to the file 'output.txt'.",
    )
    additional_input: Optional[Dict[str, Any]] = None


class Status(Enum):
    created = "created"
    running = "running"
    completed = "completed"


class Step(StepRequestBody):
    task_id: str = Field(
        ...,
        description="The ID of the task this step belongs to.",
        example="50da533e-3904-4401-8a07-c49adf88b5eb",
    )
    step_id: str = Field(
        ...,
        description="The ID of the task step.",
        example="6bb1801a-fd80-45e8-899a-4dd723cc602e",
    )
    name: Optional[str] = Field(
        None, description="The name of the task step.", example="Write to file"
    )
    status: Status = Field(
        ..., description="The status of the task step.", example="created"
    )
    output: Optional[str] = Field(
        None,
        description="Output of the task step.",
        example="I am going to use the write_to_file command and write Washington to a file called output.txt <write_to_file('output.txt', 'Washington')",
    )
    additional_output: Optional[StepOutput] = None
    artifacts: List[Artifact] = Field(
        ..., description="A list of artifacts that the step has produced."
    )
    is_last: bool = Field(
        ..., description="Whether this is the last step in the task.", example=True
    )


class AgentTasksPostResponse(BaseModel):
    pass


class AgentTasksTaskIdGetResponse(BaseModel):
    message: str = Field(
        ...,
        description="Message stating the entity was not found",
        example="Unable to find entity with the provided id",
    )


class AgentTasksTaskIdStepsGetResponse(BaseModel):
    message: str = Field(
        ...,
        description="Message stating the entity was not found",
        example="Unable to find entity with the provided id",
    )


class AgentTasksTaskIdStepsPostResponse(BaseModel):
    message: str = Field(
        ...,
        description="Message stating the entity was not found",
        example="Unable to find entity with the provided id",
    )


class AgentTasksTaskIdStepsPostResponse1(BaseModel):
    pass


class AgentTasksTaskIdStepsStepIdGetResponse(BaseModel):
    message: str = Field(
        ...,
        description="Message stating the entity was not found",
        example="Unable to find entity with the provided id",
    )


class AgentTasksTaskIdArtifactsGetResponse(BaseModel):
    message: str = Field(
        ...,
        description="Message stating the entity was not found",
        example="Unable to find entity with the provided id",
    )


class AgentTasksTaskIdArtifactsPostResponse(BaseModel):
    message: str = Field(
        ...,
        description="Message stating the entity was not found",
        example="Unable to find entity with the provided id",
    )


class AgentTasksTaskIdArtifactsArtifactIdGetResponse(BaseModel):
    message: str = Field(
        ...,
        description="Message stating the entity was not found",
        example="Unable to find entity with the provided id",
    )


class TaskListResponse(BaseModel):
    tasks: List[Task]
    pagination: Pagination


class TaskStepsListResponse(BaseModel):
    steps: List[Step]
    pagination: Pagination


class TaskArtifactsListResponse(BaseModel):
    artifacts: List[Artifact]
    pagination: Pagination
