﻿namespace Gee.External.Capstone;

/// <summary>
///     Represents the options that can be set by <see cref="NativeCapstone.SetDisassembleModeOption" />,
///     <see cref="NativeCapstone.SetInstructionMnemonicOption" />, <see cref="NativeCapstone.SetOption" />, and
///     <see cref="NativeCapstone.SetSkipDataModeConfigOption" />.
/// </summary>
/// <see href="https://github.com/capstone-engine/capstone/blob/1d230532840a37ac032c6ab80128238fc930c6c1/include/capstone/capstone.h#L168" />
internal enum NativeDisassemblerOptionType {
    /// <summary>
    ///     Indicates no option should be set. This member is equivalent to <c>CS_OPT_INVALID</c> in the Capstone
    ///     API.
    /// </summary>
    None = 0,

    /// <summary>
    ///     Represents an option to set the syntax of the assembly code generated by a disassembler. This member
    ///     can only be used by <see cref="NativeCapstone.SetOption" /> with
    ///     <see cref="NativeDisassemblerOptionValue.UseAttDisassembleSyntax" />,
    ///     <see cref="NativeDisassemblerOptionValue.UseDefaultDisassembleSyntax" />,
    ///     <see cref="NativeDisassemblerOptionValue.UseIntelDisassembleSyntax" />, and
    ///     <see cref="NativeDisassemblerOptionValue.UseMasmDisassembleSyntax" />. This member is equivalent to
    ///     <c>CS_OPT_SYNTAX</c> in the Capstone API.
    /// </summary>
    SetDisassembleSyntax,

    /// <summary>
    ///     Represents an option to set whether a disassembler should generate instruction details. This member
    ///     can only be used by <see cref="NativeCapstone.SetOption" /> with
    ///     <see cref="NativeDisassemblerOptionValue.Disable" /> and
    ///     <see cref="NativeDisassemblerOptionValue.Enable" />. This member is equivalent to <c>CS_OPT_DETAIL</c>
    ///     in the Capstone API.
    /// </summary>
    SetInstructionDetails,

    /// <summary>
    ///     Represents an option to set a disassembler's disassemble mode. This member is used by
    ///     <see cref="NativeCapstone.SetDisassembleModeOption" />. This member is equivalent to
    ///     <c>CS_OPT_MODE</c> in the Capstone API.
    /// </summary>
    SetDisassembleMode,
    SetMemory,

    /// <summary>
    ///     Represents an option to set whether Skip Data Mode is enabled for a disassembler. This member is used
    ///     by <see cref="NativeCapstone.SetOption" /> with <see cref="NativeDisassemblerOptionValue.Disable" />
    ///     and <see cref="NativeDisassemblerOptionValue.Enable" />. This member is equivalent to
    ///     <c>CS_OPT_SKIPDATA</c> in the Capstone API.
    /// </summary>
    SetSkipDataMode,

    /// <summary>
    ///     Represents an option to set a disassembler's Skip Data Mode configuration. This member is used by
    ///     <see cref="NativeCapstone.SetSkipDataModeConfigOption" />. This member is equivalent to
    ///     <c>CS_OPT_SKIPDATA_SETUP</c> in the Capstone API.
    /// </summary>
    SetSkipDataModeConfig,

    /// <summary>
    ///     Represents an option to set an instruction's mnemonic. This member is used by
    ///     <see cref="NativeCapstone.SetInstructionMnemonicOption" />. This member is equivalent to
    ///     <c>CS_OPT_MNEMONIC</c> in the Capstone API.
    /// </summary>
    SetInstructionMnemonic,
    SetUnsigned
}