﻿using System.Diagnostics.CodeAnalysis;

namespace Gee.External.Capstone.Arm64;

/// <summary>
///     ARM64 Register Unique Identifier.
/// </summary>
[SuppressMessage("ReSharper", "IdentifierTypo")]
[SuppressMessage("ReSharper", "InconsistentNaming")]
public enum Arm64RegisterId {
    /// <summary>
    ///     Indicates an invalid, or an uninitialized, register.
    /// </summary>
    Invalid = 0,
    ARM64_REG_X29,
    ARM64_REG_X30,
    ARM64_REG_NZCV,
    ARM64_REG_SP,
    ARM64_REG_WSP,
    ARM64_REG_WZR,
    ARM64_REG_XZR,
    ARM64_REG_B0,
    ARM64_REG_B1,
    ARM64_REG_B2,
    ARM64_REG_B3,
    ARM64_REG_B4,
    ARM64_REG_B5,
    ARM64_REG_B6,
    ARM64_REG_B7,
    ARM64_REG_B8,
    ARM64_REG_B9,
    ARM64_REG_B10,
    ARM64_REG_B11,
    ARM64_REG_B12,
    ARM64_REG_B13,
    ARM64_REG_B14,
    ARM64_REG_B15,
    ARM64_REG_B16,
    ARM64_REG_B17,
    ARM64_REG_B18,
    ARM64_REG_B19,
    ARM64_REG_B20,
    ARM64_REG_B21,
    ARM64_REG_B22,
    ARM64_REG_B23,
    ARM64_REG_B24,
    ARM64_REG_B25,
    ARM64_REG_B26,
    ARM64_REG_B27,
    ARM64_REG_B28,
    ARM64_REG_B29,
    ARM64_REG_B30,
    ARM64_REG_B31,
    ARM64_REG_D0,
    ARM64_REG_D1,
    ARM64_REG_D2,
    ARM64_REG_D3,
    ARM64_REG_D4,
    ARM64_REG_D5,
    ARM64_REG_D6,
    ARM64_REG_D7,
    ARM64_REG_D8,
    ARM64_REG_D9,
    ARM64_REG_D10,
    ARM64_REG_D11,
    ARM64_REG_D12,
    ARM64_REG_D13,
    ARM64_REG_D14,
    ARM64_REG_D15,
    ARM64_REG_D16,
    ARM64_REG_D17,
    ARM64_REG_D18,
    ARM64_REG_D19,
    ARM64_REG_D20,
    ARM64_REG_D21,
    ARM64_REG_D22,
    ARM64_REG_D23,
    ARM64_REG_D24,
    ARM64_REG_D25,
    ARM64_REG_D26,
    ARM64_REG_D27,
    ARM64_REG_D28,
    ARM64_REG_D29,
    ARM64_REG_D30,
    ARM64_REG_D31,
    ARM64_REG_H0,
    ARM64_REG_H1,
    ARM64_REG_H2,
    ARM64_REG_H3,
    ARM64_REG_H4,
    ARM64_REG_H5,
    ARM64_REG_H6,
    ARM64_REG_H7,
    ARM64_REG_H8,
    ARM64_REG_H9,
    ARM64_REG_H10,
    ARM64_REG_H11,
    ARM64_REG_H12,
    ARM64_REG_H13,
    ARM64_REG_H14,
    ARM64_REG_H15,
    ARM64_REG_H16,
    ARM64_REG_H17,
    ARM64_REG_H18,
    ARM64_REG_H19,
    ARM64_REG_H20,
    ARM64_REG_H21,
    ARM64_REG_H22,
    ARM64_REG_H23,
    ARM64_REG_H24,
    ARM64_REG_H25,
    ARM64_REG_H26,
    ARM64_REG_H27,
    ARM64_REG_H28,
    ARM64_REG_H29,
    ARM64_REG_H30,
    ARM64_REG_H31,
    ARM64_REG_Q0,
    ARM64_REG_Q1,
    ARM64_REG_Q2,
    ARM64_REG_Q3,
    ARM64_REG_Q4,
    ARM64_REG_Q5,
    ARM64_REG_Q6,
    ARM64_REG_Q7,
    ARM64_REG_Q8,
    ARM64_REG_Q9,
    ARM64_REG_Q10,
    ARM64_REG_Q11,
    ARM64_REG_Q12,
    ARM64_REG_Q13,
    ARM64_REG_Q14,
    ARM64_REG_Q15,
    ARM64_REG_Q16,
    ARM64_REG_Q17,
    ARM64_REG_Q18,
    ARM64_REG_Q19,
    ARM64_REG_Q20,
    ARM64_REG_Q21,
    ARM64_REG_Q22,
    ARM64_REG_Q23,
    ARM64_REG_Q24,
    ARM64_REG_Q25,
    ARM64_REG_Q26,
    ARM64_REG_Q27,
    ARM64_REG_Q28,
    ARM64_REG_Q29,
    ARM64_REG_Q30,
    ARM64_REG_Q31,
    ARM64_REG_S0,
    ARM64_REG_S1,
    ARM64_REG_S2,
    ARM64_REG_S3,
    ARM64_REG_S4,
    ARM64_REG_S5,
    ARM64_REG_S6,
    ARM64_REG_S7,
    ARM64_REG_S8,
    ARM64_REG_S9,
    ARM64_REG_S10,
    ARM64_REG_S11,
    ARM64_REG_S12,
    ARM64_REG_S13,
    ARM64_REG_S14,
    ARM64_REG_S15,
    ARM64_REG_S16,
    ARM64_REG_S17,
    ARM64_REG_S18,
    ARM64_REG_S19,
    ARM64_REG_S20,
    ARM64_REG_S21,
    ARM64_REG_S22,
    ARM64_REG_S23,
    ARM64_REG_S24,
    ARM64_REG_S25,
    ARM64_REG_S26,
    ARM64_REG_S27,
    ARM64_REG_S28,
    ARM64_REG_S29,
    ARM64_REG_S30,
    ARM64_REG_S31,
    ARM64_REG_W0,
    ARM64_REG_W1,
    ARM64_REG_W2,
    ARM64_REG_W3,
    ARM64_REG_W4,
    ARM64_REG_W5,
    ARM64_REG_W6,
    ARM64_REG_W7,
    ARM64_REG_W8,
    ARM64_REG_W9,
    ARM64_REG_W10,
    ARM64_REG_W11,
    ARM64_REG_W12,
    ARM64_REG_W13,
    ARM64_REG_W14,
    ARM64_REG_W15,
    ARM64_REG_W16,
    ARM64_REG_W17,
    ARM64_REG_W18,
    ARM64_REG_W19,
    ARM64_REG_W20,
    ARM64_REG_W21,
    ARM64_REG_W22,
    ARM64_REG_W23,
    ARM64_REG_W24,
    ARM64_REG_W25,
    ARM64_REG_W26,
    ARM64_REG_W27,
    ARM64_REG_W28,
    ARM64_REG_W29,
    ARM64_REG_W30,
    ARM64_REG_X0,
    ARM64_REG_X1,
    ARM64_REG_X2,
    ARM64_REG_X3,
    ARM64_REG_X4,
    ARM64_REG_X5,
    ARM64_REG_X6,
    ARM64_REG_X7,
    ARM64_REG_X8,
    ARM64_REG_X9,
    ARM64_REG_X10,
    ARM64_REG_X11,
    ARM64_REG_X12,
    ARM64_REG_X13,
    ARM64_REG_X14,
    ARM64_REG_X15,
    ARM64_REG_X16,
    ARM64_REG_X17,
    ARM64_REG_X18,
    ARM64_REG_X19,
    ARM64_REG_X20,
    ARM64_REG_X21,
    ARM64_REG_X22,
    ARM64_REG_X23,
    ARM64_REG_X24,
    ARM64_REG_X25,
    ARM64_REG_X26,
    ARM64_REG_X27,
    ARM64_REG_X28,
    ARM64_REG_V0,
    ARM64_REG_V1,
    ARM64_REG_V2,
    ARM64_REG_V3,
    ARM64_REG_V4,
    ARM64_REG_V5,
    ARM64_REG_V6,
    ARM64_REG_V7,
    ARM64_REG_V8,
    ARM64_REG_V9,
    ARM64_REG_V10,
    ARM64_REG_V11,
    ARM64_REG_V12,
    ARM64_REG_V13,
    ARM64_REG_V14,
    ARM64_REG_V15,
    ARM64_REG_V16,
    ARM64_REG_V17,
    ARM64_REG_V18,
    ARM64_REG_V19,
    ARM64_REG_V20,
    ARM64_REG_V21,
    ARM64_REG_V22,
    ARM64_REG_V23,
    ARM64_REG_V24,
    ARM64_REG_V25,
    ARM64_REG_V26,
    ARM64_REG_V27,
    ARM64_REG_V28,
    ARM64_REG_V29,
    ARM64_REG_V30,
    ARM64_REG_V31,
    ARM64_REG_IP0 = Arm64RegisterId.ARM64_REG_X16,
    ARM64_REG_IP1 = Arm64RegisterId.ARM64_REG_X17,
    ARM64_REG_FP = Arm64RegisterId.ARM64_REG_X29,
    ARM64_REG_LR = Arm64RegisterId.ARM64_REG_X30
}