﻿using System.Diagnostics.CodeAnalysis;

namespace Gee.External.Capstone.Arm64;

/// <summary>
///     ARM64 MRS System Register.
/// </summary>
[SuppressMessage("ReSharper", "IdentifierTypo")]
[SuppressMessage("ReSharper", "InconsistentNaming")]
public enum Arm64MrsSystemRegister {
    /// <summary>
    ///     Indicates an invalid, or an uninitialized, system register.
    /// </summary>
    Invalid = 0,
    ARM64_SYSREG_MDCCSR_EL0 = 0x9808,
    ARM64_SYSREG_DBGDTRRX_EL0 = 0x9828,
    ARM64_SYSREG_MDRAR_EL1 = 0x8080,
    ARM64_SYSREG_OSLSR_EL1 = 0x808c,
    ARM64_SYSREG_DBGAUTHSTATUS_EL1 = 0x83f6,
    ARM64_SYSREG_PMCEID0_EL0 = 0xdce6,
    ARM64_SYSREG_PMCEID1_EL0 = 0xdce7,
    ARM64_SYSREG_MIDR_EL1 = 0xc000,
    ARM64_SYSREG_CCSIDR_EL1 = 0xc800,
    ARM64_SYSREG_CLIDR_EL1 = 0xc801,
    ARM64_SYSREG_CTR_EL0 = 0xd801,
    ARM64_SYSREG_MPIDR_EL1 = 0xc005,
    ARM64_SYSREG_REVIDR_EL1 = 0xc006,
    ARM64_SYSREG_AIDR_EL1 = 0xc807,
    ARM64_SYSREG_DCZID_EL0 = 0xd807,
    ARM64_SYSREG_ID_PFR0_EL1 = 0xc008,
    ARM64_SYSREG_ID_PFR1_EL1 = 0xc009,
    ARM64_SYSREG_ID_DFR0_EL1 = 0xc00a,
    ARM64_SYSREG_ID_AFR0_EL1 = 0xc00b,
    ARM64_SYSREG_ID_MMFR0_EL1 = 0xc00c,
    ARM64_SYSREG_ID_MMFR1_EL1 = 0xc00d,
    ARM64_SYSREG_ID_MMFR2_EL1 = 0xc00e,
    ARM64_SYSREG_ID_MMFR3_EL1 = 0xc00f,
    ARM64_SYSREG_ID_ISAR0_EL1 = 0xc010,
    ARM64_SYSREG_ID_ISAR1_EL1 = 0xc011,
    ARM64_SYSREG_ID_ISAR2_EL1 = 0xc012,
    ARM64_SYSREG_ID_ISAR3_EL1 = 0xc013,
    ARM64_SYSREG_ID_ISAR4_EL1 = 0xc014,
    ARM64_SYSREG_ID_ISAR5_EL1 = 0xc015,
    ARM64_SYSREG_ID_A64PFR0_EL1 = 0xc020,
    ARM64_SYSREG_ID_A64PFR1_EL1 = 0xc021,
    ARM64_SYSREG_ID_A64DFR0_EL1 = 0xc028,
    ARM64_SYSREG_ID_A64DFR1_EL1 = 0xc029,
    ARM64_SYSREG_ID_A64AFR0_EL1 = 0xc02c,
    ARM64_SYSREG_ID_A64AFR1_EL1 = 0xc02d,
    ARM64_SYSREG_ID_A64ISAR0_EL1 = 0xc030,
    ARM64_SYSREG_ID_A64ISAR1_EL1 = 0xc031,
    ARM64_SYSREG_ID_A64MMFR0_EL1 = 0xc038,
    ARM64_SYSREG_ID_A64MMFR1_EL1 = 0xc039,
    ARM64_SYSREG_MVFR0_EL1 = 0xc018,
    ARM64_SYSREG_MVFR1_EL1 = 0xc019,
    ARM64_SYSREG_MVFR2_EL1 = 0xc01a,
    ARM64_SYSREG_RVBAR_EL1 = 0xc601,
    ARM64_SYSREG_RVBAR_EL2 = 0xe601,
    ARM64_SYSREG_RVBAR_EL3 = 0xf601,
    ARM64_SYSREG_ISR_EL1 = 0xc608,
    ARM64_SYSREG_CNTPCT_EL0 = 0xdf01,
    ARM64_SYSREG_CNTVCT_EL0 = 0xdf02,
    ARM64_SYSREG_TRCSTATR = 0x8818,
    ARM64_SYSREG_TRCIDR8 = 0x8806,
    ARM64_SYSREG_TRCIDR9 = 0x880e,
    ARM64_SYSREG_TRCIDR10 = 0x8816,
    ARM64_SYSREG_TRCIDR11 = 0x881e,
    ARM64_SYSREG_TRCIDR12 = 0x8826,
    ARM64_SYSREG_TRCIDR13 = 0x882e,
    ARM64_SYSREG_TRCIDR0 = 0x8847,
    ARM64_SYSREG_TRCIDR1 = 0x884f,
    ARM64_SYSREG_TRCIDR2 = 0x8857,
    ARM64_SYSREG_TRCIDR3 = 0x885f,
    ARM64_SYSREG_TRCIDR4 = 0x8867,
    ARM64_SYSREG_TRCIDR5 = 0x886f,
    ARM64_SYSREG_TRCIDR6 = 0x8877,
    ARM64_SYSREG_TRCIDR7 = 0x887f,
    ARM64_SYSREG_TRCOSLSR = 0x888c,
    ARM64_SYSREG_TRCPDSR = 0x88ac,
    ARM64_SYSREG_TRCDEVAFF0 = 0x8bd6,
    ARM64_SYSREG_TRCDEVAFF1 = 0x8bde,
    ARM64_SYSREG_TRCLSR = 0x8bee,
    ARM64_SYSREG_TRCAUTHSTATUS = 0x8bf6,
    ARM64_SYSREG_TRCDEVARCH = 0x8bfe,
    ARM64_SYSREG_TRCDEVID = 0x8b97,
    ARM64_SYSREG_TRCDEVTYPE = 0x8b9f,
    ARM64_SYSREG_TRCPIDR4 = 0x8ba7,
    ARM64_SYSREG_TRCPIDR5 = 0x8baf,
    ARM64_SYSREG_TRCPIDR6 = 0x8bb7,
    ARM64_SYSREG_TRCPIDR7 = 0x8bbf,
    ARM64_SYSREG_TRCPIDR0 = 0x8bc7,
    ARM64_SYSREG_TRCPIDR1 = 0x8bcf,
    ARM64_SYSREG_TRCPIDR2 = 0x8bd7,
    ARM64_SYSREG_TRCPIDR3 = 0x8bdf,
    ARM64_SYSREG_TRCCIDR0 = 0x8be7,
    ARM64_SYSREG_TRCCIDR1 = 0x8bef,
    ARM64_SYSREG_TRCCIDR2 = 0x8bf7,
    ARM64_SYSREG_TRCCIDR3 = 0x8bff,
    ARM64_SYSREG_ICC_IAR1_EL1 = 0xc660,
    ARM64_SYSREG_ICC_IAR0_EL1 = 0xc640,
    ARM64_SYSREG_ICC_HPPIR1_EL1 = 0xc662,
    ARM64_SYSREG_ICC_HPPIR0_EL1 = 0xc642,
    ARM64_SYSREG_ICC_RPR_EL1 = 0xc65b,
    ARM64_SYSREG_ICH_VTR_EL2 = 0xe659,
    ARM64_SYSREG_ICH_EISR_EL2 = 0xe65b,
    ARM64_SYSREG_ICH_ELSR_EL2 = 0xe65d
}