﻿using System.Diagnostics.CodeAnalysis;

namespace Gee.External.Capstone.Arm;

/// <summary>
///     ARM System Register.
/// </summary>
[SuppressMessage("ReSharper", "IdentifierTypo")]
[SuppressMessage("ReSharper", "InconsistentNaming")]
public enum ArmSystemRegister {
    /// <summary>
    ///     Indicates an invalid, or an uninitialized, system register.
    /// </summary>
    Invalid = 0,
    ARM_SYSREG_SPSR_C = 1,
    ARM_SYSREG_SPSR_X = 2,
    ARM_SYSREG_SPSR_S = 4,
    ARM_SYSREG_SPSR_F = 8,
    ARM_SYSREG_CPSR_C = 16,
    ARM_SYSREG_CPSR_X = 32,
    ARM_SYSREG_CPSR_S = 64,
    ARM_SYSREG_CPSR_F = 128,
    ARM_SYSREG_APSR = 256,
    ARM_SYSREG_APSR_G,
    ARM_SYSREG_APSR_NZCVQ,
    ARM_SYSREG_APSR_NZCVQG,
    ARM_SYSREG_IAPSR,
    ARM_SYSREG_IAPSR_G,
    ARM_SYSREG_IAPSR_NZCVQG,
    ARM_SYSREG_IAPSR_NZCVQ,
    ARM_SYSREG_EAPSR,
    ARM_SYSREG_EAPSR_G,
    ARM_SYSREG_EAPSR_NZCVQG,
    ARM_SYSREG_EAPSR_NZCVQ,
    ARM_SYSREG_XPSR,
    ARM_SYSREG_XPSR_G,
    ARM_SYSREG_XPSR_NZCVQG,
    ARM_SYSREG_XPSR_NZCVQ,
    ARM_SYSREG_IPSR,
    ARM_SYSREG_EPSR,
    ARM_SYSREG_IEPSR,
    ARM_SYSREG_MSP,
    ARM_SYSREG_PSP,
    ARM_SYSREG_PRIMASK,
    ARM_SYSREG_BASEPRI,
    ARM_SYSREG_BASEPRI_MAX,
    ARM_SYSREG_FAULTMASK,
    ARM_SYSREG_CONTROL,
    ARM_SYSREG_R8_USR,
    ARM_SYSREG_R9_USR,
    ARM_SYSREG_R10_USR,
    ARM_SYSREG_R11_USR,
    ARM_SYSREG_R12_USR,
    ARM_SYSREG_SP_USR,
    ARM_SYSREG_LR_USR,
    ARM_SYSREG_R8_FIQ,
    ARM_SYSREG_R9_FIQ,
    ARM_SYSREG_R10_FIQ,
    ARM_SYSREG_R11_FIQ,
    ARM_SYSREG_R12_FIQ,
    ARM_SYSREG_SP_FIQ,
    ARM_SYSREG_LR_FIQ,
    ARM_SYSREG_LR_IRQ,
    ARM_SYSREG_SP_IRQ,
    ARM_SYSREG_LR_SVC,
    ARM_SYSREG_SP_SVC,
    ARM_SYSREG_LR_ABT,
    ARM_SYSREG_SP_ABT,
    ARM_SYSREG_LR_UND,
    ARM_SYSREG_SP_UND,
    ARM_SYSREG_LR_MON,
    ARM_SYSREG_SP_MON,
    ARM_SYSREG_ELR_HYP,
    ARM_SYSREG_SP_HYP,
    ARM_SYSREG_SPSR_FIQ,
    ARM_SYSREG_SPSR_IRQ,
    ARM_SYSREG_SPSR_SVC,
    ARM_SYSREG_SPSR_ABT,
    ARM_SYSREG_SPSR_UND,
    ARM_SYSREG_SPSR_MON,
    ARM_SYSREG_SPSR_HYP
}