import { cn } from "@/libs/cn";
import type { CheckboxControlProps } from "@kobalte/core/checkbox";
import { Checkbox as CheckboxPrimitive } from "@kobalte/core/checkbox";
import type { PolymorphicProps } from "@kobalte/core/polymorphic";
import type { ValidComponent, VoidProps } from "solid-js";
import { splitProps } from "solid-js";

export const CheckboxLabel = CheckboxPrimitive.Label;
export const Checkbox = CheckboxPrimitive;
export const CheckboxErrorMessage =
  CheckboxPrimitive.ErrorMessage;
export const CheckboxDescription =
  CheckboxPrimitive.Description;

type checkboxControlProps<
  T extends ValidComponent = "div",
> = VoidProps<CheckboxControlProps<T> & { class?: string }>;

export const CheckboxControl = <
  T extends ValidComponent = "div",
>(
  props: PolymorphicProps<T, checkboxControlProps<T>>,
) => {
  const [local, rest] = splitProps(
    props as checkboxControlProps,
    ["class", "children"],
  );

  return (
    <>
      <CheckboxPrimitive.Input
        class="[&:focus-visible+div]:outline-none
          [&:focus-visible+div]:ring-[1.5px]
          [&:focus-visible+div]:ring-ring
          [&:focus-visible+div]:ring-offset-2
          [&:focus-visible+div]:ring-offset-background"
      />
      <CheckboxPrimitive.Control
        class={cn(
          `size-4 shrink-0 rounded-sm border border-primary shadow
          transition-shadow data-[disabled]:cursor-not-allowed
          data-[checked]:bg-primary
          data-[checked]:text-primary-foreground
          data-[disabled]:opacity-50 focus-visible:outline-none
          focus-visible:ring-[1.5px] focus-visible:ring-ring`,
          local.class,
        )}
        {...rest}
      >
        <CheckboxPrimitive.Indicator class="relative size-4">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 24 24"
            class="absolute left-1/2 top-1/2 size-4 -translate-x-1/2
              -translate-y-1/2"
          >
            <path
              fill="none"
              stroke="currentColor"
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke-width="2"
              d="m5 12l4 4 8-8"
            />
            <title>Checkbox</title>
          </svg>
        </CheckboxPrimitive.Indicator>
      </CheckboxPrimitive.Control>
    </>
  );
};
