;(function(window) {

  var svgSprite = '<svg>' +
    '' +
    '<symbol id="icon-edit" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M507.424 676.576l66.272-66.272-86.848-86.848-66.272 66.272 0 32 54.848 0 0 54.848 32 0zM758.848 265.152q-9.152-9.152-18.848 0.576l-200 200q-9.728 9.728-0.576 18.848t18.848-0.576l200-200q9.728-9.728 0.576-18.848zM804.576 604.576l0 108.576q0 68-48.288 116.288t-116.288 48.288l-475.424 0q-68 0-116.288-48.288t-48.288-116.288l0-475.424q0-68 48.288-116.288t116.288-48.288l475.424 0q36 0 66.848 14.272 8.576 4 10.272 13.152 1.728 9.728-5.152 16.576l-28 28q-8 8-18.272 4.576-13.152-3.424-25.728-3.424l-475.424 0q-37.728 0-64.576 26.848t-26.848 64.576l0 475.424q0 37.728 26.848 64.576t64.576 26.848l475.424 0q37.728 0 64.576-26.848t26.848-64.576l0-72q0-7.424 5.152-12.576l36.576-36.576q8.576-8.576 20-4t11.424 16.576zM749.728 182.848l164.576 164.576-384 384-164.576 0 0-164.576zM1003.424 258.272l-52.576 52.576-164.576-164.576 52.576-52.576q16-16 38.848-16t38.848 16l86.848 86.848q16 16 16 38.848t-16 38.848z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-iconfontexcel" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M741.696116 384.727315 607.207705 384.727315 512.000512 524.988826 416.789225 384.727315 282.242484 384.727315 443.512938 625.847931 261.546291 893.813962 522.313814 893.813962 522.313814 802.77348 462.032469 802.77348 512.000512 728.138642 622.744176 893.813962 762.389238 893.813962 580.483992 625.847931Z"  ></path>' +
    '' +
    '<path d="M901.163431 201.214744 759.097127 59.153238c-30.886693-30.886451-91.97853-56.240909-135.729732-56.240909l-477.289567 0c-43.752226 0-79.548943 35.795251-79.548943 79.545684l0 859.083973c0 43.750433 35.796717 79.544661 79.548943 79.544661l731.844343 0c43.751202 0 79.54792-35.794228 79.54792-79.544661L957.470092 337.000314C957.470092 293.250904 932.113572 232.102219 901.163431 201.214744zM702.915315 94.948489c4.285782 2.982938 8.079333 6.089695 11.186218 9.195429l142.067327 142.063553c3.107908 3.106758 6.21377 6.898107 9.259254 11.248182L702.915315 257.455653 702.915315 94.948489zM893.831142 941.541987c0 8.639774-7.333313 15.909341-15.90897 15.909341L146.077828 957.451328c-8.701529 0-15.909993-7.330966-15.909993-15.909341L130.167835 82.458013c0-8.639774 7.334336-15.909341 15.909993-15.909341l477.289567 0c4.721728 0 10.191524 0.620124 15.909993 1.738597l0 252.80268 252.813038 0c1.119543 5.718235 1.740715 11.062963 1.740715 15.909341L893.831142 941.541987z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-list" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M64.661184 810.227242l894.675586 0 0-99.411127L64.661184 710.816115 64.661184 810.227242zM64.661184 561.711192l894.675586 0 0-99.411127L64.661184 462.300065 64.661184 561.711192zM64.661184 213.772758l0 99.397824 894.675586 0 0-99.397824L64.661184 213.772758z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-service" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M537.676629 572.777016C667.27978 572.777016 772.259879 466.772722 772.259879 336.112332 772.259879 205.451942 667.27978 99.447648 537.676629 99.447648 408.073477 99.447648 303.093381 205.451942 303.093381 336.112332 303.093381 466.772722 408.073477 572.777016 537.676629 572.777016L537.676629 572.777016ZM537.676629 530.304582C431.623156 530.304582 345.565814 443.407655 345.565814 336.112332 345.565814 228.817008 431.623156 141.920082 537.676629 141.920082 643.730103 141.920082 729.787446 228.817008 729.787446 336.112332 729.787446 443.407655 643.730103 530.304582 537.676629 530.304582L537.676629 530.304582Z"  ></path>' +
    '' +
    '<path d="M1001.664066 1024.000004C1001.664066 751.431228 782.755985 530.387459 512.615542 530.387459 242.4751 530.387459 23.567019 751.431228 23.567019 1024.000004L66.039452 1024.000004C66.039452 774.796294 266.024779 572.859892 512.615542 572.859892 759.206306 572.859892 959.191633 774.796294 959.191633 1024.000004L1001.664066 1024.000004 1001.664066 1024.000004Z"  ></path>' +
    '' +
    '<path d="M233.809816 572.859892C281.846495 572.859892 320.7039 533.623389 320.7039 485.325241 320.7039 437.027096 281.846495 397.790593 233.809816 397.790593 185.773138 397.790593 146.915732 437.027096 146.915732 485.325241 146.915732 533.623389 185.773138 572.859892 233.809816 572.859892L233.809816 572.859892ZM233.809816 530.387459C209.322817 530.387459 189.388166 510.258322 189.388166 485.325241 189.388166 460.392163 209.322817 440.263026 233.809816 440.263026 258.296816 440.263026 278.231467 460.392163 278.231467 485.325241 278.231467 510.258322 258.296816 530.387459 233.809816 530.387459L233.809816 530.387459Z"  ></path>' +
    '' +
    '<path d="M830.543236 520.287306C838.435011 517.213408 856.420583 512.250861 869.738118 507.413846 871.10678 506.916965 871.10678 506.916965 872.477119 506.42035 883.299946 502.499785 894.907365 498.352896 906.516385 494.244034 913.482439 491.778488 918.897025 489.874927 921.981649 488.795985L936.206384 483.820443 936.206384 468.750633 936.206384 282.286293 936.206384 269.008648 924.26945 263.194403C922.053561 262.115087 918.144366 260.19565 913.109699 257.697247 904.720115 253.534 896.333421 249.310732 888.525544 245.293116 886.929012 244.470731 886.929012 244.470731 885.338411 243.647696 876.494909 239.066281 869.177034 235.138507 863.892556 232.110649 861.160872 230.54547 859.071734 229.275744 857.78666 228.410362 859.888255 229.825599 860.115079 230.016911 862.214218 234.916219 804.257697 99.647907 670.564953 0 531.990097 0 337.403916 0 179.744666 159.197389 179.744666 355.474788 179.744666 378.590106 181.933686 401.433919 186.246239 423.785122L227.949506 415.738687C224.147939 396.035838 222.2171 375.886294 222.2171 355.474788 222.2171 182.562455 360.953596 42.472433 531.990097 42.472433 652.531844 42.472433 771.567984 131.196039 823.17426 251.643123 827.282349 261.231249 830.445679 263.043749 865.801418 281.359942 867.446153 282.210985 867.446153 282.210985 869.092686 283.059126 877.10527 287.182075 885.669071 291.494531 894.229978 295.742796 899.365609 298.291301 903.366644 300.255832 905.670886 301.378183L893.733951 282.286293 893.733951 468.750633 907.958689 448.705284C904.827575 449.800489 899.364613 451.721059 892.345253 454.205469 880.645251 458.346535 868.943646 462.527074 858.011386 466.48728 856.62458 466.989862 856.62458 466.989862 855.238611 467.493025 841.640096 472.432095 830.384497 476.618365 822.125588 479.835263 817.286018 481.720307 813.48815 483.267063 810.712137 484.49784 808.902954 485.299962 807.434242 486.005276 806.123281 486.734668 804.750891 487.504549 804.750891 487.504549 802.39627 489.219923 797.915841 491.325505 788.070803 499.05109 795.378771 512.767063 802.686739 526.483036 826.258515 521.956233 830.543236 520.287306Z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-gifts" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M151.31783 556.31747 151.31783 883.907454C151.31783 920.029577 180.635004 949.418204 216.629434 949.418204L784.642673 949.418204C820.737084 949.418204 849.954278 920.237995 849.954278 884.101732L849.954278 567.069766 806.295364 567.069766 806.295364 884.101732C806.295364 896.113453 796.637303 905.759287 784.642673 905.759287L216.629434 905.759287C204.770979 905.759287 194.976744 895.941182 194.976744 883.907454L194.976744 556.31747 151.31783 556.31747 151.31783 556.31747Z"  ></path>' +
    '' +
    '<path d="M544.248062 927.255814 544.248062 305.116279 500.589148 305.116279 500.589148 927.255814 544.248062 927.255814 544.248062 927.255814Z"  ></path>' +
    '' +
    '<path d="M85.829457 326.945737 828.143565 326.945737C864.241261 326.945737 893.519379 356.278505 893.519379 392.485833L893.519379 545.240309 915.348836 523.410852 173.03473 523.410852C136.937034 523.410852 107.658915 494.078084 107.658915 457.870756L107.658915 305.116279 85.829457 326.945737 85.829457 326.945737ZM85.829457 283.286822 64 283.286822 64 305.116279 64 457.870756C64 518.17203 112.806637 567.069766 173.03473 567.069766L915.348836 567.069766 937.178295 567.069766 937.178295 545.240309 937.178295 392.485833C937.178295 332.184559 888.371659 283.286822 828.143565 283.286822L85.829457 283.286822 85.829457 283.286822Z"  ></path>' +
    '' +
    '<path d="M456.930234 261.457365 587.906976 261.457365 566.077519 239.627906 566.077519 305.116279 587.906976 283.286822 456.930234 283.286822 478.759691 305.116279 478.759691 239.627906 456.930234 261.457365 456.930234 261.457365ZM456.930234 217.79845 435.100774 217.79845 435.100774 239.627906 435.100774 305.116279 435.100774 326.945737 456.930234 326.945737 587.906976 326.945737 609.736433 326.945737 609.736433 305.116279 609.736433 239.627906 609.736433 217.79845 587.906976 217.79845 456.930234 217.79845 456.930234 217.79845Z"  ></path>' +
    '' +
    '<path d="M551.660693 251.486788C552.55357 250.106889 554.286927 247.460145 556.764205 243.728553 560.914573 237.47673 565.616813 230.502266 570.773873 222.987694 585.499725 201.530022 600.893771 180.079304 616.162106 160.113019 624.310061 149.458001 632.211424 139.508136 639.79069 130.397706 667.823241 96.702015 691.414249 75.906977 697.054263 75.906977 731.078613 75.906977 790.860256 113.663803 821.48217 154.493023 826.567552 161.273533 823.726334 180.275765 811.048563 206.999126 805.881086 217.891608 810.522118 230.910777 821.414601 236.078255 832.307083 241.245732 845.326251 236.6047 850.49373 225.712218 869.606571 185.424421 874.534694 152.464863 856.409301 128.297674 818.268427 77.443174 746.7095 32.248062 697.054263 32.248062 672.038714 32.248062 644.340604 56.663432 606.227876 102.475701 598.243548 112.073026 589.974942 122.485343 581.481306 133.592407 565.71088 154.21527 549.895622 176.252924 534.776514 198.283624 529.487838 205.989982 524.661009 213.149239 520.390835 219.581526 517.815787 223.460397 515.989067 226.2497 515.005973 227.769026 508.456493 237.890948 511.352531 251.40579 521.474453 257.955268 531.596375 264.504747 545.111215 261.60871 551.660693 251.486788L551.660693 251.486788Z"  ></path>' +
    '' +
    '<path d="M537.988958 227.769026C537.005865 226.2497 535.179145 223.460397 532.604096 219.581526 528.333922 213.149239 523.507093 205.989982 518.218415 198.283624 503.099307 176.252924 487.284049 154.21527 471.513626 133.592407 463.019987 122.485343 454.751383 112.073026 446.767055 102.475701 408.654327 56.663432 380.956218 32.248062 355.940668 32.248062 306.285431 32.248062 234.726504 77.443174 196.585628 128.297674 178.612682 152.261603 183.326064 184.892714 202.033209 224.720828 208.2705 238.000222 216.033171 251.855612 224.982418 266.060766 233.201436 279.106825 241.973779 291.750138 250.747785 303.541662 256.034751 310.646895 260.185632 315.936681 262.642498 318.939516L296.432634 291.293041C294.378822 288.782827 290.636015 284.013082 285.773954 277.478882 277.632915 266.538016 269.490213 254.802185 261.921855 242.788919 253.864791 229.999929 246.954809 217.666482 241.55017 206.159831 229.189078 179.842667 226.494032 161.18466 231.51276 154.493023 262.134675 113.663803 321.916316 75.906977 355.940668 75.906977 361.580681 75.906977 385.171691 96.702015 413.204241 130.397706 420.783505 139.508136 428.68487 149.458001 436.832823 160.113019 452.101161 180.079304 467.495204 201.530022 482.221058 222.987694 487.378116 230.502266 492.080356 237.47673 496.230726 243.728553 498.708002 247.460145 500.441361 250.106889 501.334236 251.486788L537.988958 227.769026 537.988958 227.769026Z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-warn" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M504 720c-30.928 0-56 25.072-56 56s25.072 56 56 56c30.944 0 56-25.072 56-56S534.944 720 504 720zM512 0C229.232 0 0 229.232 0 512s229.232 512 512 512c282.784 0 512-229.232 512-512S794.784 0 512 0zM512 1008C238.064 1008 16 785.936 16 512S238.064 16 512 16c273.936 0 496 222.064 496 496S785.936 1008 512 1008zM480 416l16 272c2.288-0.032 16 0 16 0s15.184-237.008 16-256c1.344-30.736 11.264-86.48 16-112 9.296-50.08 0-96 0-96s-14.368-23.888-32-32c-4.304-1.984-11.984 0-16 0-19.488 0-32 32-32 32s-5.808 36.144 0 96C466.672 347.584 480 379.024 480 416z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-chat1" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M513.875209 514.605338 276.496823 514.605338c-6.78145 0-14.326287 10.614755-14.326287 17.396205 0 6.78145 7.544837 17.396205 14.326287 17.396205l237.378385 0c6.779404 0 15.349593-7.887644 15.349593-17.396205C529.224802 522.490935 520.654612 514.605338 513.875209 514.605338z"  ></path>' +
    '' +
    '<path d="M592.604294 360.557846 276.324908 360.557846c-6.78145 0-13.302981 9.591449-13.302981 16.372899s6.52153 16.372899 13.302981 16.372899l316.279387 0c6.78145 0 13.302981-9.591449 13.302981-16.372899S599.385744 360.557846 592.604294 360.557846z"  ></path>' +
    '' +
    '<path d="M954.963159 631.071909c0-100.501972-61.927421-185.051623-155.792229-217.440287C788.049638 221.874273 628.991016 69.774133 434.464601 69.774133c-201.734584 0-365.334639 163.580612-365.334639 365.334639 0 144.397714 84.065628 269.202185 205.51263 328.509942 45.756113 69.307506-3.442402 129.047098-44.090171 162.702616 0 0-10.285251 8.848529-5.249561 18.876929 6.65149 13.243629 16.969487 10.021238 16.969487 10.021238 173.365466-2.346441 212.890668-114.774023 229.881644-156.940378 25.882484-2.611477 50.966789-7.933693 74.966389-15.678074 33.799804 38.110993 85.830831 64.065108 146.860812 68.301596l2.046612 4.756327c28.136827 72.538083 81.34875 100.168374 150.333914 100.168374 0 0 7.251148 0 12.879332-11.140735 3.611248-7.148817-3.678786-16.489556-3.678786-16.489556-27.258831-22.942525-52.755528-56.55404-28.309766-91.625814l-0.11154 0.436952C905.115867 798.298562 954.963159 720.910007 954.963159 631.071909zM458.89399 766.981299c-15.626909 1.186012-15.626909 13.465686-15.626909 13.465686-18.283412 56.880475-58.07058 124.5599-160.14742 139.681296 0 0 85.446068-82.887802 14.326287-181.125197l-5.074575-2.739391c-112.858394-53.267181-190.95303-168.004365-190.95303-301.209156C101.418342 251.132644 250.560104 102.008278 434.464601 102.008278c183.906543 0 333.046259 149.124366 333.046259 333.046259C767.51086 610.829889 631.279129 753.896282 458.89399 766.981299zM806.089503 811.385625l-3.162016 2.830465c-40.901549 56.281841 0 103.826694 0 103.826694-48.064692-12.752442-70.464865-49.615001-79.275531-83.872223 0 0-2.742461-7.433296-4.604878-9.209756-2.124384-2.02717-10.740622-4.756327-10.740622-4.756327-51.215452-3.554966-92.929506-18.993586-127.576607-50.345642 125.154441-54.625108 213.748199-177.515996 218.813564-321.694723 72.392774 30.319539 123.036197 104.510262 123.036197 182.357258C922.580634 706.047508 874.880239 781.182742 806.089503 811.385625z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-bell" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M915.130182 946.385455 102.656 946.385455c-8.308364 0-16.011636-4.421818-20.154182-11.659636-4.165818-7.214545-4.142545-16.058182 0.023273-23.272727L173.149091 754.967273 173.149091 413.579636c0-159.115636 113.966545-296.936727 268.241455-328.564364L441.390545 75.822545c0-38.679273 31.464727-70.144 70.120727-70.144s70.120727 31.464727 70.120727 70.144L581.632 86.109091c153.576727 33.675636 263.028364 168.354909 263.028364 327.470545l0 341.410909 90.624 156.462545c4.189091 7.214545 4.189091 16.058182 0.023273 23.272727C931.141818 941.963636 923.461818 946.385455 915.130182 946.385455zM143.034182 899.84l731.717818 0-75.776-130.839273c-3.863273-6.679273-4.165818-14.801455-0.861091-21.690182l0-333.730909c0-142.801455-102.353455-262.749091-243.409455-285.230545-11.287273-1.792-19.618909-11.543273-19.618909-22.970182l0-29.556364c0-13.009455-10.565818-23.598545-23.575273-23.598545-13.009455 0-23.575273 10.589091-23.575273 23.598545l0 28.741818c0 11.589818-8.517818 21.410909-19.991273 23.04C326.4 147.735273 219.694545 270.661818 219.694545 413.579636l0 336.314182c2.397091 6.283636 2.513455 13.242182-0.884364 19.106909L143.034182 899.84z"  ></path>' +
    '' +
    '<path d="M506.205091 1018.298182c-38.656 0-70.120727-31.464727-70.120727-70.144 0-12.869818 10.426182-23.272727 23.272727-23.272727s23.272727 10.402909 23.272727 23.272727c0 13.009455 10.565818 23.598545 23.575273 23.598545 13.009455 0 23.598545-10.589091 23.598545-23.598545 0-12.869818 10.402909-23.272727 23.272727-23.272727s23.272727 10.402909 23.272727 23.272727C576.349091 986.833455 544.884364 1018.298182 506.205091 1018.298182z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-oslash" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M752 1024l-480 0q-16 0-31-6t-25-18q-12-12-18-27t-6-31l0-860q0-16 6-31t18-27q10-12 25-18t31-6l480 0q16 0 31 6t25 18q12 12 18 27t6 31l0 860q0 16-6 31t-18 27q-10 12-25 18t-31 6l0 0 0 0zM272 82l0 860 480 0 0-860-480 0zM792 164l-560 0 0-122 560 0 0 122zM234 780l0 166 560 0 0-166-560 0zM512 940q-16 0-28-12t-12-30q0-16 12-28t28-12 28 12 12 28q0 18-12 30t-28 12l0 0 0 0z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-feedback" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M555.916667 511.645833c63.875-42.6875 106.229167-116.8125 106.229167-200.9375 0-132-104.25-239.375-232.375-239.375-128.104167 0-232.341667 107.375-232.341667 239.375 0 84.125 42.341667 158.25 106.216667 200.9375C133.979167 566.916667 10.666667 730.645833 10.666667 923.454167c0 16.145833 12.6875 29.208333 28.354167 29.208333s28.354167-13.0625 28.354167-29.208333c0-205.875 162.5625-373.395833 362.395833-373.395833 199.854167 0 362.416667 167.520833 362.416667 373.395833 0 16.145833 12.708333 29.208333 28.354167 29.208333 15.666667 0 28.354167-13.0625 28.354167-29.208333C848.891667 730.645833 725.583333 566.916667 555.916667 511.645833zM254.133333 310.708333c0-99.770833 78.779167-180.958333 175.633333-180.958333s175.666667 81.1875 175.666667 180.958333S526.625 491.666667 429.770833 491.666667C332.9375 491.666667 254.133333 410.479167 254.133333 310.708333zM852.725 210.979167c-88.708333 0-160.625 74.104167-160.625 165.458333 0 22.583333 4.395833 44.083333 12.333333 63.6875l-60.854167 48.25 83.4375-8.916667c29.416667 38.041667 74.791667 62.4375 125.708333 62.4375 88.6875 0 160.604167-74.0625 160.604167-165.458333C1013.329167 285.083333 941.4125 210.979167 852.725 210.979167zM772.958333 346.375c13.708333 0 24.8125 11.416667 24.8125 25.5625 0 14.104167-11.104167 25.5625-24.8125 25.5625s-24.8125-11.458333-24.8125-25.5625C748.145833 357.791667 759.25 346.375 772.958333 346.375zM852.725 397.5c-13.729167 0-24.833333-11.458333-24.833333-25.5625 0-14.145833 11.104167-25.5625 24.833333-25.5625 13.6875 0 24.8125 11.416667 24.8125 25.5625C877.5375 386.041667 866.4125 397.5 852.725 397.5zM932.475 397.5c-13.708333 0-24.8125-11.458333-24.8125-25.5625 0-14.145833 11.104167-25.5625 24.8125-25.5625s24.791667 11.416667 24.791667 25.5625C957.266667 386.041667 946.183333 397.5 932.475 397.5z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-feedback1" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M906.666667 650.666667l-164.266667 0-115.2 115.2c-4.266667 6.4-10.666667 12.8-19.2 12.8 0 0 0 0 0 0-6.4 0-10.666667-2.133333-14.933333-6.4-4.266667-4.266667-6.4-10.666667-6.4-17.066667l0-104.533333-64 0c-23.466667 0-42.666667-19.2-42.666667-42.666667l0-256c0-23.466667 19.2-42.666667 42.666667-42.666667l384 0c23.466667 0 42.666667 19.2 42.666667 42.666667l0 256C949.333333 631.466667 930.133333 650.666667 906.666667 650.666667zM906.666667 352l-384 0 0 256 85.333333 0c12.8 0 21.333333 8.533333 21.333333 21.333333l0 76.8 93.866667-93.866667c4.266667-4.266667 10.666667-6.4 17.066667-6.4l166.4 0L906.666667 352zM842.666667 501.333333l-42.666667 0 0-42.666667 42.666667 0L842.666667 501.333333zM693.333333 458.666667l42.666667 0 0 42.666667-42.666667 0L693.333333 458.666667zM586.666667 458.666667l42.666667 0 0 42.666667-42.666667 0L586.666667 458.666667zM394.666667 672l-192 0c-12.8 0-21.333333-8.533333-21.333333-21.333333s8.533333-21.333333 21.333333-21.333333l192 0c12.8 0 21.333333 8.533333 21.333333 21.333333S407.466667 672 394.666667 672zM394.666667 373.333333l-192 0c-12.8 0-21.333333-8.533333-21.333333-21.333333s8.533333-21.333333 21.333333-21.333333l192 0c12.8 0 21.333333 8.533333 21.333333 21.333333S407.466667 373.333333 394.666667 373.333333zM394.666667 522.666667l-192 0c-12.8 0-21.333333-8.533333-21.333333-21.333333s8.533333-21.333333 21.333333-21.333333l192 0c12.8 0 21.333333 8.533333 21.333333 21.333333S407.466667 522.666667 394.666667 522.666667zM714.666667 266.666667c-12.8 0-21.333333-8.533333-21.333333-21.333333l0 0 0-106.666667-576 0 0 746.666667 576 0 0-85.333333 0 0c0-12.8 8.533333-21.333333 21.333333-21.333333s21.333333 8.533333 21.333333 21.333333l0 0 0 85.333333c0 23.466667-19.2 42.666667-42.666667 42.666667l-576 0c-23.466667 0-42.666667-19.2-42.666667-42.666667l0-746.666667c0-23.466667 19.2-42.666667 42.666667-42.666667l576 0c23.466667 0 42.666667 19.2 42.666667 42.666667l0 106.666667 0 0C736 258.133333 727.466667 266.666667 714.666667 266.666667z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-feedback2" viewBox="0 0 1038 1024">' +
    '' +
    '<path d="M511.978511 48.613184c-281.513582 0-509.726214 186.739055-509.726214 417.047418 0 112.976074 55.116295 215.292368 144.290267 290.388716l-51.611471 219.337497 274.04754-109.600187c45.415352 10.81737 93.314269 16.924461 142.999878 16.924461 281.520745 0 509.726214-186.689936 509.726214-417.050488C1021.704724 235.352239 793.498232 48.613184 511.978511 48.613184zM511.978511 836.374762c-44.164872 0-88.651063-5.272074-132.225487-15.683191-3.555989-0.835018-7.172353-1.266853-10.774391-1.266853-5.855358 0-11.717879 1.110287-17.192567 3.326768l-191.33063 76.520791 31.18321-132.612297c4.027733-17.016559-1.899256-34.798551-15.254425-46.044686C93.981465 651.220808 48.591695 560.647977 48.591695 465.660602c0-204.403367 207.894887-370.70802 463.386816-370.70802 255.517511 0 463.386816 166.30363 463.386816 370.70802C975.365326 670.071132 767.496022 836.374762 511.978511 836.374762z"  ></path>' +
    '' +
    '<path d="M279.470039 418.102447c-30.861892 0-55.888891 25.027-55.888891 55.891961 0 30.869055 25.027 55.891961 55.888891 55.891961 30.869055 0 55.895031-25.022906 55.895031-55.891961C335.36507 443.129446 310.338071 418.102447 279.470039 418.102447z"  ></path>' +
    '' +
    '<path d="M511.978511 473.995431m-55.891961 0a54.619 54.619 0 1 0 111.783923 0 54.619 54.619 0 1 0-111.783923 0Z"  ></path>' +
    '' +
    '<path d="M744.486982 473.995431m-55.891961 0a54.619 54.619 0 1 0 111.783923 0 54.619 54.619 0 1 0-111.783923 0Z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-signin" viewBox="0 0 1229 1024">' +
    '' +
    '<path d="M947.200039 512.000024C947.200039 525.866664 942.133362 537.866708 932.000008 548.000014L496.799993 983.20003C486.666687 993.333384 474.66669 998.400013 460.800002 998.400013 446.933363 998.400013 434.933318 993.333384 424.800012 983.20003 414.666658 973.066676 409.600029 961.066679 409.600029 947.200039L409.600029 716.800014 51.200022 716.800014C37.333334 716.800014 25.333337 711.733337 15.199983 701.600031 5.066677 691.466677 0 679.46668 0 665.600041L0 358.400007C0 344.533368 5.066677 332.533323 15.199983 322.400017 25.333337 312.266663 37.333334 307.200033 51.200022 307.200033L409.600029 307.200033 409.600029 76.800008C409.600029 62.933321 414.666658 50.933324 424.800012 40.800018 434.933318 30.666664 446.933363 25.599987 460.800002 25.599987 474.66669 25.599987 486.666687 30.666664 496.799993 40.800018L932.000008 476.000033C942.133362 486.13334 947.200039 498.133336 947.200039 512.000024ZM1228.800038 230.400025 1228.800038 793.600023C1228.800038 857.066691 1206.266713 911.333374 1161.200015 956.400024 1116.133364 1001.466675 1061.866681 1024.000048 998.400013 1024.000048L742.400001 1024.000048C735.466681 1024.000048 729.466683 1021.466685 724.400006 1016.400008 719.333329 1011.333379 716.800014 1005.333381 716.800014 998.400013 716.800014 996.266673 716.533365 990.933346 716.000018 982.400033 715.466671 973.866672 715.333346 966.800028 715.599996 961.200004 715.866693 955.600028 716.66669 949.33338 718.000033 942.400012 719.333329 935.466692 722.000016 930.26669 725.999999 926.800007 730.00003 923.333371 735.466681 921.600005 742.400001 921.600005L998.400013 921.600005C1033.600007 921.600005 1063.733372 909.066709 1088.800012 884.000021 1113.866699 858.933381 1126.400043 828.800017 1126.400043 793.600023L1126.400043 230.400025C1126.400043 195.200031 1113.866699 165.066667 1088.800012 140.000027 1063.733372 114.933339 1033.600007 102.399995 998.400013 102.399995L768.000036 102.399995C767.466689 102.399995 764.533352 102.399995 759.200025 102.399995 753.866699 102.399995 750.400015 102.399995 748.800022 102.399995 747.200029 102.399995 744.133367 102.133346 739.600037 101.599999 735.066659 101.066652 731.999998 100.266655 730.400004 99.200009 728.800011 98.133363 726.666671 96.666694 724.000032 94.800004 721.333344 92.933361 719.466702 90.533323 718.400008 87.599986 717.333361 84.666697 716.800014 81.066689 716.800014 76.800008 716.800014 74.666668 716.533365 69.333342 716.000018 60.800029 715.466671 52.266668 715.333346 45.200023 715.599996 39.599999 715.866693 34.000023 716.66669 27.733327 718.000033 20.800007 719.333329 13.866687 722.000016 8.666686 725.999999 5.200002 730.00003 1.733318 735.466681 0 742.400001 0L998.400013 0C1061.866681 0 1116.133364 22.533325 1161.200015 67.600024 1206.266713 112.666674 1228.800038 166.933357 1228.800038 230.400025ZM1228.800038 230.400025"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-cart" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M830.013662 130.380533h-59.385348c-13.5716 0-24.573248 11.001648-24.573248 24.573248s11.001648 24.573248 24.573248 24.573248h59.385348c9.032716 0 16.382165 7.349449 16.382166 16.382165v757.504152c0 9.032716-7.349449 16.382165-16.382166 16.382165H192.918425c-9.032716 0-16.382165-7.349449-16.382165-16.382165V195.909194c0-9.032716 7.349449-16.382165 16.382165-16.382165h60.710257c13.5716 0 24.573248-11.001648 24.573247-24.573248s-11.001648-24.573248-24.573247-24.573248h-60.710257c-36.132913 0-65.528661 29.395748-65.528661 65.528661v757.504152c0 36.132913 29.395748 65.528661 65.528661 65.52866h637.095237c36.132913 0 65.528661-29.395748 65.528661-65.52866V195.909194c0-36.132913-29.395748-65.528661-65.528661-65.528661z" fill="" ></path>' +
    '' +
    '<path d="M328.066169 179.527029h368.612027c13.5716 0 24.573248-11.001648 24.573248-24.573248s-11.001648-24.573248-24.573248-24.573248h-51.538292c-6.729998-71.774361-64.563137-128.037884-134.685971-128.037883-70.12181 0-127.954949 56.263522-134.684947 128.037883h-47.702817c-13.5716 0-24.573248 11.001648-24.573248 24.573248s11.001648 24.573248 24.573248 24.573248zM510.453933 51.488121c43.109668 0 78.928248 34.287872 85.217976 78.891388H425.236981c6.289728-44.602493 42.108308-78.891388 85.216952-78.891388zM258.789064 366.242757c0 13.5716 11.001648 24.573248 24.573247 24.573248h455.294159c13.5716 0 24.573248-11.001648 24.573248-24.573248s-11.001648-24.573248-24.573248-24.573248H283.362311c-13.5716 0-24.573248 11.001648-24.573247 24.573248zM738.65647 554.636633H283.362311c-13.5716 0-24.573248 11.001648-24.573247 24.573247s11.001648 24.573248 24.573247 24.573248h455.294159c13.5716 0 24.573248-11.001648 24.573248-24.573248s-11.001648-24.573248-24.573248-24.573247zM738.65647 767.60478H283.362311c-13.5716 0-24.573248 11.001648-24.573247 24.573248s11.001648 24.573248 24.573247 24.573248h455.294159c13.5716 0 24.573248-11.001648 24.573248-24.573248s-11.001648-24.573248-24.573248-24.573248z" fill="" ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon--xianxing" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M957.6 572.8l-120.8-181.6c-3.2-4.8-8-7.2-13.6-7.2H704V224c0-17.6-14.4-32-32-32H96c-17.6 0-32 14.4-32 32v448c0 17.6 14.4 32 32 32h32c0 70.4 57.6 128 128 128s128-57.6 128-128h256c0 70.4 57.6 128 128 128s128-57.6 128-128h32c17.6 0 32-14.4 32-32V581.6c0-3.2-0.8-6.4-2.4-8.8zM256 768c-35.2 0-64-28.8-64-64s28.8-64 64-64 64 28.8 64 64-28.8 64-64 64z m384-128H366.4c-22.4-38.4-63.2-64-110.4-64s-88.8 25.6-110.4 64H128V256h512v384z m128 128c-35.2 0-64-28.8-64-64s28.8-64 64-64 64 28.8 64 64-28.8 64-64 64z m128-128h-17.6c-22.4-38.4-63.2-64-110.4-64-23.2 0-44.8 6.4-64 17.6V448h95.2c5.6 0 10.4 2.4 12.8 7.2l80.8 116.8c1.6 2.4 3.2 5.6 3.2 8.8V640z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-refresh" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M830.6 659.2c-50.9 123.8-172.7 211-314.9 211-186.8 0-338.4-150.5-340.4-336.8l-67.8 87.4-31.6-24.5 110.3-142.2 142.2 110.3-24.5 31.6-88.7-68.8v2.6c0 40.6 7.9 79.9 23.6 116.9 15.1 35.8 36.8 67.9 64.4 95.5 27.6 27.6 59.7 49.3 95.5 64.4 37 15.7 76.3 23.6 116.9 23.6 40.6 0 79.9-7.9 116.9-23.6 35.8-15.1 67.9-36.8 95.5-64.4 24.4-24.4 44.1-52.2 58.8-83h43.8zM237.1 364.8c14.7-30.8 34.4-58.7 58.8-83 27.6-27.6 59.7-49.3 95.5-64.4 37-15.7 76.3-23.6 116.9-23.6 40.6 0 79.9 7.9 116.9 23.6 35.8 15.1 67.9 36.8 95.5 64.4 27.6 27.6 49.3 59.7 64.4 95.5 15.7 37 23.6 76.3 23.6 116.9v2.6L720.1 428l-24.5 31.6 142.2 110.3 110.3-142.2-31.6-24.5-67.8 87.4c-1.9-186.4-153.6-336.8-340.4-336.8-142.2 0-264 87.2-314.9 211h43.7z" fill="" ></path>' +
    '' +
    '</symbol>' +
    '' +
    '</svg>'
  var script = function() {
    var scripts = document.getElementsByTagName('script')
    return scripts[scripts.length - 1]
  }()
  var shouldInjectCss = script.getAttribute("data-injectcss")

  /**
   * document ready
   */
  var ready = function(fn) {
    if (document.addEventListener) {
      if (~["complete", "loaded", "interactive"].indexOf(document.readyState)) {
        setTimeout(fn, 0)
      } else {
        var loadFn = function() {
          document.removeEventListener("DOMContentLoaded", loadFn, false)
          fn()
        }
        document.addEventListener("DOMContentLoaded", loadFn, false)
      }
    } else if (document.attachEvent) {
      IEContentLoaded(window, fn)
    }

    function IEContentLoaded(w, fn) {
      var d = w.document,
        done = false,
        // only fire once
        init = function() {
          if (!done) {
            done = true
            fn()
          }
        }
        // polling for no errors
      var polling = function() {
        try {
          // throws errors until after ondocumentready
          d.documentElement.doScroll('left')
        } catch (e) {
          setTimeout(polling, 50)
          return
        }
        // no errors, fire

        init()
      };

      polling()
        // trying to always fire before onload
      d.onreadystatechange = function() {
        if (d.readyState == 'complete') {
          d.onreadystatechange = null
          init()
        }
      }
    }
  }

  /**
   * Insert el before target
   *
   * @param {Element} el
   * @param {Element} target
   */

  var before = function(el, target) {
    target.parentNode.insertBefore(el, target)
  }

  /**
   * Prepend el to target
   *
   * @param {Element} el
   * @param {Element} target
   */

  var prepend = function(el, target) {
    if (target.firstChild) {
      before(el, target.firstChild)
    } else {
      target.appendChild(el)
    }
  }

  function appendSvg() {
    var div, svg

    div = document.createElement('div')
    div.innerHTML = svgSprite
    svgSprite = null
    svg = div.getElementsByTagName('svg')[0]
    if (svg) {
      svg.setAttribute('aria-hidden', 'true')
      svg.style.position = 'absolute'
      svg.style.width = 0
      svg.style.height = 0
      svg.style.overflow = 'hidden'
      prepend(svg, document.body)
    }
  }

  if (shouldInjectCss && !window.__iconfont__svg__cssinject__) {
    window.__iconfont__svg__cssinject__ = true
    try {
      document.write("<style>.svgfont {display: inline-block;width: 1em;height: 1em;fill: currentColor;vertical-align: -0.1em;font-size:16px;}</style>");
    } catch (e) {
      console && console.log(e)
    }
  }

  ready(appendSvg)


})(window)