﻿using System.Reflection;
using System.Text;
using Abp.Dependency;
using Abp.IO.Extensions;

namespace YoYoCms.AbpProjectTemplate.Emailing
{
    public class EmailTemplateProvider : IEmailTemplateProvider, ITransientDependency
    {
        public string GetDefaultTemplate()
        {
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream("YoYoCms.AbpProjectTemplate.Emailing.EmailTemplates.default.html"))
            {
                var bytes = stream.GetAllBytes();
                return Encoding.UTF8.GetString(bytes, 3, bytes.Length - 3);
            }
        }
    }
}