<!-- hide -->
# React Interactive Tutorial & Exercises

<a href="https://www.4geeksacademy.co"><img height="280" align="right" src="https://github.com/4GeeksAcademy/react-tutorial-exercises/blob/master/badge.svg?raw=true"></a>

> By [@alesanchezr](https://twitter.com/alesanchezr) and [other contributors](https://github.com/4GeeksAcademy/react-tutorial-exercises/graphs/contributors) at [4Geeks Academy](https://4geeksacademy.co/)

![last commit](https://img.shields.io/github/last-commit/4geeksacademy/react-tutorial-exercises)
[![build by developers](https://img.shields.io/badge/build_by-Developers-blue)](https://breatheco.de)
[![build by developers](https://img.shields.io/twitter/follow/4geeksacademy?style=social&logo=twitter)](https://twitter.com/4geeksacademy)

*Estas instrucciones [están disponibles en 🇪🇸 español](https://github.com/4GeeksAcademy/react-tutorial-exercises/blob/master/README.es.md) :es:*
<!-- endhide -->

You can find lots of free interactive/autograded tutorials online, but there are very few about React.js. That's why we decided to create a comprehensive selection of exercises for developers who are interested in learning React.js.

These exercises can be done by both junior and senior developers and are intended to be built through collaboration. We need your help!

If you find any bugs or spelling issues, please contribute and report them, and we will correct them.

<!-- hide -->
## One click installation (recommended):

You can open these exercises in just a few seconds by clicking: [Open in Codespaces](https://codespaces.new/?repo=4GeeksAcademy/react-tutorial-exercises) (recommended) or [Open in Gitpod](https://gitpod.io#https://github.com/4GeeksAcademy/react-tutorial-exercises.git).

> Once you have VSCode open, the LearnPack exercises should start automatically. If exercises don't run automatically, you can try typing on your terminal: `$ learnpack start`

## Local installation:

Clone the repository in your local environment and follow the steps below:

1. Make sure you have [installed learnpack locally](https://4geeks.com/docs/learnpack/quickstart-for-learners#how-to-use-learnpack-locally).
2. Download the React exercises by **cloning** the project or downloading the zip from GitHub.

> Note: Once you finish downloading, make sure you are in the right folder (you will find the subdirectory "exercises").

3) Start the tutorial/exercises by running the following command from the root of the project:

```bash
$ npm i @learnpack/learnpack -g
$ learnpack start
```

<!-- endhide -->

## How are the exercises organized?

Each exercise is a small React application containing the following files:

1. **app.js:** represents the entry file for the exercise.
2. **README.md:** contains exercise instructions.
3. **test.js:** you don't have to open this file, it contains the testing script for the exercise.

> Note: The exercises have automatic grading, but it's very rigid and strict, my recommendation is to not take the tests too serious and use them only as a suggestion, or you may get frustrated.

## Contributors

Thanks goes to these wonderful people ([emoji key](https://github.com/kentcdodds/all-contributors#emoji-key)):

1. [Alejandro Sanchez (alesanchezr)](https://github.com/alesanchezr), contribution: (coder) 💻, (idea) 🤔, (build-tests) ⚠️, (pull-request-review) 👀, (build-tutorial) ✅, (documentation) 📖

2. [Paolo (plucodev)](https://github.com/plucodev), contribution: (bug reports) 🐛, (coder) 💻, (translation) 🌎

3. [Marco Gómez (marcogonzalo)](https://github.com/marcogonzalo), contribution: (bug reports) 🐛, (translation) 🌎


This project follows the [all-contributors](https://github.com/kentcdodds/all-contributors) specification. Contributions of any kind are welcome!

This and many other exercises are built by students as part of the 4Geeks Academy [Coding Bootcamp](https://4geeksacademy.com/us/coding-bootcamp) by [Alejandro Sánchez](https://twitter.com/alesanchezr) and many other contributors. Find out more about our [Full Stack Developer Course](https://4geeksacademy.com/us/coding-bootcamps/part-time-full-stack-developer), and  [Data Science Bootcamp](https://4geeksacademy.com/us/coding-bootcamps/datascience-machine-learning).
