---
tutorial: "https://www.youtube.com/watch?v=kS4qpQmHwCs"
---

# `06` String Concatenation

String concatenation is a common task in programming that involves combining or linking two or more strings together.

You can think of this process as similar to connecting two or more train cars. If each string is a train car, concatenation is the coupling that joins them to form a single train.

In Python, you can concatenate, or join together, two or more strings using the `+` operator. This is how it works:

```py
one = 'a'
two = 'b'
print(one + two)  # This will print 'ab' on the console.
```

Here, the variables `one` and `two` hold the individual strings `'a'` and `'b'`. When you use the `+` operator between them, it acts like a glue, sticking the strings together end-to-end. In this case, it joins `'a'` and `'b'`, resulting in the concatenated string `'ab'`, which gets printed to the console.

## 📝 Instructions: 
1. Set the values for `my_var1` and `my_var2` so that, when concatenated, the code prints `Hello World` in the console.

## 💡 Hint:
+ If you need further explanation on how string **concatenation** works in Python, you can watch this clip: https://www.youtube.com/watch?v=28FUVmWU_fA&ab_channel=PortfolioCourses (`ctrl + click` on the link to open the video)
