<!-- hide -->
<img height="280" align="right" src="https://github.com/4GeeksAcademy/python-beginner-programming-exercises/blob/master/.learn/assets/badge-python-bg.png?raw=true">


# 🐍 Python Beginner Tutorial and Exercises
By [@alesanchezr](https://twitter.com/alesanchezr) and [other contributors](https://github.com/4GeeksAcademy/python-beginner-programming-exercises/graphs/contributors) at [4Geeks Academy](http://4geeksacademy.com)
<img align="left" src="https://img.shields.io/github/last-commit/4geeksacademy/python-beginner-programming-exercises">


*Estas instrucciones [están disponibles en 🇪🇸 español](https://github.com/4GeeksAcademy/python-beginner-programming-exercises/blob/master/README.es.md) :es:*
<!-- endhide -->

These exercises are the ideal first step for anyone trying to learn Python. We start with the most simple challenge, like printing a message on the terminal and slowly increase step by step.

This particular series is for Python beginners. You will learn:

1. The `print` function.

2. Data-Types. 

3. Lists and Tuples. 

4. Functions and dictionaries.

The entire tutorial is 👆 interactive, ✅ auto-graded, and has 📹 video tutorials.

These exercises were built in collaboration, we need you! If you find any bugs or misspellings please contribute and report them.

<!-- hide -->

## One click installation (recommended):

You can open these exercises in just a few seconds by clicking: [Open in Codespaces](https://codespaces.new/?repo=4GeeksAcademy/python-beginner-programming-exercises) (recommended) or [Open in Gitpod](https://gitpod.io#https://github.com/4GeeksAcademy/python-beginner-programming-exercises).

> Once you have VSCode open, the LearnPack exercises should start automatically. If exercises don't run automatically, you can try typing on your terminal: `$ learnpack start`

## Local Installation

1. Make sure you have [LearnPack](https://learnpack.co) installed, node.js version 14+, and Python version 3+. This is the command to install LearnPack:

```bash
$ npm i @learnpack/learnpack@2.1.20 -g && learnpack plugins:install @learnpack/python@1.0.0
```

2. Clone or download this repository in your local environment.

```bash
$ git clone https://github.com/4GeeksAcademy/python-beginner-programming-exercises.git
$ cd python-beginner-programming-exercises
```

> Note: Once you finish downloading, you will find an "exercises" folder that contains all the exercises within.

3. Start the tutorial/exercises by running the following command at the same level where your learn.json file is:

```bash
$ pip3 install pytest==6.2.5 pytest-testdox mock
$ learnpack start
```

<!-- endhide -->

## How are the exercises organized?

Each exercise is a small Python application containing the following files:

1. **app.py:** represents the entry Python file that will be executed by the computer.
2. **README.md:** contains exercise instructions.
3. **test.py:** you don't have to open this file, it contains the testing script for the exercise.

> Note: The exercises have automatic grading, but it's very rigid and strict, my recommendation is to not take the tests too serious and use them only as a suggestion, or you may get frustrated.

## Contributors

Thanks goes to these wonderful people ([emoji key](https://github.com/kentcdodds/all-contributors#emoji-key)):

1. [Alejandro Sanchez (alesanchezr)](https://github.com/alesanchezr), contribution: (coder) 💻, (idea) 🤔, (build-tests) ⚠️, (pull-request-review) 👀, (build-tutorial) ✅, (documentation) 📖

2. [Paolo (plucodev)](https://github.com/plucodev), contribution: (bug reports) 🐛, (coder) 💻, (translation) 🌎

This project follows the [all-contributors](https://github.com/kentcdodds/all-contributors) specification. Contributions of any kind are welcome!

This and many other exercises are built by students as part of the 4Geeks Academy [Coding Bootcamp](https://4geeksacademy.com/us/coding-bootcamp) by [Alejandro Sánchez](https://twitter.com/alesanchezr) and many other contributors. Find out more about our [Full Stack Developer Course](https://4geeksacademy.com/us/coding-bootcamps/part-time-full-stack-developer), and  [Data Science Bootcamp](https://4geeksacademy.com/us/coding-bootcamps/datascience-machine-learning).
