<!-- hide -->
# 🐍 Tutorial y Ejercicios para Principiantes de Python

Por <a href="https://twitter.com/alesanchezr">@alesanchezr</a> y <a href="https://github.com/4GeeksAcademy/python-beginner-programming-exercises/graphs/contributors">otros colaboradores</a> en <a href="http://4geeksacademy.co/">4Geeks Academy</a><a href="https://www.4geeksacademy.com"><img height="280" align="right" src="https://github.com/4GeeksAcademy/python-beginner-programming-exercises/blob/master/.learn/assets/badge-python-bg.png?raw=true"></a>
<!-- endhide -->

Esta serie en particular es para principiantes de Python. Aprenderás los siguientes conceptos:

1. La función `print`.

2. Tipos de datos. 

3. Listas y tuplas.

4. Funciones y diccionarios.

Todo el tutorial es 👆 interactivo, ✅ calificado automáticamente, y con 📹 video tutoriales.


¡Te necesitamos! Estos ejercicios se crean y mantienen con colaboradores como tú. Si encuentras algún error o falta de ortografía, contribuye y/o infórmanos.

<!-- hide -->

## Instalación en un clic (recomendado)

Puedes empezar estos ejercicios en pocos segundos haciendo clic en: [Abrir en Codespaces](https://codespaces.new/?repo=4GeeksAcademy/python-beginner-programming-exercises) (recomendado) o [Abrir en Gitpod](https://gitpod.io#https://github.com/4GeeksAcademy/python-beginner-programming-exercises).

> Una vez ya tengas abierto VSCode, los ejercicios de LearnPack deberían empezar automáticamente, si esto no sucede puedes intentar empezar los ejercicios escribiendo este comando en tu terminal: `$ learnpack start`

## Instalación local:

1. Asegúrate de instalar [LearnPack](https://learnpack.co), node.js version 14+ y Python version 3+. Este es el comando para instalar LearnPack:

```bash
$ npm i @learnpack/learnpack@2.1.20 -g && learnpack plugins:install @learnpack/python@1.0.0
```

2. Clona o descarga este repositorio en tu ambiente local.

```bash
$ git clone https://github.com/4GeeksAcademy/python-beginner-programming-exercises.git
$ cd python-beginner-programming-exercises
```

> Nota: Una vez que termine de descargar, encontrarás la carpeta "exercises" que contiene todos los ejercicios.

3. Inicializa el tutorial ejecutando el siguiente comando al mismo nivel en el que se encuentra tu archivo learn.json: 

```bash
$ pip3 install pytest==6.2.5 pytest-testdox mock
$ learnpack start
```

<!-- endhide -->


## ¿Cómo están organizados los ejercicios?

Cada ejercicio es una pequeña aplicación de Python que contiene los siguientes archivos:

1. **app.py:** representa el archivo de entrada de Python que será ejecutado por el computador.
2. **README.es.md:** Contiene las instrucciones del ejercicio.
3. **test.py:** Contiene el script del test para el ejercicio (no es necesario que abras este archivo).

> Nota: Estos ejercicios tienen calificación automática. Los tests son muy rígidos y estrictos, mi recomendación es que no prestes demasiada atención a los tests y los uses solo como una sugerencia o podrías frustrarte.

## Colaboradores
 
Gracias a estas personas maravillosas ([emoji key](https://github.com/kentcdodds/all-contributors#emoji-key)):

1. [Alejandro Sanchez (alesanchezr)](https://github.com/alesanchezr), contribución: (programador) 💻 (idea) 🤔, (build-tests) ⚠️, (pull-request-review) 👀, (build-tutorial) ✅, (documentación) 📖

2. [Paolo (plucodev)](https://github.com/plucodev), contribución: (bug reports) 🐛, (programador) 💻, (traducción) 🌎

Este proyecto sigue la especificación [all-contributors](https://github.com/kentcdodds/all-contributors). ¡Todas las contribuciones son bienvenidas!

Este y otros ejercicios son usados para [aprender a programar](https://4geeksacademy.com/es/aprender-a-programar/aprender-a-programar-desde-cero) por parte de los alumnos de 4Geeks Academy [Coding Bootcamp](https://4geeksacademy.com/us/coding-bootcamp) realizado por [Alejandro Sánchez](https://twitter.com/alesanchezr) y muchos otros contribuyentes. Conoce más sobre nuestros [Cursos de Programación](https://4geeksacademy.com/es/curso-de-programacion-desde-cero?lang=es) para convertirte en [Full Stack Developer](https://4geeksacademy.com/es/coding-bootcamps/desarrollador-full-stack/?lang=es), o nuestro [Data Science Bootcamp](https://4geeksacademy.com/es/coding-bootcamps/curso-datascience-machine-learning).
