/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : eyoucms_develop

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2018-09-13 14:30:27
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for #@__weapp_verify
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_verify`;
CREATE TABLE `#@__weapp_verify` (
  `verify_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '核销记录ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `store_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '核销门店ID',
  `admin_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '后台核销-管理人员ID',
  `staff_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '前台核销-核销职员ID',
  `verify_code` varchar(50) NOT NULL DEFAULT '' COMMENT '核销记录编号',
  `verify_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '核销时间',
  `verify_status` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '是否完成核销(1:是; 2:否;)',
  `buyer` varchar(50) NOT NULL DEFAULT '' COMMENT '买家姓名',
  `phone` varchar(50) NOT NULL DEFAULT '' COMMENT '买家手机',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`verify_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `store_id` (`store_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='核销记录表';

-- ----------------------------
-- Table structure for #@__weapp_verify_staff
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_verify_staff`;
CREATE TABLE `#@__weapp_verify_staff` (
  `staff_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '核销职员ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `store_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '提货点ID',
  `staff_name` varchar(50) NOT NULL DEFAULT '' COMMENT '核销职员姓名',
  `staff_phone` varchar(50) NOT NULL DEFAULT '' COMMENT '核销职员手机',
  `staff_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '职员是否开启核销(1:是; 2:否;)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`staff_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `store_id` (`store_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='核销人员表';

-- ----------------------------
-- Table structure for #@__weapp_verify_store
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_verify_store`;
CREATE TABLE `#@__weapp_verify_store` (
  `store_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '核销门店ID',
  `store_name` varchar(50) NOT NULL DEFAULT '' COMMENT '核销门店名称',
  `store_phone` varchar(50) NOT NULL DEFAULT '' COMMENT '核销门店手机',
  `store_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否开启门店(1:是; 2:否;)',
  `store_province` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '门店地址(省)',
  `store_city` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '门店地址(市/区)',
  `store_area` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '门店地址(县/镇)',
  `store_address` varchar(255) NOT NULL DEFAULT '' COMMENT '门店地址(详细地址)',
  `store_logo` varchar(255) NOT NULL DEFAULT '' COMMENT '门店LOGO',
  `store_business` varchar(255) NOT NULL DEFAULT '' COMMENT '门店营业时间',
  `store_coverpic` varchar(255) NOT NULL DEFAULT '' COMMENT '门店封面图片',
  `store_latitude` varchar(255) NOT NULL DEFAULT '' COMMENT '门店纬度',
  `store_longitude` varchar(255) NOT NULL DEFAULT '' COMMENT '门店经度',
  `store_intro` varchar(255) NOT NULL DEFAULT '' COMMENT '核销门店介绍',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='核销门店表';