<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace weapp\Seckill\model;

use think\Db;
use think\Model;

/**
 * 秒杀商品规格模型
 */
load_trait('controller/Jump');

class SeckillProductSpecValue extends Model
{
    use \traits\controller\Jump;

    // 数据表名
    public $name = 'weapp_seckill_product_spec_value';

    // 初始化
    protected function initialize()
    {
        // 需要调用`Model`的`initialize`方法
        parent::initialize();
    }

    public function setGoodsSpec($post = [])
    {
        // 数据判断
        if (empty($post['aid']) || empty($post['goods_id'])) $this->error('请选择商品');
        $goodsSpecSet = !empty($post['goodsSpecSet']) ? $post['goodsSpecSet'] : [];
        $pointsSpecKeys = !empty($goodsSpecSet['pointsSpecKeys']) ? $goodsSpecSet['pointsSpecKeys'] : [];
        empty($pointsSpecKeys) && $this->error('商品没有规格值');

        $where = [
            'aid' => $post['aid']
        ];
        $field = 'spec_value_id, spec_price, spec_stock, spec_sales_num';
        $goodsSpec = Db::name('product_spec_value')->where($where)->order('spec_price asc')->field($field)->getAllWithIndex('spec_value_id');

        // 处理规格数据
        $delAll = $saveAll = [];
        foreach ($pointsSpecKeys as $key => $value) {
            $goodsSpecValue = !empty($goodsSpecSet[$value]) ? $goodsSpecSet[$value] : [];
//            if (!empty($goodsSpecValue['is_join'])) {
                $seckill_stock = !empty($goodsSpecValue['seckill_stock']) ? intval($goodsSpecValue['seckill_stock']) : 0;
                $seckill_price = !empty($goodsSpecValue['seckill_price']) ? floatval($goodsSpecValue['seckill_price']) : 0;
//                if (empty($seckill_stock)) $this->error('请设置秒杀库存');
                if (empty($seckill_price)) $this->error('请设置秒杀价格');
                $max_stock = $goodsSpec[$value]['spec_stock'];
                if ($max_stock < $seckill_stock) $seckill_stock = $max_stock;
                $data = [
                    'aid' => intval($post['aid']),
                    'goods_id' => intval($post['goods_id']),
                    'spec_value_id' => strval($value),
                    'is_join' => 1,
                    'seckill_price' => $seckill_price,
                    'seckill_stock' => $seckill_stock,
                    'update_time' => getTime(),
                ];
                if (!empty($goodsSpecValue['value_id'])) {
                    $data['value_id'] = intval($goodsSpecValue['value_id']);
                } else {
                    $data['add_time'] = getTime();
                }
                $saveAll[$key] = $data;
//            } else {
//                $delAll[] = [
//                    'aid' => intval($post['aid']),
//                    'goods_id' => intval($post['goods_id']),
//                    'spec_value_id' => strval($value),
//                ];
//            }
        }

        // 保存规格数据
        $result1 = $result2 = false;
        // 保存数据
        if (!empty($saveAll)) $result1 = $this->saveAll($saveAll);
        // 删除数据
        if (!empty($delAll)) {
            $where = [
                'aid' => ['IN', array_unique(get_arr_column($delAll, 'aid'))],
                'goods_id' => ['IN', array_unique(get_arr_column($delAll, 'goods_id'))],
                'spec_value_id' => ['IN', array_unique(get_arr_column($delAll, 'spec_value_id'))],
            ];
            $result2 = $this->where($where)->delete();
        }
        // 返回提示
        $count = $this->where($where)->count();
        if (!empty($result1) || !empty($result2)) {
            $this->success('保存成功', null, ['count'=>$count]);
        } else {
            $this->error('保存失败');
        }
    }
}