DROP TABLE IF EXISTS `#@__weapp_seckill`;
CREATE TABLE `#@__weapp_seckill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `activity_title` varchar(100) DEFAULT '' COMMENT '秒杀活动标题',
  `start_time` int(11) DEFAULT '0' COMMENT '活动开始时间',
  `end_time` int(11) DEFAULT '0' COMMENT '活动结束时间',
  `total_order` int(11) DEFAULT '0' COMMENT '成交订单',
  `total_money` decimal(8,2) DEFAULT '0.00' COMMENT ' \r\n成交金额',
  `status` tinyint(3) DEFAULT '1' COMMENT '状态(1=进行中，2-未开始 3-手动停止 4-已结束)',
  `stop_time` int(11) DEFAULT '0' COMMENT '停止时间 status=3使用',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `activity_channel` varchar(100) DEFAULT '' COMMENT '活动渠道：微信小程序(weixin)；电脑端(pc)；抖音小程序(douyin)；H5(h5)',
  `is_distribution` tinyint(1) DEFAULT '0' COMMENT '参与分销 0-不参与 1-参与',
  `is_limit` tinyint(2) DEFAULT '0' COMMENT '限购次数 0-不限制 1-活动期内每人最多购买 2-动期内每人每天最多购买',
  `limit` int(11) DEFAULT '0' COMMENT '限购',
  `in_progress` tinyint(1) DEFAULT '0' COMMENT '活动开启 0-否,1-是,永远只能存在一个开启',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@__weapp_seckill_archives`;
CREATE TABLE `#@__weapp_seckill_archives` (
  `goods_id` int(11) NOT NULL AUTO_INCREMENT,
  `act_id` int(11) DEFAULT '0' COMMENT '秒杀抢购ID',
  `aid` int(11) DEFAULT '0' COMMENT '产品id',
  `total_order` int(11) DEFAULT '0' COMMENT '成交订单',
  `total_money` decimal(8,2) DEFAULT '0.00' COMMENT ' \r\n成交金额',
  `refund_money` decimal(8,0) DEFAULT '0' COMMENT '退款金额',
  `buy_count` int(11) DEFAULT '0' COMMENT '销售数量',
  `buy_users_count` int(11) DEFAULT '0' COMMENT ' \r\n成交人数',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `seckill_price` decimal(10,2) DEFAULT '0.00' COMMENT '单规格 价格',
  `seckill_stock` int(11) DEFAULT '0' COMMENT '单规格 库存',
  `temporary_add` tinyint(1) DEFAULT '1' COMMENT '1-临时添加,未确认提交 ,0-正式商品',
  `is_spec` tinyint(1) DEFAULT '0' COMMENT '是否是多规格 0-否 1-是',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '原商品 价格',
  `stock` int(11) DEFAULT '0' COMMENT '原商品 库存',
  PRIMARY KEY (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@__weapp_seckill_product_spec_value`;
CREATE TABLE `#@__weapp_seckill_product_spec_value` (
  `value_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `act_id` int(11) DEFAULT '0' COMMENT '秒杀抢购ID',
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `goods_id` int(11) DEFAULT '0',
  `spec_value_id` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值ID',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `seckill_stock` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀库存(独立库存，与spec_stock/限时折扣库存不同步)',
  `seckill_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀销售量',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `is_join` tinyint(1) DEFAULT '0' COMMENT '是否参与秒杀 0-否 1-是',
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='秒杀产品多规格组装表';
