<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-06-28
 */

namespace weapp\Querykd\controller;

use think\Page;
use think\Db;
use app\common\controller\Weapp;
use weapp\Querykd\model\QuerykdModel;

/**
 * 插件的控制器
 */
class Querykd extends Weapp
{
    /**
     * 实例化模型
     */
    private $model;

    /**
     * 实例化对象
     */
    private $db;

    /**
     * 插件基本信息
     */
    private $weappInfo;

    /**
     * 构造方法
     */
    public function __construct(){
        parent::__construct();
        $this->model = new QuerykdModel;
        $this->db = Db::name('WeappQuerykd');

        /*插件基本信息*/
        $this->weappInfo = $this->getWeappInfo();
        $this->assign('weappInfo', $this->weappInfo);
        /*--end*/
    }

    /**
     * 插件使用指南
     */
    public function doc(){
        return $this->fetch('doc');
    }

    /**
     * 插件后台管理 - 列表
     */
    public function index()
    {
        if (IS_POST) {
            $post = input('post.');
            if (1 === intval($post['openQuerykd'])) {
                if (empty($post['apikey'])) $this->error("请填写授权key");
                if (empty($post['customer'])) $this->error("请填写customer");
            }
            $post['apikey'] = trim($post['apikey']);
            $post['customer'] = trim($post['customer']);
            $post['openQuerykd'] = intval($post['openQuerykd']);
            $data = array(
                'data' => serialize($post),
                'update_time' => getTime(),
            );
            $r = M('weapp')->where('code','Querykd')->update($data);
            if ($r !== false) {
                \think\Cache::clear('hooks');
                adminLog('编辑'.$this->weappInfo['name'].'：插件配置'); // 写入操作日志
                $this->success("操作成功", weapp_url('Querykd/Querykd/index'));
            }
            $this->error("操作失败");
        }

        $row = $this->model->getWeappData();
        $this->assign('row', $row);

        return $this->fetch('index');
    }
}