<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace weapp\PointsShop\model;

use think\Db;
use think\Model;

/**
 * 积分商品规格模型
 */
load_trait('controller/Jump');

class PointsGoodsSpec extends Model
{
    use \traits\controller\Jump;

    // 数据表名
    public $name = 'weapp_points_goods_spec';

    // 初始化
    protected function initialize()
    {
        // 需要调用`Model`的`initialize`方法
        parent::initialize();
        // 当前时间戳
        $this->times = getTime();
    }

    public function setGoodsSpec($post = [])
    {
        // 数据判断
        if (empty($post['aid']) || empty($post['goods_id'])) $this->error('请选择商品');
        $goodsSpecSet = !empty($post['goodsSpecSet']) ? $post['goodsSpecSet'] : [];
        $pointsSpecKeys = !empty($goodsSpecSet['pointsSpecKeys']) ? $goodsSpecSet['pointsSpecKeys'] : [];
        empty($pointsSpecKeys) && $this->error('商品没有规格值');

        // 处理规格数据
        $delAll = $saveAll = [];
        foreach ($pointsSpecKeys as $key => $value) {
            $goodsSpecValue = !empty($goodsSpecSet[$value]) ? $goodsSpecSet[$value] : [];
            if (!empty($goodsSpecValue['specJoin'])) {
                $specStock = !empty($goodsSpecValue['specStock']) ? intval($goodsSpecValue['specStock']) : 0;
                $specPrice = !empty($goodsSpecValue['specPrice']) ? floatval($goodsSpecValue['specPrice']) : 0;
                $specPoints = !empty($goodsSpecValue['specPoints']) ? intval($goodsSpecValue['specPoints']) : 0;
                if (empty($specStock)) $this->error('请设置商品库存');
                if (empty($specPoints)) $this->error('请设置商品购买所需积分');
                $saveAll[$key] = [
                    'spec_id' => 0,
                    'aid' => intval($post['aid']),
                    'goods_id' => intval($post['goods_id']),
                    'spec_keys' => strval($value),
                    'spec_join' => intval($goodsSpecValue['specJoin']),
                    'spec_stock' => $specStock,
                    'spec_price' => $specPrice,
                    'spec_points' => $specPoints,
                    'add_time' => $this->times,
                    'update_time' => $this->times,
                ];
                if (!empty($goodsSpecValue['specID'])) {
                    unset($saveAll[$key]['add_time']);
                    $saveAll[$key]['spec_id'] = intval($goodsSpecValue['specID']);
                } else {
                    unset($saveAll[$key]['spec_id']);
                }
            } else {
                $delAll[] = [
                    'aid' => intval($post['aid']),
                    'goods_id' => intval($post['goods_id']),
                    'spec_keys' => strval($value),
                ];
            }
        }

        // 保存规格数据
        $result = false;
        // 保存数据
        if (!empty($saveAll)) $result = $this->saveAll($saveAll);
        // 删除数据
        if (!empty($delAll)) {
            $where = [
                'aid' => ['IN', array_unique(get_arr_column($delAll, 'aid'))],
                'goods_id' => ['IN', array_unique(get_arr_column($delAll, 'goods_id'))],
                'spec_keys' => ['IN', array_unique(get_arr_column($delAll, 'spec_keys'))],
            ];
            $result = $this->where($where)->delete(true);
        }
        // 返回提示
        $count = $this->where($where)->count();
        if (!empty($result)) {
            $this->success('保存成功', null, ['count'=>$count]);
        } else {
            $this->error('保存失败');
        }
    }
}