/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : eyoucms_develop

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2018-09-13 14:30:27
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for #@__weapp_points_goods
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_points_goods`;
CREATE TABLE `#@__weapp_points_goods` (
  `goods_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '积分商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '系统文档主表ID(archives 表 aid 字段)',
  `goods_spec` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商品是否有规格(0:无; 1:有;)',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '商品购买所需价格',
  `goods_points` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品购买所需积分',
  `goods_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品库存量',
  `goods_cookie` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品操作者记录cookie值(时间戳)',
  `goods_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品上下架状态(1:上架; 2:下架;)',
  `goods_shipping` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品运费设置(1:读取系统设置; 2:包邮;)',
  `goods_save` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '积分商品是否为手动保存(0:否; 1:是;)',
  `goods_passive` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '系统商品变动时，积分商品自动下架，需重新编辑积分商品上架(1:编辑上架; 2:自动下架;)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`goods_id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='积分商城--积分商品';

-- ----------------------------
-- Table structure for #@__weapp_points_goods_spec
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_points_goods_spec`;
CREATE TABLE `#@__weapp_points_goods_spec` (
  `spec_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '积分商品规格ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '系统文档主表ID(archives 表 aid 字段)',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '积分商品ID(weapp_points_goods 表 goods_id 字段)',
  `spec_keys` varchar(20) NOT NULL DEFAULT '' COMMENT '系统商品规格价格表规格值ID(product_spec_value 表 spec_value_id 字段)',
  `spec_join` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '系统商品规格是否参与积分商品购买(0:否; 1:是)',
  `spec_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '积分商品库存',
  `spec_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '购买积分商品所需金额',
  `spec_points` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '购买积分商品所需积分',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`spec_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='积分商城--积分商品规格';