// 结束日期
if (document.getElementById('add_time_end')) $.selectYY_MM_DD("#add_time_end");
// 起始日期
if (document.getElementById('add_time_begin')) $.selectYY_MM_DD("#add_time_begin");

// 订单操作
function orderMarkStatus(status_name, order_id, users_id, admin_note, update_time) {
    var content = '';
    if ('yfk' == status_name) {
        content = '确认订单已付款？';
    } else if ('ysh' == status_name) {
        content = '确认订单已收货？';
    } else if ('gbdd' == status_name) {
        content = '确认关闭订单？';
    } else if ('ddsc' == status_name) {
        content = '确认删除订单？';
    }

    // 提示确认
    layer.open({content: content, btn: ['确定', '取消'],
        yes: function(index) {
            // 提示处理
            layerLoading();
            // 提交处理
            $.ajax({
                url : orderMarkStatusUrl,
                data: {
                    _ajax: 1,
                    weappAjax: 1,
                    order_id: order_id,
                    users_id: users_id,
                    status_name: status_name,
                },
                type: 'post',
                dataType: 'json',
                success: function(res) {
                    layer.closeAll();
                    if (1 == res.code) {
                        if (!res.data.email && !res.data.mobile && !res.data.weChat) {
                            layerMsg(res.msg, 1.5, function() {
                                window.location.reload();
                            });
                        } else {
                            if (res.data.email) unifySendEmail(res.data.email);
                            if (res.data.mobile) unifySendMobile(res.data.mobile);
                            if (res.data.weChat) unifySendWeChat(res.data.weChat);
                            layerMsg('发货成功', 1.5, function() {
                                window.location.reload();
                            });
                        }
                    } else {
                        layerMsg(res.msg, 1.5);
                    }
                }
            });
        }
    });
}

// 弹出改价输入框
function promptChangePrice(orderID, orderAmount) {
    var content = '<div id="changePriceDiv" style="display: inline-block;"> <span style="color: red;">应付金额：</span><input type="text" id="changePrice" placeholder="请输入应付金额" value="'+orderAmount+'" onkeyup="this.value=this.value.replace(/[^\\d.]/g, \'\');" onpaste="this.value=this.value.replace(/[^\\d.]/g, \'\')" style="height: 25px; line-height: 25px;"> </div>';
    content += '<div>改价后让用户重新进入订单列表点击支付</div>';
    layer.open({
        anim: 'up',
        content: content,
        btn: ['确定', '关闭'],
        title: ['订单改价'],
        success: function(layero, index) {
            $('#changePriceDiv #changePrice').focus();
        },
        yes: function(index) {
            var changePrice = $('#changePriceDiv #changePrice').val();
            layer.close(index);
            orderChangePrice(orderID, orderAmount, changePrice);
        }
    });
}

// 提交改价数据并追加一条订单操作记录
function orderChangePrice(orderID, orderAmount, changePrice) {
    if (0 >= changePrice) layerMsg('应付金额不允许为0', 1.5);
    layerLoading();
    $.ajax({
        type: 'post',
        url : orderChangePriceUrl,
        data: {
            _ajax: 1,
            weappAjax: 1,
            order_id: orderID,
            order_amount: changePrice,
            order_amount_old: orderAmount,
        },
        dataType: 'json',
        success: function(res) {
            layer.closeAll();
            if (1 == res.code) {
                layerMsg(res.msg, 1.5, function() {
                    window.location.reload();
                });
            } else {
                layerAlert(res.msg, '确认', function() {
                    window.location.reload();
                });
            }
        }
    });
}

// 弹出手动退款确认框
function promptManualRefund(orderID) {
    var content = '';
    content += '<div id="manualRefundDiv"> <textarea id="refundNote" placeholder="请填写手动退款原因(非必填)" style="width: 100%; height: 60px;"></textarea> </div>';
    layer.open({
        anim: 'up',
        content: content,
        btn: ['确定', '取消'],
        title: ['手动退款'],
        success: function(layero, index) {
            $('#manualRefundDiv #refundNote').focus();
        },
        yes: function(index) {
            var refundNote = $('#manualRefundDiv #refundNote').val();
            layer.close(index);
            orderManualRefund(orderID, refundNote);
        }
    });
}

// 手动关闭订单并退款
function orderManualRefund(orderID, refundNote) {
    layerLoading();
    $.ajax({
        url : orderManualRefundUrl,
        data: {
            _ajax: 1,
            weappAjax: 1,
            order_id: orderID,
            refund_note: refundNote
        },
        type: 'post',
        dataType: 'json',
        success: function(res) {
            layer.closeAll();
            if (1 == res.code) {
                layerMsg(res.msg, 1.5, function() {
                    window.location.reload();
                });
            } else {
                layerAlert(res.msg, '确认', function() {
                    window.location.reload();
                });
            }
        }
    });
}

// 订单发货
function orderSend(obj) {
    window.location.href = $(obj).data('href');
    // var content = '';
    // $.ajax({
    //     url : "",
    //     data: {
    //         _ajax: 1,
    //         weappAjax: 1,
    //         order_id: orderID,
    //     },
    //     type: 'post',
    //     dataType: 'json',
    //     success: function(res) {
    //         if (1 == res.code) {
    //             var pageii = layer.open({
    //                 type: 1,
    //                 anim: 'up',
    //                 content: res.data,
    //                 style: 'width: 100%; height: 50%;'
    //             });
    //         } else {
    //             layerAlert(res.msg, '确认', function() {
    //                 window.location.reload();
    //             });
    //         }
    //     }
    // });
}

// 弹出订单核销提示框
function orderVerify(orderID, usersID, openVerify, openSecondVerify) {
    // 是否开启核销功能
    if (0 === parseInt(openVerify)) {
        layerAlert('已关闭核销功能，核销订单将无法操作');
        return false;
    }
    // 提示文案
    var content = '<div>核销后用户的核销凭证将失效，确认核销此单？</div>';
    if (1 === parseInt(openSecondVerify)) {
        content += '<div style="color: red;"></div>';
        content += '<div id="orderVerifyDiv"  style="display: inline-block;"> <span style="color: red;">请输入核销码：</span><input type="text" id="verifyCode" placeholder="请输入核销码验证" onkeyup="this.value=this.value.replace(/[^\\d.]/g, \'\');" onpaste="this.value=this.value.replace(/[^\\d.]/g, \'\');" style="height: 25px; line-height: 25px;"> </div>';
    }
    // 确认执行核销
    layer.open({
        anim: 'up',
        content: content,
        btn: ['确认', '取消'],
        title: ['确认核销'],
        success: function(layero, index) {
            if (1 === parseInt(openSecondVerify)) $('#orderVerifyDiv #verifyCode').focus();
        },
        yes: function(index) {
            var verifyCode = 1 === parseInt(openSecondVerify) ? $('#orderVerifyDiv #verifyCode').val() : '';
            if ('' == verifyCode && 1 === parseInt(openSecondVerify)) {
                $('#orderVerifyDiv #verifyCode').focus();
                return false;
            }
            layer.close(index);
            orderVerifyConfirm(orderID, usersID, verifyCode);
        }
    });
}

// 订单核销确认执行
function orderVerifyConfirm(orderID, usersID, verifyCode) {
    layerLoading();
    $.ajax({
        url : verifyUrl,
        data: {
            _ajax: 1,
            weappAjax: 1,
            order_id: orderID,
            users_id: usersID,
            verify_code: verifyCode
        },
        type: 'post',
        dataType: 'json',
        success: function(res) {
            layer.closeAll();
            if (1 == res.code) {
                layerMsg(res.msg, 1.5, function() {
                    window.location.reload();
                });
            } else {
                layerAlert(res.msg, '确认', function() {
                    window.location.reload();
                });
            }
        }
    });
}

// 订单备注
function orderRemarks(orderID) {
    if (parseInt(orderID) > 0) {
        var remarks = '';
        $.ajax({
            url : weappOrderRemarksUrl,
            data: {
                _ajax: 1,
                order_id: orderID,
            },
            type: 'post',
            dataType: 'json',
            success: function(res) {
                if (1 == res.code) {
                    var content = '<div id="orderRemarksDiv"> <textarea id="orderRemarks" style="width: 100%; height: 100px;"  placeholder="请输入订单备注">'+res.data+'</textarea> </div>';
                    layer.open({
                        anim: 'up',
                        content: content,
                        btn: ['确认', '取消'],
                        title: ['订单备注'],
                        success: function(layero, index) {
                            $('#orderRemarksDiv #orderRemarks').focus();
                        },
                        yes: function(index) {
                            var orderRemarks = $('#orderRemarksDiv #orderRemarks').val();
                            layer.close(index);
                            orderRemarksConfirm(orderID, orderRemarks);
                        }
                    });
                }
            }
        });
    } else {
        layerAlert('请选择需要备注的订单', '确认', function() {
            window.location.reload();
        });
    }
}

// 订单备注确认执行
function orderRemarksConfirm(orderID, orderRemarks) {
    layerLoading();
    $.ajax({
        url : orderRemarksUrl,
        data: {
            _ajax: 1,
            weappAjax: 1,
            order_id: orderID,
            order_remarks: orderRemarks
        },
        type: 'post',
        dataType: 'json',
        success: function(res) {
            layer.closeAll();
            if (1 == res.code) {
                layerMsg(res.msg, 1.5);
            } else {
                layerAlert(res.msg, '确认', function() {
                    window.location.reload();
                });
            }
        }
    });
}

// 商品状态更新
function goodsArcrank(aid, arcrank) {
    // 获取post提交的aid数组
    var aids = getPostAids(aid);
    if (false == aids) {
        showErrorAlert('请至少选择一项');
        return false;
    }

    // 执行提交
    var title = 1 === parseInt(arcrank) ? '上架' : '下架';
    showConfirm('确定' + title + '该商品？', {}, function() {
        layer_loading('正在处理');
        $.ajax({
            type: 'post',
            url : "{:url('ShopProduct/goods_arcrank')}",
            data: {aids: aids, arcrank: arcrank, _ajax: 1},
            dataType: 'json',
            success: function(res) {
                layer.closeAll();
                if (1 === parseInt(res.code)) {
                    showSuccessMsg(res.msg, 1500, function() {
                        window.location.reload();
                    });
                } else {
                    showErrorAlert(res.msg);
                }
            },
            error: function(e) {
                layer.closeAll();
                showErrorAlert(e.responseText);
            }
        });
    });
}