!(function (doc, win) {
    var docEle = doc.documentElement,
        evt = "onorientationchange" in window ? "orientationchange" : "resize",
        fn = function () {
            var width = docEle.clientWidth;
            width && (docEle.style.fontSize = 14 * (width / 375) + "px");
        };
 
    win.addEventListener(evt, fn, false);
    doc.addEventListener("DOMContentLoaded", fn, false);
}(document, window));

// 以下为筛选所需JS
function unifiedSwitch(obj, name, value) {
    $('#' + name).val(value);
    $(obj).addClass('on').siblings().removeClass('on');
}

function openFilter() {
    $('#openFilter').show();
    if ($('#keywords')) $('#keywords').focus();
}

function closeFilter() {
    $('#openFilter').hide();
}

function submitFilter() {
    $('#formFilter').submit();
}
// --------- end

// 复制信息
function textCopy(name) {
    var clipboard1 = new Clipboard("." + name);
    clipboard1.on("success", function(e) {
        layerMsg('复制成功', 1);
    });
    clipboard1.on("error", function(e) {
        layerMsg('复制失败！请手动复制', 1);
    });
}

// 普通提示
function layerMsg(content, time, callback) {
    time = time || 2;
    layer.open({
        content: content, time: time, skin: 'msg',
        end: function(elem) {
            if (typeof callback !== 'undefined') callback();
        }
    });
}

// 弹框提示
function layerAlert(content, btn, callback) {
    var btn = btn || '确认';
    layer.open({
        content: content, btn: btn,
        end: function(elem) {
            if (typeof callback !== 'undefined') callback();
        }
    });
}

// 加载动画
var loading;
function layerLoading(content) {
    var content = content || '正在处理';
    loading = layer.open({
        content: content, type: 2, shadeClose: false
    });
}

// 跳转指定页面
function unifiedJump(obj) {
    var url = $(obj).data('url') ? $(obj).data('url') : '';
    if (!url) {
        layerAlert('请添加 data-url 链接属性', '确定');
        return false;
    }
    window.location.href = url;
}

function checkTitleRepeat(obj, aid) {
    var title = $(obj).val();
    if (title) {
        $.ajax({
            type: "POST",
            url : checkTitleRepeatUrl,
            data: {title: title, aid: aid, _ajax: 1, weappAjax: 1},
            dataType: 'json',
            success: function (data) {
                if (0 === parseInt(data.code)) {
                    layer.tips(data.msg, '#title',{
                        tips: [2, '#F5F5F5'],
                        area: ['300px', 'auto'],
                        time: 0
                    });
                } else {
                    layer.closeAll();
                }
            }
        });
    } else {
        layer.closeAll();
    }
}

/*----------------------------------后台消息通知统一方法 start--------------------*/
function unifySendEmail(send_id) {
    if (send_id) {
        $.ajax({
            url : __root_dir__ + 'index.php?m=api&c=Ajax&a=sendEamilContent&_ajax=1',
            data: {send_id: send_id},
            type: 'post',
            dataType: 'json'
        });
    }
}

function unifySendMobile(send_id) {
    if (send_id) {
        $.ajax({
            url : __root_dir__ + 'index.php?m=api&c=Ajax&a=sendMobileContent&_ajax=1',
            data: {send_id: send_id},
            type: 'post',
            dataType: 'json'
        });
    }
}

function unifySendWeChat(send_id) {
    if (send_id) {
        $.ajax({
            url : __root_dir__ + 'index.php?m=api&c=Ajax&a=sendWeChatContent&_ajax=1',
            data: {send_id: send_id},
            type: 'post',
            dataType: 'json'
        });
    }
}
/*----------------------------------后台消息通知统一方法 end--------------------*/