<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-06-28
 */

namespace weapp\Mbackend\controller;

use think\Page;
use think\Db;
use app\common\controller\Weapp;
use weapp\Mbackend\model\MbackendModel;
use weapp\Mbackend\logic\MbackendLogic;

/**
 * 插件的控制器
 */
class ShopProduct extends Weapp
{
    /**
     * 构造方法
     */
    public function __construct()
    {
        parent::__construct();
        $this->mbackendLogic = new MbackendLogic;
    }

    // 内容管理
    public function index()
    {
        // 沿用系统原有订单列表逻辑
        $display = action('admin/ShopProduct/index');
        $fetch = $this->fetch($display);
        $fetch = trim($fetch);
        if (!empty($fetch)) {
            return $this->fetch($display);
        } else {
            return false;
        }
    }

    public function add()
    {
        // 删除缓存文件
        $virtual_id = input('virtual_id/d', 0);
        if (!empty($virtual_id)) $this->mbackendLogic->fileCacheHandle('del');
        $this->assign('virtual_id', $virtual_id);

        // 沿用系统原有订单详情逻辑
        $display = action('admin/ShopProduct/add');
        return $this->fetch($display);
    }

    // 内容发布详情
    public function edit()
    {
        $aid = input('id/d', 0);
        if (!empty($aid)) {
            // 删除缓存文件
            $this->mbackendLogic->fileCacheHandle('del');
            // 查询文档内容
            $article = Db::name('product_content')->field('id, aid, content, content_ey_m')->where('aid', $aid)->find();
            // 添加缓存文件
            !empty($article) && $this->mbackendLogic->fileCacheHandle('put', $article);
        }

        // 沿用系统原有订单详情逻辑
        $display = action('admin/ShopProduct/edit');
        return $this->fetch($display);
    }

    public function openContent()
    {
        $aid = input('post.aid/d', 0);
        if (IS_AJAX_POST && !empty($aid)) {
            // 获取缓存文件
            $article = $this->mbackendLogic->fileCacheHandle('get');
            if (empty($article)) {
                // 查询文档内容
                $article = Db::name('product_content')->field('id, aid, content, content_ey_m')->where('aid', $aid)->find();
                // 添加缓存文件
                !empty($article) && $this->mbackendLogic->fileCacheHandle('put', $article);
            }
            $article['content'] = !empty($article['content_ey_m']) ? htmlspecialchars_decode($article['content_ey_m']) : htmlspecialchars_decode($article['content']);
            $this->success('查询成功', null, $article);
        } else {
            $this->error('非法操作');
        }
    }

    public function saveContent()
    {
        $post = input('post.');
        if (IS_AJAX_POST && !empty($post['aid'])) {
            // 添加缓存文件
            $this->mbackendLogic->fileCacheHandle('put', $post);
            // 返回结束
            $this->success('操作成功');
        } else {
            $this->error('非法操作');
        }
    }

    public function goods_quick_edit()
    {
        if (IS_AJAX_POST) {
            $post = input('post.');
            if (empty($post['aid']) || !isset($post['openSpec'])) $this->error('数据异常，刷新重试');
            // 更新商品表数据
            $where = [
                'aid' => intval($post['aid']),
            ];
            if (!empty($post['openSpec'])){
                $post['stock_count'] = 0;
                foreach ($post['spec_stock'] as $k => $v){
                    $post['stock_count'] += intval($v['stock_count']);
                }
            }
            $update = [
                'stock_count' => empty($post['stock_count']) ? 0 : intval($post['stock_count']),
                'update_time' => getTime(),
            ];
            $update = array_merge($post, $update);
            $result = Db::name('archives')->where($where)->update($update);
            // 后续处理
            if (!empty($result)) {
                // 已开启规格的商品处理
                if (1 === intval($update['openSpec'])) {
                    foreach ($post['spec_stock'] as $k => $v){
                        Db::name('product_spec_value')->where(['aid'=>$post['aid'],'spec_value_id'=>$k])->update(['spec_stock'=>$v['stock_count'],'update_time'=>getTime()]);
                    }
                }
                // 系统商品操作时，积分商品的被动处理
                model('ShopPublicHandle')->pointsGoodsPassiveHandle([$update['aid']]);
                // 成功返回结束
                $this->success("操作成功");
            }
            // 失败返回结束
            $this->error("操作失败");
        }

        // 沿用系统原有订单详情逻辑
        $display = action('admin/ShopProduct/goods_quick_edit');
        return $this->fetch($display);
    }


}