<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-06-28
 */

namespace weapp\Mbackend\controller;

use think\Db;
use think\Page;
use think\Config;
use app\common\controller\Weapp;
use weapp\Mbackend\model\MbackendModel;

/**
 * 插件的控制器
 */
class Shop extends Weapp
{
    // 构造方法
    public function __construct()
    {
        parent::__construct();
        // 订单主表
        $this->shop_order_db = Db::name('shop_order');
        // 订单明细表
        $this->shop_order_details_db = Db::name('shop_order_details');
    }

    // 订单列表
    public function index()
    {   
        // 沿用系统原有订单列表逻辑
        $display = action('admin/Shop/index');

        // 获取当前页面完整URL
        $requestUrl = $_SERVER['REQUEST_URI'] ? $_SERVER['REQUEST_URI'] : '';
        $this->assign('requestUrl', $requestUrl);

        $fetch = $this->fetch($display);
        $fetch = trim($fetch);
        if (!empty($fetch)) {
            return $this->fetch($display);
        } else {
            return false;
        }
    }

    // 订单详情
    public function order_details()
    {
        // 沿用系统原有订单详情逻辑
        $display = action('admin/Shop/order_details');
        return $this->fetch($display);
    }

    // 订单发货
    public function order_send()
    {
        if (IS_AJAX_POST) {
            // 沿用系统原有订单发货逻辑
            $display = action('admin/Shop/order_send');
            $this->success('加载成功', null, $this->fetch($display));
        } else {
            // 沿用系统原有订单发货逻辑
            $display = action('admin/Shop/order_send');
            return $this->fetch($display);
        }
    }

    // 订单备注
    public function order_remarks()
    {
        $order_id = input('param.order_id/d', 0);
        $where = [
            'order_id' => intval($order_id)
        ];
        $remarksList = $this->shop_order_db->where($where)->getField('admin_note');
        $remarksList = !empty($remarksList) ? unserialize($remarksList) : [];
        krsort($remarksList);
        $remarks = !empty($remarksList[count($remarksList)-1]['remarks']) ? $remarksList[count($remarksList)-1]['remarks'] : '';
        $this->success('查询成功', null, $remarks);
    }

    // 订单主动退款
    public function order_active_refund()
    {
        if (IS_AJAX_POST) {
            // 沿用系统原有订单发货逻辑
            $display = action('admin/Shop/order_active_refund');
            $this->success('加载成功', null, $this->fetch($display));
        } else {
            // 沿用系统原有订单发货逻辑
            $display = action('admin/Shop/order_active_refund');
            return $this->fetch($display);
        }
    }
    
    // 售后订单列表
    public function after_service()
    {
        // 获取当前页面完整URL
        $requestUrl = $_SERVER['REQUEST_URI'] ? $_SERVER['REQUEST_URI'] : '';
        $this->assign('requestUrl', $requestUrl);
        
        // 沿用系统原有售后订单列表逻辑
        $display = action('admin/ShopService/after_service');
        $fetch = $this->fetch($display);
        if (!empty(trim($fetch))) {
            return $this->fetch($display);
        } else {
            return false;
        }
    }

    // 售后订单详情
    public function after_service_details()
    {
        // 沿用系统原有售后订单详情逻辑
        $display = action('admin/ShopService/after_service_details');
        return $this->fetch($display);
    }

    public function after_service_refund()
    {
        // 沿用系统原有售后订单详情逻辑
        $display = action('admin/ShopService/after_service_refund');
        return $this->fetch($display);
    }

    public function after_service_resend()
    {
        // 沿用系统原有售后订单详情逻辑
        $display = action('admin/ShopService/after_service_resend');
        return $this->fetch($display);
    }

    // 修改地址
    public function address_update()
    {

        return $this->fetch('shop/address_update');
    }
}