<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-06-28
 */

namespace weapp\Mbackend\controller;

use think\Page;
use think\Db;
use app\common\controller\Weapp;
use weapp\Mbackend\model\MbackendModel;

/**
 * 插件的控制器
 */
class Product extends Weapp
{
    /**
     * 构造方法
     */
    public function __construct(){
        parent::__construct();
    }
    
    // 内容管理
    public function index()
    {
        // 沿用系统原有订单列表逻辑
        $display = action('admin/Product/index');
        $fetch = $this->fetch($display);
        if (!empty(trim($fetch))) {
            return $this->fetch($display);
        } else {
            return false;
        }
    }
    
    public function add()
    {
        // 删除缓存文件
        $virtual_id = input('virtual_id/d', 0);
        if (!empty($virtual_id)) $this->mbackendLogic->fileCacheHandle('del');
        $this->assign('virtual_id', $virtual_id);
    
        // 沿用系统原有订单详情逻辑
        $display = action('admin/Product/add');
        return $this->fetch($display);
    }
    
    // 内容发布详情
    public function edit()
    {
        $aid = input('id/d', 0);
        if (!empty($aid)) {
            // 删除缓存文件
            $this->mbackendLogic->fileCacheHandle('del');
            // 查询文档内容
            $article = Db::name('article_content')->field('id, aid, content, content_ey_m')->where('aid', $aid)->find();
            // 添加缓存文件
            !empty($article) && $this->mbackendLogic->fileCacheHandle('put', $article);
        }
    
        // 沿用系统原有订单详情逻辑
        $display = action('admin/Product/edit');
        return $this->fetch($display);
    }
    
    public function openContent()
    {
        $aid = input('post.aid/d', 0);
        if (IS_AJAX_POST && !empty($aid)) {
            // 获取缓存文件
            $article = $this->mbackendLogic->fileCacheHandle('get');
            if (empty($article)) {
                // 查询文档内容
                $article = Db::name('article_content')->field('id, aid, content, content_ey_m')->where('aid', $aid)->find();
                // 添加缓存文件
                !empty($article) && $this->mbackendLogic->fileCacheHandle('put', $article);
            }
            $article['content'] = !empty($article['content_ey_m']) ? htmlspecialchars_decode($article['content_ey_m']) : htmlspecialchars_decode($article['content']);
            $this->success('查询成功', null, $article);
        } else {
            $this->error('非法操作');
        }
    }
    
    public function saveContent()
    {
        $post = input('post.');
        if (IS_AJAX_POST && !empty($post['aid'])) {
            // 添加缓存文件
            $this->mbackendLogic->fileCacheHandle('put', $post);
            // 返回结束
            $this->success('操作成功');
        } else {
            $this->error('非法操作');
        }
    }
}