<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-06-28
 */

namespace weapp\Mbackend\controller;

use think\Page;
use think\Db;
use app\common\controller\Weapp;

/**
 * 插件的控制器
 */
class Mbackend extends Weapp
{
    /**
     * 构造方法
     */
    public function __construct()
    {
        parent::__construct();
        // 查询插件信息
        $this->weappInfo = $this->getWeappInfo();
        $this->assign('weappInfo', $this->weappInfo);

        // 处理插件配置
        $this->data = Db::name('weapp')->where('code', 'Mbackend')->getField('data');
        if (!empty($this->data)) {
            $this->data = unserialize($this->data);
        } else {
            $this->data = [];
            $this->saveConfig(['status'=>1], false);
        }
        $this->assign('data', $this->data);
    }

    /**
     * 后台欢迎页
     */
    public function index()
    {
        // 管理员信息
        $admin_info = getAdminInfo(session('admin_id'));
        $this->assign('admin_info', $admin_info);
        // 商城中心开关
        $this->assign('shop_open', getUsersConfigData('shop.shop_open'));
        // 会员中心开关
        $this->assign('web_users_switch', tpCache('web.web_users_switch'));

        //统计
        $count = $this->ajax_change_time();
        //待付款
        $count['wait_pay_count'] = Db::name('shop_order')->where('order_status',0)->count('order_id');
        //待发货
        $count['send_goods_count'] = Db::name('shop_order')->where('order_status',1)->count('order_id');
        //待售后
        $count['wait_service_count'] = Db::name('shop_order_service')->where('status',1)->count('service_id');
        //预警
        $goods_stock_warning = getUsersConfigData('goods.goods_stock_warning');
        $where['arcrank'] = 0;
        $where['status'] = 1;
        $where['is_del'] = 0;
        $where['channel'] = 2;
        $count['warming_count'] = Db::name('archives')->where($where)->where('stock_count','elt',$goods_stock_warning)->count('aid');
        $this->assign('count', $count);

        $html = $this->display('mbackend/index');
        return $this->fetch($html);
    }

    public function ajax_change_time($time = 'month')
    {
        if (IS_AJAX_POST){
            $time = input('post.time/s');
        }
        if ('total' == $time){
            $count['order_count'] = Db::name('shop_order')->where('order_status','in',[1,2,3])->count('order_id');
            $count['order_amount_count'] = Db::name('shop_order')->where('order_status','in',[1,2,3])->sum('order_amount');
            $count['new_user_count'] = Db::name('users')->where('is_del',0)->count('users_id');
            $count['click_count'] = Db::name('archives')->sum('click');
        }else{
            $count['order_count'] = Db::name('shop_order')->where('order_status','in',[1,2,3])->whereTime('pay_time',$time)->count('order_id');
            $count['order_amount_count'] = Db::name('shop_order')->where('order_status','in',[1,2,3])->whereTime('pay_time',$time)->sum('order_amount');
            $count['new_user_count'] = Db::name('users')->where('is_del',0)->whereTime('reg_time','month')->count('users_id');
            $count['click_count'] = Db::name('arc_click')->sum($time);
        }
        if (IS_AJAX_POST){
            $this->success('success','',$count);
        }else{
            return $count;
        }
    }

    public function config()
    {
        if (IS_AJAX_POST) {
            $post = input('post.');
            $post['loginMode'] = empty($post['loginMode']) ? [] : $post['loginMode'];
            $this->saveConfig(['status'=>intval($post['status']), 'loginMode'=>$post['loginMode']], true);
        }

        // 生成手机后台首页二维码
        $this->createMbackendQrCode();

        $html = $this->display('mbackend/config');
        return $this->fetch($html);
    }

    // 生成手机后台首页二维码
    private function createMbackendQrCode()
    {
        // 核销处理方法
        $url = weapp_url('Mbackend/Mbackend/index', [], true, true);
        $this->assign('url', $url);
        // 二维码图片完整目录
        $path = UPLOAD_PATH . 'system/qrcode/mbackend/';
        // 二维码图片完整链接
        $links = $path . md5($url) . '.png';
        if (file_exists($links)) {
            $this->assign('qrCode', handle_subdir_pic(get_default_pic('/' . $links, true)));
        } else {
            // 如果存在则删除文件夹
            is_dir($path) && @delFile($path);
            // 创建文件夹
            @mkdir($path, 0777, true);
            // 生成二维码
            vendor('wechatpay.phpqrcode.phpqrcode');
            $qrcode = new \QRcode;
            $qrcode->png($url, $links);
            $this->assign('qrCode', handle_subdir_pic(get_default_pic('/' . $links, true)));
        }
    }

    // 保存配置
    private function saveConfig($data = [], $return = true)
    {
        $this->data = array_merge($this->data, $data);
        $update = [
            'data' => serialize($this->data),
            'update_time' => getTime()
        ];
        $result = Db::name('weapp')->where('code', 'Mbackend')->update($update);
        if (!empty($return)) {
            if (!empty($result)) {
                $this->success('保存成功');
            } else {
                $this->error('保存失败');
            }
        }
    }
}
