<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace weapp\DealerPlugin\logic;

use think\Db;
use think\Config;

/**
 * 业务逻辑
 */
class DealerPluginLogic
{
    // 添加会员表字段处理
    public function addUsersTableHandle($prefix = '')
    {
        if (!empty($prefix)) {
            // 订单表字段
            $usersTableField = Db::query("SHOW COLUMNS FROM {$prefix}users");
            $usersTableField = get_arr_column($usersTableField, 'Field');

            // 会员是否成为分销商
            if (!empty($usersTableField) && !in_array('is_dealer', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` ADD COLUMN `is_dealer`  tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '会员是否成为分销商(0:未成为分销商; 1:已成为分销商;)' AFTER `frozen_money`";
                @Db::execute($sql);
            }
            // 上级分销商会员ID
            if (!empty($usersTableField) && !in_array('parent_users_id', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` ADD COLUMN `parent_users_id`  int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级分销商会员ID' AFTER `is_dealer`";
                @Db::execute($sql);
            }
            // 上级分销商ID
            if (!empty($usersTableField) && !in_array('parent_dealer_id', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` ADD COLUMN `parent_dealer_id`  int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级分销商ID' AFTER `parent_users_id`";
                @Db::execute($sql);
            }
            // 顶级分销商会员ID
            if (!empty($usersTableField) && !in_array('top_users_id', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` ADD COLUMN `top_users_id`  int(11) unsigned NOT NULL DEFAULT '0' COMMENT '顶级分销商会员ID' AFTER `parent_dealer_id`";
                @Db::execute($sql);
            }
            // 顶级分销商ID
            if (!empty($usersTableField) && !in_array('top_dealer_id', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` ADD COLUMN `top_dealer_id`  int(11) unsigned NOT NULL DEFAULT '0' COMMENT '顶级分销商ID' AFTER `top_users_id`";
                @Db::execute($sql);
            }
            // 是否分销订单
            if (!empty($usersTableField) && !in_array('bind_dealer_time', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` ADD COLUMN `bind_dealer_time`  int(11) unsigned NOT NULL DEFAULT '0' COMMENT '绑定分销商的时间' AFTER `top_dealer_id`";
                @Db::execute($sql);
            }

            schemaTable('users');
        }
    }

    // 添加文档表字段处理
    public function addArchivesTableHandle($prefix = '')
    {
        if (!empty($prefix)) {
            // 订单表字段
            $archivesTableField = Db::query("SHOW COLUMNS FROM {$prefix}archives");
            $archivesTableField = get_arr_column($archivesTableField, 'Field');

            // 商品是否参与分销
            if (!empty($archivesTableField) && !in_array('dealer_goods', $archivesTableField)) {
                $sql = "ALTER TABLE `{$prefix}archives` ADD COLUMN `dealer_goods`  tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商品是否参与分销(0:未参与; 1:已参与;)' AFTER `channel`";
                @Db::execute($sql);
            }

            schemaTable('archives');
        }
    }

    // 添加订单表字段处理
    public function addShopOrderTableHandle($prefix = '')
    {
        if (!empty($prefix)) {
            // 订单表字段
            $shopOrderTableField = Db::query("SHOW COLUMNS FROM {$prefix}shop_order");
            $shopOrderTableField = get_arr_column($shopOrderTableField, 'Field');

            // 订单结算分佣的分销商ID
            if (!empty($shopOrderTableField) && !in_array('dealer_id', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` ADD COLUMN `dealer_id`  int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单结算分佣的分销商ID(同 weapp_dealer 表 dealer_id)' AFTER `users_id`";
                @Db::execute($sql);
            }
            // 订单结算分佣的分销商会员ID
            if (!empty($shopOrderTableField) && !in_array('dealer_users_id', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` ADD COLUMN `dealer_users_id`  int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单结算分佣的分销商会员ID(同 users 表 users_id)' AFTER `dealer_id`";
                @Db::execute($sql);
            }
            // 是否分销订单
            if (!empty($shopOrderTableField) && !in_array('dealer_order', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` ADD COLUMN `dealer_order`  tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否分销订单(0:否; 1:是;)' AFTER `dealer_users_id`";
                @Db::execute($sql);
            }
            // 分销商佣金计算方式
            if (!empty($shopOrderTableField) && !in_array('dealer_rebate', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` ADD COLUMN `dealer_rebate`  tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '分销商佣金计算方式(1:订单商品合计总额; 2:订单实际支付总额;)' AFTER `dealer_order`";
                @Db::execute($sql);
            }
            // 是否已进行结算分佣
            if (!empty($shopOrderTableField) && !in_array('handle_rebate', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` ADD COLUMN `handle_rebate`  tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已进行结算分佣(0:未结算分佣; 1:已结算分佣;)' AFTER `dealer_rebate`";
                @Db::execute($sql);
            }
            // 结算分佣时一级佣金比例
            if (!empty($shopOrderTableField) && !in_array('one_level_rebate', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` ADD COLUMN `one_level_rebate`  varchar(20) NOT NULL DEFAULT '' COMMENT '结算分佣时一级佣金比例' AFTER `handle_rebate`";
                @Db::execute($sql);
            }
            // 结算分佣时二级佣金比例
            if (!empty($shopOrderTableField) && !in_array('two_level_rebate', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` ADD COLUMN `two_level_rebate`  varchar(20) NOT NULL DEFAULT '' COMMENT '结算分佣时二级佣金比例' AFTER `one_level_rebate`";
                @Db::execute($sql);
            }

            schemaTable('shop_order');
        }
    }

    // 删除会员表字段处理
    public function delUsersTableHandle($prefix = '')
    {
        if (!empty($prefix)) {
            // 订单表字段
            $usersTableField = Db::query("SHOW COLUMNS FROM {$prefix}users");
            $usersTableField = get_arr_column($usersTableField, 'Field');

            // 会员是否成为分销商
            if (!empty($usersTableField) && in_array('is_dealer', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` DROP COLUMN `is_dealer`";
                @Db::execute($sql);
            }
            // 上级分销商会员ID
            if (!empty($usersTableField) && in_array('parent_users_id', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` DROP COLUMN `parent_users_id`";
                @Db::execute($sql);
            }
            // 上级分销商ID
            if (!empty($usersTableField) && in_array('parent_dealer_id', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` DROP COLUMN `parent_dealer_id`";
                @Db::execute($sql);
            }
            // 顶级分销商会员ID
            if (!empty($usersTableField) && in_array('top_users_id', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` DROP COLUMN `top_users_id`";
                @Db::execute($sql);
            }
            // 顶级分销商ID
            if (!empty($usersTableField) && in_array('top_dealer_id', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` DROP COLUMN `top_dealer_id`";
                @Db::execute($sql);
            }
            // 是否分销订单
            if (!empty($usersTableField) && in_array('bind_dealer_time', $usersTableField)) {
                $sql = "ALTER TABLE `{$prefix}users` DROP COLUMN `bind_dealer_time`";
                @Db::execute($sql);
            }

            schemaTable('users');
        }
    }

    // 删除文档表字段处理
    public function delArchivesTableHandle($prefix = '')
    {
        if (!empty($prefix)) {
            // 订单表字段
            $archivesTableField = Db::query("SHOW COLUMNS FROM {$prefix}archives");
            $archivesTableField = get_arr_column($archivesTableField, 'Field');

            // 商品是否参与分销
            if (!empty($archivesTableField) && in_array('dealer_goods', $archivesTableField)) {
                $sql = "ALTER TABLE `{$prefix}archives` DROP COLUMN `dealer_goods`";
                @Db::execute($sql);
            }

            schemaTable('archives');
        }
    }

    // 删除订单表字段处理
    public function delShopOrderTableHandle($prefix = '')
    {
        if (!empty($prefix)) {
            // 订单表字段
            $shopOrderTableField = Db::query("SHOW COLUMNS FROM {$prefix}shop_order");
            $shopOrderTableField = get_arr_column($shopOrderTableField, 'Field');

            // 订单结算分佣的分销商ID
            if (!empty($shopOrderTableField) && in_array('dealer_id', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` DROP COLUMN `dealer_id`";
                @Db::execute($sql);
            }
            // 订单结算分佣的分销商会员ID
            if (!empty($shopOrderTableField) && in_array('dealer_users_id', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` DROP COLUMN `dealer_users_id`";
                @Db::execute($sql);
            }
            // 是否分销订单
            if (!empty($shopOrderTableField) && in_array('dealer_order', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` DROP COLUMN `dealer_order`";
                @Db::execute($sql);
            }
            // 分销商佣金计算方式
            if (!empty($shopOrderTableField) && in_array('dealer_rebate', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` DROP COLUMN `dealer_rebate`";
                @Db::execute($sql);
            }
            // 是否已进行结算分佣
            if (!empty($shopOrderTableField) && in_array('handle_rebate', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` DROP COLUMN `handle_rebate`";
                @Db::execute($sql);
            }
            // 结算分佣时一级佣金比例
            if (!empty($shopOrderTableField) && in_array('one_level_rebate', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` DROP COLUMN `one_level_rebate`";
                @Db::execute($sql);
            }
            // 结算分佣时二级佣金比例
            if (!empty($shopOrderTableField) && in_array('two_level_rebate', $shopOrderTableField)) {
                $sql = "ALTER TABLE `{$prefix}shop_order` DROP COLUMN `two_level_rebate`";
                @Db::execute($sql);
            }

            schemaTable('shop_order');
        }
    }

    // 删除分销商设置
    public function delDealerConfigHandle()
    {
        // 删除分销商设置
        $where = [
            'inc_type' => 'dealer'
        ];
        Db::name('users_config')->where($where)->delete(true);

        // 清除缓存
        $systemController = new \app\admin\controller\System;
        $systemController->clearSystemCache();
    }

    // 检测是否存在系统分销商，如果不存在则添加系统分销商并将无归属的分销商进行归属
    public function systemDealerHandle()
    {
        // 查询是否存在系统分销商
        $where = [
            'system_dealer' => 1,
        ];
        $systemDealer = Db::name('weapp_dealer')->where($where)->find();
        // 如果不存在则添加系统分销商
        if (empty($systemDealer)) {
            // 查询系统创始人
            $where = [
                'role_id' => -1,
                'parent_id' => 0,
            ];
            $admin = Db::name('admin')->where($where)->find();
            // 添加系统分销商
            $systemDealer = [
                'users_id' => 99999999,
                'dealer_name' => !empty($admin['user_name']) ? trim($admin['user_name']) : '系统分销商',
                'dealer_mobile' => !empty($admin['mobile']) ? trim($admin['mobile']) : '',
                'dealer_status' => 1,
                'dealer_money' => 0,
                'freeze_money' => 0,
                'withdraw_money' => 0,
                'system_dealer' => 1,
                'add_time' => getTime(),
                'update_time' => getTime(),
            ];
            $dealer_id = Db::name('weapp_dealer')->insert($systemDealer);
            if (!empty($dealer_id)) $systemDealer['dealer_id'] = $dealer_id;
        }
    }
    
}
