/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : eyoucms_develop

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2018-09-13 14:30:27
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for #@__weapp_dealer
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_dealer`;
CREATE TABLE `#@__weapp_dealer` (
  `dealer_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商会员ID(同 users 表 users_id)',
  `dealer_name` varchar(30) NOT NULL DEFAULT '' COMMENT '分销商的真实姓名',
  `dealer_mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '分销商的手机号',
  `dealer_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '分销商状态(1:正常; 2:冻结;)',
  `dealer_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分销商佣金总额(可用提现总额)',
  `freeze_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分销商冻结总额(申请提现总额)',
  `withdraw_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分销商提现总额(成功提现总额)',
  `system_dealer` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否系统分销商(0:用户分销商; 1:系统分销商;)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`dealer_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='分销商信息';

-- ----------------------------
-- Table structure for #@__weapp_dealer_apply
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_dealer_apply`;
CREATE TABLE `#@__weapp_dealer_apply` (
  `apply_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商会员ID(同 users 表 users_id)',
  `dealer_name` varchar(30) NOT NULL DEFAULT '' COMMENT '分销商的真实姓名',
  `dealer_mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '分销商的手机号',
  `apply_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '申请方式(0:后台审核; 1:无需审核;)',
  `apply_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `review_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '审核状态(1:等待审核; 2:审核通过; 3:审核驳回(可重新申请); 4:拉黑(不允许再申请);)',
  `review_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '审核时间',
  `review_reason` varchar(500) NOT NULL DEFAULT '' COMMENT '审核原因',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`apply_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='分销商申请';

-- ----------------------------
-- Table structure for #@__weapp_dealer_withdraw
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_dealer_withdraw`;
CREATE TABLE `#@__weapp_dealer_withdraw` (
  `withdraw_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商会员ID(同 users 表 users_id)',
  `dealer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商ID(同 weapp_dealer 表 dealer_id)',
  `withdraw_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '提现金额',
  `withdraw_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '提现方式 (1余额 2微信)',
  `withdraw_order` varchar(30) NOT NULL DEFAULT '' COMMENT '系统本身提现订单号',
  `review_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '审核状态(1:等待审核; 2:审核通过; 3:审核驳回; 4:提现成功(已打款到指定账户);)',
  `review_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '审核时间',
  `review_reason` varchar(500) NOT NULL DEFAULT '' COMMENT '审核原因',
  `wechat_order` varchar(50) NOT NULL DEFAULT '' COMMENT '微信返回的支付订单号',
  `wechat_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '微信返回的支付时间',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`withdraw_id`),
  KEY `users_id` (`users_id`),
  KEY `dealer_id` (`dealer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='分销商提现';

-- ----------------------------
-- Table structure for #@__weapp_dealer_money_log
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_dealer_money_log`;
CREATE TABLE `#@__weapp_dealer_money_log` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商会员ID(同 users 表 users_id)',
  `dealer_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商ID(同 weapp_dealer 表 dealer_id)',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商订单ID(log_type=1结算增加时存入)',
  `withdraw_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分销商提现ID(log_type=2提现减少时存入)',
  `log_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '记录类型(1:结算增加; 2:提现减少;)',
  `log_before_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '记录本次操作前的分销商佣金',
  `log_action_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '记录本次操作的分销商佣金',
  `log_after_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '记录本次操作后的分销商佣金',
  `log_note` varchar(500) NOT NULL DEFAULT '' COMMENT '记录说明',
  `log_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '分销商佣金记录是否显示(1:显示; 2:不显示;)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`log_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `dealer_id` (`dealer_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `withdraw_id` (`withdraw_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='分销商佣金操作记录';