<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-06-28
 */

namespace weapp\DealerPlugin\controller;

use think\Page;
use think\Db;
use app\common\controller\Weapp;
use weapp\DealerPlugin\model\DealerPluginModel;
use weapp\DealerPlugin\logic\DealerPluginLogic;

/**
 * 插件的控制器
 */
class DealerPlugin extends Weapp
{
    /**
     * 构造方法
     */
    public function __construct() {
        parent::__construct();
        // 模型层
        $this->dealerModel = new DealerPluginModel;
        // 逻辑层
        $this->dealerLogic = new DealerPluginLogic;
        // 插件基本信息
        $this->weappInfo = $this->getWeappInfo();
        $this->assign('weappInfo', $this->weappInfo);
    }

    // 插件安装的后置操作
    public function afterInstall()
    {
        if (!empty($this->weappInfo)) {
            // 数据前缀
            $prefix = config('database.prefix');
            // 会员表字段处理
            $this->dealerLogic->addUsersTableHandle($prefix);
            // 文档表字段处理
            $this->dealerLogic->addArchivesTableHandle($prefix);
            // 订单表字段处理
            $this->dealerLogic->addShopOrderTableHandle($prefix);
        }
    }

    // 插件卸载的后置操作
    public function afterUninstall()
    {
        if (!empty($this->weappInfo)) {
            // 数据前缀
            $prefix = config('database.prefix');
            // 会员表字段处理
            $this->dealerLogic->delUsersTableHandle($prefix);
            // 文档表字段处理
            $this->dealerLogic->delArchivesTableHandle($prefix);
            // 订单表字段处理
            $this->dealerLogic->delShopOrderTableHandle($prefix);
            // 删除分销商设置
            $this->dealerLogic->delDealerConfigHandle();
        }
    }

    // 插件默认入口
    public function index()
    {
        // 检测是否存在系统分销商，如果不存在则添加系统分销商并将无归属的分销商进行归属
        $this->dealerLogic->systemDealerHandle();

        // 重定向到分销商概况
        $this->redirect(weapp_url('DealerPlugin/DealerPlugin/dealer_summary'));
    }

    // 分销商概况
    public function dealer_summary()
    {
        $result = $this->dealerModel->getDealerSummary();
        $this->assign($result);
        return $this->fetch('dealer_summary');
    }

    // 分销商设置
    public function dealer_config()
    {
        $dealerConfig = getUsersConfigData('dealer');

        if (IS_AJAX_POST) {
            // 接收配置信息
            $postDealer = input('post.dealer/a', []);
            // 判断配置信息
            if (empty($postDealer['dealer_level'])) $this->error('请选择分销商层级');
            if (empty($postDealer['dealer_rebate'])) $this->error('请选择佣金计算方式');
            if (empty($postDealer['dealer_settlement'])) $this->error('请选择佣金结算方式');
            // if (empty($postDealer['dealer_one_level_rebate'])) $this->error('请填写一级佣金比例');
            // if (empty($postDealer['dealer_two_level_rebate'])) $this->error('请填写二级佣金比例');
            // 保存配置信息
            getUsersConfigData('dealer', $postDealer);

            // 根据配置执行操作
            if (!empty($postDealer['dealer_open']) && 1 === intval($postDealer['dealer_open'])) {
                // 更新分销商层级后续操作
                if (!empty($dealerConfig['dealer_level']) && !empty($postDealer['dealer_level'])) {
                    // 二级分销商模式 更新为 一级分销商模式 则执行 冻结所有二级分销商所有分销能力
                    if (1 === intval($postDealer['dealer_level']) && intval($dealerConfig['dealer_level']) !== intval($postDealer['dealer_level'])) {
                        $this->dealerModel->updateDealerAbility($postDealer['dealer_level']);
                    }
                    // 一级分销商模式 更新为 二级分销商模式 则执行 恢复所有二级分销商所有分销能力
                    else if (2 === intval($postDealer['dealer_level']) && intval($dealerConfig['dealer_level']) !== intval($postDealer['dealer_level'])) {
                        $this->dealerModel->updateDealerAbility($postDealer['dealer_level']);
                    }
                }

                // 更新分销商佣金结算方式后续操作
                if (!empty($dealerConfig['dealer_settlement']) && !empty($postDealer['dealer_settlement'])) {
                    if (2 === intval($postDealer['dealer_level']) && 1 === intval($postDealer['dealer_settlement'])) {
                        // 立即结算分销商订单
                        $this->dealerModel->settlementDealerOrder($postDealer);
                    }
                }
            }

            $this->success('保存成功');
        }

        $this->assign('dealerConfig', $dealerConfig);
        return $this->fetch('dealer_config');
    }

    // 分销商管理
    public function dealer_index()
    {
        // 获取分销商列表数据
        $result = $this->dealerModel->getDealerIndexList();
        $this->assign($result);

        // 分销设置
        $dealerConfig = getUsersConfigData('dealer');
        $this->assign('dealerConfig', $dealerConfig);

        return $this->fetch('dealer_index');
    }

    // 分销商状态处理(冻结/解冻)
    public function dealer_status()
    {
        if (IS_AJAX_POST) {
            $post = input('post.');
            // 基础判断
            if (empty($post['dealer_id'])) $this->error('请选择分销商');

            // 审核分销商申请
            $resultID = $this->dealerModel->dealerStatusHandle($post);

            // 更新后续操作
            if (!empty($resultID)) {
                $this->success('操作成功');
            } else {
                $this->error('操作失败');
            }
        }
    }

    // 分销商申请列表
    public function dealer_apply()
    {
        // 获取分销商申请列表数据
        $result = $this->dealerModel->getDealerApplyList();
        $this->assign($result);

        return $this->fetch('dealer_apply');
    }

    // 分销商申请审核
    public function dealer_apply_review()
    {
        if (IS_AJAX_POST) {
            $post = input('post.');
            // 基础判断
            if (empty($post['apply_id'])) $this->error('请选择分销商');
            if (empty($post['review_status'])) $this->error('请选择审核建议');
            if (empty($post['review_reason']) && 3 == $post['review_status']) $this->error('请填写拒绝原因');

            // 审核分销商申请
            $resultID = $this->dealerModel->reviewDealerApply($post);

            // 更新后续操作
            if (!empty($resultID)) {
                $this->success('操作成功');
            } else {
                $this->error('操作失败');
            }
        }
    }

    // 分销商下级列表
    public function dealer_subordinate()
    {
        // 分销商ID
        $users_id = input('param.users_id/d', 0);
        $this->assign('users_id', $users_id);
        if (empty($users_id)) $this->error('请选择分销商');

        // 获取分销商下级列表数据
        $result = $this->dealerModel->getDealerSubordinateList($users_id);
        $this->assign($result);

        // 分销设置
        $dealerConfig = getUsersConfigData('dealer');
        $this->assign('dealerConfig', $dealerConfig);
        return $this->fetch();
    }

    // 分销商客户列表
    public function dealer_customer()
    {
        // 分销商ID
        $users_id = input('param.users_id/d', 0);
        $this->assign('users_id', $users_id);
        if (empty($users_id)) $this->error('请选择分销商');

        // 获取分销商客户列表数据
        $result = $this->dealerModel->getDealerCustomerList($users_id);
        $this->assign($result);

        // 分销设置
        $dealerConfig = getUsersConfigData('dealer');
        $this->assign('dealerConfig', $dealerConfig);
        return $this->fetch();
    }

    // 分销订单
    public function dealer_order()
    {
        $dealer_id = input('dealer_id/d', 0);
        $this->assign('dealer_id', $dealer_id);

        // 获取分销商客户列表数据
        $result = $this->dealerModel->getDealerOrderList($dealer_id);
        $this->assign($result);

        return $this->fetch('dealer_order');
    }

    // 提现列表
    public function dealer_withdraw()
    {
        // 获取分销商提现列表数据
        $result = $this->dealerModel->getDealerWithdraw();
        $this->assign($result);
        return $this->fetch('dealer_withdraw');
    }

    // 分销商提现审核
    public function dealer_withdraw_review()
    {
        if (IS_AJAX_POST) {
            $post = input('post.');
            $this->dealerModel->reviewDealerWithdraw($post);
        }
        $this->error('非法操作');
    }
}