<?php

namespace weapp\DealerPlugin\behavior\plugins;

use think\Db;

load_trait('controller/Jump');
class DealerPluginBehavior
{
    use \traits\controller\Jump;
    protected static $actionName;
    protected static $controllerName;
    protected static $moduleName;
    protected static $method;

    /**
     * 构造方法
     *
     * @param Request $request Request对象
     *
     * @access public
     */
    public function __construct()
    {
        ! isset(self::$moduleName) && self::$moduleName = request()->module();
        ! isset(self::$controllerName) && self::$controllerName = request()->controller();
        ! isset(self::$actionName) && self::$actionName = request()->action();
        ! isset(self::$method) && self::$method = strtoupper(request()->method());
    }

    /**
     * 模块初始化
     *
     * @param array $params 传入参数
     *
     * @access public
     */
    public function moduleInit(&$params)
    {
        if ('DealerPlugin' == self::$controllerName) {
            if (isMobile() && file_exists('./template/plugins/dealer_plugin/mobile/')) {
                !defined('THEME_STYLE') && define('THEME_STYLE', 'mobile'); // mobile端模板
            } else if (!isMobile() && !file_exists('./template/plugins/dealer_plugin/pc/') && file_exists('./template/plugins/dealer_plugin/mobile/')) {
                !defined('THEME_STYLE') && define('THEME_STYLE', 'mobile'); // mobile端模板
            } else {
                !defined('THEME_STYLE') && define('THEME_STYLE', 'pc'); // pc端模板
            }
        }
    }

    /**
     * 操作开始执行
     *
     * @param array $params 传入参数
     *
     * @access public
     */
    public function actionBegin(&$params)
    {
        
    }

    /**
     * 视图内容过滤
     *
     * @param array $params 传入参数
     *
     * @access public
     */
    public function viewFilter(&$params)
    {

    }

    /**
     * 应用结束
     *
     * @param array $params 传入参数
     *
     * @access public
     */
    public function appEnd(&$params)
    {

    }
}