/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : eyoucms_develop

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2018-09-13 14:30:27
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for #@__weapp_coupons
-- ----------------------------
DROP TABLE IF EXISTS `#@__weapp_coupons`;
CREATE TABLE `#@__weapp_coupons` (
  `coupon_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `coupon_code` varchar(100) DEFAULT '' COMMENT '优惠券编号',
  `coupon_name` varchar(100) DEFAULT '' COMMENT '优惠券名称',
  `coupon_color` varchar(25) DEFAULT '' COMMENT '优惠券颜色',
  `coupon_form` tinyint(1) DEFAULT '1' COMMENT '优惠券类型 1-满减券',
  `coupon_type` tinyint(1) unsigned DEFAULT '1' COMMENT '可使用商品(1全站通用，2指定商品，3指定商品分类)',
  `product_id` varchar(255) DEFAULT '' COMMENT '指定商品ID，在coupon_type=2时使用',
  `arctype_id` varchar(255) DEFAULT '' COMMENT '指定商品分类ID，在coupon_type=3时使用',
  `coupon_price` decimal(10,0) DEFAULT '0' COMMENT '优惠券金额，例如10',
  `coupon_discount` decimal(2,1) DEFAULT '0.0' COMMENT '优惠券折扣,范围0.1-9.9',
  `conditions_use` decimal(10,2) DEFAULT '0.00' COMMENT '优惠券使用条件，例如300',
  `coupon_stock` int(11) unsigned DEFAULT '0' COMMENT '优惠券库存，例如100',
  `coupon_intro` varchar(1000) DEFAULT '' COMMENT '优惠券说明',
  `redeem_authority` varchar(255) DEFAULT '' COMMENT '兑换权限，存入多个会员等级组ID',
  `valid_days` int(11) unsigned DEFAULT '0' COMMENT '有效天数，例如30',
  `start_date` int(11) unsigned DEFAULT '0' COMMENT '优惠券开放领取时间',
  `end_date` int(11) unsigned DEFAULT '0' COMMENT '优惠券结束领取时间',
  `sort_order` int(11) unsigned DEFAULT '100' COMMENT '规格排序号',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '优惠券状态(0=关闭，1=开启)',
  `use_type` int(1) DEFAULT '1' COMMENT '使用期限 \r\n1-固定日期\r\n 2-领取后当天开始N(valid_days)天内有效\r\n 2-领取后次日开始N(valid_days)天内有效',
  `use_limit` tinyint(3) DEFAULT '0' COMMENT '优惠使用限制,0-不限制,1-不可与会员折扣同时使用',
  `use_limit_num` mediumint(8) DEFAULT '0' COMMENT '每人领取张数,0-不限制',
  `use_start_time` int(11) DEFAULT NULL COMMENT '使用期限开始时间',
  `use_end_time` int(11) DEFAULT NULL COMMENT '使用期限结束时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '0-未删除 1-已删除',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`coupon_id`),
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `arctype_id` (`arctype_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='优惠券主表';

DROP TABLE IF EXISTS `#@__weapp_coupons_use`;
CREATE TABLE `#@__weapp_coupons_use` (
  `use_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `get_ip` varchar(15) DEFAULT '' COMMENT '领取时的IP地址',
  `get_time` int(11) unsigned DEFAULT '0' COMMENT '优惠券领取时的时间',
  `use_status` tinyint(4) unsigned DEFAULT '1' COMMENT '优惠券使用状态(0未使用，1已使用，2已过期，3已冻结)',
  `use_time` int(11) unsigned DEFAULT '0' COMMENT '优惠券使用时的时间',
  `start_time` int(10) DEFAULT '0' COMMENT '优惠券有效开始时间',
  `end_time` int(10) DEFAULT '0' COMMENT '优惠券有效结束时间',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `source` tinyint(3) DEFAULT '1' COMMENT '1-前台领取 2-抽奖 3-后台发放',
  PRIMARY KEY (`use_id`),
  KEY `coupon_id` (`coupon_id`) USING BTREE,
  KEY `coupon_code` (`coupon_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='优惠券-领取记录表';