<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

use think\Model;
use think\Request;

/*
 * 素材管理接口实现
 */

class material extends base
{

    public function __construct($config)
    {
        parent::__construct($config);
    }

    /**
     * 新增临时素材
     */
    public function mediaUpload($filepath, $type = 'image')
    {
        /* 使用curl函数 */
        $url = "https://api.weixin.qq.com/cgi-bin/media/upload?access_token=" . $this->access_token . "&type=" . $type;
        $post_data = array(
            'media' => '@' . $filepath,
        );
        $response = $this->httpRequest($url, 'POST', $post_data);
        $params = array();
        $params = json_decode($response, true);
        if (isset($params['errcode'])) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        /* 使用exec函数 */
        // $command = 'curl -F media=@'.$filepath.' "https://api.weixin.qq.com/cgi-bin/media/upload?access_token='.$this->access_token.'&type='.$type.'"';

        // /* 使用exec函数 */
        // $retval = array();
        // exec($command, $retval, $status);
        // $params = array();
        // $params = json_decode($retval[0],true);
        // if ($status != 0) {
        //     $params = array(
        //         'errcode'   => '-100',
        //         'errmsg'    => '公众号服务出错，请联系管理员',
        //     );
        // }

        /* 使用system函数 */
        // $retval = 1;
        // $last_line = system($command, $retval);
        // $params = array();
        // $params = json_decode($last_line,true);
        // if ($retval != 0) {
        //     if (isset($params['errcode'])) {
        //         $params = array(
        //             'errcode'   => '-100',
        //             'errmsg'    => '公众号服务出错，请联系管理员',
        //         );
        //     }
        // }

        return $params;
    }

    /**
     * 新增永久素材
     * 图片仅支持bmp/png/jpeg/jpg/gif格式，大小必须在2MB以下
     */
    public function addMaterial($filepath, $type = 'image')
    {
        /* 使用curl函数 */
        $url = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=" . $this->access_token . "&type=" . $type;
        $post_data = array(
            'media' => '@' . $filepath,
        );
        $response = $this->httpRequest($url, 'POST', $post_data);
        $params = array();
        $params = json_decode($response, true);
        if (isset($params['errcode'])) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        return $params;
    }

    /**
     * 新建草稿
     */
    public function addNews($data = array())
    {
        $post_data = array(
            'articles' => $data,
        );
        $url = "https://api.weixin.qq.com/cgi-bin/draft/add?access_token=" . $this->access_token;
        $response = $this->httpRequest($url, 'POST', json_encode($post_data, JSON_UNESCAPED_UNICODE));
        $params = json_decode($response, true);
        if (isset($params['errcode'])) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        return $params;
    }

    /**
     * 删除草稿
     */
    public function delNews($media_id = 0)
    {
        $url = "https://api.weixin.qq.com/cgi-bin/draft/delete?access_token=" . $this->access_token;
        $post_data = array(
            'media_id' => $media_id,
        );
        $response = $this->httpRequest($url, 'POST', json_encode($post_data, JSON_UNESCAPED_UNICODE));
        $params = array();
        $params = json_decode($response, true);
        if ($params['errcode'] != 0) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        return $params;
    }

    /**
     * 发布草稿
     */
    public function submitDraff($media_id = 0)
    {
        $url = "https://api.weixin.qq.com/cgi-bin/freepublish/submit?access_token=" . $this->access_token;
        $post_data = array(
            'media_id' => $media_id,
        );
        $response = $this->httpRequest($url, 'POST', json_encode($post_data, JSON_UNESCAPED_UNICODE));
        $params = json_decode($response, true);
        if ($params['errcode'] != 0) {
            //写入失败原因
            M('gzh_material')->where('media_id',$media_id)->update(['errmsg'=>$params['errmsg'],'update_time'=>getTime(),'publish_status'=>3]);
        }else{
            M('gzh_material')->where('media_id',$media_id)->update(['publish_id'=>$params['publish_id'],'update_time'=>getTime()]);
        }

        return $params;
    }

    /**
     * 发布状态轮询接口
     */
    public function publishGet($publish_id = 0)
    {
        if (empty($publish_id)) return true;
        $url = "https://api.weixin.qq.com/cgi-bin/freepublish/get?access_token=" . $this->access_token;
        $post_data = array(
            'publish_id' => $publish_id,
        );
        $response = $this->httpRequest($url, 'POST', json_encode($post_data, JSON_UNESCAPED_UNICODE));
        $return_info = json_decode($response, true);
        $update['update_time'] = getTime();
        $update['publish_status'] = $return_info['publish_status'];
        if ($return_info['publish_status'] == 0) {
            if (empty($return_info['publish_status'])){
                $update['article_id'] = $return_info['article_id'];
                $list = M('gzh_material')->where('publish_id',$return_info['publish_id'])->order('parent_id asc,id asc')->select();
                foreach ($return_info['article_detail'] as $k => $v){
                    M('gzh_material')->where('id',$list[$v['idx']-1]['id'])->update(['article_url'=>$v['article_url'],'update_time'=>getTime()]);
                }
            }else{
                if (!empty($return_info['fail_idx'])){
                    $fail_idx = implode(',',$return_info['fail_idx']);
                }
                $update['errmsg'] = "第{$fail_idx}篇文章发布失败";
            }
        }

        M('gzh_material')->where('publish_id',$publish_id)->update($update);

        return $update;
    }

    /**
     * 通过 article_id 获取已发布文章
     */
    public function getarticle($article_id  = 0)
    {
        $url = "https://api.weixin.qq.com/cgi-bin/freepublish/getarticle?access_token=" . $this->access_token;
        $post_data = array(
            'article_id' => $article_id,
        );
        $response = $this->httpRequest($url, 'POST', json_encode($post_data, JSON_UNESCAPED_UNICODE));
        $params = json_decode($response, true);
        // file_put_contents ( ROOT_PATH."/hln-log.txt", date ( "Y-m-d H:i:s" ) . "  " . var_export($params,true) . "\r\n", FILE_APPEND );

        return $params;
    }

    /**
     * 上传图文消息内的图片获取URL【订阅号与服务号认证后均可用】
     * 图片仅支持jpg/png格式，大小必须在1MB以下
     */
    public function uploadimg($filepath)
    {
        /* 使用curl函数 */
        $url = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=" . $this->access_token;
        $post_data = array(
            'media' => '@' . $filepath,
        );
        $response = $this->httpRequest($url, 'POST', $post_data);
        $params = array();
        $params = json_decode($response, true);
        if (isset($params['errcode'])) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        return $params;
    }

    /**
     * 获取临时素材
     */
    public function getTmpMaterial($media_id)
    {
        /* 使用curl函数 */
        $url = "https://api.weixin.qq.com/cgi-bin/media/get?access_token=" . $this->access_token . "&media_id=" . $media_id;
        $response = $this->httpRequest($url, 'GET');
        $params = array();
        $params = json_decode($response, true);
        if (isset($params['errcode'])) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        // $command = 'curl -I -G "https://api.weixin.qq.com/cgi-bin/media/get?access_token='.$this->access_token.'&media_id="'.$media_id;

        // /* 使用exec函数 */
        // $retval = array();
        // exec($command, $retval, $status);
        // $params = array();
        // $params = json_decode($retval[0],true);
        // if ($status != 0) {
        //     $params = array(
        //         'errcode'   => '-100',
        //         'errmsg'    => '公众号服务出错，请联系管理员',
        //     );
        // }

        return $params;
    }

    /**
     * 获取永久素材
     */
    public function getMaterial($media_id)
    {
        $url = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=" . $this->access_token;
        $post_data = array(
            'media_id' => $media_id,
        );
        $response = $this->httpRequest($url, 'POST', json_encode($post_data, JSON_UNESCAPED_UNICODE));
        $params = array();
        $params = json_decode($response, true);
        if (isset($params['errcode'])) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        return $params;
    }

    /**
     * 删除永久素材
     */
    public function delMaterial($media_id)
    {
        $url = "https://api.weixin.qq.com/cgi-bin/material/del_material?access_token=" . $this->access_token;
        $post_data = array(
            'media_id' => $media_id,
        );
        $response = $this->httpRequest($url, 'POST', json_encode($post_data, JSON_UNESCAPED_UNICODE));
        $params = array();
        $params = json_decode($response, true);
        if ($params['errcode'] != 0) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        return $params;
    }

    /**
     * 修改永久图文素材
     */
    public function updateNews($post_data = array())
    {
        $url = "https://api.weixin.qq.com/cgi-bin/material/update_news?access_token=" . $this->access_token;
        $response = $this->httpRequest($url, 'POST', json_encode($post_data, JSON_UNESCAPED_UNICODE));
        $params = array();
        $params = json_decode($response, true);
        if ($params['errcode'] != 0) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        return $params;
    }

    /**
     * 获取素材总数
     */
    public function getMaterialcount($post_data = array())
    {
        $url = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token=" . $this->access_token;
        $response = $this->httpRequest($url);
        $params = array();
        $params = json_decode($response, true);
        if (isset($params['errcode'])) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        return $params;
    }

    /**
     * 获取素材列表
     */
    public function batchgetMaterial($post_data = array())
    {
        $url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=" . $this->access_token;
        $response = $this->httpRequest($url, 'POST', json_encode($post_data, JSON_UNESCAPED_UNICODE));
        $params = array();
        $params = json_decode($response, true);
        if ($params['errcode'] != 0) {
            $errmsg = isset($this->codeArr[$params['errcode']]) ? $this->codeArr[$params['errcode']] : $params['errmsg'];
            echo "<h3>error:</h3>" . $params['errcode'];
            echo "<h3>msg  :</h3>" . $errmsg;
            exit;
        }

        return $params;
    }
}