console.log(resultArr);
console.log(json627847);

var pointsShop = 1;

$(function() {
    // 自动加载默认物流方式
    if (true === resultArr.pointsGoods.onlyVerify) {
        $('#selectVerify').click();
    } else {
        $('#selectDelivery').click();
    }

    // 头像框移入移出事件
    $(".user-photo").mouseover(function(){
       $(".user-drop").show();
    });
    $(".user-photo").mouseout(function(){
       $(".user-drop").hide();
    });

    // 收货地址更多
    if ($('#address-list-all div.address-item').length > 4) {
        $('#address-list-all #addressShowHide').show();
    } else {
        $('#address-list-all #addressShowHide').hide();
    }
    $('#addressShowHide').click(function() {
        var showhide = $(this).attr('data-showhide');
        if ('hide' == showhide) {
            $('#address-list-all div.address-item').each(function(index, item) {
                if (index > 3) $(item).show();
            });
            $(this).attr('data-showhide', 'show');
            $(this).find('span').html('收起更多地址<i class="iconfont-normal"></i>');
        } else {
            $('#address-list-all div.address-item').each(function(index, item) {
                if (index > 3) $(item).hide();
            });
            $(this).attr('data-showhide', 'hide');
            $(this).find('span').html('显示更多地址<i class="iconfont-normal"></i>');
        }
    });
});

// 选择配送方式
function selectLogisticsType(logisticsType) {
    if (!logisticsType) {
        showErrorAlert('非法操作');
        return false;
    }
    resultArr.logistics.logistics_type = logisticsType;
    // 快递配送
    if (1 === parseInt(logisticsType)) {
        $("#selectDelivery").addClass('on active');
        $("#selectDeliveryID").css('display', '');
        $("#selectDeliveryAddress").css('display', '');
        $("#selectVerify").removeClass('on active');
        $("#selectVerifyID").css('display', 'none');
        $("#selectVerifyInfo").css('display', 'none');
        // 运费计算逻辑
        selectAddress(resultArr.address.addr_id);
    }
    // 到店自提
    else if (2 === parseInt(logisticsType)) {
        if (0 < parseInt(resultArr.logistics.store_id)) {
            $("#selectVerifyInfo").css('display', '');
            if (0 === parseInt(json627847.is_wap)) $("#selectVerifyID").css('display', '');
        } else {
            $("#selectVerifyID").css('display', '');
        }
        $("#selectVerify").addClass('on active');
        $("#selectDelivery").removeClass('on active');
        $("#selectDeliveryID").css('display', 'none');
        $("#selectDeliveryAddress").css('display', 'none');
        // 运费、订单总价、支付剩余余额计算
        pointsOrderFreightCountLogic(0);
    }
}

var showWidth = 1 === parseInt(json627847.is_wap) ? '100%;' : '660px;';
var showHeight = 1 === parseInt(json627847.is_wap) ? '100%;' : '392px;';
// 添加收货地址
function addAddress() {
    event.stopPropagation();
    //iframe窗
    layer.open({
        type: 2,
        title: '添加收货地址',
        shadeClose: false,
        maxmin: false, //开启最大化最小化按钮
        area: [showWidth, showHeight],
        content: urlArr.shopAddAddress
    });
}

// 编辑收货地址
function editAddress(addrID) {
    event.stopPropagation();
    //iframe窗
    layer.open({
        type: 2,
        title: '添加收货地址',
        shadeClose: false,
        maxmin: false, //开启最大化最小化按钮
        area: [showWidth, showHeight],
        content: urlArr.shopEditAddress + '&addr_id=' + addrID,
    });
}

function delAddress(addrID) {
    event.stopPropagation();
    unifiedConfirmBox('确认删除收货地址？', '', '', function() {
        $.ajax({
            url : urlArr.shopDelAddress,
            data: {addr_id: addrID},
            type: 'post',
            dataType: 'json',
            success: function(res) {
                layer.closeAll();
                if (1 === parseInt(res.code)) {
                    showSuccessMsg(res.msg);
                    $("#address-list-" + addrID).remove();
                    if (4 >= parseInt($('#address-list-all div.address-item').length)) {
                        $('#addressShowHide').attr('data-showhide', 'hide').hide();
                        $('#address-list-all').find('div.address-item:last').show();
                    }
                } else {
                    showErrorAlert(res.msg);
                }
            },
            error: function (e) {
                layer.closeAll();
                showErrorAlert(e.responseText);
            }
        });
    });
}

// 选中收货地址
function selectAddress(addrID) {
    if (addrID) {
        // 设置选中效果
        $('#address-list-all .address-item').each(function() {
            if (this.id) $('#' + this.id).removeClass("selected");
        });
        $('#address-list-' + addrID).addClass("selected");

        // 查询运费
        var url = urlArr.shopInquiryShipping;
        $.ajax({
            url : url,
            data: {addr_id: addrID},
            type: 'post',
            dataType: 'json',
            success: function(res) {
                // 记录收货地址ID
                resultArr.address.addr_id = addrID;
                // 运费、订单总价、支付剩余余额计算
                pointsOrderFreightCountLogic(res.data);
            }
        });
    }
}

// 运费、订单总价、支付剩余余额计算
function pointsOrderFreightCountLogic(freight) {
    freight = 2 === parseInt(resultArr.pointsGoods.goods_shipping) ? 0 : freight;
    console.log(parseFloat(freight));
    // 运费
    $('#template_money').html(0 === parseFloat(freight) ? 0 : parseFloat(freight));
    
    // 计算总价+运费
    var amountNew = (Number(resultArr.pointsGoods.goodsSinglePrice) + Number(freight)).toFixed(2);
    $('#goodsTotalPrice').html(parseFloat(amountNew));
}

// 选择到店自提门店
function selectVerifyStore(confirm, obj) {
    if (confirm) {
        if (0 < parseInt($(obj).data('store_id'))) {
            resultArr.logistics.store_id = $(obj).data('store_id');
            $("#selectVerifyID").css('display', '');
            $("#selectVerifyInfo").css('display', '');
            $("#verify_store_name").html($(obj).data('store_name'));
            $("#verify_store_address").html($(obj).data('store_address'));
            $("#verify_prov_city_area").html($(obj).data('prov_city_area'));
            if (1 === parseInt(json627847.is_wap)) $("#selectVerifyID").css('display', 'none');
        } else {
            $("#verify_store_name").html('');
            $("#verify_store_address").html('');
            $("#verify_prov_city_area").html('');
            $("#selectVerifyID").css('display', '');
            $("#selectVerifyInfo").css('display', 'none');
        }
        layer.closeAll();
    } else {
        var area = ['1240px', '60%'];
        if (1 === parseInt(json627847.is_wap)) area = ['100%', '100%'];
        layer.open({
            type: 2,
            title: '选择门店',
            shadeClose: false,
            maxmin: false, //开启最大化最小化按钮
            area: area,
            content: urlArr.selectVerifyStore
        });
    }
}

function submitOrder() {
    var pay_type = 1;
    var payment_type = $('#payment_type').val();
    if (payment_type == 'yezf_balance') pay_type = 2;
    if (parseFloat(resultArr.pointsGoods.goodsTotalPrice) <= 0) pay_type = 3;
    let postData = {
        order_id: resultArr.order_id,
        order_code: resultArr.order_code,
        addr_id: resultArr.address.addr_id,
        store_id: resultArr.logistics.store_id,
        buyer: $('#buyer').val(),
        phone: $('#phone').val(),
        pay_type: pay_type,
        payment_type: payment_type,
        user_note: '',
        cacheKeys: resultArr.cacheKeys,
        prom_type: resultArr.pointsGoods.prom_type,
        logistics_type: resultArr.pointsGoods.logistics_type,
        verifyShow: 2 === parseInt(resultArr.logistics.logistics_type) ? 1 : 0,
        deliveryShow: 1 === parseInt(resultArr.logistics.logistics_type) ? 1 : 0,
    };
    layer_loading('<font id="loading_tips_230111">正在处理</font>');
    var timer = setTimeout(function() {
        $.ajax({
            url : urlArr.goodsBuySubmit,
            data: postData,
            type: 'post',
            dataType: 'json',
            success: function(res) {
                // 清理定时任务
                clearTimeout(timer);
                if (1 === parseInt(res.code)) {
                    resultArr.order_id = res.data.unified_id;
                    resultArr.order_code = res.data.unified_number;
                    if (1 === parseInt(pay_type)) {
                        SelectPayMethod_2(res.data.pay_id, res.data.pay_mark, res.data.unified_id, res.data.unified_number, res.data.transaction_type);
                    } else {
                        // if (res.data.email) eyUnifiedSendRemind(res.data.email);
                        // if (res.data.mobile) eyUnifiedSendRemind(res.data.mobile);
                        // layer.closeAll();
                        // showSuccessMsg(res.msg, function() {
                        //     window.location.href = urlArr.shopCentre;
                        // });
                        if (res.data.email) unifySendEmail(res.data.email);
                        if (res.data.mobile) unifySendMobile(res.data.mobile);
                        if (res.data.weChat) unifySendWeChat(res.data.weChat);
                        showSuccessMsg(res.msg, function() {
                            window.location.href = urlArr.shopCentre;
                        });
                    }
                } else {
                    layer.closeAll();
                    showErrorAlert(res.msg);
                }
            },
            error: function(e) {
                layer.closeAll();
                showErrorAlert(e.responseText);
            }
        });
    }, 100);
}

// 发送(短信、邮箱)提醒
function eyUnifiedSendRemind(result) {
    if (result) {
        $.ajax({
            url: result.url,
            data: result.data,
            type: 'post',
            dataType: 'json'
        });
    }
}